/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.codeStyle;

import java.util.BitSet;
import java.util.Iterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FList;
import org.jetbrains.kotlin.com.intellij.util.io.IOUtil;
import org.jetbrains.kotlin.com.intellij.util.text.Matcher;

public class MinusculeMatcher
implements Matcher {
    private final ThreadLocal<MatchingState> myMatchingState;
    private final char[] myPattern;
    private final String myHardSeparators;
    private final NameUtil.MatchingCaseSensitivity myOptions;
    private final boolean myHasHumps;
    private final boolean myHasSeparators;
    private final boolean myHasDots;
    private final boolean[] isLowerCase;
    private final boolean[] isUpperCase;
    private final boolean[] isWordSeparator;
    private final char[] toUpperCase;
    private final char[] toLowerCase;
    private final char[] myMeaningfulCharacters;
    private final int myMinNameLength;

    MinusculeMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, @NotNull String hardSeparators) {
        if (pattern == null) {
            MinusculeMatcher.$$$reportNull$$$0(0);
        }
        if (options == null) {
            MinusculeMatcher.$$$reportNull$$$0(1);
        }
        if (hardSeparators == null) {
            MinusculeMatcher.$$$reportNull$$$0(2);
        }
        this.myMatchingState = new ThreadLocal<MatchingState>(){

            @Override
            protected MatchingState initialValue() {
                return new MatchingState();
            }
        };
        this.myOptions = options;
        this.myPattern = StringUtil.trimEnd(pattern, "* ").toCharArray();
        this.myHardSeparators = hardSeparators;
        this.isLowerCase = new boolean[this.myPattern.length];
        this.isUpperCase = new boolean[this.myPattern.length];
        this.isWordSeparator = new boolean[this.myPattern.length];
        this.toUpperCase = new char[this.myPattern.length];
        this.toLowerCase = new char[this.myPattern.length];
        StringBuilder meaningful = new StringBuilder();
        for (int k = 0; k < this.myPattern.length; ++k) {
            char c = this.myPattern[k];
            this.isLowerCase[k] = Character.isLowerCase(c);
            this.isUpperCase[k] = Character.isUpperCase(c);
            this.isWordSeparator[k] = MinusculeMatcher.isWordSeparator(c);
            this.toUpperCase[k] = StringUtil.toUpperCase(c);
            this.toLowerCase[k] = StringUtil.toLowerCase(c);
            if (this.isWildcard(k)) continue;
            meaningful.append(this.toLowerCase[k]);
            meaningful.append(this.toUpperCase[k]);
        }
        int i = 0;
        while (this.isWildcard(i)) {
            ++i;
        }
        this.myHasHumps = this.hasFlag(i + 1, this.isUpperCase) && this.hasFlag(i, this.isLowerCase);
        this.myHasSeparators = this.hasFlag(i, this.isWordSeparator);
        this.myHasDots = this.hasDots(i);
        this.myMeaningfulCharacters = meaningful.toString().toCharArray();
        this.myMinNameLength = this.myMeaningfulCharacters.length / 2;
    }

    private static boolean isWordSeparator(char c) {
        return Character.isWhitespace(c) || c == '_' || c == '-' || c == ':' || c == '+' || c == '.';
    }

    private static int nextWord(@NotNull String name, int start) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(3);
        }
        if (start < name.length() && Character.isDigit(name.charAt(start))) {
            return start + 1;
        }
        return NameUtil.nextWord(name, start);
    }

    private boolean hasFlag(int start, boolean[] flags) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (!flags[i]) continue;
            return true;
        }
        return false;
    }

    private boolean hasDots(int start) {
        for (int i = start; i < this.myPattern.length; ++i) {
            if (this.myPattern[i] != '.') continue;
            return true;
        }
        return false;
    }

    private static FList<TextRange> prependRange(@NotNull FList<TextRange> ranges2, int from, int length) {
        TextRange head;
        if (ranges2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(4);
        }
        if ((head = ranges2.getHead()) != null && head.getStartOffset() == from + length) {
            return ranges2.getTail().prepend(new TextRange(from, head.getEndOffset()));
        }
        return ranges2.prepend(TextRange.from(from, length));
    }

    public int matchingDegree(@NotNull String name) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(5);
        }
        return this.matchingDegree(name, false);
    }

    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(6);
        }
        return this.matchingDegree(name, valueStartCaseMatch, this.matchingFragments(name));
    }

    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable FList<TextRange> fragments2) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(7);
        }
        if (fragments2 == null) {
            return Integer.MIN_VALUE;
        }
        if (fragments2.isEmpty()) {
            return 0;
        }
        TextRange first2 = fragments2.getHead();
        boolean startMatch = first2.getStartOffset() == 0;
        int matchingCase = 0;
        int p = -1;
        int integral = 0;
        int humpIndex = 1;
        int nextHumpStart = 0;
        boolean humpStartMatchedUpperCase = false;
        block0: for (TextRange range : fragments2) {
            for (int i = range.getStartOffset(); i < range.getEndOffset(); ++i) {
                boolean isHumpStart = false;
                while (nextHumpStart <= i) {
                    if (nextHumpStart == i) {
                        isHumpStart = true;
                    }
                    nextHumpStart = MinusculeMatcher.nextWord(name, nextHumpStart);
                    if (first2 == range) continue;
                    ++humpIndex;
                }
                integral -= humpIndex;
                char c = name.charAt(i);
                p = StringUtil.indexOf(this.myPattern, c, p + 1, this.myPattern.length, false);
                if (p < 0) continue block0;
                if (isHumpStart) {
                    humpStartMatchedUpperCase = c == this.myPattern[p] && this.isUpperCase[p];
                }
                matchingCase += this.evaluateCaseMatching(startMatch, p, humpStartMatchedUpperCase, i, isHumpStart, c);
            }
        }
        int startIndex = first2.getStartOffset();
        boolean afterSeparator = StringUtil.indexOfAny(name, this.myHardSeparators, 0, startIndex) >= 0;
        boolean wordStart = startIndex == 0 || NameUtil.isWordStart(name, startIndex) && !NameUtil.isWordStart(name, startIndex - 1);
        boolean finalMatch = fragments2.get(fragments2.size() - 1).getEndOffset() == name.length();
        return (wordStart ? 1000 : 0) + integral * 10 + matchingCase * (startMatch && valueStartCaseMatch ? 10 : 1) + (afterSeparator ? 0 : 2) + (startMatch ? 1 : 0) + (finalMatch ? 1 : 0);
    }

    private int evaluateCaseMatching(boolean startMatch, int patternIndex, boolean humpStartMatchedUpperCase, int nameIndex, boolean isHumpStart, char nameChar) {
        if (nameChar == this.myPattern[patternIndex]) {
            if (this.isUpperCase[patternIndex]) {
                return 50;
            }
            if (nameIndex == 0 && startMatch) {
                return 15;
            }
            if (isHumpStart) {
                return 1;
            }
        } else {
            if (isHumpStart) {
                return -1;
            }
            if (this.isLowerCase[patternIndex] && humpStartMatchedUpperCase) {
                return -1;
            }
        }
        return 0;
    }

    public boolean isStartMatch(@NotNull String name) {
        FList<TextRange> fragments2;
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(8);
        }
        return (fragments2 = this.matchingFragments(name)) != null && MinusculeMatcher.isStartMatch(fragments2);
    }

    public static boolean isStartMatch(@NotNull Iterable<TextRange> fragments2) {
        Iterator<TextRange> iterator2;
        if (fragments2 == null) {
            MinusculeMatcher.$$$reportNull$$$0(9);
        }
        return !(iterator2 = fragments2.iterator()).hasNext() || iterator2.next().getStartOffset() == 0;
    }

    @Override
    public boolean matches(@NotNull String name) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(10);
        }
        return this.matchingFragments(name) != null;
    }

    @NotNull
    public String getPattern() {
        String string = new String(this.myPattern);
        if (string == null) {
            MinusculeMatcher.$$$reportNull$$$0(11);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(12);
        }
        if (name.length() < this.myMinNameLength) {
            return null;
        }
        int length = name.length();
        int patternIndex = 0;
        boolean isAscii = true;
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0080') {
                isAscii = false;
            }
            if (patternIndex >= this.myMeaningfulCharacters.length || c != this.myMeaningfulCharacters[patternIndex] && c != this.myMeaningfulCharacters[patternIndex + 1]) continue;
            patternIndex += 2;
        }
        if (patternIndex < this.myMinNameLength * 2) {
            return null;
        }
        MatchingState state2 = this.myMatchingState.get();
        state2.initializeState(isAscii, length);
        try {
            FList<TextRange> fList = this.matchWildcards(name, 0, 0, state2);
            return fList;
        }
        finally {
            state2.releaseState();
        }
    }

    @Nullable
    private FList<TextRange> matchWildcards(@NotNull String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(13);
        }
        if (nameIndex < 0) {
            return null;
        }
        if (!this.isWildcard(patternIndex)) {
            if (patternIndex == this.myPattern.length) {
                return FList.emptyList();
            }
            return this.matchFragment(name, patternIndex, nameIndex, matchingState);
        }
        while (this.isWildcard(++patternIndex)) {
        }
        if (patternIndex == this.myPattern.length) {
            boolean space = this.isPatternChar(patternIndex - 1, ' ');
            if (space && nameIndex != name.length() && (patternIndex < 2 || !MinusculeMatcher.isUpperCaseOrDigit(this.myPattern[patternIndex - 2]))) {
                int spaceIndex = name.indexOf(32, nameIndex);
                if (spaceIndex >= 0) {
                    return FList.emptyList().prepend(TextRange.from(spaceIndex, 1));
                }
                return null;
            }
            return FList.emptyList();
        }
        FList<TextRange> ranges2 = this.matchFragment(name, patternIndex, nameIndex, matchingState);
        if (ranges2 != null) {
            return ranges2;
        }
        return this.matchSkippingWords(name, patternIndex, nameIndex, true, matchingState);
    }

    private static boolean isUpperCaseOrDigit(char p) {
        return Character.isUpperCase(p) || Character.isDigit(p);
    }

    @Nullable
    private FList<TextRange> matchSkippingWords(@NotNull String name, int patternIndex, int nameIndex, boolean allowSpecialChars, MatchingState matchingState) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(14);
        }
        boolean star = this.isPatternChar(patternIndex - 1, '*');
        char p = this.myPattern[patternIndex];
        while (true) {
            FList<TextRange> ranges2;
            int nextOccurrence;
            int n = nextOccurrence = star || this.isWordSeparator[patternIndex] ? this.indexOfIgnoreCase(name, nameIndex + 1, p, patternIndex, matchingState.isAsciiName) : this.indexOfWordStart(name, patternIndex, nameIndex);
            if (nextOccurrence < 0) {
                return null;
            }
            if (!allowSpecialChars && !this.myHasSeparators && !this.myHasHumps && StringUtil.containsAnyChar(name, this.myHardSeparators, nameIndex, nextOccurrence)) {
                return null;
            }
            if (!allowSpecialChars && this.myHasDots && !this.isPatternChar(patternIndex - 1, '.') && StringUtil.contains(name, nameIndex, nextOccurrence, '.')) {
                return null;
            }
            if ((!this.isUpperCase[patternIndex] || Character.isUpperCase(name.charAt(nextOccurrence)) || NameUtil.isWordStart(name, nextOccurrence) || !this.myHasHumps && this.myOptions != NameUtil.MatchingCaseSensitivity.ALL) && (ranges2 = this.matchFragment(name, patternIndex, nextOccurrence, matchingState)) != null) {
                return ranges2;
            }
            nameIndex = nextOccurrence;
        }
    }

    private boolean charEquals(char patternChar, int patternIndex, char c, boolean isIgnoreCase) {
        return patternChar == c || isIgnoreCase && (this.toLowerCase[patternIndex] == c || this.toUpperCase[patternIndex] == c);
    }

    @Nullable
    private FList<TextRange> matchFragment(@NotNull String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(15);
        }
        if (matchingState.hasFailed(patternIndex, nameIndex)) {
            return null;
        }
        FList<TextRange> result2 = this.doMatchFragments(name, patternIndex, nameIndex, matchingState);
        if (result2 == null) {
            matchingState.registerFailure(patternIndex, nameIndex);
        }
        return result2;
    }

    private FList<TextRange> doMatchFragments(String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        FList<TextRange> ranges2;
        boolean ignoreCase;
        if (!this.isFirstCharMatching(name, nameIndex, patternIndex)) {
            return null;
        }
        int minFragment = this.isPatternChar(patternIndex - 1, '*') && !this.isWildcard(patternIndex + 1) && Character.isLetterOrDigit(name.charAt(nameIndex)) && !NameUtil.isWordStart(name, nameIndex) ? 3 : 1;
        int i = 1;
        boolean bl = ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        while (nameIndex + i < name.length() && patternIndex + i < this.myPattern.length && this.charEquals(this.myPattern[patternIndex + i], patternIndex + i, name.charAt(nameIndex + i), ignoreCase)) {
            if (this.isUppercasePatternVsLowercaseNameChar(name, patternIndex + i, nameIndex + i)) {
                FList<TextRange> fList = ranges2 = i < minFragment ? null : this.findUppercaseMatchFurther(name, patternIndex + i, nameIndex + i, matchingState);
                if (ranges2 != null) {
                    return MinusculeMatcher.prependRange(ranges2, nameIndex, i);
                }
                if (this.shouldProhibitCaseMismatch(name, patternIndex + i, nameIndex + i)) {
                    return null;
                }
            }
            ++i;
        }
        if (patternIndex + i >= this.myPattern.length) {
            return FList.emptyList().prepend(TextRange.from(nameIndex, i));
        }
        while (i >= minFragment || this.isWildcard(patternIndex + i)) {
            FList<TextRange> fList = ranges2 = this.isWildcard(patternIndex + i) ? this.matchWildcards(name, patternIndex + i, nameIndex + i, matchingState) : this.matchSkippingWords(name, patternIndex + i, nameIndex + i, false, matchingState);
            if (ranges2 != null) {
                return MinusculeMatcher.prependRange(ranges2, nameIndex, i);
            }
            --i;
        }
        return null;
    }

    private boolean isUppercasePatternVsLowercaseNameChar(String name, int patternIndex, int nameIndex) {
        return this.isUpperCase[patternIndex] && this.myPattern[patternIndex] != name.charAt(nameIndex);
    }

    private FList<TextRange> findUppercaseMatchFurther(String name, int patternIndex, int nameIndex, MatchingState matchingState) {
        int nextWordStart = this.indexOfWordStart(name, patternIndex, nameIndex);
        return this.matchWildcards(name, patternIndex, nextWordStart, matchingState);
    }

    private boolean shouldProhibitCaseMismatch(String name, int patternIndex, int nameIndex) {
        return this.myHasHumps && patternIndex >= 2 && this.isUpperCase[patternIndex - 1] && this.isUpperCase[patternIndex - 2] && (nameIndex + 1 == name.length() || patternIndex + 1 < this.myPattern.length && !this.isLowerCase[patternIndex + 1]);
    }

    private boolean isFirstCharMatching(@NotNull String name, int nameIndex, int patternIndex) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(16);
        }
        if (nameIndex >= name.length()) {
            return false;
        }
        boolean ignoreCase = this.myOptions != NameUtil.MatchingCaseSensitivity.ALL;
        char patternChar = this.myPattern[patternIndex];
        if (!this.charEquals(patternChar, patternIndex, name.charAt(nameIndex), ignoreCase)) {
            return false;
        }
        return this.myOptions != NameUtil.MatchingCaseSensitivity.FIRST_LETTER || patternIndex != 0 && (patternIndex != 1 || !this.isWildcard(0)) || !MinusculeMatcher.hasCase(patternChar) || Character.isUpperCase(patternChar) == Character.isUpperCase(name.charAt(0));
    }

    private static boolean hasCase(char patternChar) {
        return Character.isUpperCase(patternChar) || Character.isLowerCase(patternChar);
    }

    private boolean isWildcard(int patternIndex) {
        if (patternIndex >= 0 && patternIndex < this.myPattern.length) {
            char pc = this.myPattern[patternIndex];
            return pc == ' ' || pc == '*';
        }
        return false;
    }

    private boolean isPatternChar(int patternIndex, char c) {
        return patternIndex >= 0 && patternIndex < this.myPattern.length && this.myPattern[patternIndex] == c;
    }

    private int indexOfWordStart(@NotNull String name, int patternIndex, int startFrom) {
        if (name == null) {
            MinusculeMatcher.$$$reportNull$$$0(17);
        }
        char p = this.myPattern[patternIndex];
        if (startFrom >= name.length() || this.myHasHumps && this.isLowerCase[patternIndex] && (patternIndex <= 0 || !this.isWordSeparator[patternIndex - 1])) {
            return -1;
        }
        int nextWordStart = startFrom;
        do {
            if ((nextWordStart = MinusculeMatcher.nextWord(name, nextWordStart)) < name.length()) continue;
            return -1;
        } while (!this.charEquals(p, patternIndex, name.charAt(nextWordStart), true));
        return nextWordStart;
    }

    private int indexOfIgnoreCase(String name, int fromIndex, char p, int patternIndex, boolean isAsciiName) {
        if (isAsciiName && IOUtil.isAscii(p)) {
            char pUpper = this.toUpperCase[patternIndex];
            char pLower = this.toLowerCase[patternIndex];
            for (int i = fromIndex; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c != p && MinusculeMatcher.toUpperAscii(c) != pUpper && MinusculeMatcher.toLowerAscii(c) != pLower) continue;
                return i;
            }
            return -1;
        }
        return StringUtil.indexOfIgnoreCase(name, p, fromIndex);
    }

    private static char toUpperAscii(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c + -32);
        }
        return c;
    }

    private static char toLowerAscii(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - -32);
        }
        return c;
    }

    @NonNls
    public String toString() {
        return "MinusculeMatcher{myPattern=" + new String(this.myPattern) + ", myOptions=" + (Object)((Object)this.myOptions) + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hardSeparators";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/codeStyle/MinusculeMatcher";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextWord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prependRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchingDegree";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isStartMatch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "matchingFragments";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "matchWildcards";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchSkippingWords";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "matchFragment";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isFirstCharMatching";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "indexOfWordStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MatchingState {
        private boolean myBusy;
        private int myNameLength;
        private boolean isAsciiName;
        private final BitSet myTable = new BitSet();

        private MatchingState() {
        }

        void initializeState(boolean isAscii, int length) {
            assert (!this.myBusy);
            this.myBusy = true;
            this.myNameLength = length;
            this.isAsciiName = isAscii;
            this.myTable.clear();
        }

        void releaseState() {
            assert (this.myBusy);
            this.myBusy = false;
        }

        void registerFailure(int patternIndex, int nameIndex) {
            this.myTable.set(patternIndex * this.myNameLength + nameIndex);
        }

        boolean hasFailed(int patternIndex, int nameIndex) {
            return this.myTable.get(patternIndex * this.myNameLength + nameIndex);
        }
    }
}

