/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractProvider;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.TransformBackedProvider;
import org.gradle.api.provider.Provider;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProvider<C>
implements CollectionPropertyInternal<T, C> {
    private static final EmptyCollection EMPTY_COLLECTION = new EmptyCollection();
    private static final NoValueCollector NO_VALUE_COLLECTOR = new NoValueCollector();
    private final Class<? extends Collection> collectionType;
    private final Class elementType;
    private Collector<T> value = EMPTY_COLLECTION;
    private List<Collector<T>> collectors = new LinkedList<Collector<T>>();

    AbstractCollectionProperty(Class<? extends Collection> collectionType, Class<T> elementType) {
        this.collectionType = collectionType;
        this.elementType = elementType;
    }

    protected abstract C fromValue(Collection<T> var1);

    public void add(T element) {
        Preconditions.checkNotNull(element, (Object)String.format("Cannot add a null element to a property of type %s.", this.collectionType.getSimpleName()));
        this.collectors.add(new SingleElement<T>(element));
    }

    public void add(Provider<? extends T> providerOfElement) {
        this.collectors.add(new ElementFromProvider<T>(providerOfElement));
    }

    public void addAll(Provider<? extends Iterable<T>> providerOfElements) {
        this.collectors.add(new ElementsFromCollectionProvider(providerOfElements));
    }

    @Override
    @Nullable
    public Class<C> getType() {
        return null;
    }

    @Override
    public boolean isPresent() {
        if (!this.value.present()) {
            return false;
        }
        for (Collector<T> collector : this.collectors) {
            if (collector.present()) continue;
            return false;
        }
        return true;
    }

    @Override
    public C get() {
        ArrayList values = new ArrayList(1 + this.collectors.size());
        this.value.collectInto(values);
        for (Collector collector : this.collectors) {
            collector.collectInto(values);
        }
        return this.fromValue(values);
    }

    @Nullable
    public C getOrNull() {
        ArrayList values = new ArrayList(1 + this.collectors.size());
        if (!this.value.maybeCollectInto(values)) {
            return null;
        }
        for (Collector collector : this.collectors) {
            if (collector.maybeCollectInto(values)) continue;
            return null;
        }
        return this.fromValue(values);
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)object);
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)object);
        }
    }

    public void set(@Nullable Iterable<? extends T> value) {
        this.collectors.clear();
        this.value = value == null ? NO_VALUE_COLLECTOR : new ElementsFromCollection<T>(value);
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        this.collectors.clear();
        this.value = new ElementsFromProvider(provider);
    }

    @Override
    public String toString() {
        String valueState = this.value == EMPTY_COLLECTION ? "empty" : (this.value == NO_VALUE_COLLECTOR ? "undefined" : "defined");
        return String.format("%s(%s, %s)", this.collectionType.getSimpleName().toLowerCase(), this.elementType, valueState);
    }

    @Override
    public <S> ProviderInternal<S> map(Transformer<? extends S, ? super C> transformer) {
        return new TransformBackedProvider<S, C>(transformer, this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoValueCollector
    implements Collector<Object> {
        private NoValueCollector() {
        }

        @Override
        public boolean present() {
            return false;
        }

        @Override
        public void collectInto(Collection<Object> collection) {
            throw new IllegalStateException("No value has been specified for this provider.");
        }

        @Override
        public boolean maybeCollectInto(Collection<Object> collection) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementsFromProvider<T>
    implements Collector<T> {
        private final Provider<? extends Iterable<? extends T>> provider;

        ElementsFromProvider(Provider<? extends Iterable<? extends T>> provider) {
            this.provider = provider;
        }

        @Override
        public boolean present() {
            return this.provider.isPresent();
        }

        @Override
        public void collectInto(Collection<T> collection) {
            Iterable value = (Iterable)this.provider.get();
            CollectionUtils.addAll(collection, (Iterable)value);
        }

        @Override
        public boolean maybeCollectInto(Collection<T> collection) {
            Iterable value = (Iterable)this.provider.getOrNull();
            if (value == null) {
                return false;
            }
            CollectionUtils.addAll(collection, (Iterable)value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementsFromCollection<T>
    implements Collector<T> {
        private final Iterable<? extends T> value;

        ElementsFromCollection(Iterable<? extends T> value) {
            this.value = value;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(Collection<T> collection) {
            CollectionUtils.addAll(collection, this.value);
        }

        @Override
        public boolean maybeCollectInto(Collection<T> collection) {
            CollectionUtils.addAll(collection, this.value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementsFromCollectionProvider<T>
    implements Collector<T> {
        private final Provider<? extends Iterable<T>> providerOfElements;

        ElementsFromCollectionProvider(Provider<? extends Iterable<T>> providerOfElements) {
            this.providerOfElements = providerOfElements;
        }

        @Override
        public boolean present() {
            return this.providerOfElements.isPresent();
        }

        @Override
        public void collectInto(Collection<T> collection) {
            Iterable value = (Iterable)this.providerOfElements.get();
            CollectionUtils.addAll(collection, (Iterable)value);
        }

        @Override
        public boolean maybeCollectInto(Collection<T> collection) {
            Iterable value = (Iterable)this.providerOfElements.getOrNull();
            if (value == null) {
                return false;
            }
            CollectionUtils.addAll(collection, (Iterable)value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementFromProvider<T>
    implements Collector<T> {
        private final Provider<? extends T> providerOfElement;

        ElementFromProvider(Provider<? extends T> providerOfElement) {
            this.providerOfElement = providerOfElement;
        }

        @Override
        public boolean present() {
            return this.providerOfElement.isPresent();
        }

        @Override
        public void collectInto(Collection<T> collection) {
            Object value = this.providerOfElement.get();
            collection.add(value);
        }

        @Override
        public boolean maybeCollectInto(Collection<T> collection) {
            Object value = this.providerOfElement.getOrNull();
            if (value == null) {
                return false;
            }
            collection.add(value);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingleElement<T>
    implements Collector<T> {
        private final T element;

        SingleElement(T element) {
            this.element = element;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(Collection<T> collection) {
            collection.add(this.element);
        }

        @Override
        public boolean maybeCollectInto(Collection<T> collection) {
            collection.add(this.element);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyCollection
    implements Collector<Object> {
        private EmptyCollection() {
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public boolean maybeCollectInto(Collection<Object> collection) {
            return true;
        }

        @Override
        public void collectInto(Collection<Object> collection) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Collector<T> {
        public boolean present();

        public void collectInto(Collection<T> var1);

        public boolean maybeCollectInto(Collection<T> var1);
    }
}

