/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.ModuleIdentifier;

public class DefaultModuleIdentifier
implements ModuleIdentifier {
    private final String group;
    private final String name;

    private DefaultModuleIdentifier(String group, String name) {
        this.group = group;
        this.name = name;
    }

    public static ModuleIdentifier newId(ModuleIdentifier other) {
        if (other instanceof DefaultModuleIdentifier) {
            return other;
        }
        return DefaultModuleIdentifier.newId(other.getGroup(), other.getName());
    }

    public static ModuleIdentifier newId(String group, String name) {
        return new DefaultModuleIdentifier(group, name);
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s:%s", this.group, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleIdentifier that = (DefaultModuleIdentifier)o;
        return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        return this.group.hashCode() ^ this.name.hashCode();
    }
}

