/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;

public class DefaultModuleVersionSelector
implements ModuleVersionSelector {
    private final ModuleIdentifier module;
    private final VersionConstraint moduleVersionConstraint;

    private DefaultModuleVersionSelector(ModuleIdentifier module, VersionConstraint versionConstraint) {
        this.module = module;
        this.moduleVersionConstraint = versionConstraint;
    }

    public DefaultModuleVersionSelector(String group, String name, String version) {
        this(DefaultModuleIdentifier.newId(group, name), new DefaultMutableVersionConstraint(version));
    }

    public String getGroup() {
        return this.module.getGroup();
    }

    public String getName() {
        return this.module.getName();
    }

    public String getVersion() {
        return this.moduleVersionConstraint.getPreferredVersion();
    }

    public VersionConstraint getVersionConstraint() {
        return this.moduleVersionConstraint;
    }

    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec((ModuleVersionSelector)this).isSatisfiedBy(identifier);
    }

    public ModuleIdentifier getModule() {
        return this.module;
    }

    public String toString() {
        return String.format("%s:%s", this.module, this.moduleVersionConstraint.getPreferredVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultModuleVersionSelector)) {
            return false;
        }
        DefaultModuleVersionSelector that = (DefaultModuleVersionSelector)o;
        if (this.module != null ? !this.module.equals(that.module) : that.module != null) {
            return false;
        }
        return !(this.moduleVersionConstraint != null ? !this.moduleVersionConstraint.equals(that.moduleVersionConstraint) : that.moduleVersionConstraint != null);
    }

    public int hashCode() {
        int result = this.module != null ? this.module.hashCode() : 0;
        result = 31 * result + this.moduleVersionConstraint.hashCode();
        return result;
    }

    public static ModuleVersionSelector newSelector(ModuleIdentifier module, String preferredVersion) {
        return new DefaultModuleVersionSelector(module, new DefaultMutableVersionConstraint(preferredVersion));
    }

    public static ModuleVersionSelector newSelector(ModuleIdentifier module, VersionConstraint version) {
        return new DefaultModuleVersionSelector(module, version);
    }

    public static ModuleVersionSelector newSelector(ModuleComponentSelector selector) {
        return new DefaultModuleVersionSelector(selector.getModuleIdentifier(), selector.getVersionConstraint());
    }
}

