/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.internal.component.model.IvyArtifactName;

class ArtifactExcludeSpec
extends AbstractModuleExclusion {
    private final ModuleIdentifier moduleId;
    private final IvyArtifactName ivyArtifactName;

    ArtifactExcludeSpec(ModuleIdentifier moduleId, IvyArtifactName artifact) {
        this.moduleId = moduleId;
        this.ivyArtifactName = artifact;
    }

    public String toString() {
        return "{artifact " + this.moduleId + ":" + this.ivyArtifactName + "}";
    }

    @Override
    protected boolean doEquals(Object o) {
        ArtifactExcludeSpec other = (ArtifactExcludeSpec)o;
        return this.moduleId.equals(other.moduleId) && this.ivyArtifactName.equals(other.ivyArtifactName);
    }

    @Override
    protected int doHashCode() {
        return this.moduleId.hashCode() ^ this.ivyArtifactName.hashCode();
    }

    @Override
    protected boolean doExcludesSameModulesAs(AbstractModuleExclusion other) {
        return true;
    }

    @Override
    protected boolean excludesNoModules() {
        return true;
    }

    @Override
    public boolean excludeModule(ModuleIdentifier module) {
        return false;
    }

    @Override
    public boolean excludeArtifact(ModuleIdentifier module, IvyArtifactName artifact) {
        return this.matches(this.moduleId.getGroup(), module.getGroup()) && this.matches(this.moduleId.getName(), module.getName()) && this.matches(this.ivyArtifactName.getName(), artifact.getName()) && this.matches(this.ivyArtifactName.getExtension(), artifact.getExtension()) && this.matches(this.ivyArtifactName.getType(), artifact.getType());
    }

    @Override
    public boolean mayExcludeArtifacts() {
        return true;
    }

    private boolean matches(String expression, String input) {
        return ArtifactExcludeSpec.isWildcard(expression) || expression.equals(input);
    }
}

