/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildableSingleResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformer;
import org.gradle.api.internal.artifacts.transform.TransformInfo;
import org.gradle.api.internal.artifacts.transform.TransformInfoFactory;
import org.gradle.api.internal.artifacts.transform.UserCodeBackedTransformer;

public class DefaultTransformInfoFactory
implements TransformInfoFactory {
    private final Map<ArtifactTransformKey, TransformInfo> transformations = Maps.newConcurrentMap();

    @Override
    public Collection<TransformInfo> getOrCreate(ResolvedArtifactSet artifactSet, ArtifactTransformer transformer) {
        final List<UserCodeBackedTransformer> transformerChain = DefaultTransformInfoFactory.unpackTransformerChain(transformer);
        final ImmutableList.Builder builder = ImmutableList.builder();
        CompositeResolvedArtifactSet.visitHierarchy(artifactSet, new CompositeResolvedArtifactSet.ResolvedArtifactSetVisitor(){

            @Override
            public boolean visitArtifactSet(ResolvedArtifactSet set) {
                if (set instanceof CompositeResolvedArtifactSet) {
                    return true;
                }
                if (!(set instanceof BuildableSingleResolvedArtifactSet)) {
                    throw new IllegalStateException(String.format("Expecting a %s instead of a %s", BuildableSingleResolvedArtifactSet.class.getSimpleName(), set.getClass().getName()));
                }
                BuildableSingleResolvedArtifactSet singleArtifactSet = (BuildableSingleResolvedArtifactSet)set;
                ArtifactTransformKey key = new ArtifactTransformKey(singleArtifactSet.getArtifactId(), transformerChain);
                TransformInfo transformInfo = (TransformInfo)((Object)DefaultTransformInfoFactory.this.transformations.get(key));
                if (transformInfo == null) {
                    transformInfo = TransformInfo.from(transformerChain, singleArtifactSet);
                    DefaultTransformInfoFactory.this.transformations.put(key, transformInfo);
                }
                builder.add((Object)transformInfo);
                return true;
            }
        });
        return builder.build();
    }

    private static List<UserCodeBackedTransformer> unpackTransformerChain(ArtifactTransformer transformer) {
        final ArrayList transformerChain = Lists.newArrayList();
        transformer.visitLeafTransformers((Action<? super ArtifactTransformer>)new Action<ArtifactTransformer>(){

            public void execute(ArtifactTransformer transformer) {
                transformerChain.add((UserCodeBackedTransformer)transformer);
            }
        });
        return transformerChain;
    }

    private static class ArtifactTransformKey {
        private final ComponentArtifactIdentifier artifactIdentifier;
        private final List<UserCodeBackedTransformer> transformers;

        private ArtifactTransformKey(ComponentArtifactIdentifier artifactIdentifier, List<UserCodeBackedTransformer> transformers) {
            this.artifactIdentifier = artifactIdentifier;
            this.transformers = transformers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactTransformKey that = (ArtifactTransformKey)o;
            if (!this.artifactIdentifier.equals(that.artifactIdentifier)) {
                return false;
            }
            return this.transformers.equals(that.transformers);
        }

        public int hashCode() {
            int result = this.artifactIdentifier.hashCode();
            result = 31 * result + this.transformers.hashCode();
            return result;
        }
    }
}

