/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.buildcomparison.compare.internal;

import java.util.HashSet;
import java.util.LinkedList;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparator;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparisonResult;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildComparisonSpec;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparator;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparatorFactory;
import org.gradle.api.plugins.buildcomparison.compare.internal.BuildOutcomeComparisonResult;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcome;
import org.gradle.api.plugins.buildcomparison.outcome.internal.BuildOutcomeAssociation;

public class DefaultBuildComparator
implements BuildComparator {
    BuildOutcomeComparatorFactory comparatorFactory;

    public DefaultBuildComparator(BuildOutcomeComparatorFactory comparatorFactory) {
        this.comparatorFactory = comparatorFactory;
    }

    @Override
    public BuildComparisonResult compareBuilds(BuildComparisonSpec spec) {
        HashSet<BuildOutcome> uncomparedFrom = new HashSet<BuildOutcome>(spec.getSource());
        HashSet<BuildOutcome> uncomparedTo = new HashSet<BuildOutcome>(spec.getTarget());
        HashSet unknownFrom = new HashSet();
        HashSet unknownTo = new HashSet();
        LinkedList results = new LinkedList();
        for (BuildOutcomeAssociation<?> outcomeAssociation : spec.getOutcomeAssociations()) {
            Object to;
            Object from = outcomeAssociation.getSource();
            boolean unknown = false;
            if (!uncomparedFrom.remove(from)) {
                unknown = true;
                unknownFrom.add(from);
            }
            if (!uncomparedTo.remove(to = outcomeAssociation.getTarget())) {
                unknown = true;
                unknownTo.add(to);
            }
            if (unknown) continue;
            BuildOutcomeComparator<?, ?> comparator = this.comparatorFactory.getComparator(outcomeAssociation.getType());
            if (comparator == null) {
                throw new RuntimeException(String.format("No comparator for %s", outcomeAssociation.getType()));
            }
            Object comparisonResult = comparator.compare(outcomeAssociation);
            results.add((BuildOutcomeComparisonResult<?>)comparisonResult);
        }
        return new BuildComparisonResult(uncomparedFrom, uncomparedTo, results);
    }
}

