/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.WorkResults;
import org.gradle.internal.FileUtils;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.toolchain.internal.AbstractCompiler;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;

public abstract class NativeCompiler<T extends NativeCompileSpec>
extends AbstractCompiler<T> {
    private final Transformer<T, T> specTransformer;
    private final String objectFileExtension;
    private final Logger logger = Logging.getLogger(NativeCompiler.class);
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;

    public NativeCompiler(BuildOperationExecutor buildOperationExecutor, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, ArgsTransformer<T> argsTransformer, Transformer<T, T> specTransformer, String objectFileExtension, boolean useCommandFile, WorkerLeaseService workerLeaseService) {
        super(buildOperationExecutor, commandLineToolInvocationWorker, invocationContext, argsTransformer, useCommandFile, workerLeaseService);
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.objectFileExtension = objectFileExtension;
        this.specTransformer = specTransformer;
    }

    @Override
    public WorkResult execute(T spec) {
        NativeCompileSpec transformedSpec = (NativeCompileSpec)this.specTransformer.transform(spec);
        super.execute(spec);
        return WorkResults.didWork((!transformedSpec.getSourceFiles().isEmpty() ? 1 : 0) != 0);
    }

    @Override
    protected Action<BuildOperationQueue<CommandLineToolInvocation>> newInvocationAction(final T spec, final List<String> genericArgs) {
        final File objectDir = spec.getObjectFileDir();
        return new Action<BuildOperationQueue<CommandLineToolInvocation>>(){

            public void execute(BuildOperationQueue<CommandLineToolInvocation> buildQueue) {
                buildQueue.setLogLocation(spec.getOperationLogger().getLogLocation());
                for (File sourceFile : spec.getSourceFiles()) {
                    CommandLineToolInvocation perFileInvocation = NativeCompiler.this.createPerFileInvocation(genericArgs, sourceFile, objectDir, spec);
                    buildQueue.add((BuildOperation)perFileInvocation);
                }
            }
        };
    }

    protected List<String> getSourceArgs(File sourceFile) {
        return Collections.singletonList(sourceFile.getAbsolutePath());
    }

    protected abstract List<String> getOutputArgs(T var1, File var2);

    @Override
    protected abstract void addOptionsFileArgs(List<String> var1, File var2);

    protected abstract List<String> getPCHArgs(T var1);

    protected File getOutputFileDir(File sourceFile, File objectFileDir, String fileSuffix) {
        boolean windowsPathLimitation = OperatingSystem.current().isWindows();
        File outputFile = this.compilerOutputFileNamingSchemeFactory.create().withObjectFileNameSuffix(fileSuffix).withOutputBaseFolder(objectFileDir).map(sourceFile);
        File outputDirectory = outputFile.getParentFile();
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        return windowsPathLimitation ? FileUtils.assertInWindowsPathLengthLimitation((File)outputFile) : outputFile;
    }

    protected List<String> maybeGetPCHArgs(T spec, File sourceFile) {
        if (spec.getPreCompiledHeader() == null || !spec.getSourceFilesForPch().contains(sourceFile)) {
            return Lists.newArrayList();
        }
        return this.getPCHArgs(spec);
    }

    protected CommandLineToolInvocation createPerFileInvocation(List<String> genericArgs, File sourceFile, File objectDir, T spec) {
        List<String> sourceArgs = this.getSourceArgs(sourceFile);
        List<String> outputArgs = this.getOutputArgs(spec, this.getOutputFileDir(sourceFile, objectDir, this.objectFileExtension));
        List<String> pchArgs = this.maybeGetPCHArgs(spec, sourceFile);
        return this.newInvocation("compiling ".concat(sourceFile.getName()), objectDir, this.buildPerFileArgs(genericArgs, sourceArgs, outputArgs, pchArgs), spec.getOperationLogger());
    }

    protected Iterable<String> buildPerFileArgs(List<String> genericArgs, List<String> sourceArgs, List<String> outputArgs, List<String> pchArgs) {
        return Iterables.concat(genericArgs, pchArgs, sourceArgs, outputArgs);
    }
}

