/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.util.Vector;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.TlsECConfigVerifier;
import org.bouncycastle.tls.crypto.TlsECConfig;

public class DefaultTlsECConfigVerifier
implements TlsECConfigVerifier {
    protected int minimumCurveBits;
    protected Vector namedGroups;

    public DefaultTlsECConfigVerifier(int n, Vector vector) {
        this.minimumCurveBits = Math.max(1, n);
        this.namedGroups = vector;
    }

    public boolean accept(TlsECConfig tlsECConfig) {
        int n = tlsECConfig.getNamedGroup();
        if (n < 0) {
            return false;
        }
        if (NamedGroup.getCurveBits(n) < this.minimumCurveBits) {
            return false;
        }
        return this.namedGroups == null || this.namedGroups.contains(n);
    }
}

