// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Admin_h__
#define __IceGrid_Admin_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Ice/Identity.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/Properties.h>
#include <Ice/SliceChecksumDict.h>
#include <Glacier2/Session.h>
#include <IceGrid/Exception.h>
#include <IceGrid/Descriptor.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class Admin;
class AdminPrx;
class FileIterator;
class FileIteratorPrx;
class RegistryObserver;
class RegistryObserverPrx;
class NodeObserver;
class NodeObserverPrx;
class ApplicationObserver;
class ApplicationObserverPrx;
class AdapterObserver;
class AdapterObserverPrx;
class ObjectObserver;
class ObjectObserverPrx;
class AdminSession;
class AdminSessionPrx;

}

namespace IceGrid
{

enum class ServerState : unsigned char
{
    Inactive,
    Activating,
    ActivationTimedOut,
    Active,
    Deactivating,
    Destroying,
    Destroyed
};

using StringObjectProxyDict = ::std::map<::std::string, ::std::shared_ptr<::Ice::ObjectPrx>>;

struct ObjectInfo
{
    ::std::shared_ptr<::Ice::ObjectPrx> proxy;
    ::std::string type;

    std::tuple<const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&> ice_tuple() const
    {
        return std::tie(proxy, type);
    }
};

using ObjectInfoSeq = ::std::vector<::IceGrid::ObjectInfo>;

struct AdapterInfo
{
    ::std::string id;
    ::std::shared_ptr<::Ice::ObjectPrx> proxy;
    ::std::string replicaGroupId;

    std::tuple<const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&> ice_tuple() const
    {
        return std::tie(id, proxy, replicaGroupId);
    }
};

using AdapterInfoSeq = ::std::vector<::IceGrid::AdapterInfo>;

struct ServerInfo
{
    ::std::string application;
    ::std::string uuid;
    int revision;
    ::std::string node;
    ::std::shared_ptr<::IceGrid::ServerDescriptor> descriptor;
    ::std::string sessionId;

    std::tuple<const ::std::string&, const ::std::string&, const int&, const ::std::string&, const ::std::shared_ptr<::IceGrid::ServerDescriptor>&, const ::std::string&> ice_tuple() const
    {
        return std::tie(application, uuid, revision, node, descriptor, sessionId);
    }
};

struct NodeInfo
{
    ::std::string name;
    ::std::string os;
    ::std::string hostname;
    ::std::string release;
    ::std::string version;
    ::std::string machine;
    int nProcessors;
    ::std::string dataDir;

    std::tuple<const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const ::std::string&, const int&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, os, hostname, release, version, machine, nProcessors, dataDir);
    }
};

struct RegistryInfo
{
    ::std::string name;
    ::std::string hostname;

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, hostname);
    }
};

using RegistryInfoSeq = ::std::vector<::IceGrid::RegistryInfo>;

struct LoadInfo
{
    float avg1;
    float avg5;
    float avg15;

    std::tuple<const float&, const float&, const float&> ice_tuple() const
    {
        return std::tie(avg1, avg5, avg15);
    }
};

struct ApplicationInfo
{
    ::std::string uuid;
    long long int createTime;
    ::std::string createUser;
    long long int updateTime;
    ::std::string updateUser;
    int revision;
    ::IceGrid::ApplicationDescriptor descriptor;

    std::tuple<const ::std::string&, const long long int&, const ::std::string&, const long long int&, const ::std::string&, const int&, const ::IceGrid::ApplicationDescriptor&> ice_tuple() const
    {
        return std::tie(uuid, createTime, createUser, updateTime, updateUser, revision, descriptor);
    }
};

using ApplicationInfoSeq = ::std::vector<::IceGrid::ApplicationInfo>;

struct ApplicationUpdateInfo
{
    long long int updateTime;
    ::std::string updateUser;
    int revision;
    ::IceGrid::ApplicationUpdateDescriptor descriptor;

    std::tuple<const long long int&, const ::std::string&, const int&, const ::IceGrid::ApplicationUpdateDescriptor&> ice_tuple() const
    {
        return std::tie(updateTime, updateUser, revision, descriptor);
    }
};

struct ServerDynamicInfo
{
    ::std::string id;
    ::IceGrid::ServerState state;
    int pid;
    bool enabled;

    std::tuple<const ::std::string&, const ::IceGrid::ServerState&, const int&, const bool&> ice_tuple() const
    {
        return std::tie(id, state, pid, enabled);
    }
};

using ServerDynamicInfoSeq = ::std::vector<::IceGrid::ServerDynamicInfo>;

struct AdapterDynamicInfo
{
    ::std::string id;
    ::std::shared_ptr<::Ice::ObjectPrx> proxy;

    std::tuple<const ::std::string&, const ::std::shared_ptr<::Ice::ObjectPrx>&> ice_tuple() const
    {
        return std::tie(id, proxy);
    }
};

using AdapterDynamicInfoSeq = ::std::vector<::IceGrid::AdapterDynamicInfo>;

struct NodeDynamicInfo
{
    ::IceGrid::NodeInfo info;
    ::IceGrid::ServerDynamicInfoSeq servers;
    ::IceGrid::AdapterDynamicInfoSeq adapters;

    std::tuple<const ::IceGrid::NodeInfo&, const ::IceGrid::ServerDynamicInfoSeq&, const ::IceGrid::AdapterDynamicInfoSeq&> ice_tuple() const
    {
        return std::tie(info, servers, adapters);
    }
};

using NodeDynamicInfoSeq = ::std::vector<::IceGrid::NodeDynamicInfo>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceGrid
{

class ICEGRID_API Admin : public virtual ::Ice::Object
{
public:

    using ProxyType = AdminPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void addApplication(::IceGrid::ApplicationDescriptor, const ::Ice::Current&) = 0;
    bool _iceD_addApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void syncApplication(::IceGrid::ApplicationDescriptor, const ::Ice::Current&) = 0;
    bool _iceD_syncApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateApplication(::IceGrid::ApplicationUpdateDescriptor, const ::Ice::Current&) = 0;
    bool _iceD_updateApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void syncApplicationWithoutRestart(::IceGrid::ApplicationDescriptor, const ::Ice::Current&) = 0;
    bool _iceD_syncApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateApplicationWithoutRestart(::IceGrid::ApplicationUpdateDescriptor, const ::Ice::Current&) = 0;
    bool _iceD_updateApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void removeApplication(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_removeApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void instantiateServer(::std::string, ::std::string, ::IceGrid::ServerInstanceDescriptor, const ::Ice::Current&) = 0;
    bool _iceD_instantiateServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void patchApplicationAsync(::std::string, bool, ::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_patchApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::ApplicationInfo getApplicationInfo(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getApplicationInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Current&) const = 0;
    bool _iceD_getDefaultApplicationDescriptor(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::StringSeq getAllApplicationNames(const ::Ice::Current&) const = 0;
    bool _iceD_getAllApplicationNames(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ServerInfo getServerInfo(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getServerInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ServerState getServerState(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getServerState(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual int getServerPid(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getServerPid(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::string getServerAdminCategory(const ::Ice::Current&) const = 0;
    bool _iceD_getServerAdminCategory(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> getServerAdmin(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getServerAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void enableServer(::std::string, bool, const ::Ice::Current&) = 0;
    bool _iceD_enableServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool isServerEnabled(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_isServerEnabled(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void startServerAsync(::std::string, ::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_startServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void stopServerAsync(::std::string, ::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_stopServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void patchServerAsync(::std::string, bool, ::std::function<void()>, ::std::function<void(::std::exception_ptr)>, const ::Ice::Current&) = 0;
    bool _iceD_patchServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void sendSignal(::std::string, ::std::string, const ::Ice::Current&) = 0;
    bool _iceD_sendSignal(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq getAllServerIds(const ::Ice::Current&) const = 0;
    bool _iceD_getAllServerIds(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::AdapterInfoSeq getAdapterInfo(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getAdapterInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void removeAdapter(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_removeAdapter(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq getAllAdapterIds(const ::Ice::Current&) const = 0;
    bool _iceD_getAllAdapterIds(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void addObject(::std::shared_ptr<::Ice::ObjectPrx>, const ::Ice::Current&) = 0;
    bool _iceD_addObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateObject(::std::shared_ptr<::Ice::ObjectPrx>, const ::Ice::Current&) = 0;
    bool _iceD_updateObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void addObjectWithType(::std::shared_ptr<::Ice::ObjectPrx>, ::std::string, const ::Ice::Current&) = 0;
    bool _iceD_addObjectWithType(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void removeObject(::Ice::Identity, const ::Ice::Current&) = 0;
    bool _iceD_removeObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::ObjectInfo getObjectInfo(::Ice::Identity, const ::Ice::Current&) const = 0;
    bool _iceD_getObjectInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ObjectInfoSeq getObjectInfosByType(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getObjectInfosByType(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ObjectInfoSeq getAllObjectInfos(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getAllObjectInfos(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool pingNode(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_pingNode(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::LoadInfo getNodeLoad(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getNodeLoad(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::NodeInfo getNodeInfo(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getNodeInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> getNodeAdmin(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getNodeAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual int getNodeProcessorSocketCount(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getNodeProcessorSocketCount(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void shutdownNode(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_shutdownNode(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::string getNodeHostname(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getNodeHostname(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::StringSeq getAllNodeNames(const ::Ice::Current&) const = 0;
    bool _iceD_getAllNodeNames(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool pingRegistry(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_pingRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::RegistryInfo getRegistryInfo(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getRegistryInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> getRegistryAdmin(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_getRegistryAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void shutdownRegistry(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_shutdownRegistry(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq getAllRegistryNames(const ::Ice::Current&) const = 0;
    bool _iceD_getAllRegistryNames(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void shutdown(const ::Ice::Current&) = 0;
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current&) const = 0;
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API FileIterator : public virtual ::Ice::Object
{
public:

    using ProxyType = FileIteratorPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    struct ReadResult
    {
        bool returnValue;
        ::Ice::StringSeq lines;
    };

    virtual bool read(int, ::Ice::StringSeq&, const ::Ice::Current&) = 0;
    bool _iceD_read(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void destroy(const ::Ice::Current&) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API RegistryObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = RegistryObserverPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void registryInit(::IceGrid::RegistryInfoSeq, const ::Ice::Current&) = 0;
    bool _iceD_registryInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void registryUp(::IceGrid::RegistryInfo, const ::Ice::Current&) = 0;
    bool _iceD_registryUp(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void registryDown(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_registryDown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API NodeObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = NodeObserverPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void nodeInit(::IceGrid::NodeDynamicInfoSeq, const ::Ice::Current&) = 0;
    bool _iceD_nodeInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void nodeUp(::IceGrid::NodeDynamicInfo, const ::Ice::Current&) = 0;
    bool _iceD_nodeUp(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void nodeDown(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_nodeDown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateServer(::std::string, ::IceGrid::ServerDynamicInfo, const ::Ice::Current&) = 0;
    bool _iceD_updateServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateAdapter(::std::string, ::IceGrid::AdapterDynamicInfo, const ::Ice::Current&) = 0;
    bool _iceD_updateAdapter(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API ApplicationObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ApplicationObserverPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void applicationInit(int, ::IceGrid::ApplicationInfoSeq, const ::Ice::Current&) = 0;
    bool _iceD_applicationInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void applicationAdded(int, ::IceGrid::ApplicationInfo, const ::Ice::Current&) = 0;
    bool _iceD_applicationAdded(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void applicationRemoved(int, ::std::string, const ::Ice::Current&) = 0;
    bool _iceD_applicationRemoved(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void applicationUpdated(int, ::IceGrid::ApplicationUpdateInfo, const ::Ice::Current&) = 0;
    bool _iceD_applicationUpdated(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API AdapterObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = AdapterObserverPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void adapterInit(::IceGrid::AdapterInfoSeq, const ::Ice::Current&) = 0;
    bool _iceD_adapterInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void adapterAdded(::IceGrid::AdapterInfo, const ::Ice::Current&) = 0;
    bool _iceD_adapterAdded(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void adapterUpdated(::IceGrid::AdapterInfo, const ::Ice::Current&) = 0;
    bool _iceD_adapterUpdated(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void adapterRemoved(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_adapterRemoved(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API ObjectObserver : public virtual ::Ice::Object
{
public:

    using ProxyType = ObjectObserverPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void objectInit(::IceGrid::ObjectInfoSeq, const ::Ice::Current&) = 0;
    bool _iceD_objectInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void objectAdded(::IceGrid::ObjectInfo, const ::Ice::Current&) = 0;
    bool _iceD_objectAdded(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void objectUpdated(::IceGrid::ObjectInfo, const ::Ice::Current&) = 0;
    bool _iceD_objectUpdated(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void objectRemoved(::Ice::Identity, const ::Ice::Current&) = 0;
    bool _iceD_objectRemoved(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API AdminSession : public virtual ::Glacier2::Session
{
public:

    using ProxyType = AdminSessionPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void keepAlive(const ::Ice::Current&) = 0;
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::AdminPrx> getAdmin(const ::Ice::Current&) const = 0;
    bool _iceD_getAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> getAdminCallbackTemplate(const ::Ice::Current&) const = 0;
    bool _iceD_getAdminCallbackTemplate(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void setObservers(::std::shared_ptr<::IceGrid::RegistryObserverPrx>, ::std::shared_ptr<::IceGrid::NodeObserverPrx>, ::std::shared_ptr<::IceGrid::ApplicationObserverPrx>, ::std::shared_ptr<::IceGrid::AdapterObserverPrx>, ::std::shared_ptr<::IceGrid::ObjectObserverPrx>, const ::Ice::Current&) = 0;
    bool _iceD_setObservers(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setObserversByIdentity(::Ice::Identity, ::Ice::Identity, ::Ice::Identity, ::Ice::Identity, ::Ice::Identity, const ::Ice::Current&) = 0;
    bool _iceD_setObserversByIdentity(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual int startUpdate(const ::Ice::Current&) = 0;
    bool _iceD_startUpdate(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void finishUpdate(const ::Ice::Current&) = 0;
    bool _iceD_finishUpdate(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::string getReplicaName(const ::Ice::Current&) const = 0;
    bool _iceD_getReplicaName(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::IceGrid::FileIteratorPrx> openServerLog(::std::string, ::std::string, int, const ::Ice::Current&) = 0;
    bool _iceD_openServerLog(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::FileIteratorPrx> openServerStdErr(::std::string, int, const ::Ice::Current&) = 0;
    bool _iceD_openServerStdErr(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::FileIteratorPrx> openServerStdOut(::std::string, int, const ::Ice::Current&) = 0;
    bool _iceD_openServerStdOut(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::FileIteratorPrx> openNodeStdErr(::std::string, int, const ::Ice::Current&) = 0;
    bool _iceD_openNodeStdErr(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::FileIteratorPrx> openNodeStdOut(::std::string, int, const ::Ice::Current&) = 0;
    bool _iceD_openNodeStdOut(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::FileIteratorPrx> openRegistryStdErr(::std::string, int, const ::Ice::Current&) = 0;
    bool _iceD_openRegistryStdErr(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::FileIteratorPrx> openRegistryStdOut(::std::string, int, const ::Ice::Current&) = 0;
    bool _iceD_openRegistryStdOut(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) AdminPrx : public virtual ::Ice::Proxy<AdminPrx, ::Ice::ObjectPrx>
{
public:

    void addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_addApplication, iceP_descriptor, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto addApplicationAsync(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_addApplication, iceP_descriptor, context);
    }

    ::std::function<void()>
    addApplicationAsync(const ::IceGrid::ApplicationDescriptor& iceP_descriptor,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_addApplication, iceP_descriptor, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_addApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&);

    void syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_syncApplication, iceP_descriptor, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto syncApplicationAsync(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_syncApplication, iceP_descriptor, context);
    }

    ::std::function<void()>
    syncApplicationAsync(const ::IceGrid::ApplicationDescriptor& iceP_descriptor,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_syncApplication, iceP_descriptor, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_syncApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&);

    void updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_updateApplication, iceP_descriptor, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto updateApplicationAsync(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_updateApplication, iceP_descriptor, context);
    }

    ::std::function<void()>
    updateApplicationAsync(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_updateApplication, iceP_descriptor, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_updateApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Context&);

    void syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_syncApplicationWithoutRestart, iceP_descriptor, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto syncApplicationWithoutRestartAsync(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_syncApplicationWithoutRestart, iceP_descriptor, context);
    }

    ::std::function<void()>
    syncApplicationWithoutRestartAsync(const ::IceGrid::ApplicationDescriptor& iceP_descriptor,
                                       ::std::function<void()> response,
                                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                       ::std::function<void(bool)> sent = nullptr,
                                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_syncApplicationWithoutRestart, iceP_descriptor, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_syncApplicationWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&);

    void updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_updateApplicationWithoutRestart, iceP_descriptor, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto updateApplicationWithoutRestartAsync(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_updateApplicationWithoutRestart, iceP_descriptor, context);
    }

    ::std::function<void()>
    updateApplicationWithoutRestartAsync(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor,
                                         ::std::function<void()> response,
                                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                         ::std::function<void(bool)> sent = nullptr,
                                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_updateApplicationWithoutRestart, iceP_descriptor, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_updateApplicationWithoutRestart(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Context&);

    void removeApplication(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_removeApplication, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto removeApplicationAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_removeApplication, iceP_name, context);
    }

    ::std::function<void()>
    removeApplicationAsync(const ::std::string& iceP_name,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_removeApplication, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_removeApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    void instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_instantiateServer, iceP_application, iceP_node, iceP_desc, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto instantiateServerAsync(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_instantiateServer, iceP_application, iceP_node, iceP_desc, context);
    }

    ::std::function<void()>
    instantiateServerAsync(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_instantiateServer, iceP_application, iceP_node, iceP_desc, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_instantiateServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::IceGrid::ServerInstanceDescriptor&, const ::Ice::Context&);

    void patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_patchApplication, iceP_name, iceP_shutdown, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto patchApplicationAsync(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_patchApplication, iceP_name, iceP_shutdown, context);
    }

    ::std::function<void()>
    patchApplicationAsync(const ::std::string& iceP_name, bool iceP_shutdown,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_patchApplication, iceP_name, iceP_shutdown, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_patchApplication(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, bool, const ::Ice::Context&);

    ::IceGrid::ApplicationInfo getApplicationInfo(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationInfo>(true, this, &IceGrid::AdminPrx::_iceI_getApplicationInfo, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getApplicationInfoAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ApplicationInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationInfo, P>(false, this, &IceGrid::AdminPrx::_iceI_getApplicationInfo, iceP_name, context);
    }

    ::std::function<void()>
    getApplicationInfoAsync(const ::std::string& iceP_name,
                            ::std::function<void(::IceGrid::ApplicationInfo)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ApplicationInfo>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getApplicationInfo, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getApplicationInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationInfo>>&, const ::std::string&, const ::Ice::Context&);

    ::IceGrid::ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor>(true, this, &IceGrid::AdminPrx::_iceI_getDefaultApplicationDescriptor, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getDefaultApplicationDescriptorAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ApplicationDescriptor>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ApplicationDescriptor, P>(false, this, &IceGrid::AdminPrx::_iceI_getDefaultApplicationDescriptor, context);
    }

    ::std::function<void()>
    getDefaultApplicationDescriptorAsync(::std::function<void(::IceGrid::ApplicationDescriptor)> response,
                                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                         ::std::function<void(bool)> sent = nullptr,
                                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ApplicationDescriptor>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getDefaultApplicationDescriptor, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getDefaultApplicationDescriptor(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ApplicationDescriptor>>&, const ::Ice::Context&);

    ::Ice::StringSeq getAllApplicationNames(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &IceGrid::AdminPrx::_iceI_getAllApplicationNames, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAllApplicationNamesAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getAllApplicationNames, context);
    }

    ::std::function<void()>
    getAllApplicationNamesAsync(::std::function<void(::Ice::StringSeq)> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getAllApplicationNames, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAllApplicationNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);

    ::IceGrid::ServerInfo getServerInfo(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ServerInfo>(true, this, &IceGrid::AdminPrx::_iceI_getServerInfo, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getServerInfoAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ServerInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ServerInfo, P>(false, this, &IceGrid::AdminPrx::_iceI_getServerInfo, iceP_id, context);
    }

    ::std::function<void()>
    getServerInfoAsync(const ::std::string& iceP_id,
                       ::std::function<void(::IceGrid::ServerInfo)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ServerInfo>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getServerInfo, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getServerInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerInfo>>&, const ::std::string&, const ::Ice::Context&);

    ::IceGrid::ServerState getServerState(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ServerState>(true, this, &IceGrid::AdminPrx::_iceI_getServerState, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getServerStateAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ServerState>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ServerState, P>(false, this, &IceGrid::AdminPrx::_iceI_getServerState, iceP_id, context);
    }

    ::std::function<void()>
    getServerStateAsync(const ::std::string& iceP_id,
                        ::std::function<void(::IceGrid::ServerState)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ServerState>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getServerState, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getServerState(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ServerState>>&, const ::std::string&, const ::Ice::Context&);

    int getServerPid(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &IceGrid::AdminPrx::_iceI_getServerPid, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getServerPidAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &IceGrid::AdminPrx::_iceI_getServerPid, iceP_id, context);
    }

    ::std::function<void()>
    getServerPidAsync(const ::std::string& iceP_id,
                      ::std::function<void(int)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getServerPid, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getServerPid(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::std::string&, const ::Ice::Context&);

    ::std::string getServerAdminCategory(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &IceGrid::AdminPrx::_iceI_getServerAdminCategory, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getServerAdminCategoryAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &IceGrid::AdminPrx::_iceI_getServerAdminCategory, context);
    }

    ::std::function<void()>
    getServerAdminCategoryAsync(::std::function<void(::std::string)> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getServerAdminCategory, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getServerAdminCategory(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> getServerAdmin(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::AdminPrx::_iceI_getServerAdmin, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getServerAdminAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::AdminPrx::_iceI_getServerAdmin, iceP_id, context);
    }

    ::std::function<void()>
    getServerAdminAsync(const ::std::string& iceP_id,
                        ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getServerAdmin, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getServerAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);

    void enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_enableServer, iceP_id, iceP_enabled, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto enableServerAsync(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_enableServer, iceP_id, iceP_enabled, context);
    }

    ::std::function<void()>
    enableServerAsync(const ::std::string& iceP_id, bool iceP_enabled,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_enableServer, iceP_id, iceP_enabled, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_enableServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, bool, const ::Ice::Context&);

    bool isServerEnabled(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &IceGrid::AdminPrx::_iceI_isServerEnabled, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto isServerEnabledAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &IceGrid::AdminPrx::_iceI_isServerEnabled, iceP_id, context);
    }

    ::std::function<void()>
    isServerEnabledAsync(const ::std::string& iceP_id,
                         ::std::function<void(bool)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_isServerEnabled, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_isServerEnabled(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::string&, const ::Ice::Context&);

    void startServer(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_startServer, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto startServerAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_startServer, iceP_id, context);
    }

    ::std::function<void()>
    startServerAsync(const ::std::string& iceP_id,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_startServer, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_startServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    void stopServer(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_stopServer, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto stopServerAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_stopServer, iceP_id, context);
    }

    ::std::function<void()>
    stopServerAsync(const ::std::string& iceP_id,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_stopServer, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_stopServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    void patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_patchServer, iceP_id, iceP_shutdown, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto patchServerAsync(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_patchServer, iceP_id, iceP_shutdown, context);
    }

    ::std::function<void()>
    patchServerAsync(const ::std::string& iceP_id, bool iceP_shutdown,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_patchServer, iceP_id, iceP_shutdown, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_patchServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, bool, const ::Ice::Context&);

    void sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_sendSignal, iceP_id, iceP_signal, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto sendSignalAsync(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_sendSignal, iceP_id, iceP_signal, context);
    }

    ::std::function<void()>
    sendSignalAsync(const ::std::string& iceP_id, const ::std::string& iceP_signal,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_sendSignal, iceP_id, iceP_signal, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_sendSignal(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);

    ::Ice::StringSeq getAllServerIds(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &IceGrid::AdminPrx::_iceI_getAllServerIds, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAllServerIdsAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getAllServerIds, context);
    }

    ::std::function<void()>
    getAllServerIdsAsync(::std::function<void(::Ice::StringSeq)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getAllServerIds, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAllServerIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);

    ::IceGrid::AdapterInfoSeq getAdapterInfo(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::AdapterInfoSeq>(true, this, &IceGrid::AdminPrx::_iceI_getAdapterInfo, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAdapterInfoAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::AdapterInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::AdapterInfoSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getAdapterInfo, iceP_id, context);
    }

    ::std::function<void()>
    getAdapterInfoAsync(const ::std::string& iceP_id,
                        ::std::function<void(::IceGrid::AdapterInfoSeq)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::AdapterInfoSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getAdapterInfo, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAdapterInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::AdapterInfoSeq>>&, const ::std::string&, const ::Ice::Context&);

    void removeAdapter(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_removeAdapter, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto removeAdapterAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_removeAdapter, iceP_id, context);
    }

    ::std::function<void()>
    removeAdapterAsync(const ::std::string& iceP_id,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_removeAdapter, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_removeAdapter(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    ::Ice::StringSeq getAllAdapterIds(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &IceGrid::AdminPrx::_iceI_getAllAdapterIds, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAllAdapterIdsAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getAllAdapterIds, context);
    }

    ::std::function<void()>
    getAllAdapterIdsAsync(::std::function<void(::Ice::StringSeq)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getAllAdapterIds, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAllAdapterIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);

    void addObject(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_addObject, iceP_obj, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto addObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_addObject, iceP_obj, context);
    }

    ::std::function<void()>
    addObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj,
                   ::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_addObject, iceP_obj, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_addObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);

    void updateObject(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_updateObject, iceP_obj, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto updateObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_updateObject, iceP_obj, context);
    }

    ::std::function<void()>
    updateObjectAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_updateObject, iceP_obj, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_updateObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);

    void addObjectWithType(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_addObjectWithType, iceP_obj, iceP_type, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto addObjectWithTypeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_addObjectWithType, iceP_obj, iceP_type, context);
    }

    ::std::function<void()>
    addObjectWithTypeAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_obj, const ::std::string& iceP_type,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_addObjectWithType, iceP_obj, iceP_type, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_addObjectWithType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&, const ::Ice::Context&);

    void removeObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_removeObject, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto removeObjectAsync(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_removeObject, iceP_id, context);
    }

    ::std::function<void()>
    removeObjectAsync(const ::Ice::Identity& iceP_id,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_removeObject, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_removeObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Context&);

    ::IceGrid::ObjectInfo getObjectInfo(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfo>(true, this, &IceGrid::AdminPrx::_iceI_getObjectInfo, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getObjectInfoAsync(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ObjectInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfo, P>(false, this, &IceGrid::AdminPrx::_iceI_getObjectInfo, iceP_id, context);
    }

    ::std::function<void()>
    getObjectInfoAsync(const ::Ice::Identity& iceP_id,
                       ::std::function<void(::IceGrid::ObjectInfo)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ObjectInfo>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getObjectInfo, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getObjectInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfo>>&, const ::Ice::Identity&, const ::Ice::Context&);

    ::IceGrid::ObjectInfoSeq getObjectInfosByType(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq>(true, this, &IceGrid::AdminPrx::_iceI_getObjectInfosByType, iceP_type, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getObjectInfosByTypeAsync(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ObjectInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getObjectInfosByType, iceP_type, context);
    }

    ::std::function<void()>
    getObjectInfosByTypeAsync(const ::std::string& iceP_type,
                              ::std::function<void(::IceGrid::ObjectInfoSeq)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ObjectInfoSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getObjectInfosByType, iceP_type, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getObjectInfosByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfoSeq>>&, const ::std::string&, const ::Ice::Context&);

    ::IceGrid::ObjectInfoSeq getAllObjectInfos(const ::std::string& iceP_expr, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq>(true, this, &IceGrid::AdminPrx::_iceI_getAllObjectInfos, iceP_expr, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAllObjectInfosAsync(const ::std::string& iceP_expr, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::ObjectInfoSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::ObjectInfoSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getAllObjectInfos, iceP_expr, context);
    }

    ::std::function<void()>
    getAllObjectInfosAsync(const ::std::string& iceP_expr,
                           ::std::function<void(::IceGrid::ObjectInfoSeq)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::ObjectInfoSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getAllObjectInfos, iceP_expr, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAllObjectInfos(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::ObjectInfoSeq>>&, const ::std::string&, const ::Ice::Context&);

    bool pingNode(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &IceGrid::AdminPrx::_iceI_pingNode, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto pingNodeAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &IceGrid::AdminPrx::_iceI_pingNode, iceP_name, context);
    }

    ::std::function<void()>
    pingNodeAsync(const ::std::string& iceP_name,
                  ::std::function<void(bool)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_pingNode, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_pingNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::string&, const ::Ice::Context&);

    ::IceGrid::LoadInfo getNodeLoad(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::LoadInfo>(true, this, &IceGrid::AdminPrx::_iceI_getNodeLoad, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getNodeLoadAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::LoadInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::LoadInfo, P>(false, this, &IceGrid::AdminPrx::_iceI_getNodeLoad, iceP_name, context);
    }

    ::std::function<void()>
    getNodeLoadAsync(const ::std::string& iceP_name,
                     ::std::function<void(::IceGrid::LoadInfo)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::LoadInfo>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getNodeLoad, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeLoad(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::LoadInfo>>&, const ::std::string&, const ::Ice::Context&);

    ::IceGrid::NodeInfo getNodeInfo(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::NodeInfo>(true, this, &IceGrid::AdminPrx::_iceI_getNodeInfo, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getNodeInfoAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::NodeInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::NodeInfo, P>(false, this, &IceGrid::AdminPrx::_iceI_getNodeInfo, iceP_name, context);
    }

    ::std::function<void()>
    getNodeInfoAsync(const ::std::string& iceP_name,
                     ::std::function<void(::IceGrid::NodeInfo)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::NodeInfo>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getNodeInfo, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::NodeInfo>>&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> getNodeAdmin(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::AdminPrx::_iceI_getNodeAdmin, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getNodeAdminAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::AdminPrx::_iceI_getNodeAdmin, iceP_name, context);
    }

    ::std::function<void()>
    getNodeAdminAsync(const ::std::string& iceP_name,
                      ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getNodeAdmin, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);

    int getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &IceGrid::AdminPrx::_iceI_getNodeProcessorSocketCount, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getNodeProcessorSocketCountAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &IceGrid::AdminPrx::_iceI_getNodeProcessorSocketCount, iceP_name, context);
    }

    ::std::function<void()>
    getNodeProcessorSocketCountAsync(const ::std::string& iceP_name,
                                     ::std::function<void(int)> response,
                                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                     ::std::function<void(bool)> sent = nullptr,
                                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getNodeProcessorSocketCount, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeProcessorSocketCount(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::std::string&, const ::Ice::Context&);

    void shutdownNode(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_shutdownNode, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto shutdownNodeAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_shutdownNode, iceP_name, context);
    }

    ::std::function<void()>
    shutdownNodeAsync(const ::std::string& iceP_name,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_shutdownNode, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_shutdownNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    ::std::string getNodeHostname(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &IceGrid::AdminPrx::_iceI_getNodeHostname, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getNodeHostnameAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &IceGrid::AdminPrx::_iceI_getNodeHostname, iceP_name, context);
    }

    ::std::function<void()>
    getNodeHostnameAsync(const ::std::string& iceP_name,
                         ::std::function<void(::std::string)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getNodeHostname, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getNodeHostname(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::std::string&, const ::Ice::Context&);

    ::Ice::StringSeq getAllNodeNames(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &IceGrid::AdminPrx::_iceI_getAllNodeNames, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAllNodeNamesAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getAllNodeNames, context);
    }

    ::std::function<void()>
    getAllNodeNamesAsync(::std::function<void(::Ice::StringSeq)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getAllNodeNames, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAllNodeNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);

    bool pingRegistry(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<bool>(true, this, &IceGrid::AdminPrx::_iceI_pingRegistry, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto pingRegistryAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<bool>>().get_future())
    {
        return _makePromiseOutgoing<bool, P>(false, this, &IceGrid::AdminPrx::_iceI_pingRegistry, iceP_name, context);
    }

    ::std::function<void()>
    pingRegistryAsync(const ::std::string& iceP_name,
                      ::std::function<void(bool)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<bool>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_pingRegistry, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_pingRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<bool>>&, const ::std::string&, const ::Ice::Context&);

    ::IceGrid::RegistryInfo getRegistryInfo(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceGrid::RegistryInfo>(true, this, &IceGrid::AdminPrx::_iceI_getRegistryInfo, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getRegistryInfoAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::RegistryInfo>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::RegistryInfo, P>(false, this, &IceGrid::AdminPrx::_iceI_getRegistryInfo, iceP_name, context);
    }

    ::std::function<void()>
    getRegistryInfoAsync(const ::std::string& iceP_name,
                         ::std::function<void(::IceGrid::RegistryInfo)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceGrid::RegistryInfo>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getRegistryInfo, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getRegistryInfo(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::RegistryInfo>>&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> getRegistryAdmin(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::AdminPrx::_iceI_getRegistryAdmin, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getRegistryAdminAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::AdminPrx::_iceI_getRegistryAdmin, iceP_name, context);
    }

    ::std::function<void()>
    getRegistryAdminAsync(const ::std::string& iceP_name,
                          ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getRegistryAdmin, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getRegistryAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);

    void shutdownRegistry(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_shutdownRegistry, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto shutdownRegistryAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_shutdownRegistry, iceP_name, context);
    }

    ::std::function<void()>
    shutdownRegistryAsync(const ::std::string& iceP_name,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_shutdownRegistry, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_shutdownRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    ::Ice::StringSeq getAllRegistryNames(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &IceGrid::AdminPrx::_iceI_getAllRegistryNames, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAllRegistryNamesAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &IceGrid::AdminPrx::_iceI_getAllRegistryNames, context);
    }

    ::std::function<void()>
    getAllRegistryNamesAsync(::std::function<void(::Ice::StringSeq)> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getAllRegistryNames, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAllRegistryNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);

    void shutdown(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminPrx::_iceI_shutdown, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto shutdownAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminPrx::_iceI_shutdown, context);
    }

    ::std::function<void()>
    shutdownAsync(::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_shutdown, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_shutdown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict>(true, this, &IceGrid::AdminPrx::_iceI_getSliceChecksums, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getSliceChecksumsAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::SliceChecksumDict>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::SliceChecksumDict, P>(false, this, &IceGrid::AdminPrx::_iceI_getSliceChecksums, context);
    }

    ::std::function<void()>
    getSliceChecksumsAsync(::std::function<void(::Ice::SliceChecksumDict)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::SliceChecksumDict>(response, ex, sent, this, &IceGrid::AdminPrx::_iceI_getSliceChecksums, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getSliceChecksums(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::SliceChecksumDict>>&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    AdminPrx() = default;
    friend ::std::shared_ptr<AdminPrx> IceInternal::createProxy<AdminPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) FileIteratorPrx : public virtual ::Ice::Proxy<FileIteratorPrx, ::Ice::ObjectPrx>
{
public:

    bool read(int iceP_size, ::Ice::StringSeq& iceP_lines, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto result = _makePromiseOutgoing<::IceGrid::FileIterator::ReadResult>(true, this, &IceGrid::FileIteratorPrx::_iceI_read, iceP_size, context).get();
        iceP_lines = ::std::move(result.lines);
        return result.returnValue;
    }

    template<template<typename> class P = ::std::promise>
    auto readAsync(int iceP_size, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceGrid::FileIterator::ReadResult>>().get_future())
    {
        return _makePromiseOutgoing<::IceGrid::FileIterator::ReadResult, P>(false, this, &IceGrid::FileIteratorPrx::_iceI_read, iceP_size, context);
    }

    ::std::function<void()>
    readAsync(int iceP_size,
              ::std::function<void(bool, ::Ice::StringSeq)> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto responseCb = [response](::IceGrid::FileIterator::ReadResult&& result)
        {
            response(result.returnValue, ::std::move(result.lines));
        };
        return _makeLamdaOutgoing<::IceGrid::FileIterator::ReadResult>(responseCb, ex, sent, this, &IceGrid::FileIteratorPrx::_iceI_read, iceP_size, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_read(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceGrid::FileIterator::ReadResult>>&, int, const ::Ice::Context&);

    void destroy(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::FileIteratorPrx::_iceI_destroy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::FileIteratorPrx::_iceI_destroy, context);
    }

    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::FileIteratorPrx::_iceI_destroy, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    FileIteratorPrx() = default;
    friend ::std::shared_ptr<FileIteratorPrx> IceInternal::createProxy<FileIteratorPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) RegistryObserverPrx : public virtual ::Ice::Proxy<RegistryObserverPrx, ::Ice::ObjectPrx>
{
public:

    void registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::RegistryObserverPrx::_iceI_registryInit, iceP_registries, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto registryInitAsync(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::RegistryObserverPrx::_iceI_registryInit, iceP_registries, context);
    }

    ::std::function<void()>
    registryInitAsync(const ::IceGrid::RegistryInfoSeq& iceP_registries,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::RegistryObserverPrx::_iceI_registryInit, iceP_registries, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_registryInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::RegistryInfoSeq&, const ::Ice::Context&);

    void registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::RegistryObserverPrx::_iceI_registryUp, iceP_node, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto registryUpAsync(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::RegistryObserverPrx::_iceI_registryUp, iceP_node, context);
    }

    ::std::function<void()>
    registryUpAsync(const ::IceGrid::RegistryInfo& iceP_node,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::RegistryObserverPrx::_iceI_registryUp, iceP_node, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_registryUp(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::RegistryInfo&, const ::Ice::Context&);

    void registryDown(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::RegistryObserverPrx::_iceI_registryDown, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto registryDownAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::RegistryObserverPrx::_iceI_registryDown, iceP_name, context);
    }

    ::std::function<void()>
    registryDownAsync(const ::std::string& iceP_name,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::RegistryObserverPrx::_iceI_registryDown, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_registryDown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    RegistryObserverPrx() = default;
    friend ::std::shared_ptr<RegistryObserverPrx> IceInternal::createProxy<RegistryObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) NodeObserverPrx : public virtual ::Ice::Proxy<NodeObserverPrx, ::Ice::ObjectPrx>
{
public:

    void nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::NodeObserverPrx::_iceI_nodeInit, iceP_nodes, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto nodeInitAsync(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::NodeObserverPrx::_iceI_nodeInit, iceP_nodes, context);
    }

    ::std::function<void()>
    nodeInitAsync(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes,
                  ::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::NodeObserverPrx::_iceI_nodeInit, iceP_nodes, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_nodeInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::NodeDynamicInfoSeq&, const ::Ice::Context&);

    void nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::NodeObserverPrx::_iceI_nodeUp, iceP_node, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto nodeUpAsync(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::NodeObserverPrx::_iceI_nodeUp, iceP_node, context);
    }

    ::std::function<void()>
    nodeUpAsync(const ::IceGrid::NodeDynamicInfo& iceP_node,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::NodeObserverPrx::_iceI_nodeUp, iceP_node, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_nodeUp(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::NodeDynamicInfo&, const ::Ice::Context&);

    void nodeDown(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::NodeObserverPrx::_iceI_nodeDown, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto nodeDownAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::NodeObserverPrx::_iceI_nodeDown, iceP_name, context);
    }

    ::std::function<void()>
    nodeDownAsync(const ::std::string& iceP_name,
                  ::std::function<void()> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::NodeObserverPrx::_iceI_nodeDown, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_nodeDown(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    void updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::NodeObserverPrx::_iceI_updateServer, iceP_node, iceP_updatedInfo, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto updateServerAsync(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::NodeObserverPrx::_iceI_updateServer, iceP_node, iceP_updatedInfo, context);
    }

    ::std::function<void()>
    updateServerAsync(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::NodeObserverPrx::_iceI_updateServer, iceP_node, iceP_updatedInfo, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_updateServer(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::IceGrid::ServerDynamicInfo&, const ::Ice::Context&);

    void updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::NodeObserverPrx::_iceI_updateAdapter, iceP_node, iceP_updatedInfo, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto updateAdapterAsync(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::NodeObserverPrx::_iceI_updateAdapter, iceP_node, iceP_updatedInfo, context);
    }

    ::std::function<void()>
    updateAdapterAsync(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::NodeObserverPrx::_iceI_updateAdapter, iceP_node, iceP_updatedInfo, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_updateAdapter(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::IceGrid::AdapterDynamicInfo&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    NodeObserverPrx() = default;
    friend ::std::shared_ptr<NodeObserverPrx> IceInternal::createProxy<NodeObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) ApplicationObserverPrx : public virtual ::Ice::Proxy<ApplicationObserverPrx, ::Ice::ObjectPrx>
{
public:

    void applicationInit(int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationInit, iceP_serial, iceP_applications, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto applicationInitAsync(int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationInit, iceP_serial, iceP_applications, context);
    }

    ::std::function<void()>
    applicationInitAsync(int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications,
                         ::std::function<void()> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationInit, iceP_serial, iceP_applications, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_applicationInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::IceGrid::ApplicationInfoSeq&, const ::Ice::Context&);

    void applicationAdded(int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationAdded, iceP_serial, iceP_desc, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto applicationAddedAsync(int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationAdded, iceP_serial, iceP_desc, context);
    }

    ::std::function<void()>
    applicationAddedAsync(int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc,
                          ::std::function<void()> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationAdded, iceP_serial, iceP_desc, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_applicationAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::IceGrid::ApplicationInfo&, const ::Ice::Context&);

    void applicationRemoved(int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationRemoved, iceP_serial, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto applicationRemovedAsync(int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationRemoved, iceP_serial, iceP_name, context);
    }

    ::std::function<void()>
    applicationRemovedAsync(int iceP_serial, const ::std::string& iceP_name,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationRemoved, iceP_serial, iceP_name, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_applicationRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::std::string&, const ::Ice::Context&);

    void applicationUpdated(int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationUpdated, iceP_serial, iceP_desc, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto applicationUpdatedAsync(int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationUpdated, iceP_serial, iceP_desc, context);
    }

    ::std::function<void()>
    applicationUpdatedAsync(int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ApplicationObserverPrx::_iceI_applicationUpdated, iceP_serial, iceP_desc, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_applicationUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::IceGrid::ApplicationUpdateInfo&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ApplicationObserverPrx() = default;
    friend ::std::shared_ptr<ApplicationObserverPrx> IceInternal::createProxy<ApplicationObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) AdapterObserverPrx : public virtual ::Ice::Proxy<AdapterObserverPrx, ::Ice::ObjectPrx>
{
public:

    void adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdapterObserverPrx::_iceI_adapterInit, iceP_adpts, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto adapterInitAsync(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdapterObserverPrx::_iceI_adapterInit, iceP_adpts, context);
    }

    ::std::function<void()>
    adapterInitAsync(const ::IceGrid::AdapterInfoSeq& iceP_adpts,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdapterObserverPrx::_iceI_adapterInit, iceP_adpts, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_adapterInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::AdapterInfoSeq&, const ::Ice::Context&);

    void adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdapterObserverPrx::_iceI_adapterAdded, iceP_info, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto adapterAddedAsync(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdapterObserverPrx::_iceI_adapterAdded, iceP_info, context);
    }

    ::std::function<void()>
    adapterAddedAsync(const ::IceGrid::AdapterInfo& iceP_info,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdapterObserverPrx::_iceI_adapterAdded, iceP_info, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_adapterAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::AdapterInfo&, const ::Ice::Context&);

    void adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdapterObserverPrx::_iceI_adapterUpdated, iceP_info, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto adapterUpdatedAsync(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdapterObserverPrx::_iceI_adapterUpdated, iceP_info, context);
    }

    ::std::function<void()>
    adapterUpdatedAsync(const ::IceGrid::AdapterInfo& iceP_info,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdapterObserverPrx::_iceI_adapterUpdated, iceP_info, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_adapterUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::AdapterInfo&, const ::Ice::Context&);

    void adapterRemoved(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdapterObserverPrx::_iceI_adapterRemoved, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto adapterRemovedAsync(const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdapterObserverPrx::_iceI_adapterRemoved, iceP_id, context);
    }

    ::std::function<void()>
    adapterRemovedAsync(const ::std::string& iceP_id,
                        ::std::function<void()> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdapterObserverPrx::_iceI_adapterRemoved, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_adapterRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    AdapterObserverPrx() = default;
    friend ::std::shared_ptr<AdapterObserverPrx> IceInternal::createProxy<AdapterObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) ObjectObserverPrx : public virtual ::Ice::Proxy<ObjectObserverPrx, ::Ice::ObjectPrx>
{
public:

    void objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ObjectObserverPrx::_iceI_objectInit, iceP_objects, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto objectInitAsync(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ObjectObserverPrx::_iceI_objectInit, iceP_objects, context);
    }

    ::std::function<void()>
    objectInitAsync(const ::IceGrid::ObjectInfoSeq& iceP_objects,
                    ::std::function<void()> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ObjectObserverPrx::_iceI_objectInit, iceP_objects, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_objectInit(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ObjectInfoSeq&, const ::Ice::Context&);

    void objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ObjectObserverPrx::_iceI_objectAdded, iceP_info, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto objectAddedAsync(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ObjectObserverPrx::_iceI_objectAdded, iceP_info, context);
    }

    ::std::function<void()>
    objectAddedAsync(const ::IceGrid::ObjectInfo& iceP_info,
                     ::std::function<void()> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ObjectObserverPrx::_iceI_objectAdded, iceP_info, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_objectAdded(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ObjectInfo&, const ::Ice::Context&);

    void objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ObjectObserverPrx::_iceI_objectUpdated, iceP_info, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto objectUpdatedAsync(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ObjectObserverPrx::_iceI_objectUpdated, iceP_info, context);
    }

    ::std::function<void()>
    objectUpdatedAsync(const ::IceGrid::ObjectInfo& iceP_info,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ObjectObserverPrx::_iceI_objectUpdated, iceP_info, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_objectUpdated(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::IceGrid::ObjectInfo&, const ::Ice::Context&);

    void objectRemoved(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::ObjectObserverPrx::_iceI_objectRemoved, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto objectRemovedAsync(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::ObjectObserverPrx::_iceI_objectRemoved, iceP_id, context);
    }

    ::std::function<void()>
    objectRemovedAsync(const ::Ice::Identity& iceP_id,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::ObjectObserverPrx::_iceI_objectRemoved, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_objectRemoved(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ObjectObserverPrx() = default;
    friend ::std::shared_ptr<ObjectObserverPrx> IceInternal::createProxy<ObjectObserverPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) AdminSessionPrx : public virtual ::Ice::Proxy<AdminSessionPrx, ::Glacier2::SessionPrx>
{
public:

    void keepAlive(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminSessionPrx::_iceI_keepAlive, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto keepAliveAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_keepAlive, context);
    }

    ::std::function<void()>
    keepAliveAsync(::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_keepAlive, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::AdminPrx> getAdmin(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_getAdmin, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAdminAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::AdminPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_getAdmin, context);
    }

    ::std::function<void()>
    getAdminAsync(::std::function<void(::std::shared_ptr<::IceGrid::AdminPrx>)> response,
                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                  ::std::function<void(bool)> sent = nullptr,
                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::AdminPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_getAdmin, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAdmin(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminPrx>>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> getAdminCallbackTemplate(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_getAdminCallbackTemplate, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAdminCallbackTemplateAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_getAdminCallbackTemplate, context);
    }

    ::std::function<void()>
    getAdminCallbackTemplateAsync(::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                  ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                  ::std::function<void(bool)> sent = nullptr,
                                  const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_getAdminCallbackTemplate, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getAdminCallbackTemplate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Context&);

    void setObservers(const ::std::shared_ptr<::IceGrid::RegistryObserverPrx>& iceP_registryObs, const ::std::shared_ptr<::IceGrid::NodeObserverPrx>& iceP_nodeObs, const ::std::shared_ptr<::IceGrid::ApplicationObserverPrx>& iceP_appObs, const ::std::shared_ptr<::IceGrid::AdapterObserverPrx>& iceP_adptObs, const ::std::shared_ptr<::IceGrid::ObjectObserverPrx>& iceP_objObs, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminSessionPrx::_iceI_setObservers, iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto setObserversAsync(const ::std::shared_ptr<::IceGrid::RegistryObserverPrx>& iceP_registryObs, const ::std::shared_ptr<::IceGrid::NodeObserverPrx>& iceP_nodeObs, const ::std::shared_ptr<::IceGrid::ApplicationObserverPrx>& iceP_appObs, const ::std::shared_ptr<::IceGrid::AdapterObserverPrx>& iceP_adptObs, const ::std::shared_ptr<::IceGrid::ObjectObserverPrx>& iceP_objObs, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_setObservers, iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context);
    }

    ::std::function<void()>
    setObserversAsync(const ::std::shared_ptr<::IceGrid::RegistryObserverPrx>& iceP_registryObs, const ::std::shared_ptr<::IceGrid::NodeObserverPrx>& iceP_nodeObs, const ::std::shared_ptr<::IceGrid::ApplicationObserverPrx>& iceP_appObs, const ::std::shared_ptr<::IceGrid::AdapterObserverPrx>& iceP_adptObs, const ::std::shared_ptr<::IceGrid::ObjectObserverPrx>& iceP_objObs,
                      ::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_setObservers, iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_setObservers(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::shared_ptr<::IceGrid::RegistryObserverPrx>&, const ::std::shared_ptr<::IceGrid::NodeObserverPrx>&, const ::std::shared_ptr<::IceGrid::ApplicationObserverPrx>&, const ::std::shared_ptr<::IceGrid::AdapterObserverPrx>&, const ::std::shared_ptr<::IceGrid::ObjectObserverPrx>&, const ::Ice::Context&);

    void setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminSessionPrx::_iceI_setObserversByIdentity, iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto setObserversByIdentityAsync(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_setObserversByIdentity, iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context);
    }

    ::std::function<void()>
    setObserversByIdentityAsync(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs,
                                ::std::function<void()> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_setObserversByIdentity, iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_setObserversByIdentity(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Context&);

    int startUpdate(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &IceGrid::AdminSessionPrx::_iceI_startUpdate, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto startUpdateAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_startUpdate, context);
    }

    ::std::function<void()>
    startUpdateAsync(::std::function<void(int)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_startUpdate, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_startUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);

    void finishUpdate(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceGrid::AdminSessionPrx::_iceI_finishUpdate, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto finishUpdateAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_finishUpdate, context);
    }

    ::std::function<void()>
    finishUpdateAsync(::std::function<void()> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_finishUpdate, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_finishUpdate(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ::std::string getReplicaName(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &IceGrid::AdminSessionPrx::_iceI_getReplicaName, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getReplicaNameAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_getReplicaName, context);
    }

    ::std::function<void()>
    getReplicaNameAsync(::std::function<void(::std::string)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_getReplicaName, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getReplicaName(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::FileIteratorPrx> openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_openServerLog, iceP_id, iceP_path, iceP_count, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto openServerLogAsync(const ::std::string& iceP_id, const ::std::string& iceP_path, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_openServerLog, iceP_id, iceP_path, iceP_count, context);
    }

    ::std::function<void()>
    openServerLogAsync(const ::std::string& iceP_id, const ::std::string& iceP_path, int iceP_count,
                       ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_openServerLog, iceP_id, iceP_path, iceP_count, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_openServerLog(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, const ::std::string&, int, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::FileIteratorPrx> openServerStdErr(const ::std::string& iceP_id, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_openServerStdErr, iceP_id, iceP_count, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto openServerStdErrAsync(const ::std::string& iceP_id, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_openServerStdErr, iceP_id, iceP_count, context);
    }

    ::std::function<void()>
    openServerStdErrAsync(const ::std::string& iceP_id, int iceP_count,
                          ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_openServerStdErr, iceP_id, iceP_count, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_openServerStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::FileIteratorPrx> openServerStdOut(const ::std::string& iceP_id, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_openServerStdOut, iceP_id, iceP_count, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto openServerStdOutAsync(const ::std::string& iceP_id, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_openServerStdOut, iceP_id, iceP_count, context);
    }

    ::std::function<void()>
    openServerStdOutAsync(const ::std::string& iceP_id, int iceP_count,
                          ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_openServerStdOut, iceP_id, iceP_count, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_openServerStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::FileIteratorPrx> openNodeStdErr(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdErr, iceP_name, iceP_count, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto openNodeStdErrAsync(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdErr, iceP_name, iceP_count, context);
    }

    ::std::function<void()>
    openNodeStdErrAsync(const ::std::string& iceP_name, int iceP_count,
                        ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdErr, iceP_name, iceP_count, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_openNodeStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::FileIteratorPrx> openNodeStdOut(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdOut, iceP_name, iceP_count, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto openNodeStdOutAsync(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdOut, iceP_name, iceP_count, context);
    }

    ::std::function<void()>
    openNodeStdOutAsync(const ::std::string& iceP_name, int iceP_count,
                        ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_openNodeStdOut, iceP_name, iceP_count, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_openNodeStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::FileIteratorPrx> openRegistryStdErr(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdErr, iceP_name, iceP_count, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto openRegistryStdErrAsync(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdErr, iceP_name, iceP_count, context);
    }

    ::std::function<void()>
    openRegistryStdErrAsync(const ::std::string& iceP_name, int iceP_count,
                            ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdErr, iceP_name, iceP_count, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_openRegistryStdErr(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::FileIteratorPrx> openRegistryStdOut(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(true, this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdOut, iceP_name, iceP_count, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto openRegistryStdOutAsync(const ::std::string& iceP_name, int iceP_count, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>, P>(false, this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdOut, iceP_name, iceP_count, context);
    }

    ::std::function<void()>
    openRegistryStdOutAsync(const ::std::string& iceP_name, int iceP_count,
                            ::std::function<void(::std::shared_ptr<::IceGrid::FileIteratorPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::FileIteratorPrx>>(response, ex, sent, this, &IceGrid::AdminSessionPrx::_iceI_openRegistryStdOut, iceP_name, iceP_count, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_openRegistryStdOut(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::FileIteratorPrx>>>&, const ::std::string&, int, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    AdminSessionPrx() = default;
    friend ::std::shared_ptr<AdminSessionPrx> IceInternal::createProxy<AdminSessionPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ServerState>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 6;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits<::IceGrid::ObjectInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ObjectInfo, S>
{
    static void read(S* istr, ::IceGrid::ObjectInfo& v)
    {
        istr->readAll(v.proxy, v.type);
    }
};

template<>
struct StreamableTraits<::IceGrid::AdapterInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::AdapterInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterInfo& v)
    {
        istr->readAll(v.id, v.proxy, v.replicaGroupId);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServerInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServerInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerInfo& v)
    {
        istr->readAll(v.application, v.uuid, v.revision, v.node, v.descriptor, v.sessionId);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeInfo& v)
    {
        istr->readAll(v.name, v.os, v.hostname, v.release, v.version, v.machine, v.nProcessors, v.dataDir);
    }
};

template<>
struct StreamableTraits<::IceGrid::RegistryInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::RegistryInfo, S>
{
    static void read(S* istr, ::IceGrid::RegistryInfo& v)
    {
        istr->readAll(v.name, v.hostname);
    }
};

template<>
struct StreamableTraits<::IceGrid::LoadInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = true;
};

template<typename S>
struct StreamReader<::IceGrid::LoadInfo, S>
{
    static void read(S* istr, ::IceGrid::LoadInfo& v)
    {
        istr->readAll(v.avg1, v.avg5, v.avg15);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 33;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationInfo& v)
    {
        istr->readAll(v.uuid, v.createTime, v.createUser, v.updateTime, v.updateUser, v.revision, v.descriptor);
    }
};

template<>
struct StreamableTraits<::IceGrid::ApplicationUpdateInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 28;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ApplicationUpdateInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateInfo& v)
    {
        istr->readAll(v.updateTime, v.updateUser, v.revision, v.descriptor);
    }
};

template<>
struct StreamableTraits<::IceGrid::ServerDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::ServerDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerDynamicInfo& v)
    {
        istr->readAll(v.id, v.state, v.pid, v.enabled);
    }
};

template<>
struct StreamableTraits<::IceGrid::AdapterDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::AdapterDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterDynamicInfo& v)
    {
        istr->readAll(v.id, v.proxy);
    }
};

template<>
struct StreamableTraits<::IceGrid::NodeDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 13;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceGrid::NodeDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeDynamicInfo& v)
    {
        istr->readAll(v.info, v.servers, v.adapters);
    }
};

}

namespace IceGrid
{

using AdminPtr = ::std::shared_ptr<Admin>;
using AdminPrxPtr = ::std::shared_ptr<AdminPrx>;

using FileIteratorPtr = ::std::shared_ptr<FileIterator>;
using FileIteratorPrxPtr = ::std::shared_ptr<FileIteratorPrx>;

using RegistryObserverPtr = ::std::shared_ptr<RegistryObserver>;
using RegistryObserverPrxPtr = ::std::shared_ptr<RegistryObserverPrx>;

using NodeObserverPtr = ::std::shared_ptr<NodeObserver>;
using NodeObserverPrxPtr = ::std::shared_ptr<NodeObserverPrx>;

using ApplicationObserverPtr = ::std::shared_ptr<ApplicationObserver>;
using ApplicationObserverPrxPtr = ::std::shared_ptr<ApplicationObserverPrx>;

using AdapterObserverPtr = ::std::shared_ptr<AdapterObserver>;
using AdapterObserverPrxPtr = ::std::shared_ptr<AdapterObserverPrx>;

using ObjectObserverPtr = ::std::shared_ptr<ObjectObserver>;
using ObjectObserverPrxPtr = ::std::shared_ptr<ObjectObserverPrx>;

using AdminSessionPtr = ::std::shared_ptr<AdminSession>;
using AdminSessionPrxPtr = ::std::shared_ptr<AdminSessionPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class Admin;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Admin>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::Admin*);

class FileIterator;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::FileIterator>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::FileIterator*);

class RegistryObserver;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RegistryObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::RegistryObserver*);

class NodeObserver;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::NodeObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::NodeObserver*);

class ApplicationObserver;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ApplicationObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::ApplicationObserver*);

class AdapterObserver;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdapterObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::AdapterObserver*);

class ObjectObserver;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ObjectObserver>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::ObjectObserver*);

class AdminSession;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdminSession>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::AdminSession*);

}

}

namespace IceGrid
{

class Admin;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::Admin*);
typedef ::IceInternal::Handle< ::IceGrid::Admin> AdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Admin> AdminPrx;
typedef AdminPrx AdminPrxPtr;
ICEGRID_API void _icePatchObjectPtr(AdminPtr&, const ::Ice::ObjectPtr&);

class FileIterator;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::FileIterator*);
typedef ::IceInternal::Handle< ::IceGrid::FileIterator> FileIteratorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::FileIterator> FileIteratorPrx;
typedef FileIteratorPrx FileIteratorPrxPtr;
ICEGRID_API void _icePatchObjectPtr(FileIteratorPtr&, const ::Ice::ObjectPtr&);

class RegistryObserver;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::RegistryObserver*);
typedef ::IceInternal::Handle< ::IceGrid::RegistryObserver> RegistryObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::RegistryObserver> RegistryObserverPrx;
typedef RegistryObserverPrx RegistryObserverPrxPtr;
ICEGRID_API void _icePatchObjectPtr(RegistryObserverPtr&, const ::Ice::ObjectPtr&);

class NodeObserver;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::NodeObserver*);
typedef ::IceInternal::Handle< ::IceGrid::NodeObserver> NodeObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::NodeObserver> NodeObserverPrx;
typedef NodeObserverPrx NodeObserverPrxPtr;
ICEGRID_API void _icePatchObjectPtr(NodeObserverPtr&, const ::Ice::ObjectPtr&);

class ApplicationObserver;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::ApplicationObserver*);
typedef ::IceInternal::Handle< ::IceGrid::ApplicationObserver> ApplicationObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ApplicationObserver> ApplicationObserverPrx;
typedef ApplicationObserverPrx ApplicationObserverPrxPtr;
ICEGRID_API void _icePatchObjectPtr(ApplicationObserverPtr&, const ::Ice::ObjectPtr&);

class AdapterObserver;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::AdapterObserver*);
typedef ::IceInternal::Handle< ::IceGrid::AdapterObserver> AdapterObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdapterObserver> AdapterObserverPrx;
typedef AdapterObserverPrx AdapterObserverPrxPtr;
ICEGRID_API void _icePatchObjectPtr(AdapterObserverPtr&, const ::Ice::ObjectPtr&);

class ObjectObserver;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::ObjectObserver*);
typedef ::IceInternal::Handle< ::IceGrid::ObjectObserver> ObjectObserverPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::ObjectObserver> ObjectObserverPrx;
typedef ObjectObserverPrx ObjectObserverPrxPtr;
ICEGRID_API void _icePatchObjectPtr(ObjectObserverPtr&, const ::Ice::ObjectPtr&);

class AdminSession;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::AdminSession*);
typedef ::IceInternal::Handle< ::IceGrid::AdminSession> AdminSessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::AdminSession> AdminSessionPrx;
typedef AdminSessionPrx AdminSessionPrxPtr;
ICEGRID_API void _icePatchObjectPtr(AdminSessionPtr&, const ::Ice::ObjectPtr&);

}

namespace IceGrid
{

enum ServerState
{
    Inactive,
    Activating,
    ActivationTimedOut,
    Active,
    Deactivating,
    Destroying,
    Destroyed
};

typedef ::std::map< ::std::string, ::Ice::ObjectPrx> StringObjectProxyDict;

struct ObjectInfo
{
    ::Ice::ObjectPrx proxy;
    ::std::string type;

    bool operator==(const ObjectInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(proxy != rhs_.proxy)
        {
            return false;
        }
        if(type != rhs_.type)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ObjectInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(proxy < rhs_.proxy)
        {
            return true;
        }
        else if(rhs_.proxy < proxy)
        {
            return false;
        }
        if(type < rhs_.type)
        {
            return true;
        }
        else if(rhs_.type < type)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ObjectInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ObjectInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ObjectInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ObjectInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::ObjectInfo> ObjectInfoSeq;

struct AdapterInfo
{
    ::std::string id;
    ::Ice::ObjectPrx proxy;
    ::std::string replicaGroupId;

    bool operator==(const AdapterInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(proxy != rhs_.proxy)
        {
            return false;
        }
        if(replicaGroupId != rhs_.replicaGroupId)
        {
            return false;
        }
        return true;
    }

    bool operator<(const AdapterInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(proxy < rhs_.proxy)
        {
            return true;
        }
        else if(rhs_.proxy < proxy)
        {
            return false;
        }
        if(replicaGroupId < rhs_.replicaGroupId)
        {
            return true;
        }
        else if(rhs_.replicaGroupId < replicaGroupId)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const AdapterInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const AdapterInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const AdapterInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const AdapterInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::AdapterInfo> AdapterInfoSeq;

struct ServerInfo
{
    ::std::string application;
    ::std::string uuid;
    ::Ice::Int revision;
    ::std::string node;
    ::IceGrid::ServerDescriptorPtr descriptor;
    ::std::string sessionId;
};

struct NodeInfo
{
    ::std::string name;
    ::std::string os;
    ::std::string hostname;
    ::std::string release;
    ::std::string version;
    ::std::string machine;
    ::Ice::Int nProcessors;
    ::std::string dataDir;

    bool operator==(const NodeInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(os != rhs_.os)
        {
            return false;
        }
        if(hostname != rhs_.hostname)
        {
            return false;
        }
        if(release != rhs_.release)
        {
            return false;
        }
        if(version != rhs_.version)
        {
            return false;
        }
        if(machine != rhs_.machine)
        {
            return false;
        }
        if(nProcessors != rhs_.nProcessors)
        {
            return false;
        }
        if(dataDir != rhs_.dataDir)
        {
            return false;
        }
        return true;
    }

    bool operator<(const NodeInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(os < rhs_.os)
        {
            return true;
        }
        else if(rhs_.os < os)
        {
            return false;
        }
        if(hostname < rhs_.hostname)
        {
            return true;
        }
        else if(rhs_.hostname < hostname)
        {
            return false;
        }
        if(release < rhs_.release)
        {
            return true;
        }
        else if(rhs_.release < release)
        {
            return false;
        }
        if(version < rhs_.version)
        {
            return true;
        }
        else if(rhs_.version < version)
        {
            return false;
        }
        if(machine < rhs_.machine)
        {
            return true;
        }
        else if(rhs_.machine < machine)
        {
            return false;
        }
        if(nProcessors < rhs_.nProcessors)
        {
            return true;
        }
        else if(rhs_.nProcessors < nProcessors)
        {
            return false;
        }
        if(dataDir < rhs_.dataDir)
        {
            return true;
        }
        else if(rhs_.dataDir < dataDir)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const NodeInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const NodeInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const NodeInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const NodeInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

struct RegistryInfo
{
    ::std::string name;
    ::std::string hostname;

    bool operator==(const RegistryInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(hostname != rhs_.hostname)
        {
            return false;
        }
        return true;
    }

    bool operator<(const RegistryInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(hostname < rhs_.hostname)
        {
            return true;
        }
        else if(rhs_.hostname < hostname)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const RegistryInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const RegistryInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const RegistryInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const RegistryInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::RegistryInfo> RegistryInfoSeq;

struct LoadInfo
{
    ::Ice::Float avg1;
    ::Ice::Float avg5;
    ::Ice::Float avg15;
};

struct ApplicationInfo
{
    ::std::string uuid;
    ::Ice::Long createTime;
    ::std::string createUser;
    ::Ice::Long updateTime;
    ::std::string updateUser;
    ::Ice::Int revision;
    ::IceGrid::ApplicationDescriptor descriptor;
};

typedef ::std::vector< ::IceGrid::ApplicationInfo> ApplicationInfoSeq;

struct ApplicationUpdateInfo
{
    ::Ice::Long updateTime;
    ::std::string updateUser;
    ::Ice::Int revision;
    ::IceGrid::ApplicationUpdateDescriptor descriptor;
};

struct ServerDynamicInfo
{
    ::std::string id;
    ::IceGrid::ServerState state;
    ::Ice::Int pid;
    bool enabled;

    bool operator==(const ServerDynamicInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(id != rhs_.id)
        {
            return false;
        }
        if(state != rhs_.state)
        {
            return false;
        }
        if(pid != rhs_.pid)
        {
            return false;
        }
        if(enabled != rhs_.enabled)
        {
            return false;
        }
        return true;
    }

    bool operator<(const ServerDynamicInfo& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(id < rhs_.id)
        {
            return true;
        }
        else if(rhs_.id < id)
        {
            return false;
        }
        if(state < rhs_.state)
        {
            return true;
        }
        else if(rhs_.state < state)
        {
            return false;
        }
        if(pid < rhs_.pid)
        {
            return true;
        }
        else if(rhs_.pid < pid)
        {
            return false;
        }
        if(enabled < rhs_.enabled)
        {
            return true;
        }
        else if(rhs_.enabled < enabled)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const ServerDynamicInfo& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const ServerDynamicInfo& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const ServerDynamicInfo& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const ServerDynamicInfo& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::vector< ::IceGrid::ServerDynamicInfo> ServerDynamicInfoSeq;

struct AdapterDynamicInfo
{
    ::std::string id;
    ::Ice::ObjectPrx proxy;
};

typedef ::std::vector< ::IceGrid::AdapterDynamicInfo> AdapterDynamicInfoSeq;

struct NodeDynamicInfo
{
    ::IceGrid::NodeInfo info;
    ::IceGrid::ServerDynamicInfoSeq servers;
    ::IceGrid::AdapterDynamicInfoSeq adapters;
};

typedef ::std::vector< ::IceGrid::NodeDynamicInfo> NodeDynamicInfoSeq;

}

namespace IceGrid
{

class ICEGRID_API AMD_Admin_patchApplication : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_patchApplication();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_patchApplication> AMD_Admin_patchApplicationPtr;

class ICEGRID_API AMD_Admin_startServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_startServer();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_startServer> AMD_Admin_startServerPtr;

class ICEGRID_API AMD_Admin_stopServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_stopServer();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_stopServer> AMD_Admin_stopServerPtr;

class ICEGRID_API AMD_Admin_patchServer : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Admin_patchServer();

    virtual void ice_response() = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Admin_patchServer> AMD_Admin_patchServerPtr;

}

namespace IceAsync
{

namespace IceGrid
{

class ICEGRID_API AMD_Admin_patchApplication : public ::IceGrid::AMD_Admin_patchApplication, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_patchApplication(::IceInternal::Incoming&);

    virtual void ice_response();
};

class ICEGRID_API AMD_Admin_startServer : public ::IceGrid::AMD_Admin_startServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_startServer(::IceInternal::Incoming&);

    virtual void ice_response();
};

class ICEGRID_API AMD_Admin_stopServer : public ::IceGrid::AMD_Admin_stopServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_stopServer(::IceInternal::Incoming&);

    virtual void ice_response();
};

class ICEGRID_API AMD_Admin_patchServer : public ::IceGrid::AMD_Admin_patchServer, public ::IceInternal::IncomingAsync
{
public:

    AMD_Admin_patchServer(::IceInternal::Incoming&);

    virtual void ice_response();
};

}

}

namespace IceGrid
{

class Callback_Admin_addApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_addApplication_Base> Callback_Admin_addApplicationPtr;

class Callback_Admin_syncApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_syncApplication_Base> Callback_Admin_syncApplicationPtr;

class Callback_Admin_updateApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_updateApplication_Base> Callback_Admin_updateApplicationPtr;

class Callback_Admin_syncApplicationWithoutRestart_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_syncApplicationWithoutRestart_Base> Callback_Admin_syncApplicationWithoutRestartPtr;

class Callback_Admin_updateApplicationWithoutRestart_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_updateApplicationWithoutRestart_Base> Callback_Admin_updateApplicationWithoutRestartPtr;

class Callback_Admin_removeApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_removeApplication_Base> Callback_Admin_removeApplicationPtr;

class Callback_Admin_instantiateServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_instantiateServer_Base> Callback_Admin_instantiateServerPtr;

class Callback_Admin_patchApplication_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_patchApplication_Base> Callback_Admin_patchApplicationPtr;

class Callback_Admin_getApplicationInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getApplicationInfo_Base> Callback_Admin_getApplicationInfoPtr;

class Callback_Admin_getDefaultApplicationDescriptor_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getDefaultApplicationDescriptor_Base> Callback_Admin_getDefaultApplicationDescriptorPtr;

class Callback_Admin_getAllApplicationNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllApplicationNames_Base> Callback_Admin_getAllApplicationNamesPtr;

class Callback_Admin_getServerInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerInfo_Base> Callback_Admin_getServerInfoPtr;

class Callback_Admin_getServerState_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerState_Base> Callback_Admin_getServerStatePtr;

class Callback_Admin_getServerPid_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerPid_Base> Callback_Admin_getServerPidPtr;

class Callback_Admin_getServerAdminCategory_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerAdminCategory_Base> Callback_Admin_getServerAdminCategoryPtr;

class Callback_Admin_getServerAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getServerAdmin_Base> Callback_Admin_getServerAdminPtr;

class Callback_Admin_enableServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_enableServer_Base> Callback_Admin_enableServerPtr;

class Callback_Admin_isServerEnabled_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_isServerEnabled_Base> Callback_Admin_isServerEnabledPtr;

class Callback_Admin_startServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_startServer_Base> Callback_Admin_startServerPtr;

class Callback_Admin_stopServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_stopServer_Base> Callback_Admin_stopServerPtr;

class Callback_Admin_patchServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_patchServer_Base> Callback_Admin_patchServerPtr;

class Callback_Admin_sendSignal_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_sendSignal_Base> Callback_Admin_sendSignalPtr;

class Callback_Admin_getAllServerIds_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllServerIds_Base> Callback_Admin_getAllServerIdsPtr;

class Callback_Admin_getAdapterInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAdapterInfo_Base> Callback_Admin_getAdapterInfoPtr;

class Callback_Admin_removeAdapter_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_removeAdapter_Base> Callback_Admin_removeAdapterPtr;

class Callback_Admin_getAllAdapterIds_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllAdapterIds_Base> Callback_Admin_getAllAdapterIdsPtr;

class Callback_Admin_addObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_addObject_Base> Callback_Admin_addObjectPtr;

class Callback_Admin_updateObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_updateObject_Base> Callback_Admin_updateObjectPtr;

class Callback_Admin_addObjectWithType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_addObjectWithType_Base> Callback_Admin_addObjectWithTypePtr;

class Callback_Admin_removeObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_removeObject_Base> Callback_Admin_removeObjectPtr;

class Callback_Admin_getObjectInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getObjectInfo_Base> Callback_Admin_getObjectInfoPtr;

class Callback_Admin_getObjectInfosByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getObjectInfosByType_Base> Callback_Admin_getObjectInfosByTypePtr;

class Callback_Admin_getAllObjectInfos_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllObjectInfos_Base> Callback_Admin_getAllObjectInfosPtr;

class Callback_Admin_pingNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_pingNode_Base> Callback_Admin_pingNodePtr;

class Callback_Admin_getNodeLoad_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeLoad_Base> Callback_Admin_getNodeLoadPtr;

class Callback_Admin_getNodeInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeInfo_Base> Callback_Admin_getNodeInfoPtr;

class Callback_Admin_getNodeAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeAdmin_Base> Callback_Admin_getNodeAdminPtr;

class Callback_Admin_getNodeProcessorSocketCount_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeProcessorSocketCount_Base> Callback_Admin_getNodeProcessorSocketCountPtr;

class Callback_Admin_shutdownNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_shutdownNode_Base> Callback_Admin_shutdownNodePtr;

class Callback_Admin_getNodeHostname_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getNodeHostname_Base> Callback_Admin_getNodeHostnamePtr;

class Callback_Admin_getAllNodeNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllNodeNames_Base> Callback_Admin_getAllNodeNamesPtr;

class Callback_Admin_pingRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_pingRegistry_Base> Callback_Admin_pingRegistryPtr;

class Callback_Admin_getRegistryInfo_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getRegistryInfo_Base> Callback_Admin_getRegistryInfoPtr;

class Callback_Admin_getRegistryAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getRegistryAdmin_Base> Callback_Admin_getRegistryAdminPtr;

class Callback_Admin_shutdownRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_shutdownRegistry_Base> Callback_Admin_shutdownRegistryPtr;

class Callback_Admin_getAllRegistryNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getAllRegistryNames_Base> Callback_Admin_getAllRegistryNamesPtr;

class Callback_Admin_shutdown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_shutdown_Base> Callback_Admin_shutdownPtr;

class Callback_Admin_getSliceChecksums_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Admin_getSliceChecksums_Base> Callback_Admin_getSliceChecksumsPtr;

class Callback_FileIterator_read_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileIterator_read_Base> Callback_FileIterator_readPtr;

class Callback_FileIterator_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_FileIterator_destroy_Base> Callback_FileIterator_destroyPtr;

class Callback_RegistryObserver_registryInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RegistryObserver_registryInit_Base> Callback_RegistryObserver_registryInitPtr;

class Callback_RegistryObserver_registryUp_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RegistryObserver_registryUp_Base> Callback_RegistryObserver_registryUpPtr;

class Callback_RegistryObserver_registryDown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_RegistryObserver_registryDown_Base> Callback_RegistryObserver_registryDownPtr;

class Callback_NodeObserver_nodeInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_nodeInit_Base> Callback_NodeObserver_nodeInitPtr;

class Callback_NodeObserver_nodeUp_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_nodeUp_Base> Callback_NodeObserver_nodeUpPtr;

class Callback_NodeObserver_nodeDown_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_nodeDown_Base> Callback_NodeObserver_nodeDownPtr;

class Callback_NodeObserver_updateServer_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_updateServer_Base> Callback_NodeObserver_updateServerPtr;

class Callback_NodeObserver_updateAdapter_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_NodeObserver_updateAdapter_Base> Callback_NodeObserver_updateAdapterPtr;

class Callback_ApplicationObserver_applicationInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationInit_Base> Callback_ApplicationObserver_applicationInitPtr;

class Callback_ApplicationObserver_applicationAdded_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationAdded_Base> Callback_ApplicationObserver_applicationAddedPtr;

class Callback_ApplicationObserver_applicationRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationRemoved_Base> Callback_ApplicationObserver_applicationRemovedPtr;

class Callback_ApplicationObserver_applicationUpdated_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ApplicationObserver_applicationUpdated_Base> Callback_ApplicationObserver_applicationUpdatedPtr;

class Callback_AdapterObserver_adapterInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterInit_Base> Callback_AdapterObserver_adapterInitPtr;

class Callback_AdapterObserver_adapterAdded_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterAdded_Base> Callback_AdapterObserver_adapterAddedPtr;

class Callback_AdapterObserver_adapterUpdated_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterUpdated_Base> Callback_AdapterObserver_adapterUpdatedPtr;

class Callback_AdapterObserver_adapterRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdapterObserver_adapterRemoved_Base> Callback_AdapterObserver_adapterRemovedPtr;

class Callback_ObjectObserver_objectInit_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectInit_Base> Callback_ObjectObserver_objectInitPtr;

class Callback_ObjectObserver_objectAdded_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectAdded_Base> Callback_ObjectObserver_objectAddedPtr;

class Callback_ObjectObserver_objectUpdated_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectUpdated_Base> Callback_ObjectObserver_objectUpdatedPtr;

class Callback_ObjectObserver_objectRemoved_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_ObjectObserver_objectRemoved_Base> Callback_ObjectObserver_objectRemovedPtr;

class Callback_AdminSession_keepAlive_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_keepAlive_Base> Callback_AdminSession_keepAlivePtr;

class Callback_AdminSession_getAdmin_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_getAdmin_Base> Callback_AdminSession_getAdminPtr;

class Callback_AdminSession_getAdminCallbackTemplate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_getAdminCallbackTemplate_Base> Callback_AdminSession_getAdminCallbackTemplatePtr;

class Callback_AdminSession_setObservers_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_setObservers_Base> Callback_AdminSession_setObserversPtr;

class Callback_AdminSession_setObserversByIdentity_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_setObserversByIdentity_Base> Callback_AdminSession_setObserversByIdentityPtr;

class Callback_AdminSession_startUpdate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_startUpdate_Base> Callback_AdminSession_startUpdatePtr;

class Callback_AdminSession_finishUpdate_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_finishUpdate_Base> Callback_AdminSession_finishUpdatePtr;

class Callback_AdminSession_getReplicaName_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_getReplicaName_Base> Callback_AdminSession_getReplicaNamePtr;

class Callback_AdminSession_openServerLog_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openServerLog_Base> Callback_AdminSession_openServerLogPtr;

class Callback_AdminSession_openServerStdErr_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openServerStdErr_Base> Callback_AdminSession_openServerStdErrPtr;

class Callback_AdminSession_openServerStdOut_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openServerStdOut_Base> Callback_AdminSession_openServerStdOutPtr;

class Callback_AdminSession_openNodeStdErr_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openNodeStdErr_Base> Callback_AdminSession_openNodeStdErrPtr;

class Callback_AdminSession_openNodeStdOut_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openNodeStdOut_Base> Callback_AdminSession_openNodeStdOutPtr;

class Callback_AdminSession_openRegistryStdErr_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openRegistryStdErr_Base> Callback_AdminSession_openRegistryStdErrPtr;

class Callback_AdminSession_openRegistryStdOut_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_AdminSession_openRegistryStdOut_Base> Callback_AdminSession_openRegistryStdOutPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) Admin : public virtual ::Ice::Proxy<Admin, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) void addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addApplication(_iceI_begin_addApplication(iceP_descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addApplication(iceP_descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(iceP_descriptor, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::IceGrid::Callback_Admin_addApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_addApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addApplication(iceP_descriptor, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_addApplication(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_addApplication(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_syncApplication(_iceI_begin_syncApplication(iceP_descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_syncApplication(iceP_descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(iceP_descriptor, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::IceGrid::Callback_Admin_syncApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_syncApplication(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_syncApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplication(iceP_descriptor, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_syncApplication(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_syncApplication(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateApplication(_iceI_begin_updateApplication(iceP_descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateApplication(iceP_descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(iceP_descriptor, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::IceGrid::Callback_Admin_updateApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_updateApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplication(iceP_descriptor, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_updateApplication(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateApplication(const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_syncApplicationWithoutRestart(_iceI_begin_syncApplicationWithoutRestart(iceP_descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_syncApplicationWithoutRestart(iceP_descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(iceP_descriptor, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::IceGrid::Callback_Admin_syncApplicationWithoutRestartPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_syncApplicationWithoutRestartPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_syncApplicationWithoutRestart(iceP_descriptor, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_syncApplicationWithoutRestart(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateApplicationWithoutRestart(_iceI_begin_updateApplicationWithoutRestart(iceP_descriptor, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateApplicationWithoutRestart(iceP_descriptor, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(iceP_descriptor, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::IceGrid::Callback_Admin_updateApplicationWithoutRestartPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(iceP_descriptor, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor& iceP_descriptor, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_updateApplicationWithoutRestartPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateApplicationWithoutRestart(iceP_descriptor, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_updateApplicationWithoutRestart(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void removeApplication(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeApplication(_iceI_begin_removeApplication(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeApplication(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_removeApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeApplication(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_removeApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeApplication(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_removeApplication(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_removeApplication(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_instantiateServer(_iceI_begin_instantiateServer(iceP_application, iceP_node, iceP_desc, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_instantiateServer(iceP_application, iceP_node, iceP_desc, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(iceP_application, iceP_node, iceP_desc, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(iceP_application, iceP_node, iceP_desc, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::IceGrid::Callback_Admin_instantiateServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(iceP_application, iceP_node, iceP_desc, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_instantiateServer(const ::std::string& iceP_application, const ::std::string& iceP_node, const ::IceGrid::ServerInstanceDescriptor& iceP_desc, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_instantiateServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_instantiateServer(iceP_application, iceP_node, iceP_desc, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_instantiateServer(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_instantiateServer(const ::std::string&, const ::std::string&, const ::IceGrid::ServerInstanceDescriptor&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_patchApplication(_iceI_begin_patchApplication(iceP_name, iceP_shutdown, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_patchApplication(iceP_name, iceP_shutdown, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(iceP_name, iceP_shutdown, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(iceP_name, iceP_shutdown, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::IceGrid::Callback_Admin_patchApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(iceP_name, iceP_shutdown, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_patchApplication(const ::std::string& iceP_name, bool iceP_shutdown, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_patchApplicationPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchApplication(iceP_name, iceP_shutdown, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_patchApplication(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_patchApplication(const ::std::string&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationInfo getApplicationInfo(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getApplicationInfo(_iceI_begin_getApplicationInfo(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getApplicationInfo(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getApplicationInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getApplicationInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getApplicationInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getApplicationInfo(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationInfo end_getApplicationInfo(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getApplicationInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getDefaultApplicationDescriptor(_iceI_begin_getDefaultApplicationDescriptor(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::IceGrid::Callback_Admin_getDefaultApplicationDescriptorPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getDefaultApplicationDescriptor(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getDefaultApplicationDescriptorPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getDefaultApplicationDescriptor(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ApplicationDescriptor end_getDefaultApplicationDescriptor(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getDefaultApplicationDescriptor(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllApplicationNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllApplicationNames(_iceI_begin_getAllApplicationNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllApplicationNames(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::IceGrid::Callback_Admin_getAllApplicationNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllApplicationNames(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllApplicationNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllApplicationNames(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllApplicationNames(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllApplicationNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerInfo getServerInfo(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerInfo(_iceI_begin_getServerInfo(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerInfo(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_getServerInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerInfo(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerInfo(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerInfo end_getServerInfo(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerState getServerState(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerState(_iceI_begin_getServerState(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerState(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_getServerStatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerState(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerStatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerState(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ServerState end_getServerState(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerState(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::Int getServerPid(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerPid(_iceI_begin_getServerPid(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerPid(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_getServerPidPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerPid(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerPidPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerPid(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getServerPid(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerPid(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::std::string getServerAdminCategory(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerAdminCategory(_iceI_begin_getServerAdminCategory(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerAdminCategory(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::IceGrid::Callback_Admin_getServerAdminCategoryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerAdminCategory(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerAdminCategoryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdminCategory(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::std::string end_getServerAdminCategory(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerAdminCategory(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getServerAdmin(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getServerAdmin(_iceI_begin_getServerAdmin(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getServerAdmin(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_getServerAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getServerAdmin(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getServerAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getServerAdmin(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getServerAdmin(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getServerAdmin(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_enableServer(_iceI_begin_enableServer(iceP_id, iceP_enabled, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_enableServer(iceP_id, iceP_enabled, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(iceP_id, iceP_enabled, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(iceP_id, iceP_enabled, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::IceGrid::Callback_Admin_enableServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(iceP_id, iceP_enabled, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_enableServer(const ::std::string& iceP_id, bool iceP_enabled, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_enableServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableServer(iceP_id, iceP_enabled, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_enableServer(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_enableServer(const ::std::string&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) bool isServerEnabled(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_isServerEnabled(_iceI_begin_isServerEnabled(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_isServerEnabled(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_isServerEnabledPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_isServerEnabled(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_isServerEnabledPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_isServerEnabled(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) bool end_isServerEnabled(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_isServerEnabled(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void startServer(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_startServer(_iceI_begin_startServer(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_startServer(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_startServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startServer(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_startServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startServer(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_startServer(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_startServer(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void stopServer(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_stopServer(_iceI_begin_stopServer(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_stopServer(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_stopServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_stopServer(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_stopServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_stopServer(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_stopServer(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_stopServer(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_patchServer(_iceI_begin_patchServer(iceP_id, iceP_shutdown, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_patchServer(iceP_id, iceP_shutdown, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(iceP_id, iceP_shutdown, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(iceP_id, iceP_shutdown, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::IceGrid::Callback_Admin_patchServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(iceP_id, iceP_shutdown, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_patchServer(const ::std::string& iceP_id, bool iceP_shutdown, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_patchServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_patchServer(iceP_id, iceP_shutdown, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_patchServer(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_patchServer(const ::std::string&, bool, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_sendSignal(_iceI_begin_sendSignal(iceP_id, iceP_signal, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_sendSignal(iceP_id, iceP_signal, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(iceP_id, iceP_signal, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(iceP_id, iceP_signal, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::IceGrid::Callback_Admin_sendSignalPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(iceP_id, iceP_signal, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_sendSignal(const ::std::string& iceP_id, const ::std::string& iceP_signal, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_sendSignalPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_sendSignal(iceP_id, iceP_signal, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_sendSignal(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_sendSignal(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllServerIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllServerIds(_iceI_begin_getAllServerIds(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllServerIds(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::IceGrid::Callback_Admin_getAllServerIdsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllServerIds(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllServerIdsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllServerIds(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllServerIds(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllServerIds(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdapterInfoSeq getAdapterInfo(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAdapterInfo(_iceI_begin_getAdapterInfo(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAdapterInfo(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_getAdapterInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdapterInfo(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAdapterInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdapterInfo(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdapterInfoSeq end_getAdapterInfo(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAdapterInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void removeAdapter(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeAdapter(_iceI_begin_removeAdapter(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeAdapter(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& iceP_id, const ::IceGrid::Callback_Admin_removeAdapterPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeAdapter(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_removeAdapterPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeAdapter(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_removeAdapter(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_removeAdapter(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllAdapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllAdapterIds(_iceI_begin_getAllAdapterIds(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllAdapterIds(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::IceGrid::Callback_Admin_getAllAdapterIdsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllAdapterIds(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllAdapterIdsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllAdapterIds(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllAdapterIds(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllAdapterIds(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void addObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addObject(_iceI_begin_addObject(iceP_obj, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addObject(iceP_obj, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(iceP_obj, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(iceP_obj, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& iceP_obj, const ::IceGrid::Callback_Admin_addObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(iceP_obj, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_addObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObject(iceP_obj, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_addObject(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_addObject(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void updateObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateObject(_iceI_begin_updateObject(iceP_obj, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateObject(iceP_obj, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(iceP_obj, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(iceP_obj, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& iceP_obj, const ::IceGrid::Callback_Admin_updateObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(iceP_obj, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateObject(const ::Ice::ObjectPrx& iceP_obj, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_updateObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateObject(iceP_obj, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_updateObject(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateObject(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void addObjectWithType(const ::Ice::ObjectPrx& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_addObjectWithType(_iceI_begin_addObjectWithType(iceP_obj, iceP_type, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_addObjectWithType(iceP_obj, iceP_type, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& iceP_obj, const ::std::string& iceP_type, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(iceP_obj, iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(iceP_obj, iceP_type, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& iceP_obj, const ::std::string& iceP_type, const ::IceGrid::Callback_Admin_addObjectWithTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(iceP_obj, iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_addObjectWithType(const ::Ice::ObjectPrx& iceP_obj, const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_addObjectWithTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_addObjectWithType(iceP_obj, iceP_type, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_addObjectWithType(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_addObjectWithType(const ::Ice::ObjectPrx&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void removeObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_removeObject(_iceI_begin_removeObject(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_removeObject(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& iceP_id, const ::IceGrid::Callback_Admin_removeObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_removeObject(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_removeObjectPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_removeObject(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_removeObject(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_removeObject(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfo getObjectInfo(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getObjectInfo(_iceI_begin_getObjectInfo(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getObjectInfo(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& iceP_id, const ::IceGrid::Callback_Admin_getObjectInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfo(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getObjectInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfo(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfo end_getObjectInfo(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getObjectInfo(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq getObjectInfosByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getObjectInfosByType(_iceI_begin_getObjectInfosByType(iceP_type, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getObjectInfosByType(iceP_type, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& iceP_type, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(iceP_type, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& iceP_type, const ::IceGrid::Callback_Admin_getObjectInfosByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getObjectInfosByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getObjectInfosByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getObjectInfosByType(iceP_type, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq end_getObjectInfosByType(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getObjectInfosByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq getAllObjectInfos(const ::std::string& iceP_expr, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllObjectInfos(_iceI_begin_getAllObjectInfos(iceP_expr, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& iceP_expr, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllObjectInfos(iceP_expr, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& iceP_expr, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(iceP_expr, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& iceP_expr, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(iceP_expr, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& iceP_expr, const ::IceGrid::Callback_Admin_getAllObjectInfosPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(iceP_expr, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllObjectInfos(const ::std::string& iceP_expr, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllObjectInfosPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllObjectInfos(iceP_expr, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::ObjectInfoSeq end_getAllObjectInfos(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllObjectInfos(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) bool pingNode(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_pingNode(_iceI_begin_pingNode(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_pingNode(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_pingNodePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_pingNode(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_pingNodePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingNode(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) bool end_pingNode(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_pingNode(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::LoadInfo getNodeLoad(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeLoad(_iceI_begin_getNodeLoad(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeLoad(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getNodeLoadPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeLoad(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeLoadPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeLoad(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::LoadInfo end_getNodeLoad(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeLoad(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::NodeInfo getNodeInfo(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeInfo(_iceI_begin_getNodeInfo(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeInfo(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getNodeInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeInfo(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::NodeInfo end_getNodeInfo(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getNodeAdmin(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeAdmin(_iceI_begin_getNodeAdmin(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeAdmin(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getNodeAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeAdmin(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeAdmin(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getNodeAdmin(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeAdmin(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::Int getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeProcessorSocketCount(_iceI_begin_getNodeProcessorSocketCount(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeProcessorSocketCount(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getNodeProcessorSocketCountPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeProcessorSocketCount(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeProcessorSocketCountPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeProcessorSocketCount(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getNodeProcessorSocketCount(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeProcessorSocketCount(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void shutdownNode(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdownNode(_iceI_begin_shutdownNode(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdownNode(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_shutdownNodePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdownNode(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_shutdownNodePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownNode(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_shutdownNode(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_shutdownNode(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::std::string getNodeHostname(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getNodeHostname(_iceI_begin_getNodeHostname(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getNodeHostname(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getNodeHostnamePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getNodeHostname(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getNodeHostnamePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getNodeHostname(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::std::string end_getNodeHostname(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getNodeHostname(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllNodeNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllNodeNames(_iceI_begin_getAllNodeNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllNodeNames(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::IceGrid::Callback_Admin_getAllNodeNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllNodeNames(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllNodeNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllNodeNames(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllNodeNames(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllNodeNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) bool pingRegistry(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_pingRegistry(_iceI_begin_pingRegistry(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_pingRegistry(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_pingRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_pingRegistry(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_pingRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_pingRegistry(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) bool end_pingRegistry(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_pingRegistry(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryInfo getRegistryInfo(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegistryInfo(_iceI_begin_getRegistryInfo(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegistryInfo(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getRegistryInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistryInfo(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getRegistryInfoPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryInfo(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryInfo end_getRegistryInfo(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getRegistryInfo(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getRegistryAdmin(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getRegistryAdmin(_iceI_begin_getRegistryAdmin(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getRegistryAdmin(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_getRegistryAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getRegistryAdmin(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getRegistryAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getRegistryAdmin(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getRegistryAdmin(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getRegistryAdmin(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void shutdownRegistry(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdownRegistry(_iceI_begin_shutdownRegistry(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdownRegistry(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& iceP_name, const ::IceGrid::Callback_Admin_shutdownRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdownRegistry(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_Admin_shutdownRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdownRegistry(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_shutdownRegistry(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_shutdownRegistry(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq getAllRegistryNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAllRegistryNames(_iceI_begin_getAllRegistryNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAllRegistryNames(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::IceGrid::Callback_Admin_getAllRegistryNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAllRegistryNames(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getAllRegistryNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAllRegistryNames(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::StringSeq end_getAllRegistryNames(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAllRegistryNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_shutdown(_iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_shutdown(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::IceGrid::Callback_Admin_shutdownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_shutdown(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_shutdownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_shutdown(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_shutdown(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_shutdown(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSliceChecksums(_iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSliceChecksums(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::IceGrid::Callback_Admin_getSliceChecksumsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSliceChecksums(const ::Ice::Context& context, const ::IceGrid::Callback_Admin_getSliceChecksumsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSliceChecksums(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::SliceChecksumDict end_getSliceChecksums(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getSliceChecksums(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) FileIterator : public virtual ::Ice::Proxy<FileIterator, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) bool read(::Ice::Int iceP_size, ::Ice::StringSeq& iceP_lines, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_read(iceP_lines, _iceI_begin_read(iceP_size, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_read(::Ice::Int iceP_size, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_read(iceP_size, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_read(::Ice::Int iceP_size, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(iceP_size, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_read(::Ice::Int iceP_size, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(iceP_size, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_read(::Ice::Int iceP_size, const ::IceGrid::Callback_FileIterator_readPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(iceP_size, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_read(::Ice::Int iceP_size, const ::Ice::Context& context, const ::IceGrid::Callback_FileIterator_readPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_read(iceP_size, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) bool end_read(::Ice::StringSeq& iceP_lines, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_read(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::IceGrid::Callback_FileIterator_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::IceGrid::Callback_FileIterator_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_destroy(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) RegistryObserver : public virtual ::Ice::Proxy<RegistryObserver, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) void registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registryInit(_iceI_begin_registryInit(iceP_registries, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registryInit(iceP_registries, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(iceP_registries, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(iceP_registries, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::IceGrid::Callback_RegistryObserver_registryInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(iceP_registries, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryInit(const ::IceGrid::RegistryInfoSeq& iceP_registries, const ::Ice::Context& context, const ::IceGrid::Callback_RegistryObserver_registryInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryInit(iceP_registries, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_registryInit(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_registryInit(const ::IceGrid::RegistryInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registryUp(_iceI_begin_registryUp(iceP_node, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registryUp(iceP_node, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(iceP_node, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(iceP_node, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::IceGrid::Callback_RegistryObserver_registryUpPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(iceP_node, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryUp(const ::IceGrid::RegistryInfo& iceP_node, const ::Ice::Context& context, const ::IceGrid::Callback_RegistryObserver_registryUpPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryUp(iceP_node, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_registryUp(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_registryUp(const ::IceGrid::RegistryInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void registryDown(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_registryDown(_iceI_begin_registryDown(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_registryDown(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& iceP_name, const ::IceGrid::Callback_RegistryObserver_registryDownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_registryDown(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_RegistryObserver_registryDownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_registryDown(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_registryDown(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_registryDown(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) NodeObserver : public virtual ::Ice::Proxy<NodeObserver, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) void nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_nodeInit(_iceI_begin_nodeInit(iceP_nodes, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nodeInit(iceP_nodes, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(iceP_nodes, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(iceP_nodes, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::IceGrid::Callback_NodeObserver_nodeInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(iceP_nodes, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq& iceP_nodes, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_nodeInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeInit(iceP_nodes, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_nodeInit(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_nodeInit(const ::IceGrid::NodeDynamicInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_nodeUp(_iceI_begin_nodeUp(iceP_node, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nodeUp(iceP_node, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(iceP_node, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(iceP_node, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::IceGrid::Callback_NodeObserver_nodeUpPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(iceP_node, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeUp(const ::IceGrid::NodeDynamicInfo& iceP_node, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_nodeUpPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeUp(iceP_node, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_nodeUp(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_nodeUp(const ::IceGrid::NodeDynamicInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void nodeDown(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_nodeDown(_iceI_begin_nodeDown(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_nodeDown(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& iceP_name, const ::IceGrid::Callback_NodeObserver_nodeDownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_nodeDown(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_nodeDownPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_nodeDown(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_nodeDown(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_nodeDown(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateServer(_iceI_begin_updateServer(iceP_node, iceP_updatedInfo, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateServer(iceP_node, iceP_updatedInfo, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(iceP_node, iceP_updatedInfo, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(iceP_node, iceP_updatedInfo, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::IceGrid::Callback_NodeObserver_updateServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(iceP_node, iceP_updatedInfo, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateServer(const ::std::string& iceP_node, const ::IceGrid::ServerDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_updateServerPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateServer(iceP_node, iceP_updatedInfo, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_updateServer(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateServer(const ::std::string&, const ::IceGrid::ServerDynamicInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_updateAdapter(_iceI_begin_updateAdapter(iceP_node, iceP_updatedInfo, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_updateAdapter(iceP_node, iceP_updatedInfo, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(iceP_node, iceP_updatedInfo, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(iceP_node, iceP_updatedInfo, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::IceGrid::Callback_NodeObserver_updateAdapterPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(iceP_node, iceP_updatedInfo, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_updateAdapter(const ::std::string& iceP_node, const ::IceGrid::AdapterDynamicInfo& iceP_updatedInfo, const ::Ice::Context& context, const ::IceGrid::Callback_NodeObserver_updateAdapterPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_updateAdapter(iceP_node, iceP_updatedInfo, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_updateAdapter(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_updateAdapter(const ::std::string&, const ::IceGrid::AdapterDynamicInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) ApplicationObserver : public virtual ::Ice::Proxy<ApplicationObserver, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) void applicationInit(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationInit(_iceI_begin_applicationInit(iceP_serial, iceP_applications, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationInit(iceP_serial, iceP_applications, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(iceP_serial, iceP_applications, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(iceP_serial, iceP_applications, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::IceGrid::Callback_ApplicationObserver_applicationInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(iceP_serial, iceP_applications, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationInit(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfoSeq& iceP_applications, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationInit(iceP_serial, iceP_applications, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_applicationInit(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationInit(::Ice::Int, const ::IceGrid::ApplicationInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void applicationAdded(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationAdded(_iceI_begin_applicationAdded(iceP_serial, iceP_desc, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationAdded(iceP_serial, iceP_desc, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(iceP_serial, iceP_desc, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(iceP_serial, iceP_desc, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::IceGrid::Callback_ApplicationObserver_applicationAddedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(iceP_serial, iceP_desc, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationAdded(::Ice::Int iceP_serial, const ::IceGrid::ApplicationInfo& iceP_desc, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationAddedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationAdded(iceP_serial, iceP_desc, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_applicationAdded(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationAdded(::Ice::Int, const ::IceGrid::ApplicationInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void applicationRemoved(::Ice::Int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationRemoved(_iceI_begin_applicationRemoved(iceP_serial, iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationRemoved(iceP_serial, iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int iceP_serial, const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(iceP_serial, iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(iceP_serial, iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int iceP_serial, const ::std::string& iceP_name, const ::IceGrid::Callback_ApplicationObserver_applicationRemovedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(iceP_serial, iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationRemoved(::Ice::Int iceP_serial, const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationRemovedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationRemoved(iceP_serial, iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_applicationRemoved(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationRemoved(::Ice::Int, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void applicationUpdated(::Ice::Int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_applicationUpdated(_iceI_begin_applicationUpdated(iceP_serial, iceP_desc, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_applicationUpdated(iceP_serial, iceP_desc, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(iceP_serial, iceP_desc, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(iceP_serial, iceP_desc, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::IceGrid::Callback_ApplicationObserver_applicationUpdatedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(iceP_serial, iceP_desc, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_applicationUpdated(::Ice::Int iceP_serial, const ::IceGrid::ApplicationUpdateInfo& iceP_desc, const ::Ice::Context& context, const ::IceGrid::Callback_ApplicationObserver_applicationUpdatedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_applicationUpdated(iceP_serial, iceP_desc, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_applicationUpdated(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_applicationUpdated(::Ice::Int, const ::IceGrid::ApplicationUpdateInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) AdapterObserver : public virtual ::Ice::Proxy<AdapterObserver, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) void adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterInit(_iceI_begin_adapterInit(iceP_adpts, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterInit(iceP_adpts, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(iceP_adpts, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(iceP_adpts, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::IceGrid::Callback_AdapterObserver_adapterInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(iceP_adpts, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterInit(const ::IceGrid::AdapterInfoSeq& iceP_adpts, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterInit(iceP_adpts, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_adapterInit(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterInit(const ::IceGrid::AdapterInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterAdded(_iceI_begin_adapterAdded(iceP_info, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterAdded(iceP_info, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(iceP_info, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::IceGrid::Callback_AdapterObserver_adapterAddedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterAdded(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterAddedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterAdded(iceP_info, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_adapterAdded(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterAdded(const ::IceGrid::AdapterInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterUpdated(_iceI_begin_adapterUpdated(iceP_info, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterUpdated(iceP_info, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(iceP_info, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::IceGrid::Callback_AdapterObserver_adapterUpdatedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterUpdated(const ::IceGrid::AdapterInfo& iceP_info, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterUpdatedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterUpdated(iceP_info, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_adapterUpdated(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterUpdated(const ::IceGrid::AdapterInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void adapterRemoved(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_adapterRemoved(_iceI_begin_adapterRemoved(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterRemoved(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& iceP_id, const ::IceGrid::Callback_AdapterObserver_adapterRemovedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterRemoved(const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_AdapterObserver_adapterRemovedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterRemoved(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_adapterRemoved(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_adapterRemoved(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) ObjectObserver : public virtual ::Ice::Proxy<ObjectObserver, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) void objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectInit(_iceI_begin_objectInit(iceP_objects, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectInit(iceP_objects, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(iceP_objects, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(iceP_objects, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::IceGrid::Callback_ObjectObserver_objectInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(iceP_objects, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectInit(const ::IceGrid::ObjectInfoSeq& iceP_objects, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectInitPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectInit(iceP_objects, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_objectInit(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectInit(const ::IceGrid::ObjectInfoSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectAdded(_iceI_begin_objectAdded(iceP_info, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectAdded(iceP_info, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(iceP_info, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::IceGrid::Callback_ObjectObserver_objectAddedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectAdded(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectAddedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectAdded(iceP_info, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_objectAdded(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectAdded(const ::IceGrid::ObjectInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectUpdated(_iceI_begin_objectUpdated(iceP_info, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectUpdated(iceP_info, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(iceP_info, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::IceGrid::Callback_ObjectObserver_objectUpdatedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(iceP_info, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectUpdated(const ::IceGrid::ObjectInfo& iceP_info, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectUpdatedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectUpdated(iceP_info, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_objectUpdated(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectUpdated(const ::IceGrid::ObjectInfo&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void objectRemoved(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_objectRemoved(_iceI_begin_objectRemoved(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_objectRemoved(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& iceP_id, const ::IceGrid::Callback_ObjectObserver_objectRemovedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_objectRemoved(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_ObjectObserver_objectRemovedPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_objectRemoved(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_objectRemoved(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_objectRemoved(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) AdminSession : public virtual ::Ice::Proxy<AdminSession, ::IceProxy::Glacier2::Session>
{
public:

    ICE_MEMBER(ICEGRID_API) void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_keepAlive(_iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::Callback_AdminSession_keepAlivePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_keepAlivePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_keepAlive(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_keepAlive(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminPrx getAdmin(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAdmin(_iceI_begin_getAdmin(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAdmin(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdmin(const ::IceGrid::Callback_AdminSession_getAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdmin(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_getAdminPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdmin(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminPrx end_getAdmin(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAdmin(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx getAdminCallbackTemplate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getAdminCallbackTemplate(_iceI_begin_getAdminCallbackTemplate(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getAdminCallbackTemplate(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::IceGrid::Callback_AdminSession_getAdminCallbackTemplatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getAdminCallbackTemplate(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_getAdminCallbackTemplatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getAdminCallbackTemplate(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_getAdminCallbackTemplate(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getAdminCallbackTemplate(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void setObservers(const ::IceGrid::RegistryObserverPrx& iceP_registryObs, const ::IceGrid::NodeObserverPrx& iceP_nodeObs, const ::IceGrid::ApplicationObserverPrx& iceP_appObs, const ::IceGrid::AdapterObserverPrx& iceP_adptObs, const ::IceGrid::ObjectObserverPrx& iceP_objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setObservers(_iceI_begin_setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& iceP_registryObs, const ::IceGrid::NodeObserverPrx& iceP_nodeObs, const ::IceGrid::ApplicationObserverPrx& iceP_appObs, const ::IceGrid::AdapterObserverPrx& iceP_adptObs, const ::IceGrid::ObjectObserverPrx& iceP_objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& iceP_registryObs, const ::IceGrid::NodeObserverPrx& iceP_nodeObs, const ::IceGrid::ApplicationObserverPrx& iceP_appObs, const ::IceGrid::AdapterObserverPrx& iceP_adptObs, const ::IceGrid::ObjectObserverPrx& iceP_objObs, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& iceP_registryObs, const ::IceGrid::NodeObserverPrx& iceP_nodeObs, const ::IceGrid::ApplicationObserverPrx& iceP_appObs, const ::IceGrid::AdapterObserverPrx& iceP_adptObs, const ::IceGrid::ObjectObserverPrx& iceP_objObs, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& iceP_registryObs, const ::IceGrid::NodeObserverPrx& iceP_nodeObs, const ::IceGrid::ApplicationObserverPrx& iceP_appObs, const ::IceGrid::AdapterObserverPrx& iceP_adptObs, const ::IceGrid::ObjectObserverPrx& iceP_objObs, const ::IceGrid::Callback_AdminSession_setObserversPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setObservers(const ::IceGrid::RegistryObserverPrx& iceP_registryObs, const ::IceGrid::NodeObserverPrx& iceP_nodeObs, const ::IceGrid::ApplicationObserverPrx& iceP_appObs, const ::IceGrid::AdapterObserverPrx& iceP_adptObs, const ::IceGrid::ObjectObserverPrx& iceP_objObs, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_setObserversPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObservers(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_setObservers(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_setObservers(const ::IceGrid::RegistryObserverPrx&, const ::IceGrid::NodeObserverPrx&, const ::IceGrid::ApplicationObserverPrx&, const ::IceGrid::AdapterObserverPrx&, const ::IceGrid::ObjectObserverPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setObserversByIdentity(_iceI_begin_setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::IceGrid::Callback_AdminSession_setObserversByIdentityPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_setObserversByIdentity(const ::Ice::Identity& iceP_registryObs, const ::Ice::Identity& iceP_nodeObs, const ::Ice::Identity& iceP_appObs, const ::Ice::Identity& iceP_adptObs, const ::Ice::Identity& iceP_objObs, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_setObserversByIdentityPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setObserversByIdentity(iceP_registryObs, iceP_nodeObs, iceP_appObs, iceP_adptObs, iceP_objObs, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_setObserversByIdentity(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_setObserversByIdentity(const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::Int startUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_startUpdate(_iceI_begin_startUpdate(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_startUpdate(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startUpdate(const ::IceGrid::Callback_AdminSession_startUpdatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_startUpdate(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_startUpdatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_startUpdate(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_startUpdate(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_startUpdate(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) void finishUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_finishUpdate(_iceI_begin_finishUpdate(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_finishUpdate(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_finishUpdate(const ::IceGrid::Callback_AdminSession_finishUpdatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_finishUpdate(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_finishUpdatePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_finishUpdate(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) void end_finishUpdate(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_finishUpdate(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::std::string getReplicaName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getReplicaName(_iceI_begin_getReplicaName(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getReplicaName(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getReplicaName(const ::IceGrid::Callback_AdminSession_getReplicaNamePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getReplicaName(const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_getReplicaNamePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaName(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::std::string end_getReplicaName(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getReplicaName(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openServerLog(_iceI_begin_openServerLog(iceP_id, iceP_path, iceP_count, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openServerLog(iceP_id, iceP_path, iceP_count, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, ::Ice::Int iceP_count, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(iceP_id, iceP_path, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(iceP_id, iceP_path, iceP_count, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, ::Ice::Int iceP_count, const ::IceGrid::Callback_AdminSession_openServerLogPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(iceP_id, iceP_path, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerLog(const ::std::string& iceP_id, const ::std::string& iceP_path, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openServerLogPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerLog(iceP_id, iceP_path, iceP_count, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openServerLog(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openServerLog(const ::std::string&, const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openServerStdErr(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openServerStdErr(_iceI_begin_openServerStdErr(iceP_id, iceP_count, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openServerStdErr(iceP_id, iceP_count, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(iceP_id, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(iceP_id, iceP_count, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::IceGrid::Callback_AdminSession_openServerStdErrPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(iceP_id, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerStdErr(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openServerStdErrPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdErr(iceP_id, iceP_count, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openServerStdErr(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openServerStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openServerStdOut(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openServerStdOut(_iceI_begin_openServerStdOut(iceP_id, iceP_count, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openServerStdOut(iceP_id, iceP_count, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(iceP_id, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(iceP_id, iceP_count, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::IceGrid::Callback_AdminSession_openServerStdOutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(iceP_id, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openServerStdOut(const ::std::string& iceP_id, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openServerStdOutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openServerStdOut(iceP_id, iceP_count, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openServerStdOut(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openServerStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openNodeStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openNodeStdErr(_iceI_begin_openNodeStdErr(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openNodeStdErr(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(iceP_name, iceP_count, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::IceGrid::Callback_AdminSession_openNodeStdErrPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openNodeStdErrPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdErr(iceP_name, iceP_count, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openNodeStdErr(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openNodeStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openNodeStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openNodeStdOut(_iceI_begin_openNodeStdOut(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openNodeStdOut(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(iceP_name, iceP_count, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::IceGrid::Callback_AdminSession_openNodeStdOutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openNodeStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openNodeStdOutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openNodeStdOut(iceP_name, iceP_count, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openNodeStdOut(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openNodeStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openRegistryStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openRegistryStdErr(_iceI_begin_openRegistryStdErr(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openRegistryStdErr(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(iceP_name, iceP_count, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::IceGrid::Callback_AdminSession_openRegistryStdErrPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdErr(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openRegistryStdErrPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdErr(iceP_name, iceP_count, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openRegistryStdErr(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openRegistryStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx openRegistryStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_openRegistryStdOut(_iceI_begin_openRegistryStdOut(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_openRegistryStdOut(iceP_name, iceP_count, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(iceP_name, iceP_count, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::IceGrid::Callback_AdminSession_openRegistryStdOutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(iceP_name, iceP_count, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_openRegistryStdOut(const ::std::string& iceP_name, ::Ice::Int iceP_count, const ::Ice::Context& context, const ::IceGrid::Callback_AdminSession_openRegistryStdOutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_openRegistryStdOut(iceP_name, iceP_count, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::FileIteratorPrx end_openRegistryStdOut(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_openRegistryStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceGrid
{

class ICEGRID_API Admin : public virtual ::Ice::Object
{
public:

    typedef AdminPrx ProxyType;
    typedef AdminPtr PointerType;

    virtual ~Admin();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void addApplication(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_addApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void syncApplication(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_syncApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateApplication(const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_updateApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void syncApplicationWithoutRestart(const ::IceGrid::ApplicationDescriptor&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_syncApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateApplicationWithoutRestart(const ::IceGrid::ApplicationUpdateDescriptor&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_updateApplicationWithoutRestart(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void removeApplication(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_removeApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void instantiateServer(const ::std::string&, const ::std::string&, const ::IceGrid::ServerInstanceDescriptor&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_instantiateServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void patchApplication_async(const ::IceGrid::AMD_Admin_patchApplicationPtr&, const ::std::string&, bool, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_patchApplication(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::ApplicationInfo getApplicationInfo(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getApplicationInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ApplicationDescriptor getDefaultApplicationDescriptor(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getDefaultApplicationDescriptor(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::StringSeq getAllApplicationNames(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAllApplicationNames(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ServerInfo getServerInfo(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getServerInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ServerState getServerState(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getServerState(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::Int getServerPid(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getServerPid(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::string getServerAdminCategory(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getServerAdminCategory(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx getServerAdmin(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getServerAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void enableServer(const ::std::string&, bool, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_enableServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool isServerEnabled(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_isServerEnabled(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void startServer_async(const ::IceGrid::AMD_Admin_startServerPtr&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_startServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void stopServer_async(const ::IceGrid::AMD_Admin_stopServerPtr&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_stopServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void patchServer_async(const ::IceGrid::AMD_Admin_patchServerPtr&, const ::std::string&, bool, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_patchServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void sendSignal(const ::std::string&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_sendSignal(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq getAllServerIds(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAllServerIds(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::AdapterInfoSeq getAdapterInfo(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAdapterInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void removeAdapter(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_removeAdapter(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq getAllAdapterIds(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAllAdapterIds(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void addObject(const ::Ice::ObjectPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_addObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateObject(const ::Ice::ObjectPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_updateObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void addObjectWithType(const ::Ice::ObjectPrx&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_addObjectWithType(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void removeObject(const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_removeObject(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::ObjectInfo getObjectInfo(const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getObjectInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ObjectInfoSeq getObjectInfosByType(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getObjectInfosByType(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::ObjectInfoSeq getAllObjectInfos(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAllObjectInfos(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool pingNode(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_pingNode(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::LoadInfo getNodeLoad(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getNodeLoad(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::NodeInfo getNodeInfo(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getNodeInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx getNodeAdmin(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getNodeAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::Int getNodeProcessorSocketCount(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getNodeProcessorSocketCount(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void shutdownNode(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_shutdownNode(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::string getNodeHostname(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getNodeHostname(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::StringSeq getAllNodeNames(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAllNodeNames(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool pingRegistry(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_pingRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::RegistryInfo getRegistryInfo(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getRegistryInfo(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx getRegistryAdmin(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getRegistryAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void shutdownRegistry(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_shutdownRegistry(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq getAllRegistryNames(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAllRegistryNames(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void shutdown(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_shutdown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::SliceChecksumDict getSliceChecksums(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getSliceChecksums(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Admin& lhs, const Admin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Admin& lhs, const Admin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API FileIterator : public virtual ::Ice::Object
{
public:

    typedef FileIteratorPrx ProxyType;
    typedef FileIteratorPtr PointerType;

    virtual ~FileIterator();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual bool read(::Ice::Int, ::Ice::StringSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_read(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void destroy(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const FileIterator& lhs, const FileIterator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const FileIterator& lhs, const FileIterator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API RegistryObserver : public virtual ::Ice::Object
{
public:

    typedef RegistryObserverPrx ProxyType;
    typedef RegistryObserverPtr PointerType;

    virtual ~RegistryObserver();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void registryInit(const ::IceGrid::RegistryInfoSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_registryInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void registryUp(const ::IceGrid::RegistryInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_registryUp(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void registryDown(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_registryDown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const RegistryObserver& lhs, const RegistryObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RegistryObserver& lhs, const RegistryObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API NodeObserver : public virtual ::Ice::Object
{
public:

    typedef NodeObserverPrx ProxyType;
    typedef NodeObserverPtr PointerType;

    virtual ~NodeObserver();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void nodeInit(const ::IceGrid::NodeDynamicInfoSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_nodeInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void nodeUp(const ::IceGrid::NodeDynamicInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_nodeUp(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void nodeDown(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_nodeDown(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateServer(const ::std::string&, const ::IceGrid::ServerDynamicInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_updateServer(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void updateAdapter(const ::std::string&, const ::IceGrid::AdapterDynamicInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_updateAdapter(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const NodeObserver& lhs, const NodeObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const NodeObserver& lhs, const NodeObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API ApplicationObserver : public virtual ::Ice::Object
{
public:

    typedef ApplicationObserverPrx ProxyType;
    typedef ApplicationObserverPtr PointerType;

    virtual ~ApplicationObserver();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void applicationInit(::Ice::Int, const ::IceGrid::ApplicationInfoSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_applicationInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void applicationAdded(::Ice::Int, const ::IceGrid::ApplicationInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_applicationAdded(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void applicationRemoved(::Ice::Int, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_applicationRemoved(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void applicationUpdated(::Ice::Int, const ::IceGrid::ApplicationUpdateInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_applicationUpdated(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const ApplicationObserver& lhs, const ApplicationObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ApplicationObserver& lhs, const ApplicationObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API AdapterObserver : public virtual ::Ice::Object
{
public:

    typedef AdapterObserverPrx ProxyType;
    typedef AdapterObserverPtr PointerType;

    virtual ~AdapterObserver();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void adapterInit(const ::IceGrid::AdapterInfoSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_adapterInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void adapterAdded(const ::IceGrid::AdapterInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_adapterAdded(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void adapterUpdated(const ::IceGrid::AdapterInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_adapterUpdated(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void adapterRemoved(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_adapterRemoved(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const AdapterObserver& lhs, const AdapterObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const AdapterObserver& lhs, const AdapterObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API ObjectObserver : public virtual ::Ice::Object
{
public:

    typedef ObjectObserverPrx ProxyType;
    typedef ObjectObserverPtr PointerType;

    virtual ~ObjectObserver();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void objectInit(const ::IceGrid::ObjectInfoSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_objectInit(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void objectAdded(const ::IceGrid::ObjectInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_objectAdded(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void objectUpdated(const ::IceGrid::ObjectInfo&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_objectUpdated(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void objectRemoved(const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_objectRemoved(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const ObjectObserver& lhs, const ObjectObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ObjectObserver& lhs, const ObjectObserver& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API AdminSession : virtual public ::Glacier2::Session
{
public:

    typedef AdminSessionPrx ProxyType;
    typedef AdminSessionPtr PointerType;

    virtual ~AdminSession();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void keepAlive(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::AdminPrx getAdmin(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAdmin(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx getAdminCallbackTemplate(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getAdminCallbackTemplate(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual void setObservers(const ::IceGrid::RegistryObserverPrx&, const ::IceGrid::NodeObserverPrx&, const ::IceGrid::ApplicationObserverPrx&, const ::IceGrid::AdapterObserverPrx&, const ::IceGrid::ObjectObserverPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_setObservers(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void setObserversByIdentity(const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_setObserversByIdentity(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::Int startUpdate(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_startUpdate(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void finishUpdate(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_finishUpdate(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::string getReplicaName(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getReplicaName(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::FileIteratorPrx openServerLog(const ::std::string&, const ::std::string&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_openServerLog(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::FileIteratorPrx openServerStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_openServerStdErr(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::FileIteratorPrx openServerStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_openServerStdOut(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::FileIteratorPrx openNodeStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_openNodeStdErr(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::FileIteratorPrx openNodeStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_openNodeStdOut(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::FileIteratorPrx openRegistryStdErr(const ::std::string&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_openRegistryStdErr(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::FileIteratorPrx openRegistryStdOut(const ::std::string&, ::Ice::Int, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_openRegistryStdOut(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const AdminSession& lhs, const AdminSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const AdminSession& lhs, const AdminSession& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::ServerState>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 6;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

template<>
struct StreamableTraits< ::IceGrid::ObjectInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ObjectInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ObjectInfo& v)
    {
        ostr->write(v.proxy);
        ostr->write(v.type);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ObjectInfo, S>
{
    static void read(S* istr, ::IceGrid::ObjectInfo& v)
    {
        istr->read(v.proxy);
        istr->read(v.type);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterInfo, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.proxy);
        ostr->write(v.replicaGroupId);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterInfo& v)
    {
        istr->read(v.id);
        istr->read(v.proxy);
        istr->read(v.replicaGroupId);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 9;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ServerInfo& v)
    {
        ostr->write(v.application);
        ostr->write(v.uuid);
        ostr->write(v.revision);
        ostr->write(v.node);
        ostr->write(v.descriptor);
        ostr->write(v.sessionId);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerInfo& v)
    {
        istr->read(v.application);
        istr->read(v.uuid);
        istr->read(v.revision);
        istr->read(v.node);
        istr->read(v.descriptor);
        istr->read(v.sessionId);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeInfo, S>
{
    static void write(S* ostr, const ::IceGrid::NodeInfo& v)
    {
        ostr->write(v.name);
        ostr->write(v.os);
        ostr->write(v.hostname);
        ostr->write(v.release);
        ostr->write(v.version);
        ostr->write(v.machine);
        ostr->write(v.nProcessors);
        ostr->write(v.dataDir);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeInfo& v)
    {
        istr->read(v.name);
        istr->read(v.os);
        istr->read(v.hostname);
        istr->read(v.release);
        istr->read(v.version);
        istr->read(v.machine);
        istr->read(v.nProcessors);
        istr->read(v.dataDir);
    }
};

template<>
struct StreamableTraits< ::IceGrid::RegistryInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::RegistryInfo, S>
{
    static void write(S* ostr, const ::IceGrid::RegistryInfo& v)
    {
        ostr->write(v.name);
        ostr->write(v.hostname);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::RegistryInfo, S>
{
    static void read(S* istr, ::IceGrid::RegistryInfo& v)
    {
        istr->read(v.name);
        istr->read(v.hostname);
    }
};

template<>
struct StreamableTraits< ::IceGrid::LoadInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 12;
    static const bool fixedLength = true;
};

template<typename S>
struct StreamWriter< ::IceGrid::LoadInfo, S>
{
    static void write(S* ostr, const ::IceGrid::LoadInfo& v)
    {
        ostr->write(v.avg1);
        ostr->write(v.avg5);
        ostr->write(v.avg15);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::LoadInfo, S>
{
    static void read(S* istr, ::IceGrid::LoadInfo& v)
    {
        istr->read(v.avg1);
        istr->read(v.avg5);
        istr->read(v.avg15);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 33;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationInfo& v)
    {
        ostr->write(v.uuid);
        ostr->write(v.createTime);
        ostr->write(v.createUser);
        ostr->write(v.updateTime);
        ostr->write(v.updateUser);
        ostr->write(v.revision);
        ostr->write(v.descriptor);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationInfo& v)
    {
        istr->read(v.uuid);
        istr->read(v.createTime);
        istr->read(v.createUser);
        istr->read(v.updateTime);
        istr->read(v.updateUser);
        istr->read(v.revision);
        istr->read(v.descriptor);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ApplicationUpdateInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 28;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ApplicationUpdateInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ApplicationUpdateInfo& v)
    {
        ostr->write(v.updateTime);
        ostr->write(v.updateUser);
        ostr->write(v.revision);
        ostr->write(v.descriptor);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ApplicationUpdateInfo, S>
{
    static void read(S* istr, ::IceGrid::ApplicationUpdateInfo& v)
    {
        istr->read(v.updateTime);
        istr->read(v.updateUser);
        istr->read(v.revision);
        istr->read(v.descriptor);
    }
};

template<>
struct StreamableTraits< ::IceGrid::ServerDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::ServerDynamicInfo, S>
{
    static void write(S* ostr, const ::IceGrid::ServerDynamicInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.state);
        ostr->write(v.pid);
        ostr->write(v.enabled);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::ServerDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::ServerDynamicInfo& v)
    {
        istr->read(v.id);
        istr->read(v.state);
        istr->read(v.pid);
        istr->read(v.enabled);
    }
};

template<>
struct StreamableTraits< ::IceGrid::AdapterDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 3;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::AdapterDynamicInfo, S>
{
    static void write(S* ostr, const ::IceGrid::AdapterDynamicInfo& v)
    {
        ostr->write(v.id);
        ostr->write(v.proxy);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::AdapterDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::AdapterDynamicInfo& v)
    {
        istr->read(v.id);
        istr->read(v.proxy);
    }
};

template<>
struct StreamableTraits< ::IceGrid::NodeDynamicInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 13;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceGrid::NodeDynamicInfo, S>
{
    static void write(S* ostr, const ::IceGrid::NodeDynamicInfo& v)
    {
        ostr->write(v.info);
        ostr->write(v.servers);
        ostr->write(v.adapters);
    }
};

template<typename S>
struct StreamReader< ::IceGrid::NodeDynamicInfo, S>
{
    static void read(S* istr, ::IceGrid::NodeDynamicInfo& v)
    {
        istr->read(v.info);
        istr->read(v.servers);
        istr->read(v.adapters);
    }
};

}

namespace IceGrid
{

template<class T>
class CallbackNC_Admin_addApplication : public Callback_Admin_addApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_addApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addApplication<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_addApplication : public Callback_Admin_addApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_addApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addApplicationPtr
newCallback_Admin_addApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_syncApplication : public Callback_Admin_syncApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_syncApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplication<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_syncApplication : public Callback_Admin_syncApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_syncApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_syncApplicationPtr
newCallback_Admin_syncApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_updateApplication : public Callback_Admin_updateApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_updateApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplication<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_updateApplication : public Callback_Admin_updateApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_updateApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateApplicationPtr
newCallback_Admin_updateApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_syncApplicationWithoutRestart : public Callback_Admin_syncApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_syncApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_syncApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_syncApplicationWithoutRestart : public Callback_Admin_syncApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_syncApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_syncApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_syncApplicationWithoutRestartPtr
newCallback_Admin_syncApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_syncApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_updateApplicationWithoutRestart : public Callback_Admin_updateApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_updateApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateApplicationWithoutRestart<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_updateApplicationWithoutRestart : public Callback_Admin_updateApplicationWithoutRestart_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_updateApplicationWithoutRestart(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateApplicationWithoutRestart(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateApplicationWithoutRestartPtr
newCallback_Admin_updateApplicationWithoutRestart(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateApplicationWithoutRestart<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_removeApplication : public Callback_Admin_removeApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_removeApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeApplication<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_removeApplication : public Callback_Admin_removeApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_removeApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeApplicationPtr
newCallback_Admin_removeApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_instantiateServer : public Callback_Admin_instantiateServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_instantiateServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_instantiateServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_instantiateServer<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_instantiateServer : public Callback_Admin_instantiateServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_instantiateServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_instantiateServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_instantiateServerPtr
newCallback_Admin_instantiateServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_instantiateServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_patchApplication : public Callback_Admin_patchApplication_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_patchApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_patchApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchApplication<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_patchApplication : public Callback_Admin_patchApplication_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_patchApplication(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_patchApplication(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_patchApplicationPtr
newCallback_Admin_patchApplication(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchApplication<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getApplicationInfo : public Callback_Admin_getApplicationInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::ApplicationInfo&);

    CallbackNC_Admin_getApplicationInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ApplicationInfo ret;
        try
        {
            ret = proxy->end_getApplicationInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ApplicationInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getApplicationInfo<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(T* instance, void (T::*cb)(const ::IceGrid::ApplicationInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getApplicationInfo<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getApplicationInfo : public Callback_Admin_getApplicationInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::ApplicationInfo&, const CT&);

    Callback_Admin_getApplicationInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ApplicationInfo ret;
        try
        {
            ret = proxy->end_getApplicationInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ApplicationInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getApplicationInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getApplicationInfoPtr
newCallback_Admin_getApplicationInfo(T* instance, void (T::*cb)(const ::IceGrid::ApplicationInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getApplicationInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getDefaultApplicationDescriptor : public Callback_Admin_getDefaultApplicationDescriptor_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::ApplicationDescriptor&);

    CallbackNC_Admin_getDefaultApplicationDescriptor(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_getDefaultApplicationDescriptor(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getDefaultApplicationDescriptor<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(T* instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getDefaultApplicationDescriptor<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getDefaultApplicationDescriptor : public Callback_Admin_getDefaultApplicationDescriptor_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::ApplicationDescriptor&, const CT&);

    Callback_Admin_getDefaultApplicationDescriptor(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ApplicationDescriptor ret;
        try
        {
            ret = proxy->end_getDefaultApplicationDescriptor(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getDefaultApplicationDescriptor<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getDefaultApplicationDescriptorPtr
newCallback_Admin_getDefaultApplicationDescriptor(T* instance, void (T::*cb)(const ::IceGrid::ApplicationDescriptor&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getDefaultApplicationDescriptor<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getAllApplicationNames : public Callback_Admin_getAllApplicationNames_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_Admin_getAllApplicationNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllApplicationNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllApplicationNames<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllApplicationNames<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getAllApplicationNames : public Callback_Admin_getAllApplicationNames_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_Admin_getAllApplicationNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllApplicationNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllApplicationNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getAllApplicationNamesPtr
newCallback_Admin_getAllApplicationNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllApplicationNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getServerInfo : public Callback_Admin_getServerInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::ServerInfo&);

    CallbackNC_Admin_getServerInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ServerInfo ret;
        try
        {
            ret = proxy->end_getServerInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ServerInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerInfo<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(T* instance, void (T::*cb)(const ::IceGrid::ServerInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerInfo<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getServerInfo : public Callback_Admin_getServerInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::ServerInfo&, const CT&);

    Callback_Admin_getServerInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ServerInfo ret;
        try
        {
            ret = proxy->end_getServerInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ServerInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getServerInfoPtr
newCallback_Admin_getServerInfo(T* instance, void (T::*cb)(const ::IceGrid::ServerInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getServerState : public Callback_Admin_getServerState_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::IceGrid::ServerState);

    CallbackNC_Admin_getServerState(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ServerState ret;
        try
        {
            ret = proxy->end_getServerState(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(const IceUtil::Handle<T>& instance, void (T::*cb)(::IceGrid::ServerState), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerState<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(T* instance, void (T::*cb)(::IceGrid::ServerState), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerState<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getServerState : public Callback_Admin_getServerState_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::IceGrid::ServerState, const CT&);

    Callback_Admin_getServerState(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ServerState ret;
        try
        {
            ret = proxy->end_getServerState(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(const IceUtil::Handle<T>& instance, void (T::*cb)(::IceGrid::ServerState, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerState<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getServerStatePtr
newCallback_Admin_getServerState(T* instance, void (T::*cb)(::IceGrid::ServerState, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerState<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getServerPid : public Callback_Admin_getServerPid_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Admin_getServerPid(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getServerPid(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerPid<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerPid<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getServerPid : public Callback_Admin_getServerPid_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Admin_getServerPid(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getServerPid(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerPid<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getServerPidPtr
newCallback_Admin_getServerPid(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerPid<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getServerAdminCategory : public Callback_Admin_getServerAdminCategory_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Admin_getServerAdminCategory(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getServerAdminCategory(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdminCategory<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdminCategory<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getServerAdminCategory : public Callback_Admin_getServerAdminCategory_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Admin_getServerAdminCategory(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getServerAdminCategory(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdminCategory<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getServerAdminCategoryPtr
newCallback_Admin_getServerAdminCategory(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdminCategory<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getServerAdmin : public Callback_Admin_getServerAdmin_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Admin_getServerAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getServerAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdmin<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getServerAdmin<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getServerAdmin : public Callback_Admin_getServerAdmin_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Admin_getServerAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getServerAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getServerAdminPtr
newCallback_Admin_getServerAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getServerAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_enableServer : public Callback_Admin_enableServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_enableServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_enableServer<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_enableServer : public Callback_Admin_enableServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_enableServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_enableServerPtr
newCallback_Admin_enableServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_enableServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_isServerEnabled : public Callback_Admin_isServerEnabled_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Admin_isServerEnabled(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_isServerEnabled(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_isServerEnabledPtr
newCallback_Admin_isServerEnabled(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_isServerEnabled<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_isServerEnabledPtr
newCallback_Admin_isServerEnabled(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_isServerEnabled<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_isServerEnabled : public Callback_Admin_isServerEnabled_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_Admin_isServerEnabled(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_isServerEnabled(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_isServerEnabledPtr
newCallback_Admin_isServerEnabled(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_isServerEnabled<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_isServerEnabledPtr
newCallback_Admin_isServerEnabled(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_isServerEnabled<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_startServer : public Callback_Admin_startServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_startServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_startServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_startServerPtr
newCallback_Admin_startServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_startServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_startServerPtr
newCallback_Admin_startServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_startServer<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_startServerPtr
newCallback_Admin_startServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_startServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_startServerPtr
newCallback_Admin_startServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_startServer<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_startServer : public Callback_Admin_startServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_startServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_startServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_startServerPtr
newCallback_Admin_startServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_startServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_startServerPtr
newCallback_Admin_startServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_startServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_startServerPtr
newCallback_Admin_startServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_startServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_startServerPtr
newCallback_Admin_startServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_startServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_stopServer : public Callback_Admin_stopServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_stopServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stopServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_stopServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_stopServer<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_stopServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_stopServer<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_stopServer : public Callback_Admin_stopServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_stopServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_stopServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_stopServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_stopServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_stopServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_stopServerPtr
newCallback_Admin_stopServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_stopServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_patchServer : public Callback_Admin_patchServer_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_patchServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_patchServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchServer<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_patchServer<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_patchServer : public Callback_Admin_patchServer_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_patchServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_patchServer(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_patchServerPtr
newCallback_Admin_patchServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_patchServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_sendSignal : public Callback_Admin_sendSignal_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_sendSignal(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_sendSignal(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_sendSignal<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_sendSignal<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_sendSignal<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_sendSignal<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_sendSignal : public Callback_Admin_sendSignal_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_sendSignal(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_sendSignal(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_sendSignal<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_sendSignal<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_sendSignal<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_sendSignalPtr
newCallback_Admin_sendSignal(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_sendSignal<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getAllServerIds : public Callback_Admin_getAllServerIds_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_Admin_getAllServerIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllServerIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getAllServerIdsPtr
newCallback_Admin_getAllServerIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllServerIds<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getAllServerIdsPtr
newCallback_Admin_getAllServerIds(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllServerIds<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getAllServerIds : public Callback_Admin_getAllServerIds_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_Admin_getAllServerIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllServerIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getAllServerIdsPtr
newCallback_Admin_getAllServerIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllServerIds<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getAllServerIdsPtr
newCallback_Admin_getAllServerIds(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllServerIds<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getAdapterInfo : public Callback_Admin_getAdapterInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::AdapterInfoSeq&);

    CallbackNC_Admin_getAdapterInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdapterInfoSeq ret;
        try
        {
            ret = proxy->end_getAdapterInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getAdapterInfoPtr
newCallback_Admin_getAdapterInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdapterInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAdapterInfo<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getAdapterInfoPtr
newCallback_Admin_getAdapterInfo(T* instance, void (T::*cb)(const ::IceGrid::AdapterInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAdapterInfo<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getAdapterInfo : public Callback_Admin_getAdapterInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::AdapterInfoSeq&, const CT&);

    Callback_Admin_getAdapterInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdapterInfoSeq ret;
        try
        {
            ret = proxy->end_getAdapterInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getAdapterInfoPtr
newCallback_Admin_getAdapterInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdapterInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAdapterInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getAdapterInfoPtr
newCallback_Admin_getAdapterInfo(T* instance, void (T::*cb)(const ::IceGrid::AdapterInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAdapterInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_removeAdapter : public Callback_Admin_removeAdapter_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_removeAdapter(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeAdapter(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeAdapter<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeAdapter<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeAdapter<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeAdapter<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_removeAdapter : public Callback_Admin_removeAdapter_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_removeAdapter(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeAdapter(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeAdapter<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeAdapter<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeAdapter<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeAdapterPtr
newCallback_Admin_removeAdapter(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeAdapter<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getAllAdapterIds : public Callback_Admin_getAllAdapterIds_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_Admin_getAllAdapterIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllAdapterIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getAllAdapterIdsPtr
newCallback_Admin_getAllAdapterIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllAdapterIds<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getAllAdapterIdsPtr
newCallback_Admin_getAllAdapterIds(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllAdapterIds<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getAllAdapterIds : public Callback_Admin_getAllAdapterIds_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_Admin_getAllAdapterIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllAdapterIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getAllAdapterIdsPtr
newCallback_Admin_getAllAdapterIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllAdapterIds<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getAllAdapterIdsPtr
newCallback_Admin_getAllAdapterIds(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllAdapterIds<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_addObject : public Callback_Admin_addObject_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_addObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObject<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObject<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_addObject : public Callback_Admin_addObject_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_addObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addObjectPtr
newCallback_Admin_addObject(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_updateObject : public Callback_Admin_updateObject_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_updateObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateObject<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_updateObject<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_updateObject : public Callback_Admin_updateObject_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_updateObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_updateObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_updateObjectPtr
newCallback_Admin_updateObject(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_updateObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_addObjectWithType : public Callback_Admin_addObjectWithType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_addObjectWithType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addObjectWithType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObjectWithType<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObjectWithType<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObjectWithType<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_addObjectWithType<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_addObjectWithType : public Callback_Admin_addObjectWithType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_addObjectWithType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_addObjectWithType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObjectWithType<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObjectWithType<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObjectWithType<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_addObjectWithTypePtr
newCallback_Admin_addObjectWithType(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_addObjectWithType<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_removeObject : public Callback_Admin_removeObject_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_removeObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeObject<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeObject<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_removeObject<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_removeObject : public Callback_Admin_removeObject_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_removeObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_removeObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeObject<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_removeObjectPtr
newCallback_Admin_removeObject(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_removeObject<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getObjectInfo : public Callback_Admin_getObjectInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::ObjectInfo&);

    CallbackNC_Admin_getObjectInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ObjectInfo ret;
        try
        {
            ret = proxy->end_getObjectInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getObjectInfoPtr
newCallback_Admin_getObjectInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ObjectInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getObjectInfo<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getObjectInfoPtr
newCallback_Admin_getObjectInfo(T* instance, void (T::*cb)(const ::IceGrid::ObjectInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getObjectInfo<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getObjectInfo : public Callback_Admin_getObjectInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::ObjectInfo&, const CT&);

    Callback_Admin_getObjectInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ObjectInfo ret;
        try
        {
            ret = proxy->end_getObjectInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getObjectInfoPtr
newCallback_Admin_getObjectInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ObjectInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getObjectInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getObjectInfoPtr
newCallback_Admin_getObjectInfo(T* instance, void (T::*cb)(const ::IceGrid::ObjectInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getObjectInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getObjectInfosByType : public Callback_Admin_getObjectInfosByType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::ObjectInfoSeq&);

    CallbackNC_Admin_getObjectInfosByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ObjectInfoSeq ret;
        try
        {
            ret = proxy->end_getObjectInfosByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getObjectInfosByTypePtr
newCallback_Admin_getObjectInfosByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getObjectInfosByType<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getObjectInfosByTypePtr
newCallback_Admin_getObjectInfosByType(T* instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getObjectInfosByType<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getObjectInfosByType : public Callback_Admin_getObjectInfosByType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::ObjectInfoSeq&, const CT&);

    Callback_Admin_getObjectInfosByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ObjectInfoSeq ret;
        try
        {
            ret = proxy->end_getObjectInfosByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getObjectInfosByTypePtr
newCallback_Admin_getObjectInfosByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getObjectInfosByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getObjectInfosByTypePtr
newCallback_Admin_getObjectInfosByType(T* instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getObjectInfosByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getAllObjectInfos : public Callback_Admin_getAllObjectInfos_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::ObjectInfoSeq&);

    CallbackNC_Admin_getAllObjectInfos(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ObjectInfoSeq ret;
        try
        {
            ret = proxy->end_getAllObjectInfos(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getAllObjectInfosPtr
newCallback_Admin_getAllObjectInfos(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllObjectInfos<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getAllObjectInfosPtr
newCallback_Admin_getAllObjectInfos(T* instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllObjectInfos<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getAllObjectInfos : public Callback_Admin_getAllObjectInfos_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::ObjectInfoSeq&, const CT&);

    Callback_Admin_getAllObjectInfos(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::ObjectInfoSeq ret;
        try
        {
            ret = proxy->end_getAllObjectInfos(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getAllObjectInfosPtr
newCallback_Admin_getAllObjectInfos(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllObjectInfos<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getAllObjectInfosPtr
newCallback_Admin_getAllObjectInfos(T* instance, void (T::*cb)(const ::IceGrid::ObjectInfoSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllObjectInfos<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_pingNode : public Callback_Admin_pingNode_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Admin_pingNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_pingNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_pingNodePtr
newCallback_Admin_pingNode(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_pingNode<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_pingNodePtr
newCallback_Admin_pingNode(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_pingNode<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_pingNode : public Callback_Admin_pingNode_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_Admin_pingNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_pingNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_pingNodePtr
newCallback_Admin_pingNode(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_pingNode<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_pingNodePtr
newCallback_Admin_pingNode(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_pingNode<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getNodeLoad : public Callback_Admin_getNodeLoad_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::LoadInfo&);

    CallbackNC_Admin_getNodeLoad(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::LoadInfo ret;
        try
        {
            ret = proxy->end_getNodeLoad(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getNodeLoadPtr
newCallback_Admin_getNodeLoad(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::LoadInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeLoad<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getNodeLoadPtr
newCallback_Admin_getNodeLoad(T* instance, void (T::*cb)(const ::IceGrid::LoadInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeLoad<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getNodeLoad : public Callback_Admin_getNodeLoad_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::LoadInfo&, const CT&);

    Callback_Admin_getNodeLoad(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::LoadInfo ret;
        try
        {
            ret = proxy->end_getNodeLoad(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getNodeLoadPtr
newCallback_Admin_getNodeLoad(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::LoadInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeLoad<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getNodeLoadPtr
newCallback_Admin_getNodeLoad(T* instance, void (T::*cb)(const ::IceGrid::LoadInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeLoad<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getNodeInfo : public Callback_Admin_getNodeInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::NodeInfo&);

    CallbackNC_Admin_getNodeInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::NodeInfo ret;
        try
        {
            ret = proxy->end_getNodeInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getNodeInfoPtr
newCallback_Admin_getNodeInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::NodeInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeInfo<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getNodeInfoPtr
newCallback_Admin_getNodeInfo(T* instance, void (T::*cb)(const ::IceGrid::NodeInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeInfo<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getNodeInfo : public Callback_Admin_getNodeInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::NodeInfo&, const CT&);

    Callback_Admin_getNodeInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::NodeInfo ret;
        try
        {
            ret = proxy->end_getNodeInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getNodeInfoPtr
newCallback_Admin_getNodeInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::NodeInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getNodeInfoPtr
newCallback_Admin_getNodeInfo(T* instance, void (T::*cb)(const ::IceGrid::NodeInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getNodeAdmin : public Callback_Admin_getNodeAdmin_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Admin_getNodeAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getNodeAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getNodeAdminPtr
newCallback_Admin_getNodeAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeAdmin<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getNodeAdminPtr
newCallback_Admin_getNodeAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeAdmin<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getNodeAdmin : public Callback_Admin_getNodeAdmin_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Admin_getNodeAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getNodeAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getNodeAdminPtr
newCallback_Admin_getNodeAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getNodeAdminPtr
newCallback_Admin_getNodeAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getNodeProcessorSocketCount : public Callback_Admin_getNodeProcessorSocketCount_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Admin_getNodeProcessorSocketCount(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getNodeProcessorSocketCount(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getNodeProcessorSocketCountPtr
newCallback_Admin_getNodeProcessorSocketCount(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeProcessorSocketCount<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getNodeProcessorSocketCountPtr
newCallback_Admin_getNodeProcessorSocketCount(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeProcessorSocketCount<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getNodeProcessorSocketCount : public Callback_Admin_getNodeProcessorSocketCount_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Admin_getNodeProcessorSocketCount(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getNodeProcessorSocketCount(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getNodeProcessorSocketCountPtr
newCallback_Admin_getNodeProcessorSocketCount(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeProcessorSocketCount<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getNodeProcessorSocketCountPtr
newCallback_Admin_getNodeProcessorSocketCount(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeProcessorSocketCount<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_shutdownNode : public Callback_Admin_shutdownNode_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_shutdownNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_shutdownNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownNode<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownNode<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownNode<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownNode<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_shutdownNode : public Callback_Admin_shutdownNode_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_shutdownNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_shutdownNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownNode<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownNode<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownNode<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownNodePtr
newCallback_Admin_shutdownNode(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownNode<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getNodeHostname : public Callback_Admin_getNodeHostname_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_Admin_getNodeHostname(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getNodeHostname(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getNodeHostnamePtr
newCallback_Admin_getNodeHostname(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeHostname<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getNodeHostnamePtr
newCallback_Admin_getNodeHostname(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getNodeHostname<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getNodeHostname : public Callback_Admin_getNodeHostname_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_Admin_getNodeHostname(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getNodeHostname(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getNodeHostnamePtr
newCallback_Admin_getNodeHostname(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeHostname<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getNodeHostnamePtr
newCallback_Admin_getNodeHostname(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getNodeHostname<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getAllNodeNames : public Callback_Admin_getAllNodeNames_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_Admin_getAllNodeNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllNodeNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getAllNodeNamesPtr
newCallback_Admin_getAllNodeNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllNodeNames<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getAllNodeNamesPtr
newCallback_Admin_getAllNodeNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllNodeNames<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getAllNodeNames : public Callback_Admin_getAllNodeNames_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_Admin_getAllNodeNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllNodeNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getAllNodeNamesPtr
newCallback_Admin_getAllNodeNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllNodeNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getAllNodeNamesPtr
newCallback_Admin_getAllNodeNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllNodeNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_pingRegistry : public Callback_Admin_pingRegistry_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool);

    CallbackNC_Admin_pingRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_pingRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_pingRegistryPtr
newCallback_Admin_pingRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_pingRegistry<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_pingRegistryPtr
newCallback_Admin_pingRegistry(T* instance, void (T::*cb)(bool), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_pingRegistry<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_pingRegistry : public Callback_Admin_pingRegistry_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const CT&);

    Callback_Admin_pingRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        bool ret;
        try
        {
            ret = proxy->end_pingRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_pingRegistryPtr
newCallback_Admin_pingRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_pingRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_pingRegistryPtr
newCallback_Admin_pingRegistry(T* instance, void (T::*cb)(bool, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_pingRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getRegistryInfo : public Callback_Admin_getRegistryInfo_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::RegistryInfo&);

    CallbackNC_Admin_getRegistryInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::RegistryInfo ret;
        try
        {
            ret = proxy->end_getRegistryInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getRegistryInfoPtr
newCallback_Admin_getRegistryInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::RegistryInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getRegistryInfo<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getRegistryInfoPtr
newCallback_Admin_getRegistryInfo(T* instance, void (T::*cb)(const ::IceGrid::RegistryInfo&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getRegistryInfo<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getRegistryInfo : public Callback_Admin_getRegistryInfo_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::RegistryInfo&, const CT&);

    Callback_Admin_getRegistryInfo(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::IceGrid::RegistryInfo ret;
        try
        {
            ret = proxy->end_getRegistryInfo(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getRegistryInfoPtr
newCallback_Admin_getRegistryInfo(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::RegistryInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getRegistryInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getRegistryInfoPtr
newCallback_Admin_getRegistryInfo(T* instance, void (T::*cb)(const ::IceGrid::RegistryInfo&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getRegistryInfo<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getRegistryAdmin : public Callback_Admin_getRegistryAdmin_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Admin_getRegistryAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getRegistryAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getRegistryAdminPtr
newCallback_Admin_getRegistryAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getRegistryAdmin<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getRegistryAdminPtr
newCallback_Admin_getRegistryAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getRegistryAdmin<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getRegistryAdmin : public Callback_Admin_getRegistryAdmin_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Admin_getRegistryAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getRegistryAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getRegistryAdminPtr
newCallback_Admin_getRegistryAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getRegistryAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getRegistryAdminPtr
newCallback_Admin_getRegistryAdmin(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getRegistryAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_shutdownRegistry : public Callback_Admin_shutdownRegistry_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_shutdownRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_shutdownRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownRegistry<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownRegistry<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownRegistry<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdownRegistry<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_shutdownRegistry : public Callback_Admin_shutdownRegistry_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_shutdownRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_shutdownRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownRegistry<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownRegistryPtr
newCallback_Admin_shutdownRegistry(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdownRegistry<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getAllRegistryNames : public Callback_Admin_getAllRegistryNames_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_Admin_getAllRegistryNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllRegistryNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getAllRegistryNamesPtr
newCallback_Admin_getAllRegistryNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllRegistryNames<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getAllRegistryNamesPtr
newCallback_Admin_getAllRegistryNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getAllRegistryNames<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getAllRegistryNames : public Callback_Admin_getAllRegistryNames_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_Admin_getAllRegistryNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getAllRegistryNames(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getAllRegistryNamesPtr
newCallback_Admin_getAllRegistryNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllRegistryNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getAllRegistryNamesPtr
newCallback_Admin_getAllRegistryNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getAllRegistryNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_shutdown : public Callback_Admin_shutdown_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Admin_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdown<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_shutdown<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_shutdown : public Callback_Admin_shutdown_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Admin_shutdown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdown<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_shutdownPtr
newCallback_Admin_shutdown(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_shutdown<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_Admin_getSliceChecksums : public Callback_Admin_getSliceChecksums_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&);

    CallbackNC_Admin_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Admin_getSliceChecksumsPtr
newCallback_Admin_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Admin_getSliceChecksumsPtr
newCallback_Admin_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Admin_getSliceChecksums<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Admin_getSliceChecksums : public Callback_Admin_getSliceChecksums_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::SliceChecksumDict&, const CT&);

    Callback_Admin_getSliceChecksums(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminPrx proxy = ::IceGrid::AdminPrx::uncheckedCast(result->getProxy());
        ::Ice::SliceChecksumDict ret;
        try
        {
            ret = proxy->end_getSliceChecksums(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Admin_getSliceChecksumsPtr
newCallback_Admin_getSliceChecksums(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Admin_getSliceChecksumsPtr
newCallback_Admin_getSliceChecksums(T* instance, void (T::*cb)(const ::Ice::SliceChecksumDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Admin_getSliceChecksums<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_FileIterator_read : public Callback_FileIterator_read_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(bool, const ::Ice::StringSeq&);

    CallbackNC_FileIterator_read(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::FileIteratorPrx proxy = ::IceGrid::FileIteratorPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq iceP_lines;
        bool ret;
        try
        {
            ret = proxy->end_read(iceP_lines, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_lines);
        }
    }

private:

    Response _response;
};

template<class T> Callback_FileIterator_readPtr
newCallback_FileIterator_read(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileIterator_read<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileIterator_readPtr
newCallback_FileIterator_read(T* instance, void (T::*cb)(bool, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileIterator_read<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileIterator_read : public Callback_FileIterator_read_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(bool, const ::Ice::StringSeq&, const CT&);

    Callback_FileIterator_read(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::FileIteratorPrx proxy = ::IceGrid::FileIteratorPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq iceP_lines;
        bool ret;
        try
        {
            ret = proxy->end_read(iceP_lines, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_lines, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_FileIterator_readPtr
newCallback_FileIterator_read(const IceUtil::Handle<T>& instance, void (T::*cb)(bool, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileIterator_read<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileIterator_readPtr
newCallback_FileIterator_read(T* instance, void (T::*cb)(bool, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileIterator_read<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_FileIterator_destroy : public Callback_FileIterator_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_FileIterator_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileIterator_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileIterator_destroy<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileIterator_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_FileIterator_destroy<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_FileIterator_destroy : public Callback_FileIterator_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_FileIterator_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileIterator_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileIterator_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileIterator_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_FileIterator_destroyPtr
newCallback_FileIterator_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_FileIterator_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_RegistryObserver_registryInit : public Callback_RegistryObserver_registryInit_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RegistryObserver_registryInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryInit<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryInit<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_RegistryObserver_registryInit : public Callback_RegistryObserver_registryInit_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RegistryObserver_registryInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryInitPtr
newCallback_RegistryObserver_registryInit(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_RegistryObserver_registryUp : public Callback_RegistryObserver_registryUp_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RegistryObserver_registryUp(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryUp<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryUp<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryUp<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryUp<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_RegistryObserver_registryUp : public Callback_RegistryObserver_registryUp_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RegistryObserver_registryUp(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryUp<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryUp<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryUp<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryUpPtr
newCallback_RegistryObserver_registryUp(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryUp<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_RegistryObserver_registryDown : public Callback_RegistryObserver_registryDown_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_RegistryObserver_registryDown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryDown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryDown<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryDown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_RegistryObserver_registryDown<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_RegistryObserver_registryDown : public Callback_RegistryObserver_registryDown_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_RegistryObserver_registryDown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryDown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryDown<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryDown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_RegistryObserver_registryDownPtr
newCallback_RegistryObserver_registryDown(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_RegistryObserver_registryDown<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_NodeObserver_nodeInit : public Callback_NodeObserver_nodeInit_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeObserver_nodeInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeInit<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeInit<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_NodeObserver_nodeInit : public Callback_NodeObserver_nodeInit_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeObserver_nodeInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeInitPtr
newCallback_NodeObserver_nodeInit(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_NodeObserver_nodeUp : public Callback_NodeObserver_nodeUp_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeObserver_nodeUp(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeUp<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeUp<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeUp<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeUp<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_NodeObserver_nodeUp : public Callback_NodeObserver_nodeUp_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeObserver_nodeUp(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeUp<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeUp<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeUp<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeUpPtr
newCallback_NodeObserver_nodeUp(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeUp<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_NodeObserver_nodeDown : public Callback_NodeObserver_nodeDown_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeObserver_nodeDown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeDown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeDown<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeDown<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_nodeDown<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_NodeObserver_nodeDown : public Callback_NodeObserver_nodeDown_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeObserver_nodeDown(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeDown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeDown<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeDown<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_nodeDownPtr
newCallback_NodeObserver_nodeDown(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_nodeDown<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_NodeObserver_updateServer : public Callback_NodeObserver_updateServer_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeObserver_updateServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateServer<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateServer<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateServer<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_NodeObserver_updateServer : public Callback_NodeObserver_updateServer_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeObserver_updateServer(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateServer<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_updateServerPtr
newCallback_NodeObserver_updateServer(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateServer<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_NodeObserver_updateAdapter : public Callback_NodeObserver_updateAdapter_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_NodeObserver_updateAdapter(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateAdapter<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateAdapter<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateAdapter<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_NodeObserver_updateAdapter<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_NodeObserver_updateAdapter : public Callback_NodeObserver_updateAdapter_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_NodeObserver_updateAdapter(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateAdapter<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateAdapter<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateAdapter<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_NodeObserver_updateAdapterPtr
newCallback_NodeObserver_updateAdapter(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_NodeObserver_updateAdapter<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ApplicationObserver_applicationInit : public Callback_ApplicationObserver_applicationInit_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ApplicationObserver_applicationInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationInit<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationInit<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ApplicationObserver_applicationInit : public Callback_ApplicationObserver_applicationInit_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ApplicationObserver_applicationInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationInitPtr
newCallback_ApplicationObserver_applicationInit(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ApplicationObserver_applicationAdded : public Callback_ApplicationObserver_applicationAdded_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ApplicationObserver_applicationAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationAdded<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationAdded<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationAdded<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationAdded<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ApplicationObserver_applicationAdded : public Callback_ApplicationObserver_applicationAdded_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ApplicationObserver_applicationAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationAdded<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationAdded<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationAdded<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationAddedPtr
newCallback_ApplicationObserver_applicationAdded(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationAdded<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ApplicationObserver_applicationRemoved : public Callback_ApplicationObserver_applicationRemoved_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ApplicationObserver_applicationRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationRemoved<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationRemoved<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationRemoved<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationRemoved<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ApplicationObserver_applicationRemoved : public Callback_ApplicationObserver_applicationRemoved_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ApplicationObserver_applicationRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationRemoved<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationRemoved<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationRemoved<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationRemovedPtr
newCallback_ApplicationObserver_applicationRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationRemoved<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ApplicationObserver_applicationUpdated : public Callback_ApplicationObserver_applicationUpdated_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ApplicationObserver_applicationUpdated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationUpdated<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationUpdated<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationUpdated<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ApplicationObserver_applicationUpdated<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ApplicationObserver_applicationUpdated : public Callback_ApplicationObserver_applicationUpdated_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ApplicationObserver_applicationUpdated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationUpdated<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationUpdated<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationUpdated<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ApplicationObserver_applicationUpdatedPtr
newCallback_ApplicationObserver_applicationUpdated(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ApplicationObserver_applicationUpdated<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdapterObserver_adapterInit : public Callback_AdapterObserver_adapterInit_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdapterObserver_adapterInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterInit<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterInit<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdapterObserver_adapterInit : public Callback_AdapterObserver_adapterInit_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdapterObserver_adapterInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterInitPtr
newCallback_AdapterObserver_adapterInit(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdapterObserver_adapterAdded : public Callback_AdapterObserver_adapterAdded_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdapterObserver_adapterAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterAdded<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterAdded<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterAdded<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterAdded<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdapterObserver_adapterAdded : public Callback_AdapterObserver_adapterAdded_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdapterObserver_adapterAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterAdded<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterAdded<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterAdded<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterAddedPtr
newCallback_AdapterObserver_adapterAdded(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterAdded<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdapterObserver_adapterUpdated : public Callback_AdapterObserver_adapterUpdated_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdapterObserver_adapterUpdated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterUpdated<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterUpdated<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterUpdated<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterUpdated<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdapterObserver_adapterUpdated : public Callback_AdapterObserver_adapterUpdated_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdapterObserver_adapterUpdated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterUpdated<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterUpdated<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterUpdated<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterUpdatedPtr
newCallback_AdapterObserver_adapterUpdated(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterUpdated<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdapterObserver_adapterRemoved : public Callback_AdapterObserver_adapterRemoved_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdapterObserver_adapterRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterRemoved<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterRemoved<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterRemoved<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdapterObserver_adapterRemoved<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdapterObserver_adapterRemoved : public Callback_AdapterObserver_adapterRemoved_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdapterObserver_adapterRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterRemoved<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterRemoved<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterRemoved<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdapterObserver_adapterRemovedPtr
newCallback_AdapterObserver_adapterRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdapterObserver_adapterRemoved<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ObjectObserver_objectInit : public Callback_ObjectObserver_objectInit_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ObjectObserver_objectInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectInit<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectInit<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectInit<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ObjectObserver_objectInit : public Callback_ObjectObserver_objectInit_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ObjectObserver_objectInit(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectInit<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectInitPtr
newCallback_ObjectObserver_objectInit(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectInit<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ObjectObserver_objectAdded : public Callback_ObjectObserver_objectAdded_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ObjectObserver_objectAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectAdded<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectAdded<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectAdded<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectAdded<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ObjectObserver_objectAdded : public Callback_ObjectObserver_objectAdded_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ObjectObserver_objectAdded(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectAdded<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectAdded<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectAdded<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectAddedPtr
newCallback_ObjectObserver_objectAdded(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectAdded<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ObjectObserver_objectUpdated : public Callback_ObjectObserver_objectUpdated_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ObjectObserver_objectUpdated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectUpdated<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectUpdated<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectUpdated<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectUpdated<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ObjectObserver_objectUpdated : public Callback_ObjectObserver_objectUpdated_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ObjectObserver_objectUpdated(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectUpdated<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectUpdated<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectUpdated<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectUpdatedPtr
newCallback_ObjectObserver_objectUpdated(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectUpdated<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_ObjectObserver_objectRemoved : public Callback_ObjectObserver_objectRemoved_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_ObjectObserver_objectRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectRemoved<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectRemoved<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectRemoved<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_ObjectObserver_objectRemoved<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_ObjectObserver_objectRemoved : public Callback_ObjectObserver_objectRemoved_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_ObjectObserver_objectRemoved(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectRemoved<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectRemoved<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectRemoved<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_ObjectObserver_objectRemovedPtr
newCallback_ObjectObserver_objectRemoved(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_ObjectObserver_objectRemoved<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_keepAlive : public Callback_AdminSession_keepAlive_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdminSession_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_keepAlive<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_keepAlive<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_keepAlive<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_keepAlive<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_keepAlive : public Callback_AdminSession_keepAlive_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdminSession_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_keepAlivePtr
newCallback_AdminSession_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_getAdmin : public Callback_AdminSession_getAdmin_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::AdminPrx&);

    CallbackNC_AdminSession_getAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdminPrx ret;
        try
        {
            ret = proxy->end_getAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_getAdminPtr
newCallback_AdminSession_getAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdminPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_getAdmin<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_getAdminPtr
newCallback_AdminSession_getAdmin(T* instance, void (T::*cb)(const ::IceGrid::AdminPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_getAdmin<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_getAdmin : public Callback_AdminSession_getAdmin_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::AdminPrx&, const CT&);

    Callback_AdminSession_getAdmin(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdminPrx ret;
        try
        {
            ret = proxy->end_getAdmin(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_getAdminPtr
newCallback_AdminSession_getAdmin(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdminPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_getAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_getAdminPtr
newCallback_AdminSession_getAdmin(T* instance, void (T::*cb)(const ::IceGrid::AdminPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_getAdmin<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_getAdminCallbackTemplate : public Callback_AdminSession_getAdminCallbackTemplate_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_AdminSession_getAdminCallbackTemplate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getAdminCallbackTemplate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_getAdminCallbackTemplatePtr
newCallback_AdminSession_getAdminCallbackTemplate(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_getAdminCallbackTemplate<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_getAdminCallbackTemplatePtr
newCallback_AdminSession_getAdminCallbackTemplate(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_getAdminCallbackTemplate<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_getAdminCallbackTemplate : public Callback_AdminSession_getAdminCallbackTemplate_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_AdminSession_getAdminCallbackTemplate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_getAdminCallbackTemplate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_getAdminCallbackTemplatePtr
newCallback_AdminSession_getAdminCallbackTemplate(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_getAdminCallbackTemplate<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_getAdminCallbackTemplatePtr
newCallback_AdminSession_getAdminCallbackTemplate(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_getAdminCallbackTemplate<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_setObservers : public Callback_AdminSession_setObservers_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdminSession_setObservers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setObservers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObservers<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObservers<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObservers<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObservers<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_setObservers : public Callback_AdminSession_setObservers_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdminSession_setObservers(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setObservers(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObservers<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObservers<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObservers<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_setObserversPtr
newCallback_AdminSession_setObservers(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObservers<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_setObserversByIdentity : public Callback_AdminSession_setObserversByIdentity_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdminSession_setObserversByIdentity(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setObserversByIdentity(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObserversByIdentity<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObserversByIdentity<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObserversByIdentity<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_setObserversByIdentity<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_setObserversByIdentity : public Callback_AdminSession_setObserversByIdentity_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdminSession_setObserversByIdentity(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_setObserversByIdentity(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObserversByIdentity<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObserversByIdentity<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObserversByIdentity<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_setObserversByIdentityPtr
newCallback_AdminSession_setObserversByIdentity(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_setObserversByIdentity<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_startUpdate : public Callback_AdminSession_startUpdate_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_AdminSession_startUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_startUpdate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_startUpdatePtr
newCallback_AdminSession_startUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_startUpdate<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_startUpdatePtr
newCallback_AdminSession_startUpdate(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_startUpdate<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_startUpdate : public Callback_AdminSession_startUpdate_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_AdminSession_startUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_startUpdate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_startUpdatePtr
newCallback_AdminSession_startUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_startUpdate<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_startUpdatePtr
newCallback_AdminSession_startUpdate(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_startUpdate<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_finishUpdate : public Callback_AdminSession_finishUpdate_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_AdminSession_finishUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_finishUpdate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_finishUpdate<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_finishUpdate<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_finishUpdate<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_finishUpdate<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_finishUpdate : public Callback_AdminSession_finishUpdate_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_AdminSession_finishUpdate(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_finishUpdate(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_finishUpdate<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_finishUpdate<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_finishUpdate<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_finishUpdatePtr
newCallback_AdminSession_finishUpdate(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_finishUpdate<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_getReplicaName : public Callback_AdminSession_getReplicaName_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_AdminSession_getReplicaName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getReplicaName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_getReplicaNamePtr
newCallback_AdminSession_getReplicaName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_getReplicaName<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_getReplicaNamePtr
newCallback_AdminSession_getReplicaName(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_getReplicaName<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_getReplicaName : public Callback_AdminSession_getReplicaName_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_AdminSession_getReplicaName(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getReplicaName(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_getReplicaNamePtr
newCallback_AdminSession_getReplicaName(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_getReplicaName<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_getReplicaNamePtr
newCallback_AdminSession_getReplicaName(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_getReplicaName<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_openServerLog : public Callback_AdminSession_openServerLog_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&);

    CallbackNC_AdminSession_openServerLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openServerLog(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_openServerLogPtr
newCallback_AdminSession_openServerLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openServerLog<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_openServerLogPtr
newCallback_AdminSession_openServerLog(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openServerLog<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_openServerLog : public Callback_AdminSession_openServerLog_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&, const CT&);

    Callback_AdminSession_openServerLog(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openServerLog(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_openServerLogPtr
newCallback_AdminSession_openServerLog(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openServerLog<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_openServerLogPtr
newCallback_AdminSession_openServerLog(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openServerLog<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_openServerStdErr : public Callback_AdminSession_openServerStdErr_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&);

    CallbackNC_AdminSession_openServerStdErr(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openServerStdErr(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_openServerStdErrPtr
newCallback_AdminSession_openServerStdErr(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openServerStdErr<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_openServerStdErrPtr
newCallback_AdminSession_openServerStdErr(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openServerStdErr<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_openServerStdErr : public Callback_AdminSession_openServerStdErr_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&, const CT&);

    Callback_AdminSession_openServerStdErr(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openServerStdErr(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_openServerStdErrPtr
newCallback_AdminSession_openServerStdErr(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openServerStdErr<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_openServerStdErrPtr
newCallback_AdminSession_openServerStdErr(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openServerStdErr<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_openServerStdOut : public Callback_AdminSession_openServerStdOut_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&);

    CallbackNC_AdminSession_openServerStdOut(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openServerStdOut(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_openServerStdOutPtr
newCallback_AdminSession_openServerStdOut(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openServerStdOut<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_openServerStdOutPtr
newCallback_AdminSession_openServerStdOut(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openServerStdOut<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_openServerStdOut : public Callback_AdminSession_openServerStdOut_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&, const CT&);

    Callback_AdminSession_openServerStdOut(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openServerStdOut(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_openServerStdOutPtr
newCallback_AdminSession_openServerStdOut(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openServerStdOut<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_openServerStdOutPtr
newCallback_AdminSession_openServerStdOut(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openServerStdOut<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_openNodeStdErr : public Callback_AdminSession_openNodeStdErr_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&);

    CallbackNC_AdminSession_openNodeStdErr(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openNodeStdErr(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_openNodeStdErrPtr
newCallback_AdminSession_openNodeStdErr(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openNodeStdErr<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_openNodeStdErrPtr
newCallback_AdminSession_openNodeStdErr(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openNodeStdErr<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_openNodeStdErr : public Callback_AdminSession_openNodeStdErr_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&, const CT&);

    Callback_AdminSession_openNodeStdErr(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openNodeStdErr(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_openNodeStdErrPtr
newCallback_AdminSession_openNodeStdErr(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openNodeStdErr<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_openNodeStdErrPtr
newCallback_AdminSession_openNodeStdErr(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openNodeStdErr<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_openNodeStdOut : public Callback_AdminSession_openNodeStdOut_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&);

    CallbackNC_AdminSession_openNodeStdOut(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openNodeStdOut(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_openNodeStdOutPtr
newCallback_AdminSession_openNodeStdOut(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openNodeStdOut<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_openNodeStdOutPtr
newCallback_AdminSession_openNodeStdOut(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openNodeStdOut<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_openNodeStdOut : public Callback_AdminSession_openNodeStdOut_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&, const CT&);

    Callback_AdminSession_openNodeStdOut(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openNodeStdOut(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_openNodeStdOutPtr
newCallback_AdminSession_openNodeStdOut(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openNodeStdOut<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_openNodeStdOutPtr
newCallback_AdminSession_openNodeStdOut(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openNodeStdOut<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_openRegistryStdErr : public Callback_AdminSession_openRegistryStdErr_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&);

    CallbackNC_AdminSession_openRegistryStdErr(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openRegistryStdErr(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_openRegistryStdErrPtr
newCallback_AdminSession_openRegistryStdErr(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openRegistryStdErr<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_openRegistryStdErrPtr
newCallback_AdminSession_openRegistryStdErr(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openRegistryStdErr<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_openRegistryStdErr : public Callback_AdminSession_openRegistryStdErr_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&, const CT&);

    Callback_AdminSession_openRegistryStdErr(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openRegistryStdErr(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_openRegistryStdErrPtr
newCallback_AdminSession_openRegistryStdErr(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openRegistryStdErr<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_openRegistryStdErrPtr
newCallback_AdminSession_openRegistryStdErr(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openRegistryStdErr<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_AdminSession_openRegistryStdOut : public Callback_AdminSession_openRegistryStdOut_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&);

    CallbackNC_AdminSession_openRegistryStdOut(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openRegistryStdOut(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_AdminSession_openRegistryStdOutPtr
newCallback_AdminSession_openRegistryStdOut(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openRegistryStdOut<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_AdminSession_openRegistryStdOutPtr
newCallback_AdminSession_openRegistryStdOut(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_AdminSession_openRegistryStdOut<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_AdminSession_openRegistryStdOut : public Callback_AdminSession_openRegistryStdOut_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::FileIteratorPrx&, const CT&);

    Callback_AdminSession_openRegistryStdOut(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::AdminSessionPrx proxy = ::IceGrid::AdminSessionPrx::uncheckedCast(result->getProxy());
        ::IceGrid::FileIteratorPrx ret;
        try
        {
            ret = proxy->end_openRegistryStdOut(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_AdminSession_openRegistryStdOutPtr
newCallback_AdminSession_openRegistryStdOut(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openRegistryStdOut<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_AdminSession_openRegistryStdOutPtr
newCallback_AdminSession_openRegistryStdOut(T* instance, void (T::*cb)(const ::IceGrid::FileIteratorPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_AdminSession_openRegistryStdOut<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
