/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.CompressBatch;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.OperationInterruptedException;
import Ice.RouterPrx;
import IceInternal.CommunicatorFlushBatch;
import IceInternal.Instance;
import IceUtilInternal.Assert;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public final class ObjectAdapterFactory {
    private Instance _instance;
    private Communicator _communicator;
    private Set<String> _adapterNamesInUse = new HashSet<String>();
    private List<ObjectAdapterI> _adapters = new LinkedList<ObjectAdapterI>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList<ObjectAdapterI> adapters;
        Object object = this;
        synchronized (object) {
            if (this._instance == null) {
                return;
            }
            adapters = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI adapter : adapters) {
            adapter.deactivate();
        }
        object = this;
        synchronized (object) {
            this._instance = null;
            this._communicator = null;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForShutdown() {
        LinkedList<ObjectAdapterI> adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            while (this._instance != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    throw new OperationInterruptedException();
                }
            }
            adapters = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI adapter : adapters) {
            adapter.waitForDeactivate();
        }
    }

    public synchronized boolean isShutdown() {
        return this._instance == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        LinkedList<ObjectAdapterI> adapters;
        this.waitForShutdown();
        Object object = this;
        synchronized (object) {
            adapters = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI adapter : adapters) {
            adapter.destroy();
        }
        object = this;
        synchronized (object) {
            this._adapters.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionObservers() {
        LinkedList<ObjectAdapterI> adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            adapters = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI adapter : adapters) {
            adapter.updateConnectionObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThreadObservers() {
        LinkedList<ObjectAdapterI> adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            adapters = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI adapter : adapters) {
            adapter.updateThreadObservers();
        }
    }

    public synchronized ObjectAdapter createObjectAdapter(String name, RouterPrx router) {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        if (this._instance == null) {
            throw new CommunicatorDestroyedException();
        }
        ObjectAdapterI adapter = null;
        if (name.length() == 0) {
            String uuid = UUID.randomUUID().toString();
            adapter = new ObjectAdapterI(this._instance, this._communicator, this, uuid, null, true);
        } else {
            if (this._adapterNamesInUse.contains(name)) {
                throw new AlreadyRegisteredException("object adapter", name);
            }
            adapter = new ObjectAdapterI(this._instance, this._communicator, this, name, router, false);
            this._adapterNamesInUse.add(name);
        }
        this._adapters.add(adapter);
        return adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter findObjectAdapter(ObjectPrx proxy) {
        LinkedList<ObjectAdapterI> adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            if (this._instance == null) {
                return null;
            }
            adapters = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI adapter : adapters) {
            try {
                if (!adapter.isLocal(proxy)) continue;
                return adapter;
            }
            catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
            }
        }
        return null;
    }

    public synchronized void removeObjectAdapter(ObjectAdapter adapter) {
        if (this._instance == null) {
            return;
        }
        this._adapters.remove(adapter);
        this._adapterNamesInUse.remove(adapter.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAsyncBatchRequests(CompressBatch compressBatch, CommunicatorFlushBatch outAsync) {
        LinkedList<ObjectAdapterI> adapters;
        ObjectAdapterFactory objectAdapterFactory = this;
        synchronized (objectAdapterFactory) {
            adapters = new LinkedList<ObjectAdapterI>(this._adapters);
        }
        for (ObjectAdapterI adapter : adapters) {
            adapter.flushAsyncBatchRequests(compressBatch, outAsync);
        }
    }

    ObjectAdapterFactory(Instance instance, Communicator communicator) {
        this._instance = instance;
        this._communicator = communicator;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._instance == null);
            Assert.FinalizerAssert(this._communicator == null);
            Assert.FinalizerAssert(this._adapters.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }
}

