/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.AggregatePrimitivesVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreePanel;
import org.openstreetmap.josm.gui.layer.AbstractMapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.ValidatorLayer;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class ValidateUploadHook
implements UploadHook {
    @Override
    public boolean checkUpload(APIDataSet apiDataSet) {
        MapFrame mapFrame;
        OsmDataLayer editLayer;
        OsmValidator.initializeTests();
        Collection<Test> tests = OsmValidator.getEnabledTests(true);
        if (tests.isEmpty()) {
            return true;
        }
        AggregatePrimitivesVisitor v = new AggregatePrimitivesVisitor();
        v.visit(apiDataSet.getPrimitivesToAdd());
        Collection<OsmPrimitive> selection = v.visit(apiDataSet.getPrimitivesToUpdate());
        ArrayList<TestError> errors = new ArrayList<TestError>(30);
        for (Test test : tests) {
            test.setBeforeUpload(true);
            test.setPartialSelection(true);
            test.startTest(null);
            test.visit(selection);
            test.endTest();
            if (ValidatorPrefHelper.PREF_OTHER.get().booleanValue() && ValidatorPrefHelper.PREF_OTHER_UPLOAD.get().booleanValue()) {
                errors.addAll(test.getErrors());
                continue;
            }
            for (TestError e : test.getErrors()) {
                if (e.getSeverity() == Severity.OTHER) continue;
                errors.add(e);
            }
        }
        if (ValidatorPrefHelper.PREF_USE_IGNORE.get().booleanValue()) {
            int nume = 0;
            for (TestError error : errors) {
                ArrayList<String> s = new ArrayList<String>();
                s.add(error.getIgnoreState());
                s.add(error.getIgnoreGroup());
                s.add(error.getIgnoreSubGroup());
                for (String state : s) {
                    if (state == null || !OsmValidator.hasIgnoredError(state)) continue;
                    error.setIgnored(true);
                }
                if (error.isIgnored()) continue;
                ++nume;
            }
            if (nume == 0) {
                return true;
            }
        }
        if ((editLayer = MainApplication.getLayerManager().getEditLayer()) != null) {
            editLayer.validationErrors.clear();
            editLayer.validationErrors.addAll(errors);
        }
        if ((mapFrame = MainApplication.getMap()) != null) {
            mapFrame.validatorDialog.tree.setErrors(errors);
        }
        if (errors.isEmpty()) {
            return true;
        }
        return ValidateUploadHook.displayErrorScreen(errors);
    }

    private static boolean displayErrorScreen(List<TestError> errors) {
        JPanel p = new JPanel(new GridBagLayout());
        ValidatorTreePanel errorPanel = new ValidatorTreePanel(errors);
        errorPanel.expandAll();
        HtmlPanel pnlMessage = new HtmlPanel();
        pnlMessage.setText("<html><body>" + I18n.tr("The following are results of automatic validation. Try fixing these, but be careful (don''t destroy valid data). When in doubt ignore them.<br>When you cancel this dialog, you can find the entries in the validator side panel to inspect them.", new Object[0]) + "<table align=\"center\"><tr><td align=\"left\"><b>" + I18n.tr("Errors", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Usually this should be fixed.", new Object[0]) + "</td></tr><tr><td align=\"left\"><b>" + I18n.tr("Warnings", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Fix these when possible.", new Object[0]) + "</td></tr><tr><td align=\"left\"><b>" + I18n.tr("Other", new Object[0]) + "&nbsp;</b></td><td align=\"left\">" + I18n.tr("Informational warnings, expect many false entries.", new Object[0]) + "</td></tr></table>");
        pnlMessage.setPreferredSize(new Dimension(500, 150));
        p.add((Component)pnlMessage, GBC.eol().fill(2));
        p.add((Component)new JScrollPane(errorPanel), GBC.eol().fill(1));
        ExtendedDialog ed = new ExtendedDialog(Main.parent, I18n.tr("Suspicious data found. Upload anyway?", new Object[0]), I18n.tr("Continue upload", new Object[0]), I18n.tr("Cancel", new Object[0])).setButtonIcons("ok", "cancel").setContent(p);
        if (ed.showDialog().getValue() != 1) {
            OsmValidator.initializeTests();
            OsmValidator.initializeErrorLayer();
            MainApplication.getMap().validatorDialog.unfurlDialog();
            MainApplication.getLayerManager().getLayersOfType(ValidatorLayer.class).forEach(AbstractMapViewPaintable::invalidate);
            return false;
        }
        return true;
    }
}

