/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLConnection;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.bouncycastle.jsse.provider.ProvTlsClient;
import org.bouncycastle.jsse.provider.ProvTlsManager;
import org.bouncycastle.jsse.provider.ProvTlsPeer;
import org.bouncycastle.jsse.provider.ProvTlsServer;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;

class ProvSSLSocketWrap
extends ProvSSLSocketBase
implements ProvTlsManager {
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final Socket wrapSocket;
    protected final String wrapHost;
    protected final int wrapPort;
    protected final boolean wrapAutoClose;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    protected ProvSSLSocketWrap(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, Socket socket, String string, int n, boolean bl) {
        this.context = provSSLContextSpi;
        this.contextData = contextData;
        this.wrapSocket = socket;
        this.wrapHost = string;
        this.wrapPort = n;
        this.wrapAutoClose = bl;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(provSSLContextSpi);
    }

    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    public ContextData getContextData() {
        return this.contextData;
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        throw new SocketException("Wrapped socket should already be bound");
    }

    public synchronized void close() throws IOException {
        if (this.protocol != null) {
            this.protocol.close();
        }
        if (this.wrapAutoClose) {
            this.wrapSocket.close();
        }
    }

    public void connect(SocketAddress socketAddress, int n) throws IOException {
        throw new SocketException("Wrapped socket should already be connected");
    }

    public SocketChannel getChannel() {
        return this.wrapSocket.getChannel();
    }

    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connection;
    }

    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    public InetAddress getInetAddress() {
        return this.wrapSocket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.wrapSocket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.wrapSocket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.wrapSocket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.wrapSocket.getLocalSocketAddress();
    }

    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    public int getPort() {
        return this.wrapSocket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.wrapSocket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.wrapSocket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.wrapSocket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.wrapSocket.getSendBufferSize();
    }

    public synchronized SSLSession getSession() {
        BCSSLConnection bCSSLConnection = this.getConnection();
        return bCSSLConnection == null ? ProvSSLSessionImpl.NULL_SESSION.getExportSession() : bCSSLConnection.getSession();
    }

    public int getSoLinger() throws SocketException {
        return this.wrapSocket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.wrapSocket.getSoTimeout();
    }

    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.wrapSocket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.wrapSocket.getTrafficClass();
    }

    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    public boolean isBound() {
        return this.wrapSocket.isBound();
    }

    public boolean isConnected() {
        return this.wrapSocket.isConnected();
    }

    public synchronized boolean isClosed() {
        return this.protocol != null && this.protocol.isClosed();
    }

    public boolean isInputShutdown() {
        return this.wrapSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.wrapSocket.isOutputShutdown();
    }

    public synchronized void setEnabledCipherSuites(String[] stringArray) {
        if (!this.context.isSupportedCipherSuites(stringArray)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(stringArray);
    }

    public synchronized void setEnabledProtocols(String[] stringArray) {
        if (!this.context.isSupportedProtocols(stringArray)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.wrapSocket.setKeepAlive(bl);
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.sslParameters.setNeedClientAuth(bl);
    }

    public void setPerformancePreferences(int n, int n2, int n3) {
        this.wrapSocket.setPerformancePreferences(n, n2, n3);
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.wrapSocket.setReceiveBufferSize(n);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.wrapSocket.setReuseAddress(bl);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.wrapSocket.setSendBufferSize(n);
    }

    public synchronized void setSSLParameters(SSLParameters sSLParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sSLParameters);
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
        this.wrapSocket.setSoLinger(bl, n);
    }

    public void setSoTimeout(int n) throws SocketException {
        this.wrapSocket.setSoTimeout(n);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.wrapSocket.setTcpNoDelay(bl);
    }

    public void setTrafficClass(int n) throws SocketException {
        this.wrapSocket.setTrafficClass(n);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (this.initialHandshakeBegun && bl != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = bl;
    }

    public synchronized void setWantClientAuth(boolean bl) {
        this.sslParameters.setWantClientAuth(bl);
    }

    public synchronized void startHandshake() throws IOException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(this.wrapSocket.getInputStream(), this.wrapSocket.getOutputStream());
                this.protocol = tlsClientProtocol;
                ProvTlsClient provTlsClient = new ProvTlsClient(this);
                this.protocolPeer = provTlsClient;
                tlsClientProtocol.connect(provTlsClient);
            } else {
                TlsServerProtocol tlsServerProtocol = new TlsServerProtocol(this.wrapSocket.getInputStream(), this.wrapSocket.getOutputStream());
                this.protocol = tlsServerProtocol;
                ProvTlsServer provTlsServer = new ProvTlsServer(this);
                this.protocolPeer = provTlsServer;
                tlsServerProtocol.accept(provTlsServer);
            }
        }
        finally {
            this.handshakeSession = null;
        }
    }

    public String toString() {
        return this.wrapSocket.toString();
    }

    public String getPeerHost() {
        return this.wrapHost;
    }

    public int getPeerPort() {
        return this.getPort();
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkClientTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        X509TrustManager x509TrustManager = this.contextData.getTrustManager();
        if (x509TrustManager != null) {
            try {
                x509TrustManager.checkServerTrusted(x509CertificateArray, string);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    public synchronized void notifyHandshakeComplete(ProvSSLConnection provSSLConnection) {
        this.connection = provSSLConnection;
    }

    synchronized void handshakeIfNecessary() throws IOException {
        if (!this.initialHandshakeBegun) {
            this.startHandshake();
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int available() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                return ProvSSLSocketWrap.this.protocol == null ? 0 : ProvSSLSocketWrap.this.protocol.applicationDataAvailable();
            }
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        public int read() throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            byte[] byArray = new byte[1];
            int n = ProvSSLSocketWrap.this.protocol.readApplicationData(byArray, 0, 1);
            return n < 0 ? -1 : byArray[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (n2 < 1) {
                return 0;
            }
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            return ProvSSLSocketWrap.this.protocol.readApplicationData(byArray, n, n2);
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        public void close() throws IOException {
            ProvSSLSocketWrap.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ProvSSLSocketWrap provSSLSocketWrap = ProvSSLSocketWrap.this;
            synchronized (provSSLSocketWrap) {
                if (ProvSSLSocketWrap.this.protocol != null) {
                    ProvSSLSocketWrap.this.protocol.flush();
                }
            }
        }

        public void write(int n) throws IOException {
            ProvSSLSocketWrap.this.handshakeIfNecessary();
            byte[] byArray = new byte[]{(byte)n};
            ProvSSLSocketWrap.this.protocol.writeApplicationData(byArray, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n2 > 0) {
                ProvSSLSocketWrap.this.handshakeIfNecessary();
                ProvSSLSocketWrap.this.protocol.writeApplicationData(byArray, n, n2);
            }
        }
    }
}

