/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.protege.editor.core.ModelManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.ui.util.Icons;
import org.protege.editor.core.ui.wizard.WizardPanel;

public abstract class AbstractWizardPanel
extends WizardPanel {
    private final JTextArea instructionArea = new JTextArea();
    private JPanel marginPanel = new JPanel(new BorderLayout());
    private JLabel marginLabel = new JLabel();
    private Icon backgroundImage;
    private boolean notifyDisplaying;
    private String title;
    private EditorKit editorKit;
    private JPanel contentHolder = new JPanel(new BorderLayout());
    private static Set<Class> nonTransparentComponents = new HashSet<Class>();

    public AbstractWizardPanel(Object id, String title, EditorKit editorKit) {
        super(id);
        this.editorKit = editorKit;
        this.title = title;
        this.notifyDisplaying = true;
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (AbstractWizardPanel.this.isShowing()) {
                    if (AbstractWizardPanel.this.notifyDisplaying) {
                        AbstractWizardPanel.this.displayingPanel();
                    } else {
                        AbstractWizardPanel.this.notifyDisplaying = false;
                    }
                } else {
                    AbstractWizardPanel.this.notifyDisplaying = true;
                }
            }
        });
        this.createUI();
    }

    public ModelManager getModelManager() {
        return this.editorKit.getModelManager();
    }

    public EditorKit getEditorKit() {
        return this.editorKit;
    }

    public void setBackgroundImage(String name) {
        this.backgroundImage = Icons.getIcon(name);
    }

    public void setMarginImage(Icon icon) {
        this.marginLabel.setIcon(icon);
    }

    protected final void createUI() {
        this.backgroundImage = Icons.getIcon("logo.wizard.png");
        this.setLayout(new BorderLayout(7, 7));
        this.marginPanel.setPreferredSize(new Dimension(150, 400));
        this.add((Component)this.marginPanel, "West");
        this.marginPanel.setOpaque(false);
        this.marginPanel.setEnabled(false);
        this.marginPanel.add((Component)this.marginLabel, "North");
        this.marginLabel.setBorder(BorderFactory.createEmptyBorder(30, 8, 0, 0));
        this.instructionArea.setBorder(null);
        this.instructionArea.setOpaque(false);
        this.instructionArea.setWrapStyleWord(true);
        this.instructionArea.setLineWrap(true);
        this.instructionArea.setEditable(false);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel containerPanel = new JPanel(new BorderLayout(7, 7));
        this.add(containerPanel);
        containerPanel.setOpaque(false);
        JLabel label = new JLabel(this.title);
        label.setOpaque(false);
        label.setFont(label.getFont().deriveFont(1, 14.0f));
        containerPanel.add((Component)label, "North");
        HolderPanel contentAndInstructionHolder = new HolderPanel();
        contentAndInstructionHolder.add((Component)this.instructionArea, "North");
        JPanel contentBorderPanel = new JPanel(new BorderLayout());
        contentBorderPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 0, 0));
        contentBorderPanel.add(this.contentHolder);
        contentBorderPanel.setOpaque(false);
        this.contentHolder.setOpaque(false);
        contentAndInstructionHolder.add((Component)contentBorderPanel, "Center");
        containerPanel.add(contentAndInstructionHolder);
        this.createUI(this.contentHolder);
        this.setComponentTransparency(this.contentHolder);
    }

    protected void setContent(JComponent content) {
        this.setComponentTransparency(content);
        this.contentHolder.add(content);
    }

    protected void setComponentTransparency(Component component) {
        if (component instanceof JComponent) {
            for (Class c : nonTransparentComponents) {
                if (!c.isInstance(component)) continue;
                return;
            }
            ((JComponent)component).setOpaque(false);
        }
        if (component instanceof Container) {
            Component[] components;
            Container container = (Container)component;
            for (Component c : components = container.getComponents()) {
                this.setComponentTransparency(c);
            }
        }
    }

    public void setBackgroundImage(Icon imageIcon) {
        this.backgroundImage = imageIcon;
    }

    public void setInstructions(String instructions) {
        this.instructionArea.setText(instructions);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(800, 550);
    }

    @Deprecated
    protected void createUI(JComponent parent) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.backgroundImage != null) {
            this.backgroundImage.paintIcon(this, g, 0, 0);
        }
    }

    static {
        nonTransparentComponents.add(JTextComponent.class);
        nonTransparentComponents.add(JList.class);
        nonTransparentComponents.add(JTree.class);
        nonTransparentComponents.add(JTable.class);
        nonTransparentComponents.add(JScrollPane.class);
        nonTransparentComponents.add(JComboBox.class);
    }

    private class HolderPanel
    extends JPanel {
        private Color color;

        public HolderPanel() {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(20, 20, 20, 20)));
            this.setLayout(new BorderLayout(7, 20));
            this.setOpaque(false);
            this.color = new Color(255, 255, 255, 230);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle r = g.getClipBounds();
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.color);
            g2.fillRect(r.x, r.y, r.width, r.height);
        }
    }
}

