/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.InputDevice;
import javax.media.j3d.InputDeviceBlockingThread;
import javax.media.j3d.J3dThread;
import javax.media.j3d.J3dThreadData;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.VirtualUniverse;

class InputDeviceScheduler
extends J3dThread {
    ArrayList nonBlockingDevices = new ArrayList(1);
    ArrayList blockingDevices = new ArrayList(1);
    ArrayList threads = new ArrayList(1);
    PhysicalEnvironment physicalEnv;
    J3dThreadData threadData = new J3dThreadData();
    boolean active = false;
    static int samplingTime = 5;
    private static int numInstances = 0;
    private int instanceNum = -1;

    private synchronized int newInstanceNum() {
        return ++numInstances;
    }

    int getInstanceNum() {
        if (this.instanceNum == -1) {
            this.instanceNum = this.newInstanceNum();
        }
        return this.instanceNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputDeviceScheduler(ThreadGroup threadGroup, PhysicalEnvironment physicalEnvironment) {
        super(threadGroup);
        this.setName("J3D-InputDeviceScheduler-" + this.getInstanceNum());
        this.threadData.threadType = 4;
        this.threadData.thread = this;
        this.physicalEnv = physicalEnvironment;
        Vector<InputDevice> vector = physicalEnvironment.devices;
        synchronized (vector) {
            for (InputDevice inputDevice : physicalEnvironment.devices) {
                this.addInputDevice(inputDevice);
            }
            physicalEnvironment.inputsched = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInputDevice(InputDevice inputDevice) {
        switch (inputDevice.getProcessingMode()) {
            case 3: {
                InputDeviceBlockingThread inputDeviceBlockingThread = VirtualUniverse.mc.getInputDeviceBlockingThread(inputDevice);
                inputDeviceBlockingThread.start();
                ArrayList arrayList = this.blockingDevices;
                synchronized (arrayList) {
                    this.threads.add(inputDeviceBlockingThread);
                    this.blockingDevices.add(inputDevice);
                    break;
                }
            }
            case 4: {
                ArrayList arrayList = this.nonBlockingDevices;
                synchronized (arrayList) {
                    this.nonBlockingDevices.add(inputDevice);
                    if (this.active && this.nonBlockingDevices.size() == 1) {
                        VirtualUniverse.mc.addInputDeviceScheduler(this);
                    }
                    break;
                }
            }
            default: {
                for (int i = inputDevice.getSensorCount() - 1; i >= 0; --i) {
                    inputDevice.getSensor((int)i).demand_driven = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInputDevice(InputDevice inputDevice) {
        switch (inputDevice.getProcessingMode()) {
            case 3: {
                ArrayList arrayList = this.blockingDevices;
                synchronized (arrayList) {
                    int n = this.blockingDevices.indexOf(inputDevice);
                    InputDeviceBlockingThread inputDeviceBlockingThread = (InputDeviceBlockingThread)this.threads.remove(n);
                    inputDeviceBlockingThread.finish();
                    this.blockingDevices.remove(n);
                    break;
                }
            }
            case 4: {
                ArrayList arrayList = this.nonBlockingDevices;
                synchronized (arrayList) {
                    this.nonBlockingDevices.remove(this.nonBlockingDevices.indexOf(inputDevice));
                    if (this.active && this.nonBlockingDevices.size() == 0) {
                        VirtualUniverse.mc.removeInputDeviceScheduler(this);
                    }
                    break;
                }
            }
            default: {
                for (int i = inputDevice.getSensorCount() - 1; i >= 0; --i) {
                    inputDevice.getSensor((int)i).demand_driven = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        if (!this.active) {
            this.active = true;
            ArrayList arrayList = this.nonBlockingDevices;
            synchronized (arrayList) {
                if (this.nonBlockingDevices.size() > 0) {
                    VirtualUniverse.mc.addInputDeviceScheduler(this);
                }
            }
            arrayList = this.blockingDevices;
            synchronized (arrayList) {
                for (int i = this.threads.size() - 1; i >= 0; --i) {
                    ((InputDeviceBlockingThread)this.threads.get(i)).restart();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate() {
        if (this.active) {
            ArrayList arrayList = this.nonBlockingDevices;
            synchronized (arrayList) {
                if (this.nonBlockingDevices.size() > 0) {
                    VirtualUniverse.mc.removeInputDeviceScheduler(this);
                }
            }
            arrayList = this.blockingDevices;
            synchronized (arrayList) {
                for (int i = this.threads.size() - 1; i >= 0; --i) {
                    ((InputDeviceBlockingThread)this.threads.get(i)).sleep();
                }
            }
            this.active = false;
        }
    }

    J3dThreadData getThreadData() {
        return this.threadData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork(long l) {
        ArrayList arrayList = this.nonBlockingDevices;
        synchronized (arrayList) {
            for (int i = this.nonBlockingDevices.size() - 1; i >= 0; --i) {
                ((InputDevice)this.nonBlockingDevices.get(i)).pollAndProcessInput();
            }
        }
    }

    void shutdown() {
        for (int i = this.threads.size() - 1; i >= 0; --i) {
            ((InputDeviceBlockingThread)this.threads.get(i)).finish();
        }
        this.threads.clear();
        this.blockingDevices.clear();
        this.nonBlockingDevices.clear();
    }
}

