//============================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  Copyright 2015 National Technology & Engineering Solutions of Sandia, LLC (NTESS).
//  Copyright 2015 UT-Battelle, LLC.
//  Copyright 2015 Los Alamos National Security.
//
//  Under the terms of Contract DE-NA0003525 with NTESS,
//  the U.S. Government retains certain rights in this software.
//
//  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
//  Laboratory (LANL), the U.S. Government retains certain rights in
//  this software.
//============================================================================
#ifndef vtk_m_ClipTables_h
#define vtk_m_ClipTables_h

#include <vtkm/CellShape.h>
#include <vtkm/Types.h>

#include <vtkm/cont/ArrayHandle.h>

namespace vtkm
{
namespace worklet
{
namespace internal
{

// table format:
// ncells, {{celltype, nverts, {edge/verts(>=100), ...}}, ...}, \n
// values < 100 represent edges where the corresponding vertex lies
// values >= 100 reresent existing vertices of the input cell (vertex = value - 100)
static vtkm::UInt8 ClipTablesData[] = {
  // vtkm::CELL_SHAPE_VERTEX
  0, // 0
  1,
  1,
  1,
  100, // 1
       // vtkm::CELL_SHAPE_LINE
  0,   // 0
  1,
  3,
  2,
  100,
  0, // 1
  1,
  3,
  2,
  0,
  101, // 2
  1,
  3,
  2,
  100,
  101, // 3
       // vtkm::CELL_SHAPE_TRIANGLE
  0,   // 0
  1,
  5,
  3,
  0,
  2,
  100, // 1
  1,
  5,
  3,
  1,
  0,
  101, // 2
  2,
  5,
  3,
  1,
  2,
  100,
  5,
  3,
  1,
  100,
  101, // 3
  1,
  5,
  3,
  2,
  1,
  102, // 4
  2,
  5,
  3,
  0,
  1,
  102,
  5,
  3,
  102,
  100,
  0, // 5
  2,
  5,
  3,
  0,
  101,
  2,
  5,
  3,
  2,
  101,
  102, // 6
  1,
  5,
  3,
  100,
  101,
  102, // 7
       // vtkm::CELL_SHAPE_QUAD
  0,   // 0
  1,
  5,
  3,
  100,
  0,
  3, // 1
  1,
  5,
  3,
  101,
  1,
  0, // 2
  1,
  9,
  4,
  100,
  101,
  1,
  3, // 3
  1,
  5,
  3,
  102,
  2,
  1, // 4
  3,
  5,
  3,
  100,
  0,
  3,
  5,
  3,
  102,
  2,
  1,
  9,
  4,
  0,
  1,
  2,
  3, // 5
  1,
  9,
  4,
  101,
  102,
  2,
  0, // 6
  3,
  5,
  3,
  100,
  101,
  3,
  5,
  3,
  101,
  2,
  3,
  5,
  3,
  101,
  102,
  2, // 7
  1,
  5,
  3,
  103,
  3,
  2, // 8
  1,
  9,
  4,
  100,
  0,
  2,
  103, // 9
  3,
  5,
  3,
  101,
  1,
  0,
  5,
  3,
  103,
  3,
  2,
  9,
  4,
  0,
  1,
  2,
  3, // 10
  3,
  5,
  3,
  100,
  101,
  1,
  5,
  3,
  100,
  1,
  2,
  5,
  3,
  100,
  2,
  103, // 11
  1,
  9,
  4,
  102,
  103,
  3,
  1, // 12
  3,
  5,
  3,
  100,
  0,
  103,
  5,
  3,
  0,
  1,
  103,
  5,
  3,
  1,
  102,
  103, // 13
  3,
  5,
  3,
  0,
  101,
  102,
  5,
  3,
  0,
  102,
  3,
  5,
  3,
  102,
  103,
  3, // 14
  1,
  9,
  4,
  100,
  101,
  102,
  103, // 15
       // vtkm::CELL_SHAPE_TETRA
  0,   // 0
  1,
  10,
  4,
  0,
  3,
  2,
  100, // 1
  1,
  10,
  4,
  0,
  1,
  4,
  101, // 2
  1,
  13,
  6,
  101,
  1,
  4,
  100,
  2,
  3, // 3
  1,
  10,
  4,
  1,
  2,
  5,
  102, // 4
  1,
  13,
  6,
  102,
  5,
  1,
  100,
  3,
  0, // 5
  1,
  13,
  6,
  102,
  2,
  5,
  101,
  0,
  4, // 6
  1,
  13,
  6,
  3,
  4,
  5,
  100,
  101,
  102, // 7
  1,
  10,
  4,
  3,
  4,
  5,
  103, // 8
  1,
  13,
  6,
  103,
  4,
  5,
  100,
  0,
  2, // 9
  1,
  13,
  6,
  103,
  5,
  3,
  101,
  1,
  0, // 10
  1,
  13,
  6,
  100,
  101,
  103,
  2,
  1,
  5, // 11
  1,
  13,
  6,
  2,
  102,
  1,
  3,
  103,
  4, // 12
  1,
  13,
  6,
  0,
  1,
  4,
  100,
  102,
  103, // 13
  1,
  13,
  6,
  0,
  3,
  2,
  101,
  103,
  102, // 14
  1,
  10,
  4,
  100,
  101,
  102,
  103, // 15
       // vtkm::CELL_SHAPE_HEXAHEDRON
  0,   // 0
  1,
  10,
  4,
  0,
  3,
  100,
  8, // 1
  1,
  10,
  4,
  101,
  1,
  0,
  9, // 2
  3,
  10,
  4,
  1,
  8,
  101,
  9,
  10,
  4,
  1,
  3,
  100,
  8,
  10,
  4,
  101,
  1,
  100,
  8, // 3
  1,
  10,
  4,
  102,
  2,
  1,
  11, // 4
  5,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  8,
  1,
  11,
  10,
  4,
  1,
  2,
  0,
  8,
  10,
  4,
  2,
  3,
  0,
  8,
  10,
  4,
  100,
  0,
  3,
  8, // 5
  3,
  10,
  4,
  2,
  9,
  102,
  11,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  102,
  0,
  101,
  9, // 6
  7,
  10,
  4,
  8,
  9,
  2,
  11,
  10,
  4,
  2,
  9,
  102,
  11,
  10,
  4,
  2,
  3,
  101,
  9,
  10,
  4,
  3,
  8,
  101,
  9,
  10,
  4,
  2,
  8,
  3,
  9,
  10,
  4,
  102,
  2,
  101,
  9,
  10,
  4,
  101,
  3,
  100,
  8, // 7
  1,
  10,
  4,
  103,
  3,
  2,
  10, // 8
  3,
  10,
  4,
  103,
  8,
  2,
  10,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  100,
  0,
  103,
  8, // 9
  5,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  9,
  2,
  10,
  10,
  4,
  2,
  3,
  0,
  9,
  10,
  4,
  1,
  2,
  0,
  9,
  10,
  4,
  101,
  1,
  0,
  9, // 10
  7,
  10,
  4,
  8,
  9,
  2,
  10,
  10,
  4,
  103,
  8,
  2,
  10,
  10,
  4,
  2,
  8,
  1,
  9,
  10,
  4,
  1,
  8,
  101,
  9,
  10,
  4,
  100,
  2,
  103,
  8,
  10,
  4,
  1,
  2,
  100,
  8,
  10,
  4,
  101,
  1,
  100,
  8, // 11
  3,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  103,
  3,
  1,
  10, // 12
  7,
  10,
  4,
  1,
  10,
  8,
  11,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  0,
  1,
  103,
  10,
  10,
  4,
  0,
  103,
  8,
  10,
  10,
  4,
  0,
  8,
  1,
  10,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  100,
  0,
  103,
  8, // 13
  7,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  102,
  0,
  9,
  11,
  10,
  4,
  3,
  9,
  0,
  11,
  10,
  4,
  3,
  102,
  10,
  11,
  10,
  4,
  3,
  10,
  9,
  11,
  10,
  4,
  103,
  3,
  102,
  10,
  10,
  4,
  102,
  0,
  101,
  9, // 14
  6,
  10,
  4,
  102,
  10,
  9,
  11,
  10,
  4,
  8,
  9,
  102,
  10,
  10,
  4,
  103,
  8,
  102,
  10,
  10,
  4,
  102,
  8,
  101,
  9,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  101,
  102,
  100,
  8, // 15
  1,
  10,
  4,
  104,
  7,
  4,
  8, // 16
  3,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  0,
  3,
  104,
  4,
  10,
  4,
  104,
  0,
  100,
  3, // 17
  5,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  0,
  4,
  7,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  0,
  4,
  1,
  7, // 18
  7,
  10,
  4,
  100,
  1,
  3,
  9,
  10,
  4,
  100,
  3,
  4,
  9,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  100,
  101,
  1,
  9,
  10,
  4,
  3,
  4,
  1,
  7,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  100,
  3,
  104,
  4, // 19
  6,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  4,
  1,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  4,
  7,
  2,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  1,
  4,
  2,
  8, // 20
  9,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  4,
  1,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  3,
  4,
  2,
  7,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  104,
  0,
  3,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  104,
  0,
  100,
  3, // 21
  10,
  10,
  4,
  102,
  2,
  9,
  11,
  10,
  4,
  4,
  9,
  2,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  2,
  4,
  0,
  9,
  10,
  4,
  101,
  102,
  0,
  9,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  0,
  4,
  7,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  0,
  4,
  2,
  7, // 22
  11,
  10,
  4,
  102,
  2,
  9,
  11,
  10,
  4,
  4,
  9,
  2,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  101,
  102,
  2,
  9,
  10,
  4,
  101,
  2,
  3,
  9,
  10,
  4,
  2,
  4,
  3,
  9,
  10,
  4,
  101,
  3,
  100,
  9,
  10,
  4,
  3,
  4,
  100,
  9,
  10,
  4,
  3,
  4,
  2,
  7,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  100,
  3,
  104,
  4, // 23
  5,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  3,
  4,
  2,
  7, // 24
  7,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  0,
  2,
  103,
  10,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  0,
  104,
  4,
  7,
  10,
  4,
  0,
  4,
  2,
  7,
  10,
  4,
  104,
  0,
  100,
  7, // 25
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  3,
  4,
  2,
  7,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4, // 26
  7,
  10,
  4,
  103,
  100,
  2,
  10,
  10,
  4,
  100,
  7,
  2,
  10,
  10,
  4,
  101,
  1,
  100,
  9,
  10,
  4,
  1,
  4,
  100,
  9,
  10,
  4,
  100,
  4,
  2,
  7,
  10,
  4,
  104,
  4,
  100,
  7,
  10,
  4,
  1,
  2,
  100,
  4, // 27
  10,
  10,
  4,
  1,
  10,
  7,
  11,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  1,
  7,
  4,
  11,
  10,
  4,
  103,
  3,
  1,
  10,
  10,
  4,
  3,
  7,
  1,
  10,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  3,
  4,
  1,
  7, // 28
  11,
  10,
  4,
  1,
  10,
  7,
  11,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  1,
  7,
  4,
  11,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  0,
  1,
  103,
  10,
  10,
  4,
  0,
  7,
  1,
  10,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  104,
  0,
  100,
  7,
  10,
  4,
  104,
  4,
  0,
  7,
  10,
  4,
  0,
  4,
  1,
  7, // 29
  15,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  102,
  0,
  9,
  11,
  10,
  4,
  3,
  9,
  0,
  11,
  10,
  4,
  3,
  10,
  9,
  11,
  10,
  4,
  102,
  10,
  3,
  11,
  10,
  4,
  9,
  10,
  7,
  11,
  10,
  4,
  4,
  9,
  7,
  11,
  10,
  4,
  7,
  9,
  3,
  10,
  10,
  4,
  102,
  103,
  3,
  10,
  10,
  4,
  3,
  7,
  4,
  9,
  10,
  4,
  3,
  4,
  0,
  9,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  0,
  4,
  3,
  8, // 30
  10,
  10,
  4,
  9,
  10,
  7,
  11,
  10,
  4,
  102,
  10,
  9,
  11,
  10,
  4,
  4,
  9,
  7,
  11,
  10,
  4,
  103,
  100,
  9,
  10,
  10,
  4,
  7,
  9,
  100,
  10,
  10,
  4,
  103,
  9,
  102,
  10,
  10,
  4,
  100,
  7,
  4,
  9,
  10,
  4,
  102,
  103,
  100,
  9,
  10,
  4,
  101,
  102,
  100,
  9,
  10,
  4,
  104,
  4,
  100,
  7, // 31
  1,
  10,
  4,
  4,
  5,
  105,
  9, // 32
  5,
  10,
  4,
  105,
  4,
  5,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  3,
  4,
  0,
  5, // 33
  3,
  10,
  4,
  1,
  4,
  105,
  5,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  101,
  0,
  105,
  1, // 34
  7,
  10,
  4,
  100,
  101,
  1,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  100,
  1,
  3,
  8,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  3,
  4,
  1,
  5,
  10,
  4,
  1,
  4,
  105,
  5,
  10,
  4,
  105,
  1,
  101,
  4, // 35
  5,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  105,
  4,
  5,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  2,
  4,
  1,
  5, // 36
  10,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  105,
  4,
  5,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  2,
  3,
  0,
  4, // 37
  7,
  10,
  4,
  102,
  2,
  0,
  11,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  101,
  102,
  0,
  11,
  10,
  4,
  101,
  0,
  5,
  11,
  10,
  4,
  105,
  0,
  4,
  5,
  10,
  4,
  2,
  4,
  0,
  5,
  10,
  4,
  101,
  0,
  105,
  5, // 38
  7,
  10,
  4,
  101,
  102,
  2,
  11,
  10,
  4,
  101,
  2,
  5,
  11,
  10,
  4,
  101,
  3,
  100,
  8,
  10,
  4,
  101,
  4,
  3,
  8,
  10,
  4,
  101,
  2,
  4,
  5,
  10,
  4,
  101,
  4,
  105,
  5,
  10,
  4,
  101,
  2,
  3,
  4, // 39
  6,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  4,
  2,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  4,
  5,
  105,
  9,
  10,
  4,
  2,
  5,
  4,
  9,
  10,
  4,
  2,
  4,
  3,
  9, // 40
  10,
  10,
  4,
  2,
  103,
  8,
  10,
  10,
  4,
  2,
  8,
  4,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  105,
  4,
  5,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  0,
  4,
  2,
  8,
  10,
  4,
  103,
  100,
  0,
  8,
  10,
  4,
  2,
  4,
  0,
  5, // 41
  9,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  4,
  2,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  105,
  1,
  4,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  101,
  0,
  105,
  1, // 42
  11,
  10,
  4,
  2,
  8,
  4,
  10,
  10,
  4,
  103,
  8,
  2,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  101,
  1,
  100,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  1,
  2,
  100,
  8,
  10,
  4,
  1,
  4,
  2,
  8,
  10,
  4,
  103,
  100,
  2,
  8,
  10,
  4,
  105,
  1,
  4,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  101,
  105,
  1,
  4, // 43
  10,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  103,
  3,
  1,
  10,
  10,
  4,
  3,
  5,
  1,
  10,
  10,
  4,
  4,
  5,
  3,
  10,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  4,
  5,
  105,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  3,
  4,
  1,
  5, // 44
  14,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  0,
  1,
  103,
  10,
  10,
  4,
  0,
  103,
  8,
  10,
  10,
  4,
  0,
  8,
  1,
  10,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  1,
  8,
  5,
  10,
  10,
  4,
  5,
  8,
  4,
  10,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  4,
  5,
  105,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  4,
  5,
  1,
  8,
  10,
  4,
  0,
  4,
  1,
  8,
  10,
  4,
  103,
  100,
  0,
  8, // 45
  11,
  10,
  4,
  3,
  10,
  5,
  11,
  10,
  4,
  102,
  10,
  3,
  11,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  102,
  0,
  101,
  11,
  10,
  4,
  0,
  5,
  101,
  11,
  10,
  4,
  102,
  103,
  3,
  10,
  10,
  4,
  4,
  5,
  3,
  10,
  10,
  4,
  101,
  0,
  105,
  5,
  10,
  4,
  0,
  4,
  105,
  5,
  10,
  4,
  3,
  4,
  0,
  5, // 46
  10,
  10,
  4,
  8,
  10,
  5,
  11,
  10,
  4,
  102,
  10,
  8,
  11,
  10,
  4,
  101,
  102,
  8,
  11,
  10,
  4,
  101,
  8,
  5,
  11,
  10,
  4,
  103,
  8,
  102,
  10,
  10,
  4,
  5,
  8,
  4,
  10,
  10,
  4,
  101,
  4,
  5,
  8,
  10,
  4,
  101,
  102,
  100,
  8,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  101,
  4,
  105,
  5, // 47
  3,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  104,
  7,
  5,
  8, // 48
  7,
  10,
  4,
  0,
  5,
  7,
  9,
  10,
  4,
  104,
  7,
  5,
  9,
  10,
  4,
  0,
  7,
  104,
  9,
  10,
  4,
  105,
  104,
  5,
  9,
  10,
  4,
  0,
  3,
  104,
  7,
  10,
  4,
  0,
  5,
  3,
  7,
  10,
  4,
  104,
  0,
  100,
  3, // 49
  7,
  10,
  4,
  0,
  5,
  7,
  8,
  10,
  4,
  104,
  7,
  5,
  8,
  10,
  4,
  105,
  104,
  5,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  0,
  5,
  1,
  7,
  10,
  4,
  105,
  1,
  0,
  5,
  10,
  4,
  101,
  0,
  105,
  1, // 50
  6,
  10,
  4,
  104,
  5,
  3,
  7,
  10,
  4,
  1,
  3,
  104,
  5,
  10,
  4,
  105,
  1,
  104,
  5,
  10,
  4,
  100,
  104,
  1,
  3,
  10,
  4,
  104,
  105,
  101,
  1,
  10,
  4,
  100,
  104,
  101,
  1, // 51
  10,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  105,
  104,
  5,
  8,
  10,
  4,
  1,
  5,
  7,
  8,
  10,
  4,
  104,
  7,
  5,
  8,
  10,
  4,
  1,
  7,
  2,
  8,
  10,
  4,
  1,
  5,
  2,
  7, // 52
  14,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  104,
  0,
  7,
  9,
  10,
  4,
  5,
  7,
  0,
  9,
  10,
  4,
  104,
  7,
  5,
  9,
  10,
  4,
  105,
  104,
  5,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  104,
  0,
  3,
  7,
  10,
  4,
  0,
  5,
  3,
  7,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  104,
  0,
  100,
  3, // 53
  12,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  102,
  2,
  0,
  11,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  102,
  0,
  101,
  11,
  10,
  4,
  0,
  5,
  101,
  11,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  0,
  5,
  7,
  8,
  10,
  4,
  104,
  7,
  5,
  8,
  10,
  4,
  105,
  104,
  5,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  0,
  5,
  2,
  7,
  10,
  4,
  101,
  0,
  105,
  5, // 54
  10,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  102,
  2,
  101,
  11,
  10,
  4,
  2,
  5,
  101,
  11,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  104,
  5,
  3,
  7,
  10,
  4,
  105,
  101,
  3,
  5,
  10,
  4,
  2,
  3,
  101,
  5,
  10,
  4,
  104,
  105,
  3,
  5,
  10,
  4,
  104,
  105,
  101,
  3,
  10,
  4,
  101,
  100,
  104,
  3, // 55
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  5,
  8,
  3,
  9,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  2,
  5,
  3,
  9,
  10,
  4,
  5,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  5,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  3,
  5,
  2,
  7, // 56
  12,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  103,
  0,
  2,
  10,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  0,
  5,
  7,
  9,
  10,
  4,
  104,
  7,
  5,
  9,
  10,
  4,
  0,
  7,
  104,
  9,
  10,
  4,
  105,
  104,
  5,
  9,
  10,
  4,
  0,
  5,
  2,
  7,
  10,
  4,
  104,
  0,
  100,
  7, // 57
  14,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  5,
  7,
  0,
  8,
  10,
  4,
  104,
  7,
  5,
  8,
  10,
  4,
  105,
  104,
  5,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  0,
  5,
  3,
  7,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  105,
  1,
  0,
  5,
  10,
  4,
  101,
  0,
  105,
  1, // 58
  10,
  10,
  4,
  103,
  100,
  2,
  10,
  10,
  4,
  100,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  1,
  104,
  5,
  7,
  10,
  4,
  1,
  5,
  2,
  7,
  10,
  4,
  104,
  1,
  100,
  7,
  10,
  4,
  1,
  2,
  100,
  7,
  10,
  4,
  105,
  1,
  104,
  5,
  10,
  4,
  101,
  100,
  104,
  1,
  10,
  4,
  104,
  105,
  101,
  1, // 59
  12,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  3,
  7,
  5,
  10,
  10,
  4,
  103,
  3,
  1,
  10,
  10,
  4,
  3,
  5,
  1,
  10,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  5,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  5,
  8,
  10,
  4,
  1,
  5,
  3,
  8,
  10,
  4,
  105,
  104,
  5,
  8, // 60
  15,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  102,
  10,
  1,
  11,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  0,
  1,
  103,
  10,
  10,
  4,
  0,
  7,
  1,
  10,
  10,
  4,
  1,
  7,
  5,
  10,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  104,
  0,
  7,
  9,
  10,
  4,
  5,
  7,
  0,
  9,
  10,
  4,
  104,
  7,
  5,
  9,
  10,
  4,
  105,
  104,
  5,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  0,
  5,
  1,
  7,
  10,
  4,
  104,
  0,
  100,
  7, // 61
  15,
  10,
  4,
  3,
  10,
  5,
  11,
  10,
  4,
  102,
  10,
  3,
  11,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  102,
  0,
  101,
  11,
  10,
  4,
  0,
  5,
  101,
  11,
  10,
  4,
  3,
  7,
  5,
  10,
  10,
  4,
  102,
  103,
  3,
  10,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  0,
  5,
  7,
  8,
  10,
  4,
  104,
  7,
  5,
  8,
  10,
  4,
  105,
  104,
  5,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  0,
  5,
  3,
  7,
  10,
  4,
  101,
  0,
  105,
  5, // 62
  9,
  10,
  4,
  101,
  102,
  10,
  11,
  10,
  4,
  101,
  10,
  5,
  11,
  10,
  4,
  100,
  7,
  5,
  10,
  10,
  4,
  101,
  102,
  100,
  10,
  10,
  4,
  101,
  100,
  5,
  10,
  10,
  4,
  102,
  103,
  100,
  10,
  10,
  4,
  104,
  5,
  100,
  7,
  10,
  4,
  104,
  105,
  101,
  5,
  10,
  4,
  101,
  100,
  104,
  5, // 63
  1,
  10,
  4,
  5,
  6,
  106,
  11, // 64
  6,
  10,
  4,
  5,
  6,
  106,
  11,
  10,
  4,
  3,
  6,
  5,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  5,
  3,
  8,
  10,
  4,
  5,
  6,
  3,
  8, // 65
  5,
  10,
  4,
  5,
  6,
  106,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  0,
  5,
  1,
  6, // 66
  10,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  101,
  1,
  8,
  9,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  100,
  101,
  1,
  8,
  10,
  4,
  100,
  1,
  3,
  8,
  10,
  4,
  1,
  5,
  3,
  8,
  10,
  4,
  5,
  6,
  3,
  8,
  10,
  4,
  3,
  5,
  1,
  6, // 67
  3,
  10,
  4,
  2,
  5,
  106,
  6,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  102,
  1,
  106,
  2, // 68
  9,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  5,
  3,
  8,
  10,
  4,
  5,
  6,
  3,
  8,
  10,
  4,
  106,
  2,
  5,
  6,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  106,
  102,
  1,
  2, // 69
  7,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  101,
  102,
  0,
  9,
  10,
  4,
  0,
  5,
  2,
  6,
  10,
  4,
  106,
  2,
  5,
  6,
  10,
  4,
  102,
  106,
  2,
  5, // 70
  11,
  10,
  4,
  101,
  102,
  2,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  101,
  2,
  3,
  9,
  10,
  4,
  2,
  5,
  3,
  9,
  10,
  4,
  101,
  3,
  8,
  9,
  10,
  4,
  5,
  8,
  3,
  9,
  10,
  4,
  101,
  3,
  100,
  8,
  10,
  4,
  5,
  6,
  3,
  8,
  10,
  4,
  106,
  2,
  5,
  6,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  106,
  2,
  102,
  5, // 71
  5,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  3,
  5,
  2,
  6, // 72
  10,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  2,
  103,
  8,
  10,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  0,
  6,
  2,
  8,
  10,
  4,
  103,
  100,
  0,
  8,
  10,
  4,
  5,
  6,
  0,
  8,
  10,
  4,
  0,
  5,
  2,
  6, // 73
  10,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5, // 74
  12,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  5,
  6,
  106,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  103,
  8,
  2,
  10,
  10,
  4,
  101,
  1,
  8,
  9,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  103,
  100,
  2,
  8,
  10,
  4,
  101,
  1,
  100,
  8,
  10,
  4,
  1,
  2,
  100,
  8,
  10,
  4,
  1,
  5,
  2,
  8,
  10,
  4,
  5,
  6,
  2,
  8, // 75
  7,
  10,
  4,
  103,
  3,
  1,
  10,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  102,
  1,
  6,
  10,
  10,
  4,
  106,
  1,
  5,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  102,
  1,
  106,
  6, // 76
  11,
  10,
  4,
  0,
  8,
  6,
  10,
  10,
  4,
  103,
  8,
  0,
  10,
  10,
  4,
  0,
  1,
  103,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  102,
  103,
  1,
  10,
  10,
  4,
  102,
  1,
  6,
  10,
  10,
  4,
  103,
  100,
  0,
  8,
  10,
  4,
  5,
  6,
  0,
  8,
  10,
  4,
  102,
  1,
  106,
  6,
  10,
  4,
  106,
  1,
  5,
  6,
  10,
  4,
  0,
  5,
  1,
  6, // 77
  7,
  10,
  4,
  102,
  103,
  3,
  10,
  10,
  4,
  102,
  3,
  6,
  10,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  102,
  5,
  0,
  9,
  10,
  4,
  102,
  3,
  5,
  6,
  10,
  4,
  102,
  5,
  106,
  6,
  10,
  4,
  102,
  3,
  0,
  5, // 78
  10,
  10,
  4,
  102,
  8,
  9,
  10,
  10,
  4,
  6,
  9,
  8,
  10,
  10,
  4,
  102,
  9,
  6,
  10,
  10,
  4,
  102,
  103,
  8,
  10,
  10,
  4,
  102,
  5,
  6,
  9,
  10,
  4,
  5,
  8,
  6,
  9,
  10,
  4,
  101,
  102,
  8,
  9,
  10,
  4,
  101,
  102,
  100,
  8,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  102,
  5,
  106,
  6, // 79
  5,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  5,
  8,
  6,
  11,
  10,
  4,
  4,
  6,
  5,
  8,
  10,
  4,
  4,
  7,
  6,
  8,
  10,
  4,
  104,
  7,
  4,
  8, // 80
  9,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  3,
  6,
  5,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  3,
  4,
  0,
  5,
  10,
  4,
  0,
  3,
  104,
  4,
  10,
  4,
  100,
  104,
  0,
  3, // 81
  10,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  4,
  7,
  0,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  4,
  6,
  0,
  7,
  10,
  4,
  4,
  5,
  1,
  6,
  10,
  4,
  0,
  4,
  1,
  6, // 82
  14,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  100,
  1,
  3,
  9,
  10,
  4,
  100,
  3,
  4,
  9,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  100,
  101,
  1,
  9,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  3,
  4,
  1,
  5,
  10,
  4,
  100,
  3,
  104,
  4, // 83
  9,
  10,
  4,
  4,
  7,
  2,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  1,
  4,
  2,
  8,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  106,
  2,
  5,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  102,
  1,
  106,
  2, // 84
  12,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  106,
  2,
  5,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  104,
  0,
  3,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  104,
  0,
  100,
  3,
  10,
  4,
  106,
  102,
  1,
  2, // 85
  14,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  0,
  4,
  7,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  0,
  4,
  2,
  7,
  10,
  4,
  106,
  2,
  5,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  2,
  4,
  0,
  5,
  10,
  4,
  102,
  106,
  2,
  5, // 86
  14,
  10,
  4,
  102,
  2,
  101,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  2,
  5,
  4,
  9,
  10,
  4,
  101,
  2,
  3,
  9,
  10,
  4,
  2,
  4,
  3,
  9,
  10,
  4,
  101,
  3,
  100,
  9,
  10,
  4,
  3,
  4,
  100,
  9,
  10,
  4,
  104,
  4,
  3,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  106,
  2,
  5,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  102,
  106,
  2,
  5,
  10,
  4,
  100,
  3,
  104,
  4, // 87
  10,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6, // 88
  14,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  103,
  0,
  2,
  10,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  0,
  104,
  4,
  7,
  10,
  4,
  0,
  4,
  2,
  7,
  10,
  4,
  104,
  0,
  100,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  2,
  4,
  0,
  5, // 89
  18,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4, // 90
  15,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  106,
  5,
  6,
  11,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  103,
  100,
  2,
  10,
  10,
  4,
  100,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  101,
  1,
  100,
  9,
  10,
  4,
  1,
  4,
  100,
  9,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  100,
  4,
  2,
  7,
  10,
  4,
  104,
  4,
  100,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  1,
  2,
  100,
  4, // 91
  14,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  1,
  10,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  1,
  6,
  102,
  10,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  106,
  1,
  5,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  102,
  1,
  106,
  6,
  10,
  4,
  3,
  4,
  1,
  5, // 92
  14,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  0,
  7,
  6,
  10,
  10,
  4,
  103,
  0,
  1,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  1,
  6,
  102,
  10,
  10,
  4,
  4,
  6,
  0,
  7,
  10,
  4,
  104,
  4,
  0,
  7,
  10,
  4,
  104,
  0,
  100,
  7,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  4,
  5,
  1,
  6,
  10,
  4,
  1,
  5,
  106,
  6,
  10,
  4,
  102,
  1,
  106,
  6, // 93
  15,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  102,
  10,
  10,
  4,
  3,
  6,
  102,
  10,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  102,
  5,
  0,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  4,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  102,
  3,
  5,
  6,
  10,
  4,
  102,
  5,
  106,
  6,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  3,
  4,
  0,
  5,
  10,
  4,
  102,
  3,
  0,
  5, // 94
  13,
  10,
  4,
  103,
  100,
  9,
  10,
  10,
  4,
  7,
  9,
  100,
  10,
  10,
  4,
  6,
  9,
  7,
  10,
  10,
  4,
  102,
  9,
  6,
  10,
  10,
  4,
  103,
  9,
  102,
  10,
  10,
  4,
  5,
  6,
  102,
  9,
  10,
  4,
  4,
  6,
  5,
  9,
  10,
  4,
  4,
  7,
  6,
  9,
  10,
  4,
  100,
  7,
  4,
  9,
  10,
  4,
  102,
  103,
  100,
  9,
  10,
  4,
  101,
  102,
  100,
  9,
  10,
  4,
  104,
  4,
  100,
  7,
  10,
  4,
  102,
  5,
  106,
  6, // 95
  3,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  4,
  6,
  106,
  9,
  10,
  4,
  105,
  4,
  106,
  9, // 96
  10,
  10,
  4,
  6,
  9,
  0,
  11,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  3,
  6,
  0,
  11,
  10,
  4,
  106,
  4,
  6,
  9,
  10,
  4,
  0,
  6,
  4,
  9,
  10,
  4,
  106,
  105,
  4,
  9,
  10,
  4,
  100,
  0,
  3,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  3,
  4,
  0,
  6, // 97
  7,
  10,
  4,
  105,
  1,
  4,
  11,
  10,
  4,
  105,
  4,
  106,
  11,
  10,
  4,
  4,
  6,
  106,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  105,
  101,
  0,
  1, // 98
  12,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  106,
  105,
  4,
  11,
  10,
  4,
  1,
  4,
  105,
  11,
  10,
  4,
  106,
  4,
  6,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  100,
  101,
  1,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  100,
  1,
  3,
  8,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  3,
  4,
  1,
  6,
  10,
  4,
  105,
  1,
  101,
  4, // 99
  7,
  10,
  4,
  106,
  4,
  6,
  9,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  106,
  6,
  1,
  9,
  10,
  4,
  106,
  105,
  4,
  9,
  10,
  4,
  106,
  2,
  1,
  6,
  10,
  4,
  2,
  4,
  1,
  6,
  10,
  4,
  102,
  1,
  106,
  2, // 100
  14,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  106,
  4,
  6,
  9,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  106,
  6,
  1,
  9,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  100,
  0,
  3,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  106,
  2,
  1,
  6,
  10,
  4,
  2,
  4,
  1,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  106,
  102,
  1,
  2, // 101
  6,
  10,
  4,
  2,
  4,
  106,
  6,
  10,
  4,
  106,
  2,
  0,
  4,
  10,
  4,
  106,
  0,
  105,
  4,
  10,
  4,
  102,
  0,
  106,
  2,
  10,
  4,
  105,
  106,
  102,
  0,
  10,
  4,
  101,
  105,
  102,
  0, // 102
  10,
  10,
  4,
  101,
  3,
  100,
  8,
  10,
  4,
  101,
  4,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  106,
  2,
  4,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  101,
  105,
  2,
  4,
  10,
  4,
  101,
  2,
  3,
  4,
  10,
  4,
  106,
  2,
  105,
  4,
  10,
  4,
  105,
  106,
  102,
  2,
  10,
  4,
  101,
  105,
  102,
  2, // 103
  10,
  10,
  4,
  6,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  106,
  4,
  6,
  9,
  10,
  4,
  2,
  6,
  4,
  9,
  10,
  4,
  106,
  105,
  4,
  9,
  10,
  4,
  2,
  4,
  3,
  9,
  10,
  4,
  3,
  4,
  2,
  6, // 104
  12,
  10,
  4,
  6,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  103,
  8,
  2,
  10,
  10,
  4,
  106,
  105,
  4,
  9,
  10,
  4,
  106,
  4,
  6,
  9,
  10,
  4,
  2,
  6,
  4,
  9,
  10,
  4,
  2,
  4,
  0,
  9,
  10,
  4,
  103,
  100,
  0,
  8,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  0,
  4,
  2,
  8,
  10,
  4,
  4,
  6,
  2,
  8, // 105
  14,
  10,
  4,
  105,
  1,
  4,
  11,
  10,
  4,
  105,
  4,
  106,
  11,
  10,
  4,
  106,
  4,
  6,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  2,
  4,
  1,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  105,
  101,
  0,
  1, // 106
  15,
  10,
  4,
  106,
  105,
  4,
  11,
  10,
  4,
  1,
  4,
  105,
  11,
  10,
  4,
  106,
  4,
  6,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  103,
  8,
  2,
  10,
  10,
  4,
  101,
  1,
  100,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  1,
  2,
  100,
  8,
  10,
  4,
  1,
  4,
  2,
  8,
  10,
  4,
  103,
  100,
  2,
  8,
  10,
  4,
  4,
  6,
  2,
  8,
  10,
  4,
  2,
  4,
  1,
  6,
  10,
  4,
  101,
  105,
  1,
  4, // 107
  12,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  103,
  3,
  1,
  10,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  1,
  6,
  102,
  10,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  106,
  4,
  6,
  9,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  106,
  6,
  1,
  9,
  10,
  4,
  106,
  105,
  4,
  9,
  10,
  4,
  3,
  4,
  1,
  6,
  10,
  4,
  102,
  1,
  106,
  6, // 108
  15,
  10,
  4,
  0,
  8,
  6,
  10,
  10,
  4,
  103,
  8,
  0,
  10,
  10,
  4,
  103,
  0,
  1,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  1,
  6,
  102,
  10,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  1,
  106,
  6,
  9,
  10,
  4,
  4,
  6,
  106,
  9,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  103,
  100,
  0,
  8,
  10,
  4,
  4,
  6,
  0,
  8,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  102,
  1,
  106,
  6, // 109
  10,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  103,
  3,
  102,
  10,
  10,
  4,
  3,
  6,
  102,
  10,
  10,
  4,
  106,
  0,
  4,
  6,
  10,
  4,
  3,
  4,
  0,
  6,
  10,
  4,
  102,
  0,
  106,
  6,
  10,
  4,
  102,
  3,
  0,
  6,
  10,
  4,
  106,
  0,
  105,
  4,
  10,
  4,
  105,
  106,
  102,
  0,
  10,
  4,
  102,
  101,
  105,
  0, // 110
  9,
  10,
  4,
  102,
  8,
  6,
  10,
  10,
  4,
  103,
  8,
  102,
  10,
  10,
  4,
  101,
  102,
  100,
  8,
  10,
  4,
  101,
  4,
  102,
  8,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  4,
  6,
  102,
  8,
  10,
  4,
  102,
  4,
  106,
  6,
  10,
  4,
  101,
  105,
  102,
  4,
  10,
  4,
  105,
  106,
  102,
  4, // 111
  7,
  10,
  4,
  6,
  9,
  8,
  11,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  7,
  8,
  6,
  9,
  10,
  4,
  105,
  8,
  7,
  9,
  10,
  4,
  105,
  6,
  106,
  9,
  10,
  4,
  104,
  7,
  105,
  8, // 112
  11,
  10,
  4,
  6,
  9,
  0,
  11,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  3,
  6,
  0,
  11,
  10,
  4,
  104,
  0,
  7,
  9,
  10,
  4,
  104,
  7,
  105,
  9,
  10,
  4,
  6,
  7,
  0,
  9,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  106,
  105,
  6,
  9,
  10,
  4,
  104,
  0,
  3,
  7,
  10,
  4,
  0,
  6,
  3,
  7,
  10,
  4,
  104,
  0,
  100,
  3, // 113
  7,
  10,
  4,
  105,
  1,
  6,
  11,
  10,
  4,
  105,
  6,
  106,
  11,
  10,
  4,
  105,
  7,
  0,
  8,
  10,
  4,
  104,
  7,
  105,
  8,
  10,
  4,
  105,
  6,
  0,
  7,
  10,
  4,
  105,
  1,
  0,
  6,
  10,
  4,
  105,
  101,
  0,
  1, // 114
  10,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  106,
  105,
  6,
  11,
  10,
  4,
  1,
  6,
  105,
  11,
  10,
  4,
  104,
  105,
  1,
  7,
  10,
  4,
  105,
  6,
  1,
  7,
  10,
  4,
  1,
  3,
  104,
  7,
  10,
  4,
  1,
  6,
  3,
  7,
  10,
  4,
  100,
  104,
  1,
  3,
  10,
  4,
  104,
  105,
  101,
  1,
  10,
  4,
  100,
  104,
  101,
  1, // 115
  11,
  10,
  4,
  7,
  8,
  1,
  9,
  10,
  4,
  105,
  8,
  7,
  9,
  10,
  4,
  6,
  7,
  1,
  9,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  106,
  105,
  6,
  9,
  10,
  4,
  106,
  6,
  1,
  9,
  10,
  4,
  104,
  7,
  105,
  8,
  10,
  4,
  1,
  7,
  2,
  8,
  10,
  4,
  1,
  6,
  2,
  7,
  10,
  4,
  106,
  2,
  1,
  6,
  10,
  4,
  102,
  1,
  106,
  2, // 116
  14,
  10,
  4,
  104,
  0,
  7,
  9,
  10,
  4,
  104,
  7,
  105,
  9,
  10,
  4,
  6,
  7,
  0,
  9,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  1,
  6,
  0,
  9,
  10,
  4,
  106,
  6,
  1,
  9,
  10,
  4,
  105,
  6,
  106,
  9,
  10,
  4,
  104,
  0,
  3,
  7,
  10,
  4,
  0,
  6,
  3,
  7,
  10,
  4,
  1,
  2,
  0,
  6,
  10,
  4,
  106,
  2,
  1,
  6,
  10,
  4,
  2,
  3,
  0,
  6,
  10,
  4,
  104,
  0,
  100,
  3,
  10,
  4,
  106,
  102,
  1,
  2, // 117
  10,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  105,
  7,
  0,
  8,
  10,
  4,
  104,
  7,
  105,
  8,
  10,
  4,
  105,
  6,
  0,
  7,
  10,
  4,
  0,
  6,
  2,
  7,
  10,
  4,
  106,
  0,
  105,
  6,
  10,
  4,
  106,
  2,
  0,
  6,
  10,
  4,
  102,
  0,
  106,
  2,
  10,
  4,
  105,
  106,
  102,
  0,
  10,
  4,
  102,
  101,
  105,
  0, // 118
  9,
  10,
  4,
  104,
  105,
  3,
  7,
  10,
  4,
  105,
  6,
  3,
  7,
  10,
  4,
  106,
  2,
  105,
  6,
  10,
  4,
  2,
  3,
  105,
  6,
  10,
  4,
  104,
  105,
  101,
  3,
  10,
  4,
  105,
  2,
  101,
  3,
  10,
  4,
  101,
  100,
  104,
  3,
  10,
  4,
  105,
  106,
  102,
  2,
  10,
  4,
  102,
  101,
  105,
  2, // 119
  14,
  10,
  4,
  6,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  7,
  8,
  6,
  9,
  10,
  4,
  105,
  8,
  7,
  9,
  10,
  4,
  106,
  105,
  6,
  9,
  10,
  4,
  2,
  6,
  8,
  9,
  10,
  4,
  2,
  8,
  3,
  9,
  10,
  4,
  2,
  6,
  3,
  8,
  10,
  4,
  6,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  105,
  8, // 120
  15,
  10,
  4,
  6,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  6,
  11,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  0,
  2,
  103,
  10,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  104,
  0,
  7,
  9,
  10,
  4,
  104,
  7,
  105,
  9,
  10,
  4,
  6,
  7,
  0,
  9,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  106,
  105,
  6,
  9,
  10,
  4,
  2,
  6,
  0,
  9,
  10,
  4,
  0,
  6,
  2,
  7,
  10,
  4,
  104,
  0,
  100,
  7, // 121
  15,
  10,
  4,
  105,
  1,
  6,
  11,
  10,
  4,
  105,
  6,
  106,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  2,
  10,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  105,
  7,
  0,
  8,
  10,
  4,
  104,
  7,
  105,
  8,
  10,
  4,
  105,
  6,
  0,
  7,
  10,
  4,
  0,
  6,
  3,
  7,
  10,
  4,
  1,
  2,
  0,
  6,
  10,
  4,
  2,
  3,
  0,
  6,
  10,
  4,
  105,
  1,
  0,
  6,
  10,
  4,
  105,
  101,
  0,
  1, // 122
  13,
  10,
  4,
  106,
  105,
  6,
  11,
  10,
  4,
  1,
  6,
  105,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  103,
  100,
  2,
  10,
  10,
  4,
  100,
  7,
  2,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  104,
  105,
  1,
  7,
  10,
  4,
  105,
  6,
  1,
  7,
  10,
  4,
  1,
  6,
  2,
  7,
  10,
  4,
  104,
  1,
  100,
  7,
  10,
  4,
  1,
  2,
  100,
  7,
  10,
  4,
  101,
  100,
  104,
  1,
  10,
  4,
  104,
  105,
  101,
  1, // 123
  15,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  1,
  10,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  1,
  6,
  102,
  10,
  10,
  4,
  7,
  8,
  1,
  9,
  10,
  4,
  105,
  8,
  7,
  9,
  10,
  4,
  6,
  7,
  1,
  9,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  106,
  105,
  6,
  9,
  10,
  4,
  106,
  6,
  1,
  9,
  10,
  4,
  1,
  7,
  3,
  8,
  10,
  4,
  104,
  7,
  105,
  8,
  10,
  4,
  1,
  6,
  3,
  7,
  10,
  4,
  102,
  1,
  106,
  6, // 124
  16,
  10,
  4,
  103,
  100,
  0,
  10,
  10,
  4,
  100,
  7,
  0,
  10,
  10,
  4,
  0,
  7,
  6,
  10,
  10,
  4,
  103,
  0,
  1,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  103,
  1,
  102,
  10,
  10,
  4,
  1,
  6,
  102,
  10,
  10,
  4,
  104,
  0,
  7,
  9,
  10,
  4,
  104,
  7,
  105,
  9,
  10,
  4,
  6,
  7,
  0,
  9,
  10,
  4,
  105,
  7,
  6,
  9,
  10,
  4,
  1,
  6,
  0,
  9,
  10,
  4,
  106,
  6,
  1,
  9,
  10,
  4,
  105,
  6,
  106,
  9,
  10,
  4,
  104,
  0,
  100,
  7,
  10,
  4,
  102,
  1,
  106,
  6, // 125
  13,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  103,
  3,
  102,
  10,
  10,
  4,
  3,
  6,
  102,
  10,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  105,
  7,
  0,
  8,
  10,
  4,
  104,
  7,
  105,
  8,
  10,
  4,
  105,
  6,
  0,
  7,
  10,
  4,
  0,
  6,
  3,
  7,
  10,
  4,
  102,
  0,
  106,
  6,
  10,
  4,
  102,
  3,
  0,
  6,
  10,
  4,
  106,
  0,
  105,
  6,
  10,
  4,
  105,
  106,
  102,
  0,
  10,
  4,
  102,
  101,
  105,
  0, // 126
  10,
  10,
  4,
  101,
  100,
  7,
  10,
  10,
  4,
  101,
  7,
  6,
  10,
  10,
  4,
  101,
  102,
  100,
  10,
  10,
  4,
  101,
  6,
  102,
  10,
  10,
  4,
  102,
  103,
  100,
  10,
  10,
  4,
  104,
  105,
  101,
  7,
  10,
  4,
  105,
  6,
  101,
  7,
  10,
  4,
  101,
  100,
  104,
  7,
  10,
  4,
  105,
  106,
  102,
  6,
  10,
  4,
  102,
  101,
  105,
  6, // 127
  1,
  10,
  4,
  6,
  7,
  107,
  10, // 128
  5,
  10,
  4,
  6,
  7,
  107,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  0,
  6,
  3,
  7, // 129
  6,
  10,
  4,
  6,
  7,
  107,
  10,
  10,
  4,
  0,
  7,
  6,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  6,
  0,
  9,
  10,
  4,
  6,
  7,
  0,
  9, // 130
  10,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  6,
  7,
  107,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  101,
  1,
  8,
  9,
  10,
  4,
  7,
  8,
  1,
  9,
  10,
  4,
  6,
  7,
  1,
  9,
  10,
  4,
  100,
  101,
  1,
  8,
  10,
  4,
  100,
  1,
  3,
  8,
  10,
  4,
  1,
  7,
  3,
  8,
  10,
  4,
  1,
  6,
  3,
  7, // 131
  5,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  6,
  7,
  107,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  1,
  6,
  2,
  7, // 132
  10,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  0,
  6,
  3,
  7,
  10,
  4,
  2,
  3,
  0,
  6,
  10,
  4,
  1,
  2,
  0,
  6, // 133
  10,
  10,
  4,
  102,
  2,
  9,
  11,
  10,
  4,
  6,
  9,
  2,
  11,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  6,
  7,
  107,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  2,
  6,
  0,
  9,
  10,
  4,
  101,
  102,
  0,
  9,
  10,
  4,
  6,
  7,
  0,
  9,
  10,
  4,
  0,
  6,
  2,
  7, // 134
  14,
  10,
  4,
  102,
  2,
  9,
  11,
  10,
  4,
  6,
  9,
  2,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  6,
  7,
  107,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  101,
  2,
  3,
  9,
  10,
  4,
  101,
  3,
  8,
  9,
  10,
  4,
  2,
  8,
  3,
  9,
  10,
  4,
  101,
  102,
  2,
  9,
  10,
  4,
  6,
  8,
  2,
  9,
  10,
  4,
  7,
  8,
  6,
  9,
  10,
  4,
  2,
  6,
  3,
  8,
  10,
  4,
  6,
  7,
  3,
  8,
  10,
  4,
  101,
  3,
  100,
  8, // 135
  3,
  10,
  4,
  3,
  6,
  107,
  7,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  103,
  2,
  107,
  3, // 136
  7,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  2,
  7,
  103,
  8,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  103,
  100,
  0,
  8,
  10,
  4,
  2,
  6,
  107,
  7,
  10,
  4,
  0,
  6,
  2,
  7,
  10,
  4,
  107,
  103,
  2,
  7, // 137
  9,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  6,
  0,
  9,
  10,
  4,
  6,
  7,
  0,
  9,
  10,
  4,
  107,
  3,
  6,
  7,
  10,
  4,
  0,
  6,
  3,
  7,
  10,
  4,
  2,
  3,
  0,
  6,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  1,
  2,
  0,
  6,
  10,
  4,
  107,
  103,
  2,
  3, // 138
  11,
  10,
  4,
  101,
  1,
  8,
  9,
  10,
  4,
  7,
  8,
  1,
  9,
  10,
  4,
  6,
  7,
  1,
  9,
  10,
  4,
  101,
  1,
  100,
  8,
  10,
  4,
  1,
  2,
  100,
  8,
  10,
  4,
  1,
  7,
  2,
  8,
  10,
  4,
  103,
  100,
  2,
  8,
  10,
  4,
  103,
  2,
  7,
  8,
  10,
  4,
  103,
  2,
  107,
  7,
  10,
  4,
  107,
  2,
  6,
  7,
  10,
  4,
  1,
  6,
  2,
  7, // 139
  7,
  10,
  4,
  103,
  3,
  1,
  11,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  102,
  103,
  1,
  11,
  10,
  4,
  1,
  6,
  3,
  7,
  10,
  4,
  107,
  3,
  6,
  7,
  10,
  4,
  103,
  107,
  3,
  6, // 140
  7,
  10,
  4,
  102,
  103,
  1,
  11,
  10,
  4,
  103,
  6,
  1,
  11,
  10,
  4,
  103,
  100,
  0,
  8,
  10,
  4,
  103,
  0,
  7,
  8,
  10,
  4,
  107,
  103,
  6,
  7,
  10,
  4,
  0,
  6,
  103,
  7,
  10,
  4,
  0,
  1,
  103,
  6, // 141
  11,
  10,
  4,
  102,
  103,
  3,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  3,
  6,
  0,
  11,
  10,
  4,
  102,
  0,
  9,
  11,
  10,
  4,
  6,
  9,
  0,
  11,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  6,
  7,
  0,
  9,
  10,
  4,
  3,
  6,
  107,
  7,
  10,
  4,
  0,
  6,
  3,
  7,
  10,
  4,
  107,
  3,
  103,
  6, // 142
  10,
  10,
  4,
  102,
  103,
  8,
  11,
  10,
  4,
  6,
  8,
  103,
  11,
  10,
  4,
  8,
  9,
  102,
  11,
  10,
  4,
  6,
  9,
  8,
  11,
  10,
  4,
  101,
  102,
  8,
  9,
  10,
  4,
  7,
  8,
  6,
  9,
  10,
  4,
  101,
  102,
  100,
  8,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  103,
  6,
  7,
  8,
  10,
  4,
  103,
  6,
  107,
  7, // 143
  3,
  10,
  4,
  107,
  6,
  8,
  10,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  107,
  4,
  104,
  8, // 144
  7,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  107,
  6,
  4,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  107,
  4,
  104,
  10,
  10,
  4,
  3,
  4,
  0,
  6,
  10,
  4,
  0,
  3,
  104,
  4,
  10,
  4,
  100,
  104,
  0,
  3, // 145
  10,
  10,
  4,
  6,
  8,
  107,
  10,
  10,
  4,
  0,
  8,
  6,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  0,
  4,
  6,
  8,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  104,
  107,
  4,
  8,
  10,
  4,
  0,
  4,
  1,
  6, // 146
  12,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  107,
  6,
  4,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  107,
  4,
  104,
  10,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  100,
  1,
  3,
  9,
  10,
  4,
  100,
  3,
  4,
  9,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  100,
  101,
  1,
  9,
  10,
  4,
  3,
  4,
  1,
  6,
  10,
  4,
  100,
  3,
  104,
  4, // 147
  10,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  107,
  6,
  8,
  10,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  4,
  6,
  2,
  8,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  107,
  4,
  104,
  8,
  10,
  4,
  1,
  4,
  2,
  8,
  10,
  4,
  2,
  4,
  1,
  6, // 148
  14,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  6,
  1,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  107,
  6,
  4,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  107,
  4,
  104,
  10,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  2,
  4,
  1,
  6,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  0,
  3,
  104,
  4,
  10,
  4,
  100,
  104,
  0,
  3, // 149
  12,
  10,
  4,
  102,
  2,
  9,
  11,
  10,
  4,
  6,
  9,
  2,
  11,
  10,
  4,
  107,
  6,
  8,
  10,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  2,
  6,
  4,
  9,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  2,
  4,
  0,
  9,
  10,
  4,
  101,
  102,
  0,
  9,
  10,
  4,
  4,
  6,
  2,
  8,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  0,
  4,
  2,
  8,
  10,
  4,
  104,
  107,
  4,
  8, // 150
  15,
  10,
  4,
  2,
  6,
  9,
  11,
  10,
  4,
  2,
  9,
  102,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  4,
  6,
  3,
  10,
  10,
  4,
  107,
  6,
  4,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  107,
  4,
  104,
  10,
  10,
  4,
  2,
  6,
  4,
  9,
  10,
  4,
  101,
  102,
  2,
  9,
  10,
  4,
  101,
  2,
  3,
  9,
  10,
  4,
  2,
  4,
  3,
  9,
  10,
  4,
  101,
  3,
  100,
  9,
  10,
  4,
  3,
  4,
  100,
  9,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  100,
  3,
  104,
  4, // 151
  7,
  10,
  4,
  107,
  3,
  6,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  107,
  4,
  104,
  8,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  103,
  2,
  107,
  3, // 152
  6,
  10,
  4,
  107,
  4,
  2,
  6,
  10,
  4,
  0,
  2,
  107,
  4,
  10,
  4,
  104,
  0,
  107,
  4,
  10,
  4,
  107,
  0,
  103,
  2,
  10,
  4,
  103,
  107,
  104,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 153
  14,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  107,
  3,
  6,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  107,
  4,
  104,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  2,
  4,
  1,
  6,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  103,
  2,
  107,
  3, // 154
  10,
  10,
  4,
  1,
  6,
  4,
  9,
  10,
  4,
  101,
  1,
  100,
  9,
  10,
  4,
  1,
  4,
  100,
  9,
  10,
  4,
  2,
  4,
  1,
  6,
  10,
  4,
  107,
  4,
  2,
  6,
  10,
  4,
  104,
  100,
  2,
  4,
  10,
  4,
  1,
  2,
  100,
  4,
  10,
  4,
  107,
  104,
  2,
  4,
  10,
  4,
  103,
  107,
  104,
  2,
  10,
  4,
  103,
  104,
  100,
  2, // 155
  12,
  10,
  4,
  103,
  3,
  1,
  11,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  103,
  1,
  102,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  107,
  3,
  6,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  107,
  4,
  104,
  8,
  10,
  4,
  3,
  4,
  1,
  6,
  10,
  4,
  103,
  107,
  3,
  6, // 156
  10,
  10,
  4,
  103,
  1,
  102,
  11,
  10,
  4,
  103,
  6,
  1,
  11,
  10,
  4,
  1,
  6,
  4,
  11,
  10,
  4,
  0,
  107,
  4,
  6,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  103,
  107,
  0,
  6,
  10,
  4,
  103,
  0,
  1,
  6,
  10,
  4,
  104,
  0,
  107,
  4,
  10,
  4,
  103,
  107,
  104,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 157
  15,
  10,
  4,
  103,
  3,
  102,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  3,
  6,
  0,
  11,
  10,
  4,
  102,
  0,
  9,
  11,
  10,
  4,
  6,
  9,
  0,
  11,
  10,
  4,
  0,
  6,
  4,
  9,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  107,
  3,
  6,
  8,
  10,
  4,
  4,
  6,
  3,
  8,
  10,
  4,
  107,
  6,
  4,
  8,
  10,
  4,
  107,
  4,
  104,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  3,
  4,
  0,
  6,
  10,
  4,
  103,
  107,
  3,
  6, // 158
  9,
  10,
  4,
  103,
  6,
  9,
  11,
  10,
  4,
  103,
  9,
  102,
  11,
  10,
  4,
  103,
  6,
  4,
  9,
  10,
  4,
  102,
  103,
  100,
  9,
  10,
  4,
  103,
  4,
  100,
  9,
  10,
  4,
  101,
  102,
  100,
  9,
  10,
  4,
  103,
  107,
  4,
  6,
  10,
  4,
  103,
  107,
  104,
  4,
  10,
  4,
  103,
  104,
  100,
  4, // 159
  5,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  6,
  9,
  7,
  10,
  10,
  4,
  4,
  7,
  6,
  9,
  10,
  4,
  4,
  6,
  5,
  9,
  10,
  4,
  105,
  4,
  5,
  9, // 160
  10,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  4,
  5,
  105,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  100,
  0,
  3,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  3,
  4,
  0,
  5, // 161
  9,
  10,
  4,
  6,
  7,
  107,
  10,
  10,
  4,
  0,
  7,
  6,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  0,
  4,
  6,
  7,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  4,
  5,
  1,
  6,
  10,
  4,
  105,
  1,
  4,
  5,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  105,
  101,
  0,
  1, // 162
  14,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  100,
  101,
  1,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  100,
  1,
  3,
  8,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  3,
  4,
  1,
  5,
  10,
  4,
  1,
  4,
  105,
  5,
  10,
  4,
  105,
  1,
  101,
  4, // 163
  10,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  4,
  5,
  105,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  2,
  4,
  1,
  5, // 164
  18,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  105,
  4,
  5,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  100,
  0,
  3,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4, // 165
  14,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  102,
  2,
  0,
  11,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  101,
  102,
  0,
  11,
  10,
  4,
  101,
  0,
  5,
  11,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  2,
  7,
  6,
  10,
  10,
  4,
  0,
  4,
  2,
  7,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  105,
  0,
  4,
  5,
  10,
  4,
  2,
  4,
  0,
  5,
  10,
  4,
  101,
  0,
  105,
  5, // 166
  15,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  101,
  102,
  2,
  11,
  10,
  4,
  101,
  2,
  5,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  107,
  6,
  7,
  10,
  10,
  4,
  3,
  7,
  6,
  10,
  10,
  4,
  101,
  3,
  100,
  8,
  10,
  4,
  101,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  101,
  2,
  4,
  5,
  10,
  4,
  101,
  4,
  105,
  5,
  10,
  4,
  101,
  2,
  3,
  4, // 167
  9,
  10,
  4,
  4,
  5,
  105,
  9,
  10,
  4,
  2,
  5,
  4,
  9,
  10,
  4,
  2,
  4,
  3,
  9,
  10,
  4,
  107,
  3,
  6,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  103,
  2,
  107,
  3, // 168
  14,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  105,
  4,
  5,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  2,
  7,
  103,
  8,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  100,
  0,
  103,
  8,
  10,
  4,
  4,
  7,
  0,
  8,
  10,
  4,
  107,
  103,
  2,
  7,
  10,
  4,
  0,
  4,
  2,
  7,
  10,
  4,
  107,
  2,
  6,
  7,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  2,
  4,
  0,
  5, // 169
  12,
  10,
  4,
  107,
  3,
  6,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  3,
  4,
  2,
  6,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  105,
  1,
  4,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  107,
  103,
  2,
  3,
  10,
  4,
  101,
  0,
  105,
  1, // 170
  14,
  10,
  4,
  100,
  2,
  103,
  8,
  10,
  4,
  2,
  7,
  103,
  8,
  10,
  4,
  101,
  1,
  100,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  100,
  1,
  2,
  8,
  10,
  4,
  1,
  4,
  2,
  8,
  10,
  4,
  4,
  7,
  2,
  8,
  10,
  4,
  103,
  2,
  107,
  7,
  10,
  4,
  107,
  2,
  6,
  7,
  10,
  4,
  4,
  6,
  2,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  1,
  4,
  105,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  101,
  105,
  1,
  4, // 171
  14,
  10,
  4,
  103,
  3,
  1,
  11,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  103,
  1,
  102,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  4,
  5,
  105,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  107,
  3,
  6,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  103,
  107,
  3,
  6,
  10,
  4,
  3,
  4,
  1,
  5, // 172
  15,
  10,
  4,
  103,
  1,
  102,
  11,
  10,
  4,
  103,
  6,
  1,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  105,
  4,
  5,
  9,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  100,
  0,
  103,
  8,
  10,
  4,
  0,
  7,
  103,
  8,
  10,
  4,
  4,
  7,
  0,
  8,
  10,
  4,
  103,
  0,
  6,
  7,
  10,
  4,
  103,
  6,
  107,
  7,
  10,
  4,
  0,
  4,
  6,
  7,
  10,
  4,
  4,
  5,
  1,
  6,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  103,
  0,
  1,
  6, // 173
  14,
  10,
  4,
  103,
  3,
  102,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  3,
  6,
  5,
  11,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  102,
  0,
  101,
  11,
  10,
  4,
  0,
  5,
  101,
  11,
  10,
  4,
  107,
  3,
  6,
  7,
  10,
  4,
  4,
  6,
  3,
  7,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  103,
  107,
  3,
  6,
  10,
  4,
  3,
  4,
  0,
  5,
  10,
  4,
  105,
  0,
  4,
  5,
  10,
  4,
  101,
  0,
  105,
  5, // 174
  13,
  10,
  4,
  103,
  6,
  8,
  11,
  10,
  4,
  103,
  8,
  102,
  11,
  10,
  4,
  5,
  8,
  6,
  11,
  10,
  4,
  101,
  102,
  8,
  11,
  10,
  4,
  101,
  8,
  5,
  11,
  10,
  4,
  103,
  6,
  7,
  8,
  10,
  4,
  4,
  7,
  6,
  8,
  10,
  4,
  4,
  6,
  5,
  8,
  10,
  4,
  101,
  4,
  5,
  8,
  10,
  4,
  101,
  102,
  100,
  8,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  103,
  6,
  107,
  7,
  10,
  4,
  101,
  4,
  105,
  5, // 175
  7,
  10,
  4,
  6,
  9,
  8,
  10,
  10,
  4,
  6,
  8,
  107,
  10,
  10,
  4,
  5,
  8,
  6,
  9,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  104,
  107,
  6,
  8, // 176
  7,
  10,
  4,
  104,
  107,
  6,
  10,
  10,
  4,
  104,
  6,
  3,
  10,
  10,
  4,
  104,
  0,
  5,
  9,
  10,
  4,
  104,
  5,
  105,
  9,
  10,
  4,
  104,
  5,
  3,
  6,
  10,
  4,
  104,
  0,
  3,
  5,
  10,
  4,
  104,
  0,
  100,
  3, // 177
  11,
  10,
  4,
  6,
  8,
  107,
  10,
  10,
  4,
  0,
  8,
  6,
  10,
  10,
  4,
  0,
  6,
  1,
  10,
  10,
  4,
  104,
  107,
  6,
  8,
  10,
  4,
  5,
  6,
  0,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  0,
  5,
  1,
  6,
  10,
  4,
  105,
  1,
  0,
  5,
  10,
  4,
  105,
  101,
  0,
  1, // 178
  10,
  10,
  4,
  3,
  6,
  1,
  10,
  10,
  4,
  104,
  6,
  3,
  10,
  10,
  4,
  107,
  6,
  104,
  10,
  10,
  4,
  104,
  5,
  3,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  1,
  3,
  104,
  5,
  10,
  4,
  104,
  105,
  1,
  5,
  10,
  4,
  100,
  104,
  1,
  3,
  10,
  4,
  100,
  104,
  101,
  1,
  10,
  4,
  104,
  105,
  101,
  1, // 179
  12,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  107,
  6,
  8,
  10,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  107,
  6,
  104,
  8,
  10,
  4,
  5,
  6,
  2,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  1,
  5,
  2,
  8, // 180
  15,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  102,
  2,
  1,
  11,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  104,
  6,
  3,
  10,
  10,
  4,
  107,
  6,
  104,
  10,
  10,
  4,
  104,
  0,
  5,
  9,
  10,
  4,
  104,
  5,
  105,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  104,
  5,
  3,
  6,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  0,
  3,
  104,
  5,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  100,
  104,
  0,
  3, // 181
  15,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  102,
  2,
  0,
  11,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  102,
  0,
  101,
  11,
  10,
  4,
  0,
  5,
  101,
  11,
  10,
  4,
  6,
  8,
  107,
  10,
  10,
  4,
  2,
  8,
  6,
  10,
  10,
  4,
  0,
  6,
  2,
  8,
  10,
  4,
  104,
  107,
  6,
  8,
  10,
  4,
  5,
  6,
  0,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  0,
  5,
  2,
  6,
  10,
  4,
  101,
  0,
  105,
  5, // 182
  13,
  10,
  4,
  2,
  6,
  5,
  11,
  10,
  4,
  102,
  2,
  101,
  11,
  10,
  4,
  2,
  5,
  101,
  11,
  10,
  4,
  3,
  6,
  2,
  10,
  10,
  4,
  104,
  6,
  3,
  10,
  10,
  4,
  107,
  6,
  104,
  10,
  10,
  4,
  104,
  5,
  3,
  6,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  105,
  101,
  3,
  5,
  10,
  4,
  2,
  3,
  101,
  5,
  10,
  4,
  104,
  105,
  3,
  5,
  10,
  4,
  104,
  105,
  101,
  3,
  10,
  4,
  101,
  100,
  104,
  3, // 183
  11,
  10,
  4,
  5,
  8,
  3,
  9,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  2,
  5,
  3,
  9,
  10,
  4,
  104,
  107,
  6,
  8,
  10,
  4,
  3,
  6,
  107,
  8,
  10,
  4,
  5,
  6,
  3,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  103,
  2,
  107,
  3, // 184
  10,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  104,
  0,
  5,
  9,
  10,
  4,
  104,
  5,
  105,
  9,
  10,
  4,
  104,
  0,
  107,
  6,
  10,
  4,
  104,
  5,
  0,
  6,
  10,
  4,
  0,
  2,
  107,
  6,
  10,
  4,
  0,
  5,
  2,
  6,
  10,
  4,
  107,
  0,
  103,
  2,
  10,
  4,
  104,
  103,
  107,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 185
  14,
  10,
  4,
  104,
  107,
  6,
  8,
  10,
  4,
  3,
  6,
  107,
  8,
  10,
  4,
  5,
  6,
  3,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  0,
  5,
  3,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  107,
  3,
  2,
  6,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  105,
  1,
  0,
  5,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  107,
  103,
  2,
  3,
  10,
  4,
  101,
  0,
  105,
  1, // 186
  9,
  10,
  4,
  104,
  2,
  107,
  6,
  10,
  4,
  104,
  5,
  2,
  6,
  10,
  4,
  104,
  105,
  1,
  5,
  10,
  4,
  104,
  1,
  2,
  5,
  10,
  4,
  104,
  103,
  107,
  2,
  10,
  4,
  103,
  104,
  100,
  2,
  10,
  4,
  104,
  1,
  100,
  2,
  10,
  4,
  101,
  100,
  104,
  1,
  10,
  4,
  104,
  105,
  101,
  1, // 187
  15,
  10,
  4,
  103,
  3,
  1,
  11,
  10,
  4,
  3,
  6,
  1,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  103,
  1,
  102,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  105,
  8,
  5,
  9,
  10,
  4,
  107,
  3,
  6,
  8,
  10,
  4,
  107,
  6,
  104,
  8,
  10,
  4,
  5,
  6,
  3,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  1,
  5,
  3,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  103,
  107,
  3,
  6, // 188
  13,
  10,
  4,
  103,
  1,
  102,
  11,
  10,
  4,
  103,
  6,
  1,
  11,
  10,
  4,
  1,
  6,
  5,
  11,
  10,
  4,
  104,
  0,
  5,
  9,
  10,
  4,
  104,
  5,
  105,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  104,
  0,
  107,
  6,
  10,
  4,
  104,
  5,
  0,
  6,
  10,
  4,
  0,
  5,
  1,
  6,
  10,
  4,
  103,
  107,
  0,
  6,
  10,
  4,
  103,
  0,
  1,
  6,
  10,
  4,
  103,
  107,
  104,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 189
  16,
  10,
  4,
  103,
  3,
  102,
  11,
  10,
  4,
  103,
  6,
  3,
  11,
  10,
  4,
  3,
  6,
  5,
  11,
  10,
  4,
  102,
  3,
  0,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  102,
  0,
  101,
  11,
  10,
  4,
  0,
  5,
  101,
  11,
  10,
  4,
  107,
  3,
  6,
  8,
  10,
  4,
  107,
  6,
  104,
  8,
  10,
  4,
  5,
  6,
  3,
  8,
  10,
  4,
  104,
  6,
  5,
  8,
  10,
  4,
  0,
  5,
  3,
  8,
  10,
  4,
  105,
  5,
  0,
  8,
  10,
  4,
  104,
  5,
  105,
  8,
  10,
  4,
  103,
  107,
  3,
  6,
  10,
  4,
  101,
  0,
  105,
  5, // 190
  10,
  10,
  4,
  100,
  6,
  5,
  11,
  10,
  4,
  103,
  6,
  100,
  11,
  10,
  4,
  102,
  103,
  100,
  11,
  10,
  4,
  101,
  102,
  100,
  11,
  10,
  4,
  101,
  100,
  5,
  11,
  10,
  4,
  103,
  104,
  100,
  6,
  10,
  4,
  104,
  5,
  100,
  6,
  10,
  4,
  103,
  107,
  104,
  6,
  10,
  4,
  101,
  100,
  104,
  5,
  10,
  4,
  104,
  105,
  101,
  5, // 191
  3,
  10,
  4,
  106,
  5,
  10,
  11,
  10,
  4,
  5,
  7,
  107,
  10,
  10,
  4,
  106,
  5,
  107,
  10, // 192
  10,
  10,
  4,
  106,
  5,
  10,
  11,
  10,
  4,
  3,
  10,
  5,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  5,
  7,
  107,
  10,
  10,
  4,
  3,
  7,
  5,
  10,
  10,
  4,
  5,
  7,
  0,
  8,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  0,
  5,
  3,
  7, // 193
  10,
  10,
  4,
  106,
  5,
  10,
  11,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  5,
  7,
  107,
  10,
  10,
  4,
  1,
  7,
  5,
  10,
  10,
  4,
  0,
  7,
  1,
  10,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  5,
  7,
  0,
  9,
  10,
  4,
  0,
  5,
  1,
  7, // 194
  12,
  10,
  4,
  5,
  10,
  106,
  11,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  107,
  106,
  5,
  10,
  10,
  4,
  3,
  5,
  1,
  10,
  10,
  4,
  107,
  5,
  7,
  10,
  10,
  4,
  3,
  7,
  5,
  10,
  10,
  4,
  101,
  1,
  8,
  9,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  100,
  101,
  1,
  8,
  10,
  4,
  1,
  3,
  100,
  8,
  10,
  4,
  1,
  5,
  3,
  8,
  10,
  4,
  5,
  7,
  3,
  8, // 195
  7,
  10,
  4,
  106,
  2,
  5,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  5,
  7,
  107,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  1,
  5,
  2,
  7,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  106,
  102,
  1,
  2, // 196
  14,
  10,
  4,
  106,
  2,
  5,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  107,
  5,
  7,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  5,
  7,
  0,
  8,
  10,
  4,
  100,
  0,
  3,
  8,
  10,
  4,
  0,
  7,
  3,
  8,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  0,
  5,
  3,
  7,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  106,
  102,
  1,
  2, // 197
  12,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  106,
  2,
  5,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  5,
  7,
  107,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  101,
  102,
  0,
  9,
  10,
  4,
  5,
  7,
  0,
  9,
  10,
  4,
  0,
  5,
  2,
  7,
  10,
  4,
  106,
  2,
  102,
  5, // 198
  15,
  10,
  4,
  107,
  106,
  5,
  10,
  10,
  4,
  2,
  5,
  106,
  10,
  10,
  4,
  107,
  5,
  7,
  10,
  10,
  4,
  2,
  7,
  5,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  101,
  102,
  2,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  101,
  2,
  3,
  9,
  10,
  4,
  2,
  5,
  3,
  9,
  10,
  4,
  101,
  3,
  8,
  9,
  10,
  4,
  5,
  8,
  3,
  9,
  10,
  4,
  101,
  3,
  100,
  8,
  10,
  4,
  5,
  7,
  3,
  8,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  106,
  2,
  102,
  5, // 199
  7,
  10,
  4,
  107,
  5,
  7,
  11,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  107,
  7,
  2,
  11,
  10,
  4,
  107,
  106,
  5,
  11,
  10,
  4,
  107,
  3,
  2,
  7,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  103,
  2,
  107,
  3, // 200
  12,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  2,
  107,
  7,
  11,
  10,
  4,
  5,
  7,
  107,
  11,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  106,
  5,
  107,
  11,
  10,
  4,
  5,
  7,
  0,
  8,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  2,
  7,
  103,
  8,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  100,
  0,
  103,
  8,
  10,
  4,
  0,
  5,
  2,
  7,
  10,
  4,
  107,
  103,
  2,
  7, // 201
  14,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  107,
  5,
  7,
  11,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  107,
  7,
  2,
  11,
  10,
  4,
  106,
  5,
  107,
  11,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  5,
  0,
  9,
  10,
  4,
  5,
  7,
  0,
  9,
  10,
  4,
  107,
  3,
  2,
  7,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  0,
  5,
  3,
  7,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  107,
  103,
  2,
  3, // 202
  15,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  2,
  107,
  7,
  11,
  10,
  4,
  5,
  7,
  107,
  11,
  10,
  4,
  2,
  7,
  5,
  11,
  10,
  4,
  106,
  5,
  107,
  11,
  10,
  4,
  101,
  1,
  8,
  9,
  10,
  4,
  5,
  8,
  1,
  9,
  10,
  4,
  101,
  1,
  100,
  8,
  10,
  4,
  5,
  7,
  1,
  8,
  10,
  4,
  100,
  1,
  2,
  8,
  10,
  4,
  1,
  7,
  2,
  8,
  10,
  4,
  100,
  2,
  103,
  8,
  10,
  4,
  2,
  7,
  103,
  8,
  10,
  4,
  1,
  5,
  2,
  7,
  10,
  4,
  103,
  2,
  107,
  7, // 203
  6,
  10,
  4,
  3,
  5,
  107,
  7,
  10,
  4,
  107,
  3,
  1,
  5,
  10,
  4,
  107,
  1,
  106,
  5,
  10,
  4,
  103,
  1,
  107,
  3,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  102,
  106,
  103,
  1, // 204
  10,
  10,
  4,
  5,
  7,
  0,
  8,
  10,
  4,
  100,
  0,
  103,
  8,
  10,
  4,
  0,
  7,
  103,
  8,
  10,
  4,
  1,
  5,
  107,
  7,
  10,
  4,
  0,
  5,
  1,
  7,
  10,
  4,
  107,
  103,
  1,
  7,
  10,
  4,
  0,
  1,
  103,
  7,
  10,
  4,
  106,
  107,
  1,
  5,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  102,
  106,
  103,
  1, // 205
  10,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  102,
  5,
  0,
  9,
  10,
  4,
  5,
  7,
  0,
  9,
  10,
  4,
  3,
  5,
  107,
  7,
  10,
  4,
  0,
  5,
  3,
  7,
  10,
  4,
  102,
  106,
  3,
  5,
  10,
  4,
  102,
  3,
  0,
  5,
  10,
  4,
  106,
  107,
  3,
  5,
  10,
  4,
  102,
  106,
  103,
  3,
  10,
  4,
  106,
  107,
  103,
  3, // 206
  9,
  10,
  4,
  101,
  102,
  8,
  9,
  10,
  4,
  5,
  8,
  102,
  9,
  10,
  4,
  101,
  102,
  100,
  8,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  102,
  5,
  103,
  8,
  10,
  4,
  5,
  7,
  103,
  8,
  10,
  4,
  103,
  5,
  107,
  7,
  10,
  4,
  102,
  106,
  103,
  5,
  10,
  4,
  106,
  107,
  103,
  5, // 207
  7,
  10,
  4,
  8,
  10,
  5,
  11,
  10,
  4,
  106,
  5,
  10,
  11,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  107,
  4,
  8,
  10,
  10,
  4,
  5,
  8,
  4,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  104,
  107,
  4,
  8, // 208
  11,
  10,
  4,
  106,
  5,
  10,
  11,
  10,
  4,
  3,
  10,
  5,
  11,
  10,
  4,
  3,
  5,
  0,
  11,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  4,
  5,
  3,
  10,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  104,
  107,
  4,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  3,
  4,
  0,
  5,
  10,
  4,
  104,
  0,
  3,
  4,
  10,
  4,
  104,
  0,
  100,
  3, // 209
  14,
  10,
  4,
  106,
  5,
  10,
  11,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  107,
  4,
  8,
  10,
  10,
  4,
  5,
  8,
  4,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  1,
  8,
  5,
  10,
  10,
  4,
  0,
  8,
  1,
  10,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  4,
  5,
  1,
  8,
  10,
  4,
  0,
  4,
  1,
  8,
  10,
  4,
  104,
  107,
  4,
  8, // 210
  15,
  10,
  4,
  5,
  10,
  106,
  11,
  10,
  4,
  1,
  10,
  5,
  11,
  10,
  4,
  107,
  106,
  5,
  10,
  10,
  4,
  3,
  5,
  1,
  10,
  10,
  4,
  4,
  5,
  3,
  10,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  107,
  4,
  104,
  10,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  100,
  1,
  3,
  9,
  10,
  4,
  100,
  3,
  4,
  9,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  100,
  101,
  1,
  9,
  10,
  4,
  3,
  4,
  1,
  5,
  10,
  4,
  100,
  3,
  104,
  4, // 211
  11,
  10,
  4,
  106,
  2,
  5,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  107,
  4,
  8,
  10,
  10,
  4,
  2,
  8,
  4,
  10,
  10,
  4,
  107,
  4,
  104,
  8,
  10,
  4,
  1,
  4,
  2,
  8,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  106,
  102,
  1,
  2, // 212
  14,
  10,
  4,
  106,
  2,
  5,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  3,
  4,
  2,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  107,
  4,
  104,
  10,
  10,
  4,
  106,
  2,
  1,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  0,
  3,
  104,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  100,
  104,
  0,
  3,
  10,
  4,
  106,
  102,
  1,
  2, // 213
  15,
  10,
  4,
  106,
  2,
  5,
  10,
  10,
  4,
  106,
  5,
  107,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  4,
  8,
  107,
  10,
  10,
  4,
  2,
  8,
  4,
  10,
  10,
  4,
  102,
  2,
  0,
  9,
  10,
  4,
  2,
  5,
  0,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  0,
  4,
  2,
  8,
  10,
  4,
  104,
  107,
  4,
  8,
  10,
  4,
  2,
  4,
  0,
  5,
  10,
  4,
  106,
  2,
  102,
  5, // 214
  16,
  10,
  4,
  107,
  106,
  5,
  10,
  10,
  4,
  2,
  5,
  106,
  10,
  10,
  4,
  4,
  5,
  2,
  10,
  10,
  4,
  107,
  5,
  4,
  10,
  10,
  4,
  3,
  4,
  2,
  10,
  10,
  4,
  104,
  4,
  3,
  10,
  10,
  4,
  107,
  4,
  104,
  10,
  10,
  4,
  102,
  2,
  101,
  9,
  10,
  4,
  102,
  5,
  2,
  9,
  10,
  4,
  2,
  5,
  4,
  9,
  10,
  4,
  101,
  2,
  3,
  9,
  10,
  4,
  2,
  4,
  3,
  9,
  10,
  4,
  101,
  3,
  100,
  9,
  10,
  4,
  3,
  4,
  100,
  9,
  10,
  4,
  102,
  106,
  2,
  5,
  10,
  4,
  100,
  3,
  104,
  4, // 215
  7,
  10,
  4,
  107,
  106,
  5,
  11,
  10,
  4,
  107,
  5,
  2,
  11,
  10,
  4,
  104,
  107,
  4,
  8,
  10,
  4,
  3,
  4,
  107,
  8,
  10,
  4,
  107,
  4,
  2,
  5,
  10,
  4,
  107,
  3,
  2,
  4,
  10,
  4,
  103,
  2,
  107,
  3, // 216
  10,
  10,
  4,
  2,
  5,
  0,
  11,
  10,
  4,
  107,
  5,
  2,
  11,
  10,
  4,
  106,
  5,
  107,
  11,
  10,
  4,
  107,
  4,
  2,
  5,
  10,
  4,
  2,
  4,
  0,
  5,
  10,
  4,
  0,
  2,
  107,
  4,
  10,
  4,
  104,
  0,
  107,
  4,
  10,
  4,
  107,
  0,
  103,
  2,
  10,
  4,
  104,
  103,
  107,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 217
  15,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  107,
  5,
  2,
  11,
  10,
  4,
  106,
  5,
  107,
  11,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  101,
  1,
  0,
  9,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  104,
  107,
  4,
  8,
  10,
  4,
  3,
  4,
  107,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  107,
  4,
  2,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  107,
  3,
  2,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  107,
  103,
  2,
  3, // 218
  13,
  10,
  4,
  2,
  5,
  1,
  11,
  10,
  4,
  107,
  5,
  2,
  11,
  10,
  4,
  106,
  5,
  107,
  11,
  10,
  4,
  1,
  5,
  4,
  9,
  10,
  4,
  101,
  1,
  100,
  9,
  10,
  4,
  1,
  4,
  100,
  9,
  10,
  4,
  107,
  4,
  2,
  5,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  104,
  100,
  2,
  4,
  10,
  4,
  1,
  2,
  100,
  4,
  10,
  4,
  104,
  2,
  107,
  4,
  10,
  4,
  104,
  103,
  107,
  2,
  10,
  4,
  103,
  104,
  100,
  2, // 219
  10,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  104,
  107,
  4,
  8,
  10,
  4,
  3,
  4,
  107,
  8,
  10,
  4,
  107,
  3,
  1,
  5,
  10,
  4,
  3,
  4,
  1,
  5,
  10,
  4,
  107,
  4,
  3,
  5,
  10,
  4,
  107,
  1,
  106,
  5,
  10,
  4,
  103,
  1,
  107,
  3,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  103,
  102,
  106,
  1, // 220
  9,
  10,
  4,
  106,
  107,
  1,
  5,
  10,
  4,
  107,
  4,
  1,
  5,
  10,
  4,
  104,
  0,
  107,
  4,
  10,
  4,
  0,
  1,
  107,
  4,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  107,
  0,
  103,
  1,
  10,
  4,
  103,
  102,
  106,
  1,
  10,
  4,
  104,
  103,
  107,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 221
  13,
  10,
  4,
  102,
  0,
  101,
  9,
  10,
  4,
  102,
  5,
  0,
  9,
  10,
  4,
  0,
  5,
  4,
  9,
  10,
  4,
  104,
  107,
  4,
  8,
  10,
  4,
  3,
  4,
  107,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  106,
  107,
  3,
  5,
  10,
  4,
  107,
  4,
  3,
  5,
  10,
  4,
  3,
  4,
  0,
  5,
  10,
  4,
  102,
  106,
  3,
  5,
  10,
  4,
  102,
  3,
  0,
  5,
  10,
  4,
  103,
  102,
  106,
  3,
  10,
  4,
  106,
  107,
  103,
  3, // 222
  10,
  10,
  4,
  103,
  102,
  5,
  9,
  10,
  4,
  103,
  5,
  4,
  9,
  10,
  4,
  102,
  103,
  100,
  9,
  10,
  4,
  103,
  4,
  100,
  9,
  10,
  4,
  101,
  102,
  100,
  9,
  10,
  4,
  106,
  107,
  103,
  5,
  10,
  4,
  107,
  4,
  103,
  5,
  10,
  4,
  103,
  102,
  106,
  5,
  10,
  4,
  104,
  103,
  107,
  4,
  10,
  4,
  103,
  104,
  100,
  4, // 223
  7,
  10,
  4,
  106,
  4,
  7,
  11,
  10,
  4,
  4,
  9,
  7,
  11,
  10,
  4,
  106,
  9,
  4,
  11,
  10,
  4,
  106,
  7,
  10,
  11,
  10,
  4,
  9,
  10,
  7,
  11,
  10,
  4,
  106,
  7,
  107,
  10,
  10,
  4,
  105,
  4,
  106,
  9, // 224
  15,
  10,
  4,
  106,
  4,
  7,
  11,
  10,
  4,
  4,
  9,
  7,
  11,
  10,
  4,
  106,
  9,
  4,
  11,
  10,
  4,
  106,
  7,
  10,
  11,
  10,
  4,
  9,
  10,
  7,
  11,
  10,
  4,
  3,
  10,
  9,
  11,
  10,
  4,
  3,
  9,
  0,
  11,
  10,
  4,
  7,
  9,
  3,
  10,
  10,
  4,
  106,
  7,
  107,
  10,
  10,
  4,
  3,
  7,
  4,
  9,
  10,
  4,
  3,
  4,
  0,
  9,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  0,
  3,
  100,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8, // 225
  11,
  10,
  4,
  105,
  1,
  4,
  11,
  10,
  4,
  105,
  4,
  106,
  11,
  10,
  4,
  106,
  4,
  7,
  11,
  10,
  4,
  1,
  7,
  4,
  11,
  10,
  4,
  106,
  7,
  10,
  11,
  10,
  4,
  1,
  10,
  7,
  11,
  10,
  4,
  106,
  7,
  107,
  10,
  10,
  4,
  0,
  7,
  1,
  10,
  10,
  4,
  0,
  4,
  1,
  7,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  105,
  101,
  0,
  1, // 226
  15,
  10,
  4,
  105,
  1,
  4,
  11,
  10,
  4,
  105,
  4,
  106,
  11,
  10,
  4,
  4,
  7,
  106,
  11,
  10,
  4,
  1,
  7,
  4,
  11,
  10,
  4,
  7,
  10,
  106,
  11,
  10,
  4,
  1,
  10,
  7,
  11,
  10,
  4,
  107,
  106,
  7,
  10,
  10,
  4,
  3,
  7,
  1,
  10,
  10,
  4,
  100,
  101,
  1,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  1,
  3,
  100,
  8,
  10,
  4,
  1,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  3,
  4,
  1,
  7,
  10,
  4,
  105,
  1,
  101,
  4, // 227
  7,
  10,
  4,
  106,
  2,
  7,
  10,
  10,
  4,
  106,
  7,
  107,
  10,
  10,
  4,
  106,
  4,
  1,
  9,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  106,
  2,
  4,
  7,
  10,
  4,
  106,
  2,
  1,
  4,
  10,
  4,
  106,
  102,
  1,
  2, // 228
  15,
  10,
  4,
  106,
  2,
  7,
  10,
  10,
  4,
  106,
  7,
  107,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  106,
  4,
  1,
  9,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  100,
  0,
  3,
  8,
  10,
  4,
  0,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  3,
  4,
  2,
  7,
  10,
  4,
  106,
  2,
  4,
  7,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  106,
  2,
  1,
  4,
  10,
  4,
  106,
  102,
  1,
  2, // 229
  10,
  10,
  4,
  0,
  7,
  2,
  10,
  10,
  4,
  106,
  2,
  7,
  10,
  10,
  4,
  106,
  7,
  107,
  10,
  10,
  4,
  0,
  4,
  2,
  7,
  10,
  4,
  106,
  2,
  4,
  7,
  10,
  4,
  106,
  2,
  0,
  4,
  10,
  4,
  105,
  106,
  0,
  4,
  10,
  4,
  106,
  102,
  0,
  2,
  10,
  4,
  105,
  106,
  102,
  0,
  10,
  4,
  101,
  105,
  102,
  0, // 230
  13,
  10,
  4,
  107,
  106,
  7,
  10,
  10,
  4,
  2,
  7,
  106,
  10,
  10,
  4,
  3,
  7,
  2,
  10,
  10,
  4,
  101,
  3,
  100,
  8,
  10,
  4,
  101,
  4,
  3,
  8,
  10,
  4,
  4,
  7,
  3,
  8,
  10,
  4,
  3,
  4,
  2,
  7,
  10,
  4,
  2,
  4,
  106,
  7,
  10,
  4,
  101,
  105,
  2,
  4,
  10,
  4,
  101,
  2,
  3,
  4,
  10,
  4,
  105,
  106,
  2,
  4,
  10,
  4,
  105,
  106,
  102,
  2,
  10,
  4,
  101,
  105,
  102,
  2, // 231
  11,
  10,
  4,
  4,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  4,
  11,
  10,
  4,
  4,
  7,
  106,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  107,
  106,
  7,
  11,
  10,
  4,
  107,
  7,
  2,
  11,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  2,
  4,
  3,
  9,
  10,
  4,
  107,
  3,
  2,
  7,
  10,
  4,
  3,
  4,
  2,
  7,
  10,
  4,
  103,
  2,
  107,
  3, // 232
  15,
  10,
  4,
  4,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  4,
  11,
  10,
  4,
  106,
  4,
  7,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  107,
  7,
  2,
  11,
  10,
  4,
  106,
  7,
  107,
  11,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  2,
  4,
  0,
  9,
  10,
  4,
  0,
  2,
  103,
  8,
  10,
  4,
  2,
  7,
  103,
  8,
  10,
  4,
  0,
  7,
  2,
  8,
  10,
  4,
  100,
  0,
  103,
  8,
  10,
  4,
  4,
  7,
  0,
  8,
  10,
  4,
  107,
  103,
  2,
  7,
  10,
  4,
  0,
  4,
  2,
  7, // 233
  14,
  10,
  4,
  105,
  1,
  4,
  11,
  10,
  4,
  105,
  4,
  106,
  11,
  10,
  4,
  2,
  4,
  1,
  11,
  10,
  4,
  106,
  4,
  7,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  107,
  7,
  2,
  11,
  10,
  4,
  106,
  7,
  107,
  11,
  10,
  4,
  107,
  3,
  2,
  7,
  10,
  4,
  3,
  4,
  2,
  7,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  1,
  2,
  0,
  4,
  10,
  4,
  105,
  1,
  0,
  4,
  10,
  4,
  107,
  103,
  2,
  3,
  10,
  4,
  105,
  101,
  0,
  1, // 234
  16,
  10,
  4,
  105,
  1,
  4,
  11,
  10,
  4,
  105,
  4,
  106,
  11,
  10,
  4,
  2,
  4,
  1,
  11,
  10,
  4,
  106,
  4,
  7,
  11,
  10,
  4,
  2,
  7,
  4,
  11,
  10,
  4,
  107,
  7,
  2,
  11,
  10,
  4,
  106,
  7,
  107,
  11,
  10,
  4,
  100,
  2,
  103,
  8,
  10,
  4,
  2,
  7,
  103,
  8,
  10,
  4,
  101,
  1,
  100,
  8,
  10,
  4,
  101,
  4,
  1,
  8,
  10,
  4,
  100,
  1,
  2,
  8,
  10,
  4,
  1,
  4,
  2,
  8,
  10,
  4,
  4,
  7,
  2,
  8,
  10,
  4,
  103,
  2,
  107,
  7,
  10,
  4,
  101,
  105,
  1,
  4, // 235
  10,
  10,
  4,
  1,
  4,
  3,
  9,
  10,
  4,
  106,
  4,
  1,
  9,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  107,
  3,
  1,
  7,
  10,
  4,
  3,
  4,
  1,
  7,
  10,
  4,
  107,
  1,
  106,
  7,
  10,
  4,
  1,
  4,
  106,
  7,
  10,
  4,
  103,
  1,
  107,
  3,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  103,
  102,
  106,
  1, // 236
  13,
  10,
  4,
  1,
  4,
  0,
  9,
  10,
  4,
  106,
  4,
  1,
  9,
  10,
  4,
  105,
  4,
  106,
  9,
  10,
  4,
  100,
  0,
  103,
  8,
  10,
  4,
  0,
  7,
  103,
  8,
  10,
  4,
  4,
  7,
  0,
  8,
  10,
  4,
  107,
  103,
  1,
  7,
  10,
  4,
  0,
  1,
  103,
  7,
  10,
  4,
  0,
  4,
  1,
  7,
  10,
  4,
  106,
  107,
  1,
  7,
  10,
  4,
  106,
  1,
  4,
  7,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  103,
  102,
  106,
  1, // 237
  9,
  10,
  4,
  106,
  107,
  3,
  7,
  10,
  4,
  106,
  3,
  4,
  7,
  10,
  4,
  106,
  3,
  0,
  4,
  10,
  4,
  105,
  106,
  0,
  4,
  10,
  4,
  103,
  102,
  106,
  3,
  10,
  4,
  102,
  0,
  106,
  3,
  10,
  4,
  106,
  107,
  103,
  3,
  10,
  4,
  105,
  106,
  102,
  0,
  10,
  4,
  102,
  101,
  105,
  0, // 238
  10,
  10,
  4,
  103,
  102,
  7,
  8,
  10,
  4,
  4,
  7,
  102,
  8,
  10,
  4,
  101,
  102,
  100,
  8,
  10,
  4,
  101,
  4,
  102,
  8,
  10,
  4,
  102,
  103,
  100,
  8,
  10,
  4,
  103,
  102,
  106,
  7,
  10,
  4,
  102,
  4,
  106,
  7,
  10,
  4,
  106,
  107,
  103,
  7,
  10,
  4,
  105,
  106,
  102,
  4,
  10,
  4,
  101,
  105,
  102,
  4, // 239
  6,
  10,
  4,
  106,
  9,
  10,
  11,
  10,
  4,
  106,
  9,
  8,
  10,
  10,
  4,
  106,
  8,
  107,
  10,
  10,
  4,
  105,
  8,
  106,
  9,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  104,
  107,
  106,
  8, // 240
  10,
  10,
  4,
  106,
  9,
  10,
  11,
  10,
  4,
  3,
  10,
  9,
  11,
  10,
  4,
  3,
  9,
  0,
  11,
  10,
  4,
  106,
  9,
  107,
  10,
  10,
  4,
  104,
  107,
  9,
  10,
  10,
  4,
  104,
  9,
  3,
  10,
  10,
  4,
  104,
  0,
  3,
  9,
  10,
  4,
  104,
  107,
  106,
  9,
  10,
  4,
  104,
  106,
  105,
  9,
  10,
  4,
  104,
  0,
  100,
  3, // 241
  10,
  10,
  4,
  105,
  1,
  8,
  11,
  10,
  4,
  105,
  8,
  106,
  11,
  10,
  4,
  106,
  8,
  10,
  11,
  10,
  4,
  1,
  10,
  8,
  11,
  10,
  4,
  106,
  8,
  107,
  10,
  10,
  4,
  0,
  8,
  1,
  10,
  10,
  4,
  104,
  107,
  106,
  8,
  10,
  4,
  105,
  1,
  0,
  8,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  105,
  101,
  0,
  1, // 242
  9,
  10,
  4,
  106,
  105,
  10,
  11,
  10,
  4,
  1,
  10,
  105,
  11,
  10,
  4,
  104,
  106,
  105,
  10,
  10,
  4,
  104,
  105,
  1,
  10,
  10,
  4,
  104,
  107,
  106,
  10,
  10,
  4,
  1,
  3,
  104,
  10,
  10,
  4,
  100,
  104,
  1,
  3,
  10,
  4,
  104,
  105,
  101,
  1,
  10,
  4,
  100,
  104,
  101,
  1, // 243
  10,
  10,
  4,
  106,
  2,
  9,
  10,
  10,
  4,
  8,
  9,
  2,
  10,
  10,
  4,
  106,
  9,
  8,
  10,
  10,
  4,
  106,
  8,
  107,
  10,
  10,
  4,
  106,
  2,
  1,
  9,
  10,
  4,
  2,
  8,
  1,
  9,
  10,
  4,
  106,
  105,
  8,
  9,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  104,
  107,
  106,
  8,
  10,
  4,
  106,
  102,
  1,
  2, // 244
  13,
  10,
  4,
  106,
  2,
  9,
  10,
  10,
  4,
  106,
  9,
  107,
  10,
  10,
  4,
  3,
  9,
  2,
  10,
  10,
  4,
  104,
  9,
  3,
  10,
  10,
  4,
  107,
  9,
  104,
  10,
  10,
  4,
  106,
  2,
  1,
  9,
  10,
  4,
  1,
  2,
  0,
  9,
  10,
  4,
  2,
  3,
  0,
  9,
  10,
  4,
  0,
  3,
  104,
  9,
  10,
  4,
  104,
  107,
  106,
  9,
  10,
  4,
  104,
  106,
  105,
  9,
  10,
  4,
  100,
  104,
  0,
  3,
  10,
  4,
  106,
  102,
  1,
  2, // 245
  9,
  10,
  4,
  106,
  2,
  8,
  10,
  10,
  4,
  106,
  8,
  107,
  10,
  10,
  4,
  106,
  2,
  0,
  8,
  10,
  4,
  104,
  107,
  106,
  8,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  106,
  0,
  105,
  8,
  10,
  4,
  106,
  102,
  0,
  2,
  10,
  4,
  102,
  101,
  105,
  0,
  10,
  4,
  105,
  106,
  102,
  0, // 246
  10,
  10,
  4,
  104,
  105,
  3,
  10,
  10,
  4,
  2,
  3,
  105,
  10,
  10,
  4,
  104,
  106,
  105,
  10,
  10,
  4,
  106,
  2,
  105,
  10,
  10,
  4,
  104,
  107,
  106,
  10,
  10,
  4,
  104,
  105,
  101,
  3,
  10,
  4,
  105,
  2,
  101,
  3,
  10,
  4,
  101,
  100,
  104,
  3,
  10,
  4,
  102,
  101,
  105,
  2,
  10,
  4,
  105,
  106,
  102,
  2, // 247
  10,
  10,
  4,
  8,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  8,
  11,
  10,
  4,
  107,
  106,
  8,
  11,
  10,
  4,
  107,
  8,
  2,
  11,
  10,
  4,
  106,
  105,
  8,
  9,
  10,
  4,
  2,
  8,
  3,
  9,
  10,
  4,
  107,
  3,
  2,
  8,
  10,
  4,
  104,
  107,
  106,
  8,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  103,
  2,
  107,
  3, // 248
  9,
  10,
  4,
  107,
  9,
  2,
  11,
  10,
  4,
  106,
  9,
  107,
  11,
  10,
  4,
  104,
  106,
  105,
  9,
  10,
  4,
  104,
  107,
  106,
  9,
  10,
  4,
  104,
  0,
  107,
  9,
  10,
  4,
  0,
  2,
  107,
  9,
  10,
  4,
  107,
  0,
  103,
  2,
  10,
  4,
  104,
  103,
  107,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 249
  13,
  10,
  4,
  105,
  1,
  8,
  11,
  10,
  4,
  105,
  8,
  106,
  11,
  10,
  4,
  2,
  8,
  1,
  11,
  10,
  4,
  107,
  8,
  2,
  11,
  10,
  4,
  106,
  8,
  107,
  11,
  10,
  4,
  104,
  107,
  106,
  8,
  10,
  4,
  2,
  3,
  0,
  8,
  10,
  4,
  107,
  3,
  2,
  8,
  10,
  4,
  1,
  2,
  0,
  8,
  10,
  4,
  105,
  1,
  0,
  8,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  107,
  103,
  2,
  3,
  10,
  4,
  105,
  101,
  0,
  1, // 250
  10,
  10,
  4,
  104,
  1,
  2,
  11,
  10,
  4,
  104,
  2,
  107,
  11,
  10,
  4,
  104,
  106,
  105,
  11,
  10,
  4,
  104,
  105,
  1,
  11,
  10,
  4,
  104,
  107,
  106,
  11,
  10,
  4,
  104,
  103,
  107,
  2,
  10,
  4,
  103,
  104,
  100,
  2,
  10,
  4,
  104,
  1,
  100,
  2,
  10,
  4,
  101,
  100,
  104,
  1,
  10,
  4,
  104,
  105,
  101,
  1, // 251
  9,
  10,
  4,
  106,
  105,
  8,
  9,
  10,
  4,
  106,
  8,
  1,
  9,
  10,
  4,
  107,
  3,
  1,
  8,
  10,
  4,
  104,
  107,
  106,
  8,
  10,
  4,
  107,
  1,
  106,
  8,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  103,
  1,
  107,
  3,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  103,
  102,
  106,
  1, // 252
  10,
  10,
  4,
  106,
  107,
  1,
  9,
  10,
  4,
  0,
  1,
  107,
  9,
  10,
  4,
  104,
  107,
  106,
  9,
  10,
  4,
  104,
  0,
  107,
  9,
  10,
  4,
  104,
  106,
  105,
  9,
  10,
  4,
  106,
  107,
  103,
  1,
  10,
  4,
  107,
  0,
  103,
  1,
  10,
  4,
  103,
  102,
  106,
  1,
  10,
  4,
  104,
  103,
  107,
  0,
  10,
  4,
  103,
  104,
  100,
  0, // 253
  10,
  10,
  4,
  106,
  107,
  3,
  8,
  10,
  4,
  106,
  3,
  0,
  8,
  10,
  4,
  104,
  107,
  106,
  8,
  10,
  4,
  104,
  106,
  105,
  8,
  10,
  4,
  106,
  0,
  105,
  8,
  10,
  4,
  103,
  102,
  106,
  3,
  10,
  4,
  102,
  0,
  106,
  3,
  10,
  4,
  106,
  107,
  103,
  3,
  10,
  4,
  105,
  106,
  102,
  0,
  10,
  4,
  102,
  101,
  105,
  0, // 254
  1,
  12,
  8,
  100,
  101,
  102,
  103,
  104,
  105,
  106,
  107, // 255
       // vtkm::CELL_SHAPE_WEDGE
  0,   // 0
  1,
  10,
  4,
  0,
  2,
  100,
  6, // 1
  1,
  10,
  4,
  101,
  1,
  0,
  7, // 2
  3,
  10,
  4,
  1,
  6,
  101,
  7,
  10,
  4,
  1,
  2,
  100,
  6,
  10,
  4,
  101,
  1,
  100,
  6, // 3
  1,
  10,
  4,
  102,
  2,
  1,
  8, // 4
  3,
  10,
  4,
  102,
  6,
  1,
  8,
  10,
  4,
  100,
  1,
  102,
  6,
  10,
  4,
  100,
  0,
  1,
  6, // 5
  3,
  10,
  4,
  2,
  7,
  102,
  8,
  10,
  4,
  102,
  2,
  0,
  7,
  10,
  4,
  102,
  0,
  101,
  7, // 6
  3,
  10,
  4,
  6,
  7,
  102,
  8,
  10,
  4,
  102,
  6,
  101,
  7,
  10,
  4,
  101,
  102,
  100,
  6, // 7
  1,
  10,
  4,
  103,
  5,
  3,
  6, // 8
  3,
  10,
  4,
  103,
  3,
  2,
  5,
  10,
  4,
  0,
  2,
  103,
  3,
  10,
  4,
  103,
  0,
  100,
  2, // 9
  6,
  10,
  4,
  1,
  5,
  3,
  7,
  10,
  4,
  101,
  1,
  0,
  7,
  10,
  4,
  1,
  3,
  0,
  7,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  103,
  5,
  3,
  6,
  10,
  4,
  0,
  3,
  1,
  6, // 10
  7,
  10,
  4,
  1,
  5,
  3,
  7,
  10,
  4,
  100,
  101,
  1,
  7,
  10,
  4,
  100,
  1,
  3,
  7,
  10,
  4,
  103,
  3,
  1,
  5,
  10,
  4,
  1,
  2,
  103,
  5,
  10,
  4,
  100,
  1,
  103,
  3,
  10,
  4,
  103,
  1,
  100,
  2, // 11
  6,
  10,
  4,
  102,
  2,
  1,
  8,
  10,
  4,
  2,
  5,
  1,
  8,
  10,
  4,
  1,
  5,
  3,
  8,
  10,
  4,
  1,
  5,
  2,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  103,
  5,
  3,
  6, // 12
  7,
  10,
  4,
  102,
  100,
  1,
  8,
  10,
  4,
  100,
  5,
  1,
  8,
  10,
  4,
  1,
  5,
  3,
  8,
  10,
  4,
  103,
  1,
  100,
  5,
  10,
  4,
  103,
  3,
  1,
  5,
  10,
  4,
  0,
  1,
  103,
  3,
  10,
  4,
  103,
  0,
  100,
  1, // 13
  9,
  10,
  4,
  102,
  2,
  7,
  8,
  10,
  4,
  5,
  7,
  2,
  8,
  10,
  4,
  2,
  5,
  3,
  7,
  10,
  4,
  102,
  2,
  0,
  7,
  10,
  4,
  2,
  3,
  0,
  7,
  10,
  4,
  101,
  102,
  0,
  7,
  10,
  4,
  3,
  5,
  2,
  6,
  10,
  4,
  103,
  5,
  3,
  6,
  10,
  4,
  0,
  3,
  2,
  6, // 14
  5,
  10,
  4,
  102,
  100,
  7,
  8,
  10,
  4,
  5,
  7,
  100,
  8,
  10,
  4,
  100,
  5,
  3,
  7,
  10,
  4,
  101,
  102,
  100,
  7,
  10,
  4,
  103,
  3,
  100,
  5, // 15
  1,
  10,
  4,
  3,
  4,
  104,
  7, // 16
  6,
  10,
  4,
  2,
  4,
  0,
  7,
  10,
  4,
  104,
  3,
  4,
  7,
  10,
  4,
  0,
  4,
  3,
  7,
  10,
  4,
  0,
  2,
  100,
  6,
  10,
  4,
  2,
  0,
  4,
  6,
  10,
  4,
  3,
  4,
  0,
  6, // 17
  3,
  10,
  4,
  1,
  3,
  104,
  4,
  10,
  4,
  104,
  1,
  0,
  3,
  10,
  4,
  101,
  0,
  104,
  1, // 18
  7,
  10,
  4,
  100,
  101,
  1,
  6,
  10,
  4,
  101,
  3,
  1,
  6,
  10,
  4,
  1,
  2,
  100,
  6,
  10,
  4,
  2,
  1,
  4,
  6,
  10,
  4,
  3,
  4,
  1,
  6,
  10,
  4,
  1,
  3,
  104,
  4,
  10,
  4,
  104,
  1,
  101,
  3, // 19
  7,
  10,
  4,
  3,
  4,
  2,
  8,
  10,
  4,
  102,
  2,
  1,
  8,
  10,
  4,
  2,
  4,
  1,
  8,
  10,
  4,
  1,
  3,
  2,
  7,
  10,
  4,
  3,
  4,
  104,
  7,
  10,
  4,
  1,
  4,
  3,
  7,
  10,
  4,
  2,
  3,
  1,
  4, // 20
  9,
  10,
  4,
  1,
  6,
  4,
  8,
  10,
  4,
  102,
  6,
  1,
  8,
  10,
  4,
  1,
  3,
  0,
  7,
  10,
  4,
  3,
  4,
  104,
  7,
  10,
  4,
  1,
  4,
  3,
  7,
  10,
  4,
  102,
  100,
  1,
  6,
  10,
  4,
  0,
  1,
  100,
  6,
  10,
  4,
  0,
  3,
  1,
  6,
  10,
  4,
  3,
  4,
  1,
  6, // 21
  7,
  10,
  4,
  3,
  4,
  2,
  8,
  10,
  4,
  2,
  4,
  102,
  8,
  10,
  4,
  104,
  0,
  3,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  102,
  2,
  0,
  4,
  10,
  4,
  101,
  102,
  0,
  4,
  10,
  4,
  101,
  0,
  104,
  4, // 22
  6,
  10,
  4,
  102,
  6,
  4,
  8,
  10,
  4,
  100,
  4,
  102,
  6,
  10,
  4,
  101,
  3,
  4,
  6,
  10,
  4,
  101,
  4,
  100,
  6,
  10,
  4,
  101,
  102,
  100,
  4,
  10,
  4,
  101,
  3,
  104,
  4, // 23
  3,
  10,
  4,
  104,
  6,
  4,
  7,
  10,
  4,
  103,
  4,
  104,
  6,
  10,
  4,
  103,
  5,
  4,
  6, // 24
  6,
  10,
  4,
  2,
  4,
  0,
  7,
  10,
  4,
  104,
  103,
  4,
  7,
  10,
  4,
  0,
  4,
  103,
  7,
  10,
  4,
  103,
  4,
  2,
  5,
  10,
  4,
  0,
  2,
  103,
  4,
  10,
  4,
  103,
  0,
  100,
  2, // 25
  7,
  10,
  4,
  4,
  5,
  1,
  6,
  10,
  4,
  103,
  5,
  4,
  6,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  104,
  103,
  4,
  6,
  10,
  4,
  104,
  4,
  0,
  6,
  10,
  4,
  104,
  1,
  0,
  4,
  10,
  4,
  101,
  0,
  104,
  1, // 26
  6,
  10,
  4,
  103,
  4,
  2,
  5,
  10,
  4,
  104,
  1,
  103,
  4,
  10,
  4,
  1,
  2,
  103,
  4,
  10,
  4,
  103,
  1,
  100,
  2,
  10,
  4,
  100,
  103,
  101,
  1,
  10,
  4,
  103,
  104,
  101,
  1, // 27
  9,
  10,
  4,
  2,
  5,
  4,
  8,
  10,
  4,
  102,
  2,
  1,
  8,
  10,
  4,
  2,
  4,
  1,
  8,
  10,
  4,
  4,
  6,
  1,
  7,
  10,
  4,
  104,
  6,
  4,
  7,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  103,
  5,
  4,
  6,
  10,
  4,
  1,
  4,
  2,
  6,
  10,
  4,
  104,
  103,
  4,
  6, // 28
  10,
  10,
  4,
  102,
  100,
  1,
  8,
  10,
  4,
  100,
  5,
  1,
  8,
  10,
  4,
  1,
  5,
  4,
  8,
  10,
  4,
  104,
  103,
  4,
  7,
  10,
  4,
  0,
  4,
  103,
  7,
  10,
  4,
  1,
  4,
  0,
  7,
  10,
  4,
  103,
  4,
  1,
  5,
  10,
  4,
  103,
  1,
  100,
  5,
  10,
  4,
  0,
  1,
  103,
  4,
  10,
  4,
  103,
  0,
  100,
  1, // 29
  10,
  10,
  4,
  102,
  2,
  4,
  8,
  10,
  4,
  2,
  5,
  4,
  8,
  10,
  4,
  4,
  5,
  2,
  6,
  10,
  4,
  103,
  5,
  4,
  6,
  10,
  4,
  0,
  4,
  2,
  6,
  10,
  4,
  104,
  103,
  4,
  6,
  10,
  4,
  104,
  4,
  0,
  6,
  10,
  4,
  102,
  2,
  0,
  4,
  10,
  4,
  101,
  0,
  104,
  4,
  10,
  4,
  102,
  0,
  101,
  4, // 30
  6,
  10,
  4,
  102,
  100,
  4,
  8,
  10,
  4,
  100,
  5,
  4,
  8,
  10,
  4,
  103,
  4,
  100,
  5,
  10,
  4,
  101,
  102,
  100,
  4,
  10,
  4,
  101,
  100,
  103,
  4,
  10,
  4,
  103,
  104,
  101,
  4, // 31
  1,
  10,
  4,
  4,
  5,
  105,
  8, // 32
  6,
  10,
  4,
  2,
  4,
  0,
  8,
  10,
  4,
  105,
  4,
  5,
  8,
  10,
  4,
  2,
  5,
  4,
  8,
  10,
  4,
  0,
  2,
  100,
  6,
  10,
  4,
  0,
  4,
  2,
  6,
  10,
  4,
  4,
  5,
  2,
  6, // 33
  7,
  10,
  4,
  0,
  5,
  1,
  8,
  10,
  4,
  4,
  5,
  105,
  8,
  10,
  4,
  1,
  5,
  4,
  8,
  10,
  4,
  101,
  1,
  0,
  7,
  10,
  4,
  1,
  4,
  0,
  7,
  10,
  4,
  4,
  5,
  0,
  7,
  10,
  4,
  0,
  4,
  1,
  5, // 34
  9,
  10,
  4,
  2,
  4,
  1,
  8,
  10,
  4,
  105,
  4,
  5,
  8,
  10,
  4,
  2,
  5,
  4,
  8,
  10,
  4,
  101,
  1,
  6,
  7,
  10,
  4,
  4,
  6,
  1,
  7,
  10,
  4,
  100,
  101,
  1,
  6,
  10,
  4,
  1,
  2,
  100,
  6,
  10,
  4,
  1,
  4,
  2,
  6,
  10,
  4,
  4,
  5,
  2,
  6, // 35
  3,
  10,
  4,
  2,
  4,
  105,
  5,
  10,
  4,
  105,
  2,
  1,
  4,
  10,
  4,
  102,
  1,
  105,
  2, // 36
  7,
  10,
  4,
  0,
  1,
  100,
  6,
  10,
  4,
  0,
  4,
  1,
  6,
  10,
  4,
  4,
  5,
  1,
  6,
  10,
  4,
  102,
  100,
  1,
  6,
  10,
  4,
  102,
  1,
  5,
  6,
  10,
  4,
  105,
  1,
  4,
  5,
  10,
  4,
  102,
  1,
  105,
  5, // 37
  7,
  10,
  4,
  4,
  5,
  0,
  7,
  10,
  4,
  101,
  4,
  0,
  7,
  10,
  4,
  105,
  2,
  4,
  5,
  10,
  4,
  0,
  4,
  2,
  5,
  10,
  4,
  102,
  105,
  2,
  4,
  10,
  4,
  102,
  2,
  0,
  4,
  10,
  4,
  101,
  102,
  0,
  4, // 38
  6,
  10,
  4,
  4,
  6,
  101,
  7,
  10,
  4,
  101,
  4,
  100,
  6,
  10,
  4,
  102,
  100,
  4,
  6,
  10,
  4,
  102,
  4,
  5,
  6,
  10,
  4,
  102,
  4,
  105,
  5,
  10,
  4,
  101,
  102,
  100,
  4, // 39
  3,
  10,
  4,
  4,
  6,
  105,
  8,
  10,
  4,
  103,
  4,
  3,
  6,
  10,
  4,
  105,
  4,
  103,
  6, // 40
  7,
  10,
  4,
  2,
  4,
  0,
  8,
  10,
  4,
  103,
  4,
  2,
  8,
  10,
  4,
  105,
  4,
  103,
  8,
  10,
  4,
  103,
  3,
  2,
  4,
  10,
  4,
  2,
  3,
  0,
  4,
  10,
  4,
  0,
  2,
  103,
  3,
  10,
  4,
  100,
  103,
  0,
  2, // 41
  9,
  10,
  4,
  4,
  6,
  105,
  8,
  10,
  4,
  1,
  6,
  4,
  8,
  10,
  4,
  1,
  4,
  3,
  7,
  10,
  4,
  101,
  1,
  0,
  7,
  10,
  4,
  1,
  3,
  0,
  7,
  10,
  4,
  103,
  105,
  4,
  6,
  10,
  4,
  3,
  4,
  1,
  6,
  10,
  4,
  103,
  4,
  3,
  6,
  10,
  4,
  0,
  3,
  1,
  6, // 42
  10,
  10,
  4,
  2,
  4,
  1,
  8,
  10,
  4,
  103,
  4,
  2,
  8,
  10,
  4,
  105,
  4,
  103,
  8,
  10,
  4,
  1,
  4,
  3,
  7,
  10,
  4,
  100,
  101,
  1,
  7,
  10,
  4,
  100,
  1,
  3,
  7,
  10,
  4,
  1,
  2,
  103,
  4,
  10,
  4,
  103,
  3,
  1,
  4,
  10,
  4,
  100,
  1,
  103,
  3,
  10,
  4,
  100,
  103,
  1,
  2, // 43
  7,
  10,
  4,
  105,
  2,
  4,
  6,
  10,
  4,
  105,
  4,
  103,
  6,
  10,
  4,
  1,
  4,
  2,
  6,
  10,
  4,
  3,
  4,
  1,
  6,
  10,
  4,
  103,
  4,
  3,
  6,
  10,
  4,
  105,
  2,
  1,
  4,
  10,
  4,
  102,
  1,
  105,
  2, // 44
  6,
  10,
  4,
  103,
  1,
  105,
  4,
  10,
  4,
  103,
  3,
  1,
  4,
  10,
  4,
  0,
  1,
  103,
  3,
  10,
  4,
  102,
  105,
  103,
  1,
  10,
  4,
  102,
  103,
  100,
  1,
  10,
  4,
  103,
  0,
  100,
  1, // 45
  10,
  10,
  4,
  0,
  101,
  4,
  7,
  10,
  4,
  0,
  4,
  3,
  7,
  10,
  4,
  2,
  0,
  4,
  6,
  10,
  4,
  3,
  4,
  0,
  6,
  10,
  4,
  105,
  2,
  4,
  6,
  10,
  4,
  105,
  4,
  103,
  6,
  10,
  4,
  103,
  4,
  3,
  6,
  10,
  4,
  102,
  105,
  2,
  4,
  10,
  4,
  102,
  2,
  0,
  4,
  10,
  4,
  102,
  0,
  101,
  4, // 46
  6,
  10,
  4,
  100,
  4,
  3,
  7,
  10,
  4,
  101,
  4,
  100,
  7,
  10,
  4,
  101,
  102,
  100,
  4,
  10,
  4,
  102,
  103,
  100,
  4,
  10,
  4,
  103,
  3,
  100,
  4,
  10,
  4,
  102,
  105,
  103,
  4, // 47
  3,
  10,
  4,
  105,
  7,
  5,
  8,
  10,
  4,
  3,
  5,
  105,
  7,
  10,
  4,
  104,
  3,
  105,
  7, // 48
  9,
  10,
  4,
  2,
  5,
  7,
  8,
  10,
  4,
  105,
  7,
  5,
  8,
  10,
  4,
  105,
  104,
  3,
  7,
  10,
  4,
  3,
  5,
  105,
  7,
  10,
  4,
  2,
  5,
  3,
  7,
  10,
  4,
  2,
  3,
  0,
  7,
  10,
  4,
  100,
  0,
  2,
  6,
  10,
  4,
  0,
  3,
  2,
  6,
  10,
  4,
  3,
  5,
  2,
  6, // 49
  7,
  10,
  4,
  0,
  5,
  1,
  8,
  10,
  4,
  1,
  5,
  105,
  8,
  10,
  4,
  1,
  3,
  105,
  5,
  10,
  4,
  0,
  3,
  1,
  5,
  10,
  4,
  104,
  105,
  1,
  3,
  10,
  4,
  104,
  1,
  0,
  3,
  10,
  4,
  104,
  101,
  0,
  1, // 50
  10,
  10,
  4,
  105,
  1,
  5,
  8,
  10,
  4,
  2,
  5,
  1,
  8,
  10,
  4,
  2,
  1,
  5,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  100,
  101,
  1,
  6,
  10,
  4,
  101,
  3,
  1,
  6,
  10,
  4,
  1,
  2,
  100,
  6,
  10,
  4,
  105,
  1,
  3,
  5,
  10,
  4,
  104,
  1,
  101,
  3,
  10,
  4,
  105,
  1,
  104,
  3, // 51
  7,
  10,
  4,
  1,
  3,
  2,
  7,
  10,
  4,
  104,
  3,
  1,
  7,
  10,
  4,
  105,
  2,
  1,
  5,
  10,
  4,
  105,
  1,
  3,
  5,
  10,
  4,
  2,
  3,
  1,
  5,
  10,
  4,
  105,
  1,
  104,
  3,
  10,
  4,
  102,
  1,
  105,
  2, // 52
  10,
  10,
  4,
  1,
  3,
  0,
  7,
  10,
  4,
  104,
  3,
  1,
  7,
  10,
  4,
  100,
  1,
  102,
  6,
  10,
  4,
  1,
  5,
  102,
  6,
  10,
  4,
  100,
  0,
  1,
  6,
  10,
  4,
  0,
  3,
  1,
  6,
  10,
  4,
  3,
  5,
  1,
  6,
  10,
  4,
  1,
  3,
  105,
  5,
  10,
  4,
  102,
  1,
  105,
  5,
  10,
  4,
  104,
  105,
  1,
  3, // 53
  6,
  10,
  4,
  2,
  3,
  105,
  5,
  10,
  4,
  105,
  2,
  0,
  3,
  10,
  4,
  105,
  0,
  104,
  3,
  10,
  4,
  102,
  0,
  105,
  2,
  10,
  4,
  104,
  105,
  102,
  0,
  10,
  4,
  101,
  104,
  102,
  0, // 54
  6,
  10,
  4,
  101,
  102,
  100,
  6,
  10,
  4,
  101,
  3,
  102,
  6,
  10,
  4,
  3,
  5,
  102,
  6,
  10,
  4,
  102,
  3,
  105,
  5,
  10,
  4,
  101,
  104,
  102,
  3,
  10,
  4,
  104,
  105,
  102,
  3, // 55
  3,
  10,
  4,
  105,
  7,
  6,
  8,
  10,
  4,
  104,
  6,
  105,
  7,
  10,
  4,
  103,
  105,
  104,
  6, // 56
  5,
  10,
  4,
  103,
  105,
  7,
  8,
  10,
  4,
  103,
  7,
  2,
  8,
  10,
  4,
  103,
  105,
  104,
  7,
  10,
  4,
  103,
  0,
  2,
  7,
  10,
  4,
  103,
  0,
  100,
  2, // 57
  6,
  10,
  4,
  1,
  6,
  105,
  8,
  10,
  4,
  105,
  1,
  103,
  6,
  10,
  4,
  104,
  1,
  0,
  6,
  10,
  4,
  103,
  1,
  104,
  6,
  10,
  4,
  103,
  105,
  104,
  1,
  10,
  4,
  104,
  101,
  0,
  1, // 58
  6,
  10,
  4,
  105,
  1,
  103,
  8,
  10,
  4,
  1,
  2,
  103,
  8,
  10,
  4,
  100,
  103,
  1,
  2,
  10,
  4,
  100,
  103,
  101,
  1,
  10,
  4,
  103,
  104,
  101,
  1,
  10,
  4,
  103,
  105,
  104,
  1, // 59
  6,
  10,
  4,
  104,
  6,
  1,
  7,
  10,
  4,
  103,
  105,
  1,
  6,
  10,
  4,
  105,
  2,
  1,
  6,
  10,
  4,
  103,
  1,
  104,
  6,
  10,
  4,
  102,
  1,
  105,
  2,
  10,
  4,
  103,
  105,
  104,
  1, // 60
  6,
  10,
  4,
  103,
  0,
  1,
  7,
  10,
  4,
  103,
  1,
  104,
  7,
  10,
  4,
  103,
  105,
  104,
  1,
  10,
  4,
  102,
  103,
  100,
  1,
  10,
  4,
  103,
  0,
  100,
  1,
  10,
  4,
  103,
  102,
  105,
  1, // 61
  6,
  10,
  4,
  105,
  2,
  0,
  6,
  10,
  4,
  103,
  105,
  104,
  6,
  10,
  4,
  105,
  0,
  104,
  6,
  10,
  4,
  102,
  0,
  105,
  2,
  10,
  4,
  104,
  105,
  102,
  0,
  10,
  4,
  102,
  101,
  104,
  0, // 62
  1,
  13,
  6,
  100,
  101,
  102,
  103,
  104,
  105, // 63
       // vtkm::CELL_SHAPE_PYRAMID
  0,   // 0
  1,
  10,
  4,
  0,
  3,
  100,
  4, // 1
  1,
  10,
  4,
  101,
  1,
  0,
  5, // 2
  3,
  10,
  4,
  1,
  3,
  100,
  5,
  10,
  4,
  3,
  4,
  100,
  5,
  10,
  4,
  101,
  1,
  100,
  5, // 3
  1,
  10,
  4,
  102,
  2,
  1,
  6, // 4
  5,
  10,
  4,
  102,
  2,
  1,
  6,
  10,
  4,
  2,
  3,
  0,
  6,
  10,
  4,
  3,
  4,
  0,
  6,
  10,
  4,
  1,
  2,
  0,
  6,
  10,
  4,
  100,
  0,
  3,
  4, // 5
  3,
  10,
  4,
  102,
  2,
  0,
  6,
  10,
  4,
  102,
  0,
  101,
  6,
  10,
  4,
  0,
  5,
  101,
  6, // 6
  6,
  10,
  4,
  102,
  2,
  101,
  6,
  10,
  4,
  2,
  3,
  101,
  6,
  10,
  4,
  3,
  5,
  101,
  6,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  101,
  3,
  100,
  5,
  10,
  4,
  3,
  4,
  100,
  5, // 7
  1,
  10,
  4,
  103,
  3,
  2,
  7, // 8
  3,
  10,
  4,
  100,
  0,
  103,
  7,
  10,
  4,
  100,
  4,
  0,
  7,
  10,
  4,
  0,
  2,
  103,
  7, // 9
  5,
  10,
  4,
  103,
  3,
  2,
  7,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  101,
  1,
  0,
  5, // 10
  5,
  10,
  4,
  100,
  2,
  103,
  7,
  10,
  4,
  2,
  100,
  5,
  7,
  10,
  4,
  4,
  5,
  100,
  7,
  10,
  4,
  1,
  2,
  100,
  5,
  10,
  4,
  101,
  1,
  100,
  5, // 11
  3,
  10,
  4,
  3,
  6,
  103,
  7,
  10,
  4,
  103,
  3,
  1,
  6,
  10,
  4,
  103,
  1,
  102,
  6, // 12
  6,
  10,
  4,
  100,
  4,
  6,
  7,
  10,
  4,
  100,
  6,
  103,
  7,
  10,
  4,
  103,
  1,
  102,
  6,
  10,
  4,
  100,
  0,
  103,
  6,
  10,
  4,
  100,
  4,
  0,
  6,
  10,
  4,
  0,
  1,
  103,
  6, // 13
  7,
  10,
  4,
  3,
  6,
  103,
  7,
  10,
  4,
  5,
  6,
  3,
  7,
  10,
  4,
  103,
  3,
  102,
  6,
  10,
  4,
  102,
  3,
  0,
  6,
  10,
  4,
  3,
  5,
  0,
  6,
  10,
  4,
  102,
  0,
  101,
  6,
  10,
  4,
  0,
  5,
  101,
  6, // 14
  6,
  10,
  4,
  103,
  100,
  6,
  7,
  10,
  4,
  4,
  6,
  100,
  7,
  10,
  4,
  4,
  5,
  100,
  6,
  10,
  4,
  102,
  103,
  100,
  6,
  10,
  4,
  101,
  102,
  100,
  6,
  10,
  4,
  101,
  100,
  5,
  6, // 15
  2,
  10,
  4,
  104,
  6,
  4,
  7,
  10,
  4,
  104,
  5,
  4,
  6, // 16
  6,
  10,
  4,
  5,
  6,
  3,
  7,
  10,
  4,
  104,
  6,
  5,
  7,
  10,
  4,
  100,
  5,
  3,
  7,
  10,
  4,
  104,
  5,
  100,
  7,
  10,
  4,
  3,
  5,
  0,
  6,
  10,
  4,
  0,
  3,
  100,
  5, // 17
  6,
  10,
  4,
  104,
  6,
  4,
  7,
  10,
  4,
  0,
  6,
  1,
  7,
  10,
  4,
  4,
  6,
  0,
  7,
  10,
  4,
  104,
  0,
  4,
  6,
  10,
  4,
  101,
  0,
  104,
  6,
  10,
  4,
  101,
  1,
  0,
  6, // 18
  5,
  10,
  4,
  100,
  104,
  6,
  7,
  10,
  4,
  100,
  6,
  3,
  7,
  10,
  4,
  100,
  1,
  3,
  6,
  10,
  4,
  100,
  104,
  101,
  6,
  10,
  4,
  100,
  101,
  1,
  6, // 19
  6,
  10,
  4,
  4,
  5,
  2,
  7,
  10,
  4,
  104,
  5,
  4,
  7,
  10,
  4,
  102,
  2,
  5,
  7,
  10,
  4,
  102,
  5,
  104,
  7,
  10,
  4,
  2,
  4,
  1,
  5,
  10,
  4,
  102,
  2,
  1,
  5, // 20
  9,
  10,
  4,
  3,
  5,
  2,
  7,
  10,
  4,
  100,
  5,
  3,
  7,
  10,
  4,
  104,
  5,
  100,
  7,
  10,
  4,
  104,
  102,
  5,
  7,
  10,
  4,
  2,
  5,
  102,
  7,
  10,
  4,
  0,
  3,
  100,
  5,
  10,
  4,
  2,
  3,
  0,
  5,
  10,
  4,
  1,
  2,
  0,
  5,
  10,
  4,
  102,
  2,
  1,
  5, // 21
  5,
  10,
  4,
  104,
  0,
  4,
  7,
  10,
  4,
  101,
  104,
  102,
  7,
  10,
  4,
  101,
  102,
  0,
  7,
  10,
  4,
  101,
  0,
  104,
  7,
  10,
  4,
  102,
  2,
  0,
  7, // 22
  5,
  10,
  4,
  101,
  2,
  3,
  7,
  10,
  4,
  101,
  100,
  104,
  7,
  10,
  4,
  101,
  3,
  100,
  7,
  10,
  4,
  101,
  104,
  102,
  7,
  10,
  4,
  101,
  102,
  2,
  7, // 23
  6,
  10,
  4,
  104,
  5,
  4,
  6,
  10,
  4,
  2,
  3,
  5,
  6,
  10,
  4,
  4,
  5,
  3,
  6,
  10,
  4,
  104,
  4,
  3,
  6,
  10,
  4,
  103,
  104,
  3,
  6,
  10,
  4,
  103,
  3,
  2,
  6, // 24
  5,
  10,
  4,
  103,
  104,
  100,
  6,
  10,
  4,
  104,
  5,
  100,
  6,
  10,
  4,
  103,
  100,
  0,
  6,
  10,
  4,
  100,
  5,
  0,
  6,
  10,
  4,
  0,
  2,
  103,
  6, // 25
  9,
  10,
  4,
  103,
  3,
  2,
  6,
  10,
  4,
  104,
  3,
  103,
  6,
  10,
  4,
  104,
  4,
  3,
  6,
  10,
  4,
  2,
  3,
  0,
  6,
  10,
  4,
  3,
  4,
  0,
  6,
  10,
  4,
  1,
  2,
  0,
  6,
  10,
  4,
  104,
  0,
  4,
  6,
  10,
  4,
  101,
  0,
  104,
  6,
  10,
  4,
  101,
  1,
  0,
  6, // 26
  5,
  10,
  4,
  1,
  2,
  100,
  6,
  10,
  4,
  103,
  104,
  100,
  6,
  10,
  4,
  103,
  100,
  2,
  6,
  10,
  4,
  101,
  100,
  104,
  6,
  10,
  4,
  101,
  1,
  100,
  6, // 27
  5,
  10,
  4,
  104,
  4,
  3,
  5,
  10,
  4,
  103,
  104,
  3,
  5,
  10,
  4,
  103,
  3,
  1,
  5,
  10,
  4,
  102,
  104,
  103,
  5,
  10,
  4,
  102,
  103,
  1,
  5, // 28
  5,
  10,
  4,
  103,
  104,
  100,
  5,
  10,
  4,
  103,
  100,
  0,
  5,
  10,
  4,
  0,
  1,
  103,
  5,
  10,
  4,
  102,
  104,
  103,
  5,
  10,
  4,
  102,
  103,
  1,
  5, // 29
  5,
  10,
  4,
  102,
  0,
  104,
  4,
  10,
  4,
  102,
  104,
  3,
  4,
  10,
  4,
  102,
  3,
  0,
  4,
  10,
  4,
  102,
  104,
  103,
  3,
  10,
  4,
  102,
  101,
  104,
  0, // 30
  1,
  14,
  5,
  100,
  101,
  102,
  103,
  104 // 31
};

// Index into ClipTablesData for each shape and configuration
static vtkm::UInt16 ClipTablesIndices[] = {
  // vtkm::CELL_SHAPE_VERTEX
  0,
  1,
  // vtkm::CELL_SHAPE_LINE
  5,
  6,
  11,
  16,
  // vtkm::CELL_SHAPE_TRIANGLE
  21,
  22,
  28,
  34,
  45,
  51,
  62,
  73,
  // vtkm::CELL_SHAPE_QUAD
  79,
  80,
  86,
  92,
  99,
  105,
  122,
  129,
  145,
  151,
  158,
  175,
  191,
  198,
  214,
  230,
  // vtkm::CELL_SHAPE_TETRA
  237,
  238,
  245,
  252,
  261,
  268,
  277,
  286,
  295,
  302,
  311,
  320,
  329,
  338,
  347,
  356,
  // vtkm::CELL_SHAPE_HEXAHEDRON
  363,
  364,
  371,
  378,
  397,
  404,
  435,
  454,
  497,
  504,
  523,
  554,
  597,
  616,
  659,
  702,
  739,
  746,
  765,
  796,
  839,
  876,
  931,
  992,
  1059,
  1090,
  1133,
  1194,
  1237,
  1298,
  1365,
  1456,
  1517,
  1524,
  1555,
  1574,
  1617,
  1648,
  1709,
  1752,
  1795,
  1832,
  1893,
  1948,
  2015,
  2076,
  2161,
  2228,
  2289,
  2308,
  2351,
  2394,
  2431,
  2492,
  2577,
  2650,
  2711,
  2772,
  2845,
  2930,
  2991,
  3064,
  3155,
  3246,
  3301,
  3308,
  3345,
  3376,
  3437,
  3456,
  3511,
  3554,
  3621,
  3652,
  3713,
  3774,
  3847,
  3890,
  3957,
  4000,
  4061,
  4092,
  4147,
  4208,
  4293,
  4348,
  4421,
  4506,
  4591,
  4652,
  4737,
  4846,
  4937,
  5022,
  5107,
  5198,
  5277,
  5296,
  5357,
  5400,
  5473,
  5516,
  5601,
  5638,
  5699,
  5760,
  5833,
  5918,
  6009,
  6082,
  6173,
  6234,
  6289,
  6332,
  6399,
  6442,
  6503,
  6570,
  6655,
  6716,
  6771,
  6856,
  6947,
  7038,
  7117,
  7208,
  7305,
  7384,
  7445,
  7452,
  7483,
  7520,
  7581,
  7612,
  7673,
  7734,
  7819,
  7838,
  7881,
  7936,
  8003,
  8046,
  8089,
  8156,
  8217,
  8236,
  8279,
  8340,
  8413,
  8474,
  8559,
  8632,
  8723,
  8766,
  8803,
  8888,
  8949,
  9022,
  9083,
  9174,
  9229,
  9260,
  9321,
  9376,
  9461,
  9522,
  9631,
  9716,
  9807,
  9862,
  9947,
  10020,
  10105,
  10190,
  10281,
  10366,
  10445,
  10488,
  10531,
  10598,
  10659,
  10732,
  10823,
  10914,
  10993,
  11060,
  11121,
  11206,
  11261,
  11352,
  11431,
  11528,
  11589,
  11608,
  11669,
  11730,
  11803,
  11846,
  11931,
  12004,
  12095,
  12138,
  12211,
  12296,
  12387,
  12424,
  12485,
  12546,
  12601,
  12644,
  12711,
  12796,
  12887,
  12954,
  13039,
  13130,
  13227,
  13270,
  13331,
  13422,
  13501,
  13562,
  13617,
  13696,
  13757,
  13800,
  13891,
  13958,
  14049,
  14092,
  14183,
  14244,
  14323,
  14390,
  14481,
  14566,
  14663,
  14724,
  14803,
  14858,
  14919,
  14956,
  15017,
  15078,
  15133,
  15194,
  15273,
  15328,
  15389,
  15450,
  15505,
  15584,
  15645,
  15700,
  15761,
  15822,
  // vtkm::CELL_SHAPE_WEDGE
  15833,
  15834,
  15841,
  15848,
  15867,
  15874,
  15893,
  15912,
  15931,
  15938,
  15957,
  15994,
  16037,
  16074,
  16117,
  16172,
  16203,
  16210,
  16247,
  16266,
  16309,
  16352,
  16407,
  16450,
  16487,
  16506,
  16543,
  16586,
  16623,
  16678,
  16739,
  16800,
  16837,
  16844,
  16881,
  16924,
  16979,
  16998,
  17041,
  17084,
  17121,
  17140,
  17183,
  17238,
  17299,
  17342,
  17379,
  17440,
  17477,
  17496,
  17551,
  17594,
  17655,
  17698,
  17759,
  17796,
  17833,
  17852,
  17883,
  17920,
  17957,
  17994,
  18031,
  18068,
  // vtkm::CELL_SHAPE_PYRAMID
  18077,
  18078,
  18085,
  18092,
  18111,
  18118,
  18149,
  18168,
  18205,
  18212,
  18231,
  18262,
  18293,
  18312,
  18349,
  18392,
  18429,
  18442,
  18479,
  18516,
  18547,
  18584,
  18639,
  18670,
  18701,
  18738,
  18769,
  18824,
  18855,
  18886,
  18917,
  18948
};

enum
{
  CLIP_TABLES_DATA_SIZE = sizeof(ClipTablesData) / sizeof(ClipTablesData[0]),
  CLIP_TABLES_INDICES_SIZE = sizeof(ClipTablesIndices) / sizeof(ClipTablesIndices[0]),
  MAX_CELL_EDGES = 12, // Hexahedron
  CELL_EDGES_SIZE = vtkm::NUMBER_OF_CELL_SHAPES * MAX_CELL_EDGES * 2
};

#define X 255
static vtkm::UInt8 CellEdges[CELL_EDGES_SIZE] = {
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_EMPTY_CELL
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_VERTEX
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_POLY_VERTEX
  0, 1, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_LINE
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_POLY_LINE
  0, 1, 1, 2, 2, 0, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_TRIANGLE
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_TRIANGLE_STRIP
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_POLYGON
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_PIXEL
  0, 1, 1, 2, 3, 2, 0, 3, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_QUAD
  0, 1, 1, 2, 2, 0, 0, 3, 1, 3, 2, 3,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_TETRA
  X, X, X, X, X, X, X, X, X, X, X, X,
  X, X, X, X, X, X, X, X, X, X, X, X, // vtkm::CELL_SHAPE_VOXEL
  0, 1, 1, 2, 3, 2, 0, 3, 4, 5, 5, 6,
  7, 6, 4, 7, 0, 4, 1, 5, 3, 7, 2, 6, // vtkm::CELL_SHAPE_HEXAHEDRON
  0, 1, 1, 2, 2, 0, 3, 4, 4, 5, 5, 3,
  0, 3, 1, 4, 2, 5, X, X, X, X, X, X, // vtkm::CELL_SHAPE_WEDGE
  0, 1, 1, 2, 2, 3, 3, 0, 0, 4, 1, 4,
  2, 4, 3, 4, X, X, X, X, X, X, X, X // vtkm::CELL_SHAPE_PYRAMID
};
#undef X

// index into ClipTablesIndices for each shape
VTKM_EXEC_CONSTANT
static vtkm::Int16 CellIndexLookup[vtkm::NUMBER_OF_CELL_SHAPES] = {
  -1,  //  0 = vtkm::CELL_SHAPE_EMPTY_CELL
  0,   //  1 = vtkm::CELL_SHAPE_VERTEX
  -1,  //  2 = vtkm::CELL_SHAPE_POLY_VERTEX
  2,   //  3 = vtkm::CELL_SHAPE_LINE
  -1,  //  4 = vtkm::CELL_SHAPE_POLY_LINE
  6,   //  5 = vtkm::CELL_SHAPE_TRIANGLE
  -1,  //  6 = vtkm::CELL_SHAPE_TRIANGLE_STRIP
  -1,  //  7 = vtkm::CELL_SHAPE_POLYGON
  -1,  //  8 = vtkm::CELL_SHAPE_PIXEL
  14,  //  9 = vtkm::CELL_SHAPE_QUAD
  30,  // 10 = vtkm::CELL_SHAPE_TETRA
  -1,  // 11 = vtkm::CELL_SHAPE_VOXEL
  46,  // 12 = vtkm::CELL_SHAPE_HEXAHEDRON
  302, // 13 = vtkm::CELL_SHAPE_WEDGE
  366  // 14 = vtkm::CELL_SHAPE_PYRAMID
};

class ClipTables
{
public:
  typedef vtkm::Vec<vtkm::IdComponent, 2> EdgeVec;

  template <typename DeviceAdapter>
  class DevicePortal
  {
  public:
    VTKM_EXEC
    vtkm::Id GetCaseIndex(vtkm::Id shape, vtkm::Id caseId) const
    {
      vtkm::Id index = CellIndexLookup[shape];
      return this->ClipTablesIndicesPortal.Get(index + caseId);
    }

    VTKM_EXEC
    vtkm::UInt8 ValueAt(vtkm::Id idx) const { return this->ClipTablesDataPortal.Get(idx); }

    VTKM_EXEC
    EdgeVec GetEdge(vtkm::Id shape, vtkm::Id edgeId) const
    {
      vtkm::Id index = ((shape * MAX_CELL_EDGES) + edgeId) * 2;
      vtkm::IdComponent v1 = this->CellEdgesPortal.Get(index);
      vtkm::IdComponent v2 = this->CellEdgesPortal.Get(index + 1);
      return EdgeVec(v1, v2);
    }

  private:
    typename vtkm::cont::ArrayHandle<vtkm::UInt8>::ExecutionTypes<DeviceAdapter>::PortalConst
      ClipTablesDataPortal;
    typename vtkm::cont::ArrayHandle<vtkm::UInt16>::ExecutionTypes<DeviceAdapter>::PortalConst
      ClipTablesIndicesPortal;
    typename vtkm::cont::ArrayHandle<vtkm::UInt8>::ExecutionTypes<DeviceAdapter>::PortalConst
      CellEdgesPortal;

    friend class ClipTables;
  };

  ClipTables()
    : ClipTablesDataArray(vtkm::cont::make_ArrayHandle(ClipTablesData, CLIP_TABLES_DATA_SIZE))
    , ClipTablesIndicesArray(
        vtkm::cont::make_ArrayHandle(ClipTablesIndices, CLIP_TABLES_INDICES_SIZE))
    , CellEdgesArray(vtkm::cont::make_ArrayHandle(CellEdges, CELL_EDGES_SIZE))
  {
  }

  template <typename DeviceAdapter>
  DevicePortal<DeviceAdapter> GetDevicePortal(DeviceAdapter)
  {
    DevicePortal<DeviceAdapter> portal;
    portal.ClipTablesDataPortal = this->ClipTablesDataArray.PrepareForInput(DeviceAdapter());
    portal.ClipTablesIndicesPortal = this->ClipTablesIndicesArray.PrepareForInput(DeviceAdapter());
    portal.CellEdgesPortal = this->CellEdgesArray.PrepareForInput(DeviceAdapter());
    return portal;
  }

private:
  vtkm::cont::ArrayHandle<vtkm::UInt8> ClipTablesDataArray;
  vtkm::cont::ArrayHandle<vtkm::UInt16> ClipTablesIndicesArray;
  vtkm::cont::ArrayHandle<vtkm::UInt8> CellEdgesArray;
};
}
}
} // namespace vtkm::worklet::internal

#endif // vtk_m_ClipTables_h
