/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public class LazyComboBox<E>
extends JComboBox<E> {
    public LazyComboBox(Populator<E> populator) {
        super(new LazyComboBoxModel<E>(populator));
        this.setPrototypeDisplayValue(populator.initial());
    }

    @Override
    public final void setModel(ComboBoxModel<E> comboBoxModel) {
        if (!(comboBoxModel instanceof LazyComboBoxModel)) {
            throw new IllegalArgumentException("Can only use private LazyComboBoxModel");
        }
        super.setModel(comboBoxModel);
    }

    private LazyComboBoxModel<E> _getModel() {
        return (LazyComboBoxModel)super.getModel();
    }

    @Override
    public final int getSelectedIndex() {
        return this._getModel().isPopulated() ? super.getSelectedIndex() : -1;
    }

    @Override
    public final void setSelectedItem(Object object) {
        LazyComboBoxModel<E> lazyComboBoxModel = this._getModel();
        E e = lazyComboBoxModel.getSelectedItem();
        lazyComboBoxModel.setSelectedItem(object);
        if (!Objects.equals(e, object)) {
            this.repaint();
            this.selectionChanged();
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent itemEvent) {
        super.fireItemStateChanged(itemEvent);
        if (itemEvent.getStateChange() == 1) {
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
    }

    public final void resetModel() {
        LazyComboBoxModel<E> lazyComboBoxModel = this._getModel();
        E e = lazyComboBoxModel.getSelectedItem();
        lazyComboBoxModel.reset(true);
        if (!Objects.equals(e, lazyComboBoxModel.getSelectedItem())) {
            this.repaint();
            this.selectionChanged();
        }
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension dimension = this.getPrototypeDisplayValue() != null || this._getModel().isPopulated() ? super.getPreferredSize() : new JComboBox<Object>(new Object[]{this._getModel().getSelectedItem()}).getPreferredSize();
        if (this.getPreferredWidth() >= 0) {
            dimension.width = Math.max(dimension.width, this.getPreferredWidth());
        }
        return dimension;
    }

    @Override
    public final Dimension getMinimumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = this.getPreferredWidth() < 0 ? 0 : Math.max(0, this.getPreferredWidth());
        return dimension;
    }

    @Override
    public final Dimension getMaximumSize() {
        Dimension dimension = this.getPreferredSize();
        dimension.width = this.getPreferredWidth() < 0 ? Integer.MAX_VALUE : Math.max(dimension.width, this.getPreferredWidth());
        return dimension;
    }

    protected int getPreferredWidth() {
        return -1;
    }

    private static class LazyComboBoxModel<E>
    extends AbstractListModel<E>
    implements ComboBoxModel<E> {
        private E[] items;
        private E selected;
        private final Populator<E> populator;

        LazyComboBoxModel(Populator<E> populator) {
            this.populator = populator;
            this.selected = populator.initial();
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selected = object;
        }

        @Override
        public E getSelectedItem() {
            return this.selected;
        }

        @Override
        public int getSize() {
            return this.getItems().length;
        }

        @Override
        public E getElementAt(int n) {
            return this.getItems()[n];
        }

        boolean isPopulated() {
            return this.items != null;
        }

        private E[] getItems() {
            if (this.items == null) {
                this.items = this.populator.populate();
                if (this.items == null) {
                    throw new UnsupportedOperationException("Populator returned null");
                }
                this.fireContentsChanged(this, -1, -1);
            }
            return this.items;
        }

        void reset(boolean bl) {
            this.items = null;
            if (bl && !Objects.equals(this.selected, this.populator.initial()) && !this.containsItem(this.selected)) {
                this.selected = this.populator.initial();
            }
        }

        private boolean containsItem(E e) {
            for (E e2 : this.populator.populate()) {
                if (!Objects.equals(e2, e)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class Populator<E> {
        protected abstract E initial();

        protected abstract E[] populate();
    }
}

