/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.PrintWriter;
import org.netbeans.spi.io.InputOutputProvider;

public abstract class Fold {
    static final Fold UNSUPPORTED = new Fold(){

        @Override
        public void setExpanded(boolean expanded) {
        }

        @Override
        void endFold() {
        }
    };

    private Fold() {
    }

    static <IO, OW extends PrintWriter, P, F> Fold create(InputOutputProvider<IO, OW, P, F> provider, IO io, OW writer, F fold) {
        if (fold == null) {
            return UNSUPPORTED;
        }
        return new Impl<IO, OW, P, F>(provider, io, writer, fold);
    }

    public abstract void setExpanded(boolean var1);

    abstract void endFold();

    public final void expand() {
        this.setExpanded(true);
    }

    public final void collapse() {
        this.setExpanded(false);
    }

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends Fold {
        private final InputOutputProvider<IO, OW, P, F> provider;
        private final IO io;
        private final OW writer;
        private final F fold;

        public Impl(InputOutputProvider<IO, OW, P, F> provider, IO io, OW writer, F fold) {
            this.provider = provider;
            this.io = io;
            this.writer = writer;
            this.fold = fold;
        }

        @Override
        public void setExpanded(boolean expanded) {
            this.provider.setFoldExpanded(this.io, this.writer, this.fold, expanded);
        }

        @Override
        void endFold() {
            this.provider.endFold(this.io, this.writer, this.fold);
        }
    }
}

