/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.categorization;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.xpack.core.ml.job.config.CategorizationAnalyzerConfig;

public class CategorizationAnalyzer
implements Closeable {
    private final Analyzer analyzer;
    private final boolean closeAnalyzer;

    public CategorizationAnalyzer(AnalysisRegistry analysisRegistry, Environment environment, CategorizationAnalyzerConfig categorizationAnalyzerConfig) throws IOException {
        Tuple tuple = categorizationAnalyzerConfig.toAnalyzer(analysisRegistry, environment);
        this.analyzer = (Analyzer)tuple.v1();
        this.closeAnalyzer = (Boolean)tuple.v2();
    }

    @Override
    public void close() {
        if (this.closeAnalyzer) {
            this.analyzer.close();
        }
    }

    public List<String> tokenizeField(String fieldName, String fieldValue) {
        ArrayList<String> tokens = new ArrayList<String>();
        try (TokenStream stream = this.analyzer.tokenStream(fieldName, fieldValue);){
            stream.reset();
            CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            while (stream.incrementToken()) {
                String token = term.toString();
                if (token.isEmpty()) continue;
                tokens.add(term.toString());
            }
            stream.end();
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to analyze value [" + fieldValue + "] of field [" + fieldName + "]", (Throwable)e, new Object[0]);
        }
        return tokens;
    }
}

