/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.HashSet;
import java.util.Set;
import org.gradle.internal.featurelifecycle.FeatureHandler;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingIncubatingFeatureHandler
implements FeatureHandler {
    private static final String INCUBATION_MESSAGE = "%s is an incubating feature.";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingIncubatingFeatureHandler.class);
    private final Set<String> features = new HashSet<String>();

    public void featureUsed(FeatureUsage usage) {
        if (this.features.add(usage.getMessage())) {
            LOGGER.warn(String.format(INCUBATION_MESSAGE, usage.getMessage()));
        }
    }

    public void reset() {
        this.features.clear();
    }
}

