/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.cursor.CursorFrame;
import com.sun.javafx.cursor.ImageCursorFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

class SwingCursors {
    SwingCursors() {
    }

    private static Cursor createCustomCursor(ImageCursorFrame imageCursorFrame) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        double d = imageCursorFrame.getWidth();
        double d2 = imageCursorFrame.getHeight();
        Dimension dimension = toolkit.getBestCursorSize((int)d, (int)d2);
        double d3 = imageCursorFrame.getHotspotX() * dimension.getWidth() / d;
        double d4 = imageCursorFrame.getHotspotY() * dimension.getHeight() / d2;
        Point point = new Point((int)d3, (int)d4);
        com.sun.javafx.tk.Toolkit toolkit2 = com.sun.javafx.tk.Toolkit.getToolkit();
        BufferedImage bufferedImage = (BufferedImage)toolkit2.toExternalImage(imageCursorFrame.getPlatformImage(), BufferedImage.class);
        return toolkit.createCustomCursor(bufferedImage, point, null);
    }

    static Cursor embedCursorToCursor(CursorFrame cursorFrame) {
        switch (cursorFrame.getCursorType()) {
            case DEFAULT: {
                return Cursor.getPredefinedCursor(0);
            }
            case CROSSHAIR: {
                return Cursor.getPredefinedCursor(1);
            }
            case TEXT: {
                return Cursor.getPredefinedCursor(2);
            }
            case WAIT: {
                return Cursor.getPredefinedCursor(3);
            }
            case SW_RESIZE: {
                return Cursor.getPredefinedCursor(4);
            }
            case SE_RESIZE: {
                return Cursor.getPredefinedCursor(5);
            }
            case NW_RESIZE: {
                return Cursor.getPredefinedCursor(6);
            }
            case NE_RESIZE: {
                return Cursor.getPredefinedCursor(7);
            }
            case N_RESIZE: {
                return Cursor.getPredefinedCursor(8);
            }
            case S_RESIZE: {
                return Cursor.getPredefinedCursor(9);
            }
            case W_RESIZE: {
                return Cursor.getPredefinedCursor(10);
            }
            case E_RESIZE: {
                return Cursor.getPredefinedCursor(11);
            }
            case OPEN_HAND: 
            case CLOSED_HAND: 
            case HAND: {
                return Cursor.getPredefinedCursor(12);
            }
            case MOVE: {
                return Cursor.getPredefinedCursor(13);
            }
            case DISAPPEAR: 
            case H_RESIZE: 
            case V_RESIZE: {
                return Cursor.getPredefinedCursor(0);
            }
            case NONE: {
                return null;
            }
            case IMAGE: {
                return SwingCursors.createCustomCursor((ImageCursorFrame)cursorFrame);
            }
        }
        return Cursor.getPredefinedCursor(0);
    }
}

