// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Registry_h__
#define __IceGrid_Registry_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <IceGrid/Exception.h>
#include <IceGrid/Session.h>
#include <IceGrid/Admin.h>
#include <Ice/Locator.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class Query;
class QueryPrx;
class Registry;
class RegistryPrx;
class Locator;
class LocatorPrx;

}

namespace IceGrid
{

enum class LoadSample : unsigned char
{
    LoadSample1,
    LoadSample5,
    LoadSample15
};

}

namespace IceGrid
{

class ICEGRID_API Query : public virtual ::Ice::Object
{
public:

    using ProxyType = QueryPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> findObjectById(::Ice::Identity, const ::Ice::Current&) const = 0;
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> findObjectByType(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_findObjectByType(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> findObjectByTypeOnLeastLoadedNode(::std::string, ::IceGrid::LoadSample, const ::Ice::Current&) const = 0;
    bool _iceD_findObjectByTypeOnLeastLoadedNode(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectProxySeq findAllObjectsByType(::std::string, const ::Ice::Current&) const = 0;
    bool _iceD_findAllObjectsByType(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectProxySeq findAllReplicas(::std::shared_ptr<::Ice::ObjectPrx>, const ::Ice::Current&) const = 0;
    bool _iceD_findAllReplicas(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API Registry : public virtual ::Ice::Object
{
public:

    using ProxyType = RegistryPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::IceGrid::SessionPrx> createSession(::std::string, ::std::string, const ::Ice::Current&) = 0;
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::AdminSessionPrx> createAdminSession(::std::string, ::std::string, const ::Ice::Current&) = 0;
    bool _iceD_createAdminSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::SessionPrx> createSessionFromSecureConnection(const ::Ice::Current&) = 0;
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::IceGrid::AdminSessionPrx> createAdminSessionFromSecureConnection(const ::Ice::Current&) = 0;
    bool _iceD_createAdminSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual int getSessionTimeout(const ::Ice::Current&) const = 0;
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual int getACMTimeout(const ::Ice::Current&) const = 0;
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class ICEGRID_API Locator : public virtual ::Ice::Locator
{
public:

    using ProxyType = LocatorPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::IceGrid::RegistryPrx> getLocalRegistry(const ::Ice::Current&) const = 0;
    bool _iceD_getLocalRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::std::shared_ptr<::IceGrid::QueryPrx> getLocalQuery(const ::Ice::Current&) const = 0;
    bool _iceD_getLocalQuery(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) QueryPrx : public virtual ::Ice::Proxy<QueryPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::Ice::ObjectPrx> findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::QueryPrx::_iceI_findObjectById, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto findObjectByIdAsync(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::QueryPrx::_iceI_findObjectById, iceP_id, context);
    }

    ::std::function<void()>
    findObjectByIdAsync(const ::Ice::Identity& iceP_id,
                        ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::QueryPrx::_iceI_findObjectById, iceP_id, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_findObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Identity&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> findObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::QueryPrx::_iceI_findObjectByType, iceP_type, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto findObjectByTypeAsync(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::QueryPrx::_iceI_findObjectByType, iceP_type, context);
    }

    ::std::function<void()>
    findObjectByTypeAsync(const ::std::string& iceP_type,
                          ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::QueryPrx::_iceI_findObjectByType, iceP_type, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_findObjectByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::Ice::ObjectPrx> findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &IceGrid::QueryPrx::_iceI_findObjectByTypeOnLeastLoadedNode, iceP_type, iceP_sample, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto findObjectByTypeOnLeastLoadedNodeAsync(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &IceGrid::QueryPrx::_iceI_findObjectByTypeOnLeastLoadedNode, iceP_type, iceP_sample, context);
    }

    ::std::function<void()>
    findObjectByTypeOnLeastLoadedNodeAsync(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample,
                                           ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                           ::std::function<void(bool)> sent = nullptr,
                                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(response, ex, sent, this, &IceGrid::QueryPrx::_iceI_findObjectByTypeOnLeastLoadedNode, iceP_type, iceP_sample, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_findObjectByTypeOnLeastLoadedNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, ::IceGrid::LoadSample, const ::Ice::Context&);

    ::Ice::ObjectProxySeq findAllObjectsByType(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq>(true, this, &IceGrid::QueryPrx::_iceI_findAllObjectsByType, iceP_type, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto findAllObjectsByTypeAsync(const ::std::string& iceP_type, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ObjectProxySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq, P>(false, this, &IceGrid::QueryPrx::_iceI_findAllObjectsByType, iceP_type, context);
    }

    ::std::function<void()>
    findAllObjectsByTypeAsync(const ::std::string& iceP_type,
                              ::std::function<void(::Ice::ObjectProxySeq)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::ObjectProxySeq>(response, ex, sent, this, &IceGrid::QueryPrx::_iceI_findAllObjectsByType, iceP_type, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_findAllObjectsByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ObjectProxySeq>>&, const ::std::string&, const ::Ice::Context&);

    ::Ice::ObjectProxySeq findAllReplicas(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq>(true, this, &IceGrid::QueryPrx::_iceI_findAllReplicas, iceP_proxy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto findAllReplicasAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::ObjectProxySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::ObjectProxySeq, P>(false, this, &IceGrid::QueryPrx::_iceI_findAllReplicas, iceP_proxy, context);
    }

    ::std::function<void()>
    findAllReplicasAsync(const ::std::shared_ptr<::Ice::ObjectPrx>& iceP_proxy,
                         ::std::function<void(::Ice::ObjectProxySeq)> response,
                         ::std::function<void(::std::exception_ptr)> ex = nullptr,
                         ::std::function<void(bool)> sent = nullptr,
                         const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::ObjectProxySeq>(response, ex, sent, this, &IceGrid::QueryPrx::_iceI_findAllReplicas, iceP_proxy, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_findAllReplicas(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::ObjectProxySeq>>&, const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    QueryPrx() = default;
    friend ::std::shared_ptr<QueryPrx> IceInternal::createProxy<QueryPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) RegistryPrx : public virtual ::Ice::Proxy<RegistryPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::IceGrid::SessionPrx> createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(true, this, &IceGrid::RegistryPrx::_iceI_createSession, iceP_userId, iceP_password, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createSessionAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>, P>(false, this, &IceGrid::RegistryPrx::_iceI_createSession, iceP_userId, iceP_password, context);
    }

    ::std::function<void()>
    createSessionAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password,
                       ::std::function<void(::std::shared_ptr<::IceGrid::SessionPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(response, ex, sent, this, &IceGrid::RegistryPrx::_iceI_createSession, iceP_userId, iceP_password, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_createSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::SessionPrx>>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::AdminSessionPrx> createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(true, this, &IceGrid::RegistryPrx::_iceI_createAdminSession, iceP_userId, iceP_password, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createAdminSessionAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>, P>(false, this, &IceGrid::RegistryPrx::_iceI_createAdminSession, iceP_userId, iceP_password, context);
    }

    ::std::function<void()>
    createAdminSessionAsync(const ::std::string& iceP_userId, const ::std::string& iceP_password,
                            ::std::function<void(::std::shared_ptr<::IceGrid::AdminSessionPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(response, ex, sent, this, &IceGrid::RegistryPrx::_iceI_createAdminSession, iceP_userId, iceP_password, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_createAdminSession(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::SessionPrx> createSessionFromSecureConnection(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(true, this, &IceGrid::RegistryPrx::_iceI_createSessionFromSecureConnection, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createSessionFromSecureConnectionAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>, P>(false, this, &IceGrid::RegistryPrx::_iceI_createSessionFromSecureConnection, context);
    }

    ::std::function<void()>
    createSessionFromSecureConnectionAsync(::std::function<void(::std::shared_ptr<::IceGrid::SessionPrx>)> response,
                                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                           ::std::function<void(bool)> sent = nullptr,
                                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::SessionPrx>>(response, ex, sent, this, &IceGrid::RegistryPrx::_iceI_createSessionFromSecureConnection, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_createSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::SessionPrx>>>&, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::AdminSessionPrx> createAdminSessionFromSecureConnection(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(true, this, &IceGrid::RegistryPrx::_iceI_createAdminSessionFromSecureConnection, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createAdminSessionFromSecureConnectionAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>, P>(false, this, &IceGrid::RegistryPrx::_iceI_createAdminSessionFromSecureConnection, context);
    }

    ::std::function<void()>
    createAdminSessionFromSecureConnectionAsync(::std::function<void(::std::shared_ptr<::IceGrid::AdminSessionPrx>)> response,
                                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                                ::std::function<void(bool)> sent = nullptr,
                                                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::AdminSessionPrx>>(response, ex, sent, this, &IceGrid::RegistryPrx::_iceI_createAdminSessionFromSecureConnection, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_createAdminSessionFromSecureConnection(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::AdminSessionPrx>>>&, const ::Ice::Context&);

    int getSessionTimeout(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &IceGrid::RegistryPrx::_iceI_getSessionTimeout, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getSessionTimeoutAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &IceGrid::RegistryPrx::_iceI_getSessionTimeout, context);
    }

    ::std::function<void()>
    getSessionTimeoutAsync(::std::function<void(int)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &IceGrid::RegistryPrx::_iceI_getSessionTimeout, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);

    int getACMTimeout(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &IceGrid::RegistryPrx::_iceI_getACMTimeout, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getACMTimeoutAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &IceGrid::RegistryPrx::_iceI_getACMTimeout, context);
    }

    ::std::function<void()>
    getACMTimeoutAsync(::std::function<void(int)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &IceGrid::RegistryPrx::_iceI_getACMTimeout, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getACMTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    RegistryPrx() = default;
    friend ::std::shared_ptr<RegistryPrx> IceInternal::createProxy<RegistryPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(ICEGRID_API) LocatorPrx : public virtual ::Ice::Proxy<LocatorPrx, ::Ice::LocatorPrx>
{
public:

    ::std::shared_ptr<::IceGrid::RegistryPrx> getLocalRegistry(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::RegistryPrx>>(true, this, &IceGrid::LocatorPrx::_iceI_getLocalRegistry, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getLocalRegistryAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::RegistryPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::RegistryPrx>, P>(false, this, &IceGrid::LocatorPrx::_iceI_getLocalRegistry, context);
    }

    ::std::function<void()>
    getLocalRegistryAsync(::std::function<void(::std::shared_ptr<::IceGrid::RegistryPrx>)> response,
                          ::std::function<void(::std::exception_ptr)> ex = nullptr,
                          ::std::function<void(bool)> sent = nullptr,
                          const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::RegistryPrx>>(response, ex, sent, this, &IceGrid::LocatorPrx::_iceI_getLocalRegistry, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getLocalRegistry(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::RegistryPrx>>>&, const ::Ice::Context&);

    ::std::shared_ptr<::IceGrid::QueryPrx> getLocalQuery(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::QueryPrx>>(true, this, &IceGrid::LocatorPrx::_iceI_getLocalQuery, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getLocalQueryAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceGrid::QueryPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceGrid::QueryPrx>, P>(false, this, &IceGrid::LocatorPrx::_iceI_getLocalQuery, context);
    }

    ::std::function<void()>
    getLocalQueryAsync(::std::function<void(::std::shared_ptr<::IceGrid::QueryPrx>)> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceGrid::QueryPrx>>(response, ex, sent, this, &IceGrid::LocatorPrx::_iceI_getLocalQuery, context);
    }

    ICE_MEMBER(ICEGRID_API) void _iceI_getLocalQuery(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceGrid::QueryPrx>>>&, const ::Ice::Context&);

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    LocatorPrx() = default;
    friend ::std::shared_ptr<LocatorPrx> IceInternal::createProxy<LocatorPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::LoadSample>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 2;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

}

namespace IceGrid
{

using QueryPtr = ::std::shared_ptr<Query>;
using QueryPrxPtr = ::std::shared_ptr<QueryPrx>;

using RegistryPtr = ::std::shared_ptr<Registry>;
using RegistryPrxPtr = ::std::shared_ptr<RegistryPrx>;

using LocatorPtr = ::std::shared_ptr<Locator>;
using LocatorPrxPtr = ::std::shared_ptr<LocatorPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class Query;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Query>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::Query*);

class Registry;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Registry>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::Registry*);

class Locator;
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Locator>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceGrid::Locator*);

}

}

namespace IceGrid
{

class Query;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::Query*);
typedef ::IceInternal::Handle< ::IceGrid::Query> QueryPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Query> QueryPrx;
typedef QueryPrx QueryPrxPtr;
ICEGRID_API void _icePatchObjectPtr(QueryPtr&, const ::Ice::ObjectPtr&);

class Registry;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::Registry*);
typedef ::IceInternal::Handle< ::IceGrid::Registry> RegistryPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Registry> RegistryPrx;
typedef RegistryPrx RegistryPrxPtr;
ICEGRID_API void _icePatchObjectPtr(RegistryPtr&, const ::Ice::ObjectPtr&);

class Locator;
ICEGRID_API ::Ice::Object* upCast(::IceGrid::Locator*);
typedef ::IceInternal::Handle< ::IceGrid::Locator> LocatorPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Locator> LocatorPrx;
typedef LocatorPrx LocatorPrxPtr;
ICEGRID_API void _icePatchObjectPtr(LocatorPtr&, const ::Ice::ObjectPtr&);

}

namespace IceGrid
{

enum LoadSample
{
    LoadSample1,
    LoadSample5,
    LoadSample15
};

}

namespace IceAsync
{

}

namespace IceGrid
{

class Callback_Query_findObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findObjectById_Base> Callback_Query_findObjectByIdPtr;

class Callback_Query_findObjectByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findObjectByType_Base> Callback_Query_findObjectByTypePtr;

class Callback_Query_findObjectByTypeOnLeastLoadedNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findObjectByTypeOnLeastLoadedNode_Base> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr;

class Callback_Query_findAllObjectsByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findAllObjectsByType_Base> Callback_Query_findAllObjectsByTypePtr;

class Callback_Query_findAllReplicas_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Query_findAllReplicas_Base> Callback_Query_findAllReplicasPtr;

class Callback_Registry_createSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createSession_Base> Callback_Registry_createSessionPtr;

class Callback_Registry_createAdminSession_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createAdminSession_Base> Callback_Registry_createAdminSessionPtr;

class Callback_Registry_createSessionFromSecureConnection_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createSessionFromSecureConnection_Base> Callback_Registry_createSessionFromSecureConnectionPtr;

class Callback_Registry_createAdminSessionFromSecureConnection_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_createAdminSessionFromSecureConnection_Base> Callback_Registry_createAdminSessionFromSecureConnectionPtr;

class Callback_Registry_getSessionTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_getSessionTimeout_Base> Callback_Registry_getSessionTimeoutPtr;

class Callback_Registry_getACMTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Registry_getACMTimeout_Base> Callback_Registry_getACMTimeoutPtr;

class Callback_Locator_getLocalRegistry_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_getLocalRegistry_Base> Callback_Locator_getLocalRegistryPtr;

class Callback_Locator_getLocalQuery_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Locator_getLocalQuery_Base> Callback_Locator_getLocalQueryPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) Query : public virtual ::Ice::Proxy<Query, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectById(_iceI_begin_findObjectById(iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectById(iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::IceGrid::Callback_Query_findObjectByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectById(const ::Ice::Identity& iceP_id, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findObjectByIdPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectById(iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_findObjectById(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectById(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx findObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectByType(_iceI_begin_findObjectByType(iceP_type, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectByType(iceP_type, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& iceP_type, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(iceP_type, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& iceP_type, const ::IceGrid::Callback_Query_findObjectByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findObjectByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByType(iceP_type, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_findObjectByType(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findObjectByTypeOnLeastLoadedNode(_iceI_begin_findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::IceGrid::Callback_Query_findObjectByTypeOnLeastLoadedNodePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findObjectByTypeOnLeastLoadedNode(const ::std::string& iceP_type, ::IceGrid::LoadSample iceP_sample, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findObjectByTypeOnLeastLoadedNodePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_findObjectByTypeOnLeastLoadedNode(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findObjectByTypeOnLeastLoadedNode(const ::std::string&, ::IceGrid::LoadSample, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq findAllObjectsByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findAllObjectsByType(_iceI_begin_findAllObjectsByType(iceP_type, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& iceP_type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findAllObjectsByType(iceP_type, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& iceP_type, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(iceP_type, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& iceP_type, const ::IceGrid::Callback_Query_findAllObjectsByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(iceP_type, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAllObjectsByType(const ::std::string& iceP_type, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findAllObjectsByTypePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllObjectsByType(iceP_type, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq end_findAllObjectsByType(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findAllObjectsByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq findAllReplicas(const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_findAllReplicas(_iceI_begin_findAllReplicas(iceP_proxy, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_findAllReplicas(iceP_proxy, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(iceP_proxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(iceP_proxy, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& iceP_proxy, const ::IceGrid::Callback_Query_findAllReplicasPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(iceP_proxy, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_findAllReplicas(const ::Ice::ObjectPrx& iceP_proxy, const ::Ice::Context& context, const ::IceGrid::Callback_Query_findAllReplicasPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_findAllReplicas(iceP_proxy, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectProxySeq end_findAllReplicas(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_findAllReplicas(const ::Ice::ObjectPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) Registry : public virtual ::Ice::Proxy<Registry, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSession(_iceI_begin_createSession(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::IceGrid::Callback_Registry_createSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSession(iceP_userId, iceP_password, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx end_createSession(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createSession(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createAdminSession(_iceI_begin_createAdminSession(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createAdminSession(iceP_userId, iceP_password, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(iceP_userId, iceP_password, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::IceGrid::Callback_Registry_createAdminSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(iceP_userId, iceP_password, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createAdminSession(const ::std::string& iceP_userId, const ::std::string& iceP_password, const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createAdminSessionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSession(iceP_userId, iceP_password, context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx end_createAdminSession(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createAdminSession(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createSessionFromSecureConnection(_iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::IceGrid::Callback_Registry_createSessionFromSecureConnectionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createSessionFromSecureConnection(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createSessionFromSecureConnectionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createSessionFromSecureConnection(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::SessionPrx end_createSessionFromSecureConnection(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createSessionFromSecureConnection(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx createAdminSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_createAdminSessionFromSecureConnection(_iceI_begin_createAdminSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::IceGrid::Callback_Registry_createAdminSessionFromSecureConnectionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_createAdminSessionFromSecureConnection(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_createAdminSessionFromSecureConnectionPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_createAdminSessionFromSecureConnection(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::AdminSessionPrx end_createAdminSessionFromSecureConnection(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_createAdminSessionFromSecureConnection(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::Int getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSessionTimeout(_iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::IceGrid::Callback_Registry_getSessionTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_getSessionTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getSessionTimeout(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getSessionTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::Ice::Int getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getACMTimeout(_iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getACMTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::IceGrid::Callback_Registry_getACMTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getACMTimeout(const ::Ice::Context& context, const ::IceGrid::Callback_Registry_getACMTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getACMTimeout(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::Ice::Int end_getACMTimeout(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getACMTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICEGRID_API) Locator : public virtual ::Ice::Proxy<Locator, ::IceProxy::Ice::Locator>
{
public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryPrx getLocalRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLocalRegistry(_iceI_begin_getLocalRegistry(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLocalRegistry(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::IceGrid::Callback_Locator_getLocalRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocalRegistry(const ::Ice::Context& context, const ::IceGrid::Callback_Locator_getLocalRegistryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalRegistry(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::RegistryPrx end_getLocalRegistry(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getLocalRegistry(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) ::IceGrid::QueryPrx getLocalQuery(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLocalQuery(_iceI_begin_getLocalQuery(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLocalQuery(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::IceGrid::Callback_Locator_getLocalQueryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getLocalQuery(const ::Ice::Context& context, const ::IceGrid::Callback_Locator_getLocalQueryPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLocalQuery(context, del, cookie);
    }

    ICE_MEMBER(ICEGRID_API) ::IceGrid::QueryPrx end_getLocalQuery(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_getLocalQuery(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceGrid
{

class ICEGRID_API Query : public virtual ::Ice::Object
{
public:

    typedef QueryPrx ProxyType;
    typedef QueryPtr PointerType;

    virtual ~Query();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::Ice::ObjectPrx findObjectById(const ::Ice::Identity&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_findObjectById(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx findObjectByType(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_findObjectByType(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectPrx findObjectByTypeOnLeastLoadedNode(const ::std::string&, ::IceGrid::LoadSample, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_findObjectByTypeOnLeastLoadedNode(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectProxySeq findAllObjectsByType(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_findAllObjectsByType(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::ObjectProxySeq findAllReplicas(const ::Ice::ObjectPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_findAllReplicas(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Query& lhs, const Query& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Query& lhs, const Query& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API Registry : public virtual ::Ice::Object
{
public:

    typedef RegistryPrx ProxyType;
    typedef RegistryPtr PointerType;

    virtual ~Registry();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::IceGrid::SessionPrx createSession(const ::std::string&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_createSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::AdminSessionPrx createAdminSession(const ::std::string&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_createAdminSession(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::SessionPrx createSessionFromSecureConnection(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_createSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceGrid::AdminSessionPrx createAdminSessionFromSecureConnection(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_createAdminSessionFromSecureConnection(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::Int getSessionTimeout(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::Ice::Int getACMTimeout(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getACMTimeout(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Registry& lhs, const Registry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Registry& lhs, const Registry& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICEGRID_API Locator : virtual public ::Ice::Locator
{
public:

    typedef LocatorPrx ProxyType;
    typedef LocatorPtr PointerType;

    virtual ~Locator();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::IceGrid::RegistryPrx getLocalRegistry(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getLocalRegistry(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual ::IceGrid::QueryPrx getLocalQuery(const ::Ice::Current& = ::Ice::emptyCurrent) const = 0;
    bool _iceD_getLocalQuery(::IceInternal::Incoming&, const ::Ice::Current&) const;

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Locator& lhs, const Locator& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::IceGrid::LoadSample>
{
    static const StreamHelperCategory helper = StreamHelperCategoryEnum;
    static const int minValue = 0;
    static const int maxValue = 2;
    static const int minWireSize = 1;
    static const bool fixedLength = false;
};

}

namespace IceGrid
{

template<class T>
class CallbackNC_Query_findObjectById : public Callback_Query_findObjectById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Query_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectById<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectById<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Query_findObjectById : public Callback_Query_findObjectById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Query_findObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Query_findObjectByIdPtr
newCallback_Query_findObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectById<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Query_findObjectByType : public Callback_Query_findObjectByType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Query_findObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByType<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByType<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Query_findObjectByType : public Callback_Query_findObjectByType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Query_findObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Query_findObjectByTypePtr
newCallback_Query_findObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Query_findObjectByTypeOnLeastLoadedNode : public Callback_Query_findObjectByTypeOnLeastLoadedNode_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Query_findObjectByTypeOnLeastLoadedNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByTypeOnLeastLoadedNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByTypeOnLeastLoadedNode<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findObjectByTypeOnLeastLoadedNode<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Query_findObjectByTypeOnLeastLoadedNode : public Callback_Query_findObjectByTypeOnLeastLoadedNode_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Query_findObjectByTypeOnLeastLoadedNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_findObjectByTypeOnLeastLoadedNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByTypeOnLeastLoadedNode<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Query_findObjectByTypeOnLeastLoadedNodePtr
newCallback_Query_findObjectByTypeOnLeastLoadedNode(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findObjectByTypeOnLeastLoadedNode<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Query_findAllObjectsByType : public Callback_Query_findAllObjectsByType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&);

    CallbackNC_Query_findAllObjectsByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllObjectsByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllObjectsByType<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllObjectsByType<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Query_findAllObjectsByType : public Callback_Query_findAllObjectsByType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&, const CT&);

    Callback_Query_findAllObjectsByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllObjectsByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllObjectsByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Query_findAllObjectsByTypePtr
newCallback_Query_findAllObjectsByType(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllObjectsByType<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Query_findAllReplicas : public Callback_Query_findAllReplicas_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&);

    CallbackNC_Query_findAllReplicas(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllReplicas(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllReplicas<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Query_findAllReplicas<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Query_findAllReplicas : public Callback_Query_findAllReplicas_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectProxySeq&, const CT&);

    Callback_Query_findAllReplicas(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::QueryPrx proxy = ::IceGrid::QueryPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectProxySeq ret;
        try
        {
            ret = proxy->end_findAllReplicas(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllReplicas<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Query_findAllReplicasPtr
newCallback_Query_findAllReplicas(T* instance, void (T::*cb)(const ::Ice::ObjectProxySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Query_findAllReplicas<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Registry_createSession : public Callback_Registry_createSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::SessionPrx&);

    CallbackNC_Registry_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSession<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(T* instance, void (T::*cb)(const ::IceGrid::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSession<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Registry_createSession : public Callback_Registry_createSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::SessionPrx&, const CT&);

    Callback_Registry_createSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::SessionPrx ret;
        try
        {
            ret = proxy->end_createSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Registry_createSessionPtr
newCallback_Registry_createSession(T* instance, void (T::*cb)(const ::IceGrid::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Registry_createAdminSession : public Callback_Registry_createAdminSession_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::AdminSessionPrx&);

    CallbackNC_Registry_createAdminSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSession<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(T* instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSession<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Registry_createAdminSession : public Callback_Registry_createAdminSession_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::AdminSessionPrx&, const CT&);

    Callback_Registry_createAdminSession(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSession(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Registry_createAdminSessionPtr
newCallback_Registry_createAdminSession(T* instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSession<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Registry_createSessionFromSecureConnection : public Callback_Registry_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::SessionPrx&);

    CallbackNC_Registry_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(T* instance, void (T::*cb)(const ::IceGrid::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Registry_createSessionFromSecureConnection : public Callback_Registry_createSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::SessionPrx&, const CT&);

    Callback_Registry_createSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::SessionPrx ret;
        try
        {
            ret = proxy->end_createSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Registry_createSessionFromSecureConnectionPtr
newCallback_Registry_createSessionFromSecureConnection(T* instance, void (T::*cb)(const ::IceGrid::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Registry_createAdminSessionFromSecureConnection : public Callback_Registry_createAdminSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::AdminSessionPrx&);

    CallbackNC_Registry_createAdminSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(T* instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_createAdminSessionFromSecureConnection<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Registry_createAdminSessionFromSecureConnection : public Callback_Registry_createAdminSessionFromSecureConnection_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::AdminSessionPrx&, const CT&);

    Callback_Registry_createAdminSessionFromSecureConnection(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::IceGrid::AdminSessionPrx ret;
        try
        {
            ret = proxy->end_createAdminSessionFromSecureConnection(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Registry_createAdminSessionFromSecureConnectionPtr
newCallback_Registry_createAdminSessionFromSecureConnection(T* instance, void (T::*cb)(const ::IceGrid::AdminSessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_createAdminSessionFromSecureConnection<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Registry_getSessionTimeout : public Callback_Registry_getSessionTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Registry_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Registry_getSessionTimeout : public Callback_Registry_getSessionTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Registry_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Registry_getSessionTimeoutPtr
newCallback_Registry_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Registry_getACMTimeout : public Callback_Registry_getACMTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_Registry_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getACMTimeout<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Registry_getACMTimeout<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Registry_getACMTimeout : public Callback_Registry_getACMTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_Registry_getACMTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::RegistryPrx proxy = ::IceGrid::RegistryPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getACMTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Registry_getACMTimeoutPtr
newCallback_Registry_getACMTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Registry_getACMTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Locator_getLocalRegistry : public Callback_Locator_getLocalRegistry_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::RegistryPrx&);

    CallbackNC_Locator_getLocalRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::LocatorPrx proxy = ::IceGrid::LocatorPrx::uncheckedCast(result->getProxy());
        ::IceGrid::RegistryPrx ret;
        try
        {
            ret = proxy->end_getLocalRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::RegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalRegistry<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(T* instance, void (T::*cb)(const ::IceGrid::RegistryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalRegistry<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Locator_getLocalRegistry : public Callback_Locator_getLocalRegistry_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::RegistryPrx&, const CT&);

    Callback_Locator_getLocalRegistry(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::LocatorPrx proxy = ::IceGrid::LocatorPrx::uncheckedCast(result->getProxy());
        ::IceGrid::RegistryPrx ret;
        try
        {
            ret = proxy->end_getLocalRegistry(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::RegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Locator_getLocalRegistryPtr
newCallback_Locator_getLocalRegistry(T* instance, void (T::*cb)(const ::IceGrid::RegistryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalRegistry<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_Locator_getLocalQuery : public Callback_Locator_getLocalQuery_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceGrid::QueryPrx&);

    CallbackNC_Locator_getLocalQuery(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::LocatorPrx proxy = ::IceGrid::LocatorPrx::uncheckedCast(result->getProxy());
        ::IceGrid::QueryPrx ret;
        try
        {
            ret = proxy->end_getLocalQuery(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::QueryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalQuery<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(T* instance, void (T::*cb)(const ::IceGrid::QueryPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Locator_getLocalQuery<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_Locator_getLocalQuery : public Callback_Locator_getLocalQuery_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceGrid::QueryPrx&, const CT&);

    Callback_Locator_getLocalQuery(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceGrid::LocatorPrx proxy = ::IceGrid::LocatorPrx::uncheckedCast(result->getProxy());
        ::IceGrid::QueryPrx ret;
        try
        {
            ret = proxy->end_getLocalQuery(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceGrid::QueryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalQuery<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Locator_getLocalQueryPtr
newCallback_Locator_getLocalQuery(T* instance, void (T::*cb)(const ::IceGrid::QueryPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Locator_getLocalQuery<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
