/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.math.BinaryNumericProcessor;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.Processor;

public class BinaryMathProcessor
extends BinaryNumericProcessor<BinaryMathOperation> {
    public static final String NAME = "mb";

    public BinaryMathProcessor(Processor left, Processor right, BinaryMathOperation operation) {
        super(left, right, operation);
    }

    public BinaryMathProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryMathOperation)i.readEnum(BinaryMathOperation.class));
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
        out.writeEnum((Enum)((BinaryMathOperation)this.operation()));
    }

    public String getWriteableName() {
        return NAME;
    }

    public static enum BinaryMathOperation implements BiFunction<Number, Number, Number>
    {
        ATAN2((l, r) -> Math.atan2(l.doubleValue(), r.doubleValue())),
        POWER((l, r) -> Math.pow(l.doubleValue(), r.doubleValue()));

        private final BiFunction<Number, Number, Number> process;

        private BinaryMathOperation(BiFunction<Number, Number, Number> process) {
            this.process = process;
        }

        @Override
        public final Number apply(Number left, Number right) {
            return this.process.apply(left, right);
        }
    }
}

