/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.charts.xy;

import java.awt.Color;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;

public class ProfilerXYItemPainter
extends SynchronousXYItemPainter {
    public static ProfilerXYItemPainter absolutePainter(float f, Color color, Color color2) {
        return new ProfilerXYItemPainter(f, color, color2, 0, 0);
    }

    public static ProfilerXYItemPainter relativePainter(float f, Color color, Color color2, int n) {
        return new ProfilerXYItemPainter(f, color, color2, 1, n);
    }

    public ProfilerXYItemPainter(float f, Color color, Color color2, int n, int n2) {
        super(f, color, color2, n, n2);
    }

    public boolean supportsHovering(ChartItem chartItem) {
        return true;
    }

    public LongRect getSelectionBounds(ItemSelection itemSelection, ChartContext chartContext) {
        XYItemSelection xYItemSelection = (XYItemSelection)itemSelection;
        XYItem xYItem = xYItemSelection.getItem();
        int n = xYItemSelection.getValueIndex();
        if (n == -1 || n >= xYItem.getValuesCount()) {
            return new LongRect(0L, 0L, (long)chartContext.getViewportWidth(), (long)chartContext.getViewportHeight());
        }
        return this.getViewBounds(xYItem, new int[]{xYItemSelection.getValueIndex()}, chartContext);
    }

    public ItemSelection getClosestSelection(ChartItem chartItem, int n, int n2, ChartContext chartContext) {
        SynchronousXYChartContext synchronousXYChartContext = (SynchronousXYChartContext)chartContext;
        int n3 = synchronousXYChartContext.getNearestTimestampIndex(n, n2);
        if (n3 == -1) {
            return null;
        }
        SynchronousXYItem synchronousXYItem = (SynchronousXYItem)chartItem;
        return new XYItemSelection.Default((XYItem)synchronousXYItem, n3, Integer.MAX_VALUE);
    }

    private LongRect getViewBounds(XYItem xYItem, int[] nArray, ChartContext chartContext) {
        LongRect longRect = new LongRect();
        if (nArray == null) {
            LongRect.set((LongRect)longRect, (LongRect)xYItem.getBounds());
        } else {
            boolean bl = true;
            for (int n : nArray) {
                if (n == -1) continue;
                long l = xYItem.getXValue(n);
                long l2 = xYItem.getYValue(n);
                if (bl) {
                    LongRect.set((LongRect)longRect, (long)l, (long)l2, (long)0L, (long)0L);
                    bl = false;
                    continue;
                }
                LongRect.add((LongRect)longRect, (long)l, (long)l2);
            }
        }
        if (this.type == 1) {
            return this.getViewBoundsRelative(longRect, xYItem, chartContext);
        }
        LongRect longRect2 = chartContext.getViewRect(longRect);
        LongRect.addBorder((LongRect)longRect2, (long)this.lineWidth);
        return longRect2;
    }

    private LongRect getViewBoundsRelative(LongRect longRect, XYItem xYItem, ChartContext chartContext) {
        long l;
        LongRect longRect2 = xYItem.getBounds();
        double d = ProfilerXYItemPainter.getItemValueFactor(chartContext, this.maxValueOffset, longRect2.height);
        double d2 = (double)chartContext.getDataOffsetY() + d * (double)(longRect.y - longRect2.y);
        double d3 = (double)chartContext.getDataOffsetY() + d * (double)(longRect.y + longRect.height - longRect2.y);
        long l2 = (long)Math.ceil(chartContext.getViewX((double)longRect.x));
        long l3 = (long)Math.ceil(chartContext.getViewWidth((double)longRect.width));
        if (chartContext.isRightBased()) {
            l2 -= l3;
        }
        long l4 = (long)Math.ceil(chartContext.getViewY(d2));
        long l5 = (long)Math.ceil(chartContext.getViewY(d3));
        long l6 = l = chartContext.isBottomBased() ? l4 - l5 : l5 - l4;
        if (!chartContext.isBottomBased()) {
            l5 -= l;
        }
        LongRect longRect3 = new LongRect(l2, l5, l3, l);
        LongRect.addBorder((LongRect)longRect3, (long)this.lineWidth);
        return longRect3;
    }

    private static double getItemValueFactor(ChartContext chartContext, double d, double d2) {
        return ((double)chartContext.getDataHeight() - chartContext.getDataHeight(d)) / d2;
    }
}

