/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import com.google.common.collect.ObjectArrays;
import org.gradle.api.specs.CompositeSpec;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrSpec<T>
extends CompositeSpec<T> {
    public static final OrSpec<?> EMPTY = new OrSpec();

    public OrSpec() {
    }

    public OrSpec(Spec<? super T> ... specs) {
        super(specs);
    }

    public OrSpec(Iterable<? extends Spec<? super T>> specs) {
        super(specs);
    }

    @Override
    public boolean isSatisfiedBy(T object) {
        Spec<T>[] specs = this.getSpecsArray();
        if (specs.length == 0) {
            return true;
        }
        for (Spec<T> spec : specs) {
            if (!spec.isSatisfiedBy(object)) continue;
            return true;
        }
        return false;
    }

    public OrSpec<T> or(Spec<? super T> ... specs) {
        if (specs.length == 0) {
            return this;
        }
        Spec<T>[] thisSpecs = this.getSpecsArray();
        int thisLength = thisSpecs.length;
        if (thisLength == 0) {
            return new OrSpec<T>(specs);
        }
        Spec[] combinedSpecs = (Spec[])OrSpec.uncheckedCast(ObjectArrays.newArray(Spec.class, (int)(thisLength + specs.length)));
        System.arraycopy(thisSpecs, 0, combinedSpecs, 0, thisLength);
        System.arraycopy(specs, 0, combinedSpecs, thisLength, specs.length);
        return new OrSpec<T>(combinedSpecs);
    }

    public static <T> OrSpec<T> empty() {
        return (OrSpec)OrSpec.uncheckedCast(EMPTY);
    }

    @Override
    public int hashCode() {
        return 13 * super.hashCode();
    }
}

