/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.tree.Location;

public abstract class NamedExpression
extends Expression {
    private final String name;
    private final ExpressionId id;
    private final boolean synthetic;

    public NamedExpression(Location location, String name, List<Expression> children, ExpressionId id) {
        this(location, name, children, id, false);
    }

    public NamedExpression(Location location, String name, List<Expression> children, ExpressionId id, boolean synthetic) {
        super(location, children);
        this.name = name;
        this.id = id == null ? new ExpressionId() : id;
        this.synthetic = synthetic;
    }

    public String name() {
        return this.name;
    }

    public ExpressionId id() {
        return this.id;
    }

    public boolean synthetic() {
        return this.synthetic;
    }

    public abstract Attribute toAttribute();

    @Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.synthetic);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedExpression other = (NamedExpression)obj;
        return Objects.equals(this.synthetic, other.synthetic) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.children(), other.children());
    }
}

