/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.autodetect.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.writer.RecordWriter;

public class LengthEncodedWriter
implements RecordWriter {
    private OutputStream outputStream;
    private ByteBuffer lengthBuffer;

    public LengthEncodedWriter(OutputStream os) {
        this.outputStream = os;
        this.lengthBuffer = ByteBuffer.allocate(4);
    }

    public void writeRecord(String[] record) throws IOException {
        this.writeNumFields(record.length);
        for (String field : record) {
            this.writeField(field);
        }
    }

    public void writeRecord(List<String> record) throws IOException {
        this.writeNumFields(record.size());
        for (String field : record) {
            this.writeField(field);
        }
    }

    public void writeNumFields(int numFields) throws IOException {
        this.lengthBuffer.clear();
        this.lengthBuffer.putInt(numFields);
        this.outputStream.write(this.lengthBuffer.array());
    }

    public void writeField(String field) throws IOException {
        byte[] utf8Bytes = field.getBytes(StandardCharsets.UTF_8);
        this.lengthBuffer.clear();
        this.lengthBuffer.putInt(utf8Bytes.length);
        this.outputStream.write(this.lengthBuffer.array());
        this.outputStream.write(utf8Bytes);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }
}

