/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.Objects;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.common.Nullable;

class SecurityHttpClientConfigCallback
implements RestClientBuilder.HttpClientConfigCallback {
    @Nullable
    private final CredentialsProvider credentialsProvider;
    private final SSLIOSessionStrategy sslStrategy;

    SecurityHttpClientConfigCallback(SSLIOSessionStrategy sslStrategy, @Nullable CredentialsProvider credentialsProvider) {
        this.sslStrategy = Objects.requireNonNull(sslStrategy);
        this.credentialsProvider = credentialsProvider;
    }

    @Nullable
    CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    SSLIOSessionStrategy getSSLStrategy() {
        return this.sslStrategy;
    }

    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)this.sslStrategy);
        if (this.credentialsProvider != null) {
            httpClientBuilder.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        return httpClientBuilder;
    }
}

