/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.zipimport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.util.FileUtil;
import org.python.core.util.StringUtil;
import org.python.core.util.importer;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.zipimport.zipimport;
import org.python.modules.zipimport.zipimporter$PyExposer;

@ExposedType(name="zipimport.zipimporter", base=PyObject.class)
public class zipimporter
extends importer<PyObject>
implements Traverseproc {
    public static final PyType TYPE;
    public static final PyString __doc__;
    public String archive;
    public String prefix;
    public PyObject files;
    private PySystemState sys;

    public PyString getArchive() {
        return Py.fileSystemEncode(this.archive);
    }

    public zipimporter() {
    }

    public zipimporter(PyType subType) {
        super(subType);
    }

    public zipimporter(String path) {
        this.zipimporter___init__(path);
    }

    @ExposedNew
    final void zipimporter___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("__init__", args, kwds, new String[]{"path"});
        String path = Py.fileSystemDecode(ap.getPyObject(0));
        this.zipimporter___init__(path);
    }

    private void zipimporter___init__(String path) {
        if (path == null || path.length() == 0) {
            throw zipimport.ZipImportError("archive path is empty");
        }
        File pathFile = new File(path);
        this.sys = Py.getSystemState();
        this.prefix = "";
        while (true) {
            File parentFile;
            File fullPathFile = new File(this.sys.getPath(pathFile.getPath()));
            try {
                if (fullPathFile.isFile()) {
                    this.archive = pathFile.getPath();
                    break;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if ((parentFile = pathFile.getParentFile()) == null) break;
            this.prefix = pathFile.getName() + File.separator + this.prefix;
            pathFile = parentFile;
        }
        if (this.archive != null) {
            PyUnicode archivePath = Py.newUnicode(this.archive);
            this.files = zipimport._zip_directory_cache.__finditem__(archivePath);
            if (this.files == null) {
                this.files = this.readDirectory(this.archive);
                zipimport._zip_directory_cache.__setitem__(archivePath, this.files);
            }
        } else {
            throw zipimport.ZipImportError("not a Zip file: " + path);
        }
        if (this.prefix != "" && !this.prefix.endsWith(File.separator)) {
            this.prefix = this.prefix + File.separator;
        }
    }

    public PyObject find_module(String fullname) {
        return this.zipimporter_find_module(fullname, null);
    }

    public PyObject find_module(String fullname, String path) {
        return this.zipimporter_find_module(fullname, path);
    }

    final PyObject zipimporter_find_module(String fullname, String path) {
        return this.importer_find_module(fullname, path);
    }

    public PyObject load_module(String fullname) {
        return this.zipimporter_load_module(fullname);
    }

    final PyObject zipimporter_load_module(String fullname) {
        return this.importer_load_module(fullname);
    }

    @Override
    public String get_data(String path) {
        return this.zipimporter_get_data(Py.newUnicode(path));
    }

    final String zipimporter_get_data(PyObject opath) {
        byte[] data;
        PyObject tocEntry;
        String path = Py.fileSystemDecode(opath);
        int len = this.archive.length();
        if (len < path.length() && path.startsWith(this.archive + File.separator)) {
            path = path.substring(len + 1);
        }
        if ((tocEntry = this.files.__finditem__(path)) == null) {
            throw Py.IOError(path);
        }
        try (ZipBundle zipBundle = this.makeBundle(path, tocEntry);){
            data = FileUtil.readBytes(zipBundle.inputStream);
        }
        return StringUtil.fromBytes(data);
    }

    public boolean is_package(String fullname) {
        return this.zipimporter_is_package(fullname);
    }

    final boolean zipimporter_is_package(String fullname) {
        importer.ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == importer.ModuleInfo.NOT_FOUND) {
            throw zipimport.ZipImportError(String.format("can't find module '%s'", fullname));
        }
        return moduleInfo == importer.ModuleInfo.PACKAGE;
    }

    public PyObject get_code(String fullname) {
        return this.zipimporter_get_code(fullname);
    }

    final PyObject zipimporter_get_code(String fullname) {
        importer.ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData != null) {
            return moduleCodeData.code;
        }
        return Py.None;
    }

    public PyObject get_filename(String fullname) {
        return this.zipimporter_get_filename(fullname);
    }

    final PyObject zipimporter_get_filename(String fullname) {
        importer.ModuleCodeData moduleCodeData = this.getModuleCode(fullname);
        if (moduleCodeData != null) {
            return Py.fileSystemEncode(moduleCodeData.path);
        }
        return Py.None;
    }

    public String get_source(String fullname) {
        return this.zipimporter_get_source(fullname);
    }

    final String zipimporter_get_source(String fullname) {
        importer.ModuleInfo moduleInfo = this.getModuleInfo(fullname);
        if (moduleInfo == importer.ModuleInfo.ERROR) {
            return null;
        }
        if (moduleInfo == importer.ModuleInfo.NOT_FOUND) {
            throw zipimport.ZipImportError(String.format("can't find module '%s'", fullname));
        }
        String path = this.makeFilename(fullname);
        path = moduleInfo == importer.ModuleInfo.PACKAGE ? path + File.separator + "__init__.py" : path + ".py";
        PyObject tocEntry = this.files.__finditem__(path);
        return tocEntry == null ? null : this.get_data(path);
    }

    public ZipBundle makeBundle(String datapath, PyObject entry) {
        ZipFile zipArchive;
        datapath = datapath.replace(File.separatorChar, '/');
        try {
            zipArchive = new ZipFile(new File(this.sys.getPath(this.archive)));
        }
        catch (IOException ioe) {
            throw zipimport.ZipImportError("zipimport: can not open file: " + this.archive);
        }
        ZipEntry dataEntry = zipArchive.getEntry(datapath);
        try {
            return new ZipBundle(zipArchive, zipArchive.getInputStream(dataEntry));
        }
        catch (IOException ioe) {
            Py.writeDebug("import", "zipimporter.getDataStream exception: " + ioe.toString());
            throw zipimport.ZipImportError("zipimport: can not open file: " + this.archive);
        }
    }

    @Override
    protected long getSourceMtime(String path) {
        int date;
        int time;
        String sourcePath = path.substring(0, path.length() - 9) + ".py";
        PyObject sourceTocEntry = this.files.__finditem__(sourcePath);
        if (sourceTocEntry == null) {
            return -1L;
        }
        try {
            time = sourceTocEntry.__finditem__(5).asInt();
            date = sourceTocEntry.__finditem__(6).asInt();
        }
        catch (PyException pye) {
            if (!pye.match(Py.TypeError)) {
                throw pye;
            }
            time = -1;
            date = -1;
        }
        return this.dosTimeToEpoch(time, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PyObject readDirectory(String archive) {
        ZipFile zipFile;
        File file = new File(this.sys.getPath(archive));
        if (!file.canRead()) {
            throw zipimport.ZipImportError(String.format("can't open Zip file: '%s'", archive));
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException ioe) {
            throw zipimport.ZipImportError(String.format("can't read Zip file: '%s'", archive));
        }
        PyDictionary files = new PyDictionary();
        try {
            this.readZipFile(zipFile, files);
        }
        finally {
            try {
                zipFile.close();
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
        return files;
    }

    private void readZipFile(ZipFile zipFile, PyObject files) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String name = zipEntry.getName().replace('/', File.separatorChar);
            PyString __file__ = Py.fileSystemEncode(this.archive + File.separator + name);
            PyInteger compress2 = Py.newInteger(zipEntry.getMethod());
            PyLong data_size = new PyLong(zipEntry.getCompressedSize());
            PyLong file_size = new PyLong(zipEntry.getSize());
            PyInteger file_offset = Py.newInteger(-1);
            PyInteger time = new PyInteger(this.epochToDosTime(zipEntry.getTime()));
            PyInteger date = new PyInteger(this.epochToDosDate(zipEntry.getTime()));
            PyLong crc = new PyLong(zipEntry.getCrc());
            PyTuple entry = new PyTuple(__file__, compress2, data_size, file_size, file_offset, time, date, crc);
            files.__setitem__(Py.newStringOrUnicode(name), (PyObject)entry);
        }
    }

    @Override
    protected String getSeparator() {
        return File.separator;
    }

    @Override
    protected String makeFilename(String fullname) {
        return this.prefix + this.getSubname(fullname).replace('.', File.separatorChar);
    }

    @Override
    protected String makePackagePath(String fullname) {
        return this.archive + File.separator + this.prefix + this.getSubname(fullname);
    }

    @Override
    protected String makeFilePath(String fullname) {
        return this.makePackagePath(fullname);
    }

    @Override
    protected PyObject makeEntry(String fullFilename) {
        return this.files.__finditem__(fullFilename);
    }

    protected String getSubname(String fullname) {
        int i = fullname.lastIndexOf(".");
        if (i >= 0) {
            return fullname.substring(i + 1);
        }
        return fullname;
    }

    private int epochToDosDate(long time) {
        Date d = new Date(time);
        int year = d.getYear() + 1900;
        if (year < 1980) {
            return 0x210000;
        }
        return year - 1980 << 9 | d.getMonth() + 1 << 5 | d.getDate() << 0;
    }

    private int epochToDosTime(long time) {
        Date d = new Date(time);
        return d.getHours() << 11 | d.getMinutes() << 5 | d.getSeconds() >> 1;
    }

    private long dosTimeToEpoch(int dosTime, int dosDate) {
        Date d = new Date((dosDate >> 9 & 0x7F) + 80, (dosDate >> 5 & 0xF) - 1, dosDate & 0x1F, dosTime >> 11 & 0x1F, dosTime >> 5 & 0x3F, (dosTime & 0x1F) * 2);
        return d.getTime();
    }

    @Override
    public String toString() {
        return this.zipimporter_toString();
    }

    final String zipimporter_toString() {
        String bytesName;
        String string = bytesName = this.archive != null ? Py.fileSystemEncode(this.archive).getString() : "???";
        if (this.prefix != null && !"".equals(this.prefix)) {
            return String.format("<zipimporter object \"%.300s%c%.150s\">", bytesName, Character.valueOf(File.separatorChar), this.prefix);
        }
        return String.format("<zipimporter object \"%.300s\">", bytesName);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.files != null && (retVal = visit.visit(this.files, arg)) != 0) {
            return retVal;
        }
        return this.sys == null ? 0 : visit.visit(this.sys, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.files || ob == this.sys);
    }

    static {
        PyType.addBuilder(zipimporter.class, new zipimporter$PyExposer());
        TYPE = PyType.fromClass(zipimporter.class);
        __doc__ = new PyString("zipimporter(archivepath) -> zipimporter object\n\nCreate a new zipimporter instance. 'archivepath' must be a path to\na zipfile. ZipImportError is raised if 'archivepath' doesn't point to\na valid Zip archive.");
    }

    private class ZipBundle
    extends importer.Bundle {
        ZipFile zipFile;

        public ZipBundle(ZipFile zipFile, InputStream inputStream) {
            super(inputStream);
            this.zipFile = zipFile;
        }

        @Override
        public void close() {
            try {
                this.zipFile.close();
            }
            catch (IOException ioe) {
                throw Py.IOError(ioe);
            }
        }
    }
}

