/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image;

import org.sunflow.image.SpectralCurve;

public class RegularSpectralCurve
extends SpectralCurve {
    private final float[] spectrum;
    private final float lambdaMin;
    private final float lambdaMax;
    private final float delta;
    private final float invDelta;

    public RegularSpectralCurve(float[] fArray, float f, float f2) {
        this.lambdaMin = f;
        this.lambdaMax = f2;
        this.spectrum = fArray;
        this.delta = (f2 - f) / (float)(fArray.length - 1);
        this.invDelta = 1.0f / this.delta;
    }

    public float sample(float f) {
        if (f < this.lambdaMin || f > this.lambdaMax) {
            return 0.0f;
        }
        float f2 = (f - this.lambdaMin) * this.invDelta;
        int n = (int)f2;
        int n2 = Math.min(n + 1, this.spectrum.length - 1);
        float f3 = f2 - (float)n;
        return (1.0f - f3) * this.spectrum[n] + f3 * this.spectrum[n2];
    }
}

