#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 8
#define STATE_COUNT 3206
#define SYMBOL_COUNT 144
#define ALIAS_COUNT 5
#define TOKEN_COUNT 90
#define EXTERNAL_TOKEN_COUNT 12
#define MAX_ALIAS_SEQUENCE_LENGTH 8

enum {
  sym_heredoc_start = 1,
  sym__simple_heredoc_body = 2,
  sym__heredoc_body_beginning = 3,
  sym__heredoc_body_middle = 4,
  sym__heredoc_body_end = 5,
  sym_file_descriptor = 6,
  sym__empty_value = 7,
  sym__concat = 8,
  sym_variable_name = 9,
  anon_sym_for = 10,
  anon_sym_in = 11,
  anon_sym_while = 12,
  anon_sym_do = 13,
  anon_sym_done = 14,
  anon_sym_if = 15,
  anon_sym_then = 16,
  anon_sym_fi = 17,
  anon_sym_elif = 18,
  anon_sym_else = 19,
  anon_sym_case = 20,
  anon_sym_esac = 21,
  anon_sym_PIPE = 22,
  anon_sym_RPAREN = 23,
  anon_sym_SEMI_SEMI = 24,
  anon_sym_function = 25,
  anon_sym_LPAREN = 26,
  anon_sym_LBRACE = 27,
  anon_sym_RBRACE = 28,
  anon_sym_PIPE_AMP = 29,
  anon_sym_AMP_AMP = 30,
  anon_sym_PIPE_PIPE = 31,
  anon_sym_BANG = 32,
  anon_sym_LBRACK = 33,
  anon_sym_RBRACK = 34,
  anon_sym_LBRACK_LBRACK = 35,
  anon_sym_RBRACK_RBRACK = 36,
  anon_sym_declare = 37,
  anon_sym_typeset = 38,
  anon_sym_export = 39,
  anon_sym_readonly = 40,
  anon_sym_local = 41,
  anon_sym_unset = 42,
  anon_sym_unsetenv = 43,
  anon_sym_EQ_TILDE = 44,
  anon_sym_EQ_EQ = 45,
  anon_sym_EQ = 46,
  anon_sym_PLUS_EQ = 47,
  anon_sym_LT = 48,
  anon_sym_GT = 49,
  anon_sym_GT_GT = 50,
  anon_sym_AMP_GT = 51,
  anon_sym_AMP_GT_GT = 52,
  anon_sym_LT_AMP = 53,
  anon_sym_GT_AMP = 54,
  anon_sym_LT_LT = 55,
  anon_sym_LT_LT_DASH = 56,
  anon_sym_LT_LT_LT = 57,
  anon_sym_BANG_EQ = 58,
  sym__special_characters = 59,
  anon_sym_DQUOTE = 60,
  anon_sym_DOLLAR = 61,
  sym__string_content = 62,
  sym_raw_string = 63,
  anon_sym_POUND = 64,
  anon_sym_DOLLAR_LBRACE = 65,
  aux_sym_SLASH = 66,
  anon_sym_COLON = 67,
  anon_sym_COLON_QMARK = 68,
  anon_sym_COLON_DASH = 69,
  anon_sym_PERCENT = 70,
  anon_sym_DASH = 71,
  anon_sym_DOLLAR_LPAREN = 72,
  anon_sym_BQUOTE = 73,
  anon_sym_LT_LPAREN = 74,
  anon_sym_GT_LPAREN = 75,
  sym_comment = 76,
  aux_sym_SLASH_BSLASHw_PLUS_SLASH = 77,
  anon_sym_STAR = 78,
  anon_sym_AT = 79,
  anon_sym_QMARK = 80,
  anon_sym_0 = 81,
  anon_sym__ = 82,
  sym_word = 83,
  sym_test_operator = 84,
  sym_regex = 85,
  sym_regex_without_right_brace = 86,
  anon_sym_SEMI = 87,
  anon_sym_LF = 88,
  anon_sym_AMP = 89,
  sym_program = 90,
  sym__terminated_statement = 91,
  sym_for_statement = 92,
  sym_while_statement = 93,
  sym_do_group = 94,
  sym_if_statement = 95,
  sym_elif_clause = 96,
  sym_else_clause = 97,
  sym_case_statement = 98,
  sym_case_item = 99,
  sym_last_case_item = 100,
  sym_function_definition = 101,
  sym_compound_statement = 102,
  sym_subshell = 103,
  sym_pipeline = 104,
  sym_list = 105,
  sym_negated_command = 106,
  sym_test_command = 107,
  sym_declaration_command = 108,
  sym_unset_command = 109,
  sym_command = 110,
  sym_command_name = 111,
  sym_variable_assignment = 112,
  sym_subscript = 113,
  sym_file_redirect = 114,
  sym_heredoc_redirect = 115,
  sym_heredoc_body = 116,
  sym_herestring_redirect = 117,
  sym__expression = 118,
  sym_binary_expression = 119,
  sym_unary_expression = 120,
  sym_parenthesized_expression = 121,
  sym_concatenation = 122,
  sym_string = 123,
  sym_array = 124,
  sym_simple_expansion = 125,
  sym_string_expansion = 126,
  sym_expansion = 127,
  sym_command_substitution = 128,
  sym_process_substitution = 129,
  aux_sym_program_repeat1 = 130,
  aux_sym_for_statement_repeat1 = 131,
  aux_sym_while_statement_repeat1 = 132,
  aux_sym_if_statement_repeat1 = 133,
  aux_sym_case_statement_repeat1 = 134,
  aux_sym_case_item_repeat1 = 135,
  aux_sym_declaration_command_repeat1 = 136,
  aux_sym_unset_command_repeat1 = 137,
  aux_sym_command_repeat1 = 138,
  aux_sym_command_repeat2 = 139,
  aux_sym_heredoc_body_repeat1 = 140,
  aux_sym_concatenation_repeat1 = 141,
  aux_sym_string_repeat1 = 142,
  aux_sym_expansion_repeat1 = 143,
  alias_sym_case_item = 144,
  alias_sym_regex = 145,
  alias_sym_special_variable_name = 146,
  alias_sym_variable_name = 147,
  alias_sym_word = 148,
};

static const char *ts_symbol_names[] = {
  [sym_heredoc_start] = "heredoc_start",
  [sym__simple_heredoc_body] = "_simple_heredoc_body",
  [sym__heredoc_body_beginning] = "_heredoc_body_beginning",
  [sym__heredoc_body_middle] = "_heredoc_body_middle",
  [sym__heredoc_body_end] = "_heredoc_body_end",
  [sym_file_descriptor] = "file_descriptor",
  [sym__empty_value] = "_empty_value",
  [sym__concat] = "_concat",
  [sym_variable_name] = "variable_name",
  [ts_builtin_sym_end] = "END",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_done] = "done",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_fi] = "fi",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_case] = "case",
  [anon_sym_esac] = "esac",
  [anon_sym_PIPE] = "|",
  [anon_sym_RPAREN] = ")",
  [anon_sym_SEMI_SEMI] = ";;",
  [anon_sym_function] = "function",
  [anon_sym_LPAREN] = "(",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_PIPE_AMP] = "|&",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_BANG] = "!",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACK_LBRACK] = "[[",
  [anon_sym_RBRACK_RBRACK] = "]]",
  [anon_sym_declare] = "declare",
  [anon_sym_typeset] = "typeset",
  [anon_sym_export] = "export",
  [anon_sym_readonly] = "readonly",
  [anon_sym_local] = "local",
  [anon_sym_unset] = "unset",
  [anon_sym_unsetenv] = "unsetenv",
  [anon_sym_EQ_TILDE] = "=~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_GT] = "&>",
  [anon_sym_AMP_GT_GT] = "&>>",
  [anon_sym_LT_AMP] = "<&",
  [anon_sym_GT_AMP] = ">&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_LT_LT_DASH] = "<<-",
  [anon_sym_LT_LT_LT] = "<<<",
  [anon_sym_BANG_EQ] = "!=",
  [sym__special_characters] = "_special_characters",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DOLLAR] = "$",
  [sym__string_content] = "_string_content",
  [sym_raw_string] = "raw_string",
  [anon_sym_POUND] = "#",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [aux_sym_SLASH] = "/",
  [anon_sym_COLON] = ":",
  [anon_sym_COLON_QMARK] = ":?",
  [anon_sym_COLON_DASH] = ":-",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DASH] = "-",
  [anon_sym_DOLLAR_LPAREN] = "$(",
  [anon_sym_BQUOTE] = "`",
  [anon_sym_LT_LPAREN] = "<(",
  [anon_sym_GT_LPAREN] = ">(",
  [sym_comment] = "comment",
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = "/\\w+/",
  [anon_sym_STAR] = "*",
  [anon_sym_AT] = "@",
  [anon_sym_QMARK] = "?",
  [anon_sym_0] = "0",
  [anon_sym__] = "_",
  [sym_word] = "word",
  [sym_test_operator] = "test_operator",
  [sym_regex] = "regex",
  [sym_regex_without_right_brace] = "regex_without_right_brace",
  [anon_sym_SEMI] = ";",
  [anon_sym_LF] = "\n",
  [anon_sym_AMP] = "&",
  [sym_program] = "program",
  [sym__terminated_statement] = "_terminated_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_group] = "do_group",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_case_statement] = "case_statement",
  [sym_case_item] = "case_item",
  [sym_last_case_item] = "last_case_item",
  [sym_function_definition] = "function_definition",
  [sym_compound_statement] = "compound_statement",
  [sym_subshell] = "subshell",
  [sym_pipeline] = "pipeline",
  [sym_list] = "list",
  [sym_negated_command] = "negated_command",
  [sym_test_command] = "test_command",
  [sym_declaration_command] = "declaration_command",
  [sym_unset_command] = "unset_command",
  [sym_command] = "command",
  [sym_command_name] = "command_name",
  [sym_variable_assignment] = "variable_assignment",
  [sym_subscript] = "subscript",
  [sym_file_redirect] = "file_redirect",
  [sym_heredoc_redirect] = "heredoc_redirect",
  [sym_heredoc_body] = "heredoc_body",
  [sym_herestring_redirect] = "herestring_redirect",
  [sym__expression] = "_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_concatenation] = "concatenation",
  [sym_string] = "string",
  [sym_array] = "array",
  [sym_simple_expansion] = "simple_expansion",
  [sym_string_expansion] = "string_expansion",
  [sym_expansion] = "expansion",
  [sym_command_substitution] = "command_substitution",
  [sym_process_substitution] = "process_substitution",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_for_statement_repeat1] = "for_statement_repeat1",
  [aux_sym_while_statement_repeat1] = "while_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_case_statement_repeat1] = "case_statement_repeat1",
  [aux_sym_case_item_repeat1] = "case_item_repeat1",
  [aux_sym_declaration_command_repeat1] = "declaration_command_repeat1",
  [aux_sym_unset_command_repeat1] = "unset_command_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
  [aux_sym_command_repeat2] = "command_repeat2",
  [aux_sym_heredoc_body_repeat1] = "heredoc_body_repeat1",
  [aux_sym_concatenation_repeat1] = "concatenation_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_expansion_repeat1] = "expansion_repeat1",
  [alias_sym_case_item] = "case_item",
  [alias_sym_regex] = "regex",
  [alias_sym_special_variable_name] = "special_variable_name",
  [alias_sym_variable_name] = "variable_name",
  [alias_sym_word] = "word",
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [sym_heredoc_start] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_heredoc_body] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_beginning] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_middle] = {
    .visible = false,
    .named = true,
  },
  [sym__heredoc_body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_file_descriptor] = {
    .visible = true,
    .named = true,
  },
  [sym__empty_value] = {
    .visible = false,
    .named = true,
  },
  [sym__concat] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_done] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_esac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_declare] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_typeset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_readonly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsetenv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym__special_characters] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym_raw_string] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_SLASH] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_0] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_test_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_regex] = {
    .visible = true,
    .named = true,
  },
  [sym_regex_without_right_brace] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym__terminated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_group] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_last_case_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subshell] = {
    .visible = true,
    .named = true,
  },
  [sym_pipeline] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_command] = {
    .visible = true,
    .named = true,
  },
  [sym_test_command] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration_command] = {
    .visible = true,
    .named = true,
  },
  [sym_unset_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_file_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym_heredoc_body] = {
    .visible = true,
    .named = true,
  },
  [sym_herestring_redirect] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenation] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_string_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_expansion] = {
    .visible = true,
    .named = true,
  },
  [sym_command_substitution] = {
    .visible = true,
    .named = true,
  },
  [sym_process_substitution] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_for_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_while_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_item_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unset_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_heredoc_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expansion_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_case_item] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_regex] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_special_variable_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_variable_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_word] = {
    .visible = true,
    .named = true,
  },
};

static TSSymbol ts_alias_sequences[23][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [1] = {
    [0] = alias_sym_word,
  },
  [2] = {
    [0] = alias_sym_variable_name,
  },
  [3] = {
    [1] = alias_sym_word,
  },
  [4] = {
    [1] = alias_sym_special_variable_name,
  },
  [5] = {
    [1] = alias_sym_variable_name,
  },
  [6] = {
    [2] = alias_sym_word,
  },
  [7] = {
    [2] = alias_sym_special_variable_name,
  },
  [8] = {
    [2] = alias_sym_variable_name,
  },
  [9] = {
    [3] = alias_sym_word,
  },
  [10] = {
    [1] = alias_sym_special_variable_name,
    [3] = alias_sym_regex,
  },
  [11] = {
    [1] = alias_sym_variable_name,
    [3] = alias_sym_regex,
  },
  [12] = {
    [3] = alias_sym_regex,
  },
  [13] = {
    [1] = alias_sym_word,
    [4] = alias_sym_case_item,
  },
  [14] = {
    [4] = alias_sym_case_item,
  },
  [15] = {
    [4] = alias_sym_word,
  },
  [16] = {
    [2] = alias_sym_special_variable_name,
    [4] = alias_sym_regex,
  },
  [17] = {
    [2] = alias_sym_variable_name,
    [4] = alias_sym_regex,
  },
  [18] = {
    [4] = alias_sym_regex,
  },
  [19] = {
    [1] = alias_sym_word,
    [5] = alias_sym_case_item,
  },
  [20] = {
    [5] = alias_sym_case_item,
  },
  [21] = {
    [1] = alias_sym_word,
    [6] = alias_sym_case_item,
  },
  [22] = {
    [6] = alias_sym_case_item,
  },
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  switch (state) {
    case 0:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '!')
        ADVANCE(2);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(5);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '%')
        ADVANCE(9);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '*')
        ADVANCE(18);
      if (lookahead == '+')
        ADVANCE(19);
      if (lookahead == '-')
        ADVANCE(21);
      if (lookahead == '/')
        ADVANCE(22);
      if (lookahead == '0')
        ADVANCE(23);
      if (lookahead == ':')
        ADVANCE(25);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(36);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '?')
        ADVANCE(43);
      if (lookahead == '@')
        ADVANCE(44);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        SKIP(47);
      if (lookahead == ']')
        ADVANCE(48);
      if (lookahead == '_')
        ADVANCE(50);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(52);
      if (lookahead == 'd')
        ADVANCE(56);
      if (lookahead == 'e')
        ADVANCE(66);
      if (lookahead == 'f')
        ADVANCE(80);
      if (lookahead == 'i')
        ADVANCE(91);
      if (lookahead == 'l')
        ADVANCE(94);
      if (lookahead == 'r')
        ADVANCE(99);
      if (lookahead == 't')
        ADVANCE(107);
      if (lookahead == 'u')
        ADVANCE(117);
      if (lookahead == 'w')
        ADVANCE(125);
      if (lookahead == '{')
        ADVANCE(130);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(0);
      if (('1' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 2:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=')
        ADVANCE(3);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 6:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(')
        ADVANCE(7);
      if (lookahead == '{')
        ADVANCE(8);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(11);
      if (lookahead == '>')
        ADVANCE(12);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(anon_sym_AMP_GT);
      if (lookahead == '>')
        ADVANCE(13);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_AMP_GT_GT);
      END_STATE();
    case 14:
      if (lookahead == '\'')
        ADVANCE(15);
      if (lookahead != 0)
        ADVANCE(14);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(sym_raw_string);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 19:
      if (lookahead == '=')
        ADVANCE(20);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(aux_sym_SLASH);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-')
        ADVANCE(26);
      if (lookahead == '?')
        ADVANCE(27);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_SEMI);
      if (lookahead == ';')
        ADVANCE(29);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_SEMI_SEMI);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(31);
      if (lookahead == '(')
        ADVANCE(32);
      if (lookahead == '<')
        ADVANCE(33);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_LT_AMP);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '-')
        ADVANCE(34);
      if (lookahead == '<')
        ADVANCE(35);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LT_LT_DASH);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LT_LT_LT);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=')
        ADVANCE(37);
      if (lookahead == '~')
        ADVANCE(38);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(40);
      if (lookahead == '(')
        ADVANCE(41);
      if (lookahead == '>')
        ADVANCE(42);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_GT_AMP);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '[')
        ADVANCE(46);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(anon_sym_LBRACK_LBRACK);
      END_STATE();
    case 47:
      if (lookahead == '\n')
        SKIP(0);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      if (lookahead == ']')
        ADVANCE(49);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_RBRACK_RBRACK);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'a')
        ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 's')
        ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_case);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(57);
      if (lookahead == 'o')
        ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'c')
        ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'l')
        ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'a')
        ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'r')
        ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_declare);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_do);
      if (lookahead == 'n')
        ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_done);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'l')
        ADVANCE(67);
      if (lookahead == 's')
        ADVANCE(72);
      if (lookahead == 'x')
        ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'i')
        ADVANCE(68);
      if (lookahead == 's')
        ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'f')
        ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_elif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'a')
        ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'c')
        ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_esac);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'p')
        ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'o')
        ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'r')
        ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 't')
        ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_export);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'i')
        ADVANCE(81);
      if (lookahead == 'o')
        ADVANCE(82);
      if (lookahead == 'u')
        ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_fi);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'r')
        ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'c')
        ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 't')
        ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'i')
        ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'o')
        ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'f')
        ADVANCE(92);
      if (lookahead == 'n')
        ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_in);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'o')
        ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'c')
        ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'a')
        ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'l')
        ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_local);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'a')
        ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'd')
        ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'o')
        ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'l')
        ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'y')
        ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_readonly);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'h')
        ADVANCE(108);
      if (lookahead == 'y')
        ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_then);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'p')
        ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(113);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 's')
        ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 't')
        ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_typeset);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 's')
        ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 't')
        ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == 'e')
        ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'n')
        ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'v')
        ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'h')
        ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'i')
        ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'l')
        ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == 'e')
        ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '&')
        ADVANCE(132);
      if (lookahead == '|')
        ADVANCE(133);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_PIPE_AMP);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 135:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(142);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(148);
      if (lookahead == 'e')
        ADVANCE(155);
      if (lookahead == 'f')
        ADVANCE(161);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(135);
      if ((lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 137:
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n')
        ADVANCE(139);
      END_STATE();
    case 140:
      if (lookahead == '>')
        ADVANCE(12);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(31);
      if (lookahead == '(')
        ADVANCE(32);
      END_STATE();
    case 142:
      if (lookahead == '\n')
        SKIP(135);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym__special_characters);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'a')
        ADVANCE(145);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 's')
        ADVANCE(146);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(149);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'c')
        ADVANCE(150);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'l')
        ADVANCE(151);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'a')
        ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'r')
        ADVANCE(153);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(154);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_declare);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'x')
        ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'p')
        ADVANCE(157);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'o')
        ADVANCE(158);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'r')
        ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 't')
        ADVANCE(160);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_export);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'o')
        ADVANCE(162);
      if (lookahead == 'u')
        ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'r')
        ADVANCE(163);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'n')
        ADVANCE(165);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'c')
        ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 't')
        ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'i')
        ADVANCE(168);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'o')
        ADVANCE(169);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'n')
        ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'f')
        ADVANCE(172);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'o')
        ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'c')
        ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'a')
        ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'l')
        ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_local);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'a')
        ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'd')
        ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'o')
        ADVANCE(182);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'n')
        ADVANCE(183);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'l')
        ADVANCE(184);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'y')
        ADVANCE(185);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_readonly);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'y')
        ADVANCE(187);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'p')
        ADVANCE(188);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(189);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 's')
        ADVANCE(190);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(191);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 't')
        ADVANCE(192);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_typeset);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'n')
        ADVANCE(194);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 's')
        ADVANCE(195);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(196);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 't')
        ADVANCE(197);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_unset);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(198);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'n')
        ADVANCE(199);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'v')
        ADVANCE(200);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_unsetenv);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'h')
        ADVANCE(202);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'i')
        ADVANCE(203);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'l')
        ADVANCE(204);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(205);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_while);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 206:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '+')
        ADVANCE(19);
      if (lookahead == '=')
        ADVANCE(208);
      if (lookahead == '[')
        ADVANCE(209);
      if (lookahead == '\\')
        SKIP(210);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'd')
        ADVANCE(212);
      if (lookahead == 'e')
        ADVANCE(214);
      if (lookahead == 'f')
        ADVANCE(223);
      if (lookahead == 'i')
        ADVANCE(225);
      if (lookahead == 't')
        ADVANCE(227);
      if (lookahead == '{')
        ADVANCE(130);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(206);
      END_STATE();
    case 207:
      if (lookahead == '&')
        ADVANCE(11);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 210:
      if (lookahead == '\n')
        SKIP(206);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 212:
      if (lookahead == 'o')
        ADVANCE(213);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 214:
      if (lookahead == 'l')
        ADVANCE(215);
      if (lookahead == 's')
        ADVANCE(220);
      END_STATE();
    case 215:
      if (lookahead == 'i')
        ADVANCE(216);
      if (lookahead == 's')
        ADVANCE(218);
      END_STATE();
    case 216:
      if (lookahead == 'f')
        ADVANCE(217);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 218:
      if (lookahead == 'e')
        ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 220:
      if (lookahead == 'a')
        ADVANCE(221);
      END_STATE();
    case 221:
      if (lookahead == 'c')
        ADVANCE(222);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_esac);
      END_STATE();
    case 223:
      if (lookahead == 'i')
        ADVANCE(224);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_fi);
      END_STATE();
    case 225:
      if (lookahead == 'n')
        ADVANCE(226);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 227:
      if (lookahead == 'h')
        ADVANCE(228);
      END_STATE();
    case 228:
      if (lookahead == 'e')
        ADVANCE(229);
      END_STATE();
    case 229:
      if (lookahead == 'n')
        ADVANCE(230);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 231:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '\\')
        SKIP(232);
      if (lookahead == '|')
        ADVANCE(233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 232:
      if (lookahead == '\n')
        SKIP(231);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 234:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(235);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(234);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 235:
      if (lookahead == '\n')
        SKIP(234);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 236:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(237);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(236);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 237:
      if (lookahead == '\n')
        SKIP(236);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 238:
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '-')
        ADVANCE(239);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(243);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(238);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(240);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '`' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(240);
      END_STATE();
    case 241:
      if (lookahead == '(')
        ADVANCE(32);
      END_STATE();
    case 242:
      if (lookahead == '(')
        ADVANCE(41);
      END_STATE();
    case 243:
      if (lookahead == '\n')
        SKIP(238);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 244:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(246);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(247);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_LF);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&')
        ADVANCE(11);
      END_STATE();
    case 247:
      if (lookahead == '\n')
        SKIP(244);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 249:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(253);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(249);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '=')
        ADVANCE(251);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == '~')
        ADVANCE(252);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>') &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '~'))
        ADVANCE(138);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_EQ_TILDE);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 253:
      if (lookahead == '\n')
        SKIP(249);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 254:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(255);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '\\')
        ADVANCE(259);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(260);
      if (lookahead != 0)
        ADVANCE(256);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(256);
      if (lookahead == '\\')
        ADVANCE(258);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(255);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\\')
        ADVANCE(257);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '$' &&
          lookahead != '`')
        ADVANCE(256);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(256);
      if (lookahead == '\\')
        ADVANCE(257);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(256);
      if (lookahead != 0)
        ADVANCE(256);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(256);
      if (lookahead == '\\')
        ADVANCE(258);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(255);
      if (lookahead != 0)
        ADVANCE(255);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(260);
      if (lookahead == '\\')
        ADVANCE(257);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(256);
      if (lookahead != 0)
        ADVANCE(256);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(255);
      if (lookahead == '\\')
        ADVANCE(259);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(260);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          lookahead != '`')
        ADVANCE(256);
      END_STATE();
    case 261:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(5);
      if (lookahead == '$')
        ADVANCE(262);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '*')
        ADVANCE(18);
      if (lookahead == '-')
        ADVANCE(21);
      if (lookahead == '0')
        ADVANCE(23);
      if (lookahead == '?')
        ADVANCE(43);
      if (lookahead == '@')
        ADVANCE(44);
      if (lookahead == '\\')
        SKIP(263);
      if (lookahead == '_')
        ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(261);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 263:
      if (lookahead == '\n')
        SKIP(261);
      END_STATE();
    case 264:
      if (lookahead == '#')
        ADVANCE(5);
      if (lookahead == '$')
        ADVANCE(262);
      if (lookahead == '*')
        ADVANCE(18);
      if (lookahead == '-')
        ADVANCE(21);
      if (lookahead == '0')
        ADVANCE(23);
      if (lookahead == '?')
        ADVANCE(43);
      if (lookahead == '@')
        ADVANCE(44);
      if (lookahead == '\\')
        SKIP(265);
      if (lookahead == '_')
        ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(264);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 265:
      if (lookahead == '\n')
        SKIP(264);
      END_STATE();
    case 266:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(267);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(266);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 267:
      if (lookahead == '\n')
        SKIP(266);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 268:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(269);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(268);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 269:
      if (lookahead == '\n')
        SKIP(268);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 270:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(271);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(270);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 271:
      if (lookahead == '\n')
        SKIP(270);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 272:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(273);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(272);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 273:
      if (lookahead == '\n')
        SKIP(272);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 274:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(275);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '\\')
        SKIP(276);
      if (lookahead == 'i')
        ADVANCE(225);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(274);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 276:
      if (lookahead == '\n')
        SKIP(274);
      END_STATE();
    case 277:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(246);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(278);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(277);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 278:
      if (lookahead == '\n')
        SKIP(277);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 279:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(280);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(279);
      if (lookahead != 0)
        ADVANCE(138);
      END_STATE();
    case 280:
      if (lookahead == '\n')
        SKIP(279);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 281:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(282);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(281);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 282:
      if (lookahead == '\n')
        SKIP(281);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 283:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(246);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '\\')
        SKIP(284);
      if (lookahead == 'e')
        ADVANCE(285);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(283);
      END_STATE();
    case 284:
      if (lookahead == '\n')
        SKIP(283);
      END_STATE();
    case 285:
      if (lookahead == 's')
        ADVANCE(220);
      END_STATE();
    case 286:
      if (lookahead == '!')
        ADVANCE(287);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == '-')
        ADVANCE(288);
      if (lookahead == '<')
        ADVANCE(290);
      if (lookahead == '=')
        ADVANCE(36);
      if (lookahead == '>')
        ADVANCE(291);
      if (lookahead == '\\')
        SKIP(292);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '|')
        ADVANCE(293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(286);
      END_STATE();
    case 287:
      if (lookahead == '=')
        ADVANCE(3);
      END_STATE();
    case 288:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(289);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(289);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 292:
      if (lookahead == '\n')
        SKIP(286);
      END_STATE();
    case 293:
      if (lookahead == '|')
        ADVANCE(133);
      END_STATE();
    case 294:
      if (lookahead == '!')
        ADVANCE(287);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == '-')
        ADVANCE(288);
      if (lookahead == '<')
        ADVANCE(290);
      if (lookahead == '=')
        ADVANCE(36);
      if (lookahead == '>')
        ADVANCE(291);
      if (lookahead == '\\')
        SKIP(295);
      if (lookahead == ']')
        ADVANCE(296);
      if (lookahead == '|')
        ADVANCE(293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(294);
      END_STATE();
    case 295:
      if (lookahead == '\n')
        SKIP(294);
      END_STATE();
    case 296:
      if (lookahead == ']')
        ADVANCE(49);
      END_STATE();
    case 297:
      if (lookahead == '#')
        ADVANCE(5);
      if (lookahead == '$')
        ADVANCE(262);
      if (lookahead == '*')
        ADVANCE(18);
      if (lookahead == '-')
        ADVANCE(21);
      if (lookahead == '0')
        ADVANCE(298);
      if (lookahead == '?')
        ADVANCE(43);
      if (lookahead == '@')
        ADVANCE(44);
      if (lookahead == '\\')
        ADVANCE(300);
      if (lookahead == '_')
        ADVANCE(302);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(301);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(299);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(256);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_0);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(299);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(299);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '\n')
        ADVANCE(301);
      if (lookahead == '\\')
        ADVANCE(257);
      if (lookahead == '\"' ||
          lookahead == '$' ||
          lookahead == '`')
        ADVANCE(256);
      if (lookahead != 0)
        ADVANCE(256);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym__string_content);
      if (lookahead == '#')
        ADVANCE(5);
      if (lookahead == '*')
        ADVANCE(18);
      if (lookahead == '-')
        ADVANCE(21);
      if (lookahead == '0')
        ADVANCE(298);
      if (lookahead == '?')
        ADVANCE(43);
      if (lookahead == '@')
        ADVANCE(44);
      if (lookahead == '\\')
        ADVANCE(300);
      if (lookahead == '_')
        ADVANCE(302);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(301);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(299);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '_' || lookahead > 'z'))
        ADVANCE(256);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym__);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(299);
      END_STATE();
    case 303:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(5);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '%')
        ADVANCE(304);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '-')
        ADVANCE(305);
      if (lookahead == '/')
        ADVANCE(22);
      if (lookahead == ':')
        ADVANCE(306);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '=')
        ADVANCE(309);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(310);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(303);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '-')
        ADVANCE(307);
      if (lookahead == '?')
        ADVANCE(308);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '?' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_COLON_DASH);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_COLON_QMARK);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 310:
      if (lookahead == '\n')
        SKIP(303);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 311:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(262);
      if (lookahead == '*')
        ADVANCE(18);
      if (lookahead == '-')
        ADVANCE(21);
      if (lookahead == '0')
        ADVANCE(23);
      if (lookahead == '?')
        ADVANCE(43);
      if (lookahead == '@')
        ADVANCE(44);
      if (lookahead == '\\')
        SKIP(312);
      if (lookahead == '_')
        ADVANCE(50);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(311);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(24);
      END_STATE();
    case 312:
      if (lookahead == '\n')
        SKIP(311);
      END_STATE();
    case 313:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(314);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<')
        ADVANCE(138);
      END_STATE();
    case 314:
      if (lookahead == '\n')
        SKIP(313);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 315:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(317);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(315);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>'))
        ADVANCE(138);
      END_STATE();
    case 316:
      if (lookahead == '&')
        ADVANCE(11);
      if (lookahead == '>')
        ADVANCE(12);
      END_STATE();
    case 317:
      if (lookahead == '\n')
        SKIP(315);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 318:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(319);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(318);
      if (lookahead != 0 &&
          (lookahead < ';' || lookahead > '>'))
        ADVANCE(138);
      END_STATE();
    case 319:
      if (lookahead == '\n')
        SKIP(318);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 320:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(321);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(320);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<')
        ADVANCE(138);
      END_STATE();
    case 321:
      if (lookahead == '\n')
        SKIP(320);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 322:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(323);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(322);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<')
        ADVANCE(138);
      END_STATE();
    case 323:
      if (lookahead == '\n')
        SKIP(322);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 324:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(325);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(324);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>'))
        ADVANCE(138);
      END_STATE();
    case 325:
      if (lookahead == '\n')
        SKIP(324);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 326:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(327);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(326);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < ';' || lookahead > '>'))
        ADVANCE(138);
      END_STATE();
    case 327:
      if (lookahead == '\n')
        SKIP(326);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 328:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(329);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(328);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<')
        ADVANCE(138);
      END_STATE();
    case 329:
      if (lookahead == '\n')
        SKIP(328);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 330:
      if (lookahead == 0)
        ADVANCE(1);
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(331);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(332);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(148);
      if (lookahead == 'e')
        ADVANCE(155);
      if (lookahead == 'f')
        ADVANCE(161);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(330);
      if ((lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 331:
      if (lookahead == ';')
        ADVANCE(29);
      END_STATE();
    case 332:
      if (lookahead == '\n')
        SKIP(330);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 333:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(334);
      if (lookahead == '\\')
        SKIP(335);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(333);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{')
        ADVANCE(8);
      END_STATE();
    case 335:
      if (lookahead == '\n')
        SKIP(333);
      END_STATE();
    case 336:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(337);
      if (lookahead == '$')
        ADVANCE(339);
      if (lookahead == '\'')
        ADVANCE(344);
      if (lookahead == '<')
        ADVANCE(347);
      if (lookahead == '>')
        ADVANCE(349);
      if (lookahead == '[')
        ADVANCE(351);
      if (lookahead == '\\')
        ADVANCE(352);
      if (lookahead == ']')
        ADVANCE(351);
      if (lookahead == '`')
        ADVANCE(355);
      if (lookahead == '{')
        ADVANCE(351);
      if (lookahead == '}')
        ADVANCE(351);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(336);
      if (('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '|')
        ADVANCE(342);
      if (lookahead != 0)
        ADVANCE(354);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(338);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(337);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(338);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(337);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(337);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '(')
        ADVANCE(340);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead == '{')
        ADVANCE(343);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LPAREN);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(342);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\'')
        ADVANCE(345);
      if (lookahead == '\\')
        ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(14);
      if (lookahead != 0)
        ADVANCE(344);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_raw_string);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\n')
        ADVANCE(14);
      if (lookahead == '\'')
        ADVANCE(345);
      if (lookahead == '\\')
        ADVANCE(346);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(344);
      if (lookahead != 0)
        ADVANCE(344);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '(')
        ADVANCE(348);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_LT_LPAREN);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '(')
        ADVANCE(350);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_GT_LPAREN);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '[')
        ADVANCE(351);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead == ']')
        ADVANCE(351);
      if (lookahead == '{')
        ADVANCE(351);
      if (lookahead == '}')
        ADVANCE(351);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_regex);
      if (lookahead == '\\')
        ADVANCE(353);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(354);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(352);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        ADVANCE(342);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(354);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(352);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(354);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 356:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '\\')
        SKIP(357);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(356);
      END_STATE();
    case 357:
      if (lookahead == '\n')
        SKIP(356);
      END_STATE();
    case 358:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(359);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(361);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(358);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(31);
      if (lookahead == '<')
        ADVANCE(33);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '&')
        ADVANCE(40);
      if (lookahead == '>')
        ADVANCE(42);
      END_STATE();
    case 361:
      if (lookahead == '\n')
        SKIP(358);
      END_STATE();
    case 362:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '\\')
        SKIP(363);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(362);
      END_STATE();
    case 363:
      if (lookahead == '\n')
        SKIP(362);
      END_STATE();
    case 364:
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(365);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(366);
      if (lookahead == 'e')
        ADVANCE(155);
      if (lookahead == 'f')
        ADVANCE(161);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(364);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 365:
      if (lookahead == '\n')
        SKIP(364);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(149);
      if (lookahead == 'o')
        ADVANCE(367);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'n')
        ADVANCE(368);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(369);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_done);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 370:
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(371);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(148);
      if (lookahead == 'e')
        ADVANCE(372);
      if (lookahead == 'f')
        ADVANCE(378);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(370);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 371:
      if (lookahead == '\n')
        SKIP(370);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'l')
        ADVANCE(373);
      if (lookahead == 'x')
        ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'i')
        ADVANCE(374);
      if (lookahead == 's')
        ADVANCE(376);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'f')
        ADVANCE(375);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_elif);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'e')
        ADVANCE(377);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'i')
        ADVANCE(379);
      if (lookahead == 'o')
        ADVANCE(162);
      if (lookahead == 'u')
        ADVANCE(164);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_fi);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 380:
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(381);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(148);
      if (lookahead == 'e')
        ADVANCE(155);
      if (lookahead == 'f')
        ADVANCE(161);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(380);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 381:
      if (lookahead == '\n')
        SKIP(380);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 382:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(383);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(384);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(382);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '&')
        ADVANCE(31);
      END_STATE();
    case 384:
      if (lookahead == '\n')
        SKIP(382);
      END_STATE();
    case 385:
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(386);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(148);
      if (lookahead == 'e')
        ADVANCE(155);
      if (lookahead == 'f')
        ADVANCE(161);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(385);
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 386:
      if (lookahead == '\n')
        SKIP(385);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 387:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(359);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(388);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(387);
      END_STATE();
    case 388:
      if (lookahead == '\n')
        SKIP(387);
      END_STATE();
    case 389:
      if (lookahead == '!')
        ADVANCE(287);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '-')
        ADVANCE(288);
      if (lookahead == '<')
        ADVANCE(290);
      if (lookahead == '=')
        ADVANCE(36);
      if (lookahead == '>')
        ADVANCE(291);
      if (lookahead == '\\')
        SKIP(390);
      if (lookahead == '|')
        ADVANCE(293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(389);
      END_STATE();
    case 390:
      if (lookahead == '\n')
        SKIP(389);
      END_STATE();
    case 391:
      if (lookahead == '!')
        ADVANCE(392);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(337);
      if (lookahead == '$')
        ADVANCE(339);
      if (lookahead == '\'')
        ADVANCE(344);
      if (lookahead == '(')
        ADVANCE(393);
      if (lookahead == '-')
        ADVANCE(394);
      if (lookahead == '<')
        ADVANCE(347);
      if (lookahead == '>')
        ADVANCE(349);
      if (lookahead == '[')
        ADVANCE(351);
      if (lookahead == '\\')
        ADVANCE(352);
      if (lookahead == ']')
        ADVANCE(351);
      if (lookahead == '`')
        ADVANCE(355);
      if (lookahead == '{')
        ADVANCE(351);
      if (lookahead == '}')
        ADVANCE(351);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(391);
      if (('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '|')
        ADVANCE(342);
      if (lookahead != 0)
        ADVANCE(354);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '\\')
        ADVANCE(352);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(354);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '\\')
        ADVANCE(341);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(342);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(352);
      if (('\"' <= lookahead && lookahead <= '$') ||
          ('&' <= lookahead && lookahead <= ')') ||
          lookahead == ';' ||
          lookahead == '<' ||
          lookahead == '>' ||
          ('[' <= lookahead && lookahead <= ']') ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}'))
        ADVANCE(342);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(395);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(354);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_test_operator);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(395);
      END_STATE();
    case 396:
      if (lookahead == '!')
        ADVANCE(287);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '-')
        ADVANCE(288);
      if (lookahead == '<')
        ADVANCE(290);
      if (lookahead == '=')
        ADVANCE(36);
      if (lookahead == '>')
        ADVANCE(291);
      if (lookahead == '\\')
        SKIP(397);
      if (lookahead == ']')
        ADVANCE(296);
      if (lookahead == '|')
        ADVANCE(398);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(396);
      END_STATE();
    case 397:
      if (lookahead == '\n')
        SKIP(396);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|')
        ADVANCE(133);
      END_STATE();
    case 399:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(400);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(399);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 400:
      if (lookahead == '\n')
        SKIP(399);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 401:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(5);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '%')
        ADVANCE(304);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '-')
        ADVANCE(305);
      if (lookahead == ':')
        ADVANCE(306);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '=')
        ADVANCE(309);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(402);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(401);
      if (lookahead != 0 &&
          (lookahead < '\"' || lookahead > ')') &&
          (lookahead < ':' || lookahead > '>') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 402:
      if (lookahead == '\n')
        SKIP(401);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 403:
      if (lookahead == '#')
        ADVANCE(404);
      if (lookahead == '\\')
        ADVANCE(406);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(403);
      if (lookahead != 0 &&
          lookahead != '\"' &&
          lookahead != '#' &&
          lookahead != '}')
        ADVANCE(407);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(405);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '}')
        ADVANCE(404);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(405);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '}')
        ADVANCE(404);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(404);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(406);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == '}')
        ADVANCE(407);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n')
        ADVANCE(407);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_regex_without_right_brace);
      if (lookahead == '\\')
        ADVANCE(406);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          lookahead != '}')
        ADVANCE(407);
      END_STATE();
    case 408:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(359);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(409);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(408);
      END_STATE();
    case 409:
      if (lookahead == '\n')
        SKIP(408);
      END_STATE();
    case 410:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '<')
        ADVANCE(359);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(411);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(410);
      END_STATE();
    case 411:
      if (lookahead == '\n')
        SKIP(410);
      END_STATE();
    case 412:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(359);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(413);
      if (lookahead == 'e')
        ADVANCE(285);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(412);
      END_STATE();
    case 413:
      if (lookahead == '\n')
        SKIP(412);
      END_STATE();
    case 414:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(415);
      if (lookahead == ']')
        ADVANCE(211);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(414);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 415:
      if (lookahead == '\n')
        SKIP(414);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 416:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '+')
        ADVANCE(19);
      if (lookahead == '=')
        ADVANCE(208);
      if (lookahead == '\\')
        SKIP(417);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(416);
      END_STATE();
    case 417:
      if (lookahead == '\n')
        SKIP(416);
      END_STATE();
    case 418:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(419);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(418);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 419:
      if (lookahead == '\n')
        SKIP(418);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 420:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(275);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(421);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(420);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 421:
      if (lookahead == '\n')
        SKIP(420);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 422:
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(423);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(148);
      if (lookahead == 'e')
        ADVANCE(155);
      if (lookahead == 'f')
        ADVANCE(378);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(422);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 423:
      if (lookahead == '\n')
        SKIP(422);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 424:
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(425);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(426);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(424);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 425:
      if (lookahead == '\n')
        SKIP(424);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 's')
        ADVANCE(427);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'a')
        ADVANCE(428);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          lookahead != 'a' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'c')
        ADVANCE(429);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 430:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(383);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(431);
      if (lookahead == 'e')
        ADVANCE(285);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(430);
      END_STATE();
    case 431:
      if (lookahead == '\n')
        SKIP(430);
      END_STATE();
    case 432:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(383);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(433);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(432);
      END_STATE();
    case 433:
      if (lookahead == '\n')
        SKIP(432);
      END_STATE();
    case 434:
      if (lookahead == '!')
        ADVANCE(287);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '-')
        ADVANCE(288);
      if (lookahead == '<')
        ADVANCE(290);
      if (lookahead == '=')
        ADVANCE(36);
      if (lookahead == '>')
        ADVANCE(291);
      if (lookahead == '\\')
        SKIP(435);
      if (lookahead == ']')
        ADVANCE(296);
      if (lookahead == '|')
        ADVANCE(293);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(434);
      END_STATE();
    case 435:
      if (lookahead == '\n')
        SKIP(434);
      END_STATE();
    case 436:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '\\')
        SKIP(437);
      if (lookahead == '}')
        ADVANCE(134);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(436);
      END_STATE();
    case 437:
      if (lookahead == '\n')
        SKIP(436);
      END_STATE();
    case 438:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(383);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(439);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(438);
      END_STATE();
    case 439:
      if (lookahead == '\n')
        SKIP(438);
      END_STATE();
    case 440:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(359);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(441);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(440);
      END_STATE();
    case 441:
      if (lookahead == '\n')
        SKIP(440);
      END_STATE();
    case 442:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == '<')
        ADVANCE(383);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(443);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(442);
      END_STATE();
    case 443:
      if (lookahead == '\n')
        SKIP(442);
      END_STATE();
    case 444:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '\\')
        SKIP(445);
      if (lookahead == '|')
        ADVANCE(233);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(444);
      END_STATE();
    case 445:
      if (lookahead == '\n')
        SKIP(444);
      END_STATE();
    case 446:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(246);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '\\')
        SKIP(447);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(446);
      END_STATE();
    case 447:
      if (lookahead == '\n')
        SKIP(446);
      END_STATE();
    case 448:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(316);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '<')
        ADVANCE(383);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(449);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(448);
      END_STATE();
    case 449:
      if (lookahead == '\n')
        SKIP(448);
      END_STATE();
    case 450:
      if (lookahead == '!')
        ADVANCE(136);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(140);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(331);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(45);
      if (lookahead == '\\')
        ADVANCE(451);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'c')
        ADVANCE(144);
      if (lookahead == 'd')
        ADVANCE(148);
      if (lookahead == 'e')
        ADVANCE(452);
      if (lookahead == 'f')
        ADVANCE(161);
      if (lookahead == 'i')
        ADVANCE(171);
      if (lookahead == 'l')
        ADVANCE(173);
      if (lookahead == 'r')
        ADVANCE(178);
      if (lookahead == 't')
        ADVANCE(186);
      if (lookahead == 'u')
        ADVANCE(193);
      if (lookahead == 'w')
        ADVANCE(201);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(450);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')') &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 451:
      if (lookahead == '\n')
        SKIP(450);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 's')
        ADVANCE(427);
      if (lookahead == 'x')
        ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < '[' || lookahead > ']') &&
          lookahead != '`' &&
          (lookahead < '{' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 453:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(246);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '\\')
        SKIP(454);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(453);
      END_STATE();
    case 454:
      if (lookahead == '\n')
        SKIP(453);
      END_STATE();
    case 455:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == ')')
        ADVANCE(17);
      if (lookahead == '\\')
        SKIP(456);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(455);
      END_STATE();
    case 456:
      if (lookahead == '\n')
        SKIP(455);
      END_STATE();
    case 457:
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(207);
      if (lookahead == '\\')
        SKIP(458);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(457);
      END_STATE();
    case 458:
      if (lookahead == '\n')
        SKIP(457);
      END_STATE();
    case 459:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(246);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(241);
      if (lookahead == '>')
        ADVANCE(242);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(460);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(461);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(459);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 460:
      if (lookahead == '\n')
        SKIP(459);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 's')
        ADVANCE(462);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'a')
        ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(aux_sym_SLASH_BSLASHw_PLUS_SLASH);
      if (lookahead == '\\')
        ADVANCE(137);
      if (lookahead == 'c')
        ADVANCE(464);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_esac);
      if (lookahead == '\\')
        ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z'))
        ADVANCE(248);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ' &&
          (lookahead < '\"' || lookahead > '$') &&
          (lookahead < '&' || lookahead > ')') &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          (lookahead < 'A' || lookahead > ']') &&
          (lookahead < '_' || lookahead > '}'))
        ADVANCE(138);
      END_STATE();
    case 465:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(466);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(426);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(465);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 466:
      if (lookahead == '\n')
        SKIP(465);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 467:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == '(')
        ADVANCE(16);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(30);
      if (lookahead == '=')
        ADVANCE(250);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(468);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(426);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(467);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 468:
      if (lookahead == '\n')
        SKIP(467);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 469:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '\"')
        ADVANCE(4);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '$')
        ADVANCE(6);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == '\'')
        ADVANCE(14);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(141);
      if (lookahead == '>')
        ADVANCE(39);
      if (lookahead == '[')
        ADVANCE(143);
      if (lookahead == '\\')
        ADVANCE(470);
      if (lookahead == ']')
        ADVANCE(143);
      if (lookahead == '`')
        ADVANCE(51);
      if (lookahead == 'e')
        ADVANCE(426);
      if (lookahead == '{')
        ADVANCE(143);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '}')
        ADVANCE(143);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(469);
      if (lookahead != 0 &&
          (lookahead < '&' || lookahead > ')'))
        ADVANCE(138);
      END_STATE();
    case 470:
      if (lookahead == '\n')
        SKIP(469);
      if (lookahead != 0 &&
          lookahead != '\t' &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ' ')
        ADVANCE(138);
      END_STATE();
    case 471:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(359);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(472);
      if (lookahead == 'e')
        ADVANCE(285);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(471);
      END_STATE();
    case 472:
      if (lookahead == '\n')
        SKIP(471);
      END_STATE();
    case 473:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(10);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '<')
        ADVANCE(383);
      if (lookahead == '>')
        ADVANCE(360);
      if (lookahead == '\\')
        SKIP(474);
      if (lookahead == 'e')
        ADVANCE(285);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(473);
      END_STATE();
    case 474:
      if (lookahead == '\n')
        SKIP(473);
      END_STATE();
    case 475:
      if (lookahead == '\n')
        ADVANCE(245);
      if (lookahead == '#')
        ADVANCE(139);
      if (lookahead == '&')
        ADVANCE(246);
      if (lookahead == ';')
        ADVANCE(28);
      if (lookahead == '\\')
        SKIP(476);
      if (lookahead == 'e')
        ADVANCE(285);
      if (lookahead == '|')
        ADVANCE(131);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ')
        SKIP(475);
      END_STATE();
    case 476:
      if (lookahead == '\n')
        SKIP(475);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 135, .external_lex_state = 2},
  [2] = {.lex_state = 135},
  [3] = {.lex_state = 206},
  [4] = {.lex_state = 231},
  [5] = {.lex_state = 135, .external_lex_state = 2},
  [6] = {.lex_state = 135, .external_lex_state = 2},
  [7] = {.lex_state = 234},
  [8] = {.lex_state = 234},
  [9] = {.lex_state = 135, .external_lex_state = 2},
  [10] = {.lex_state = 236, .external_lex_state = 2},
  [11] = {.lex_state = 238},
  [12] = {.lex_state = 238},
  [13] = {.lex_state = 244, .external_lex_state = 3},
  [14] = {.lex_state = 244, .external_lex_state = 4},
  [15] = {.lex_state = 234},
  [16] = {.lex_state = 249, .external_lex_state = 5},
  [17] = {.lex_state = 254},
  [18] = {.lex_state = 261},
  [19] = {.lex_state = 249, .external_lex_state = 5},
  [20] = {.lex_state = 264, .external_lex_state = 6},
  [21] = {.lex_state = 135, .external_lex_state = 2},
  [22] = {.lex_state = 135, .external_lex_state = 2},
  [23] = {.lex_state = 135, .external_lex_state = 2},
  [24] = {.lex_state = 266, .external_lex_state = 5},
  [25] = {.lex_state = 135},
  [26] = {.lex_state = 244, .external_lex_state = 4},
  [27] = {.lex_state = 249, .external_lex_state = 7},
  [28] = {.lex_state = 268, .external_lex_state = 8},
  [29] = {.lex_state = 206},
  [30] = {.lex_state = 234, .external_lex_state = 2},
  [31] = {.lex_state = 270, .external_lex_state = 7},
  [32] = {.lex_state = 135, .external_lex_state = 2},
  [33] = {.lex_state = 234, .external_lex_state = 2},
  [34] = {.lex_state = 234},
  [35] = {.lex_state = 234},
  [36] = {.lex_state = 272, .external_lex_state = 9},
  [37] = {.lex_state = 274, .external_lex_state = 4},
  [38] = {.lex_state = 206},
  [39] = {.lex_state = 244, .external_lex_state = 4},
  [40] = {.lex_state = 268, .external_lex_state = 8},
  [41] = {.lex_state = 206},
  [42] = {.lex_state = 274, .external_lex_state = 10},
  [43] = {.lex_state = 254},
  [44] = {.lex_state = 261},
  [45] = {.lex_state = 274, .external_lex_state = 10},
  [46] = {.lex_state = 264, .external_lex_state = 6},
  [47] = {.lex_state = 135, .external_lex_state = 2},
  [48] = {.lex_state = 135, .external_lex_state = 2},
  [49] = {.lex_state = 135, .external_lex_state = 2},
  [50] = {.lex_state = 274, .external_lex_state = 4},
  [51] = {.lex_state = 206},
  [52] = {.lex_state = 206},
  [53] = {.lex_state = 135, .external_lex_state = 2},
  [54] = {.lex_state = 234},
  [55] = {.lex_state = 236, .external_lex_state = 2},
  [56] = {.lex_state = 238},
  [57] = {.lex_state = 238},
  [58] = {.lex_state = 277, .external_lex_state = 3},
  [59] = {.lex_state = 277, .external_lex_state = 4},
  [60] = {.lex_state = 270, .external_lex_state = 5},
  [61] = {.lex_state = 270, .external_lex_state = 5},
  [62] = {.lex_state = 279, .external_lex_state = 5},
  [63] = {.lex_state = 277, .external_lex_state = 4},
  [64] = {.lex_state = 270, .external_lex_state = 7},
  [65] = {.lex_state = 281, .external_lex_state = 8},
  [66] = {.lex_state = 206},
  [67] = {.lex_state = 135, .external_lex_state = 2},
  [68] = {.lex_state = 234, .external_lex_state = 2},
  [69] = {.lex_state = 206},
  [70] = {.lex_state = 283, .external_lex_state = 4},
  [71] = {.lex_state = 206},
  [72] = {.lex_state = 238},
  [73] = {.lex_state = 238},
  [74] = {.lex_state = 286, .external_lex_state = 11},
  [75] = {.lex_state = 254},
  [76] = {.lex_state = 261},
  [77] = {.lex_state = 286, .external_lex_state = 11},
  [78] = {.lex_state = 264, .external_lex_state = 6},
  [79] = {.lex_state = 135, .external_lex_state = 2},
  [80] = {.lex_state = 135, .external_lex_state = 2},
  [81] = {.lex_state = 135, .external_lex_state = 2},
  [82] = {.lex_state = 286, .external_lex_state = 12},
  [83] = {.lex_state = 238},
  [84] = {.lex_state = 238},
  [85] = {.lex_state = 294, .external_lex_state = 13},
  [86] = {.lex_state = 254},
  [87] = {.lex_state = 261},
  [88] = {.lex_state = 294, .external_lex_state = 13},
  [89] = {.lex_state = 264, .external_lex_state = 6},
  [90] = {.lex_state = 135, .external_lex_state = 2},
  [91] = {.lex_state = 135, .external_lex_state = 2},
  [92] = {.lex_state = 135, .external_lex_state = 2},
  [93] = {.lex_state = 294},
  [94] = {.lex_state = 206},
  [95] = {.lex_state = 244, .external_lex_state = 14},
  [96] = {.lex_state = 254},
  [97] = {.lex_state = 261},
  [98] = {.lex_state = 244, .external_lex_state = 14},
  [99] = {.lex_state = 264, .external_lex_state = 6},
  [100] = {.lex_state = 135, .external_lex_state = 2},
  [101] = {.lex_state = 135, .external_lex_state = 2},
  [102] = {.lex_state = 135, .external_lex_state = 2},
  [103] = {.lex_state = 277, .external_lex_state = 3},
  [104] = {.lex_state = 206},
  [105] = {.lex_state = 244, .external_lex_state = 3},
  [106] = {.lex_state = 244, .external_lex_state = 10},
  [107] = {.lex_state = 254},
  [108] = {.lex_state = 261},
  [109] = {.lex_state = 244, .external_lex_state = 10},
  [110] = {.lex_state = 264, .external_lex_state = 6},
  [111] = {.lex_state = 135, .external_lex_state = 2},
  [112] = {.lex_state = 135, .external_lex_state = 2},
  [113] = {.lex_state = 135, .external_lex_state = 2},
  [114] = {.lex_state = 277, .external_lex_state = 4},
  [115] = {.lex_state = 244, .external_lex_state = 4},
  [116] = {.lex_state = 234, .external_lex_state = 15},
  [117] = {.lex_state = 254},
  [118] = {.lex_state = 261},
  [119] = {.lex_state = 234, .external_lex_state = 15},
  [120] = {.lex_state = 264, .external_lex_state = 6},
  [121] = {.lex_state = 135, .external_lex_state = 2},
  [122] = {.lex_state = 135, .external_lex_state = 2},
  [123] = {.lex_state = 135, .external_lex_state = 2},
  [124] = {.lex_state = 234, .external_lex_state = 2},
  [125] = {.lex_state = 234},
  [126] = {.lex_state = 249, .external_lex_state = 5},
  [127] = {.lex_state = 270, .external_lex_state = 5},
  [128] = {.lex_state = 297},
  [129] = {.lex_state = 254, .external_lex_state = 13},
  [130] = {.lex_state = 264, .external_lex_state = 6},
  [131] = {.lex_state = 135, .external_lex_state = 2},
  [132] = {.lex_state = 135, .external_lex_state = 2},
  [133] = {.lex_state = 254},
  [134] = {.lex_state = 270, .external_lex_state = 5},
  [135] = {.lex_state = 270, .external_lex_state = 5},
  [136] = {.lex_state = 270, .external_lex_state = 5},
  [137] = {.lex_state = 206},
  [138] = {.lex_state = 303, .external_lex_state = 16},
  [139] = {.lex_state = 311, .external_lex_state = 6},
  [140] = {.lex_state = 303, .external_lex_state = 16},
  [141] = {.lex_state = 303, .external_lex_state = 16},
  [142] = {.lex_state = 206},
  [143] = {.lex_state = 231},
  [144] = {.lex_state = 135, .external_lex_state = 2},
  [145] = {.lex_state = 135, .external_lex_state = 2},
  [146] = {.lex_state = 234},
  [147] = {.lex_state = 234},
  [148] = {.lex_state = 135, .external_lex_state = 2},
  [149] = {.lex_state = 236, .external_lex_state = 2},
  [150] = {.lex_state = 238},
  [151] = {.lex_state = 238},
  [152] = {.lex_state = 313, .external_lex_state = 6},
  [153] = {.lex_state = 313},
  [154] = {.lex_state = 315, .external_lex_state = 17},
  [155] = {.lex_state = 254},
  [156] = {.lex_state = 261},
  [157] = {.lex_state = 315, .external_lex_state = 17},
  [158] = {.lex_state = 264, .external_lex_state = 6},
  [159] = {.lex_state = 135, .external_lex_state = 2},
  [160] = {.lex_state = 135, .external_lex_state = 2},
  [161] = {.lex_state = 135, .external_lex_state = 2},
  [162] = {.lex_state = 318, .external_lex_state = 17},
  [163] = {.lex_state = 206},
  [164] = {.lex_state = 315, .external_lex_state = 18},
  [165] = {.lex_state = 320, .external_lex_state = 2},
  [166] = {.lex_state = 206},
  [167] = {.lex_state = 315, .external_lex_state = 18},
  [168] = {.lex_state = 234, .external_lex_state = 2},
  [169] = {.lex_state = 206},
  [170] = {.lex_state = 135, .external_lex_state = 2},
  [171] = {.lex_state = 234},
  [172] = {.lex_state = 236, .external_lex_state = 2},
  [173] = {.lex_state = 238},
  [174] = {.lex_state = 238},
  [175] = {.lex_state = 322, .external_lex_state = 6},
  [176] = {.lex_state = 313},
  [177] = {.lex_state = 324, .external_lex_state = 17},
  [178] = {.lex_state = 324, .external_lex_state = 17},
  [179] = {.lex_state = 326, .external_lex_state = 17},
  [180] = {.lex_state = 206},
  [181] = {.lex_state = 324, .external_lex_state = 18},
  [182] = {.lex_state = 328, .external_lex_state = 2},
  [183] = {.lex_state = 206},
  [184] = {.lex_state = 234, .external_lex_state = 2},
  [185] = {.lex_state = 206},
  [186] = {.lex_state = 320, .external_lex_state = 2},
  [187] = {.lex_state = 206},
  [188] = {.lex_state = 135, .external_lex_state = 2},
  [189] = {.lex_state = 330, .external_lex_state = 2},
  [190] = {.lex_state = 135, .external_lex_state = 2},
  [191] = {.lex_state = 283, .external_lex_state = 4},
  [192] = {.lex_state = 333, .external_lex_state = 19},
  [193] = {.lex_state = 135},
  [194] = {.lex_state = 336},
  [195] = {.lex_state = 234},
  [196] = {.lex_state = 356, .external_lex_state = 20},
  [197] = {.lex_state = 234},
  [198] = {.lex_state = 249, .external_lex_state = 5},
  [199] = {.lex_state = 249, .external_lex_state = 5},
  [200] = {.lex_state = 283, .external_lex_state = 4},
  [201] = {.lex_state = 358, .external_lex_state = 7},
  [202] = {.lex_state = 249, .external_lex_state = 7},
  [203] = {.lex_state = 135, .external_lex_state = 2},
  [204] = {.lex_state = 249, .external_lex_state = 7},
  [205] = {.lex_state = 234, .external_lex_state = 2},
  [206] = {.lex_state = 234, .external_lex_state = 15},
  [207] = {.lex_state = 234, .external_lex_state = 15},
  [208] = {.lex_state = 234, .external_lex_state = 2},
  [209] = {.lex_state = 362, .external_lex_state = 11},
  [210] = {.lex_state = 362, .external_lex_state = 11},
  [211] = {.lex_state = 362, .external_lex_state = 11},
  [212] = {.lex_state = 281, .external_lex_state = 8},
  [213] = {.lex_state = 320},
  [214] = {.lex_state = 268, .external_lex_state = 21},
  [215] = {.lex_state = 254},
  [216] = {.lex_state = 261},
  [217] = {.lex_state = 268, .external_lex_state = 21},
  [218] = {.lex_state = 264, .external_lex_state = 6},
  [219] = {.lex_state = 135, .external_lex_state = 2},
  [220] = {.lex_state = 135, .external_lex_state = 2},
  [221] = {.lex_state = 135, .external_lex_state = 2},
  [222] = {.lex_state = 234},
  [223] = {.lex_state = 206},
  [224] = {.lex_state = 364, .external_lex_state = 2},
  [225] = {.lex_state = 358, .external_lex_state = 7},
  [226] = {.lex_state = 206},
  [227] = {.lex_state = 370, .external_lex_state = 2},
  [228] = {.lex_state = 234},
  [229] = {.lex_state = 274, .external_lex_state = 4},
  [230] = {.lex_state = 206},
  [231] = {.lex_state = 274, .external_lex_state = 10},
  [232] = {.lex_state = 274, .external_lex_state = 10},
  [233] = {.lex_state = 254},
  [234] = {.lex_state = 274, .external_lex_state = 10},
  [235] = {.lex_state = 274, .external_lex_state = 10},
  [236] = {.lex_state = 274, .external_lex_state = 10},
  [237] = {.lex_state = 274, .external_lex_state = 4},
  [238] = {.lex_state = 206},
  [239] = {.lex_state = 206},
  [240] = {.lex_state = 303, .external_lex_state = 16},
  [241] = {.lex_state = 311, .external_lex_state = 6},
  [242] = {.lex_state = 303, .external_lex_state = 16},
  [243] = {.lex_state = 303, .external_lex_state = 16},
  [244] = {.lex_state = 206},
  [245] = {.lex_state = 320, .external_lex_state = 2},
  [246] = {.lex_state = 206},
  [247] = {.lex_state = 328, .external_lex_state = 2},
  [248] = {.lex_state = 206},
  [249] = {.lex_state = 320, .external_lex_state = 2},
  [250] = {.lex_state = 206},
  [251] = {.lex_state = 380, .external_lex_state = 22},
  [252] = {.lex_state = 382, .external_lex_state = 23},
  [253] = {.lex_state = 272, .external_lex_state = 9},
  [254] = {.lex_state = 206},
  [255] = {.lex_state = 206},
  [256] = {.lex_state = 286, .external_lex_state = 12},
  [257] = {.lex_state = 294},
  [258] = {.lex_state = 206},
  [259] = {.lex_state = 277, .external_lex_state = 14},
  [260] = {.lex_state = 277, .external_lex_state = 14},
  [261] = {.lex_state = 206},
  [262] = {.lex_state = 277, .external_lex_state = 3},
  [263] = {.lex_state = 277, .external_lex_state = 10},
  [264] = {.lex_state = 277, .external_lex_state = 10},
  [265] = {.lex_state = 277, .external_lex_state = 4},
  [266] = {.lex_state = 270, .external_lex_state = 5},
  [267] = {.lex_state = 206},
  [268] = {.lex_state = 135, .external_lex_state = 2},
  [269] = {.lex_state = 283, .external_lex_state = 4},
  [270] = {.lex_state = 385, .external_lex_state = 2},
  [271] = {.lex_state = 135, .external_lex_state = 2},
  [272] = {.lex_state = 135},
  [273] = {.lex_state = 336},
  [274] = {.lex_state = 234},
  [275] = {.lex_state = 234},
  [276] = {.lex_state = 270, .external_lex_state = 5},
  [277] = {.lex_state = 270, .external_lex_state = 5},
  [278] = {.lex_state = 387, .external_lex_state = 7},
  [279] = {.lex_state = 270, .external_lex_state = 7},
  [280] = {.lex_state = 277, .external_lex_state = 4},
  [281] = {.lex_state = 281, .external_lex_state = 8},
  [282] = {.lex_state = 135, .external_lex_state = 2},
  [283] = {.lex_state = 270, .external_lex_state = 7},
  [284] = {.lex_state = 272, .external_lex_state = 9},
  [285] = {.lex_state = 238},
  [286] = {.lex_state = 389, .external_lex_state = 13},
  [287] = {.lex_state = 389, .external_lex_state = 13},
  [288] = {.lex_state = 389},
  [289] = {.lex_state = 286, .external_lex_state = 12},
  [290] = {.lex_state = 234},
  [291] = {.lex_state = 286, .external_lex_state = 11},
  [292] = {.lex_state = 286, .external_lex_state = 11},
  [293] = {.lex_state = 254},
  [294] = {.lex_state = 286, .external_lex_state = 11},
  [295] = {.lex_state = 286, .external_lex_state = 11},
  [296] = {.lex_state = 286, .external_lex_state = 11},
  [297] = {.lex_state = 206},
  [298] = {.lex_state = 303, .external_lex_state = 16},
  [299] = {.lex_state = 311, .external_lex_state = 6},
  [300] = {.lex_state = 303, .external_lex_state = 16},
  [301] = {.lex_state = 303, .external_lex_state = 16},
  [302] = {.lex_state = 206},
  [303] = {.lex_state = 320, .external_lex_state = 2},
  [304] = {.lex_state = 206},
  [305] = {.lex_state = 328, .external_lex_state = 2},
  [306] = {.lex_state = 206},
  [307] = {.lex_state = 320, .external_lex_state = 2},
  [308] = {.lex_state = 238},
  [309] = {.lex_state = 358, .external_lex_state = 23},
  [310] = {.lex_state = 391},
  [311] = {.lex_state = 389},
  [312] = {.lex_state = 294},
  [313] = {.lex_state = 234},
  [314] = {.lex_state = 294, .external_lex_state = 13},
  [315] = {.lex_state = 396, .external_lex_state = 13},
  [316] = {.lex_state = 254},
  [317] = {.lex_state = 396, .external_lex_state = 13},
  [318] = {.lex_state = 396, .external_lex_state = 13},
  [319] = {.lex_state = 396, .external_lex_state = 13},
  [320] = {.lex_state = 206},
  [321] = {.lex_state = 303, .external_lex_state = 16},
  [322] = {.lex_state = 311, .external_lex_state = 6},
  [323] = {.lex_state = 303, .external_lex_state = 16},
  [324] = {.lex_state = 303, .external_lex_state = 16},
  [325] = {.lex_state = 206},
  [326] = {.lex_state = 320, .external_lex_state = 2},
  [327] = {.lex_state = 206},
  [328] = {.lex_state = 328, .external_lex_state = 2},
  [329] = {.lex_state = 206},
  [330] = {.lex_state = 320, .external_lex_state = 2},
  [331] = {.lex_state = 238},
  [332] = {.lex_state = 391},
  [333] = {.lex_state = 272, .external_lex_state = 9},
  [334] = {.lex_state = 234},
  [335] = {.lex_state = 244, .external_lex_state = 14},
  [336] = {.lex_state = 277, .external_lex_state = 14},
  [337] = {.lex_state = 254},
  [338] = {.lex_state = 277, .external_lex_state = 14},
  [339] = {.lex_state = 277, .external_lex_state = 14},
  [340] = {.lex_state = 277, .external_lex_state = 14},
  [341] = {.lex_state = 206},
  [342] = {.lex_state = 303, .external_lex_state = 16},
  [343] = {.lex_state = 311, .external_lex_state = 6},
  [344] = {.lex_state = 303, .external_lex_state = 16},
  [345] = {.lex_state = 303, .external_lex_state = 16},
  [346] = {.lex_state = 206},
  [347] = {.lex_state = 320, .external_lex_state = 2},
  [348] = {.lex_state = 206},
  [349] = {.lex_state = 328, .external_lex_state = 2},
  [350] = {.lex_state = 206},
  [351] = {.lex_state = 320, .external_lex_state = 2},
  [352] = {.lex_state = 244, .external_lex_state = 3},
  [353] = {.lex_state = 234},
  [354] = {.lex_state = 244, .external_lex_state = 10},
  [355] = {.lex_state = 277, .external_lex_state = 10},
  [356] = {.lex_state = 254},
  [357] = {.lex_state = 277, .external_lex_state = 10},
  [358] = {.lex_state = 277, .external_lex_state = 10},
  [359] = {.lex_state = 277, .external_lex_state = 10},
  [360] = {.lex_state = 206},
  [361] = {.lex_state = 303, .external_lex_state = 16},
  [362] = {.lex_state = 311, .external_lex_state = 6},
  [363] = {.lex_state = 303, .external_lex_state = 16},
  [364] = {.lex_state = 303, .external_lex_state = 16},
  [365] = {.lex_state = 206},
  [366] = {.lex_state = 320, .external_lex_state = 2},
  [367] = {.lex_state = 206},
  [368] = {.lex_state = 328, .external_lex_state = 2},
  [369] = {.lex_state = 206},
  [370] = {.lex_state = 320, .external_lex_state = 2},
  [371] = {.lex_state = 244, .external_lex_state = 4},
  [372] = {.lex_state = 234},
  [373] = {.lex_state = 234, .external_lex_state = 15},
  [374] = {.lex_state = 320, .external_lex_state = 15},
  [375] = {.lex_state = 254},
  [376] = {.lex_state = 320, .external_lex_state = 15},
  [377] = {.lex_state = 320, .external_lex_state = 15},
  [378] = {.lex_state = 320, .external_lex_state = 15},
  [379] = {.lex_state = 206},
  [380] = {.lex_state = 303, .external_lex_state = 16},
  [381] = {.lex_state = 311, .external_lex_state = 6},
  [382] = {.lex_state = 303, .external_lex_state = 16},
  [383] = {.lex_state = 303, .external_lex_state = 16},
  [384] = {.lex_state = 206},
  [385] = {.lex_state = 320, .external_lex_state = 2},
  [386] = {.lex_state = 206},
  [387] = {.lex_state = 328, .external_lex_state = 2},
  [388] = {.lex_state = 206},
  [389] = {.lex_state = 320, .external_lex_state = 2},
  [390] = {.lex_state = 270, .external_lex_state = 5},
  [391] = {.lex_state = 249, .external_lex_state = 5},
  [392] = {.lex_state = 254, .external_lex_state = 13},
  [393] = {.lex_state = 254, .external_lex_state = 13},
  [394] = {.lex_state = 254, .external_lex_state = 13},
  [395] = {.lex_state = 254},
  [396] = {.lex_state = 206},
  [397] = {.lex_state = 303, .external_lex_state = 16},
  [398] = {.lex_state = 311, .external_lex_state = 6},
  [399] = {.lex_state = 303, .external_lex_state = 16},
  [400] = {.lex_state = 303, .external_lex_state = 16},
  [401] = {.lex_state = 206},
  [402] = {.lex_state = 320, .external_lex_state = 2},
  [403] = {.lex_state = 206},
  [404] = {.lex_state = 328, .external_lex_state = 2},
  [405] = {.lex_state = 270, .external_lex_state = 5},
  [406] = {.lex_state = 254},
  [407] = {.lex_state = 234},
  [408] = {.lex_state = 399, .external_lex_state = 16},
  [409] = {.lex_state = 270, .external_lex_state = 5},
  [410] = {.lex_state = 401, .external_lex_state = 24},
  [411] = {.lex_state = 254},
  [412] = {.lex_state = 261},
  [413] = {.lex_state = 401, .external_lex_state = 24},
  [414] = {.lex_state = 264, .external_lex_state = 6},
  [415] = {.lex_state = 403},
  [416] = {.lex_state = 135, .external_lex_state = 2},
  [417] = {.lex_state = 135, .external_lex_state = 2},
  [418] = {.lex_state = 135, .external_lex_state = 2},
  [419] = {.lex_state = 401, .external_lex_state = 16},
  [420] = {.lex_state = 206},
  [421] = {.lex_state = 303, .external_lex_state = 16},
  [422] = {.lex_state = 303, .external_lex_state = 16},
  [423] = {.lex_state = 303, .external_lex_state = 16},
  [424] = {.lex_state = 270, .external_lex_state = 5},
  [425] = {.lex_state = 403},
  [426] = {.lex_state = 401, .external_lex_state = 16},
  [427] = {.lex_state = 270, .external_lex_state = 5},
  [428] = {.lex_state = 403},
  [429] = {.lex_state = 401, .external_lex_state = 16},
  [430] = {.lex_state = 272, .external_lex_state = 9},
  [431] = {.lex_state = 274, .external_lex_state = 4},
  [432] = {.lex_state = 206},
  [433] = {.lex_state = 206},
  [434] = {.lex_state = 274, .external_lex_state = 10},
  [435] = {.lex_state = 274, .external_lex_state = 10},
  [436] = {.lex_state = 274, .external_lex_state = 4},
  [437] = {.lex_state = 206},
  [438] = {.lex_state = 277, .external_lex_state = 4},
  [439] = {.lex_state = 281, .external_lex_state = 8},
  [440] = {.lex_state = 135, .external_lex_state = 2},
  [441] = {.lex_state = 206},
  [442] = {.lex_state = 286, .external_lex_state = 12},
  [443] = {.lex_state = 294},
  [444] = {.lex_state = 206},
  [445] = {.lex_state = 313, .external_lex_state = 25},
  [446] = {.lex_state = 254},
  [447] = {.lex_state = 261},
  [448] = {.lex_state = 313, .external_lex_state = 25},
  [449] = {.lex_state = 264, .external_lex_state = 6},
  [450] = {.lex_state = 135, .external_lex_state = 2},
  [451] = {.lex_state = 135, .external_lex_state = 2},
  [452] = {.lex_state = 135, .external_lex_state = 2},
  [453] = {.lex_state = 313, .external_lex_state = 6},
  [454] = {.lex_state = 206},
  [455] = {.lex_state = 313, .external_lex_state = 6},
  [456] = {.lex_state = 313, .external_lex_state = 13},
  [457] = {.lex_state = 254},
  [458] = {.lex_state = 261},
  [459] = {.lex_state = 313, .external_lex_state = 13},
  [460] = {.lex_state = 264, .external_lex_state = 6},
  [461] = {.lex_state = 135, .external_lex_state = 2},
  [462] = {.lex_state = 135, .external_lex_state = 2},
  [463] = {.lex_state = 135, .external_lex_state = 2},
  [464] = {.lex_state = 313},
  [465] = {.lex_state = 313},
  [466] = {.lex_state = 234},
  [467] = {.lex_state = 315, .external_lex_state = 17},
  [468] = {.lex_state = 315, .external_lex_state = 17},
  [469] = {.lex_state = 254},
  [470] = {.lex_state = 315, .external_lex_state = 17},
  [471] = {.lex_state = 315, .external_lex_state = 17},
  [472] = {.lex_state = 315, .external_lex_state = 17},
  [473] = {.lex_state = 206},
  [474] = {.lex_state = 303, .external_lex_state = 16},
  [475] = {.lex_state = 311, .external_lex_state = 6},
  [476] = {.lex_state = 303, .external_lex_state = 16},
  [477] = {.lex_state = 303, .external_lex_state = 16},
  [478] = {.lex_state = 206},
  [479] = {.lex_state = 320, .external_lex_state = 2},
  [480] = {.lex_state = 206},
  [481] = {.lex_state = 328, .external_lex_state = 2},
  [482] = {.lex_state = 206},
  [483] = {.lex_state = 320, .external_lex_state = 2},
  [484] = {.lex_state = 206},
  [485] = {.lex_state = 135, .external_lex_state = 2},
  [486] = {.lex_state = 270, .external_lex_state = 5},
  [487] = {.lex_state = 135, .external_lex_state = 2},
  [488] = {.lex_state = 206},
  [489] = {.lex_state = 333, .external_lex_state = 19},
  [490] = {.lex_state = 135},
  [491] = {.lex_state = 336},
  [492] = {.lex_state = 234},
  [493] = {.lex_state = 356, .external_lex_state = 20},
  [494] = {.lex_state = 234},
  [495] = {.lex_state = 315, .external_lex_state = 17},
  [496] = {.lex_state = 315, .external_lex_state = 17},
  [497] = {.lex_state = 206},
  [498] = {.lex_state = 408, .external_lex_state = 18},
  [499] = {.lex_state = 315, .external_lex_state = 18},
  [500] = {.lex_state = 315, .external_lex_state = 18},
  [501] = {.lex_state = 272, .external_lex_state = 9},
  [502] = {.lex_state = 206},
  [503] = {.lex_state = 206},
  [504] = {.lex_state = 286, .external_lex_state = 12},
  [505] = {.lex_state = 294},
  [506] = {.lex_state = 206},
  [507] = {.lex_state = 322, .external_lex_state = 25},
  [508] = {.lex_state = 322, .external_lex_state = 25},
  [509] = {.lex_state = 206},
  [510] = {.lex_state = 322, .external_lex_state = 6},
  [511] = {.lex_state = 322, .external_lex_state = 13},
  [512] = {.lex_state = 322, .external_lex_state = 13},
  [513] = {.lex_state = 313},
  [514] = {.lex_state = 324, .external_lex_state = 17},
  [515] = {.lex_state = 206},
  [516] = {.lex_state = 135, .external_lex_state = 2},
  [517] = {.lex_state = 135, .external_lex_state = 2},
  [518] = {.lex_state = 135},
  [519] = {.lex_state = 336},
  [520] = {.lex_state = 234},
  [521] = {.lex_state = 234},
  [522] = {.lex_state = 324, .external_lex_state = 17},
  [523] = {.lex_state = 324, .external_lex_state = 17},
  [524] = {.lex_state = 410, .external_lex_state = 18},
  [525] = {.lex_state = 324, .external_lex_state = 18},
  [526] = {.lex_state = 324, .external_lex_state = 18},
  [527] = {.lex_state = 270, .external_lex_state = 5},
  [528] = {.lex_state = 206},
  [529] = {.lex_state = 283, .external_lex_state = 4},
  [530] = {.lex_state = 281, .external_lex_state = 8},
  [531] = {.lex_state = 244, .external_lex_state = 4},
  [532] = {.lex_state = 268, .external_lex_state = 8},
  [533] = {.lex_state = 283, .external_lex_state = 4},
  [534] = {.lex_state = 261},
  [535] = {.lex_state = 264, .external_lex_state = 6},
  [536] = {.lex_state = 333, .external_lex_state = 19},
  [537] = {.lex_state = 234},
  [538] = {.lex_state = 249, .external_lex_state = 5},
  [539] = {.lex_state = 249, .external_lex_state = 5},
  [540] = {.lex_state = 270, .external_lex_state = 7},
  [541] = {.lex_state = 358, .external_lex_state = 5},
  [542] = {.lex_state = 358, .external_lex_state = 5},
  [543] = {.lex_state = 412, .external_lex_state = 7},
  [544] = {.lex_state = 412, .external_lex_state = 7},
  [545] = {.lex_state = 358, .external_lex_state = 5},
  [546] = {.lex_state = 358, .external_lex_state = 5},
  [547] = {.lex_state = 412, .external_lex_state = 7},
  [548] = {.lex_state = 283, .external_lex_state = 4},
  [549] = {.lex_state = 358, .external_lex_state = 7},
  [550] = {.lex_state = 358, .external_lex_state = 7},
  [551] = {.lex_state = 249, .external_lex_state = 7},
  [552] = {.lex_state = 249, .external_lex_state = 7},
  [553] = {.lex_state = 414, .external_lex_state = 12},
  [554] = {.lex_state = 416, .external_lex_state = 13},
  [555] = {.lex_state = 362, .external_lex_state = 11},
  [556] = {.lex_state = 414, .external_lex_state = 12},
  [557] = {.lex_state = 416, .external_lex_state = 13},
  [558] = {.lex_state = 206, .external_lex_state = 12},
  [559] = {.lex_state = 281, .external_lex_state = 8},
  [560] = {.lex_state = 418, .external_lex_state = 13},
  [561] = {.lex_state = 254},
  [562] = {.lex_state = 261},
  [563] = {.lex_state = 418, .external_lex_state = 13},
  [564] = {.lex_state = 264, .external_lex_state = 6},
  [565] = {.lex_state = 135, .external_lex_state = 2},
  [566] = {.lex_state = 135, .external_lex_state = 2},
  [567] = {.lex_state = 135, .external_lex_state = 2},
  [568] = {.lex_state = 320},
  [569] = {.lex_state = 234},
  [570] = {.lex_state = 268, .external_lex_state = 21},
  [571] = {.lex_state = 281, .external_lex_state = 21},
  [572] = {.lex_state = 254},
  [573] = {.lex_state = 281, .external_lex_state = 21},
  [574] = {.lex_state = 281, .external_lex_state = 21},
  [575] = {.lex_state = 281, .external_lex_state = 21},
  [576] = {.lex_state = 206},
  [577] = {.lex_state = 303, .external_lex_state = 16},
  [578] = {.lex_state = 311, .external_lex_state = 6},
  [579] = {.lex_state = 303, .external_lex_state = 16},
  [580] = {.lex_state = 303, .external_lex_state = 16},
  [581] = {.lex_state = 206},
  [582] = {.lex_state = 320, .external_lex_state = 2},
  [583] = {.lex_state = 206},
  [584] = {.lex_state = 328, .external_lex_state = 2},
  [585] = {.lex_state = 206},
  [586] = {.lex_state = 320, .external_lex_state = 2},
  [587] = {.lex_state = 420, .external_lex_state = 10},
  [588] = {.lex_state = 254},
  [589] = {.lex_state = 261},
  [590] = {.lex_state = 420, .external_lex_state = 10},
  [591] = {.lex_state = 264, .external_lex_state = 6},
  [592] = {.lex_state = 135, .external_lex_state = 2},
  [593] = {.lex_state = 135, .external_lex_state = 2},
  [594] = {.lex_state = 135, .external_lex_state = 2},
  [595] = {.lex_state = 420, .external_lex_state = 4},
  [596] = {.lex_state = 364, .external_lex_state = 2},
  [597] = {.lex_state = 283, .external_lex_state = 4},
  [598] = {.lex_state = 412, .external_lex_state = 7},
  [599] = {.lex_state = 244, .external_lex_state = 4},
  [600] = {.lex_state = 268, .external_lex_state = 8},
  [601] = {.lex_state = 364, .external_lex_state = 2},
  [602] = {.lex_state = 283, .external_lex_state = 4},
  [603] = {.lex_state = 358, .external_lex_state = 7},
  [604] = {.lex_state = 283, .external_lex_state = 4},
  [605] = {.lex_state = 135, .external_lex_state = 2},
  [606] = {.lex_state = 422, .external_lex_state = 2},
  [607] = {.lex_state = 244, .external_lex_state = 4},
  [608] = {.lex_state = 206},
  [609] = {.lex_state = 206},
  [610] = {.lex_state = 268, .external_lex_state = 8},
  [611] = {.lex_state = 370, .external_lex_state = 2},
  [612] = {.lex_state = 206},
  [613] = {.lex_state = 274, .external_lex_state = 10},
  [614] = {.lex_state = 424},
  [615] = {.lex_state = 274, .external_lex_state = 4},
  [616] = {.lex_state = 274, .external_lex_state = 10},
  [617] = {.lex_state = 274, .external_lex_state = 10},
  [618] = {.lex_state = 424},
  [619] = {.lex_state = 274, .external_lex_state = 4},
  [620] = {.lex_state = 399, .external_lex_state = 16},
  [621] = {.lex_state = 274, .external_lex_state = 10},
  [622] = {.lex_state = 403},
  [623] = {.lex_state = 401, .external_lex_state = 16},
  [624] = {.lex_state = 206},
  [625] = {.lex_state = 303, .external_lex_state = 16},
  [626] = {.lex_state = 303, .external_lex_state = 16},
  [627] = {.lex_state = 303, .external_lex_state = 16},
  [628] = {.lex_state = 274, .external_lex_state = 10},
  [629] = {.lex_state = 403},
  [630] = {.lex_state = 401, .external_lex_state = 16},
  [631] = {.lex_state = 274, .external_lex_state = 10},
  [632] = {.lex_state = 403},
  [633] = {.lex_state = 401, .external_lex_state = 16},
  [634] = {.lex_state = 274, .external_lex_state = 10},
  [635] = {.lex_state = 274, .external_lex_state = 10},
  [636] = {.lex_state = 206},
  [637] = {.lex_state = 430, .external_lex_state = 23},
  [638] = {.lex_state = 244, .external_lex_state = 4},
  [639] = {.lex_state = 268, .external_lex_state = 8},
  [640] = {.lex_state = 380, .external_lex_state = 22},
  [641] = {.lex_state = 135},
  [642] = {.lex_state = 234},
  [643] = {.lex_state = 283, .external_lex_state = 4},
  [644] = {.lex_state = 281, .external_lex_state = 21},
  [645] = {.lex_state = 281, .external_lex_state = 21},
  [646] = {.lex_state = 387, .external_lex_state = 7},
  [647] = {.lex_state = 206},
  [648] = {.lex_state = 432, .external_lex_state = 23},
  [649] = {.lex_state = 387, .external_lex_state = 23},
  [650] = {.lex_state = 272, .external_lex_state = 9},
  [651] = {.lex_state = 277, .external_lex_state = 14},
  [652] = {.lex_state = 277, .external_lex_state = 3},
  [653] = {.lex_state = 277, .external_lex_state = 10},
  [654] = {.lex_state = 277, .external_lex_state = 4},
  [655] = {.lex_state = 270, .external_lex_state = 5},
  [656] = {.lex_state = 206},
  [657] = {.lex_state = 283, .external_lex_state = 4},
  [658] = {.lex_state = 277, .external_lex_state = 4},
  [659] = {.lex_state = 281, .external_lex_state = 8},
  [660] = {.lex_state = 234},
  [661] = {.lex_state = 270, .external_lex_state = 5},
  [662] = {.lex_state = 270, .external_lex_state = 5},
  [663] = {.lex_state = 387, .external_lex_state = 5},
  [664] = {.lex_state = 387, .external_lex_state = 5},
  [665] = {.lex_state = 387, .external_lex_state = 5},
  [666] = {.lex_state = 387, .external_lex_state = 5},
  [667] = {.lex_state = 387, .external_lex_state = 7},
  [668] = {.lex_state = 387, .external_lex_state = 7},
  [669] = {.lex_state = 270, .external_lex_state = 7},
  [670] = {.lex_state = 385, .external_lex_state = 2},
  [671] = {.lex_state = 270, .external_lex_state = 7},
  [672] = {.lex_state = 320, .external_lex_state = 2},
  [673] = {.lex_state = 320},
  [674] = {.lex_state = 234, .external_lex_state = 15},
  [675] = {.lex_state = 234, .external_lex_state = 15},
  [676] = {.lex_state = 389},
  [677] = {.lex_state = 389, .external_lex_state = 13},
  [678] = {.lex_state = 286, .external_lex_state = 12},
  [679] = {.lex_state = 238},
  [680] = {.lex_state = 391},
  [681] = {.lex_state = 286, .external_lex_state = 11},
  [682] = {.lex_state = 286, .external_lex_state = 11},
  [683] = {.lex_state = 286, .external_lex_state = 11},
  [684] = {.lex_state = 399, .external_lex_state = 16},
  [685] = {.lex_state = 286, .external_lex_state = 11},
  [686] = {.lex_state = 403},
  [687] = {.lex_state = 401, .external_lex_state = 16},
  [688] = {.lex_state = 206},
  [689] = {.lex_state = 303, .external_lex_state = 16},
  [690] = {.lex_state = 303, .external_lex_state = 16},
  [691] = {.lex_state = 303, .external_lex_state = 16},
  [692] = {.lex_state = 286, .external_lex_state = 11},
  [693] = {.lex_state = 403},
  [694] = {.lex_state = 401, .external_lex_state = 16},
  [695] = {.lex_state = 286, .external_lex_state = 11},
  [696] = {.lex_state = 403},
  [697] = {.lex_state = 401, .external_lex_state = 16},
  [698] = {.lex_state = 286, .external_lex_state = 11},
  [699] = {.lex_state = 286, .external_lex_state = 11},
  [700] = {.lex_state = 286, .external_lex_state = 12},
  [701] = {.lex_state = 135},
  [702] = {.lex_state = 234},
  [703] = {.lex_state = 356, .external_lex_state = 20},
  [704] = {.lex_state = 234},
  [705] = {.lex_state = 358, .external_lex_state = 23},
  [706] = {.lex_state = 286, .external_lex_state = 12},
  [707] = {.lex_state = 434},
  [708] = {.lex_state = 396, .external_lex_state = 13},
  [709] = {.lex_state = 294, .external_lex_state = 13},
  [710] = {.lex_state = 396, .external_lex_state = 13},
  [711] = {.lex_state = 399, .external_lex_state = 16},
  [712] = {.lex_state = 396, .external_lex_state = 13},
  [713] = {.lex_state = 403},
  [714] = {.lex_state = 401, .external_lex_state = 16},
  [715] = {.lex_state = 206},
  [716] = {.lex_state = 303, .external_lex_state = 16},
  [717] = {.lex_state = 303, .external_lex_state = 16},
  [718] = {.lex_state = 303, .external_lex_state = 16},
  [719] = {.lex_state = 396, .external_lex_state = 13},
  [720] = {.lex_state = 403},
  [721] = {.lex_state = 401, .external_lex_state = 16},
  [722] = {.lex_state = 396, .external_lex_state = 13},
  [723] = {.lex_state = 403},
  [724] = {.lex_state = 401, .external_lex_state = 16},
  [725] = {.lex_state = 396, .external_lex_state = 13},
  [726] = {.lex_state = 396, .external_lex_state = 13},
  [727] = {.lex_state = 434},
  [728] = {.lex_state = 434},
  [729] = {.lex_state = 277, .external_lex_state = 3},
  [730] = {.lex_state = 320},
  [731] = {.lex_state = 244, .external_lex_state = 14},
  [732] = {.lex_state = 244, .external_lex_state = 14},
  [733] = {.lex_state = 277, .external_lex_state = 14},
  [734] = {.lex_state = 244, .external_lex_state = 14},
  [735] = {.lex_state = 277, .external_lex_state = 14},
  [736] = {.lex_state = 399, .external_lex_state = 16},
  [737] = {.lex_state = 277, .external_lex_state = 14},
  [738] = {.lex_state = 403},
  [739] = {.lex_state = 401, .external_lex_state = 16},
  [740] = {.lex_state = 206},
  [741] = {.lex_state = 303, .external_lex_state = 16},
  [742] = {.lex_state = 303, .external_lex_state = 16},
  [743] = {.lex_state = 303, .external_lex_state = 16},
  [744] = {.lex_state = 277, .external_lex_state = 14},
  [745] = {.lex_state = 403},
  [746] = {.lex_state = 401, .external_lex_state = 16},
  [747] = {.lex_state = 277, .external_lex_state = 14},
  [748] = {.lex_state = 403},
  [749] = {.lex_state = 401, .external_lex_state = 16},
  [750] = {.lex_state = 277, .external_lex_state = 14},
  [751] = {.lex_state = 277, .external_lex_state = 14},
  [752] = {.lex_state = 277, .external_lex_state = 10},
  [753] = {.lex_state = 244, .external_lex_state = 10},
  [754] = {.lex_state = 277, .external_lex_state = 10},
  [755] = {.lex_state = 399, .external_lex_state = 16},
  [756] = {.lex_state = 277, .external_lex_state = 10},
  [757] = {.lex_state = 403},
  [758] = {.lex_state = 401, .external_lex_state = 16},
  [759] = {.lex_state = 206},
  [760] = {.lex_state = 303, .external_lex_state = 16},
  [761] = {.lex_state = 303, .external_lex_state = 16},
  [762] = {.lex_state = 303, .external_lex_state = 16},
  [763] = {.lex_state = 277, .external_lex_state = 10},
  [764] = {.lex_state = 403},
  [765] = {.lex_state = 401, .external_lex_state = 16},
  [766] = {.lex_state = 277, .external_lex_state = 10},
  [767] = {.lex_state = 403},
  [768] = {.lex_state = 401, .external_lex_state = 16},
  [769] = {.lex_state = 277, .external_lex_state = 10},
  [770] = {.lex_state = 277, .external_lex_state = 10},
  [771] = {.lex_state = 320, .external_lex_state = 15},
  [772] = {.lex_state = 234, .external_lex_state = 15},
  [773] = {.lex_state = 320, .external_lex_state = 15},
  [774] = {.lex_state = 399, .external_lex_state = 16},
  [775] = {.lex_state = 320, .external_lex_state = 15},
  [776] = {.lex_state = 403},
  [777] = {.lex_state = 401, .external_lex_state = 16},
  [778] = {.lex_state = 206},
  [779] = {.lex_state = 303, .external_lex_state = 16},
  [780] = {.lex_state = 303, .external_lex_state = 16},
  [781] = {.lex_state = 303, .external_lex_state = 16},
  [782] = {.lex_state = 320, .external_lex_state = 15},
  [783] = {.lex_state = 403},
  [784] = {.lex_state = 401, .external_lex_state = 16},
  [785] = {.lex_state = 320, .external_lex_state = 15},
  [786] = {.lex_state = 403},
  [787] = {.lex_state = 401, .external_lex_state = 16},
  [788] = {.lex_state = 320, .external_lex_state = 15},
  [789] = {.lex_state = 320, .external_lex_state = 15},
  [790] = {.lex_state = 254},
  [791] = {.lex_state = 399, .external_lex_state = 16},
  [792] = {.lex_state = 254, .external_lex_state = 13},
  [793] = {.lex_state = 403},
  [794] = {.lex_state = 401, .external_lex_state = 16},
  [795] = {.lex_state = 206},
  [796] = {.lex_state = 303, .external_lex_state = 16},
  [797] = {.lex_state = 303, .external_lex_state = 16},
  [798] = {.lex_state = 303, .external_lex_state = 16},
  [799] = {.lex_state = 254, .external_lex_state = 13},
  [800] = {.lex_state = 403},
  [801] = {.lex_state = 401, .external_lex_state = 16},
  [802] = {.lex_state = 254, .external_lex_state = 13},
  [803] = {.lex_state = 403},
  [804] = {.lex_state = 401, .external_lex_state = 16},
  [805] = {.lex_state = 254, .external_lex_state = 13},
  [806] = {.lex_state = 362, .external_lex_state = 11},
  [807] = {.lex_state = 362, .external_lex_state = 11},
  [808] = {.lex_state = 362, .external_lex_state = 11},
  [809] = {.lex_state = 270, .external_lex_state = 5},
  [810] = {.lex_state = 436, .external_lex_state = 24},
  [811] = {.lex_state = 254},
  [812] = {.lex_state = 261},
  [813] = {.lex_state = 436, .external_lex_state = 24},
  [814] = {.lex_state = 264, .external_lex_state = 6},
  [815] = {.lex_state = 135, .external_lex_state = 2},
  [816] = {.lex_state = 135, .external_lex_state = 2},
  [817] = {.lex_state = 135, .external_lex_state = 2},
  [818] = {.lex_state = 206, .external_lex_state = 16},
  [819] = {.lex_state = 234},
  [820] = {.lex_state = 401, .external_lex_state = 24},
  [821] = {.lex_state = 401, .external_lex_state = 24},
  [822] = {.lex_state = 254},
  [823] = {.lex_state = 401, .external_lex_state = 24},
  [824] = {.lex_state = 401, .external_lex_state = 24},
  [825] = {.lex_state = 401, .external_lex_state = 24},
  [826] = {.lex_state = 206},
  [827] = {.lex_state = 303, .external_lex_state = 16},
  [828] = {.lex_state = 311, .external_lex_state = 6},
  [829] = {.lex_state = 303, .external_lex_state = 16},
  [830] = {.lex_state = 303, .external_lex_state = 16},
  [831] = {.lex_state = 401, .external_lex_state = 16},
  [832] = {.lex_state = 206},
  [833] = {.lex_state = 320, .external_lex_state = 2},
  [834] = {.lex_state = 206},
  [835] = {.lex_state = 328, .external_lex_state = 2},
  [836] = {.lex_state = 206},
  [837] = {.lex_state = 320, .external_lex_state = 2},
  [838] = {.lex_state = 270, .external_lex_state = 5},
  [839] = {.lex_state = 401, .external_lex_state = 16},
  [840] = {.lex_state = 399, .external_lex_state = 16},
  [841] = {.lex_state = 270, .external_lex_state = 5},
  [842] = {.lex_state = 403},
  [843] = {.lex_state = 401, .external_lex_state = 16},
  [844] = {.lex_state = 270, .external_lex_state = 5},
  [845] = {.lex_state = 403},
  [846] = {.lex_state = 401, .external_lex_state = 16},
  [847] = {.lex_state = 403},
  [848] = {.lex_state = 401, .external_lex_state = 16},
  [849] = {.lex_state = 401, .external_lex_state = 16},
  [850] = {.lex_state = 270, .external_lex_state = 5},
  [851] = {.lex_state = 401, .external_lex_state = 16},
  [852] = {.lex_state = 320, .external_lex_state = 15},
  [853] = {.lex_state = 320, .external_lex_state = 15},
  [854] = {.lex_state = 234},
  [855] = {.lex_state = 206},
  [856] = {.lex_state = 364, .external_lex_state = 2},
  [857] = {.lex_state = 408, .external_lex_state = 18},
  [858] = {.lex_state = 370, .external_lex_state = 2},
  [859] = {.lex_state = 274, .external_lex_state = 4},
  [860] = {.lex_state = 206},
  [861] = {.lex_state = 274, .external_lex_state = 4},
  [862] = {.lex_state = 206},
  [863] = {.lex_state = 206},
  [864] = {.lex_state = 380, .external_lex_state = 22},
  [865] = {.lex_state = 438, .external_lex_state = 26},
  [866] = {.lex_state = 206},
  [867] = {.lex_state = 385, .external_lex_state = 2},
  [868] = {.lex_state = 277, .external_lex_state = 4},
  [869] = {.lex_state = 281, .external_lex_state = 8},
  [870] = {.lex_state = 408, .external_lex_state = 26},
  [871] = {.lex_state = 272, .external_lex_state = 9},
  [872] = {.lex_state = 234},
  [873] = {.lex_state = 313, .external_lex_state = 25},
  [874] = {.lex_state = 313, .external_lex_state = 25},
  [875] = {.lex_state = 254},
  [876] = {.lex_state = 313, .external_lex_state = 25},
  [877] = {.lex_state = 313, .external_lex_state = 25},
  [878] = {.lex_state = 313, .external_lex_state = 25},
  [879] = {.lex_state = 206},
  [880] = {.lex_state = 303, .external_lex_state = 16},
  [881] = {.lex_state = 311, .external_lex_state = 6},
  [882] = {.lex_state = 303, .external_lex_state = 16},
  [883] = {.lex_state = 303, .external_lex_state = 16},
  [884] = {.lex_state = 206},
  [885] = {.lex_state = 320, .external_lex_state = 2},
  [886] = {.lex_state = 206},
  [887] = {.lex_state = 328, .external_lex_state = 2},
  [888] = {.lex_state = 206},
  [889] = {.lex_state = 320, .external_lex_state = 2},
  [890] = {.lex_state = 313, .external_lex_state = 6},
  [891] = {.lex_state = 234},
  [892] = {.lex_state = 313, .external_lex_state = 13},
  [893] = {.lex_state = 313, .external_lex_state = 13},
  [894] = {.lex_state = 254},
  [895] = {.lex_state = 313, .external_lex_state = 13},
  [896] = {.lex_state = 313, .external_lex_state = 13},
  [897] = {.lex_state = 313, .external_lex_state = 13},
  [898] = {.lex_state = 206},
  [899] = {.lex_state = 303, .external_lex_state = 16},
  [900] = {.lex_state = 311, .external_lex_state = 6},
  [901] = {.lex_state = 303, .external_lex_state = 16},
  [902] = {.lex_state = 303, .external_lex_state = 16},
  [903] = {.lex_state = 206},
  [904] = {.lex_state = 320, .external_lex_state = 2},
  [905] = {.lex_state = 206},
  [906] = {.lex_state = 328, .external_lex_state = 2},
  [907] = {.lex_state = 206},
  [908] = {.lex_state = 320, .external_lex_state = 2},
  [909] = {.lex_state = 313},
  [910] = {.lex_state = 315, .external_lex_state = 17},
  [911] = {.lex_state = 315, .external_lex_state = 17},
  [912] = {.lex_state = 315, .external_lex_state = 17},
  [913] = {.lex_state = 399, .external_lex_state = 16},
  [914] = {.lex_state = 315, .external_lex_state = 17},
  [915] = {.lex_state = 403},
  [916] = {.lex_state = 401, .external_lex_state = 16},
  [917] = {.lex_state = 206},
  [918] = {.lex_state = 303, .external_lex_state = 16},
  [919] = {.lex_state = 303, .external_lex_state = 16},
  [920] = {.lex_state = 303, .external_lex_state = 16},
  [921] = {.lex_state = 315, .external_lex_state = 17},
  [922] = {.lex_state = 403},
  [923] = {.lex_state = 401, .external_lex_state = 16},
  [924] = {.lex_state = 315, .external_lex_state = 17},
  [925] = {.lex_state = 403},
  [926] = {.lex_state = 401, .external_lex_state = 16},
  [927] = {.lex_state = 315, .external_lex_state = 17},
  [928] = {.lex_state = 315, .external_lex_state = 17},
  [929] = {.lex_state = 206},
  [930] = {.lex_state = 206},
  [931] = {.lex_state = 320, .external_lex_state = 2},
  [932] = {.lex_state = 206},
  [933] = {.lex_state = 320, .external_lex_state = 2},
  [934] = {.lex_state = 206},
  [935] = {.lex_state = 333, .external_lex_state = 19},
  [936] = {.lex_state = 234},
  [937] = {.lex_state = 315, .external_lex_state = 17},
  [938] = {.lex_state = 315, .external_lex_state = 17},
  [939] = {.lex_state = 315, .external_lex_state = 18},
  [940] = {.lex_state = 408, .external_lex_state = 17},
  [941] = {.lex_state = 408, .external_lex_state = 17},
  [942] = {.lex_state = 440, .external_lex_state = 18},
  [943] = {.lex_state = 440, .external_lex_state = 18},
  [944] = {.lex_state = 408, .external_lex_state = 17},
  [945] = {.lex_state = 408, .external_lex_state = 17},
  [946] = {.lex_state = 440, .external_lex_state = 18},
  [947] = {.lex_state = 206},
  [948] = {.lex_state = 408, .external_lex_state = 18},
  [949] = {.lex_state = 408, .external_lex_state = 18},
  [950] = {.lex_state = 315, .external_lex_state = 18},
  [951] = {.lex_state = 315, .external_lex_state = 18},
  [952] = {.lex_state = 328, .external_lex_state = 15},
  [953] = {.lex_state = 328, .external_lex_state = 15},
  [954] = {.lex_state = 410, .external_lex_state = 18},
  [955] = {.lex_state = 206},
  [956] = {.lex_state = 442, .external_lex_state = 26},
  [957] = {.lex_state = 410, .external_lex_state = 26},
  [958] = {.lex_state = 272, .external_lex_state = 9},
  [959] = {.lex_state = 322, .external_lex_state = 25},
  [960] = {.lex_state = 322, .external_lex_state = 6},
  [961] = {.lex_state = 322, .external_lex_state = 13},
  [962] = {.lex_state = 313},
  [963] = {.lex_state = 324, .external_lex_state = 17},
  [964] = {.lex_state = 206},
  [965] = {.lex_state = 328, .external_lex_state = 2},
  [966] = {.lex_state = 206},
  [967] = {.lex_state = 328, .external_lex_state = 2},
  [968] = {.lex_state = 234},
  [969] = {.lex_state = 324, .external_lex_state = 17},
  [970] = {.lex_state = 324, .external_lex_state = 17},
  [971] = {.lex_state = 410, .external_lex_state = 17},
  [972] = {.lex_state = 410, .external_lex_state = 17},
  [973] = {.lex_state = 410, .external_lex_state = 17},
  [974] = {.lex_state = 410, .external_lex_state = 17},
  [975] = {.lex_state = 410, .external_lex_state = 18},
  [976] = {.lex_state = 410, .external_lex_state = 18},
  [977] = {.lex_state = 324, .external_lex_state = 18},
  [978] = {.lex_state = 324, .external_lex_state = 18},
  [979] = {.lex_state = 382, .external_lex_state = 23},
  [980] = {.lex_state = 333, .external_lex_state = 19},
  [981] = {.lex_state = 333, .external_lex_state = 19},
  [982] = {.lex_state = 206},
  [983] = {.lex_state = 303, .external_lex_state = 16},
  [984] = {.lex_state = 311, .external_lex_state = 6},
  [985] = {.lex_state = 303, .external_lex_state = 16},
  [986] = {.lex_state = 303, .external_lex_state = 16},
  [987] = {.lex_state = 283, .external_lex_state = 4},
  [988] = {.lex_state = 333, .external_lex_state = 19},
  [989] = {.lex_state = 358, .external_lex_state = 5},
  [990] = {.lex_state = 358, .external_lex_state = 5},
  [991] = {.lex_state = 412, .external_lex_state = 7},
  [992] = {.lex_state = 358, .external_lex_state = 5},
  [993] = {.lex_state = 283, .external_lex_state = 4},
  [994] = {.lex_state = 358, .external_lex_state = 7},
  [995] = {.lex_state = 416, .external_lex_state = 13},
  [996] = {.lex_state = 206},
  [997] = {.lex_state = 362, .external_lex_state = 11},
  [998] = {.lex_state = 416, .external_lex_state = 13},
  [999] = {.lex_state = 206},
  [1000] = {.lex_state = 234},
  [1001] = {.lex_state = 418, .external_lex_state = 13},
  [1002] = {.lex_state = 418, .external_lex_state = 13},
  [1003] = {.lex_state = 254},
  [1004] = {.lex_state = 418, .external_lex_state = 13},
  [1005] = {.lex_state = 418, .external_lex_state = 13},
  [1006] = {.lex_state = 418, .external_lex_state = 13},
  [1007] = {.lex_state = 206},
  [1008] = {.lex_state = 303, .external_lex_state = 16},
  [1009] = {.lex_state = 311, .external_lex_state = 6},
  [1010] = {.lex_state = 303, .external_lex_state = 16},
  [1011] = {.lex_state = 303, .external_lex_state = 16},
  [1012] = {.lex_state = 206},
  [1013] = {.lex_state = 320, .external_lex_state = 2},
  [1014] = {.lex_state = 206},
  [1015] = {.lex_state = 328, .external_lex_state = 2},
  [1016] = {.lex_state = 206},
  [1017] = {.lex_state = 320, .external_lex_state = 2},
  [1018] = {.lex_state = 281, .external_lex_state = 8},
  [1019] = {.lex_state = 320},
  [1020] = {.lex_state = 281, .external_lex_state = 21},
  [1021] = {.lex_state = 268, .external_lex_state = 21},
  [1022] = {.lex_state = 281, .external_lex_state = 21},
  [1023] = {.lex_state = 399, .external_lex_state = 16},
  [1024] = {.lex_state = 281, .external_lex_state = 21},
  [1025] = {.lex_state = 403},
  [1026] = {.lex_state = 401, .external_lex_state = 16},
  [1027] = {.lex_state = 206},
  [1028] = {.lex_state = 303, .external_lex_state = 16},
  [1029] = {.lex_state = 303, .external_lex_state = 16},
  [1030] = {.lex_state = 303, .external_lex_state = 16},
  [1031] = {.lex_state = 281, .external_lex_state = 21},
  [1032] = {.lex_state = 403},
  [1033] = {.lex_state = 401, .external_lex_state = 16},
  [1034] = {.lex_state = 281, .external_lex_state = 21},
  [1035] = {.lex_state = 403},
  [1036] = {.lex_state = 401, .external_lex_state = 16},
  [1037] = {.lex_state = 281, .external_lex_state = 21},
  [1038] = {.lex_state = 281, .external_lex_state = 21},
  [1039] = {.lex_state = 234},
  [1040] = {.lex_state = 420, .external_lex_state = 10},
  [1041] = {.lex_state = 420, .external_lex_state = 10},
  [1042] = {.lex_state = 254},
  [1043] = {.lex_state = 420, .external_lex_state = 10},
  [1044] = {.lex_state = 420, .external_lex_state = 10},
  [1045] = {.lex_state = 420, .external_lex_state = 10},
  [1046] = {.lex_state = 206},
  [1047] = {.lex_state = 303, .external_lex_state = 16},
  [1048] = {.lex_state = 311, .external_lex_state = 6},
  [1049] = {.lex_state = 303, .external_lex_state = 16},
  [1050] = {.lex_state = 303, .external_lex_state = 16},
  [1051] = {.lex_state = 206},
  [1052] = {.lex_state = 320, .external_lex_state = 2},
  [1053] = {.lex_state = 206},
  [1054] = {.lex_state = 328, .external_lex_state = 2},
  [1055] = {.lex_state = 206},
  [1056] = {.lex_state = 320, .external_lex_state = 2},
  [1057] = {.lex_state = 206},
  [1058] = {.lex_state = 420, .external_lex_state = 4},
  [1059] = {.lex_state = 283, .external_lex_state = 4},
  [1060] = {.lex_state = 364, .external_lex_state = 2},
  [1061] = {.lex_state = 364, .external_lex_state = 2},
  [1062] = {.lex_state = 412, .external_lex_state = 7},
  [1063] = {.lex_state = 364, .external_lex_state = 2},
  [1064] = {.lex_state = 283, .external_lex_state = 4},
  [1065] = {.lex_state = 206},
  [1066] = {.lex_state = 244, .external_lex_state = 4},
  [1067] = {.lex_state = 268, .external_lex_state = 8},
  [1068] = {.lex_state = 422, .external_lex_state = 2},
  [1069] = {.lex_state = 370, .external_lex_state = 2},
  [1070] = {.lex_state = 283, .external_lex_state = 4},
  [1071] = {.lex_state = 206},
  [1072] = {.lex_state = 370, .external_lex_state = 2},
  [1073] = {.lex_state = 206},
  [1074] = {.lex_state = 206},
  [1075] = {.lex_state = 283, .external_lex_state = 4},
  [1076] = {.lex_state = 444, .external_lex_state = 13},
  [1077] = {.lex_state = 444, .external_lex_state = 13},
  [1078] = {.lex_state = 206},
  [1079] = {.lex_state = 231},
  [1080] = {.lex_state = 234},
  [1081] = {.lex_state = 424},
  [1082] = {.lex_state = 283, .external_lex_state = 4},
  [1083] = {.lex_state = 206},
  [1084] = {.lex_state = 234},
  [1085] = {.lex_state = 424},
  [1086] = {.lex_state = 274, .external_lex_state = 10},
  [1087] = {.lex_state = 436, .external_lex_state = 24},
  [1088] = {.lex_state = 436, .external_lex_state = 24},
  [1089] = {.lex_state = 206, .external_lex_state = 16},
  [1090] = {.lex_state = 401, .external_lex_state = 16},
  [1091] = {.lex_state = 274, .external_lex_state = 10},
  [1092] = {.lex_state = 399, .external_lex_state = 16},
  [1093] = {.lex_state = 274, .external_lex_state = 10},
  [1094] = {.lex_state = 403},
  [1095] = {.lex_state = 401, .external_lex_state = 16},
  [1096] = {.lex_state = 274, .external_lex_state = 10},
  [1097] = {.lex_state = 403},
  [1098] = {.lex_state = 401, .external_lex_state = 16},
  [1099] = {.lex_state = 403},
  [1100] = {.lex_state = 401, .external_lex_state = 16},
  [1101] = {.lex_state = 401, .external_lex_state = 16},
  [1102] = {.lex_state = 274, .external_lex_state = 10},
  [1103] = {.lex_state = 401, .external_lex_state = 16},
  [1104] = {.lex_state = 382, .external_lex_state = 23},
  [1105] = {.lex_state = 380, .external_lex_state = 22},
  [1106] = {.lex_state = 430, .external_lex_state = 23},
  [1107] = {.lex_state = 380, .external_lex_state = 22},
  [1108] = {.lex_state = 234},
  [1109] = {.lex_state = 446, .external_lex_state = 10},
  [1110] = {.lex_state = 446, .external_lex_state = 10},
  [1111] = {.lex_state = 283, .external_lex_state = 4},
  [1112] = {.lex_state = 281, .external_lex_state = 21},
  [1113] = {.lex_state = 387, .external_lex_state = 7},
  [1114] = {.lex_state = 206},
  [1115] = {.lex_state = 135},
  [1116] = {.lex_state = 234},
  [1117] = {.lex_state = 135},
  [1118] = {.lex_state = 234},
  [1119] = {.lex_state = 234},
  [1120] = {.lex_state = 387, .external_lex_state = 23},
  [1121] = {.lex_state = 277, .external_lex_state = 14},
  [1122] = {.lex_state = 277, .external_lex_state = 14},
  [1123] = {.lex_state = 277, .external_lex_state = 14},
  [1124] = {.lex_state = 277, .external_lex_state = 10},
  [1125] = {.lex_state = 432, .external_lex_state = 23},
  [1126] = {.lex_state = 387, .external_lex_state = 5},
  [1127] = {.lex_state = 387, .external_lex_state = 5},
  [1128] = {.lex_state = 387, .external_lex_state = 5},
  [1129] = {.lex_state = 283, .external_lex_state = 4},
  [1130] = {.lex_state = 387, .external_lex_state = 7},
  [1131] = {.lex_state = 320, .external_lex_state = 2},
  [1132] = {.lex_state = 320},
  [1133] = {.lex_state = 389, .external_lex_state = 13},
  [1134] = {.lex_state = 286, .external_lex_state = 11},
  [1135] = {.lex_state = 436, .external_lex_state = 24},
  [1136] = {.lex_state = 436, .external_lex_state = 24},
  [1137] = {.lex_state = 206, .external_lex_state = 16},
  [1138] = {.lex_state = 401, .external_lex_state = 16},
  [1139] = {.lex_state = 286, .external_lex_state = 11},
  [1140] = {.lex_state = 399, .external_lex_state = 16},
  [1141] = {.lex_state = 286, .external_lex_state = 11},
  [1142] = {.lex_state = 403},
  [1143] = {.lex_state = 401, .external_lex_state = 16},
  [1144] = {.lex_state = 286, .external_lex_state = 11},
  [1145] = {.lex_state = 403},
  [1146] = {.lex_state = 401, .external_lex_state = 16},
  [1147] = {.lex_state = 403},
  [1148] = {.lex_state = 401, .external_lex_state = 16},
  [1149] = {.lex_state = 401, .external_lex_state = 16},
  [1150] = {.lex_state = 286, .external_lex_state = 11},
  [1151] = {.lex_state = 401, .external_lex_state = 16},
  [1152] = {.lex_state = 234},
  [1153] = {.lex_state = 358, .external_lex_state = 27},
  [1154] = {.lex_state = 254},
  [1155] = {.lex_state = 261},
  [1156] = {.lex_state = 358, .external_lex_state = 27},
  [1157] = {.lex_state = 264, .external_lex_state = 6},
  [1158] = {.lex_state = 135, .external_lex_state = 2},
  [1159] = {.lex_state = 135, .external_lex_state = 2},
  [1160] = {.lex_state = 135, .external_lex_state = 2},
  [1161] = {.lex_state = 412, .external_lex_state = 23},
  [1162] = {.lex_state = 412, .external_lex_state = 23},
  [1163] = {.lex_state = 358, .external_lex_state = 27},
  [1164] = {.lex_state = 358, .external_lex_state = 27},
  [1165] = {.lex_state = 412, .external_lex_state = 23},
  [1166] = {.lex_state = 358, .external_lex_state = 23},
  [1167] = {.lex_state = 396, .external_lex_state = 13},
  [1168] = {.lex_state = 436, .external_lex_state = 24},
  [1169] = {.lex_state = 436, .external_lex_state = 24},
  [1170] = {.lex_state = 206, .external_lex_state = 16},
  [1171] = {.lex_state = 401, .external_lex_state = 16},
  [1172] = {.lex_state = 396, .external_lex_state = 13},
  [1173] = {.lex_state = 399, .external_lex_state = 16},
  [1174] = {.lex_state = 396, .external_lex_state = 13},
  [1175] = {.lex_state = 403},
  [1176] = {.lex_state = 401, .external_lex_state = 16},
  [1177] = {.lex_state = 396, .external_lex_state = 13},
  [1178] = {.lex_state = 403},
  [1179] = {.lex_state = 401, .external_lex_state = 16},
  [1180] = {.lex_state = 403},
  [1181] = {.lex_state = 401, .external_lex_state = 16},
  [1182] = {.lex_state = 401, .external_lex_state = 16},
  [1183] = {.lex_state = 396, .external_lex_state = 13},
  [1184] = {.lex_state = 401, .external_lex_state = 16},
  [1185] = {.lex_state = 277, .external_lex_state = 3},
  [1186] = {.lex_state = 320},
  [1187] = {.lex_state = 277, .external_lex_state = 14},
  [1188] = {.lex_state = 436, .external_lex_state = 24},
  [1189] = {.lex_state = 436, .external_lex_state = 24},
  [1190] = {.lex_state = 206, .external_lex_state = 16},
  [1191] = {.lex_state = 401, .external_lex_state = 16},
  [1192] = {.lex_state = 277, .external_lex_state = 14},
  [1193] = {.lex_state = 399, .external_lex_state = 16},
  [1194] = {.lex_state = 277, .external_lex_state = 14},
  [1195] = {.lex_state = 403},
  [1196] = {.lex_state = 401, .external_lex_state = 16},
  [1197] = {.lex_state = 277, .external_lex_state = 14},
  [1198] = {.lex_state = 403},
  [1199] = {.lex_state = 401, .external_lex_state = 16},
  [1200] = {.lex_state = 403},
  [1201] = {.lex_state = 401, .external_lex_state = 16},
  [1202] = {.lex_state = 401, .external_lex_state = 16},
  [1203] = {.lex_state = 277, .external_lex_state = 14},
  [1204] = {.lex_state = 401, .external_lex_state = 16},
  [1205] = {.lex_state = 277, .external_lex_state = 10},
  [1206] = {.lex_state = 436, .external_lex_state = 24},
  [1207] = {.lex_state = 436, .external_lex_state = 24},
  [1208] = {.lex_state = 206, .external_lex_state = 16},
  [1209] = {.lex_state = 401, .external_lex_state = 16},
  [1210] = {.lex_state = 277, .external_lex_state = 10},
  [1211] = {.lex_state = 399, .external_lex_state = 16},
  [1212] = {.lex_state = 277, .external_lex_state = 10},
  [1213] = {.lex_state = 403},
  [1214] = {.lex_state = 401, .external_lex_state = 16},
  [1215] = {.lex_state = 277, .external_lex_state = 10},
  [1216] = {.lex_state = 403},
  [1217] = {.lex_state = 401, .external_lex_state = 16},
  [1218] = {.lex_state = 403},
  [1219] = {.lex_state = 401, .external_lex_state = 16},
  [1220] = {.lex_state = 401, .external_lex_state = 16},
  [1221] = {.lex_state = 277, .external_lex_state = 10},
  [1222] = {.lex_state = 401, .external_lex_state = 16},
  [1223] = {.lex_state = 320, .external_lex_state = 15},
  [1224] = {.lex_state = 436, .external_lex_state = 24},
  [1225] = {.lex_state = 436, .external_lex_state = 24},
  [1226] = {.lex_state = 206, .external_lex_state = 16},
  [1227] = {.lex_state = 401, .external_lex_state = 16},
  [1228] = {.lex_state = 320, .external_lex_state = 15},
  [1229] = {.lex_state = 399, .external_lex_state = 16},
  [1230] = {.lex_state = 320, .external_lex_state = 15},
  [1231] = {.lex_state = 403},
  [1232] = {.lex_state = 401, .external_lex_state = 16},
  [1233] = {.lex_state = 320, .external_lex_state = 15},
  [1234] = {.lex_state = 403},
  [1235] = {.lex_state = 401, .external_lex_state = 16},
  [1236] = {.lex_state = 403},
  [1237] = {.lex_state = 401, .external_lex_state = 16},
  [1238] = {.lex_state = 401, .external_lex_state = 16},
  [1239] = {.lex_state = 320, .external_lex_state = 15},
  [1240] = {.lex_state = 401, .external_lex_state = 16},
  [1241] = {.lex_state = 254, .external_lex_state = 13},
  [1242] = {.lex_state = 436, .external_lex_state = 24},
  [1243] = {.lex_state = 436, .external_lex_state = 24},
  [1244] = {.lex_state = 206, .external_lex_state = 16},
  [1245] = {.lex_state = 401, .external_lex_state = 16},
  [1246] = {.lex_state = 254, .external_lex_state = 13},
  [1247] = {.lex_state = 399, .external_lex_state = 16},
  [1248] = {.lex_state = 254, .external_lex_state = 13},
  [1249] = {.lex_state = 403},
  [1250] = {.lex_state = 401, .external_lex_state = 16},
  [1251] = {.lex_state = 254, .external_lex_state = 13},
  [1252] = {.lex_state = 403},
  [1253] = {.lex_state = 401, .external_lex_state = 16},
  [1254] = {.lex_state = 403},
  [1255] = {.lex_state = 401, .external_lex_state = 16},
  [1256] = {.lex_state = 401, .external_lex_state = 16},
  [1257] = {.lex_state = 254, .external_lex_state = 13},
  [1258] = {.lex_state = 401, .external_lex_state = 16},
  [1259] = {.lex_state = 414, .external_lex_state = 12},
  [1260] = {.lex_state = 303, .external_lex_state = 24},
  [1261] = {.lex_state = 414, .external_lex_state = 12},
  [1262] = {.lex_state = 303, .external_lex_state = 24},
  [1263] = {.lex_state = 206, .external_lex_state = 12},
  [1264] = {.lex_state = 234},
  [1265] = {.lex_state = 270, .external_lex_state = 5},
  [1266] = {.lex_state = 436, .external_lex_state = 24},
  [1267] = {.lex_state = 436, .external_lex_state = 24},
  [1268] = {.lex_state = 254},
  [1269] = {.lex_state = 436, .external_lex_state = 24},
  [1270] = {.lex_state = 436, .external_lex_state = 24},
  [1271] = {.lex_state = 436, .external_lex_state = 24},
  [1272] = {.lex_state = 270, .external_lex_state = 5},
  [1273] = {.lex_state = 206},
  [1274] = {.lex_state = 303, .external_lex_state = 16},
  [1275] = {.lex_state = 311, .external_lex_state = 6},
  [1276] = {.lex_state = 303, .external_lex_state = 16},
  [1277] = {.lex_state = 303, .external_lex_state = 16},
  [1278] = {.lex_state = 206},
  [1279] = {.lex_state = 320, .external_lex_state = 2},
  [1280] = {.lex_state = 206},
  [1281] = {.lex_state = 328, .external_lex_state = 2},
  [1282] = {.lex_state = 206},
  [1283] = {.lex_state = 320, .external_lex_state = 2},
  [1284] = {.lex_state = 401, .external_lex_state = 24},
  [1285] = {.lex_state = 401, .external_lex_state = 24},
  [1286] = {.lex_state = 401, .external_lex_state = 24},
  [1287] = {.lex_state = 399, .external_lex_state = 16},
  [1288] = {.lex_state = 401, .external_lex_state = 24},
  [1289] = {.lex_state = 403},
  [1290] = {.lex_state = 401, .external_lex_state = 16},
  [1291] = {.lex_state = 206},
  [1292] = {.lex_state = 303, .external_lex_state = 16},
  [1293] = {.lex_state = 303, .external_lex_state = 16},
  [1294] = {.lex_state = 303, .external_lex_state = 16},
  [1295] = {.lex_state = 401, .external_lex_state = 24},
  [1296] = {.lex_state = 403},
  [1297] = {.lex_state = 401, .external_lex_state = 16},
  [1298] = {.lex_state = 401, .external_lex_state = 24},
  [1299] = {.lex_state = 403},
  [1300] = {.lex_state = 401, .external_lex_state = 16},
  [1301] = {.lex_state = 270, .external_lex_state = 5},
  [1302] = {.lex_state = 401, .external_lex_state = 16},
  [1303] = {.lex_state = 401, .external_lex_state = 24},
  [1304] = {.lex_state = 401, .external_lex_state = 24},
  [1305] = {.lex_state = 436, .external_lex_state = 24},
  [1306] = {.lex_state = 436, .external_lex_state = 24},
  [1307] = {.lex_state = 206, .external_lex_state = 16},
  [1308] = {.lex_state = 401, .external_lex_state = 16},
  [1309] = {.lex_state = 270, .external_lex_state = 5},
  [1310] = {.lex_state = 401, .external_lex_state = 16},
  [1311] = {.lex_state = 270, .external_lex_state = 5},
  [1312] = {.lex_state = 401, .external_lex_state = 16},
  [1313] = {.lex_state = 270, .external_lex_state = 5},
  [1314] = {.lex_state = 401, .external_lex_state = 16},
  [1315] = {.lex_state = 270, .external_lex_state = 5},
  [1316] = {.lex_state = 401, .external_lex_state = 16},
  [1317] = {.lex_state = 320, .external_lex_state = 15},
  [1318] = {.lex_state = 420, .external_lex_state = 4},
  [1319] = {.lex_state = 364, .external_lex_state = 2},
  [1320] = {.lex_state = 206},
  [1321] = {.lex_state = 440, .external_lex_state = 18},
  [1322] = {.lex_state = 364, .external_lex_state = 2},
  [1323] = {.lex_state = 206},
  [1324] = {.lex_state = 408, .external_lex_state = 18},
  [1325] = {.lex_state = 206},
  [1326] = {.lex_state = 206},
  [1327] = {.lex_state = 370, .external_lex_state = 2},
  [1328] = {.lex_state = 206},
  [1329] = {.lex_state = 424},
  [1330] = {.lex_state = 274, .external_lex_state = 4},
  [1331] = {.lex_state = 424},
  [1332] = {.lex_state = 274, .external_lex_state = 4},
  [1333] = {.lex_state = 206},
  [1334] = {.lex_state = 448, .external_lex_state = 26},
  [1335] = {.lex_state = 380, .external_lex_state = 22},
  [1336] = {.lex_state = 135},
  [1337] = {.lex_state = 234},
  [1338] = {.lex_state = 206},
  [1339] = {.lex_state = 206},
  [1340] = {.lex_state = 385, .external_lex_state = 2},
  [1341] = {.lex_state = 135},
  [1342] = {.lex_state = 234},
  [1343] = {.lex_state = 356, .external_lex_state = 20},
  [1344] = {.lex_state = 234},
  [1345] = {.lex_state = 408, .external_lex_state = 26},
  [1346] = {.lex_state = 313, .external_lex_state = 6},
  [1347] = {.lex_state = 320},
  [1348] = {.lex_state = 313, .external_lex_state = 25},
  [1349] = {.lex_state = 313, .external_lex_state = 25},
  [1350] = {.lex_state = 313, .external_lex_state = 25},
  [1351] = {.lex_state = 313, .external_lex_state = 25},
  [1352] = {.lex_state = 313, .external_lex_state = 25},
  [1353] = {.lex_state = 399, .external_lex_state = 16},
  [1354] = {.lex_state = 313, .external_lex_state = 25},
  [1355] = {.lex_state = 403},
  [1356] = {.lex_state = 401, .external_lex_state = 16},
  [1357] = {.lex_state = 206},
  [1358] = {.lex_state = 303, .external_lex_state = 16},
  [1359] = {.lex_state = 303, .external_lex_state = 16},
  [1360] = {.lex_state = 303, .external_lex_state = 16},
  [1361] = {.lex_state = 313, .external_lex_state = 25},
  [1362] = {.lex_state = 403},
  [1363] = {.lex_state = 401, .external_lex_state = 16},
  [1364] = {.lex_state = 313, .external_lex_state = 25},
  [1365] = {.lex_state = 403},
  [1366] = {.lex_state = 401, .external_lex_state = 16},
  [1367] = {.lex_state = 313, .external_lex_state = 25},
  [1368] = {.lex_state = 313, .external_lex_state = 25},
  [1369] = {.lex_state = 313, .external_lex_state = 13},
  [1370] = {.lex_state = 313, .external_lex_state = 13},
  [1371] = {.lex_state = 313, .external_lex_state = 13},
  [1372] = {.lex_state = 399, .external_lex_state = 16},
  [1373] = {.lex_state = 313, .external_lex_state = 13},
  [1374] = {.lex_state = 403},
  [1375] = {.lex_state = 401, .external_lex_state = 16},
  [1376] = {.lex_state = 206},
  [1377] = {.lex_state = 303, .external_lex_state = 16},
  [1378] = {.lex_state = 303, .external_lex_state = 16},
  [1379] = {.lex_state = 303, .external_lex_state = 16},
  [1380] = {.lex_state = 313, .external_lex_state = 13},
  [1381] = {.lex_state = 403},
  [1382] = {.lex_state = 401, .external_lex_state = 16},
  [1383] = {.lex_state = 313, .external_lex_state = 13},
  [1384] = {.lex_state = 403},
  [1385] = {.lex_state = 401, .external_lex_state = 16},
  [1386] = {.lex_state = 313, .external_lex_state = 13},
  [1387] = {.lex_state = 313, .external_lex_state = 13},
  [1388] = {.lex_state = 315, .external_lex_state = 17},
  [1389] = {.lex_state = 436, .external_lex_state = 24},
  [1390] = {.lex_state = 436, .external_lex_state = 24},
  [1391] = {.lex_state = 206, .external_lex_state = 16},
  [1392] = {.lex_state = 401, .external_lex_state = 16},
  [1393] = {.lex_state = 315, .external_lex_state = 17},
  [1394] = {.lex_state = 399, .external_lex_state = 16},
  [1395] = {.lex_state = 315, .external_lex_state = 17},
  [1396] = {.lex_state = 403},
  [1397] = {.lex_state = 401, .external_lex_state = 16},
  [1398] = {.lex_state = 315, .external_lex_state = 17},
  [1399] = {.lex_state = 403},
  [1400] = {.lex_state = 401, .external_lex_state = 16},
  [1401] = {.lex_state = 403},
  [1402] = {.lex_state = 401, .external_lex_state = 16},
  [1403] = {.lex_state = 401, .external_lex_state = 16},
  [1404] = {.lex_state = 315, .external_lex_state = 17},
  [1405] = {.lex_state = 401, .external_lex_state = 16},
  [1406] = {.lex_state = 438, .external_lex_state = 26},
  [1407] = {.lex_state = 206},
  [1408] = {.lex_state = 408, .external_lex_state = 17},
  [1409] = {.lex_state = 408, .external_lex_state = 17},
  [1410] = {.lex_state = 440, .external_lex_state = 18},
  [1411] = {.lex_state = 408, .external_lex_state = 17},
  [1412] = {.lex_state = 206},
  [1413] = {.lex_state = 408, .external_lex_state = 18},
  [1414] = {.lex_state = 328, .external_lex_state = 15},
  [1415] = {.lex_state = 410, .external_lex_state = 18},
  [1416] = {.lex_state = 206},
  [1417] = {.lex_state = 135},
  [1418] = {.lex_state = 234},
  [1419] = {.lex_state = 135},
  [1420] = {.lex_state = 234},
  [1421] = {.lex_state = 234},
  [1422] = {.lex_state = 410, .external_lex_state = 26},
  [1423] = {.lex_state = 322, .external_lex_state = 25},
  [1424] = {.lex_state = 322, .external_lex_state = 25},
  [1425] = {.lex_state = 322, .external_lex_state = 25},
  [1426] = {.lex_state = 322, .external_lex_state = 13},
  [1427] = {.lex_state = 442, .external_lex_state = 26},
  [1428] = {.lex_state = 410, .external_lex_state = 17},
  [1429] = {.lex_state = 410, .external_lex_state = 17},
  [1430] = {.lex_state = 410, .external_lex_state = 17},
  [1431] = {.lex_state = 410, .external_lex_state = 18},
  [1432] = {.lex_state = 283, .external_lex_state = 4},
  [1433] = {.lex_state = 399, .external_lex_state = 16},
  [1434] = {.lex_state = 333, .external_lex_state = 19},
  [1435] = {.lex_state = 403},
  [1436] = {.lex_state = 401, .external_lex_state = 16},
  [1437] = {.lex_state = 206},
  [1438] = {.lex_state = 303, .external_lex_state = 16},
  [1439] = {.lex_state = 303, .external_lex_state = 16},
  [1440] = {.lex_state = 303, .external_lex_state = 16},
  [1441] = {.lex_state = 333, .external_lex_state = 19},
  [1442] = {.lex_state = 403},
  [1443] = {.lex_state = 401, .external_lex_state = 16},
  [1444] = {.lex_state = 333, .external_lex_state = 19},
  [1445] = {.lex_state = 403},
  [1446] = {.lex_state = 401, .external_lex_state = 16},
  [1447] = {.lex_state = 358, .external_lex_state = 5},
  [1448] = {.lex_state = 283, .external_lex_state = 4},
  [1449] = {.lex_state = 206},
  [1450] = {.lex_state = 206},
  [1451] = {.lex_state = 418, .external_lex_state = 13},
  [1452] = {.lex_state = 418, .external_lex_state = 13},
  [1453] = {.lex_state = 418, .external_lex_state = 13},
  [1454] = {.lex_state = 399, .external_lex_state = 16},
  [1455] = {.lex_state = 418, .external_lex_state = 13},
  [1456] = {.lex_state = 403},
  [1457] = {.lex_state = 401, .external_lex_state = 16},
  [1458] = {.lex_state = 206},
  [1459] = {.lex_state = 303, .external_lex_state = 16},
  [1460] = {.lex_state = 303, .external_lex_state = 16},
  [1461] = {.lex_state = 303, .external_lex_state = 16},
  [1462] = {.lex_state = 418, .external_lex_state = 13},
  [1463] = {.lex_state = 403},
  [1464] = {.lex_state = 401, .external_lex_state = 16},
  [1465] = {.lex_state = 418, .external_lex_state = 13},
  [1466] = {.lex_state = 403},
  [1467] = {.lex_state = 401, .external_lex_state = 16},
  [1468] = {.lex_state = 418, .external_lex_state = 13},
  [1469] = {.lex_state = 418, .external_lex_state = 13},
  [1470] = {.lex_state = 281, .external_lex_state = 21},
  [1471] = {.lex_state = 436, .external_lex_state = 24},
  [1472] = {.lex_state = 436, .external_lex_state = 24},
  [1473] = {.lex_state = 206, .external_lex_state = 16},
  [1474] = {.lex_state = 401, .external_lex_state = 16},
  [1475] = {.lex_state = 281, .external_lex_state = 21},
  [1476] = {.lex_state = 399, .external_lex_state = 16},
  [1477] = {.lex_state = 281, .external_lex_state = 21},
  [1478] = {.lex_state = 403},
  [1479] = {.lex_state = 401, .external_lex_state = 16},
  [1480] = {.lex_state = 281, .external_lex_state = 21},
  [1481] = {.lex_state = 403},
  [1482] = {.lex_state = 401, .external_lex_state = 16},
  [1483] = {.lex_state = 403},
  [1484] = {.lex_state = 401, .external_lex_state = 16},
  [1485] = {.lex_state = 401, .external_lex_state = 16},
  [1486] = {.lex_state = 281, .external_lex_state = 21},
  [1487] = {.lex_state = 401, .external_lex_state = 16},
  [1488] = {.lex_state = 420, .external_lex_state = 10},
  [1489] = {.lex_state = 420, .external_lex_state = 10},
  [1490] = {.lex_state = 420, .external_lex_state = 10},
  [1491] = {.lex_state = 399, .external_lex_state = 16},
  [1492] = {.lex_state = 420, .external_lex_state = 10},
  [1493] = {.lex_state = 403},
  [1494] = {.lex_state = 401, .external_lex_state = 16},
  [1495] = {.lex_state = 206},
  [1496] = {.lex_state = 303, .external_lex_state = 16},
  [1497] = {.lex_state = 303, .external_lex_state = 16},
  [1498] = {.lex_state = 303, .external_lex_state = 16},
  [1499] = {.lex_state = 420, .external_lex_state = 10},
  [1500] = {.lex_state = 403},
  [1501] = {.lex_state = 401, .external_lex_state = 16},
  [1502] = {.lex_state = 420, .external_lex_state = 10},
  [1503] = {.lex_state = 403},
  [1504] = {.lex_state = 401, .external_lex_state = 16},
  [1505] = {.lex_state = 420, .external_lex_state = 10},
  [1506] = {.lex_state = 420, .external_lex_state = 10},
  [1507] = {.lex_state = 283, .external_lex_state = 4},
  [1508] = {.lex_state = 283, .external_lex_state = 4},
  [1509] = {.lex_state = 370, .external_lex_state = 2},
  [1510] = {.lex_state = 422, .external_lex_state = 2},
  [1511] = {.lex_state = 422, .external_lex_state = 2},
  [1512] = {.lex_state = 283, .external_lex_state = 4},
  [1513] = {.lex_state = 206},
  [1514] = {.lex_state = 234},
  [1515] = {.lex_state = 450, .external_lex_state = 2},
  [1516] = {.lex_state = 231},
  [1517] = {.lex_state = 444, .external_lex_state = 13},
  [1518] = {.lex_state = 450, .external_lex_state = 2},
  [1519] = {.lex_state = 231},
  [1520] = {.lex_state = 283, .external_lex_state = 4},
  [1521] = {.lex_state = 206},
  [1522] = {.lex_state = 234},
  [1523] = {.lex_state = 283, .external_lex_state = 4},
  [1524] = {.lex_state = 234},
  [1525] = {.lex_state = 283, .external_lex_state = 4},
  [1526] = {.lex_state = 206},
  [1527] = {.lex_state = 283, .external_lex_state = 4},
  [1528] = {.lex_state = 234},
  [1529] = {.lex_state = 274, .external_lex_state = 10},
  [1530] = {.lex_state = 274, .external_lex_state = 10},
  [1531] = {.lex_state = 274, .external_lex_state = 10},
  [1532] = {.lex_state = 401, .external_lex_state = 16},
  [1533] = {.lex_state = 436, .external_lex_state = 24},
  [1534] = {.lex_state = 436, .external_lex_state = 24},
  [1535] = {.lex_state = 206, .external_lex_state = 16},
  [1536] = {.lex_state = 401, .external_lex_state = 16},
  [1537] = {.lex_state = 274, .external_lex_state = 10},
  [1538] = {.lex_state = 401, .external_lex_state = 16},
  [1539] = {.lex_state = 274, .external_lex_state = 10},
  [1540] = {.lex_state = 401, .external_lex_state = 16},
  [1541] = {.lex_state = 274, .external_lex_state = 10},
  [1542] = {.lex_state = 401, .external_lex_state = 16},
  [1543] = {.lex_state = 274, .external_lex_state = 10},
  [1544] = {.lex_state = 401, .external_lex_state = 16},
  [1545] = {.lex_state = 283, .external_lex_state = 4},
  [1546] = {.lex_state = 446, .external_lex_state = 10},
  [1547] = {.lex_state = 446, .external_lex_state = 10},
  [1548] = {.lex_state = 283, .external_lex_state = 4},
  [1549] = {.lex_state = 446, .external_lex_state = 10},
  [1550] = {.lex_state = 281, .external_lex_state = 21},
  [1551] = {.lex_state = 432, .external_lex_state = 23},
  [1552] = {.lex_state = 234},
  [1553] = {.lex_state = 453, .external_lex_state = 10},
  [1554] = {.lex_state = 453, .external_lex_state = 10},
  [1555] = {.lex_state = 234},
  [1556] = {.lex_state = 387, .external_lex_state = 27},
  [1557] = {.lex_state = 387, .external_lex_state = 27},
  [1558] = {.lex_state = 387, .external_lex_state = 27},
  [1559] = {.lex_state = 387, .external_lex_state = 27},
  [1560] = {.lex_state = 387, .external_lex_state = 23},
  [1561] = {.lex_state = 387, .external_lex_state = 5},
  [1562] = {.lex_state = 320, .external_lex_state = 2},
  [1563] = {.lex_state = 286, .external_lex_state = 11},
  [1564] = {.lex_state = 286, .external_lex_state = 11},
  [1565] = {.lex_state = 286, .external_lex_state = 11},
  [1566] = {.lex_state = 401, .external_lex_state = 16},
  [1567] = {.lex_state = 436, .external_lex_state = 24},
  [1568] = {.lex_state = 436, .external_lex_state = 24},
  [1569] = {.lex_state = 206, .external_lex_state = 16},
  [1570] = {.lex_state = 401, .external_lex_state = 16},
  [1571] = {.lex_state = 286, .external_lex_state = 11},
  [1572] = {.lex_state = 401, .external_lex_state = 16},
  [1573] = {.lex_state = 286, .external_lex_state = 11},
  [1574] = {.lex_state = 401, .external_lex_state = 16},
  [1575] = {.lex_state = 286, .external_lex_state = 11},
  [1576] = {.lex_state = 401, .external_lex_state = 16},
  [1577] = {.lex_state = 286, .external_lex_state = 11},
  [1578] = {.lex_state = 401, .external_lex_state = 16},
  [1579] = {.lex_state = 358, .external_lex_state = 27},
  [1580] = {.lex_state = 358, .external_lex_state = 27},
  [1581] = {.lex_state = 412, .external_lex_state = 23},
  [1582] = {.lex_state = 234},
  [1583] = {.lex_state = 358, .external_lex_state = 27},
  [1584] = {.lex_state = 412, .external_lex_state = 27},
  [1585] = {.lex_state = 254},
  [1586] = {.lex_state = 412, .external_lex_state = 27},
  [1587] = {.lex_state = 412, .external_lex_state = 27},
  [1588] = {.lex_state = 412, .external_lex_state = 27},
  [1589] = {.lex_state = 206},
  [1590] = {.lex_state = 303, .external_lex_state = 16},
  [1591] = {.lex_state = 311, .external_lex_state = 6},
  [1592] = {.lex_state = 303, .external_lex_state = 16},
  [1593] = {.lex_state = 303, .external_lex_state = 16},
  [1594] = {.lex_state = 206},
  [1595] = {.lex_state = 320, .external_lex_state = 2},
  [1596] = {.lex_state = 206},
  [1597] = {.lex_state = 328, .external_lex_state = 2},
  [1598] = {.lex_state = 206},
  [1599] = {.lex_state = 320, .external_lex_state = 2},
  [1600] = {.lex_state = 396, .external_lex_state = 13},
  [1601] = {.lex_state = 396, .external_lex_state = 13},
  [1602] = {.lex_state = 396, .external_lex_state = 13},
  [1603] = {.lex_state = 401, .external_lex_state = 16},
  [1604] = {.lex_state = 436, .external_lex_state = 24},
  [1605] = {.lex_state = 436, .external_lex_state = 24},
  [1606] = {.lex_state = 206, .external_lex_state = 16},
  [1607] = {.lex_state = 401, .external_lex_state = 16},
  [1608] = {.lex_state = 396, .external_lex_state = 13},
  [1609] = {.lex_state = 401, .external_lex_state = 16},
  [1610] = {.lex_state = 396, .external_lex_state = 13},
  [1611] = {.lex_state = 401, .external_lex_state = 16},
  [1612] = {.lex_state = 396, .external_lex_state = 13},
  [1613] = {.lex_state = 401, .external_lex_state = 16},
  [1614] = {.lex_state = 396, .external_lex_state = 13},
  [1615] = {.lex_state = 401, .external_lex_state = 16},
  [1616] = {.lex_state = 277, .external_lex_state = 3},
  [1617] = {.lex_state = 277, .external_lex_state = 14},
  [1618] = {.lex_state = 277, .external_lex_state = 14},
  [1619] = {.lex_state = 277, .external_lex_state = 14},
  [1620] = {.lex_state = 401, .external_lex_state = 16},
  [1621] = {.lex_state = 436, .external_lex_state = 24},
  [1622] = {.lex_state = 436, .external_lex_state = 24},
  [1623] = {.lex_state = 206, .external_lex_state = 16},
  [1624] = {.lex_state = 401, .external_lex_state = 16},
  [1625] = {.lex_state = 277, .external_lex_state = 14},
  [1626] = {.lex_state = 401, .external_lex_state = 16},
  [1627] = {.lex_state = 277, .external_lex_state = 14},
  [1628] = {.lex_state = 401, .external_lex_state = 16},
  [1629] = {.lex_state = 277, .external_lex_state = 14},
  [1630] = {.lex_state = 401, .external_lex_state = 16},
  [1631] = {.lex_state = 277, .external_lex_state = 14},
  [1632] = {.lex_state = 401, .external_lex_state = 16},
  [1633] = {.lex_state = 277, .external_lex_state = 10},
  [1634] = {.lex_state = 277, .external_lex_state = 10},
  [1635] = {.lex_state = 277, .external_lex_state = 10},
  [1636] = {.lex_state = 401, .external_lex_state = 16},
  [1637] = {.lex_state = 436, .external_lex_state = 24},
  [1638] = {.lex_state = 436, .external_lex_state = 24},
  [1639] = {.lex_state = 206, .external_lex_state = 16},
  [1640] = {.lex_state = 401, .external_lex_state = 16},
  [1641] = {.lex_state = 277, .external_lex_state = 10},
  [1642] = {.lex_state = 401, .external_lex_state = 16},
  [1643] = {.lex_state = 277, .external_lex_state = 10},
  [1644] = {.lex_state = 401, .external_lex_state = 16},
  [1645] = {.lex_state = 277, .external_lex_state = 10},
  [1646] = {.lex_state = 401, .external_lex_state = 16},
  [1647] = {.lex_state = 277, .external_lex_state = 10},
  [1648] = {.lex_state = 401, .external_lex_state = 16},
  [1649] = {.lex_state = 320, .external_lex_state = 15},
  [1650] = {.lex_state = 320, .external_lex_state = 15},
  [1651] = {.lex_state = 320, .external_lex_state = 15},
  [1652] = {.lex_state = 401, .external_lex_state = 16},
  [1653] = {.lex_state = 436, .external_lex_state = 24},
  [1654] = {.lex_state = 436, .external_lex_state = 24},
  [1655] = {.lex_state = 206, .external_lex_state = 16},
  [1656] = {.lex_state = 401, .external_lex_state = 16},
  [1657] = {.lex_state = 320, .external_lex_state = 15},
  [1658] = {.lex_state = 401, .external_lex_state = 16},
  [1659] = {.lex_state = 320, .external_lex_state = 15},
  [1660] = {.lex_state = 401, .external_lex_state = 16},
  [1661] = {.lex_state = 320, .external_lex_state = 15},
  [1662] = {.lex_state = 401, .external_lex_state = 16},
  [1663] = {.lex_state = 320, .external_lex_state = 15},
  [1664] = {.lex_state = 401, .external_lex_state = 16},
  [1665] = {.lex_state = 254, .external_lex_state = 13},
  [1666] = {.lex_state = 254, .external_lex_state = 13},
  [1667] = {.lex_state = 254, .external_lex_state = 13},
  [1668] = {.lex_state = 401, .external_lex_state = 16},
  [1669] = {.lex_state = 436, .external_lex_state = 24},
  [1670] = {.lex_state = 436, .external_lex_state = 24},
  [1671] = {.lex_state = 206, .external_lex_state = 16},
  [1672] = {.lex_state = 401, .external_lex_state = 16},
  [1673] = {.lex_state = 254, .external_lex_state = 13},
  [1674] = {.lex_state = 401, .external_lex_state = 16},
  [1675] = {.lex_state = 254, .external_lex_state = 13},
  [1676] = {.lex_state = 401, .external_lex_state = 16},
  [1677] = {.lex_state = 254, .external_lex_state = 13},
  [1678] = {.lex_state = 401, .external_lex_state = 16},
  [1679] = {.lex_state = 254, .external_lex_state = 13},
  [1680] = {.lex_state = 401, .external_lex_state = 16},
  [1681] = {.lex_state = 303, .external_lex_state = 24},
  [1682] = {.lex_state = 303, .external_lex_state = 16},
  [1683] = {.lex_state = 303, .external_lex_state = 24},
  [1684] = {.lex_state = 303, .external_lex_state = 16},
  [1685] = {.lex_state = 436, .external_lex_state = 24},
  [1686] = {.lex_state = 436, .external_lex_state = 24},
  [1687] = {.lex_state = 436, .external_lex_state = 24},
  [1688] = {.lex_state = 399, .external_lex_state = 16},
  [1689] = {.lex_state = 436, .external_lex_state = 24},
  [1690] = {.lex_state = 403},
  [1691] = {.lex_state = 401, .external_lex_state = 16},
  [1692] = {.lex_state = 206},
  [1693] = {.lex_state = 303, .external_lex_state = 16},
  [1694] = {.lex_state = 303, .external_lex_state = 16},
  [1695] = {.lex_state = 303, .external_lex_state = 16},
  [1696] = {.lex_state = 436, .external_lex_state = 24},
  [1697] = {.lex_state = 403},
  [1698] = {.lex_state = 401, .external_lex_state = 16},
  [1699] = {.lex_state = 436, .external_lex_state = 24},
  [1700] = {.lex_state = 403},
  [1701] = {.lex_state = 401, .external_lex_state = 16},
  [1702] = {.lex_state = 436, .external_lex_state = 24},
  [1703] = {.lex_state = 436, .external_lex_state = 24},
  [1704] = {.lex_state = 401, .external_lex_state = 24},
  [1705] = {.lex_state = 436, .external_lex_state = 24},
  [1706] = {.lex_state = 436, .external_lex_state = 24},
  [1707] = {.lex_state = 206, .external_lex_state = 16},
  [1708] = {.lex_state = 401, .external_lex_state = 16},
  [1709] = {.lex_state = 401, .external_lex_state = 24},
  [1710] = {.lex_state = 399, .external_lex_state = 16},
  [1711] = {.lex_state = 401, .external_lex_state = 24},
  [1712] = {.lex_state = 403},
  [1713] = {.lex_state = 401, .external_lex_state = 16},
  [1714] = {.lex_state = 401, .external_lex_state = 24},
  [1715] = {.lex_state = 403},
  [1716] = {.lex_state = 401, .external_lex_state = 16},
  [1717] = {.lex_state = 403},
  [1718] = {.lex_state = 401, .external_lex_state = 16},
  [1719] = {.lex_state = 401, .external_lex_state = 16},
  [1720] = {.lex_state = 401, .external_lex_state = 24},
  [1721] = {.lex_state = 401, .external_lex_state = 16},
  [1722] = {.lex_state = 270, .external_lex_state = 5},
  [1723] = {.lex_state = 270, .external_lex_state = 5},
  [1724] = {.lex_state = 270, .external_lex_state = 5},
  [1725] = {.lex_state = 270, .external_lex_state = 5},
  [1726] = {.lex_state = 401, .external_lex_state = 16},
  [1727] = {.lex_state = 270, .external_lex_state = 5},
  [1728] = {.lex_state = 401, .external_lex_state = 16},
  [1729] = {.lex_state = 270, .external_lex_state = 5},
  [1730] = {.lex_state = 401, .external_lex_state = 16},
  [1731] = {.lex_state = 270, .external_lex_state = 5},
  [1732] = {.lex_state = 270, .external_lex_state = 5},
  [1733] = {.lex_state = 320, .external_lex_state = 15},
  [1734] = {.lex_state = 206},
  [1735] = {.lex_state = 206},
  [1736] = {.lex_state = 364, .external_lex_state = 2},
  [1737] = {.lex_state = 440, .external_lex_state = 18},
  [1738] = {.lex_state = 206},
  [1739] = {.lex_state = 206},
  [1740] = {.lex_state = 206},
  [1741] = {.lex_state = 206},
  [1742] = {.lex_state = 206},
  [1743] = {.lex_state = 206},
  [1744] = {.lex_state = 234},
  [1745] = {.lex_state = 424},
  [1746] = {.lex_state = 206},
  [1747] = {.lex_state = 206},
  [1748] = {.lex_state = 234},
  [1749] = {.lex_state = 424},
  [1750] = {.lex_state = 438, .external_lex_state = 26},
  [1751] = {.lex_state = 448, .external_lex_state = 26},
  [1752] = {.lex_state = 234},
  [1753] = {.lex_state = 455, .external_lex_state = 13},
  [1754] = {.lex_state = 455, .external_lex_state = 13},
  [1755] = {.lex_state = 206},
  [1756] = {.lex_state = 206},
  [1757] = {.lex_state = 234},
  [1758] = {.lex_state = 408, .external_lex_state = 28},
  [1759] = {.lex_state = 254},
  [1760] = {.lex_state = 261},
  [1761] = {.lex_state = 408, .external_lex_state = 28},
  [1762] = {.lex_state = 264, .external_lex_state = 6},
  [1763] = {.lex_state = 135, .external_lex_state = 2},
  [1764] = {.lex_state = 135, .external_lex_state = 2},
  [1765] = {.lex_state = 135, .external_lex_state = 2},
  [1766] = {.lex_state = 440, .external_lex_state = 26},
  [1767] = {.lex_state = 440, .external_lex_state = 26},
  [1768] = {.lex_state = 408, .external_lex_state = 28},
  [1769] = {.lex_state = 408, .external_lex_state = 28},
  [1770] = {.lex_state = 440, .external_lex_state = 26},
  [1771] = {.lex_state = 408, .external_lex_state = 26},
  [1772] = {.lex_state = 313, .external_lex_state = 6},
  [1773] = {.lex_state = 320},
  [1774] = {.lex_state = 313, .external_lex_state = 25},
  [1775] = {.lex_state = 436, .external_lex_state = 24},
  [1776] = {.lex_state = 436, .external_lex_state = 24},
  [1777] = {.lex_state = 206, .external_lex_state = 16},
  [1778] = {.lex_state = 401, .external_lex_state = 16},
  [1779] = {.lex_state = 313, .external_lex_state = 25},
  [1780] = {.lex_state = 399, .external_lex_state = 16},
  [1781] = {.lex_state = 313, .external_lex_state = 25},
  [1782] = {.lex_state = 403},
  [1783] = {.lex_state = 401, .external_lex_state = 16},
  [1784] = {.lex_state = 313, .external_lex_state = 25},
  [1785] = {.lex_state = 403},
  [1786] = {.lex_state = 401, .external_lex_state = 16},
  [1787] = {.lex_state = 403},
  [1788] = {.lex_state = 401, .external_lex_state = 16},
  [1789] = {.lex_state = 401, .external_lex_state = 16},
  [1790] = {.lex_state = 313, .external_lex_state = 25},
  [1791] = {.lex_state = 401, .external_lex_state = 16},
  [1792] = {.lex_state = 313, .external_lex_state = 13},
  [1793] = {.lex_state = 436, .external_lex_state = 24},
  [1794] = {.lex_state = 436, .external_lex_state = 24},
  [1795] = {.lex_state = 206, .external_lex_state = 16},
  [1796] = {.lex_state = 401, .external_lex_state = 16},
  [1797] = {.lex_state = 313, .external_lex_state = 13},
  [1798] = {.lex_state = 399, .external_lex_state = 16},
  [1799] = {.lex_state = 313, .external_lex_state = 13},
  [1800] = {.lex_state = 403},
  [1801] = {.lex_state = 401, .external_lex_state = 16},
  [1802] = {.lex_state = 313, .external_lex_state = 13},
  [1803] = {.lex_state = 403},
  [1804] = {.lex_state = 401, .external_lex_state = 16},
  [1805] = {.lex_state = 403},
  [1806] = {.lex_state = 401, .external_lex_state = 16},
  [1807] = {.lex_state = 401, .external_lex_state = 16},
  [1808] = {.lex_state = 313, .external_lex_state = 13},
  [1809] = {.lex_state = 401, .external_lex_state = 16},
  [1810] = {.lex_state = 315, .external_lex_state = 17},
  [1811] = {.lex_state = 315, .external_lex_state = 17},
  [1812] = {.lex_state = 315, .external_lex_state = 17},
  [1813] = {.lex_state = 401, .external_lex_state = 16},
  [1814] = {.lex_state = 436, .external_lex_state = 24},
  [1815] = {.lex_state = 436, .external_lex_state = 24},
  [1816] = {.lex_state = 206, .external_lex_state = 16},
  [1817] = {.lex_state = 401, .external_lex_state = 16},
  [1818] = {.lex_state = 315, .external_lex_state = 17},
  [1819] = {.lex_state = 401, .external_lex_state = 16},
  [1820] = {.lex_state = 315, .external_lex_state = 17},
  [1821] = {.lex_state = 401, .external_lex_state = 16},
  [1822] = {.lex_state = 315, .external_lex_state = 17},
  [1823] = {.lex_state = 401, .external_lex_state = 16},
  [1824] = {.lex_state = 315, .external_lex_state = 17},
  [1825] = {.lex_state = 401, .external_lex_state = 16},
  [1826] = {.lex_state = 206},
  [1827] = {.lex_state = 408, .external_lex_state = 17},
  [1828] = {.lex_state = 206},
  [1829] = {.lex_state = 328, .external_lex_state = 15},
  [1830] = {.lex_state = 442, .external_lex_state = 26},
  [1831] = {.lex_state = 234},
  [1832] = {.lex_state = 457, .external_lex_state = 13},
  [1833] = {.lex_state = 457, .external_lex_state = 13},
  [1834] = {.lex_state = 234},
  [1835] = {.lex_state = 410, .external_lex_state = 28},
  [1836] = {.lex_state = 410, .external_lex_state = 28},
  [1837] = {.lex_state = 410, .external_lex_state = 28},
  [1838] = {.lex_state = 410, .external_lex_state = 28},
  [1839] = {.lex_state = 410, .external_lex_state = 26},
  [1840] = {.lex_state = 410, .external_lex_state = 17},
  [1841] = {.lex_state = 333, .external_lex_state = 19},
  [1842] = {.lex_state = 436, .external_lex_state = 24},
  [1843] = {.lex_state = 436, .external_lex_state = 24},
  [1844] = {.lex_state = 206, .external_lex_state = 16},
  [1845] = {.lex_state = 401, .external_lex_state = 16},
  [1846] = {.lex_state = 333, .external_lex_state = 19},
  [1847] = {.lex_state = 399, .external_lex_state = 16},
  [1848] = {.lex_state = 333, .external_lex_state = 19},
  [1849] = {.lex_state = 403},
  [1850] = {.lex_state = 401, .external_lex_state = 16},
  [1851] = {.lex_state = 333, .external_lex_state = 19},
  [1852] = {.lex_state = 403},
  [1853] = {.lex_state = 401, .external_lex_state = 16},
  [1854] = {.lex_state = 403},
  [1855] = {.lex_state = 401, .external_lex_state = 16},
  [1856] = {.lex_state = 401, .external_lex_state = 16},
  [1857] = {.lex_state = 333, .external_lex_state = 19},
  [1858] = {.lex_state = 401, .external_lex_state = 16},
  [1859] = {.lex_state = 418, .external_lex_state = 13},
  [1860] = {.lex_state = 436, .external_lex_state = 24},
  [1861] = {.lex_state = 436, .external_lex_state = 24},
  [1862] = {.lex_state = 206, .external_lex_state = 16},
  [1863] = {.lex_state = 401, .external_lex_state = 16},
  [1864] = {.lex_state = 418, .external_lex_state = 13},
  [1865] = {.lex_state = 399, .external_lex_state = 16},
  [1866] = {.lex_state = 418, .external_lex_state = 13},
  [1867] = {.lex_state = 403},
  [1868] = {.lex_state = 401, .external_lex_state = 16},
  [1869] = {.lex_state = 418, .external_lex_state = 13},
  [1870] = {.lex_state = 403},
  [1871] = {.lex_state = 401, .external_lex_state = 16},
  [1872] = {.lex_state = 403},
  [1873] = {.lex_state = 401, .external_lex_state = 16},
  [1874] = {.lex_state = 401, .external_lex_state = 16},
  [1875] = {.lex_state = 418, .external_lex_state = 13},
  [1876] = {.lex_state = 401, .external_lex_state = 16},
  [1877] = {.lex_state = 281, .external_lex_state = 21},
  [1878] = {.lex_state = 281, .external_lex_state = 21},
  [1879] = {.lex_state = 281, .external_lex_state = 21},
  [1880] = {.lex_state = 401, .external_lex_state = 16},
  [1881] = {.lex_state = 436, .external_lex_state = 24},
  [1882] = {.lex_state = 436, .external_lex_state = 24},
  [1883] = {.lex_state = 206, .external_lex_state = 16},
  [1884] = {.lex_state = 401, .external_lex_state = 16},
  [1885] = {.lex_state = 281, .external_lex_state = 21},
  [1886] = {.lex_state = 401, .external_lex_state = 16},
  [1887] = {.lex_state = 281, .external_lex_state = 21},
  [1888] = {.lex_state = 401, .external_lex_state = 16},
  [1889] = {.lex_state = 281, .external_lex_state = 21},
  [1890] = {.lex_state = 401, .external_lex_state = 16},
  [1891] = {.lex_state = 281, .external_lex_state = 21},
  [1892] = {.lex_state = 401, .external_lex_state = 16},
  [1893] = {.lex_state = 420, .external_lex_state = 10},
  [1894] = {.lex_state = 436, .external_lex_state = 24},
  [1895] = {.lex_state = 436, .external_lex_state = 24},
  [1896] = {.lex_state = 206, .external_lex_state = 16},
  [1897] = {.lex_state = 401, .external_lex_state = 16},
  [1898] = {.lex_state = 420, .external_lex_state = 10},
  [1899] = {.lex_state = 399, .external_lex_state = 16},
  [1900] = {.lex_state = 420, .external_lex_state = 10},
  [1901] = {.lex_state = 403},
  [1902] = {.lex_state = 401, .external_lex_state = 16},
  [1903] = {.lex_state = 420, .external_lex_state = 10},
  [1904] = {.lex_state = 403},
  [1905] = {.lex_state = 401, .external_lex_state = 16},
  [1906] = {.lex_state = 403},
  [1907] = {.lex_state = 401, .external_lex_state = 16},
  [1908] = {.lex_state = 401, .external_lex_state = 16},
  [1909] = {.lex_state = 420, .external_lex_state = 10},
  [1910] = {.lex_state = 401, .external_lex_state = 16},
  [1911] = {.lex_state = 370, .external_lex_state = 2},
  [1912] = {.lex_state = 283, .external_lex_state = 4},
  [1913] = {.lex_state = 444, .external_lex_state = 13},
  [1914] = {.lex_state = 444, .external_lex_state = 13},
  [1915] = {.lex_state = 231},
  [1916] = {.lex_state = 206},
  [1917] = {.lex_state = 135, .external_lex_state = 2},
  [1918] = {.lex_state = 424},
  [1919] = {.lex_state = 234},
  [1920] = {.lex_state = 236, .external_lex_state = 2},
  [1921] = {.lex_state = 238},
  [1922] = {.lex_state = 238},
  [1923] = {.lex_state = 459, .external_lex_state = 3},
  [1924] = {.lex_state = 459, .external_lex_state = 4},
  [1925] = {.lex_state = 465, .external_lex_state = 5},
  [1926] = {.lex_state = 254},
  [1927] = {.lex_state = 261},
  [1928] = {.lex_state = 465, .external_lex_state = 5},
  [1929] = {.lex_state = 264, .external_lex_state = 6},
  [1930] = {.lex_state = 135, .external_lex_state = 2},
  [1931] = {.lex_state = 135, .external_lex_state = 2},
  [1932] = {.lex_state = 135, .external_lex_state = 2},
  [1933] = {.lex_state = 467, .external_lex_state = 5},
  [1934] = {.lex_state = 283, .external_lex_state = 4},
  [1935] = {.lex_state = 465, .external_lex_state = 7},
  [1936] = {.lex_state = 469, .external_lex_state = 8},
  [1937] = {.lex_state = 206},
  [1938] = {.lex_state = 465, .external_lex_state = 7},
  [1939] = {.lex_state = 450, .external_lex_state = 2},
  [1940] = {.lex_state = 234, .external_lex_state = 2},
  [1941] = {.lex_state = 450, .external_lex_state = 2},
  [1942] = {.lex_state = 231},
  [1943] = {.lex_state = 444, .external_lex_state = 13},
  [1944] = {.lex_state = 424},
  [1945] = {.lex_state = 283, .external_lex_state = 4},
  [1946] = {.lex_state = 469, .external_lex_state = 8},
  [1947] = {.lex_state = 450, .external_lex_state = 2},
  [1948] = {.lex_state = 450, .external_lex_state = 2},
  [1949] = {.lex_state = 283, .external_lex_state = 4},
  [1950] = {.lex_state = 444, .external_lex_state = 13},
  [1951] = {.lex_state = 444, .external_lex_state = 13},
  [1952] = {.lex_state = 231},
  [1953] = {.lex_state = 206},
  [1954] = {.lex_state = 283, .external_lex_state = 4},
  [1955] = {.lex_state = 206},
  [1956] = {.lex_state = 274, .external_lex_state = 10},
  [1957] = {.lex_state = 274, .external_lex_state = 10},
  [1958] = {.lex_state = 274, .external_lex_state = 10},
  [1959] = {.lex_state = 274, .external_lex_state = 10},
  [1960] = {.lex_state = 401, .external_lex_state = 16},
  [1961] = {.lex_state = 274, .external_lex_state = 10},
  [1962] = {.lex_state = 401, .external_lex_state = 16},
  [1963] = {.lex_state = 274, .external_lex_state = 10},
  [1964] = {.lex_state = 401, .external_lex_state = 16},
  [1965] = {.lex_state = 274, .external_lex_state = 10},
  [1966] = {.lex_state = 274, .external_lex_state = 10},
  [1967] = {.lex_state = 446, .external_lex_state = 10},
  [1968] = {.lex_state = 453, .external_lex_state = 10},
  [1969] = {.lex_state = 453, .external_lex_state = 10},
  [1970] = {.lex_state = 453, .external_lex_state = 10},
  [1971] = {.lex_state = 387, .external_lex_state = 27},
  [1972] = {.lex_state = 387, .external_lex_state = 27},
  [1973] = {.lex_state = 387, .external_lex_state = 27},
  [1974] = {.lex_state = 286, .external_lex_state = 11},
  [1975] = {.lex_state = 286, .external_lex_state = 11},
  [1976] = {.lex_state = 286, .external_lex_state = 11},
  [1977] = {.lex_state = 286, .external_lex_state = 11},
  [1978] = {.lex_state = 401, .external_lex_state = 16},
  [1979] = {.lex_state = 286, .external_lex_state = 11},
  [1980] = {.lex_state = 401, .external_lex_state = 16},
  [1981] = {.lex_state = 286, .external_lex_state = 11},
  [1982] = {.lex_state = 401, .external_lex_state = 16},
  [1983] = {.lex_state = 286, .external_lex_state = 11},
  [1984] = {.lex_state = 286, .external_lex_state = 11},
  [1985] = {.lex_state = 412, .external_lex_state = 27},
  [1986] = {.lex_state = 358, .external_lex_state = 27},
  [1987] = {.lex_state = 412, .external_lex_state = 27},
  [1988] = {.lex_state = 399, .external_lex_state = 16},
  [1989] = {.lex_state = 412, .external_lex_state = 27},
  [1990] = {.lex_state = 403},
  [1991] = {.lex_state = 401, .external_lex_state = 16},
  [1992] = {.lex_state = 206},
  [1993] = {.lex_state = 303, .external_lex_state = 16},
  [1994] = {.lex_state = 303, .external_lex_state = 16},
  [1995] = {.lex_state = 303, .external_lex_state = 16},
  [1996] = {.lex_state = 412, .external_lex_state = 27},
  [1997] = {.lex_state = 403},
  [1998] = {.lex_state = 401, .external_lex_state = 16},
  [1999] = {.lex_state = 412, .external_lex_state = 27},
  [2000] = {.lex_state = 403},
  [2001] = {.lex_state = 401, .external_lex_state = 16},
  [2002] = {.lex_state = 412, .external_lex_state = 27},
  [2003] = {.lex_state = 412, .external_lex_state = 27},
  [2004] = {.lex_state = 396, .external_lex_state = 13},
  [2005] = {.lex_state = 396, .external_lex_state = 13},
  [2006] = {.lex_state = 396, .external_lex_state = 13},
  [2007] = {.lex_state = 396, .external_lex_state = 13},
  [2008] = {.lex_state = 401, .external_lex_state = 16},
  [2009] = {.lex_state = 396, .external_lex_state = 13},
  [2010] = {.lex_state = 401, .external_lex_state = 16},
  [2011] = {.lex_state = 396, .external_lex_state = 13},
  [2012] = {.lex_state = 401, .external_lex_state = 16},
  [2013] = {.lex_state = 396, .external_lex_state = 13},
  [2014] = {.lex_state = 396, .external_lex_state = 13},
  [2015] = {.lex_state = 277, .external_lex_state = 14},
  [2016] = {.lex_state = 277, .external_lex_state = 14},
  [2017] = {.lex_state = 277, .external_lex_state = 14},
  [2018] = {.lex_state = 277, .external_lex_state = 14},
  [2019] = {.lex_state = 401, .external_lex_state = 16},
  [2020] = {.lex_state = 277, .external_lex_state = 14},
  [2021] = {.lex_state = 401, .external_lex_state = 16},
  [2022] = {.lex_state = 277, .external_lex_state = 14},
  [2023] = {.lex_state = 401, .external_lex_state = 16},
  [2024] = {.lex_state = 277, .external_lex_state = 14},
  [2025] = {.lex_state = 277, .external_lex_state = 14},
  [2026] = {.lex_state = 277, .external_lex_state = 10},
  [2027] = {.lex_state = 277, .external_lex_state = 10},
  [2028] = {.lex_state = 277, .external_lex_state = 10},
  [2029] = {.lex_state = 277, .external_lex_state = 10},
  [2030] = {.lex_state = 401, .external_lex_state = 16},
  [2031] = {.lex_state = 277, .external_lex_state = 10},
  [2032] = {.lex_state = 401, .external_lex_state = 16},
  [2033] = {.lex_state = 277, .external_lex_state = 10},
  [2034] = {.lex_state = 401, .external_lex_state = 16},
  [2035] = {.lex_state = 277, .external_lex_state = 10},
  [2036] = {.lex_state = 277, .external_lex_state = 10},
  [2037] = {.lex_state = 320, .external_lex_state = 15},
  [2038] = {.lex_state = 320, .external_lex_state = 15},
  [2039] = {.lex_state = 320, .external_lex_state = 15},
  [2040] = {.lex_state = 320, .external_lex_state = 15},
  [2041] = {.lex_state = 401, .external_lex_state = 16},
  [2042] = {.lex_state = 320, .external_lex_state = 15},
  [2043] = {.lex_state = 401, .external_lex_state = 16},
  [2044] = {.lex_state = 320, .external_lex_state = 15},
  [2045] = {.lex_state = 401, .external_lex_state = 16},
  [2046] = {.lex_state = 320, .external_lex_state = 15},
  [2047] = {.lex_state = 320, .external_lex_state = 15},
  [2048] = {.lex_state = 254, .external_lex_state = 13},
  [2049] = {.lex_state = 254, .external_lex_state = 13},
  [2050] = {.lex_state = 254, .external_lex_state = 13},
  [2051] = {.lex_state = 254, .external_lex_state = 13},
  [2052] = {.lex_state = 401, .external_lex_state = 16},
  [2053] = {.lex_state = 254, .external_lex_state = 13},
  [2054] = {.lex_state = 401, .external_lex_state = 16},
  [2055] = {.lex_state = 254, .external_lex_state = 13},
  [2056] = {.lex_state = 401, .external_lex_state = 16},
  [2057] = {.lex_state = 254, .external_lex_state = 13},
  [2058] = {.lex_state = 254, .external_lex_state = 13},
  [2059] = {.lex_state = 303, .external_lex_state = 16},
  [2060] = {.lex_state = 303, .external_lex_state = 16},
  [2061] = {.lex_state = 436, .external_lex_state = 24},
  [2062] = {.lex_state = 436, .external_lex_state = 24},
  [2063] = {.lex_state = 436, .external_lex_state = 24},
  [2064] = {.lex_state = 206, .external_lex_state = 16},
  [2065] = {.lex_state = 401, .external_lex_state = 16},
  [2066] = {.lex_state = 436, .external_lex_state = 24},
  [2067] = {.lex_state = 399, .external_lex_state = 16},
  [2068] = {.lex_state = 436, .external_lex_state = 24},
  [2069] = {.lex_state = 403},
  [2070] = {.lex_state = 401, .external_lex_state = 16},
  [2071] = {.lex_state = 436, .external_lex_state = 24},
  [2072] = {.lex_state = 403},
  [2073] = {.lex_state = 401, .external_lex_state = 16},
  [2074] = {.lex_state = 403},
  [2075] = {.lex_state = 401, .external_lex_state = 16},
  [2076] = {.lex_state = 401, .external_lex_state = 16},
  [2077] = {.lex_state = 436, .external_lex_state = 24},
  [2078] = {.lex_state = 401, .external_lex_state = 16},
  [2079] = {.lex_state = 401, .external_lex_state = 24},
  [2080] = {.lex_state = 401, .external_lex_state = 24},
  [2081] = {.lex_state = 401, .external_lex_state = 24},
  [2082] = {.lex_state = 401, .external_lex_state = 16},
  [2083] = {.lex_state = 436, .external_lex_state = 24},
  [2084] = {.lex_state = 436, .external_lex_state = 24},
  [2085] = {.lex_state = 206, .external_lex_state = 16},
  [2086] = {.lex_state = 401, .external_lex_state = 16},
  [2087] = {.lex_state = 401, .external_lex_state = 24},
  [2088] = {.lex_state = 401, .external_lex_state = 16},
  [2089] = {.lex_state = 401, .external_lex_state = 24},
  [2090] = {.lex_state = 401, .external_lex_state = 16},
  [2091] = {.lex_state = 401, .external_lex_state = 24},
  [2092] = {.lex_state = 401, .external_lex_state = 16},
  [2093] = {.lex_state = 401, .external_lex_state = 24},
  [2094] = {.lex_state = 401, .external_lex_state = 16},
  [2095] = {.lex_state = 270, .external_lex_state = 5},
  [2096] = {.lex_state = 270, .external_lex_state = 5},
  [2097] = {.lex_state = 270, .external_lex_state = 5},
  [2098] = {.lex_state = 206},
  [2099] = {.lex_state = 206},
  [2100] = {.lex_state = 206},
  [2101] = {.lex_state = 206},
  [2102] = {.lex_state = 206},
  [2103] = {.lex_state = 206},
  [2104] = {.lex_state = 206},
  [2105] = {.lex_state = 234},
  [2106] = {.lex_state = 206},
  [2107] = {.lex_state = 206},
  [2108] = {.lex_state = 206},
  [2109] = {.lex_state = 234},
  [2110] = {.lex_state = 206},
  [2111] = {.lex_state = 455, .external_lex_state = 13},
  [2112] = {.lex_state = 455, .external_lex_state = 13},
  [2113] = {.lex_state = 206},
  [2114] = {.lex_state = 455, .external_lex_state = 13},
  [2115] = {.lex_state = 408, .external_lex_state = 28},
  [2116] = {.lex_state = 408, .external_lex_state = 28},
  [2117] = {.lex_state = 440, .external_lex_state = 26},
  [2118] = {.lex_state = 234},
  [2119] = {.lex_state = 408, .external_lex_state = 28},
  [2120] = {.lex_state = 440, .external_lex_state = 28},
  [2121] = {.lex_state = 254},
  [2122] = {.lex_state = 440, .external_lex_state = 28},
  [2123] = {.lex_state = 440, .external_lex_state = 28},
  [2124] = {.lex_state = 440, .external_lex_state = 28},
  [2125] = {.lex_state = 206},
  [2126] = {.lex_state = 303, .external_lex_state = 16},
  [2127] = {.lex_state = 311, .external_lex_state = 6},
  [2128] = {.lex_state = 303, .external_lex_state = 16},
  [2129] = {.lex_state = 303, .external_lex_state = 16},
  [2130] = {.lex_state = 206},
  [2131] = {.lex_state = 320, .external_lex_state = 2},
  [2132] = {.lex_state = 206},
  [2133] = {.lex_state = 328, .external_lex_state = 2},
  [2134] = {.lex_state = 206},
  [2135] = {.lex_state = 320, .external_lex_state = 2},
  [2136] = {.lex_state = 313, .external_lex_state = 6},
  [2137] = {.lex_state = 313, .external_lex_state = 25},
  [2138] = {.lex_state = 313, .external_lex_state = 25},
  [2139] = {.lex_state = 313, .external_lex_state = 25},
  [2140] = {.lex_state = 401, .external_lex_state = 16},
  [2141] = {.lex_state = 436, .external_lex_state = 24},
  [2142] = {.lex_state = 436, .external_lex_state = 24},
  [2143] = {.lex_state = 206, .external_lex_state = 16},
  [2144] = {.lex_state = 401, .external_lex_state = 16},
  [2145] = {.lex_state = 313, .external_lex_state = 25},
  [2146] = {.lex_state = 401, .external_lex_state = 16},
  [2147] = {.lex_state = 313, .external_lex_state = 25},
  [2148] = {.lex_state = 401, .external_lex_state = 16},
  [2149] = {.lex_state = 313, .external_lex_state = 25},
  [2150] = {.lex_state = 401, .external_lex_state = 16},
  [2151] = {.lex_state = 313, .external_lex_state = 25},
  [2152] = {.lex_state = 401, .external_lex_state = 16},
  [2153] = {.lex_state = 313, .external_lex_state = 13},
  [2154] = {.lex_state = 313, .external_lex_state = 13},
  [2155] = {.lex_state = 313, .external_lex_state = 13},
  [2156] = {.lex_state = 401, .external_lex_state = 16},
  [2157] = {.lex_state = 436, .external_lex_state = 24},
  [2158] = {.lex_state = 436, .external_lex_state = 24},
  [2159] = {.lex_state = 206, .external_lex_state = 16},
  [2160] = {.lex_state = 401, .external_lex_state = 16},
  [2161] = {.lex_state = 313, .external_lex_state = 13},
  [2162] = {.lex_state = 401, .external_lex_state = 16},
  [2163] = {.lex_state = 313, .external_lex_state = 13},
  [2164] = {.lex_state = 401, .external_lex_state = 16},
  [2165] = {.lex_state = 313, .external_lex_state = 13},
  [2166] = {.lex_state = 401, .external_lex_state = 16},
  [2167] = {.lex_state = 313, .external_lex_state = 13},
  [2168] = {.lex_state = 401, .external_lex_state = 16},
  [2169] = {.lex_state = 315, .external_lex_state = 17},
  [2170] = {.lex_state = 315, .external_lex_state = 17},
  [2171] = {.lex_state = 315, .external_lex_state = 17},
  [2172] = {.lex_state = 315, .external_lex_state = 17},
  [2173] = {.lex_state = 401, .external_lex_state = 16},
  [2174] = {.lex_state = 315, .external_lex_state = 17},
  [2175] = {.lex_state = 401, .external_lex_state = 16},
  [2176] = {.lex_state = 315, .external_lex_state = 17},
  [2177] = {.lex_state = 401, .external_lex_state = 16},
  [2178] = {.lex_state = 315, .external_lex_state = 17},
  [2179] = {.lex_state = 315, .external_lex_state = 17},
  [2180] = {.lex_state = 457, .external_lex_state = 13},
  [2181] = {.lex_state = 457, .external_lex_state = 13},
  [2182] = {.lex_state = 457, .external_lex_state = 13},
  [2183] = {.lex_state = 410, .external_lex_state = 28},
  [2184] = {.lex_state = 410, .external_lex_state = 28},
  [2185] = {.lex_state = 410, .external_lex_state = 28},
  [2186] = {.lex_state = 333, .external_lex_state = 19},
  [2187] = {.lex_state = 333, .external_lex_state = 19},
  [2188] = {.lex_state = 333, .external_lex_state = 19},
  [2189] = {.lex_state = 401, .external_lex_state = 16},
  [2190] = {.lex_state = 436, .external_lex_state = 24},
  [2191] = {.lex_state = 436, .external_lex_state = 24},
  [2192] = {.lex_state = 206, .external_lex_state = 16},
  [2193] = {.lex_state = 401, .external_lex_state = 16},
  [2194] = {.lex_state = 333, .external_lex_state = 19},
  [2195] = {.lex_state = 401, .external_lex_state = 16},
  [2196] = {.lex_state = 333, .external_lex_state = 19},
  [2197] = {.lex_state = 401, .external_lex_state = 16},
  [2198] = {.lex_state = 333, .external_lex_state = 19},
  [2199] = {.lex_state = 401, .external_lex_state = 16},
  [2200] = {.lex_state = 333, .external_lex_state = 19},
  [2201] = {.lex_state = 401, .external_lex_state = 16},
  [2202] = {.lex_state = 418, .external_lex_state = 13},
  [2203] = {.lex_state = 418, .external_lex_state = 13},
  [2204] = {.lex_state = 418, .external_lex_state = 13},
  [2205] = {.lex_state = 401, .external_lex_state = 16},
  [2206] = {.lex_state = 436, .external_lex_state = 24},
  [2207] = {.lex_state = 436, .external_lex_state = 24},
  [2208] = {.lex_state = 206, .external_lex_state = 16},
  [2209] = {.lex_state = 401, .external_lex_state = 16},
  [2210] = {.lex_state = 418, .external_lex_state = 13},
  [2211] = {.lex_state = 401, .external_lex_state = 16},
  [2212] = {.lex_state = 418, .external_lex_state = 13},
  [2213] = {.lex_state = 401, .external_lex_state = 16},
  [2214] = {.lex_state = 418, .external_lex_state = 13},
  [2215] = {.lex_state = 401, .external_lex_state = 16},
  [2216] = {.lex_state = 418, .external_lex_state = 13},
  [2217] = {.lex_state = 401, .external_lex_state = 16},
  [2218] = {.lex_state = 281, .external_lex_state = 21},
  [2219] = {.lex_state = 281, .external_lex_state = 21},
  [2220] = {.lex_state = 281, .external_lex_state = 21},
  [2221] = {.lex_state = 281, .external_lex_state = 21},
  [2222] = {.lex_state = 401, .external_lex_state = 16},
  [2223] = {.lex_state = 281, .external_lex_state = 21},
  [2224] = {.lex_state = 401, .external_lex_state = 16},
  [2225] = {.lex_state = 281, .external_lex_state = 21},
  [2226] = {.lex_state = 401, .external_lex_state = 16},
  [2227] = {.lex_state = 281, .external_lex_state = 21},
  [2228] = {.lex_state = 281, .external_lex_state = 21},
  [2229] = {.lex_state = 420, .external_lex_state = 10},
  [2230] = {.lex_state = 420, .external_lex_state = 10},
  [2231] = {.lex_state = 420, .external_lex_state = 10},
  [2232] = {.lex_state = 401, .external_lex_state = 16},
  [2233] = {.lex_state = 436, .external_lex_state = 24},
  [2234] = {.lex_state = 436, .external_lex_state = 24},
  [2235] = {.lex_state = 206, .external_lex_state = 16},
  [2236] = {.lex_state = 401, .external_lex_state = 16},
  [2237] = {.lex_state = 420, .external_lex_state = 10},
  [2238] = {.lex_state = 401, .external_lex_state = 16},
  [2239] = {.lex_state = 420, .external_lex_state = 10},
  [2240] = {.lex_state = 401, .external_lex_state = 16},
  [2241] = {.lex_state = 420, .external_lex_state = 10},
  [2242] = {.lex_state = 401, .external_lex_state = 16},
  [2243] = {.lex_state = 420, .external_lex_state = 10},
  [2244] = {.lex_state = 401, .external_lex_state = 16},
  [2245] = {.lex_state = 272, .external_lex_state = 9},
  [2246] = {.lex_state = 206},
  [2247] = {.lex_state = 206},
  [2248] = {.lex_state = 286, .external_lex_state = 12},
  [2249] = {.lex_state = 294},
  [2250] = {.lex_state = 206},
  [2251] = {.lex_state = 459, .external_lex_state = 14},
  [2252] = {.lex_state = 254},
  [2253] = {.lex_state = 261},
  [2254] = {.lex_state = 459, .external_lex_state = 14},
  [2255] = {.lex_state = 264, .external_lex_state = 6},
  [2256] = {.lex_state = 135, .external_lex_state = 2},
  [2257] = {.lex_state = 135, .external_lex_state = 2},
  [2258] = {.lex_state = 135, .external_lex_state = 2},
  [2259] = {.lex_state = 459, .external_lex_state = 3},
  [2260] = {.lex_state = 206},
  [2261] = {.lex_state = 459, .external_lex_state = 3},
  [2262] = {.lex_state = 459, .external_lex_state = 10},
  [2263] = {.lex_state = 254},
  [2264] = {.lex_state = 261},
  [2265] = {.lex_state = 459, .external_lex_state = 10},
  [2266] = {.lex_state = 264, .external_lex_state = 6},
  [2267] = {.lex_state = 135, .external_lex_state = 2},
  [2268] = {.lex_state = 135, .external_lex_state = 2},
  [2269] = {.lex_state = 135, .external_lex_state = 2},
  [2270] = {.lex_state = 459, .external_lex_state = 4},
  [2271] = {.lex_state = 459, .external_lex_state = 4},
  [2272] = {.lex_state = 234},
  [2273] = {.lex_state = 465, .external_lex_state = 5},
  [2274] = {.lex_state = 465, .external_lex_state = 5},
  [2275] = {.lex_state = 254},
  [2276] = {.lex_state = 465, .external_lex_state = 5},
  [2277] = {.lex_state = 465, .external_lex_state = 5},
  [2278] = {.lex_state = 465, .external_lex_state = 5},
  [2279] = {.lex_state = 206},
  [2280] = {.lex_state = 303, .external_lex_state = 16},
  [2281] = {.lex_state = 311, .external_lex_state = 6},
  [2282] = {.lex_state = 303, .external_lex_state = 16},
  [2283] = {.lex_state = 303, .external_lex_state = 16},
  [2284] = {.lex_state = 206},
  [2285] = {.lex_state = 320, .external_lex_state = 2},
  [2286] = {.lex_state = 206},
  [2287] = {.lex_state = 328, .external_lex_state = 2},
  [2288] = {.lex_state = 206},
  [2289] = {.lex_state = 320, .external_lex_state = 2},
  [2290] = {.lex_state = 206},
  [2291] = {.lex_state = 135, .external_lex_state = 2},
  [2292] = {.lex_state = 450, .external_lex_state = 2},
  [2293] = {.lex_state = 135, .external_lex_state = 2},
  [2294] = {.lex_state = 450, .external_lex_state = 2},
  [2295] = {.lex_state = 135},
  [2296] = {.lex_state = 336},
  [2297] = {.lex_state = 234},
  [2298] = {.lex_state = 234},
  [2299] = {.lex_state = 465, .external_lex_state = 5},
  [2300] = {.lex_state = 465, .external_lex_state = 5},
  [2301] = {.lex_state = 471, .external_lex_state = 7},
  [2302] = {.lex_state = 465, .external_lex_state = 7},
  [2303] = {.lex_state = 424},
  [2304] = {.lex_state = 283, .external_lex_state = 4},
  [2305] = {.lex_state = 469, .external_lex_state = 8},
  [2306] = {.lex_state = 450, .external_lex_state = 2},
  [2307] = {.lex_state = 465, .external_lex_state = 7},
  [2308] = {.lex_state = 450, .external_lex_state = 2},
  [2309] = {.lex_state = 450, .external_lex_state = 2},
  [2310] = {.lex_state = 424},
  [2311] = {.lex_state = 283, .external_lex_state = 4},
  [2312] = {.lex_state = 469, .external_lex_state = 8},
  [2313] = {.lex_state = 450, .external_lex_state = 2},
  [2314] = {.lex_state = 330, .external_lex_state = 2},
  [2315] = {.lex_state = 231},
  [2316] = {.lex_state = 330, .external_lex_state = 2},
  [2317] = {.lex_state = 231},
  [2318] = {.lex_state = 283, .external_lex_state = 4},
  [2319] = {.lex_state = 283, .external_lex_state = 4},
  [2320] = {.lex_state = 274, .external_lex_state = 10},
  [2321] = {.lex_state = 274, .external_lex_state = 10},
  [2322] = {.lex_state = 274, .external_lex_state = 10},
  [2323] = {.lex_state = 453, .external_lex_state = 10},
  [2324] = {.lex_state = 387, .external_lex_state = 27},
  [2325] = {.lex_state = 286, .external_lex_state = 11},
  [2326] = {.lex_state = 286, .external_lex_state = 11},
  [2327] = {.lex_state = 286, .external_lex_state = 11},
  [2328] = {.lex_state = 412, .external_lex_state = 27},
  [2329] = {.lex_state = 436, .external_lex_state = 24},
  [2330] = {.lex_state = 436, .external_lex_state = 24},
  [2331] = {.lex_state = 206, .external_lex_state = 16},
  [2332] = {.lex_state = 401, .external_lex_state = 16},
  [2333] = {.lex_state = 412, .external_lex_state = 27},
  [2334] = {.lex_state = 399, .external_lex_state = 16},
  [2335] = {.lex_state = 412, .external_lex_state = 27},
  [2336] = {.lex_state = 403},
  [2337] = {.lex_state = 401, .external_lex_state = 16},
  [2338] = {.lex_state = 412, .external_lex_state = 27},
  [2339] = {.lex_state = 403},
  [2340] = {.lex_state = 401, .external_lex_state = 16},
  [2341] = {.lex_state = 403},
  [2342] = {.lex_state = 401, .external_lex_state = 16},
  [2343] = {.lex_state = 401, .external_lex_state = 16},
  [2344] = {.lex_state = 412, .external_lex_state = 27},
  [2345] = {.lex_state = 401, .external_lex_state = 16},
  [2346] = {.lex_state = 396, .external_lex_state = 13},
  [2347] = {.lex_state = 396, .external_lex_state = 13},
  [2348] = {.lex_state = 396, .external_lex_state = 13},
  [2349] = {.lex_state = 277, .external_lex_state = 14},
  [2350] = {.lex_state = 277, .external_lex_state = 14},
  [2351] = {.lex_state = 277, .external_lex_state = 14},
  [2352] = {.lex_state = 277, .external_lex_state = 10},
  [2353] = {.lex_state = 277, .external_lex_state = 10},
  [2354] = {.lex_state = 277, .external_lex_state = 10},
  [2355] = {.lex_state = 320, .external_lex_state = 15},
  [2356] = {.lex_state = 320, .external_lex_state = 15},
  [2357] = {.lex_state = 320, .external_lex_state = 15},
  [2358] = {.lex_state = 254, .external_lex_state = 13},
  [2359] = {.lex_state = 254, .external_lex_state = 13},
  [2360] = {.lex_state = 254, .external_lex_state = 13},
  [2361] = {.lex_state = 436, .external_lex_state = 24},
  [2362] = {.lex_state = 436, .external_lex_state = 24},
  [2363] = {.lex_state = 436, .external_lex_state = 24},
  [2364] = {.lex_state = 401, .external_lex_state = 16},
  [2365] = {.lex_state = 436, .external_lex_state = 24},
  [2366] = {.lex_state = 436, .external_lex_state = 24},
  [2367] = {.lex_state = 206, .external_lex_state = 16},
  [2368] = {.lex_state = 401, .external_lex_state = 16},
  [2369] = {.lex_state = 436, .external_lex_state = 24},
  [2370] = {.lex_state = 401, .external_lex_state = 16},
  [2371] = {.lex_state = 436, .external_lex_state = 24},
  [2372] = {.lex_state = 401, .external_lex_state = 16},
  [2373] = {.lex_state = 436, .external_lex_state = 24},
  [2374] = {.lex_state = 401, .external_lex_state = 16},
  [2375] = {.lex_state = 436, .external_lex_state = 24},
  [2376] = {.lex_state = 401, .external_lex_state = 16},
  [2377] = {.lex_state = 401, .external_lex_state = 24},
  [2378] = {.lex_state = 401, .external_lex_state = 24},
  [2379] = {.lex_state = 401, .external_lex_state = 24},
  [2380] = {.lex_state = 401, .external_lex_state = 24},
  [2381] = {.lex_state = 401, .external_lex_state = 16},
  [2382] = {.lex_state = 401, .external_lex_state = 24},
  [2383] = {.lex_state = 401, .external_lex_state = 16},
  [2384] = {.lex_state = 401, .external_lex_state = 24},
  [2385] = {.lex_state = 401, .external_lex_state = 16},
  [2386] = {.lex_state = 401, .external_lex_state = 24},
  [2387] = {.lex_state = 401, .external_lex_state = 24},
  [2388] = {.lex_state = 206},
  [2389] = {.lex_state = 206},
  [2390] = {.lex_state = 206},
  [2391] = {.lex_state = 206},
  [2392] = {.lex_state = 206},
  [2393] = {.lex_state = 455, .external_lex_state = 13},
  [2394] = {.lex_state = 440, .external_lex_state = 28},
  [2395] = {.lex_state = 408, .external_lex_state = 28},
  [2396] = {.lex_state = 440, .external_lex_state = 28},
  [2397] = {.lex_state = 399, .external_lex_state = 16},
  [2398] = {.lex_state = 440, .external_lex_state = 28},
  [2399] = {.lex_state = 403},
  [2400] = {.lex_state = 401, .external_lex_state = 16},
  [2401] = {.lex_state = 206},
  [2402] = {.lex_state = 303, .external_lex_state = 16},
  [2403] = {.lex_state = 303, .external_lex_state = 16},
  [2404] = {.lex_state = 303, .external_lex_state = 16},
  [2405] = {.lex_state = 440, .external_lex_state = 28},
  [2406] = {.lex_state = 403},
  [2407] = {.lex_state = 401, .external_lex_state = 16},
  [2408] = {.lex_state = 440, .external_lex_state = 28},
  [2409] = {.lex_state = 403},
  [2410] = {.lex_state = 401, .external_lex_state = 16},
  [2411] = {.lex_state = 440, .external_lex_state = 28},
  [2412] = {.lex_state = 440, .external_lex_state = 28},
  [2413] = {.lex_state = 313, .external_lex_state = 25},
  [2414] = {.lex_state = 313, .external_lex_state = 25},
  [2415] = {.lex_state = 313, .external_lex_state = 25},
  [2416] = {.lex_state = 313, .external_lex_state = 25},
  [2417] = {.lex_state = 401, .external_lex_state = 16},
  [2418] = {.lex_state = 313, .external_lex_state = 25},
  [2419] = {.lex_state = 401, .external_lex_state = 16},
  [2420] = {.lex_state = 313, .external_lex_state = 25},
  [2421] = {.lex_state = 401, .external_lex_state = 16},
  [2422] = {.lex_state = 313, .external_lex_state = 25},
  [2423] = {.lex_state = 313, .external_lex_state = 25},
  [2424] = {.lex_state = 313, .external_lex_state = 13},
  [2425] = {.lex_state = 313, .external_lex_state = 13},
  [2426] = {.lex_state = 313, .external_lex_state = 13},
  [2427] = {.lex_state = 313, .external_lex_state = 13},
  [2428] = {.lex_state = 401, .external_lex_state = 16},
  [2429] = {.lex_state = 313, .external_lex_state = 13},
  [2430] = {.lex_state = 401, .external_lex_state = 16},
  [2431] = {.lex_state = 313, .external_lex_state = 13},
  [2432] = {.lex_state = 401, .external_lex_state = 16},
  [2433] = {.lex_state = 313, .external_lex_state = 13},
  [2434] = {.lex_state = 313, .external_lex_state = 13},
  [2435] = {.lex_state = 315, .external_lex_state = 17},
  [2436] = {.lex_state = 315, .external_lex_state = 17},
  [2437] = {.lex_state = 315, .external_lex_state = 17},
  [2438] = {.lex_state = 457, .external_lex_state = 13},
  [2439] = {.lex_state = 410, .external_lex_state = 28},
  [2440] = {.lex_state = 333, .external_lex_state = 19},
  [2441] = {.lex_state = 333, .external_lex_state = 19},
  [2442] = {.lex_state = 333, .external_lex_state = 19},
  [2443] = {.lex_state = 333, .external_lex_state = 19},
  [2444] = {.lex_state = 401, .external_lex_state = 16},
  [2445] = {.lex_state = 333, .external_lex_state = 19},
  [2446] = {.lex_state = 401, .external_lex_state = 16},
  [2447] = {.lex_state = 333, .external_lex_state = 19},
  [2448] = {.lex_state = 401, .external_lex_state = 16},
  [2449] = {.lex_state = 333, .external_lex_state = 19},
  [2450] = {.lex_state = 333, .external_lex_state = 19},
  [2451] = {.lex_state = 418, .external_lex_state = 13},
  [2452] = {.lex_state = 418, .external_lex_state = 13},
  [2453] = {.lex_state = 418, .external_lex_state = 13},
  [2454] = {.lex_state = 418, .external_lex_state = 13},
  [2455] = {.lex_state = 401, .external_lex_state = 16},
  [2456] = {.lex_state = 418, .external_lex_state = 13},
  [2457] = {.lex_state = 401, .external_lex_state = 16},
  [2458] = {.lex_state = 418, .external_lex_state = 13},
  [2459] = {.lex_state = 401, .external_lex_state = 16},
  [2460] = {.lex_state = 418, .external_lex_state = 13},
  [2461] = {.lex_state = 418, .external_lex_state = 13},
  [2462] = {.lex_state = 281, .external_lex_state = 21},
  [2463] = {.lex_state = 281, .external_lex_state = 21},
  [2464] = {.lex_state = 281, .external_lex_state = 21},
  [2465] = {.lex_state = 420, .external_lex_state = 10},
  [2466] = {.lex_state = 420, .external_lex_state = 10},
  [2467] = {.lex_state = 420, .external_lex_state = 10},
  [2468] = {.lex_state = 420, .external_lex_state = 10},
  [2469] = {.lex_state = 401, .external_lex_state = 16},
  [2470] = {.lex_state = 420, .external_lex_state = 10},
  [2471] = {.lex_state = 401, .external_lex_state = 16},
  [2472] = {.lex_state = 420, .external_lex_state = 10},
  [2473] = {.lex_state = 401, .external_lex_state = 16},
  [2474] = {.lex_state = 420, .external_lex_state = 10},
  [2475] = {.lex_state = 420, .external_lex_state = 10},
  [2476] = {.lex_state = 469, .external_lex_state = 8},
  [2477] = {.lex_state = 320},
  [2478] = {.lex_state = 469, .external_lex_state = 21},
  [2479] = {.lex_state = 254},
  [2480] = {.lex_state = 261},
  [2481] = {.lex_state = 469, .external_lex_state = 21},
  [2482] = {.lex_state = 264, .external_lex_state = 6},
  [2483] = {.lex_state = 135, .external_lex_state = 2},
  [2484] = {.lex_state = 135, .external_lex_state = 2},
  [2485] = {.lex_state = 135, .external_lex_state = 2},
  [2486] = {.lex_state = 471, .external_lex_state = 7},
  [2487] = {.lex_state = 206},
  [2488] = {.lex_state = 473, .external_lex_state = 23},
  [2489] = {.lex_state = 471, .external_lex_state = 23},
  [2490] = {.lex_state = 272, .external_lex_state = 9},
  [2491] = {.lex_state = 234},
  [2492] = {.lex_state = 459, .external_lex_state = 14},
  [2493] = {.lex_state = 459, .external_lex_state = 14},
  [2494] = {.lex_state = 254},
  [2495] = {.lex_state = 459, .external_lex_state = 14},
  [2496] = {.lex_state = 459, .external_lex_state = 14},
  [2497] = {.lex_state = 459, .external_lex_state = 14},
  [2498] = {.lex_state = 206},
  [2499] = {.lex_state = 303, .external_lex_state = 16},
  [2500] = {.lex_state = 311, .external_lex_state = 6},
  [2501] = {.lex_state = 303, .external_lex_state = 16},
  [2502] = {.lex_state = 303, .external_lex_state = 16},
  [2503] = {.lex_state = 206},
  [2504] = {.lex_state = 320, .external_lex_state = 2},
  [2505] = {.lex_state = 206},
  [2506] = {.lex_state = 328, .external_lex_state = 2},
  [2507] = {.lex_state = 206},
  [2508] = {.lex_state = 320, .external_lex_state = 2},
  [2509] = {.lex_state = 459, .external_lex_state = 3},
  [2510] = {.lex_state = 234},
  [2511] = {.lex_state = 459, .external_lex_state = 10},
  [2512] = {.lex_state = 459, .external_lex_state = 10},
  [2513] = {.lex_state = 254},
  [2514] = {.lex_state = 459, .external_lex_state = 10},
  [2515] = {.lex_state = 459, .external_lex_state = 10},
  [2516] = {.lex_state = 459, .external_lex_state = 10},
  [2517] = {.lex_state = 206},
  [2518] = {.lex_state = 303, .external_lex_state = 16},
  [2519] = {.lex_state = 311, .external_lex_state = 6},
  [2520] = {.lex_state = 303, .external_lex_state = 16},
  [2521] = {.lex_state = 303, .external_lex_state = 16},
  [2522] = {.lex_state = 206},
  [2523] = {.lex_state = 320, .external_lex_state = 2},
  [2524] = {.lex_state = 206},
  [2525] = {.lex_state = 328, .external_lex_state = 2},
  [2526] = {.lex_state = 206},
  [2527] = {.lex_state = 320, .external_lex_state = 2},
  [2528] = {.lex_state = 459, .external_lex_state = 4},
  [2529] = {.lex_state = 465, .external_lex_state = 5},
  [2530] = {.lex_state = 465, .external_lex_state = 5},
  [2531] = {.lex_state = 465, .external_lex_state = 5},
  [2532] = {.lex_state = 399, .external_lex_state = 16},
  [2533] = {.lex_state = 465, .external_lex_state = 5},
  [2534] = {.lex_state = 403},
  [2535] = {.lex_state = 401, .external_lex_state = 16},
  [2536] = {.lex_state = 206},
  [2537] = {.lex_state = 303, .external_lex_state = 16},
  [2538] = {.lex_state = 303, .external_lex_state = 16},
  [2539] = {.lex_state = 303, .external_lex_state = 16},
  [2540] = {.lex_state = 465, .external_lex_state = 5},
  [2541] = {.lex_state = 403},
  [2542] = {.lex_state = 401, .external_lex_state = 16},
  [2543] = {.lex_state = 465, .external_lex_state = 5},
  [2544] = {.lex_state = 403},
  [2545] = {.lex_state = 401, .external_lex_state = 16},
  [2546] = {.lex_state = 465, .external_lex_state = 5},
  [2547] = {.lex_state = 465, .external_lex_state = 5},
  [2548] = {.lex_state = 206},
  [2549] = {.lex_state = 469, .external_lex_state = 8},
  [2550] = {.lex_state = 283, .external_lex_state = 4},
  [2551] = {.lex_state = 469, .external_lex_state = 8},
  [2552] = {.lex_state = 234},
  [2553] = {.lex_state = 465, .external_lex_state = 5},
  [2554] = {.lex_state = 465, .external_lex_state = 5},
  [2555] = {.lex_state = 465, .external_lex_state = 7},
  [2556] = {.lex_state = 471, .external_lex_state = 5},
  [2557] = {.lex_state = 254},
  [2558] = {.lex_state = 261},
  [2559] = {.lex_state = 471, .external_lex_state = 5},
  [2560] = {.lex_state = 264, .external_lex_state = 6},
  [2561] = {.lex_state = 135, .external_lex_state = 2},
  [2562] = {.lex_state = 135, .external_lex_state = 2},
  [2563] = {.lex_state = 135, .external_lex_state = 2},
  [2564] = {.lex_state = 471, .external_lex_state = 5},
  [2565] = {.lex_state = 471, .external_lex_state = 5},
  [2566] = {.lex_state = 471, .external_lex_state = 7},
  [2567] = {.lex_state = 471, .external_lex_state = 7},
  [2568] = {.lex_state = 465, .external_lex_state = 7},
  [2569] = {.lex_state = 450, .external_lex_state = 2},
  [2570] = {.lex_state = 244, .external_lex_state = 4},
  [2571] = {.lex_state = 268, .external_lex_state = 8},
  [2572] = {.lex_state = 465, .external_lex_state = 7},
  [2573] = {.lex_state = 424},
  [2574] = {.lex_state = 283, .external_lex_state = 4},
  [2575] = {.lex_state = 469, .external_lex_state = 8},
  [2576] = {.lex_state = 450, .external_lex_state = 2},
  [2577] = {.lex_state = 424},
  [2578] = {.lex_state = 283, .external_lex_state = 4},
  [2579] = {.lex_state = 469, .external_lex_state = 8},
  [2580] = {.lex_state = 234},
  [2581] = {.lex_state = 244, .external_lex_state = 4},
  [2582] = {.lex_state = 268, .external_lex_state = 8},
  [2583] = {.lex_state = 330, .external_lex_state = 2},
  [2584] = {.lex_state = 330, .external_lex_state = 2},
  [2585] = {.lex_state = 234},
  [2586] = {.lex_state = 244, .external_lex_state = 4},
  [2587] = {.lex_state = 268, .external_lex_state = 8},
  [2588] = {.lex_state = 330, .external_lex_state = 2},
  [2589] = {.lex_state = 330, .external_lex_state = 2},
  [2590] = {.lex_state = 412, .external_lex_state = 27},
  [2591] = {.lex_state = 412, .external_lex_state = 27},
  [2592] = {.lex_state = 412, .external_lex_state = 27},
  [2593] = {.lex_state = 401, .external_lex_state = 16},
  [2594] = {.lex_state = 436, .external_lex_state = 24},
  [2595] = {.lex_state = 436, .external_lex_state = 24},
  [2596] = {.lex_state = 206, .external_lex_state = 16},
  [2597] = {.lex_state = 401, .external_lex_state = 16},
  [2598] = {.lex_state = 412, .external_lex_state = 27},
  [2599] = {.lex_state = 401, .external_lex_state = 16},
  [2600] = {.lex_state = 412, .external_lex_state = 27},
  [2601] = {.lex_state = 401, .external_lex_state = 16},
  [2602] = {.lex_state = 412, .external_lex_state = 27},
  [2603] = {.lex_state = 401, .external_lex_state = 16},
  [2604] = {.lex_state = 412, .external_lex_state = 27},
  [2605] = {.lex_state = 401, .external_lex_state = 16},
  [2606] = {.lex_state = 436, .external_lex_state = 24},
  [2607] = {.lex_state = 436, .external_lex_state = 24},
  [2608] = {.lex_state = 436, .external_lex_state = 24},
  [2609] = {.lex_state = 436, .external_lex_state = 24},
  [2610] = {.lex_state = 401, .external_lex_state = 16},
  [2611] = {.lex_state = 436, .external_lex_state = 24},
  [2612] = {.lex_state = 401, .external_lex_state = 16},
  [2613] = {.lex_state = 436, .external_lex_state = 24},
  [2614] = {.lex_state = 401, .external_lex_state = 16},
  [2615] = {.lex_state = 436, .external_lex_state = 24},
  [2616] = {.lex_state = 436, .external_lex_state = 24},
  [2617] = {.lex_state = 401, .external_lex_state = 24},
  [2618] = {.lex_state = 401, .external_lex_state = 24},
  [2619] = {.lex_state = 401, .external_lex_state = 24},
  [2620] = {.lex_state = 206},
  [2621] = {.lex_state = 206},
  [2622] = {.lex_state = 440, .external_lex_state = 28},
  [2623] = {.lex_state = 436, .external_lex_state = 24},
  [2624] = {.lex_state = 436, .external_lex_state = 24},
  [2625] = {.lex_state = 206, .external_lex_state = 16},
  [2626] = {.lex_state = 401, .external_lex_state = 16},
  [2627] = {.lex_state = 440, .external_lex_state = 28},
  [2628] = {.lex_state = 399, .external_lex_state = 16},
  [2629] = {.lex_state = 440, .external_lex_state = 28},
  [2630] = {.lex_state = 403},
  [2631] = {.lex_state = 401, .external_lex_state = 16},
  [2632] = {.lex_state = 440, .external_lex_state = 28},
  [2633] = {.lex_state = 403},
  [2634] = {.lex_state = 401, .external_lex_state = 16},
  [2635] = {.lex_state = 403},
  [2636] = {.lex_state = 401, .external_lex_state = 16},
  [2637] = {.lex_state = 401, .external_lex_state = 16},
  [2638] = {.lex_state = 440, .external_lex_state = 28},
  [2639] = {.lex_state = 401, .external_lex_state = 16},
  [2640] = {.lex_state = 313, .external_lex_state = 25},
  [2641] = {.lex_state = 313, .external_lex_state = 25},
  [2642] = {.lex_state = 313, .external_lex_state = 25},
  [2643] = {.lex_state = 313, .external_lex_state = 13},
  [2644] = {.lex_state = 313, .external_lex_state = 13},
  [2645] = {.lex_state = 313, .external_lex_state = 13},
  [2646] = {.lex_state = 333, .external_lex_state = 19},
  [2647] = {.lex_state = 333, .external_lex_state = 19},
  [2648] = {.lex_state = 333, .external_lex_state = 19},
  [2649] = {.lex_state = 418, .external_lex_state = 13},
  [2650] = {.lex_state = 418, .external_lex_state = 13},
  [2651] = {.lex_state = 418, .external_lex_state = 13},
  [2652] = {.lex_state = 420, .external_lex_state = 10},
  [2653] = {.lex_state = 420, .external_lex_state = 10},
  [2654] = {.lex_state = 420, .external_lex_state = 10},
  [2655] = {.lex_state = 469, .external_lex_state = 8},
  [2656] = {.lex_state = 320},
  [2657] = {.lex_state = 234},
  [2658] = {.lex_state = 469, .external_lex_state = 21},
  [2659] = {.lex_state = 469, .external_lex_state = 21},
  [2660] = {.lex_state = 254},
  [2661] = {.lex_state = 469, .external_lex_state = 21},
  [2662] = {.lex_state = 469, .external_lex_state = 21},
  [2663] = {.lex_state = 469, .external_lex_state = 21},
  [2664] = {.lex_state = 206},
  [2665] = {.lex_state = 303, .external_lex_state = 16},
  [2666] = {.lex_state = 311, .external_lex_state = 6},
  [2667] = {.lex_state = 303, .external_lex_state = 16},
  [2668] = {.lex_state = 303, .external_lex_state = 16},
  [2669] = {.lex_state = 206},
  [2670] = {.lex_state = 320, .external_lex_state = 2},
  [2671] = {.lex_state = 206},
  [2672] = {.lex_state = 328, .external_lex_state = 2},
  [2673] = {.lex_state = 206},
  [2674] = {.lex_state = 320, .external_lex_state = 2},
  [2675] = {.lex_state = 471, .external_lex_state = 7},
  [2676] = {.lex_state = 206},
  [2677] = {.lex_state = 135},
  [2678] = {.lex_state = 234},
  [2679] = {.lex_state = 135},
  [2680] = {.lex_state = 234},
  [2681] = {.lex_state = 234},
  [2682] = {.lex_state = 471, .external_lex_state = 23},
  [2683] = {.lex_state = 459, .external_lex_state = 3},
  [2684] = {.lex_state = 320},
  [2685] = {.lex_state = 459, .external_lex_state = 14},
  [2686] = {.lex_state = 459, .external_lex_state = 14},
  [2687] = {.lex_state = 459, .external_lex_state = 14},
  [2688] = {.lex_state = 459, .external_lex_state = 14},
  [2689] = {.lex_state = 459, .external_lex_state = 14},
  [2690] = {.lex_state = 399, .external_lex_state = 16},
  [2691] = {.lex_state = 459, .external_lex_state = 14},
  [2692] = {.lex_state = 403},
  [2693] = {.lex_state = 401, .external_lex_state = 16},
  [2694] = {.lex_state = 206},
  [2695] = {.lex_state = 303, .external_lex_state = 16},
  [2696] = {.lex_state = 303, .external_lex_state = 16},
  [2697] = {.lex_state = 303, .external_lex_state = 16},
  [2698] = {.lex_state = 459, .external_lex_state = 14},
  [2699] = {.lex_state = 403},
  [2700] = {.lex_state = 401, .external_lex_state = 16},
  [2701] = {.lex_state = 459, .external_lex_state = 14},
  [2702] = {.lex_state = 403},
  [2703] = {.lex_state = 401, .external_lex_state = 16},
  [2704] = {.lex_state = 459, .external_lex_state = 14},
  [2705] = {.lex_state = 459, .external_lex_state = 14},
  [2706] = {.lex_state = 459, .external_lex_state = 10},
  [2707] = {.lex_state = 459, .external_lex_state = 10},
  [2708] = {.lex_state = 459, .external_lex_state = 10},
  [2709] = {.lex_state = 399, .external_lex_state = 16},
  [2710] = {.lex_state = 459, .external_lex_state = 10},
  [2711] = {.lex_state = 403},
  [2712] = {.lex_state = 401, .external_lex_state = 16},
  [2713] = {.lex_state = 206},
  [2714] = {.lex_state = 303, .external_lex_state = 16},
  [2715] = {.lex_state = 303, .external_lex_state = 16},
  [2716] = {.lex_state = 303, .external_lex_state = 16},
  [2717] = {.lex_state = 459, .external_lex_state = 10},
  [2718] = {.lex_state = 403},
  [2719] = {.lex_state = 401, .external_lex_state = 16},
  [2720] = {.lex_state = 459, .external_lex_state = 10},
  [2721] = {.lex_state = 403},
  [2722] = {.lex_state = 401, .external_lex_state = 16},
  [2723] = {.lex_state = 459, .external_lex_state = 10},
  [2724] = {.lex_state = 459, .external_lex_state = 10},
  [2725] = {.lex_state = 465, .external_lex_state = 5},
  [2726] = {.lex_state = 436, .external_lex_state = 24},
  [2727] = {.lex_state = 436, .external_lex_state = 24},
  [2728] = {.lex_state = 206, .external_lex_state = 16},
  [2729] = {.lex_state = 401, .external_lex_state = 16},
  [2730] = {.lex_state = 465, .external_lex_state = 5},
  [2731] = {.lex_state = 399, .external_lex_state = 16},
  [2732] = {.lex_state = 465, .external_lex_state = 5},
  [2733] = {.lex_state = 403},
  [2734] = {.lex_state = 401, .external_lex_state = 16},
  [2735] = {.lex_state = 465, .external_lex_state = 5},
  [2736] = {.lex_state = 403},
  [2737] = {.lex_state = 401, .external_lex_state = 16},
  [2738] = {.lex_state = 403},
  [2739] = {.lex_state = 401, .external_lex_state = 16},
  [2740] = {.lex_state = 401, .external_lex_state = 16},
  [2741] = {.lex_state = 465, .external_lex_state = 5},
  [2742] = {.lex_state = 401, .external_lex_state = 16},
  [2743] = {.lex_state = 473, .external_lex_state = 23},
  [2744] = {.lex_state = 471, .external_lex_state = 5},
  [2745] = {.lex_state = 471, .external_lex_state = 5},
  [2746] = {.lex_state = 234},
  [2747] = {.lex_state = 471, .external_lex_state = 5},
  [2748] = {.lex_state = 471, .external_lex_state = 5},
  [2749] = {.lex_state = 254},
  [2750] = {.lex_state = 471, .external_lex_state = 5},
  [2751] = {.lex_state = 471, .external_lex_state = 5},
  [2752] = {.lex_state = 471, .external_lex_state = 5},
  [2753] = {.lex_state = 206},
  [2754] = {.lex_state = 303, .external_lex_state = 16},
  [2755] = {.lex_state = 311, .external_lex_state = 6},
  [2756] = {.lex_state = 303, .external_lex_state = 16},
  [2757] = {.lex_state = 303, .external_lex_state = 16},
  [2758] = {.lex_state = 206},
  [2759] = {.lex_state = 320, .external_lex_state = 2},
  [2760] = {.lex_state = 206},
  [2761] = {.lex_state = 328, .external_lex_state = 2},
  [2762] = {.lex_state = 206},
  [2763] = {.lex_state = 320, .external_lex_state = 2},
  [2764] = {.lex_state = 471, .external_lex_state = 7},
  [2765] = {.lex_state = 450, .external_lex_state = 2},
  [2766] = {.lex_state = 450, .external_lex_state = 2},
  [2767] = {.lex_state = 330, .external_lex_state = 2},
  [2768] = {.lex_state = 234},
  [2769] = {.lex_state = 244, .external_lex_state = 4},
  [2770] = {.lex_state = 268, .external_lex_state = 8},
  [2771] = {.lex_state = 330, .external_lex_state = 2},
  [2772] = {.lex_state = 330, .external_lex_state = 2},
  [2773] = {.lex_state = 330, .external_lex_state = 2},
  [2774] = {.lex_state = 234},
  [2775] = {.lex_state = 244, .external_lex_state = 4},
  [2776] = {.lex_state = 268, .external_lex_state = 8},
  [2777] = {.lex_state = 330, .external_lex_state = 2},
  [2778] = {.lex_state = 412, .external_lex_state = 27},
  [2779] = {.lex_state = 412, .external_lex_state = 27},
  [2780] = {.lex_state = 412, .external_lex_state = 27},
  [2781] = {.lex_state = 412, .external_lex_state = 27},
  [2782] = {.lex_state = 401, .external_lex_state = 16},
  [2783] = {.lex_state = 412, .external_lex_state = 27},
  [2784] = {.lex_state = 401, .external_lex_state = 16},
  [2785] = {.lex_state = 412, .external_lex_state = 27},
  [2786] = {.lex_state = 401, .external_lex_state = 16},
  [2787] = {.lex_state = 412, .external_lex_state = 27},
  [2788] = {.lex_state = 412, .external_lex_state = 27},
  [2789] = {.lex_state = 436, .external_lex_state = 24},
  [2790] = {.lex_state = 436, .external_lex_state = 24},
  [2791] = {.lex_state = 436, .external_lex_state = 24},
  [2792] = {.lex_state = 440, .external_lex_state = 28},
  [2793] = {.lex_state = 440, .external_lex_state = 28},
  [2794] = {.lex_state = 440, .external_lex_state = 28},
  [2795] = {.lex_state = 401, .external_lex_state = 16},
  [2796] = {.lex_state = 436, .external_lex_state = 24},
  [2797] = {.lex_state = 436, .external_lex_state = 24},
  [2798] = {.lex_state = 206, .external_lex_state = 16},
  [2799] = {.lex_state = 401, .external_lex_state = 16},
  [2800] = {.lex_state = 440, .external_lex_state = 28},
  [2801] = {.lex_state = 401, .external_lex_state = 16},
  [2802] = {.lex_state = 440, .external_lex_state = 28},
  [2803] = {.lex_state = 401, .external_lex_state = 16},
  [2804] = {.lex_state = 440, .external_lex_state = 28},
  [2805] = {.lex_state = 401, .external_lex_state = 16},
  [2806] = {.lex_state = 440, .external_lex_state = 28},
  [2807] = {.lex_state = 401, .external_lex_state = 16},
  [2808] = {.lex_state = 469, .external_lex_state = 8},
  [2809] = {.lex_state = 469, .external_lex_state = 21},
  [2810] = {.lex_state = 469, .external_lex_state = 21},
  [2811] = {.lex_state = 469, .external_lex_state = 21},
  [2812] = {.lex_state = 399, .external_lex_state = 16},
  [2813] = {.lex_state = 469, .external_lex_state = 21},
  [2814] = {.lex_state = 403},
  [2815] = {.lex_state = 401, .external_lex_state = 16},
  [2816] = {.lex_state = 206},
  [2817] = {.lex_state = 303, .external_lex_state = 16},
  [2818] = {.lex_state = 303, .external_lex_state = 16},
  [2819] = {.lex_state = 303, .external_lex_state = 16},
  [2820] = {.lex_state = 469, .external_lex_state = 21},
  [2821] = {.lex_state = 403},
  [2822] = {.lex_state = 401, .external_lex_state = 16},
  [2823] = {.lex_state = 469, .external_lex_state = 21},
  [2824] = {.lex_state = 403},
  [2825] = {.lex_state = 401, .external_lex_state = 16},
  [2826] = {.lex_state = 469, .external_lex_state = 21},
  [2827] = {.lex_state = 469, .external_lex_state = 21},
  [2828] = {.lex_state = 473, .external_lex_state = 23},
  [2829] = {.lex_state = 234},
  [2830] = {.lex_state = 475, .external_lex_state = 10},
  [2831] = {.lex_state = 254},
  [2832] = {.lex_state = 261},
  [2833] = {.lex_state = 475, .external_lex_state = 10},
  [2834] = {.lex_state = 264, .external_lex_state = 6},
  [2835] = {.lex_state = 135, .external_lex_state = 2},
  [2836] = {.lex_state = 135, .external_lex_state = 2},
  [2837] = {.lex_state = 135, .external_lex_state = 2},
  [2838] = {.lex_state = 234},
  [2839] = {.lex_state = 471, .external_lex_state = 27},
  [2840] = {.lex_state = 471, .external_lex_state = 27},
  [2841] = {.lex_state = 471, .external_lex_state = 27},
  [2842] = {.lex_state = 471, .external_lex_state = 27},
  [2843] = {.lex_state = 471, .external_lex_state = 23},
  [2844] = {.lex_state = 459, .external_lex_state = 3},
  [2845] = {.lex_state = 320},
  [2846] = {.lex_state = 459, .external_lex_state = 14},
  [2847] = {.lex_state = 436, .external_lex_state = 24},
  [2848] = {.lex_state = 436, .external_lex_state = 24},
  [2849] = {.lex_state = 206, .external_lex_state = 16},
  [2850] = {.lex_state = 401, .external_lex_state = 16},
  [2851] = {.lex_state = 459, .external_lex_state = 14},
  [2852] = {.lex_state = 399, .external_lex_state = 16},
  [2853] = {.lex_state = 459, .external_lex_state = 14},
  [2854] = {.lex_state = 403},
  [2855] = {.lex_state = 401, .external_lex_state = 16},
  [2856] = {.lex_state = 459, .external_lex_state = 14},
  [2857] = {.lex_state = 403},
  [2858] = {.lex_state = 401, .external_lex_state = 16},
  [2859] = {.lex_state = 403},
  [2860] = {.lex_state = 401, .external_lex_state = 16},
  [2861] = {.lex_state = 401, .external_lex_state = 16},
  [2862] = {.lex_state = 459, .external_lex_state = 14},
  [2863] = {.lex_state = 401, .external_lex_state = 16},
  [2864] = {.lex_state = 459, .external_lex_state = 10},
  [2865] = {.lex_state = 436, .external_lex_state = 24},
  [2866] = {.lex_state = 436, .external_lex_state = 24},
  [2867] = {.lex_state = 206, .external_lex_state = 16},
  [2868] = {.lex_state = 401, .external_lex_state = 16},
  [2869] = {.lex_state = 459, .external_lex_state = 10},
  [2870] = {.lex_state = 399, .external_lex_state = 16},
  [2871] = {.lex_state = 459, .external_lex_state = 10},
  [2872] = {.lex_state = 403},
  [2873] = {.lex_state = 401, .external_lex_state = 16},
  [2874] = {.lex_state = 459, .external_lex_state = 10},
  [2875] = {.lex_state = 403},
  [2876] = {.lex_state = 401, .external_lex_state = 16},
  [2877] = {.lex_state = 403},
  [2878] = {.lex_state = 401, .external_lex_state = 16},
  [2879] = {.lex_state = 401, .external_lex_state = 16},
  [2880] = {.lex_state = 459, .external_lex_state = 10},
  [2881] = {.lex_state = 401, .external_lex_state = 16},
  [2882] = {.lex_state = 465, .external_lex_state = 5},
  [2883] = {.lex_state = 465, .external_lex_state = 5},
  [2884] = {.lex_state = 465, .external_lex_state = 5},
  [2885] = {.lex_state = 401, .external_lex_state = 16},
  [2886] = {.lex_state = 436, .external_lex_state = 24},
  [2887] = {.lex_state = 436, .external_lex_state = 24},
  [2888] = {.lex_state = 206, .external_lex_state = 16},
  [2889] = {.lex_state = 401, .external_lex_state = 16},
  [2890] = {.lex_state = 465, .external_lex_state = 5},
  [2891] = {.lex_state = 401, .external_lex_state = 16},
  [2892] = {.lex_state = 465, .external_lex_state = 5},
  [2893] = {.lex_state = 401, .external_lex_state = 16},
  [2894] = {.lex_state = 465, .external_lex_state = 5},
  [2895] = {.lex_state = 401, .external_lex_state = 16},
  [2896] = {.lex_state = 465, .external_lex_state = 5},
  [2897] = {.lex_state = 401, .external_lex_state = 16},
  [2898] = {.lex_state = 471, .external_lex_state = 5},
  [2899] = {.lex_state = 471, .external_lex_state = 5},
  [2900] = {.lex_state = 471, .external_lex_state = 5},
  [2901] = {.lex_state = 399, .external_lex_state = 16},
  [2902] = {.lex_state = 471, .external_lex_state = 5},
  [2903] = {.lex_state = 403},
  [2904] = {.lex_state = 401, .external_lex_state = 16},
  [2905] = {.lex_state = 206},
  [2906] = {.lex_state = 303, .external_lex_state = 16},
  [2907] = {.lex_state = 303, .external_lex_state = 16},
  [2908] = {.lex_state = 303, .external_lex_state = 16},
  [2909] = {.lex_state = 471, .external_lex_state = 5},
  [2910] = {.lex_state = 403},
  [2911] = {.lex_state = 401, .external_lex_state = 16},
  [2912] = {.lex_state = 471, .external_lex_state = 5},
  [2913] = {.lex_state = 403},
  [2914] = {.lex_state = 401, .external_lex_state = 16},
  [2915] = {.lex_state = 471, .external_lex_state = 5},
  [2916] = {.lex_state = 471, .external_lex_state = 5},
  [2917] = {.lex_state = 330, .external_lex_state = 2},
  [2918] = {.lex_state = 234},
  [2919] = {.lex_state = 244, .external_lex_state = 4},
  [2920] = {.lex_state = 268, .external_lex_state = 8},
  [2921] = {.lex_state = 330, .external_lex_state = 2},
  [2922] = {.lex_state = 234},
  [2923] = {.lex_state = 244, .external_lex_state = 4},
  [2924] = {.lex_state = 268, .external_lex_state = 8},
  [2925] = {.lex_state = 412, .external_lex_state = 27},
  [2926] = {.lex_state = 412, .external_lex_state = 27},
  [2927] = {.lex_state = 412, .external_lex_state = 27},
  [2928] = {.lex_state = 440, .external_lex_state = 28},
  [2929] = {.lex_state = 440, .external_lex_state = 28},
  [2930] = {.lex_state = 440, .external_lex_state = 28},
  [2931] = {.lex_state = 440, .external_lex_state = 28},
  [2932] = {.lex_state = 401, .external_lex_state = 16},
  [2933] = {.lex_state = 440, .external_lex_state = 28},
  [2934] = {.lex_state = 401, .external_lex_state = 16},
  [2935] = {.lex_state = 440, .external_lex_state = 28},
  [2936] = {.lex_state = 401, .external_lex_state = 16},
  [2937] = {.lex_state = 440, .external_lex_state = 28},
  [2938] = {.lex_state = 440, .external_lex_state = 28},
  [2939] = {.lex_state = 469, .external_lex_state = 21},
  [2940] = {.lex_state = 436, .external_lex_state = 24},
  [2941] = {.lex_state = 436, .external_lex_state = 24},
  [2942] = {.lex_state = 206, .external_lex_state = 16},
  [2943] = {.lex_state = 401, .external_lex_state = 16},
  [2944] = {.lex_state = 469, .external_lex_state = 21},
  [2945] = {.lex_state = 399, .external_lex_state = 16},
  [2946] = {.lex_state = 469, .external_lex_state = 21},
  [2947] = {.lex_state = 403},
  [2948] = {.lex_state = 401, .external_lex_state = 16},
  [2949] = {.lex_state = 469, .external_lex_state = 21},
  [2950] = {.lex_state = 403},
  [2951] = {.lex_state = 401, .external_lex_state = 16},
  [2952] = {.lex_state = 403},
  [2953] = {.lex_state = 401, .external_lex_state = 16},
  [2954] = {.lex_state = 401, .external_lex_state = 16},
  [2955] = {.lex_state = 469, .external_lex_state = 21},
  [2956] = {.lex_state = 401, .external_lex_state = 16},
  [2957] = {.lex_state = 475, .external_lex_state = 10},
  [2958] = {.lex_state = 475, .external_lex_state = 10},
  [2959] = {.lex_state = 234},
  [2960] = {.lex_state = 475, .external_lex_state = 10},
  [2961] = {.lex_state = 475, .external_lex_state = 10},
  [2962] = {.lex_state = 254},
  [2963] = {.lex_state = 475, .external_lex_state = 10},
  [2964] = {.lex_state = 475, .external_lex_state = 10},
  [2965] = {.lex_state = 475, .external_lex_state = 10},
  [2966] = {.lex_state = 206},
  [2967] = {.lex_state = 303, .external_lex_state = 16},
  [2968] = {.lex_state = 311, .external_lex_state = 6},
  [2969] = {.lex_state = 303, .external_lex_state = 16},
  [2970] = {.lex_state = 303, .external_lex_state = 16},
  [2971] = {.lex_state = 206},
  [2972] = {.lex_state = 320, .external_lex_state = 2},
  [2973] = {.lex_state = 206},
  [2974] = {.lex_state = 328, .external_lex_state = 2},
  [2975] = {.lex_state = 206},
  [2976] = {.lex_state = 320, .external_lex_state = 2},
  [2977] = {.lex_state = 471, .external_lex_state = 27},
  [2978] = {.lex_state = 471, .external_lex_state = 27},
  [2979] = {.lex_state = 471, .external_lex_state = 27},
  [2980] = {.lex_state = 459, .external_lex_state = 3},
  [2981] = {.lex_state = 459, .external_lex_state = 14},
  [2982] = {.lex_state = 459, .external_lex_state = 14},
  [2983] = {.lex_state = 459, .external_lex_state = 14},
  [2984] = {.lex_state = 401, .external_lex_state = 16},
  [2985] = {.lex_state = 436, .external_lex_state = 24},
  [2986] = {.lex_state = 436, .external_lex_state = 24},
  [2987] = {.lex_state = 206, .external_lex_state = 16},
  [2988] = {.lex_state = 401, .external_lex_state = 16},
  [2989] = {.lex_state = 459, .external_lex_state = 14},
  [2990] = {.lex_state = 401, .external_lex_state = 16},
  [2991] = {.lex_state = 459, .external_lex_state = 14},
  [2992] = {.lex_state = 401, .external_lex_state = 16},
  [2993] = {.lex_state = 459, .external_lex_state = 14},
  [2994] = {.lex_state = 401, .external_lex_state = 16},
  [2995] = {.lex_state = 459, .external_lex_state = 14},
  [2996] = {.lex_state = 401, .external_lex_state = 16},
  [2997] = {.lex_state = 459, .external_lex_state = 10},
  [2998] = {.lex_state = 459, .external_lex_state = 10},
  [2999] = {.lex_state = 459, .external_lex_state = 10},
  [3000] = {.lex_state = 401, .external_lex_state = 16},
  [3001] = {.lex_state = 436, .external_lex_state = 24},
  [3002] = {.lex_state = 436, .external_lex_state = 24},
  [3003] = {.lex_state = 206, .external_lex_state = 16},
  [3004] = {.lex_state = 401, .external_lex_state = 16},
  [3005] = {.lex_state = 459, .external_lex_state = 10},
  [3006] = {.lex_state = 401, .external_lex_state = 16},
  [3007] = {.lex_state = 459, .external_lex_state = 10},
  [3008] = {.lex_state = 401, .external_lex_state = 16},
  [3009] = {.lex_state = 459, .external_lex_state = 10},
  [3010] = {.lex_state = 401, .external_lex_state = 16},
  [3011] = {.lex_state = 459, .external_lex_state = 10},
  [3012] = {.lex_state = 401, .external_lex_state = 16},
  [3013] = {.lex_state = 465, .external_lex_state = 5},
  [3014] = {.lex_state = 465, .external_lex_state = 5},
  [3015] = {.lex_state = 465, .external_lex_state = 5},
  [3016] = {.lex_state = 465, .external_lex_state = 5},
  [3017] = {.lex_state = 401, .external_lex_state = 16},
  [3018] = {.lex_state = 465, .external_lex_state = 5},
  [3019] = {.lex_state = 401, .external_lex_state = 16},
  [3020] = {.lex_state = 465, .external_lex_state = 5},
  [3021] = {.lex_state = 401, .external_lex_state = 16},
  [3022] = {.lex_state = 465, .external_lex_state = 5},
  [3023] = {.lex_state = 465, .external_lex_state = 5},
  [3024] = {.lex_state = 471, .external_lex_state = 5},
  [3025] = {.lex_state = 436, .external_lex_state = 24},
  [3026] = {.lex_state = 436, .external_lex_state = 24},
  [3027] = {.lex_state = 206, .external_lex_state = 16},
  [3028] = {.lex_state = 401, .external_lex_state = 16},
  [3029] = {.lex_state = 471, .external_lex_state = 5},
  [3030] = {.lex_state = 399, .external_lex_state = 16},
  [3031] = {.lex_state = 471, .external_lex_state = 5},
  [3032] = {.lex_state = 403},
  [3033] = {.lex_state = 401, .external_lex_state = 16},
  [3034] = {.lex_state = 471, .external_lex_state = 5},
  [3035] = {.lex_state = 403},
  [3036] = {.lex_state = 401, .external_lex_state = 16},
  [3037] = {.lex_state = 403},
  [3038] = {.lex_state = 401, .external_lex_state = 16},
  [3039] = {.lex_state = 401, .external_lex_state = 16},
  [3040] = {.lex_state = 471, .external_lex_state = 5},
  [3041] = {.lex_state = 401, .external_lex_state = 16},
  [3042] = {.lex_state = 330, .external_lex_state = 2},
  [3043] = {.lex_state = 330, .external_lex_state = 2},
  [3044] = {.lex_state = 440, .external_lex_state = 28},
  [3045] = {.lex_state = 440, .external_lex_state = 28},
  [3046] = {.lex_state = 440, .external_lex_state = 28},
  [3047] = {.lex_state = 469, .external_lex_state = 21},
  [3048] = {.lex_state = 469, .external_lex_state = 21},
  [3049] = {.lex_state = 469, .external_lex_state = 21},
  [3050] = {.lex_state = 401, .external_lex_state = 16},
  [3051] = {.lex_state = 436, .external_lex_state = 24},
  [3052] = {.lex_state = 436, .external_lex_state = 24},
  [3053] = {.lex_state = 206, .external_lex_state = 16},
  [3054] = {.lex_state = 401, .external_lex_state = 16},
  [3055] = {.lex_state = 469, .external_lex_state = 21},
  [3056] = {.lex_state = 401, .external_lex_state = 16},
  [3057] = {.lex_state = 469, .external_lex_state = 21},
  [3058] = {.lex_state = 401, .external_lex_state = 16},
  [3059] = {.lex_state = 469, .external_lex_state = 21},
  [3060] = {.lex_state = 401, .external_lex_state = 16},
  [3061] = {.lex_state = 469, .external_lex_state = 21},
  [3062] = {.lex_state = 401, .external_lex_state = 16},
  [3063] = {.lex_state = 475, .external_lex_state = 10},
  [3064] = {.lex_state = 475, .external_lex_state = 10},
  [3065] = {.lex_state = 475, .external_lex_state = 10},
  [3066] = {.lex_state = 399, .external_lex_state = 16},
  [3067] = {.lex_state = 475, .external_lex_state = 10},
  [3068] = {.lex_state = 403},
  [3069] = {.lex_state = 401, .external_lex_state = 16},
  [3070] = {.lex_state = 206},
  [3071] = {.lex_state = 303, .external_lex_state = 16},
  [3072] = {.lex_state = 303, .external_lex_state = 16},
  [3073] = {.lex_state = 303, .external_lex_state = 16},
  [3074] = {.lex_state = 475, .external_lex_state = 10},
  [3075] = {.lex_state = 403},
  [3076] = {.lex_state = 401, .external_lex_state = 16},
  [3077] = {.lex_state = 475, .external_lex_state = 10},
  [3078] = {.lex_state = 403},
  [3079] = {.lex_state = 401, .external_lex_state = 16},
  [3080] = {.lex_state = 475, .external_lex_state = 10},
  [3081] = {.lex_state = 475, .external_lex_state = 10},
  [3082] = {.lex_state = 471, .external_lex_state = 27},
  [3083] = {.lex_state = 459, .external_lex_state = 14},
  [3084] = {.lex_state = 459, .external_lex_state = 14},
  [3085] = {.lex_state = 459, .external_lex_state = 14},
  [3086] = {.lex_state = 459, .external_lex_state = 14},
  [3087] = {.lex_state = 401, .external_lex_state = 16},
  [3088] = {.lex_state = 459, .external_lex_state = 14},
  [3089] = {.lex_state = 401, .external_lex_state = 16},
  [3090] = {.lex_state = 459, .external_lex_state = 14},
  [3091] = {.lex_state = 401, .external_lex_state = 16},
  [3092] = {.lex_state = 459, .external_lex_state = 14},
  [3093] = {.lex_state = 459, .external_lex_state = 14},
  [3094] = {.lex_state = 459, .external_lex_state = 10},
  [3095] = {.lex_state = 459, .external_lex_state = 10},
  [3096] = {.lex_state = 459, .external_lex_state = 10},
  [3097] = {.lex_state = 459, .external_lex_state = 10},
  [3098] = {.lex_state = 401, .external_lex_state = 16},
  [3099] = {.lex_state = 459, .external_lex_state = 10},
  [3100] = {.lex_state = 401, .external_lex_state = 16},
  [3101] = {.lex_state = 459, .external_lex_state = 10},
  [3102] = {.lex_state = 401, .external_lex_state = 16},
  [3103] = {.lex_state = 459, .external_lex_state = 10},
  [3104] = {.lex_state = 459, .external_lex_state = 10},
  [3105] = {.lex_state = 465, .external_lex_state = 5},
  [3106] = {.lex_state = 465, .external_lex_state = 5},
  [3107] = {.lex_state = 465, .external_lex_state = 5},
  [3108] = {.lex_state = 471, .external_lex_state = 5},
  [3109] = {.lex_state = 471, .external_lex_state = 5},
  [3110] = {.lex_state = 471, .external_lex_state = 5},
  [3111] = {.lex_state = 401, .external_lex_state = 16},
  [3112] = {.lex_state = 436, .external_lex_state = 24},
  [3113] = {.lex_state = 436, .external_lex_state = 24},
  [3114] = {.lex_state = 206, .external_lex_state = 16},
  [3115] = {.lex_state = 401, .external_lex_state = 16},
  [3116] = {.lex_state = 471, .external_lex_state = 5},
  [3117] = {.lex_state = 401, .external_lex_state = 16},
  [3118] = {.lex_state = 471, .external_lex_state = 5},
  [3119] = {.lex_state = 401, .external_lex_state = 16},
  [3120] = {.lex_state = 471, .external_lex_state = 5},
  [3121] = {.lex_state = 401, .external_lex_state = 16},
  [3122] = {.lex_state = 471, .external_lex_state = 5},
  [3123] = {.lex_state = 401, .external_lex_state = 16},
  [3124] = {.lex_state = 469, .external_lex_state = 21},
  [3125] = {.lex_state = 469, .external_lex_state = 21},
  [3126] = {.lex_state = 469, .external_lex_state = 21},
  [3127] = {.lex_state = 469, .external_lex_state = 21},
  [3128] = {.lex_state = 401, .external_lex_state = 16},
  [3129] = {.lex_state = 469, .external_lex_state = 21},
  [3130] = {.lex_state = 401, .external_lex_state = 16},
  [3131] = {.lex_state = 469, .external_lex_state = 21},
  [3132] = {.lex_state = 401, .external_lex_state = 16},
  [3133] = {.lex_state = 469, .external_lex_state = 21},
  [3134] = {.lex_state = 469, .external_lex_state = 21},
  [3135] = {.lex_state = 475, .external_lex_state = 10},
  [3136] = {.lex_state = 436, .external_lex_state = 24},
  [3137] = {.lex_state = 436, .external_lex_state = 24},
  [3138] = {.lex_state = 206, .external_lex_state = 16},
  [3139] = {.lex_state = 401, .external_lex_state = 16},
  [3140] = {.lex_state = 475, .external_lex_state = 10},
  [3141] = {.lex_state = 399, .external_lex_state = 16},
  [3142] = {.lex_state = 475, .external_lex_state = 10},
  [3143] = {.lex_state = 403},
  [3144] = {.lex_state = 401, .external_lex_state = 16},
  [3145] = {.lex_state = 475, .external_lex_state = 10},
  [3146] = {.lex_state = 403},
  [3147] = {.lex_state = 401, .external_lex_state = 16},
  [3148] = {.lex_state = 403},
  [3149] = {.lex_state = 401, .external_lex_state = 16},
  [3150] = {.lex_state = 401, .external_lex_state = 16},
  [3151] = {.lex_state = 475, .external_lex_state = 10},
  [3152] = {.lex_state = 401, .external_lex_state = 16},
  [3153] = {.lex_state = 459, .external_lex_state = 14},
  [3154] = {.lex_state = 459, .external_lex_state = 14},
  [3155] = {.lex_state = 459, .external_lex_state = 14},
  [3156] = {.lex_state = 459, .external_lex_state = 10},
  [3157] = {.lex_state = 459, .external_lex_state = 10},
  [3158] = {.lex_state = 459, .external_lex_state = 10},
  [3159] = {.lex_state = 471, .external_lex_state = 5},
  [3160] = {.lex_state = 471, .external_lex_state = 5},
  [3161] = {.lex_state = 471, .external_lex_state = 5},
  [3162] = {.lex_state = 471, .external_lex_state = 5},
  [3163] = {.lex_state = 401, .external_lex_state = 16},
  [3164] = {.lex_state = 471, .external_lex_state = 5},
  [3165] = {.lex_state = 401, .external_lex_state = 16},
  [3166] = {.lex_state = 471, .external_lex_state = 5},
  [3167] = {.lex_state = 401, .external_lex_state = 16},
  [3168] = {.lex_state = 471, .external_lex_state = 5},
  [3169] = {.lex_state = 471, .external_lex_state = 5},
  [3170] = {.lex_state = 469, .external_lex_state = 21},
  [3171] = {.lex_state = 469, .external_lex_state = 21},
  [3172] = {.lex_state = 469, .external_lex_state = 21},
  [3173] = {.lex_state = 475, .external_lex_state = 10},
  [3174] = {.lex_state = 475, .external_lex_state = 10},
  [3175] = {.lex_state = 475, .external_lex_state = 10},
  [3176] = {.lex_state = 401, .external_lex_state = 16},
  [3177] = {.lex_state = 436, .external_lex_state = 24},
  [3178] = {.lex_state = 436, .external_lex_state = 24},
  [3179] = {.lex_state = 206, .external_lex_state = 16},
  [3180] = {.lex_state = 401, .external_lex_state = 16},
  [3181] = {.lex_state = 475, .external_lex_state = 10},
  [3182] = {.lex_state = 401, .external_lex_state = 16},
  [3183] = {.lex_state = 475, .external_lex_state = 10},
  [3184] = {.lex_state = 401, .external_lex_state = 16},
  [3185] = {.lex_state = 475, .external_lex_state = 10},
  [3186] = {.lex_state = 401, .external_lex_state = 16},
  [3187] = {.lex_state = 475, .external_lex_state = 10},
  [3188] = {.lex_state = 401, .external_lex_state = 16},
  [3189] = {.lex_state = 471, .external_lex_state = 5},
  [3190] = {.lex_state = 471, .external_lex_state = 5},
  [3191] = {.lex_state = 471, .external_lex_state = 5},
  [3192] = {.lex_state = 475, .external_lex_state = 10},
  [3193] = {.lex_state = 475, .external_lex_state = 10},
  [3194] = {.lex_state = 475, .external_lex_state = 10},
  [3195] = {.lex_state = 475, .external_lex_state = 10},
  [3196] = {.lex_state = 401, .external_lex_state = 16},
  [3197] = {.lex_state = 475, .external_lex_state = 10},
  [3198] = {.lex_state = 401, .external_lex_state = 16},
  [3199] = {.lex_state = 475, .external_lex_state = 10},
  [3200] = {.lex_state = 401, .external_lex_state = 16},
  [3201] = {.lex_state = 475, .external_lex_state = 10},
  [3202] = {.lex_state = 475, .external_lex_state = 10},
  [3203] = {.lex_state = 475, .external_lex_state = 10},
  [3204] = {.lex_state = 475, .external_lex_state = 10},
  [3205] = {.lex_state = 475, .external_lex_state = 10},
};

enum {
  ts_external_token_heredoc_start,
  ts_external_token__simple_heredoc_body,
  ts_external_token__heredoc_body_beginning,
  ts_external_token__heredoc_body_middle,
  ts_external_token__heredoc_body_end,
  ts_external_token_file_descriptor,
  ts_external_token__empty_value,
  ts_external_token__concat,
  ts_external_token_variable_name,
  ts_external_token_RBRACE,
  ts_external_token_RBRACK,
  ts_external_token_LF,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_heredoc_start] = sym_heredoc_start,
  [ts_external_token__simple_heredoc_body] = sym__simple_heredoc_body,
  [ts_external_token__heredoc_body_beginning] = sym__heredoc_body_beginning,
  [ts_external_token__heredoc_body_middle] = sym__heredoc_body_middle,
  [ts_external_token__heredoc_body_end] = sym__heredoc_body_end,
  [ts_external_token_file_descriptor] = sym_file_descriptor,
  [ts_external_token__empty_value] = sym__empty_value,
  [ts_external_token__concat] = sym__concat,
  [ts_external_token_variable_name] = sym_variable_name,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_LF] = anon_sym_LF,
};

static bool ts_external_scanner_states[29][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_heredoc_start] = true,
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__empty_value] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_RBRACK] = true,
  },
  [2] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
  },
  [3] = {
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [4] = {
    [ts_external_token_LF] = true,
  },
  [5] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [6] = {
    [ts_external_token_variable_name] = true,
  },
  [7] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LF] = true,
  },
  [8] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [9] = {
    [ts_external_token__empty_value] = true,
  },
  [10] = {
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [11] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACK] = true,
  },
  [12] = {
    [ts_external_token_RBRACK] = true,
  },
  [13] = {
    [ts_external_token__concat] = true,
  },
  [14] = {
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [15] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [16] = {
    [ts_external_token_RBRACE] = true,
  },
  [17] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
  },
  [18] = {
    [ts_external_token__simple_heredoc_body] = true,
    [ts_external_token__heredoc_body_beginning] = true,
    [ts_external_token_file_descriptor] = true,
  },
  [19] = {
    [ts_external_token__heredoc_body_middle] = true,
    [ts_external_token__heredoc_body_end] = true,
  },
  [20] = {
    [ts_external_token_heredoc_start] = true,
  },
  [21] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_LF] = true,
  },
  [22] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_variable_name] = true,
    [ts_external_token_RBRACE] = true,
  },
  [23] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token_LF] = true,
  },
  [24] = {
    [ts_external_token__concat] = true,
    [ts_external_token_RBRACE] = true,
  },
  [25] = {
    [ts_external_token__concat] = true,
    [ts_external_token_variable_name] = true,
  },
  [26] = {
    [ts_external_token_file_descriptor] = true,
  },
  [27] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
    [ts_external_token_LF] = true,
  },
  [28] = {
    [ts_external_token_file_descriptor] = true,
    [ts_external_token__concat] = true,
  },
};

static uint16_t ts_parse_table[STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_heredoc_start] = ACTIONS(1),
    [sym__simple_heredoc_body] = ACTIONS(1),
    [sym__heredoc_body_beginning] = ACTIONS(1),
    [sym__heredoc_body_middle] = ACTIONS(1),
    [sym__heredoc_body_end] = ACTIONS(1),
    [sym_file_descriptor] = ACTIONS(1),
    [sym__empty_value] = ACTIONS(1),
    [sym__concat] = ACTIONS(1),
    [sym_variable_name] = ACTIONS(1),
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(3),
    [anon_sym_in] = ACTIONS(3),
    [anon_sym_while] = ACTIONS(3),
    [anon_sym_do] = ACTIONS(3),
    [anon_sym_done] = ACTIONS(3),
    [anon_sym_if] = ACTIONS(3),
    [anon_sym_then] = ACTIONS(3),
    [anon_sym_fi] = ACTIONS(3),
    [anon_sym_elif] = ACTIONS(3),
    [anon_sym_else] = ACTIONS(3),
    [anon_sym_case] = ACTIONS(3),
    [anon_sym_esac] = ACTIONS(3),
    [anon_sym_PIPE] = ACTIONS(3),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_SEMI_SEMI] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_PIPE_AMP] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(3),
    [anon_sym_RBRACK] = ACTIONS(3),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1),
    [anon_sym_declare] = ACTIONS(3),
    [anon_sym_typeset] = ACTIONS(3),
    [anon_sym_export] = ACTIONS(3),
    [anon_sym_readonly] = ACTIONS(3),
    [anon_sym_local] = ACTIONS(3),
    [anon_sym_unset] = ACTIONS(3),
    [anon_sym_unsetenv] = ACTIONS(3),
    [anon_sym_EQ_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(3),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(3),
    [anon_sym_GT] = ACTIONS(3),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_GT] = ACTIONS(3),
    [anon_sym_AMP_GT_GT] = ACTIONS(1),
    [anon_sym_LT_AMP] = ACTIONS(1),
    [anon_sym_GT_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(3),
    [anon_sym_LT_LT_DASH] = ACTIONS(1),
    [anon_sym_LT_LT_LT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [sym__special_characters] = ACTIONS(3),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(3),
    [sym_raw_string] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [aux_sym_SLASH] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(3),
    [anon_sym_COLON_QMARK] = ACTIONS(1),
    [anon_sym_COLON_DASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LT_LPAREN] = ACTIONS(1),
    [anon_sym_GT_LPAREN] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(3),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_0] = ACTIONS(3),
    [anon_sym__] = ACTIONS(3),
    [anon_sym_SEMI] = ACTIONS(3),
    [anon_sym_AMP] = ACTIONS(3),
  },
  [1] = {
    [sym_program] = STATE(25),
    [sym__terminated_statement] = STATE(32),
    [sym_for_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym_subshell] = STATE(26),
    [sym_pipeline] = STATE(26),
    [sym_list] = STATE(26),
    [sym_negated_command] = STATE(26),
    [sym_test_command] = STATE(26),
    [sym_declaration_command] = STATE(26),
    [sym_unset_command] = STATE(26),
    [sym_command] = STATE(26),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(28),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(32),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [2] = {
    [anon_sym_LT] = ACTIONS(57),
    [anon_sym_GT] = ACTIONS(57),
    [anon_sym_GT_GT] = ACTIONS(59),
    [anon_sym_AMP_GT] = ACTIONS(57),
    [anon_sym_AMP_GT_GT] = ACTIONS(59),
    [anon_sym_LT_AMP] = ACTIONS(59),
    [anon_sym_GT_AMP] = ACTIONS(59),
    [sym_comment] = ACTIONS(53),
  },
  [3] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(63),
    [anon_sym_PLUS_EQ] = ACTIONS(63),
    [sym_comment] = ACTIONS(53),
  },
  [4] = {
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(65),
  },
  [5] = {
    [sym__terminated_statement] = STATE(38),
    [sym_for_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_subshell] = STATE(39),
    [sym_pipeline] = STATE(39),
    [sym_list] = STATE(39),
    [sym_negated_command] = STATE(39),
    [sym_test_command] = STATE(39),
    [sym_declaration_command] = STATE(39),
    [sym_unset_command] = STATE(39),
    [sym_command] = STATE(39),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(40),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [6] = {
    [sym__terminated_statement] = STATE(41),
    [sym_for_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_subshell] = STATE(39),
    [sym_pipeline] = STATE(39),
    [sym_list] = STATE(39),
    [sym_negated_command] = STATE(39),
    [sym_test_command] = STATE(39),
    [sym_declaration_command] = STATE(39),
    [sym_unset_command] = STATE(39),
    [sym_command] = STATE(39),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(40),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [7] = {
    [sym_concatenation] = STATE(50),
    [sym_string] = STATE(45),
    [sym_simple_expansion] = STATE(45),
    [sym_string_expansion] = STATE(45),
    [sym_expansion] = STATE(45),
    [sym_command_substitution] = STATE(45),
    [sym_process_substitution] = STATE(45),
    [sym__special_characters] = ACTIONS(67),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_DOLLAR] = ACTIONS(71),
    [sym_raw_string] = ACTIONS(73),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(75),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(77),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [anon_sym_LT_LPAREN] = ACTIONS(81),
    [anon_sym_GT_LPAREN] = ACTIONS(81),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(73),
  },
  [8] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(83),
  },
  [9] = {
    [sym__terminated_statement] = STATE(67),
    [sym_for_statement] = STATE(63),
    [sym_while_statement] = STATE(63),
    [sym_if_statement] = STATE(63),
    [sym_case_statement] = STATE(63),
    [sym_function_definition] = STATE(63),
    [sym_subshell] = STATE(63),
    [sym_pipeline] = STATE(63),
    [sym_list] = STATE(63),
    [sym_negated_command] = STATE(63),
    [sym_test_command] = STATE(63),
    [sym_declaration_command] = STATE(63),
    [sym_unset_command] = STATE(63),
    [sym_command] = STATE(63),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(65),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_program_repeat1] = STATE(67),
    [aux_sym_command_repeat1] = STATE(68),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_typeset] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_readonly] = ACTIONS(97),
    [anon_sym_local] = ACTIONS(97),
    [anon_sym_unset] = ACTIONS(99),
    [anon_sym_unsetenv] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(105),
  },
  [10] = {
    [sym_test_command] = STATE(70),
    [sym_command] = STATE(70),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(43),
  },
  [11] = {
    [sym__expression] = STATE(82),
    [sym_binary_expression] = STATE(82),
    [sym_unary_expression] = STATE(82),
    [sym_parenthesized_expression] = STATE(82),
    [sym_concatenation] = STATE(82),
    [sym_string] = STATE(77),
    [sym_simple_expansion] = STATE(77),
    [sym_string_expansion] = STATE(77),
    [sym_expansion] = STATE(77),
    [sym_command_substitution] = STATE(77),
    [sym_process_substitution] = STATE(77),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(111),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
    [sym_test_operator] = ACTIONS(131),
  },
  [12] = {
    [sym__expression] = STATE(93),
    [sym_binary_expression] = STATE(93),
    [sym_unary_expression] = STATE(93),
    [sym_parenthesized_expression] = STATE(93),
    [sym_concatenation] = STATE(93),
    [sym_string] = STATE(88),
    [sym_simple_expansion] = STATE(88),
    [sym_string_expansion] = STATE(88),
    [sym_expansion] = STATE(88),
    [sym_command_substitution] = STATE(88),
    [sym_process_substitution] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [13] = {
    [sym_variable_assignment] = STATE(105),
    [sym_subscript] = STATE(104),
    [sym_concatenation] = STATE(105),
    [sym_string] = STATE(98),
    [sym_simple_expansion] = STATE(98),
    [sym_string_expansion] = STATE(98),
    [sym_expansion] = STATE(98),
    [sym_command_substitution] = STATE(98),
    [sym_process_substitution] = STATE(98),
    [aux_sym_declaration_command_repeat1] = STATE(105),
    [sym_variable_name] = ACTIONS(157),
    [anon_sym_PIPE] = ACTIONS(159),
    [anon_sym_SEMI_SEMI] = ACTIONS(159),
    [anon_sym_PIPE_AMP] = ACTIONS(159),
    [anon_sym_AMP_AMP] = ACTIONS(159),
    [anon_sym_PIPE_PIPE] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(179),
    [sym_word] = ACTIONS(167),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_LF] = ACTIONS(181),
    [anon_sym_AMP] = ACTIONS(159),
  },
  [14] = {
    [sym_concatenation] = STATE(115),
    [sym_string] = STATE(109),
    [sym_simple_expansion] = STATE(109),
    [sym_string_expansion] = STATE(109),
    [sym_expansion] = STATE(109),
    [sym_command_substitution] = STATE(109),
    [sym_process_substitution] = STATE(109),
    [aux_sym_unset_command_repeat1] = STATE(115),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(183),
    [anon_sym_PIPE_AMP] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [sym__special_characters] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(193),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(195),
    [anon_sym_BQUOTE] = ACTIONS(197),
    [anon_sym_LT_LPAREN] = ACTIONS(199),
    [anon_sym_GT_LPAREN] = ACTIONS(199),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(201),
    [sym_word] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(183),
    [anon_sym_LF] = ACTIONS(203),
    [anon_sym_AMP] = ACTIONS(183),
  },
  [15] = {
    [sym_concatenation] = STATE(124),
    [sym_string] = STATE(119),
    [sym_simple_expansion] = STATE(119),
    [sym_string_expansion] = STATE(119),
    [sym_expansion] = STATE(119),
    [sym_command_substitution] = STATE(119),
    [sym_process_substitution] = STATE(119),
    [sym__special_characters] = ACTIONS(205),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(211),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(211),
  },
  [16] = {
    [aux_sym_concatenation_repeat1] = STATE(126),
    [sym__simple_heredoc_body] = ACTIONS(221),
    [sym__heredoc_body_beginning] = ACTIONS(221),
    [sym_file_descriptor] = ACTIONS(221),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_SEMI_SEMI] = ACTIONS(225),
    [anon_sym_PIPE_AMP] = ACTIONS(225),
    [anon_sym_AMP_AMP] = ACTIONS(225),
    [anon_sym_PIPE_PIPE] = ACTIONS(225),
    [anon_sym_EQ_TILDE] = ACTIONS(225),
    [anon_sym_EQ_EQ] = ACTIONS(225),
    [anon_sym_LT] = ACTIONS(225),
    [anon_sym_GT] = ACTIONS(225),
    [anon_sym_GT_GT] = ACTIONS(225),
    [anon_sym_AMP_GT] = ACTIONS(225),
    [anon_sym_AMP_GT_GT] = ACTIONS(225),
    [anon_sym_LT_AMP] = ACTIONS(225),
    [anon_sym_GT_AMP] = ACTIONS(225),
    [anon_sym_LT_LT] = ACTIONS(225),
    [anon_sym_LT_LT_DASH] = ACTIONS(225),
    [anon_sym_LT_LT_LT] = ACTIONS(225),
    [sym__special_characters] = ACTIONS(225),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR] = ACTIONS(225),
    [sym_raw_string] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(225),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(225),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(225),
    [anon_sym_SEMI] = ACTIONS(225),
    [anon_sym_LF] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(225),
  },
  [17] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(133),
    [anon_sym_DQUOTE] = ACTIONS(227),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [18] = {
    [sym_string] = STATE(135),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(239),
    [sym_raw_string] = ACTIONS(241),
    [anon_sym_POUND] = ACTIONS(239),
    [anon_sym_DASH] = ACTIONS(239),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(243),
    [anon_sym_STAR] = ACTIONS(239),
    [anon_sym_AT] = ACTIONS(239),
    [anon_sym_QMARK] = ACTIONS(239),
    [anon_sym_0] = ACTIONS(245),
    [anon_sym__] = ACTIONS(245),
  },
  [19] = {
    [aux_sym_concatenation_repeat1] = STATE(126),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_SEMI_SEMI] = ACTIONS(249),
    [anon_sym_PIPE_AMP] = ACTIONS(249),
    [anon_sym_AMP_AMP] = ACTIONS(249),
    [anon_sym_PIPE_PIPE] = ACTIONS(249),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(249),
    [anon_sym_LT_AMP] = ACTIONS(249),
    [anon_sym_GT_AMP] = ACTIONS(249),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(249),
    [anon_sym_LT_LT_LT] = ACTIONS(249),
    [sym__special_characters] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(249),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(249),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(249),
    [anon_sym_BQUOTE] = ACTIONS(249),
    [anon_sym_LT_LPAREN] = ACTIONS(249),
    [anon_sym_GT_LPAREN] = ACTIONS(249),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(249),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(249),
  },
  [20] = {
    [sym_subscript] = STATE(141),
    [sym_variable_name] = ACTIONS(251),
    [anon_sym_DOLLAR] = ACTIONS(253),
    [anon_sym_POUND] = ACTIONS(255),
    [anon_sym_DASH] = ACTIONS(253),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(257),
    [anon_sym_STAR] = ACTIONS(253),
    [anon_sym_AT] = ACTIONS(253),
    [anon_sym_QMARK] = ACTIONS(253),
    [anon_sym_0] = ACTIONS(259),
    [anon_sym__] = ACTIONS(259),
  },
  [21] = {
    [sym_for_statement] = STATE(163),
    [sym_while_statement] = STATE(163),
    [sym_if_statement] = STATE(163),
    [sym_case_statement] = STATE(163),
    [sym_function_definition] = STATE(163),
    [sym_subshell] = STATE(163),
    [sym_pipeline] = STATE(163),
    [sym_list] = STATE(163),
    [sym_negated_command] = STATE(163),
    [sym_test_command] = STATE(163),
    [sym_declaration_command] = STATE(163),
    [sym_unset_command] = STATE(163),
    [sym_command] = STATE(163),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(165),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [22] = {
    [sym_for_statement] = STATE(180),
    [sym_while_statement] = STATE(180),
    [sym_if_statement] = STATE(180),
    [sym_case_statement] = STATE(180),
    [sym_function_definition] = STATE(180),
    [sym_subshell] = STATE(180),
    [sym_pipeline] = STATE(180),
    [sym_list] = STATE(180),
    [sym_negated_command] = STATE(180),
    [sym_test_command] = STATE(180),
    [sym_declaration_command] = STATE(180),
    [sym_unset_command] = STATE(180),
    [sym_command] = STATE(180),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(182),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [23] = {
    [sym_for_statement] = STATE(185),
    [sym_while_statement] = STATE(185),
    [sym_if_statement] = STATE(185),
    [sym_case_statement] = STATE(185),
    [sym_function_definition] = STATE(185),
    [sym_subshell] = STATE(185),
    [sym_pipeline] = STATE(185),
    [sym_list] = STATE(185),
    [sym_negated_command] = STATE(185),
    [sym_test_command] = STATE(185),
    [sym_declaration_command] = STATE(185),
    [sym_unset_command] = STATE(185),
    [sym_command] = STATE(185),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(186),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [24] = {
    [aux_sym_concatenation_repeat1] = STATE(126),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_SEMI_SEMI] = ACTIONS(249),
    [anon_sym_LPAREN] = ACTIONS(325),
    [anon_sym_PIPE_AMP] = ACTIONS(249),
    [anon_sym_AMP_AMP] = ACTIONS(249),
    [anon_sym_PIPE_PIPE] = ACTIONS(249),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(249),
    [anon_sym_LT_AMP] = ACTIONS(249),
    [anon_sym_GT_AMP] = ACTIONS(249),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(249),
    [anon_sym_LT_LT_LT] = ACTIONS(249),
    [sym__special_characters] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(249),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(249),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(249),
    [anon_sym_BQUOTE] = ACTIONS(249),
    [anon_sym_LT_LPAREN] = ACTIONS(249),
    [anon_sym_GT_LPAREN] = ACTIONS(249),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(249),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(249),
  },
  [25] = {
    [ts_builtin_sym_end] = ACTIONS(327),
    [sym_comment] = ACTIONS(53),
  },
  [26] = {
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(331),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(331),
  },
  [27] = {
    [sym_file_redirect] = STATE(201),
    [sym_heredoc_redirect] = STATE(201),
    [sym_heredoc_body] = STATE(200),
    [sym_herestring_redirect] = STATE(201),
    [sym_concatenation] = STATE(202),
    [sym_string] = STATE(199),
    [sym_simple_expansion] = STATE(199),
    [sym_string_expansion] = STATE(199),
    [sym_expansion] = STATE(199),
    [sym_command_substitution] = STATE(199),
    [sym_process_substitution] = STATE(199),
    [aux_sym_while_statement_repeat1] = STATE(201),
    [aux_sym_command_repeat2] = STATE(202),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(343),
    [anon_sym_SEMI_SEMI] = ACTIONS(343),
    [anon_sym_PIPE_AMP] = ACTIONS(343),
    [anon_sym_AMP_AMP] = ACTIONS(343),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_EQ_TILDE] = ACTIONS(345),
    [anon_sym_EQ_EQ] = ACTIONS(345),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym__special_characters] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(357),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_LF] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(343),
  },
  [28] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(331),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(331),
    [anon_sym_LF] = ACTIONS(335),
    [anon_sym_AMP] = ACTIONS(331),
  },
  [29] = {
    [anon_sym_EQ] = ACTIONS(63),
    [anon_sym_PLUS_EQ] = ACTIONS(63),
    [sym_comment] = ACTIONS(53),
  },
  [30] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [31] = {
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(249),
    [anon_sym_SEMI_SEMI] = ACTIONS(249),
    [anon_sym_PIPE_AMP] = ACTIONS(249),
    [anon_sym_AMP_AMP] = ACTIONS(249),
    [anon_sym_PIPE_PIPE] = ACTIONS(249),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(249),
    [anon_sym_LT_AMP] = ACTIONS(249),
    [anon_sym_GT_AMP] = ACTIONS(249),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(249),
    [anon_sym_LT_LT_LT] = ACTIONS(249),
    [sym__special_characters] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(249),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(249),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(249),
    [anon_sym_BQUOTE] = ACTIONS(249),
    [anon_sym_LT_LPAREN] = ACTIONS(249),
    [anon_sym_GT_LPAREN] = ACTIONS(249),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(249),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(249),
  },
  [32] = {
    [sym__terminated_statement] = STATE(203),
    [sym_for_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym_subshell] = STATE(26),
    [sym_pipeline] = STATE(26),
    [sym_list] = STATE(26),
    [sym_negated_command] = STATE(26),
    [sym_test_command] = STATE(26),
    [sym_declaration_command] = STATE(26),
    [sym_unset_command] = STATE(26),
    [sym_command] = STATE(26),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(28),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(203),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [ts_builtin_sym_end] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [33] = {
    [sym_command_name] = STATE(204),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(205),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(375),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(43),
  },
  [34] = {
    [sym_concatenation] = STATE(208),
    [sym_string] = STATE(207),
    [sym_simple_expansion] = STATE(207),
    [sym_string_expansion] = STATE(207),
    [sym_expansion] = STATE(207),
    [sym_command_substitution] = STATE(207),
    [sym_process_substitution] = STATE(207),
    [sym__special_characters] = ACTIONS(377),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(379),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(379),
  },
  [35] = {
    [sym_concatenation] = STATE(211),
    [sym_string] = STATE(210),
    [sym_simple_expansion] = STATE(210),
    [sym_string_expansion] = STATE(210),
    [sym_expansion] = STATE(210),
    [sym_command_substitution] = STATE(210),
    [sym_process_substitution] = STATE(210),
    [sym__special_characters] = ACTIONS(381),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(383),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(383),
  },
  [36] = {
    [sym_concatenation] = STATE(212),
    [sym_string] = STATE(217),
    [sym_array] = STATE(212),
    [sym_simple_expansion] = STATE(217),
    [sym_string_expansion] = STATE(217),
    [sym_expansion] = STATE(217),
    [sym_command_substitution] = STATE(217),
    [sym_process_substitution] = STATE(217),
    [sym__empty_value] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(389),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(395),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(395),
  },
  [37] = {
    [anon_sym_in] = ACTIONS(405),
    [anon_sym_SEMI_SEMI] = ACTIONS(407),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(407),
    [anon_sym_LF] = ACTIONS(409),
    [anon_sym_AMP] = ACTIONS(407),
  },
  [38] = {
    [sym_do_group] = STATE(225),
    [anon_sym_do] = ACTIONS(411),
    [sym_comment] = ACTIONS(53),
  },
  [39] = {
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(413),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(413),
    [anon_sym_LF] = ACTIONS(415),
    [anon_sym_AMP] = ACTIONS(413),
  },
  [40] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(413),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(413),
    [anon_sym_LF] = ACTIONS(415),
    [anon_sym_AMP] = ACTIONS(413),
  },
  [41] = {
    [anon_sym_then] = ACTIONS(417),
    [sym_comment] = ACTIONS(53),
  },
  [42] = {
    [aux_sym_concatenation_repeat1] = STATE(231),
    [sym__concat] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(421),
    [anon_sym_SEMI_SEMI] = ACTIONS(423),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(423),
    [anon_sym_LF] = ACTIONS(425),
    [anon_sym_AMP] = ACTIONS(423),
  },
  [43] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(233),
    [anon_sym_DQUOTE] = ACTIONS(427),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [44] = {
    [sym_string] = STATE(235),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_DOLLAR] = ACTIONS(429),
    [sym_raw_string] = ACTIONS(431),
    [anon_sym_POUND] = ACTIONS(429),
    [anon_sym_DASH] = ACTIONS(429),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(433),
    [anon_sym_STAR] = ACTIONS(429),
    [anon_sym_AT] = ACTIONS(429),
    [anon_sym_QMARK] = ACTIONS(429),
    [anon_sym_0] = ACTIONS(435),
    [anon_sym__] = ACTIONS(435),
  },
  [45] = {
    [aux_sym_concatenation_repeat1] = STATE(231),
    [sym__concat] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(437),
    [anon_sym_SEMI_SEMI] = ACTIONS(439),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(439),
  },
  [46] = {
    [sym_subscript] = STATE(243),
    [sym_variable_name] = ACTIONS(443),
    [anon_sym_DOLLAR] = ACTIONS(445),
    [anon_sym_POUND] = ACTIONS(447),
    [anon_sym_DASH] = ACTIONS(445),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(449),
    [anon_sym_STAR] = ACTIONS(445),
    [anon_sym_AT] = ACTIONS(445),
    [anon_sym_QMARK] = ACTIONS(445),
    [anon_sym_0] = ACTIONS(451),
    [anon_sym__] = ACTIONS(451),
  },
  [47] = {
    [sym_for_statement] = STATE(244),
    [sym_while_statement] = STATE(244),
    [sym_if_statement] = STATE(244),
    [sym_case_statement] = STATE(244),
    [sym_function_definition] = STATE(244),
    [sym_subshell] = STATE(244),
    [sym_pipeline] = STATE(244),
    [sym_list] = STATE(244),
    [sym_negated_command] = STATE(244),
    [sym_test_command] = STATE(244),
    [sym_declaration_command] = STATE(244),
    [sym_unset_command] = STATE(244),
    [sym_command] = STATE(244),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(245),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [48] = {
    [sym_for_statement] = STATE(246),
    [sym_while_statement] = STATE(246),
    [sym_if_statement] = STATE(246),
    [sym_case_statement] = STATE(246),
    [sym_function_definition] = STATE(246),
    [sym_subshell] = STATE(246),
    [sym_pipeline] = STATE(246),
    [sym_list] = STATE(246),
    [sym_negated_command] = STATE(246),
    [sym_test_command] = STATE(246),
    [sym_declaration_command] = STATE(246),
    [sym_unset_command] = STATE(246),
    [sym_command] = STATE(246),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(247),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [49] = {
    [sym_for_statement] = STATE(248),
    [sym_while_statement] = STATE(248),
    [sym_if_statement] = STATE(248),
    [sym_case_statement] = STATE(248),
    [sym_function_definition] = STATE(248),
    [sym_subshell] = STATE(248),
    [sym_pipeline] = STATE(248),
    [sym_list] = STATE(248),
    [sym_negated_command] = STATE(248),
    [sym_test_command] = STATE(248),
    [sym_declaration_command] = STATE(248),
    [sym_unset_command] = STATE(248),
    [sym_command] = STATE(248),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(249),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [50] = {
    [anon_sym_in] = ACTIONS(437),
    [anon_sym_SEMI_SEMI] = ACTIONS(439),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(439),
    [anon_sym_LF] = ACTIONS(441),
    [anon_sym_AMP] = ACTIONS(439),
  },
  [51] = {
    [sym_compound_statement] = STATE(252),
    [anon_sym_LPAREN] = ACTIONS(453),
    [anon_sym_LBRACE] = ACTIONS(455),
    [sym_comment] = ACTIONS(53),
  },
  [52] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(457),
    [anon_sym_PLUS_EQ] = ACTIONS(457),
    [sym_comment] = ACTIONS(53),
  },
  [53] = {
    [sym__terminated_statement] = STATE(254),
    [sym_for_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_subshell] = STATE(39),
    [sym_pipeline] = STATE(39),
    [sym_list] = STATE(39),
    [sym_negated_command] = STATE(39),
    [sym_test_command] = STATE(39),
    [sym_declaration_command] = STATE(39),
    [sym_unset_command] = STATE(39),
    [sym_command] = STATE(39),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(40),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [54] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(459),
  },
  [55] = {
    [sym_test_command] = STATE(70),
    [sym_command] = STATE(70),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_command_repeat1] = STATE(68),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(95),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(103),
  },
  [56] = {
    [sym__expression] = STATE(256),
    [sym_binary_expression] = STATE(256),
    [sym_unary_expression] = STATE(256),
    [sym_parenthesized_expression] = STATE(256),
    [sym_concatenation] = STATE(256),
    [sym_string] = STATE(77),
    [sym_simple_expansion] = STATE(77),
    [sym_string_expansion] = STATE(77),
    [sym_expansion] = STATE(77),
    [sym_command_substitution] = STATE(77),
    [sym_process_substitution] = STATE(77),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(111),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
    [sym_test_operator] = ACTIONS(131),
  },
  [57] = {
    [sym__expression] = STATE(257),
    [sym_binary_expression] = STATE(257),
    [sym_unary_expression] = STATE(257),
    [sym_parenthesized_expression] = STATE(257),
    [sym_concatenation] = STATE(257),
    [sym_string] = STATE(88),
    [sym_simple_expansion] = STATE(88),
    [sym_string_expansion] = STATE(88),
    [sym_expansion] = STATE(88),
    [sym_command_substitution] = STATE(88),
    [sym_process_substitution] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [58] = {
    [sym_variable_assignment] = STATE(262),
    [sym_subscript] = STATE(261),
    [sym_concatenation] = STATE(262),
    [sym_string] = STATE(260),
    [sym_simple_expansion] = STATE(260),
    [sym_string_expansion] = STATE(260),
    [sym_expansion] = STATE(260),
    [sym_command_substitution] = STATE(260),
    [sym_process_substitution] = STATE(260),
    [aux_sym_declaration_command_repeat1] = STATE(262),
    [sym_variable_name] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(159),
    [anon_sym_RPAREN] = ACTIONS(159),
    [anon_sym_SEMI_SEMI] = ACTIONS(159),
    [anon_sym_PIPE_AMP] = ACTIONS(159),
    [anon_sym_AMP_AMP] = ACTIONS(159),
    [anon_sym_PIPE_PIPE] = ACTIONS(159),
    [sym__special_characters] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(465),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(179),
    [sym_word] = ACTIONS(465),
    [anon_sym_SEMI] = ACTIONS(159),
    [anon_sym_LF] = ACTIONS(181),
    [anon_sym_AMP] = ACTIONS(159),
  },
  [59] = {
    [sym_concatenation] = STATE(265),
    [sym_string] = STATE(264),
    [sym_simple_expansion] = STATE(264),
    [sym_string_expansion] = STATE(264),
    [sym_expansion] = STATE(264),
    [sym_command_substitution] = STATE(264),
    [sym_process_substitution] = STATE(264),
    [aux_sym_unset_command_repeat1] = STATE(265),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_RPAREN] = ACTIONS(183),
    [anon_sym_SEMI_SEMI] = ACTIONS(183),
    [anon_sym_PIPE_AMP] = ACTIONS(183),
    [anon_sym_AMP_AMP] = ACTIONS(183),
    [anon_sym_PIPE_PIPE] = ACTIONS(183),
    [sym__special_characters] = ACTIONS(467),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(469),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(193),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(195),
    [anon_sym_BQUOTE] = ACTIONS(197),
    [anon_sym_LT_LPAREN] = ACTIONS(199),
    [anon_sym_GT_LPAREN] = ACTIONS(199),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(201),
    [sym_word] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(183),
    [anon_sym_LF] = ACTIONS(203),
    [anon_sym_AMP] = ACTIONS(183),
  },
  [60] = {
    [aux_sym_concatenation_repeat1] = STATE(266),
    [sym__simple_heredoc_body] = ACTIONS(221),
    [sym__heredoc_body_beginning] = ACTIONS(221),
    [sym_file_descriptor] = ACTIONS(221),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_RPAREN] = ACTIONS(225),
    [anon_sym_SEMI_SEMI] = ACTIONS(225),
    [anon_sym_PIPE_AMP] = ACTIONS(225),
    [anon_sym_AMP_AMP] = ACTIONS(225),
    [anon_sym_PIPE_PIPE] = ACTIONS(225),
    [anon_sym_EQ_TILDE] = ACTIONS(225),
    [anon_sym_EQ_EQ] = ACTIONS(225),
    [anon_sym_LT] = ACTIONS(225),
    [anon_sym_GT] = ACTIONS(225),
    [anon_sym_GT_GT] = ACTIONS(225),
    [anon_sym_AMP_GT] = ACTIONS(225),
    [anon_sym_AMP_GT_GT] = ACTIONS(225),
    [anon_sym_LT_AMP] = ACTIONS(225),
    [anon_sym_GT_AMP] = ACTIONS(225),
    [anon_sym_LT_LT] = ACTIONS(225),
    [anon_sym_LT_LT_DASH] = ACTIONS(225),
    [anon_sym_LT_LT_LT] = ACTIONS(225),
    [sym__special_characters] = ACTIONS(225),
    [anon_sym_DQUOTE] = ACTIONS(225),
    [anon_sym_DOLLAR] = ACTIONS(225),
    [sym_raw_string] = ACTIONS(225),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(225),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(225),
    [anon_sym_BQUOTE] = ACTIONS(225),
    [anon_sym_LT_LPAREN] = ACTIONS(225),
    [anon_sym_GT_LPAREN] = ACTIONS(225),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(225),
    [anon_sym_SEMI] = ACTIONS(225),
    [anon_sym_LF] = ACTIONS(221),
    [anon_sym_AMP] = ACTIONS(225),
  },
  [61] = {
    [aux_sym_concatenation_repeat1] = STATE(266),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(249),
    [anon_sym_SEMI_SEMI] = ACTIONS(249),
    [anon_sym_PIPE_AMP] = ACTIONS(249),
    [anon_sym_AMP_AMP] = ACTIONS(249),
    [anon_sym_PIPE_PIPE] = ACTIONS(249),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(249),
    [anon_sym_LT_AMP] = ACTIONS(249),
    [anon_sym_GT_AMP] = ACTIONS(249),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(249),
    [anon_sym_LT_LT_LT] = ACTIONS(249),
    [sym__special_characters] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(249),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(249),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(249),
    [anon_sym_BQUOTE] = ACTIONS(249),
    [anon_sym_LT_LPAREN] = ACTIONS(249),
    [anon_sym_GT_LPAREN] = ACTIONS(249),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(249),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(249),
  },
  [62] = {
    [aux_sym_concatenation_repeat1] = STATE(266),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(249),
    [anon_sym_SEMI_SEMI] = ACTIONS(249),
    [anon_sym_LPAREN] = ACTIONS(471),
    [anon_sym_PIPE_AMP] = ACTIONS(249),
    [anon_sym_AMP_AMP] = ACTIONS(249),
    [anon_sym_PIPE_PIPE] = ACTIONS(249),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(249),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(249),
    [anon_sym_LT_AMP] = ACTIONS(249),
    [anon_sym_GT_AMP] = ACTIONS(249),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(249),
    [anon_sym_LT_LT_LT] = ACTIONS(249),
    [sym__special_characters] = ACTIONS(249),
    [anon_sym_DQUOTE] = ACTIONS(249),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(249),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(249),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(249),
    [anon_sym_BQUOTE] = ACTIONS(249),
    [anon_sym_LT_LPAREN] = ACTIONS(249),
    [anon_sym_GT_LPAREN] = ACTIONS(249),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(249),
    [anon_sym_SEMI] = ACTIONS(249),
    [anon_sym_LF] = ACTIONS(247),
    [anon_sym_AMP] = ACTIONS(249),
  },
  [63] = {
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(475),
    [anon_sym_SEMI_SEMI] = ACTIONS(477),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(477),
    [anon_sym_LF] = ACTIONS(481),
    [anon_sym_AMP] = ACTIONS(477),
  },
  [64] = {
    [sym_file_redirect] = STATE(278),
    [sym_heredoc_redirect] = STATE(278),
    [sym_heredoc_body] = STATE(200),
    [sym_herestring_redirect] = STATE(278),
    [sym_concatenation] = STATE(279),
    [sym_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_string_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym_while_statement_repeat1] = STATE(278),
    [aux_sym_command_repeat2] = STATE(279),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(343),
    [anon_sym_RPAREN] = ACTIONS(343),
    [anon_sym_SEMI_SEMI] = ACTIONS(343),
    [anon_sym_PIPE_AMP] = ACTIONS(343),
    [anon_sym_AMP_AMP] = ACTIONS(343),
    [anon_sym_PIPE_PIPE] = ACTIONS(343),
    [anon_sym_EQ_TILDE] = ACTIONS(485),
    [anon_sym_EQ_EQ] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(487),
    [anon_sym_AMP_GT] = ACTIONS(487),
    [anon_sym_AMP_GT_GT] = ACTIONS(487),
    [anon_sym_LT_AMP] = ACTIONS(487),
    [anon_sym_GT_AMP] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [sym__special_characters] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(493),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(493),
    [anon_sym_SEMI] = ACTIONS(343),
    [anon_sym_LF] = ACTIONS(367),
    [anon_sym_AMP] = ACTIONS(343),
  },
  [65] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(475),
    [anon_sym_SEMI_SEMI] = ACTIONS(477),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(477),
    [anon_sym_LF] = ACTIONS(481),
    [anon_sym_AMP] = ACTIONS(477),
  },
  [66] = {
    [anon_sym_EQ] = ACTIONS(457),
    [anon_sym_PLUS_EQ] = ACTIONS(457),
    [sym_comment] = ACTIONS(53),
  },
  [67] = {
    [sym__terminated_statement] = STATE(282),
    [sym_for_statement] = STATE(280),
    [sym_while_statement] = STATE(280),
    [sym_if_statement] = STATE(280),
    [sym_case_statement] = STATE(280),
    [sym_function_definition] = STATE(280),
    [sym_subshell] = STATE(280),
    [sym_pipeline] = STATE(280),
    [sym_list] = STATE(280),
    [sym_negated_command] = STATE(280),
    [sym_test_command] = STATE(280),
    [sym_declaration_command] = STATE(280),
    [sym_unset_command] = STATE(280),
    [sym_command] = STATE(280),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(281),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_program_repeat1] = STATE(282),
    [aux_sym_command_repeat1] = STATE(68),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_typeset] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_readonly] = ACTIONS(97),
    [anon_sym_local] = ACTIONS(97),
    [anon_sym_unset] = ACTIONS(99),
    [anon_sym_unsetenv] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(105),
  },
  [68] = {
    [sym_command_name] = STATE(283),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_command_repeat1] = STATE(205),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(495),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(103),
  },
  [69] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(497),
    [sym_comment] = ACTIONS(53),
  },
  [70] = {
    [anon_sym_esac] = ACTIONS(499),
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_RPAREN] = ACTIONS(499),
    [anon_sym_SEMI_SEMI] = ACTIONS(499),
    [anon_sym_PIPE_AMP] = ACTIONS(499),
    [anon_sym_AMP_AMP] = ACTIONS(499),
    [anon_sym_PIPE_PIPE] = ACTIONS(499),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(499),
    [anon_sym_LF] = ACTIONS(501),
    [anon_sym_AMP] = ACTIONS(499),
  },
  [71] = {
    [anon_sym_EQ] = ACTIONS(497),
    [anon_sym_PLUS_EQ] = ACTIONS(497),
    [sym_comment] = ACTIONS(53),
  },
  [72] = {
    [sym__expression] = STATE(288),
    [sym_binary_expression] = STATE(288),
    [sym_unary_expression] = STATE(288),
    [sym_parenthesized_expression] = STATE(288),
    [sym_concatenation] = STATE(288),
    [sym_string] = STATE(287),
    [sym_simple_expansion] = STATE(287),
    [sym_string_expansion] = STATE(287),
    [sym_expansion] = STATE(287),
    [sym_command_substitution] = STATE(287),
    [sym_process_substitution] = STATE(287),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(503),
    [sym__special_characters] = ACTIONS(505),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(507),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(509),
    [sym_test_operator] = ACTIONS(511),
  },
  [73] = {
    [sym__expression] = STATE(289),
    [sym_binary_expression] = STATE(289),
    [sym_unary_expression] = STATE(289),
    [sym_parenthesized_expression] = STATE(289),
    [sym_concatenation] = STATE(289),
    [sym_string] = STATE(77),
    [sym_simple_expansion] = STATE(77),
    [sym_string_expansion] = STATE(77),
    [sym_expansion] = STATE(77),
    [sym_command_substitution] = STATE(77),
    [sym_process_substitution] = STATE(77),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(111),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
    [sym_test_operator] = ACTIONS(131),
  },
  [74] = {
    [aux_sym_concatenation_repeat1] = STATE(291),
    [sym__concat] = ACTIONS(513),
    [anon_sym_AMP_AMP] = ACTIONS(515),
    [anon_sym_PIPE_PIPE] = ACTIONS(515),
    [anon_sym_RBRACK] = ACTIONS(515),
    [anon_sym_EQ_TILDE] = ACTIONS(515),
    [anon_sym_EQ_EQ] = ACTIONS(515),
    [anon_sym_EQ] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(515),
    [anon_sym_GT] = ACTIONS(515),
    [anon_sym_BANG_EQ] = ACTIONS(515),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(515),
  },
  [75] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(293),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [76] = {
    [sym_string] = STATE(295),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(521),
    [sym_raw_string] = ACTIONS(523),
    [anon_sym_POUND] = ACTIONS(521),
    [anon_sym_DASH] = ACTIONS(521),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(525),
    [anon_sym_STAR] = ACTIONS(521),
    [anon_sym_AT] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(521),
    [anon_sym_0] = ACTIONS(527),
    [anon_sym__] = ACTIONS(527),
  },
  [77] = {
    [aux_sym_concatenation_repeat1] = STATE(291),
    [sym__concat] = ACTIONS(513),
    [anon_sym_AMP_AMP] = ACTIONS(529),
    [anon_sym_PIPE_PIPE] = ACTIONS(529),
    [anon_sym_RBRACK] = ACTIONS(529),
    [anon_sym_EQ_TILDE] = ACTIONS(529),
    [anon_sym_EQ_EQ] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(529),
    [anon_sym_GT] = ACTIONS(529),
    [anon_sym_BANG_EQ] = ACTIONS(529),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(529),
  },
  [78] = {
    [sym_subscript] = STATE(301),
    [sym_variable_name] = ACTIONS(533),
    [anon_sym_DOLLAR] = ACTIONS(535),
    [anon_sym_POUND] = ACTIONS(537),
    [anon_sym_DASH] = ACTIONS(535),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(539),
    [anon_sym_STAR] = ACTIONS(535),
    [anon_sym_AT] = ACTIONS(535),
    [anon_sym_QMARK] = ACTIONS(535),
    [anon_sym_0] = ACTIONS(541),
    [anon_sym__] = ACTIONS(541),
  },
  [79] = {
    [sym_for_statement] = STATE(302),
    [sym_while_statement] = STATE(302),
    [sym_if_statement] = STATE(302),
    [sym_case_statement] = STATE(302),
    [sym_function_definition] = STATE(302),
    [sym_subshell] = STATE(302),
    [sym_pipeline] = STATE(302),
    [sym_list] = STATE(302),
    [sym_negated_command] = STATE(302),
    [sym_test_command] = STATE(302),
    [sym_declaration_command] = STATE(302),
    [sym_unset_command] = STATE(302),
    [sym_command] = STATE(302),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(303),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [80] = {
    [sym_for_statement] = STATE(304),
    [sym_while_statement] = STATE(304),
    [sym_if_statement] = STATE(304),
    [sym_case_statement] = STATE(304),
    [sym_function_definition] = STATE(304),
    [sym_subshell] = STATE(304),
    [sym_pipeline] = STATE(304),
    [sym_list] = STATE(304),
    [sym_negated_command] = STATE(304),
    [sym_test_command] = STATE(304),
    [sym_declaration_command] = STATE(304),
    [sym_unset_command] = STATE(304),
    [sym_command] = STATE(304),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(305),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [81] = {
    [sym_for_statement] = STATE(306),
    [sym_while_statement] = STATE(306),
    [sym_if_statement] = STATE(306),
    [sym_case_statement] = STATE(306),
    [sym_function_definition] = STATE(306),
    [sym_subshell] = STATE(306),
    [sym_pipeline] = STATE(306),
    [sym_list] = STATE(306),
    [sym_negated_command] = STATE(306),
    [sym_test_command] = STATE(306),
    [sym_declaration_command] = STATE(306),
    [sym_unset_command] = STATE(306),
    [sym_command] = STATE(306),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(307),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [82] = {
    [anon_sym_AMP_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(543),
    [anon_sym_RBRACK] = ACTIONS(545),
    [anon_sym_EQ_TILDE] = ACTIONS(547),
    [anon_sym_EQ_EQ] = ACTIONS(547),
    [anon_sym_EQ] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(543),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(543),
  },
  [83] = {
    [sym__expression] = STATE(311),
    [sym_binary_expression] = STATE(311),
    [sym_unary_expression] = STATE(311),
    [sym_parenthesized_expression] = STATE(311),
    [sym_concatenation] = STATE(311),
    [sym_string] = STATE(287),
    [sym_simple_expansion] = STATE(287),
    [sym_string_expansion] = STATE(287),
    [sym_expansion] = STATE(287),
    [sym_command_substitution] = STATE(287),
    [sym_process_substitution] = STATE(287),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(503),
    [sym__special_characters] = ACTIONS(505),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(507),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(509),
    [sym_test_operator] = ACTIONS(511),
  },
  [84] = {
    [sym__expression] = STATE(312),
    [sym_binary_expression] = STATE(312),
    [sym_unary_expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(312),
    [sym_concatenation] = STATE(312),
    [sym_string] = STATE(88),
    [sym_simple_expansion] = STATE(88),
    [sym_string_expansion] = STATE(88),
    [sym_expansion] = STATE(88),
    [sym_command_substitution] = STATE(88),
    [sym_process_substitution] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [85] = {
    [aux_sym_concatenation_repeat1] = STATE(314),
    [sym__concat] = ACTIONS(551),
    [anon_sym_AMP_AMP] = ACTIONS(515),
    [anon_sym_PIPE_PIPE] = ACTIONS(515),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(515),
    [anon_sym_EQ_TILDE] = ACTIONS(515),
    [anon_sym_EQ_EQ] = ACTIONS(515),
    [anon_sym_EQ] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(515),
    [anon_sym_GT] = ACTIONS(515),
    [anon_sym_BANG_EQ] = ACTIONS(515),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(515),
  },
  [86] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(316),
    [anon_sym_DQUOTE] = ACTIONS(553),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [87] = {
    [sym_string] = STATE(318),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(555),
    [sym_raw_string] = ACTIONS(557),
    [anon_sym_POUND] = ACTIONS(555),
    [anon_sym_DASH] = ACTIONS(555),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(559),
    [anon_sym_STAR] = ACTIONS(555),
    [anon_sym_AT] = ACTIONS(555),
    [anon_sym_QMARK] = ACTIONS(555),
    [anon_sym_0] = ACTIONS(561),
    [anon_sym__] = ACTIONS(561),
  },
  [88] = {
    [aux_sym_concatenation_repeat1] = STATE(314),
    [sym__concat] = ACTIONS(551),
    [anon_sym_AMP_AMP] = ACTIONS(529),
    [anon_sym_PIPE_PIPE] = ACTIONS(529),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(529),
    [anon_sym_EQ_TILDE] = ACTIONS(529),
    [anon_sym_EQ_EQ] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(529),
    [anon_sym_GT] = ACTIONS(529),
    [anon_sym_BANG_EQ] = ACTIONS(529),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(529),
  },
  [89] = {
    [sym_subscript] = STATE(324),
    [sym_variable_name] = ACTIONS(563),
    [anon_sym_DOLLAR] = ACTIONS(565),
    [anon_sym_POUND] = ACTIONS(567),
    [anon_sym_DASH] = ACTIONS(565),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(569),
    [anon_sym_STAR] = ACTIONS(565),
    [anon_sym_AT] = ACTIONS(565),
    [anon_sym_QMARK] = ACTIONS(565),
    [anon_sym_0] = ACTIONS(571),
    [anon_sym__] = ACTIONS(571),
  },
  [90] = {
    [sym_for_statement] = STATE(325),
    [sym_while_statement] = STATE(325),
    [sym_if_statement] = STATE(325),
    [sym_case_statement] = STATE(325),
    [sym_function_definition] = STATE(325),
    [sym_subshell] = STATE(325),
    [sym_pipeline] = STATE(325),
    [sym_list] = STATE(325),
    [sym_negated_command] = STATE(325),
    [sym_test_command] = STATE(325),
    [sym_declaration_command] = STATE(325),
    [sym_unset_command] = STATE(325),
    [sym_command] = STATE(325),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(326),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [91] = {
    [sym_for_statement] = STATE(327),
    [sym_while_statement] = STATE(327),
    [sym_if_statement] = STATE(327),
    [sym_case_statement] = STATE(327),
    [sym_function_definition] = STATE(327),
    [sym_subshell] = STATE(327),
    [sym_pipeline] = STATE(327),
    [sym_list] = STATE(327),
    [sym_negated_command] = STATE(327),
    [sym_test_command] = STATE(327),
    [sym_declaration_command] = STATE(327),
    [sym_unset_command] = STATE(327),
    [sym_command] = STATE(327),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(328),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [92] = {
    [sym_for_statement] = STATE(329),
    [sym_while_statement] = STATE(329),
    [sym_if_statement] = STATE(329),
    [sym_case_statement] = STATE(329),
    [sym_function_definition] = STATE(329),
    [sym_subshell] = STATE(329),
    [sym_pipeline] = STATE(329),
    [sym_list] = STATE(329),
    [sym_negated_command] = STATE(329),
    [sym_test_command] = STATE(329),
    [sym_declaration_command] = STATE(329),
    [sym_unset_command] = STATE(329),
    [sym_command] = STATE(329),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(330),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [93] = {
    [anon_sym_AMP_AMP] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(545),
    [anon_sym_EQ_TILDE] = ACTIONS(575),
    [anon_sym_EQ_EQ] = ACTIONS(575),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(573),
    [anon_sym_GT] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(573),
  },
  [94] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_PLUS_EQ] = ACTIONS(579),
    [sym_comment] = ACTIONS(53),
  },
  [95] = {
    [aux_sym_concatenation_repeat1] = STATE(335),
    [sym__concat] = ACTIONS(581),
    [sym_variable_name] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(585),
    [anon_sym_SEMI_SEMI] = ACTIONS(585),
    [anon_sym_PIPE_AMP] = ACTIONS(585),
    [anon_sym_AMP_AMP] = ACTIONS(585),
    [anon_sym_PIPE_PIPE] = ACTIONS(585),
    [sym__special_characters] = ACTIONS(585),
    [anon_sym_DQUOTE] = ACTIONS(585),
    [anon_sym_DOLLAR] = ACTIONS(585),
    [sym_raw_string] = ACTIONS(585),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(585),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(585),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [anon_sym_LT_LPAREN] = ACTIONS(585),
    [anon_sym_GT_LPAREN] = ACTIONS(585),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(585),
    [sym_word] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(585),
    [anon_sym_LF] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(585),
  },
  [96] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(337),
    [anon_sym_DQUOTE] = ACTIONS(587),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [97] = {
    [sym_string] = STATE(339),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [anon_sym_DOLLAR] = ACTIONS(591),
    [sym_raw_string] = ACTIONS(593),
    [anon_sym_POUND] = ACTIONS(591),
    [anon_sym_DASH] = ACTIONS(591),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(595),
    [anon_sym_STAR] = ACTIONS(591),
    [anon_sym_AT] = ACTIONS(591),
    [anon_sym_QMARK] = ACTIONS(591),
    [anon_sym_0] = ACTIONS(597),
    [anon_sym__] = ACTIONS(597),
  },
  [98] = {
    [aux_sym_concatenation_repeat1] = STATE(335),
    [sym__concat] = ACTIONS(581),
    [sym_variable_name] = ACTIONS(599),
    [anon_sym_PIPE] = ACTIONS(601),
    [anon_sym_SEMI_SEMI] = ACTIONS(601),
    [anon_sym_PIPE_AMP] = ACTIONS(601),
    [anon_sym_AMP_AMP] = ACTIONS(601),
    [anon_sym_PIPE_PIPE] = ACTIONS(601),
    [sym__special_characters] = ACTIONS(601),
    [anon_sym_DQUOTE] = ACTIONS(601),
    [anon_sym_DOLLAR] = ACTIONS(601),
    [sym_raw_string] = ACTIONS(601),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(601),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(601),
    [anon_sym_BQUOTE] = ACTIONS(601),
    [anon_sym_LT_LPAREN] = ACTIONS(601),
    [anon_sym_GT_LPAREN] = ACTIONS(601),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(601),
    [sym_word] = ACTIONS(601),
    [anon_sym_SEMI] = ACTIONS(601),
    [anon_sym_LF] = ACTIONS(599),
    [anon_sym_AMP] = ACTIONS(601),
  },
  [99] = {
    [sym_subscript] = STATE(345),
    [sym_variable_name] = ACTIONS(603),
    [anon_sym_DOLLAR] = ACTIONS(605),
    [anon_sym_POUND] = ACTIONS(607),
    [anon_sym_DASH] = ACTIONS(605),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(609),
    [anon_sym_STAR] = ACTIONS(605),
    [anon_sym_AT] = ACTIONS(605),
    [anon_sym_QMARK] = ACTIONS(605),
    [anon_sym_0] = ACTIONS(611),
    [anon_sym__] = ACTIONS(611),
  },
  [100] = {
    [sym_for_statement] = STATE(346),
    [sym_while_statement] = STATE(346),
    [sym_if_statement] = STATE(346),
    [sym_case_statement] = STATE(346),
    [sym_function_definition] = STATE(346),
    [sym_subshell] = STATE(346),
    [sym_pipeline] = STATE(346),
    [sym_list] = STATE(346),
    [sym_negated_command] = STATE(346),
    [sym_test_command] = STATE(346),
    [sym_declaration_command] = STATE(346),
    [sym_unset_command] = STATE(346),
    [sym_command] = STATE(346),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(347),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [101] = {
    [sym_for_statement] = STATE(348),
    [sym_while_statement] = STATE(348),
    [sym_if_statement] = STATE(348),
    [sym_case_statement] = STATE(348),
    [sym_function_definition] = STATE(348),
    [sym_subshell] = STATE(348),
    [sym_pipeline] = STATE(348),
    [sym_list] = STATE(348),
    [sym_negated_command] = STATE(348),
    [sym_test_command] = STATE(348),
    [sym_declaration_command] = STATE(348),
    [sym_unset_command] = STATE(348),
    [sym_command] = STATE(348),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(349),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [102] = {
    [sym_for_statement] = STATE(350),
    [sym_while_statement] = STATE(350),
    [sym_if_statement] = STATE(350),
    [sym_case_statement] = STATE(350),
    [sym_function_definition] = STATE(350),
    [sym_subshell] = STATE(350),
    [sym_pipeline] = STATE(350),
    [sym_list] = STATE(350),
    [sym_negated_command] = STATE(350),
    [sym_test_command] = STATE(350),
    [sym_declaration_command] = STATE(350),
    [sym_unset_command] = STATE(350),
    [sym_command] = STATE(350),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(351),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [103] = {
    [sym_variable_name] = ACTIONS(613),
    [anon_sym_PIPE] = ACTIONS(615),
    [anon_sym_RPAREN] = ACTIONS(615),
    [anon_sym_SEMI_SEMI] = ACTIONS(615),
    [anon_sym_PIPE_AMP] = ACTIONS(615),
    [anon_sym_AMP_AMP] = ACTIONS(615),
    [anon_sym_PIPE_PIPE] = ACTIONS(615),
    [sym__special_characters] = ACTIONS(615),
    [anon_sym_DQUOTE] = ACTIONS(615),
    [anon_sym_DOLLAR] = ACTIONS(615),
    [sym_raw_string] = ACTIONS(615),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(615),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(615),
    [anon_sym_BQUOTE] = ACTIONS(615),
    [anon_sym_LT_LPAREN] = ACTIONS(615),
    [anon_sym_GT_LPAREN] = ACTIONS(615),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(615),
    [sym_word] = ACTIONS(615),
    [anon_sym_SEMI] = ACTIONS(615),
    [anon_sym_LF] = ACTIONS(613),
    [anon_sym_AMP] = ACTIONS(615),
  },
  [104] = {
    [anon_sym_EQ] = ACTIONS(579),
    [anon_sym_PLUS_EQ] = ACTIONS(579),
    [sym_comment] = ACTIONS(53),
  },
  [105] = {
    [sym_variable_assignment] = STATE(352),
    [sym_subscript] = STATE(104),
    [sym_concatenation] = STATE(352),
    [sym_string] = STATE(98),
    [sym_simple_expansion] = STATE(98),
    [sym_string_expansion] = STATE(98),
    [sym_expansion] = STATE(98),
    [sym_command_substitution] = STATE(98),
    [sym_process_substitution] = STATE(98),
    [aux_sym_declaration_command_repeat1] = STATE(352),
    [sym_variable_name] = ACTIONS(157),
    [anon_sym_PIPE] = ACTIONS(617),
    [anon_sym_SEMI_SEMI] = ACTIONS(617),
    [anon_sym_PIPE_AMP] = ACTIONS(617),
    [anon_sym_AMP_AMP] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [sym__special_characters] = ACTIONS(161),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(167),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(179),
    [sym_word] = ACTIONS(167),
    [anon_sym_SEMI] = ACTIONS(617),
    [anon_sym_LF] = ACTIONS(619),
    [anon_sym_AMP] = ACTIONS(617),
  },
  [106] = {
    [aux_sym_concatenation_repeat1] = STATE(354),
    [sym__concat] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_SEMI_SEMI] = ACTIONS(623),
    [anon_sym_PIPE_AMP] = ACTIONS(623),
    [anon_sym_AMP_AMP] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [sym__special_characters] = ACTIONS(623),
    [anon_sym_DQUOTE] = ACTIONS(623),
    [anon_sym_DOLLAR] = ACTIONS(623),
    [sym_raw_string] = ACTIONS(623),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(623),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(623),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_LT_LPAREN] = ACTIONS(623),
    [anon_sym_GT_LPAREN] = ACTIONS(623),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(623),
    [sym_word] = ACTIONS(623),
    [anon_sym_SEMI] = ACTIONS(623),
    [anon_sym_LF] = ACTIONS(625),
    [anon_sym_AMP] = ACTIONS(623),
  },
  [107] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(356),
    [anon_sym_DQUOTE] = ACTIONS(627),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [108] = {
    [sym_string] = STATE(358),
    [anon_sym_DQUOTE] = ACTIONS(629),
    [anon_sym_DOLLAR] = ACTIONS(631),
    [sym_raw_string] = ACTIONS(633),
    [anon_sym_POUND] = ACTIONS(631),
    [anon_sym_DASH] = ACTIONS(631),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(635),
    [anon_sym_STAR] = ACTIONS(631),
    [anon_sym_AT] = ACTIONS(631),
    [anon_sym_QMARK] = ACTIONS(631),
    [anon_sym_0] = ACTIONS(637),
    [anon_sym__] = ACTIONS(637),
  },
  [109] = {
    [aux_sym_concatenation_repeat1] = STATE(354),
    [sym__concat] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(639),
    [anon_sym_SEMI_SEMI] = ACTIONS(639),
    [anon_sym_PIPE_AMP] = ACTIONS(639),
    [anon_sym_AMP_AMP] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [sym__special_characters] = ACTIONS(639),
    [anon_sym_DQUOTE] = ACTIONS(639),
    [anon_sym_DOLLAR] = ACTIONS(639),
    [sym_raw_string] = ACTIONS(639),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(639),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(639),
    [anon_sym_BQUOTE] = ACTIONS(639),
    [anon_sym_LT_LPAREN] = ACTIONS(639),
    [anon_sym_GT_LPAREN] = ACTIONS(639),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(639),
    [sym_word] = ACTIONS(639),
    [anon_sym_SEMI] = ACTIONS(639),
    [anon_sym_LF] = ACTIONS(641),
    [anon_sym_AMP] = ACTIONS(639),
  },
  [110] = {
    [sym_subscript] = STATE(364),
    [sym_variable_name] = ACTIONS(643),
    [anon_sym_DOLLAR] = ACTIONS(645),
    [anon_sym_POUND] = ACTIONS(647),
    [anon_sym_DASH] = ACTIONS(645),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(649),
    [anon_sym_STAR] = ACTIONS(645),
    [anon_sym_AT] = ACTIONS(645),
    [anon_sym_QMARK] = ACTIONS(645),
    [anon_sym_0] = ACTIONS(651),
    [anon_sym__] = ACTIONS(651),
  },
  [111] = {
    [sym_for_statement] = STATE(365),
    [sym_while_statement] = STATE(365),
    [sym_if_statement] = STATE(365),
    [sym_case_statement] = STATE(365),
    [sym_function_definition] = STATE(365),
    [sym_subshell] = STATE(365),
    [sym_pipeline] = STATE(365),
    [sym_list] = STATE(365),
    [sym_negated_command] = STATE(365),
    [sym_test_command] = STATE(365),
    [sym_declaration_command] = STATE(365),
    [sym_unset_command] = STATE(365),
    [sym_command] = STATE(365),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(366),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [112] = {
    [sym_for_statement] = STATE(367),
    [sym_while_statement] = STATE(367),
    [sym_if_statement] = STATE(367),
    [sym_case_statement] = STATE(367),
    [sym_function_definition] = STATE(367),
    [sym_subshell] = STATE(367),
    [sym_pipeline] = STATE(367),
    [sym_list] = STATE(367),
    [sym_negated_command] = STATE(367),
    [sym_test_command] = STATE(367),
    [sym_declaration_command] = STATE(367),
    [sym_unset_command] = STATE(367),
    [sym_command] = STATE(367),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(368),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [113] = {
    [sym_for_statement] = STATE(369),
    [sym_while_statement] = STATE(369),
    [sym_if_statement] = STATE(369),
    [sym_case_statement] = STATE(369),
    [sym_function_definition] = STATE(369),
    [sym_subshell] = STATE(369),
    [sym_pipeline] = STATE(369),
    [sym_list] = STATE(369),
    [sym_negated_command] = STATE(369),
    [sym_test_command] = STATE(369),
    [sym_declaration_command] = STATE(369),
    [sym_unset_command] = STATE(369),
    [sym_command] = STATE(369),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(370),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [114] = {
    [anon_sym_PIPE] = ACTIONS(653),
    [anon_sym_RPAREN] = ACTIONS(653),
    [anon_sym_SEMI_SEMI] = ACTIONS(653),
    [anon_sym_PIPE_AMP] = ACTIONS(653),
    [anon_sym_AMP_AMP] = ACTIONS(653),
    [anon_sym_PIPE_PIPE] = ACTIONS(653),
    [sym__special_characters] = ACTIONS(653),
    [anon_sym_DQUOTE] = ACTIONS(653),
    [anon_sym_DOLLAR] = ACTIONS(653),
    [sym_raw_string] = ACTIONS(653),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(653),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(653),
    [anon_sym_BQUOTE] = ACTIONS(653),
    [anon_sym_LT_LPAREN] = ACTIONS(653),
    [anon_sym_GT_LPAREN] = ACTIONS(653),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(653),
    [sym_word] = ACTIONS(653),
    [anon_sym_SEMI] = ACTIONS(653),
    [anon_sym_LF] = ACTIONS(655),
    [anon_sym_AMP] = ACTIONS(653),
  },
  [115] = {
    [sym_concatenation] = STATE(371),
    [sym_string] = STATE(109),
    [sym_simple_expansion] = STATE(109),
    [sym_string_expansion] = STATE(109),
    [sym_expansion] = STATE(109),
    [sym_command_substitution] = STATE(109),
    [sym_process_substitution] = STATE(109),
    [aux_sym_unset_command_repeat1] = STATE(371),
    [anon_sym_PIPE] = ACTIONS(657),
    [anon_sym_SEMI_SEMI] = ACTIONS(657),
    [anon_sym_PIPE_AMP] = ACTIONS(657),
    [anon_sym_AMP_AMP] = ACTIONS(657),
    [anon_sym_PIPE_PIPE] = ACTIONS(657),
    [sym__special_characters] = ACTIONS(185),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(191),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(193),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(195),
    [anon_sym_BQUOTE] = ACTIONS(197),
    [anon_sym_LT_LPAREN] = ACTIONS(199),
    [anon_sym_GT_LPAREN] = ACTIONS(199),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(201),
    [sym_word] = ACTIONS(191),
    [anon_sym_SEMI] = ACTIONS(657),
    [anon_sym_LF] = ACTIONS(659),
    [anon_sym_AMP] = ACTIONS(657),
  },
  [116] = {
    [aux_sym_concatenation_repeat1] = STATE(373),
    [sym_file_descriptor] = ACTIONS(661),
    [sym__concat] = ACTIONS(663),
    [sym_variable_name] = ACTIONS(661),
    [anon_sym_LT] = ACTIONS(665),
    [anon_sym_GT] = ACTIONS(665),
    [anon_sym_GT_GT] = ACTIONS(661),
    [anon_sym_AMP_GT] = ACTIONS(665),
    [anon_sym_AMP_GT_GT] = ACTIONS(661),
    [anon_sym_LT_AMP] = ACTIONS(661),
    [anon_sym_GT_AMP] = ACTIONS(661),
    [sym__special_characters] = ACTIONS(661),
    [anon_sym_DQUOTE] = ACTIONS(661),
    [anon_sym_DOLLAR] = ACTIONS(665),
    [sym_raw_string] = ACTIONS(661),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(661),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(661),
    [anon_sym_BQUOTE] = ACTIONS(661),
    [anon_sym_LT_LPAREN] = ACTIONS(661),
    [anon_sym_GT_LPAREN] = ACTIONS(661),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(661),
  },
  [117] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(375),
    [anon_sym_DQUOTE] = ACTIONS(667),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [118] = {
    [sym_string] = STATE(377),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(669),
    [sym_raw_string] = ACTIONS(671),
    [anon_sym_POUND] = ACTIONS(669),
    [anon_sym_DASH] = ACTIONS(669),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(673),
    [anon_sym_STAR] = ACTIONS(669),
    [anon_sym_AT] = ACTIONS(669),
    [anon_sym_QMARK] = ACTIONS(669),
    [anon_sym_0] = ACTIONS(675),
    [anon_sym__] = ACTIONS(675),
  },
  [119] = {
    [aux_sym_concatenation_repeat1] = STATE(373),
    [sym_file_descriptor] = ACTIONS(677),
    [sym__concat] = ACTIONS(663),
    [sym_variable_name] = ACTIONS(677),
    [anon_sym_LT] = ACTIONS(679),
    [anon_sym_GT] = ACTIONS(679),
    [anon_sym_GT_GT] = ACTIONS(677),
    [anon_sym_AMP_GT] = ACTIONS(679),
    [anon_sym_AMP_GT_GT] = ACTIONS(677),
    [anon_sym_LT_AMP] = ACTIONS(677),
    [anon_sym_GT_AMP] = ACTIONS(677),
    [sym__special_characters] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(677),
    [anon_sym_DOLLAR] = ACTIONS(679),
    [sym_raw_string] = ACTIONS(677),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(677),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(677),
    [anon_sym_BQUOTE] = ACTIONS(677),
    [anon_sym_LT_LPAREN] = ACTIONS(677),
    [anon_sym_GT_LPAREN] = ACTIONS(677),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(677),
  },
  [120] = {
    [sym_subscript] = STATE(383),
    [sym_variable_name] = ACTIONS(681),
    [anon_sym_DOLLAR] = ACTIONS(683),
    [anon_sym_POUND] = ACTIONS(685),
    [anon_sym_DASH] = ACTIONS(683),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(687),
    [anon_sym_STAR] = ACTIONS(683),
    [anon_sym_AT] = ACTIONS(683),
    [anon_sym_QMARK] = ACTIONS(683),
    [anon_sym_0] = ACTIONS(689),
    [anon_sym__] = ACTIONS(689),
  },
  [121] = {
    [sym_for_statement] = STATE(384),
    [sym_while_statement] = STATE(384),
    [sym_if_statement] = STATE(384),
    [sym_case_statement] = STATE(384),
    [sym_function_definition] = STATE(384),
    [sym_subshell] = STATE(384),
    [sym_pipeline] = STATE(384),
    [sym_list] = STATE(384),
    [sym_negated_command] = STATE(384),
    [sym_test_command] = STATE(384),
    [sym_declaration_command] = STATE(384),
    [sym_unset_command] = STATE(384),
    [sym_command] = STATE(384),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(385),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [122] = {
    [sym_for_statement] = STATE(386),
    [sym_while_statement] = STATE(386),
    [sym_if_statement] = STATE(386),
    [sym_case_statement] = STATE(386),
    [sym_function_definition] = STATE(386),
    [sym_subshell] = STATE(386),
    [sym_pipeline] = STATE(386),
    [sym_list] = STATE(386),
    [sym_negated_command] = STATE(386),
    [sym_test_command] = STATE(386),
    [sym_declaration_command] = STATE(386),
    [sym_unset_command] = STATE(386),
    [sym_command] = STATE(386),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(387),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [123] = {
    [sym_for_statement] = STATE(388),
    [sym_while_statement] = STATE(388),
    [sym_if_statement] = STATE(388),
    [sym_case_statement] = STATE(388),
    [sym_function_definition] = STATE(388),
    [sym_subshell] = STATE(388),
    [sym_pipeline] = STATE(388),
    [sym_list] = STATE(388),
    [sym_negated_command] = STATE(388),
    [sym_test_command] = STATE(388),
    [sym_declaration_command] = STATE(388),
    [sym_unset_command] = STATE(388),
    [sym_command] = STATE(388),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(389),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [124] = {
    [sym_file_descriptor] = ACTIONS(677),
    [sym_variable_name] = ACTIONS(677),
    [anon_sym_LT] = ACTIONS(679),
    [anon_sym_GT] = ACTIONS(679),
    [anon_sym_GT_GT] = ACTIONS(677),
    [anon_sym_AMP_GT] = ACTIONS(679),
    [anon_sym_AMP_GT_GT] = ACTIONS(677),
    [anon_sym_LT_AMP] = ACTIONS(677),
    [anon_sym_GT_AMP] = ACTIONS(677),
    [sym__special_characters] = ACTIONS(677),
    [anon_sym_DQUOTE] = ACTIONS(677),
    [anon_sym_DOLLAR] = ACTIONS(679),
    [sym_raw_string] = ACTIONS(677),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(677),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(677),
    [anon_sym_BQUOTE] = ACTIONS(677),
    [anon_sym_LT_LPAREN] = ACTIONS(677),
    [anon_sym_GT_LPAREN] = ACTIONS(677),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(677),
  },
  [125] = {
    [sym_string] = STATE(390),
    [sym_simple_expansion] = STATE(390),
    [sym_string_expansion] = STATE(390),
    [sym_expansion] = STATE(390),
    [sym_command_substitution] = STATE(390),
    [sym_process_substitution] = STATE(390),
    [sym__special_characters] = ACTIONS(691),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(691),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(691),
  },
  [126] = {
    [aux_sym_concatenation_repeat1] = STATE(391),
    [sym__simple_heredoc_body] = ACTIONS(693),
    [sym__heredoc_body_beginning] = ACTIONS(693),
    [sym_file_descriptor] = ACTIONS(693),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(695),
    [anon_sym_EQ_TILDE] = ACTIONS(695),
    [anon_sym_EQ_EQ] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(695),
    [anon_sym_GT] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(695),
    [anon_sym_AMP_GT] = ACTIONS(695),
    [anon_sym_AMP_GT_GT] = ACTIONS(695),
    [anon_sym_LT_AMP] = ACTIONS(695),
    [anon_sym_GT_AMP] = ACTIONS(695),
    [anon_sym_LT_LT] = ACTIONS(695),
    [anon_sym_LT_LT_DASH] = ACTIONS(695),
    [anon_sym_LT_LT_LT] = ACTIONS(695),
    [sym__special_characters] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(695),
    [anon_sym_BQUOTE] = ACTIONS(695),
    [anon_sym_LT_LPAREN] = ACTIONS(695),
    [anon_sym_GT_LPAREN] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [127] = {
    [sym__simple_heredoc_body] = ACTIONS(697),
    [sym__heredoc_body_beginning] = ACTIONS(697),
    [sym_file_descriptor] = ACTIONS(697),
    [sym__concat] = ACTIONS(697),
    [anon_sym_PIPE] = ACTIONS(699),
    [anon_sym_RPAREN] = ACTIONS(699),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [anon_sym_PIPE_AMP] = ACTIONS(699),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [anon_sym_EQ_TILDE] = ACTIONS(699),
    [anon_sym_EQ_EQ] = ACTIONS(699),
    [anon_sym_LT] = ACTIONS(699),
    [anon_sym_GT] = ACTIONS(699),
    [anon_sym_GT_GT] = ACTIONS(699),
    [anon_sym_AMP_GT] = ACTIONS(699),
    [anon_sym_AMP_GT_GT] = ACTIONS(699),
    [anon_sym_LT_AMP] = ACTIONS(699),
    [anon_sym_GT_AMP] = ACTIONS(699),
    [anon_sym_LT_LT] = ACTIONS(699),
    [anon_sym_LT_LT_DASH] = ACTIONS(699),
    [anon_sym_LT_LT_LT] = ACTIONS(699),
    [sym__special_characters] = ACTIONS(699),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_DOLLAR] = ACTIONS(699),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(699),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(699),
    [anon_sym_BQUOTE] = ACTIONS(699),
    [anon_sym_LT_LPAREN] = ACTIONS(699),
    [anon_sym_GT_LPAREN] = ACTIONS(699),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(699),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_LF] = ACTIONS(697),
    [anon_sym_AMP] = ACTIONS(699),
  },
  [128] = {
    [anon_sym_DOLLAR] = ACTIONS(701),
    [sym__string_content] = ACTIONS(703),
    [anon_sym_POUND] = ACTIONS(705),
    [anon_sym_DASH] = ACTIONS(705),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(707),
    [anon_sym_STAR] = ACTIONS(705),
    [anon_sym_AT] = ACTIONS(705),
    [anon_sym_QMARK] = ACTIONS(705),
    [anon_sym_0] = ACTIONS(701),
    [anon_sym__] = ACTIONS(701),
  },
  [129] = {
    [sym__concat] = ACTIONS(709),
    [anon_sym_DQUOTE] = ACTIONS(711),
    [anon_sym_DOLLAR] = ACTIONS(711),
    [sym__string_content] = ACTIONS(713),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(711),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(711),
    [anon_sym_BQUOTE] = ACTIONS(711),
    [sym_comment] = ACTIONS(177),
  },
  [130] = {
    [sym_subscript] = STATE(400),
    [sym_variable_name] = ACTIONS(715),
    [anon_sym_DOLLAR] = ACTIONS(717),
    [anon_sym_POUND] = ACTIONS(719),
    [anon_sym_DASH] = ACTIONS(717),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(721),
    [anon_sym_STAR] = ACTIONS(717),
    [anon_sym_AT] = ACTIONS(717),
    [anon_sym_QMARK] = ACTIONS(717),
    [anon_sym_0] = ACTIONS(723),
    [anon_sym__] = ACTIONS(723),
  },
  [131] = {
    [sym_for_statement] = STATE(401),
    [sym_while_statement] = STATE(401),
    [sym_if_statement] = STATE(401),
    [sym_case_statement] = STATE(401),
    [sym_function_definition] = STATE(401),
    [sym_subshell] = STATE(401),
    [sym_pipeline] = STATE(401),
    [sym_list] = STATE(401),
    [sym_negated_command] = STATE(401),
    [sym_test_command] = STATE(401),
    [sym_declaration_command] = STATE(401),
    [sym_unset_command] = STATE(401),
    [sym_command] = STATE(401),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(402),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [132] = {
    [sym_for_statement] = STATE(403),
    [sym_while_statement] = STATE(403),
    [sym_if_statement] = STATE(403),
    [sym_case_statement] = STATE(403),
    [sym_function_definition] = STATE(403),
    [sym_subshell] = STATE(403),
    [sym_pipeline] = STATE(403),
    [sym_list] = STATE(403),
    [sym_negated_command] = STATE(403),
    [sym_test_command] = STATE(403),
    [sym_declaration_command] = STATE(403),
    [sym_unset_command] = STATE(403),
    [sym_command] = STATE(403),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(404),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [133] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(725),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [134] = {
    [sym__simple_heredoc_body] = ACTIONS(727),
    [sym__heredoc_body_beginning] = ACTIONS(727),
    [sym_file_descriptor] = ACTIONS(727),
    [sym__concat] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_RPAREN] = ACTIONS(729),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [anon_sym_EQ_TILDE] = ACTIONS(729),
    [anon_sym_EQ_EQ] = ACTIONS(729),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(729),
    [anon_sym_AMP_GT] = ACTIONS(729),
    [anon_sym_AMP_GT_GT] = ACTIONS(729),
    [anon_sym_LT_AMP] = ACTIONS(729),
    [anon_sym_GT_AMP] = ACTIONS(729),
    [anon_sym_LT_LT] = ACTIONS(729),
    [anon_sym_LT_LT_DASH] = ACTIONS(729),
    [anon_sym_LT_LT_LT] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(729),
    [anon_sym_DQUOTE] = ACTIONS(729),
    [anon_sym_DOLLAR] = ACTIONS(729),
    [sym_raw_string] = ACTIONS(729),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(729),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(729),
    [anon_sym_BQUOTE] = ACTIONS(729),
    [anon_sym_LT_LPAREN] = ACTIONS(729),
    [anon_sym_GT_LPAREN] = ACTIONS(729),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(729),
    [anon_sym_LF] = ACTIONS(727),
    [anon_sym_AMP] = ACTIONS(729),
  },
  [135] = {
    [sym__simple_heredoc_body] = ACTIONS(731),
    [sym__heredoc_body_beginning] = ACTIONS(731),
    [sym_file_descriptor] = ACTIONS(731),
    [sym__concat] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(733),
    [anon_sym_SEMI_SEMI] = ACTIONS(733),
    [anon_sym_PIPE_AMP] = ACTIONS(733),
    [anon_sym_AMP_AMP] = ACTIONS(733),
    [anon_sym_PIPE_PIPE] = ACTIONS(733),
    [anon_sym_EQ_TILDE] = ACTIONS(733),
    [anon_sym_EQ_EQ] = ACTIONS(733),
    [anon_sym_LT] = ACTIONS(733),
    [anon_sym_GT] = ACTIONS(733),
    [anon_sym_GT_GT] = ACTIONS(733),
    [anon_sym_AMP_GT] = ACTIONS(733),
    [anon_sym_AMP_GT_GT] = ACTIONS(733),
    [anon_sym_LT_AMP] = ACTIONS(733),
    [anon_sym_GT_AMP] = ACTIONS(733),
    [anon_sym_LT_LT] = ACTIONS(733),
    [anon_sym_LT_LT_DASH] = ACTIONS(733),
    [anon_sym_LT_LT_LT] = ACTIONS(733),
    [sym__special_characters] = ACTIONS(733),
    [anon_sym_DQUOTE] = ACTIONS(733),
    [anon_sym_DOLLAR] = ACTIONS(733),
    [sym_raw_string] = ACTIONS(733),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(733),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(733),
    [anon_sym_BQUOTE] = ACTIONS(733),
    [anon_sym_LT_LPAREN] = ACTIONS(733),
    [anon_sym_GT_LPAREN] = ACTIONS(733),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(733),
    [anon_sym_SEMI] = ACTIONS(733),
    [anon_sym_LF] = ACTIONS(731),
    [anon_sym_AMP] = ACTIONS(733),
  },
  [136] = {
    [sym__simple_heredoc_body] = ACTIONS(735),
    [sym__heredoc_body_beginning] = ACTIONS(735),
    [sym_file_descriptor] = ACTIONS(735),
    [sym__concat] = ACTIONS(735),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_RPAREN] = ACTIONS(737),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [anon_sym_PIPE_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(737),
    [anon_sym_EQ_TILDE] = ACTIONS(737),
    [anon_sym_EQ_EQ] = ACTIONS(737),
    [anon_sym_LT] = ACTIONS(737),
    [anon_sym_GT] = ACTIONS(737),
    [anon_sym_GT_GT] = ACTIONS(737),
    [anon_sym_AMP_GT] = ACTIONS(737),
    [anon_sym_AMP_GT_GT] = ACTIONS(737),
    [anon_sym_LT_AMP] = ACTIONS(737),
    [anon_sym_GT_AMP] = ACTIONS(737),
    [anon_sym_LT_LT] = ACTIONS(737),
    [anon_sym_LT_LT_DASH] = ACTIONS(737),
    [anon_sym_LT_LT_LT] = ACTIONS(737),
    [sym__special_characters] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym_raw_string] = ACTIONS(737),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [anon_sym_LT_LPAREN] = ACTIONS(737),
    [anon_sym_GT_LPAREN] = ACTIONS(737),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(737),
    [anon_sym_SEMI] = ACTIONS(737),
    [anon_sym_LF] = ACTIONS(735),
    [anon_sym_AMP] = ACTIONS(737),
  },
  [137] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(741),
    [sym_comment] = ACTIONS(53),
  },
  [138] = {
    [sym_concatenation] = STATE(419),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(419),
    [anon_sym_RBRACE] = ACTIONS(743),
    [anon_sym_EQ] = ACTIONS(745),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(755),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(759),
    [anon_sym_COLON] = ACTIONS(745),
    [anon_sym_COLON_QMARK] = ACTIONS(745),
    [anon_sym_COLON_DASH] = ACTIONS(745),
    [anon_sym_PERCENT] = ACTIONS(745),
    [anon_sym_DASH] = ACTIONS(745),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [139] = {
    [sym_subscript] = STATE(423),
    [sym_variable_name] = ACTIONS(769),
    [anon_sym_DOLLAR] = ACTIONS(771),
    [anon_sym_DASH] = ACTIONS(771),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(773),
    [anon_sym_STAR] = ACTIONS(771),
    [anon_sym_AT] = ACTIONS(771),
    [anon_sym_QMARK] = ACTIONS(771),
    [anon_sym_0] = ACTIONS(775),
    [anon_sym__] = ACTIONS(775),
  },
  [140] = {
    [sym_concatenation] = STATE(426),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(426),
    [anon_sym_RBRACE] = ACTIONS(777),
    [anon_sym_EQ] = ACTIONS(779),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(781),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(783),
    [anon_sym_COLON] = ACTIONS(779),
    [anon_sym_COLON_QMARK] = ACTIONS(779),
    [anon_sym_COLON_DASH] = ACTIONS(779),
    [anon_sym_PERCENT] = ACTIONS(779),
    [anon_sym_DASH] = ACTIONS(779),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [141] = {
    [sym_concatenation] = STATE(429),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(429),
    [anon_sym_RBRACE] = ACTIONS(785),
    [anon_sym_EQ] = ACTIONS(787),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(789),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(791),
    [anon_sym_COLON] = ACTIONS(787),
    [anon_sym_COLON_QMARK] = ACTIONS(787),
    [anon_sym_COLON_DASH] = ACTIONS(787),
    [anon_sym_PERCENT] = ACTIONS(787),
    [anon_sym_DASH] = ACTIONS(787),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [142] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(793),
    [anon_sym_PLUS_EQ] = ACTIONS(793),
    [sym_comment] = ACTIONS(53),
  },
  [143] = {
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(795),
  },
  [144] = {
    [sym__terminated_statement] = STATE(432),
    [sym_for_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_subshell] = STATE(39),
    [sym_pipeline] = STATE(39),
    [sym_list] = STATE(39),
    [sym_negated_command] = STATE(39),
    [sym_test_command] = STATE(39),
    [sym_declaration_command] = STATE(39),
    [sym_unset_command] = STATE(39),
    [sym_command] = STATE(39),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(40),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [145] = {
    [sym__terminated_statement] = STATE(433),
    [sym_for_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_subshell] = STATE(39),
    [sym_pipeline] = STATE(39),
    [sym_list] = STATE(39),
    [sym_negated_command] = STATE(39),
    [sym_test_command] = STATE(39),
    [sym_declaration_command] = STATE(39),
    [sym_unset_command] = STATE(39),
    [sym_command] = STATE(39),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(40),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [146] = {
    [sym_concatenation] = STATE(436),
    [sym_string] = STATE(435),
    [sym_simple_expansion] = STATE(435),
    [sym_string_expansion] = STATE(435),
    [sym_expansion] = STATE(435),
    [sym_command_substitution] = STATE(435),
    [sym_process_substitution] = STATE(435),
    [sym__special_characters] = ACTIONS(797),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_DOLLAR] = ACTIONS(71),
    [sym_raw_string] = ACTIONS(799),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(75),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(77),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [anon_sym_LT_LPAREN] = ACTIONS(81),
    [anon_sym_GT_LPAREN] = ACTIONS(81),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(799),
  },
  [147] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(801),
  },
  [148] = {
    [sym__terminated_statement] = STATE(440),
    [sym_for_statement] = STATE(438),
    [sym_while_statement] = STATE(438),
    [sym_if_statement] = STATE(438),
    [sym_case_statement] = STATE(438),
    [sym_function_definition] = STATE(438),
    [sym_subshell] = STATE(438),
    [sym_pipeline] = STATE(438),
    [sym_list] = STATE(438),
    [sym_negated_command] = STATE(438),
    [sym_test_command] = STATE(438),
    [sym_declaration_command] = STATE(438),
    [sym_unset_command] = STATE(438),
    [sym_command] = STATE(438),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(439),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_program_repeat1] = STATE(440),
    [aux_sym_command_repeat1] = STATE(68),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_typeset] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_readonly] = ACTIONS(97),
    [anon_sym_local] = ACTIONS(97),
    [anon_sym_unset] = ACTIONS(99),
    [anon_sym_unsetenv] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(105),
  },
  [149] = {
    [sym_test_command] = STATE(441),
    [sym_command] = STATE(441),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(291),
  },
  [150] = {
    [sym__expression] = STATE(442),
    [sym_binary_expression] = STATE(442),
    [sym_unary_expression] = STATE(442),
    [sym_parenthesized_expression] = STATE(442),
    [sym_concatenation] = STATE(442),
    [sym_string] = STATE(77),
    [sym_simple_expansion] = STATE(77),
    [sym_string_expansion] = STATE(77),
    [sym_expansion] = STATE(77),
    [sym_command_substitution] = STATE(77),
    [sym_process_substitution] = STATE(77),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(111),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
    [sym_test_operator] = ACTIONS(131),
  },
  [151] = {
    [sym__expression] = STATE(443),
    [sym_binary_expression] = STATE(443),
    [sym_unary_expression] = STATE(443),
    [sym_parenthesized_expression] = STATE(443),
    [sym_concatenation] = STATE(443),
    [sym_string] = STATE(88),
    [sym_simple_expansion] = STATE(88),
    [sym_string_expansion] = STATE(88),
    [sym_expansion] = STATE(88),
    [sym_command_substitution] = STATE(88),
    [sym_process_substitution] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [152] = {
    [sym_variable_assignment] = STATE(455),
    [sym_subscript] = STATE(454),
    [sym_concatenation] = STATE(455),
    [sym_string] = STATE(448),
    [sym_simple_expansion] = STATE(448),
    [sym_string_expansion] = STATE(448),
    [sym_expansion] = STATE(448),
    [sym_command_substitution] = STATE(448),
    [sym_process_substitution] = STATE(448),
    [aux_sym_declaration_command_repeat1] = STATE(455),
    [sym_variable_name] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(159),
    [anon_sym_RPAREN] = ACTIONS(181),
    [anon_sym_PIPE_AMP] = ACTIONS(181),
    [anon_sym_AMP_AMP] = ACTIONS(181),
    [anon_sym_PIPE_PIPE] = ACTIONS(181),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(811),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(813),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(815),
    [anon_sym_BQUOTE] = ACTIONS(817),
    [anon_sym_LT_LPAREN] = ACTIONS(819),
    [anon_sym_GT_LPAREN] = ACTIONS(819),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(821),
    [sym_word] = ACTIONS(823),
  },
  [153] = {
    [sym_concatenation] = STATE(465),
    [sym_string] = STATE(459),
    [sym_simple_expansion] = STATE(459),
    [sym_string_expansion] = STATE(459),
    [sym_expansion] = STATE(459),
    [sym_command_substitution] = STATE(459),
    [sym_process_substitution] = STATE(459),
    [aux_sym_unset_command_repeat1] = STATE(465),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_RPAREN] = ACTIONS(203),
    [anon_sym_PIPE_AMP] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(833),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(835),
    [anon_sym_BQUOTE] = ACTIONS(837),
    [anon_sym_LT_LPAREN] = ACTIONS(839),
    [anon_sym_GT_LPAREN] = ACTIONS(839),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(841),
    [sym_word] = ACTIONS(843),
  },
  [154] = {
    [aux_sym_concatenation_repeat1] = STATE(467),
    [sym__simple_heredoc_body] = ACTIONS(221),
    [sym__heredoc_body_beginning] = ACTIONS(221),
    [sym_file_descriptor] = ACTIONS(221),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_RPAREN] = ACTIONS(221),
    [anon_sym_PIPE_AMP] = ACTIONS(221),
    [anon_sym_AMP_AMP] = ACTIONS(221),
    [anon_sym_PIPE_PIPE] = ACTIONS(221),
    [anon_sym_EQ_TILDE] = ACTIONS(225),
    [anon_sym_EQ_EQ] = ACTIONS(225),
    [anon_sym_LT] = ACTIONS(225),
    [anon_sym_GT] = ACTIONS(225),
    [anon_sym_GT_GT] = ACTIONS(221),
    [anon_sym_AMP_GT] = ACTIONS(225),
    [anon_sym_AMP_GT_GT] = ACTIONS(221),
    [anon_sym_LT_AMP] = ACTIONS(221),
    [anon_sym_GT_AMP] = ACTIONS(221),
    [anon_sym_LT_LT] = ACTIONS(225),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_LT] = ACTIONS(221),
    [sym__special_characters] = ACTIONS(221),
    [anon_sym_DQUOTE] = ACTIONS(221),
    [anon_sym_DOLLAR] = ACTIONS(225),
    [sym_raw_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(221),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(221),
    [anon_sym_GT_LPAREN] = ACTIONS(221),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(225),
  },
  [155] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(469),
    [anon_sym_DQUOTE] = ACTIONS(847),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [156] = {
    [sym_string] = STATE(471),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(849),
    [sym_raw_string] = ACTIONS(851),
    [anon_sym_POUND] = ACTIONS(849),
    [anon_sym_DASH] = ACTIONS(849),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(853),
    [anon_sym_STAR] = ACTIONS(849),
    [anon_sym_AT] = ACTIONS(849),
    [anon_sym_QMARK] = ACTIONS(849),
    [anon_sym_0] = ACTIONS(855),
    [anon_sym__] = ACTIONS(855),
  },
  [157] = {
    [aux_sym_concatenation_repeat1] = STATE(467),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(249),
  },
  [158] = {
    [sym_subscript] = STATE(477),
    [sym_variable_name] = ACTIONS(857),
    [anon_sym_DOLLAR] = ACTIONS(859),
    [anon_sym_POUND] = ACTIONS(861),
    [anon_sym_DASH] = ACTIONS(859),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(863),
    [anon_sym_STAR] = ACTIONS(859),
    [anon_sym_AT] = ACTIONS(859),
    [anon_sym_QMARK] = ACTIONS(859),
    [anon_sym_0] = ACTIONS(865),
    [anon_sym__] = ACTIONS(865),
  },
  [159] = {
    [sym_for_statement] = STATE(478),
    [sym_while_statement] = STATE(478),
    [sym_if_statement] = STATE(478),
    [sym_case_statement] = STATE(478),
    [sym_function_definition] = STATE(478),
    [sym_subshell] = STATE(478),
    [sym_pipeline] = STATE(478),
    [sym_list] = STATE(478),
    [sym_negated_command] = STATE(478),
    [sym_test_command] = STATE(478),
    [sym_declaration_command] = STATE(478),
    [sym_unset_command] = STATE(478),
    [sym_command] = STATE(478),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(479),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [160] = {
    [sym_for_statement] = STATE(480),
    [sym_while_statement] = STATE(480),
    [sym_if_statement] = STATE(480),
    [sym_case_statement] = STATE(480),
    [sym_function_definition] = STATE(480),
    [sym_subshell] = STATE(480),
    [sym_pipeline] = STATE(480),
    [sym_list] = STATE(480),
    [sym_negated_command] = STATE(480),
    [sym_test_command] = STATE(480),
    [sym_declaration_command] = STATE(480),
    [sym_unset_command] = STATE(480),
    [sym_command] = STATE(480),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(481),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [161] = {
    [sym_for_statement] = STATE(482),
    [sym_while_statement] = STATE(482),
    [sym_if_statement] = STATE(482),
    [sym_case_statement] = STATE(482),
    [sym_function_definition] = STATE(482),
    [sym_subshell] = STATE(482),
    [sym_pipeline] = STATE(482),
    [sym_list] = STATE(482),
    [sym_negated_command] = STATE(482),
    [sym_test_command] = STATE(482),
    [sym_declaration_command] = STATE(482),
    [sym_unset_command] = STATE(482),
    [sym_command] = STATE(482),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(483),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [162] = {
    [aux_sym_concatenation_repeat1] = STATE(467),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_LPAREN] = ACTIONS(867),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(249),
  },
  [163] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(871),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [164] = {
    [sym_file_redirect] = STATE(498),
    [sym_heredoc_redirect] = STATE(498),
    [sym_heredoc_body] = STATE(497),
    [sym_herestring_redirect] = STATE(498),
    [sym_concatenation] = STATE(499),
    [sym_string] = STATE(496),
    [sym_simple_expansion] = STATE(496),
    [sym_string_expansion] = STATE(496),
    [sym_expansion] = STATE(496),
    [sym_command_substitution] = STATE(496),
    [sym_process_substitution] = STATE(496),
    [aux_sym_while_statement_repeat1] = STATE(498),
    [aux_sym_command_repeat2] = STATE(499),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(881),
    [anon_sym_PIPE] = ACTIONS(343),
    [anon_sym_RPAREN] = ACTIONS(367),
    [anon_sym_PIPE_AMP] = ACTIONS(367),
    [anon_sym_AMP_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(367),
    [anon_sym_EQ_TILDE] = ACTIONS(883),
    [anon_sym_EQ_EQ] = ACTIONS(883),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(893),
    [sym__special_characters] = ACTIONS(895),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(897),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(899),
  },
  [165] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(871),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [166] = {
    [anon_sym_EQ] = ACTIONS(793),
    [anon_sym_PLUS_EQ] = ACTIONS(793),
    [sym_comment] = ACTIONS(53),
  },
  [167] = {
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_RPAREN] = ACTIONS(247),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(249),
  },
  [168] = {
    [sym_command_name] = STATE(500),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(205),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(901),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(291),
  },
  [169] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(903),
    [anon_sym_PLUS_EQ] = ACTIONS(903),
    [sym_comment] = ACTIONS(53),
  },
  [170] = {
    [sym__terminated_statement] = STATE(502),
    [sym_for_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_subshell] = STATE(39),
    [sym_pipeline] = STATE(39),
    [sym_list] = STATE(39),
    [sym_negated_command] = STATE(39),
    [sym_test_command] = STATE(39),
    [sym_declaration_command] = STATE(39),
    [sym_unset_command] = STATE(39),
    [sym_command] = STATE(39),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(40),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [171] = {
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(905),
  },
  [172] = {
    [sym_test_command] = STATE(441),
    [sym_command] = STATE(441),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(321),
  },
  [173] = {
    [sym__expression] = STATE(504),
    [sym_binary_expression] = STATE(504),
    [sym_unary_expression] = STATE(504),
    [sym_parenthesized_expression] = STATE(504),
    [sym_concatenation] = STATE(504),
    [sym_string] = STATE(77),
    [sym_simple_expansion] = STATE(77),
    [sym_string_expansion] = STATE(77),
    [sym_expansion] = STATE(77),
    [sym_command_substitution] = STATE(77),
    [sym_process_substitution] = STATE(77),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(111),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
    [sym_test_operator] = ACTIONS(131),
  },
  [174] = {
    [sym__expression] = STATE(505),
    [sym_binary_expression] = STATE(505),
    [sym_unary_expression] = STATE(505),
    [sym_parenthesized_expression] = STATE(505),
    [sym_concatenation] = STATE(505),
    [sym_string] = STATE(88),
    [sym_simple_expansion] = STATE(88),
    [sym_string_expansion] = STATE(88),
    [sym_expansion] = STATE(88),
    [sym_command_substitution] = STATE(88),
    [sym_process_substitution] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [175] = {
    [sym_variable_assignment] = STATE(510),
    [sym_subscript] = STATE(509),
    [sym_concatenation] = STATE(510),
    [sym_string] = STATE(508),
    [sym_simple_expansion] = STATE(508),
    [sym_string_expansion] = STATE(508),
    [sym_expansion] = STATE(508),
    [sym_command_substitution] = STATE(508),
    [sym_process_substitution] = STATE(508),
    [aux_sym_declaration_command_repeat1] = STATE(510),
    [sym_variable_name] = ACTIONS(907),
    [anon_sym_PIPE] = ACTIONS(159),
    [anon_sym_PIPE_AMP] = ACTIONS(181),
    [anon_sym_AMP_AMP] = ACTIONS(181),
    [anon_sym_PIPE_PIPE] = ACTIONS(181),
    [sym__special_characters] = ACTIONS(909),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(911),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(813),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(815),
    [anon_sym_BQUOTE] = ACTIONS(181),
    [anon_sym_LT_LPAREN] = ACTIONS(819),
    [anon_sym_GT_LPAREN] = ACTIONS(819),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(821),
    [sym_word] = ACTIONS(913),
  },
  [176] = {
    [sym_concatenation] = STATE(513),
    [sym_string] = STATE(512),
    [sym_simple_expansion] = STATE(512),
    [sym_string_expansion] = STATE(512),
    [sym_expansion] = STATE(512),
    [sym_command_substitution] = STATE(512),
    [sym_process_substitution] = STATE(512),
    [aux_sym_unset_command_repeat1] = STATE(513),
    [anon_sym_PIPE] = ACTIONS(183),
    [anon_sym_PIPE_AMP] = ACTIONS(203),
    [anon_sym_AMP_AMP] = ACTIONS(203),
    [anon_sym_PIPE_PIPE] = ACTIONS(203),
    [sym__special_characters] = ACTIONS(915),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(917),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(833),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(835),
    [anon_sym_BQUOTE] = ACTIONS(203),
    [anon_sym_LT_LPAREN] = ACTIONS(839),
    [anon_sym_GT_LPAREN] = ACTIONS(839),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(841),
    [sym_word] = ACTIONS(919),
  },
  [177] = {
    [aux_sym_concatenation_repeat1] = STATE(514),
    [sym__simple_heredoc_body] = ACTIONS(221),
    [sym__heredoc_body_beginning] = ACTIONS(221),
    [sym_file_descriptor] = ACTIONS(221),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(225),
    [anon_sym_PIPE_AMP] = ACTIONS(221),
    [anon_sym_AMP_AMP] = ACTIONS(221),
    [anon_sym_PIPE_PIPE] = ACTIONS(221),
    [anon_sym_EQ_TILDE] = ACTIONS(225),
    [anon_sym_EQ_EQ] = ACTIONS(225),
    [anon_sym_LT] = ACTIONS(225),
    [anon_sym_GT] = ACTIONS(225),
    [anon_sym_GT_GT] = ACTIONS(221),
    [anon_sym_AMP_GT] = ACTIONS(225),
    [anon_sym_AMP_GT_GT] = ACTIONS(221),
    [anon_sym_LT_AMP] = ACTIONS(221),
    [anon_sym_GT_AMP] = ACTIONS(221),
    [anon_sym_LT_LT] = ACTIONS(225),
    [anon_sym_LT_LT_DASH] = ACTIONS(221),
    [anon_sym_LT_LT_LT] = ACTIONS(221),
    [sym__special_characters] = ACTIONS(221),
    [anon_sym_DQUOTE] = ACTIONS(221),
    [anon_sym_DOLLAR] = ACTIONS(225),
    [sym_raw_string] = ACTIONS(221),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(221),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(221),
    [anon_sym_BQUOTE] = ACTIONS(221),
    [anon_sym_LT_LPAREN] = ACTIONS(221),
    [anon_sym_GT_LPAREN] = ACTIONS(221),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(225),
  },
  [178] = {
    [aux_sym_concatenation_repeat1] = STATE(514),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(249),
  },
  [179] = {
    [aux_sym_concatenation_repeat1] = STATE(514),
    [sym__simple_heredoc_body] = ACTIONS(247),
    [sym__heredoc_body_beginning] = ACTIONS(247),
    [sym_file_descriptor] = ACTIONS(247),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(249),
    [anon_sym_LPAREN] = ACTIONS(921),
    [anon_sym_PIPE_AMP] = ACTIONS(247),
    [anon_sym_AMP_AMP] = ACTIONS(247),
    [anon_sym_PIPE_PIPE] = ACTIONS(247),
    [anon_sym_EQ_TILDE] = ACTIONS(249),
    [anon_sym_EQ_EQ] = ACTIONS(249),
    [anon_sym_LT] = ACTIONS(249),
    [anon_sym_GT] = ACTIONS(249),
    [anon_sym_GT_GT] = ACTIONS(247),
    [anon_sym_AMP_GT] = ACTIONS(249),
    [anon_sym_AMP_GT_GT] = ACTIONS(247),
    [anon_sym_LT_AMP] = ACTIONS(247),
    [anon_sym_GT_AMP] = ACTIONS(247),
    [anon_sym_LT_LT] = ACTIONS(249),
    [anon_sym_LT_LT_DASH] = ACTIONS(247),
    [anon_sym_LT_LT_LT] = ACTIONS(247),
    [sym__special_characters] = ACTIONS(247),
    [anon_sym_DQUOTE] = ACTIONS(247),
    [anon_sym_DOLLAR] = ACTIONS(249),
    [sym_raw_string] = ACTIONS(247),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(247),
    [anon_sym_BQUOTE] = ACTIONS(247),
    [anon_sym_LT_LPAREN] = ACTIONS(247),
    [anon_sym_GT_LPAREN] = ACTIONS(247),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(249),
  },
  [180] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(871),
    [sym_comment] = ACTIONS(53),
  },
  [181] = {
    [sym_file_redirect] = STATE(524),
    [sym_heredoc_redirect] = STATE(524),
    [sym_heredoc_body] = STATE(497),
    [sym_herestring_redirect] = STATE(524),
    [sym_concatenation] = STATE(525),
    [sym_string] = STATE(523),
    [sym_simple_expansion] = STATE(523),
    [sym_string_expansion] = STATE(523),
    [sym_expansion] = STATE(523),
    [sym_command_substitution] = STATE(523),
    [sym_process_substitution] = STATE(523),
    [aux_sym_while_statement_repeat1] = STATE(524),
    [aux_sym_command_repeat2] = STATE(525),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(929),
    [anon_sym_PIPE] = ACTIONS(343),
    [anon_sym_PIPE_AMP] = ACTIONS(367),
    [anon_sym_AMP_AMP] = ACTIONS(367),
    [anon_sym_PIPE_PIPE] = ACTIONS(367),
    [anon_sym_EQ_TILDE] = ACTIONS(931),
    [anon_sym_EQ_EQ] = ACTIONS(931),
    [anon_sym_LT] = ACTIONS(933),
    [anon_sym_GT] = ACTIONS(933),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_AMP_GT] = ACTIONS(933),
    [anon_sym_AMP_GT_GT] = ACTIONS(935),
    [anon_sym_LT_AMP] = ACTIONS(935),
    [anon_sym_GT_AMP] = ACTIONS(935),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(937),
    [sym__special_characters] = ACTIONS(939),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(941),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(367),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(943),
  },
  [182] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(871),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [183] = {
    [anon_sym_EQ] = ACTIONS(903),
    [anon_sym_PLUS_EQ] = ACTIONS(903),
    [sym_comment] = ACTIONS(53),
  },
  [184] = {
    [sym_command_name] = STATE(526),
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(205),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(107),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(945),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(321),
  },
  [185] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(947),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [186] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(947),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [187] = {
    [anon_sym_RPAREN] = ACTIONS(949),
    [sym_comment] = ACTIONS(53),
  },
  [188] = {
    [sym_for_statement] = STATE(529),
    [sym_while_statement] = STATE(529),
    [sym_if_statement] = STATE(529),
    [sym_case_statement] = STATE(529),
    [sym_function_definition] = STATE(529),
    [sym_subshell] = STATE(529),
    [sym_pipeline] = STATE(529),
    [sym_list] = STATE(529),
    [sym_negated_command] = STATE(529),
    [sym_test_command] = STATE(529),
    [sym_declaration_command] = STATE(529),
    [sym_unset_command] = STATE(529),
    [sym_command] = STATE(529),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(530),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [189] = {
    [sym_file_descriptor] = ACTIONS(951),
    [sym_variable_name] = ACTIONS(951),
    [ts_builtin_sym_end] = ACTIONS(951),
    [anon_sym_for] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(953),
    [anon_sym_if] = ACTIONS(953),
    [anon_sym_case] = ACTIONS(953),
    [anon_sym_SEMI_SEMI] = ACTIONS(951),
    [anon_sym_function] = ACTIONS(953),
    [anon_sym_LPAREN] = ACTIONS(951),
    [anon_sym_BANG] = ACTIONS(953),
    [anon_sym_LBRACK] = ACTIONS(953),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(951),
    [anon_sym_declare] = ACTIONS(953),
    [anon_sym_typeset] = ACTIONS(953),
    [anon_sym_export] = ACTIONS(953),
    [anon_sym_readonly] = ACTIONS(953),
    [anon_sym_local] = ACTIONS(953),
    [anon_sym_unset] = ACTIONS(953),
    [anon_sym_unsetenv] = ACTIONS(953),
    [anon_sym_LT] = ACTIONS(953),
    [anon_sym_GT] = ACTIONS(953),
    [anon_sym_GT_GT] = ACTIONS(951),
    [anon_sym_AMP_GT] = ACTIONS(953),
    [anon_sym_AMP_GT_GT] = ACTIONS(951),
    [anon_sym_LT_AMP] = ACTIONS(951),
    [anon_sym_GT_AMP] = ACTIONS(951),
    [sym__special_characters] = ACTIONS(953),
    [anon_sym_DQUOTE] = ACTIONS(951),
    [anon_sym_DOLLAR] = ACTIONS(953),
    [sym_raw_string] = ACTIONS(951),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(951),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(951),
    [anon_sym_BQUOTE] = ACTIONS(951),
    [anon_sym_LT_LPAREN] = ACTIONS(951),
    [anon_sym_GT_LPAREN] = ACTIONS(951),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(953),
  },
  [190] = {
    [sym_for_statement] = STATE(531),
    [sym_while_statement] = STATE(531),
    [sym_if_statement] = STATE(531),
    [sym_case_statement] = STATE(531),
    [sym_function_definition] = STATE(531),
    [sym_subshell] = STATE(531),
    [sym_pipeline] = STATE(531),
    [sym_list] = STATE(531),
    [sym_negated_command] = STATE(531),
    [sym_test_command] = STATE(531),
    [sym_declaration_command] = STATE(531),
    [sym_unset_command] = STATE(531),
    [sym_command] = STATE(531),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(532),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [191] = {
    [anon_sym_esac] = ACTIONS(955),
    [anon_sym_PIPE] = ACTIONS(955),
    [anon_sym_RPAREN] = ACTIONS(955),
    [anon_sym_SEMI_SEMI] = ACTIONS(955),
    [anon_sym_PIPE_AMP] = ACTIONS(955),
    [anon_sym_AMP_AMP] = ACTIONS(955),
    [anon_sym_PIPE_PIPE] = ACTIONS(955),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(955),
    [anon_sym_LF] = ACTIONS(957),
    [anon_sym_AMP] = ACTIONS(955),
  },
  [192] = {
    [sym_simple_expansion] = STATE(536),
    [sym_expansion] = STATE(536),
    [aux_sym_heredoc_body_repeat1] = STATE(536),
    [sym__heredoc_body_middle] = ACTIONS(959),
    [sym__heredoc_body_end] = ACTIONS(961),
    [anon_sym_DOLLAR] = ACTIONS(963),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(965),
    [sym_comment] = ACTIONS(53),
  },
  [193] = {
    [anon_sym_LT] = ACTIONS(967),
    [anon_sym_GT] = ACTIONS(967),
    [anon_sym_GT_GT] = ACTIONS(969),
    [anon_sym_AMP_GT] = ACTIONS(967),
    [anon_sym_AMP_GT_GT] = ACTIONS(969),
    [anon_sym_LT_AMP] = ACTIONS(969),
    [anon_sym_GT_AMP] = ACTIONS(969),
    [sym_comment] = ACTIONS(53),
  },
  [194] = {
    [sym_concatenation] = STATE(540),
    [sym_string] = STATE(539),
    [sym_simple_expansion] = STATE(539),
    [sym_string_expansion] = STATE(539),
    [sym_expansion] = STATE(539),
    [sym_command_substitution] = STATE(539),
    [sym_process_substitution] = STATE(539),
    [sym__special_characters] = ACTIONS(971),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(973),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(973),
    [sym_regex] = ACTIONS(975),
  },
  [195] = {
    [sym_concatenation] = STATE(543),
    [sym_string] = STATE(542),
    [sym_simple_expansion] = STATE(542),
    [sym_string_expansion] = STATE(542),
    [sym_expansion] = STATE(542),
    [sym_command_substitution] = STATE(542),
    [sym_process_substitution] = STATE(542),
    [sym__special_characters] = ACTIONS(977),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(979),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(979),
  },
  [196] = {
    [sym_heredoc_start] = ACTIONS(981),
    [sym_comment] = ACTIONS(53),
  },
  [197] = {
    [sym_concatenation] = STATE(547),
    [sym_string] = STATE(546),
    [sym_simple_expansion] = STATE(546),
    [sym_string_expansion] = STATE(546),
    [sym_expansion] = STATE(546),
    [sym_command_substitution] = STATE(546),
    [sym_process_substitution] = STATE(546),
    [sym__special_characters] = ACTIONS(983),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(985),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(985),
  },
  [198] = {
    [aux_sym_concatenation_repeat1] = STATE(126),
    [sym__simple_heredoc_body] = ACTIONS(987),
    [sym__heredoc_body_beginning] = ACTIONS(987),
    [sym_file_descriptor] = ACTIONS(987),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(989),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(989),
    [anon_sym_EQ_EQ] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(989),
    [anon_sym_GT] = ACTIONS(989),
    [anon_sym_GT_GT] = ACTIONS(989),
    [anon_sym_AMP_GT] = ACTIONS(989),
    [anon_sym_AMP_GT_GT] = ACTIONS(989),
    [anon_sym_LT_AMP] = ACTIONS(989),
    [anon_sym_GT_AMP] = ACTIONS(989),
    [anon_sym_LT_LT] = ACTIONS(989),
    [anon_sym_LT_LT_DASH] = ACTIONS(989),
    [anon_sym_LT_LT_LT] = ACTIONS(989),
    [sym__special_characters] = ACTIONS(989),
    [anon_sym_DQUOTE] = ACTIONS(989),
    [anon_sym_DOLLAR] = ACTIONS(989),
    [sym_raw_string] = ACTIONS(989),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(989),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(989),
    [anon_sym_BQUOTE] = ACTIONS(989),
    [anon_sym_LT_LPAREN] = ACTIONS(989),
    [anon_sym_GT_LPAREN] = ACTIONS(989),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(989),
    [anon_sym_SEMI] = ACTIONS(989),
    [anon_sym_LF] = ACTIONS(987),
    [anon_sym_AMP] = ACTIONS(989),
  },
  [199] = {
    [aux_sym_concatenation_repeat1] = STATE(126),
    [sym__simple_heredoc_body] = ACTIONS(991),
    [sym__heredoc_body_beginning] = ACTIONS(991),
    [sym_file_descriptor] = ACTIONS(991),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(993),
    [anon_sym_SEMI_SEMI] = ACTIONS(993),
    [anon_sym_PIPE_AMP] = ACTIONS(993),
    [anon_sym_AMP_AMP] = ACTIONS(993),
    [anon_sym_PIPE_PIPE] = ACTIONS(993),
    [anon_sym_EQ_TILDE] = ACTIONS(993),
    [anon_sym_EQ_EQ] = ACTIONS(993),
    [anon_sym_LT] = ACTIONS(993),
    [anon_sym_GT] = ACTIONS(993),
    [anon_sym_GT_GT] = ACTIONS(993),
    [anon_sym_AMP_GT] = ACTIONS(993),
    [anon_sym_AMP_GT_GT] = ACTIONS(993),
    [anon_sym_LT_AMP] = ACTIONS(993),
    [anon_sym_GT_AMP] = ACTIONS(993),
    [anon_sym_LT_LT] = ACTIONS(993),
    [anon_sym_LT_LT_DASH] = ACTIONS(993),
    [anon_sym_LT_LT_LT] = ACTIONS(993),
    [sym__special_characters] = ACTIONS(993),
    [anon_sym_DQUOTE] = ACTIONS(993),
    [anon_sym_DOLLAR] = ACTIONS(993),
    [sym_raw_string] = ACTIONS(993),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(993),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(993),
    [anon_sym_BQUOTE] = ACTIONS(993),
    [anon_sym_LT_LPAREN] = ACTIONS(993),
    [anon_sym_GT_LPAREN] = ACTIONS(993),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(993),
    [anon_sym_SEMI] = ACTIONS(993),
    [anon_sym_LF] = ACTIONS(991),
    [anon_sym_AMP] = ACTIONS(993),
  },
  [200] = {
    [anon_sym_esac] = ACTIONS(995),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(995),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(995),
    [anon_sym_AMP_AMP] = ACTIONS(995),
    [anon_sym_PIPE_PIPE] = ACTIONS(995),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(995),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(995),
  },
  [201] = {
    [sym_file_redirect] = STATE(549),
    [sym_heredoc_redirect] = STATE(549),
    [sym_heredoc_body] = STATE(548),
    [sym_herestring_redirect] = STATE(549),
    [aux_sym_while_statement_repeat1] = STATE(549),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(995),
    [anon_sym_AMP_AMP] = ACTIONS(995),
    [anon_sym_PIPE_PIPE] = ACTIONS(995),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(995),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(995),
  },
  [202] = {
    [sym_file_redirect] = STATE(550),
    [sym_heredoc_redirect] = STATE(550),
    [sym_heredoc_body] = STATE(548),
    [sym_herestring_redirect] = STATE(550),
    [sym_concatenation] = STATE(551),
    [sym_string] = STATE(199),
    [sym_simple_expansion] = STATE(199),
    [sym_string_expansion] = STATE(199),
    [sym_expansion] = STATE(199),
    [sym_command_substitution] = STATE(199),
    [sym_process_substitution] = STATE(199),
    [aux_sym_while_statement_repeat1] = STATE(550),
    [aux_sym_command_repeat2] = STATE(551),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(995),
    [anon_sym_AMP_AMP] = ACTIONS(995),
    [anon_sym_PIPE_PIPE] = ACTIONS(995),
    [anon_sym_EQ_TILDE] = ACTIONS(345),
    [anon_sym_EQ_EQ] = ACTIONS(345),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym__special_characters] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(357),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(995),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(995),
  },
  [203] = {
    [sym__terminated_statement] = STATE(203),
    [sym_for_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym_subshell] = STATE(26),
    [sym_pipeline] = STATE(26),
    [sym_list] = STATE(26),
    [sym_negated_command] = STATE(26),
    [sym_test_command] = STATE(26),
    [sym_declaration_command] = STATE(26),
    [sym_unset_command] = STATE(26),
    [sym_command] = STATE(26),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(28),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(203),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(999),
    [sym_variable_name] = ACTIONS(1002),
    [ts_builtin_sym_end] = ACTIONS(1005),
    [anon_sym_for] = ACTIONS(1007),
    [anon_sym_while] = ACTIONS(1010),
    [anon_sym_if] = ACTIONS(1013),
    [anon_sym_case] = ACTIONS(1016),
    [anon_sym_function] = ACTIONS(1019),
    [anon_sym_LPAREN] = ACTIONS(1022),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_LBRACK] = ACTIONS(1028),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1031),
    [anon_sym_declare] = ACTIONS(1034),
    [anon_sym_typeset] = ACTIONS(1034),
    [anon_sym_export] = ACTIONS(1034),
    [anon_sym_readonly] = ACTIONS(1034),
    [anon_sym_local] = ACTIONS(1034),
    [anon_sym_unset] = ACTIONS(1037),
    [anon_sym_unsetenv] = ACTIONS(1037),
    [anon_sym_LT] = ACTIONS(1040),
    [anon_sym_GT] = ACTIONS(1040),
    [anon_sym_GT_GT] = ACTIONS(1043),
    [anon_sym_AMP_GT] = ACTIONS(1040),
    [anon_sym_AMP_GT_GT] = ACTIONS(1043),
    [anon_sym_LT_AMP] = ACTIONS(1043),
    [anon_sym_GT_AMP] = ACTIONS(1043),
    [sym__special_characters] = ACTIONS(1046),
    [anon_sym_DQUOTE] = ACTIONS(1049),
    [anon_sym_DOLLAR] = ACTIONS(1052),
    [sym_raw_string] = ACTIONS(1055),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1058),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1061),
    [anon_sym_BQUOTE] = ACTIONS(1064),
    [anon_sym_LT_LPAREN] = ACTIONS(1067),
    [anon_sym_GT_LPAREN] = ACTIONS(1067),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1070),
  },
  [204] = {
    [sym_file_redirect] = STATE(550),
    [sym_heredoc_redirect] = STATE(550),
    [sym_heredoc_body] = STATE(548),
    [sym_herestring_redirect] = STATE(550),
    [sym_concatenation] = STATE(552),
    [sym_string] = STATE(199),
    [sym_simple_expansion] = STATE(199),
    [sym_string_expansion] = STATE(199),
    [sym_expansion] = STATE(199),
    [sym_command_substitution] = STATE(199),
    [sym_process_substitution] = STATE(199),
    [aux_sym_while_statement_repeat1] = STATE(550),
    [aux_sym_command_repeat2] = STATE(552),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(995),
    [anon_sym_AMP_AMP] = ACTIONS(995),
    [anon_sym_PIPE_PIPE] = ACTIONS(995),
    [anon_sym_EQ_TILDE] = ACTIONS(345),
    [anon_sym_EQ_EQ] = ACTIONS(345),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym__special_characters] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(357),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(995),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(995),
  },
  [205] = {
    [sym_variable_assignment] = STATE(30),
    [sym_subscript] = STATE(71),
    [sym_file_redirect] = STATE(30),
    [aux_sym_command_repeat1] = STATE(205),
    [sym_file_descriptor] = ACTIONS(1073),
    [sym_variable_name] = ACTIONS(1076),
    [anon_sym_LT] = ACTIONS(1079),
    [anon_sym_GT] = ACTIONS(1079),
    [anon_sym_GT_GT] = ACTIONS(1082),
    [anon_sym_AMP_GT] = ACTIONS(1079),
    [anon_sym_AMP_GT_GT] = ACTIONS(1082),
    [anon_sym_LT_AMP] = ACTIONS(1082),
    [anon_sym_GT_AMP] = ACTIONS(1082),
    [sym__special_characters] = ACTIONS(1085),
    [anon_sym_DQUOTE] = ACTIONS(1085),
    [anon_sym_DOLLAR] = ACTIONS(1087),
    [sym_raw_string] = ACTIONS(1085),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1085),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1085),
    [anon_sym_BQUOTE] = ACTIONS(1085),
    [anon_sym_LT_LPAREN] = ACTIONS(1085),
    [anon_sym_GT_LPAREN] = ACTIONS(1085),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1085),
  },
  [206] = {
    [aux_sym_concatenation_repeat1] = STATE(373),
    [sym_file_descriptor] = ACTIONS(1089),
    [sym__concat] = ACTIONS(663),
    [sym_variable_name] = ACTIONS(1089),
    [anon_sym_LT] = ACTIONS(1091),
    [anon_sym_GT] = ACTIONS(1091),
    [anon_sym_GT_GT] = ACTIONS(1089),
    [anon_sym_AMP_GT] = ACTIONS(1091),
    [anon_sym_AMP_GT_GT] = ACTIONS(1089),
    [anon_sym_LT_AMP] = ACTIONS(1089),
    [anon_sym_GT_AMP] = ACTIONS(1089),
    [sym__special_characters] = ACTIONS(1089),
    [anon_sym_DQUOTE] = ACTIONS(1089),
    [anon_sym_DOLLAR] = ACTIONS(1091),
    [sym_raw_string] = ACTIONS(1089),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1089),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1089),
    [anon_sym_BQUOTE] = ACTIONS(1089),
    [anon_sym_LT_LPAREN] = ACTIONS(1089),
    [anon_sym_GT_LPAREN] = ACTIONS(1089),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1089),
  },
  [207] = {
    [aux_sym_concatenation_repeat1] = STATE(373),
    [sym_file_descriptor] = ACTIONS(1093),
    [sym__concat] = ACTIONS(663),
    [sym_variable_name] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1095),
    [anon_sym_GT] = ACTIONS(1095),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [anon_sym_AMP_GT] = ACTIONS(1095),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [sym__special_characters] = ACTIONS(1093),
    [anon_sym_DQUOTE] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(1095),
    [sym_raw_string] = ACTIONS(1093),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1093),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1093),
    [anon_sym_BQUOTE] = ACTIONS(1093),
    [anon_sym_LT_LPAREN] = ACTIONS(1093),
    [anon_sym_GT_LPAREN] = ACTIONS(1093),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1093),
  },
  [208] = {
    [sym_file_descriptor] = ACTIONS(1093),
    [sym_variable_name] = ACTIONS(1093),
    [anon_sym_LT] = ACTIONS(1095),
    [anon_sym_GT] = ACTIONS(1095),
    [anon_sym_GT_GT] = ACTIONS(1093),
    [anon_sym_AMP_GT] = ACTIONS(1095),
    [anon_sym_AMP_GT_GT] = ACTIONS(1093),
    [anon_sym_LT_AMP] = ACTIONS(1093),
    [anon_sym_GT_AMP] = ACTIONS(1093),
    [sym__special_characters] = ACTIONS(1093),
    [anon_sym_DQUOTE] = ACTIONS(1093),
    [anon_sym_DOLLAR] = ACTIONS(1095),
    [sym_raw_string] = ACTIONS(1093),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1093),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1093),
    [anon_sym_BQUOTE] = ACTIONS(1093),
    [anon_sym_LT_LPAREN] = ACTIONS(1093),
    [anon_sym_GT_LPAREN] = ACTIONS(1093),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1093),
  },
  [209] = {
    [aux_sym_concatenation_repeat1] = STATE(555),
    [sym__concat] = ACTIONS(1097),
    [anon_sym_RBRACK] = ACTIONS(1099),
    [sym_comment] = ACTIONS(53),
  },
  [210] = {
    [aux_sym_concatenation_repeat1] = STATE(555),
    [sym__concat] = ACTIONS(1101),
    [anon_sym_RBRACK] = ACTIONS(1103),
    [sym_comment] = ACTIONS(53),
  },
  [211] = {
    [sym__concat] = ACTIONS(1105),
    [anon_sym_RBRACK] = ACTIONS(1103),
    [sym_comment] = ACTIONS(53),
  },
  [212] = {
    [sym_file_descriptor] = ACTIONS(1107),
    [sym_variable_name] = ACTIONS(1107),
    [anon_sym_PIPE] = ACTIONS(1109),
    [anon_sym_RPAREN] = ACTIONS(1109),
    [anon_sym_SEMI_SEMI] = ACTIONS(1109),
    [anon_sym_PIPE_AMP] = ACTIONS(1109),
    [anon_sym_AMP_AMP] = ACTIONS(1109),
    [anon_sym_PIPE_PIPE] = ACTIONS(1109),
    [anon_sym_LT] = ACTIONS(1109),
    [anon_sym_GT] = ACTIONS(1109),
    [anon_sym_GT_GT] = ACTIONS(1109),
    [anon_sym_AMP_GT] = ACTIONS(1109),
    [anon_sym_AMP_GT_GT] = ACTIONS(1109),
    [anon_sym_LT_AMP] = ACTIONS(1109),
    [anon_sym_GT_AMP] = ACTIONS(1109),
    [sym__special_characters] = ACTIONS(1109),
    [anon_sym_DQUOTE] = ACTIONS(1109),
    [anon_sym_DOLLAR] = ACTIONS(1109),
    [sym_raw_string] = ACTIONS(1109),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1109),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1109),
    [anon_sym_BQUOTE] = ACTIONS(1109),
    [anon_sym_LT_LPAREN] = ACTIONS(1109),
    [anon_sym_GT_LPAREN] = ACTIONS(1109),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1109),
    [anon_sym_SEMI] = ACTIONS(1109),
    [anon_sym_LF] = ACTIONS(1107),
    [anon_sym_AMP] = ACTIONS(1109),
  },
  [213] = {
    [sym_concatenation] = STATE(568),
    [sym_string] = STATE(563),
    [sym_simple_expansion] = STATE(563),
    [sym_string_expansion] = STATE(563),
    [sym_expansion] = STATE(563),
    [sym_command_substitution] = STATE(563),
    [sym_process_substitution] = STATE(563),
    [aux_sym_for_statement_repeat1] = STATE(568),
    [anon_sym_RPAREN] = ACTIONS(1111),
    [sym__special_characters] = ACTIONS(1113),
    [anon_sym_DQUOTE] = ACTIONS(1115),
    [anon_sym_DOLLAR] = ACTIONS(1117),
    [sym_raw_string] = ACTIONS(1119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1123),
    [anon_sym_BQUOTE] = ACTIONS(1125),
    [anon_sym_LT_LPAREN] = ACTIONS(1127),
    [anon_sym_GT_LPAREN] = ACTIONS(1127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1119),
  },
  [214] = {
    [aux_sym_concatenation_repeat1] = STATE(570),
    [sym_file_descriptor] = ACTIONS(1129),
    [sym__concat] = ACTIONS(1131),
    [sym_variable_name] = ACTIONS(1129),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_SEMI_SEMI] = ACTIONS(1133),
    [anon_sym_PIPE_AMP] = ACTIONS(1133),
    [anon_sym_AMP_AMP] = ACTIONS(1133),
    [anon_sym_PIPE_PIPE] = ACTIONS(1133),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_GT] = ACTIONS(1133),
    [anon_sym_GT_GT] = ACTIONS(1133),
    [anon_sym_AMP_GT] = ACTIONS(1133),
    [anon_sym_AMP_GT_GT] = ACTIONS(1133),
    [anon_sym_LT_AMP] = ACTIONS(1133),
    [anon_sym_GT_AMP] = ACTIONS(1133),
    [sym__special_characters] = ACTIONS(1133),
    [anon_sym_DQUOTE] = ACTIONS(1133),
    [anon_sym_DOLLAR] = ACTIONS(1133),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1133),
    [anon_sym_BQUOTE] = ACTIONS(1133),
    [anon_sym_LT_LPAREN] = ACTIONS(1133),
    [anon_sym_GT_LPAREN] = ACTIONS(1133),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1133),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym_LF] = ACTIONS(1129),
    [anon_sym_AMP] = ACTIONS(1133),
  },
  [215] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(572),
    [anon_sym_DQUOTE] = ACTIONS(1135),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [216] = {
    [sym_string] = STATE(574),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(1137),
    [sym_raw_string] = ACTIONS(1139),
    [anon_sym_POUND] = ACTIONS(1137),
    [anon_sym_DASH] = ACTIONS(1137),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1141),
    [anon_sym_STAR] = ACTIONS(1137),
    [anon_sym_AT] = ACTIONS(1137),
    [anon_sym_QMARK] = ACTIONS(1137),
    [anon_sym_0] = ACTIONS(1143),
    [anon_sym__] = ACTIONS(1143),
  },
  [217] = {
    [aux_sym_concatenation_repeat1] = STATE(570),
    [sym_file_descriptor] = ACTIONS(1107),
    [sym__concat] = ACTIONS(1131),
    [sym_variable_name] = ACTIONS(1107),
    [anon_sym_PIPE] = ACTIONS(1109),
    [anon_sym_SEMI_SEMI] = ACTIONS(1109),
    [anon_sym_PIPE_AMP] = ACTIONS(1109),
    [anon_sym_AMP_AMP] = ACTIONS(1109),
    [anon_sym_PIPE_PIPE] = ACTIONS(1109),
    [anon_sym_LT] = ACTIONS(1109),
    [anon_sym_GT] = ACTIONS(1109),
    [anon_sym_GT_GT] = ACTIONS(1109),
    [anon_sym_AMP_GT] = ACTIONS(1109),
    [anon_sym_AMP_GT_GT] = ACTIONS(1109),
    [anon_sym_LT_AMP] = ACTIONS(1109),
    [anon_sym_GT_AMP] = ACTIONS(1109),
    [sym__special_characters] = ACTIONS(1109),
    [anon_sym_DQUOTE] = ACTIONS(1109),
    [anon_sym_DOLLAR] = ACTIONS(1109),
    [sym_raw_string] = ACTIONS(1109),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1109),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1109),
    [anon_sym_BQUOTE] = ACTIONS(1109),
    [anon_sym_LT_LPAREN] = ACTIONS(1109),
    [anon_sym_GT_LPAREN] = ACTIONS(1109),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1109),
    [anon_sym_SEMI] = ACTIONS(1109),
    [anon_sym_LF] = ACTIONS(1107),
    [anon_sym_AMP] = ACTIONS(1109),
  },
  [218] = {
    [sym_subscript] = STATE(580),
    [sym_variable_name] = ACTIONS(1145),
    [anon_sym_DOLLAR] = ACTIONS(1147),
    [anon_sym_POUND] = ACTIONS(1149),
    [anon_sym_DASH] = ACTIONS(1147),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1151),
    [anon_sym_STAR] = ACTIONS(1147),
    [anon_sym_AT] = ACTIONS(1147),
    [anon_sym_QMARK] = ACTIONS(1147),
    [anon_sym_0] = ACTIONS(1153),
    [anon_sym__] = ACTIONS(1153),
  },
  [219] = {
    [sym_for_statement] = STATE(581),
    [sym_while_statement] = STATE(581),
    [sym_if_statement] = STATE(581),
    [sym_case_statement] = STATE(581),
    [sym_function_definition] = STATE(581),
    [sym_subshell] = STATE(581),
    [sym_pipeline] = STATE(581),
    [sym_list] = STATE(581),
    [sym_negated_command] = STATE(581),
    [sym_test_command] = STATE(581),
    [sym_declaration_command] = STATE(581),
    [sym_unset_command] = STATE(581),
    [sym_command] = STATE(581),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(582),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [220] = {
    [sym_for_statement] = STATE(583),
    [sym_while_statement] = STATE(583),
    [sym_if_statement] = STATE(583),
    [sym_case_statement] = STATE(583),
    [sym_function_definition] = STATE(583),
    [sym_subshell] = STATE(583),
    [sym_pipeline] = STATE(583),
    [sym_list] = STATE(583),
    [sym_negated_command] = STATE(583),
    [sym_test_command] = STATE(583),
    [sym_declaration_command] = STATE(583),
    [sym_unset_command] = STATE(583),
    [sym_command] = STATE(583),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(584),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [221] = {
    [sym_for_statement] = STATE(585),
    [sym_while_statement] = STATE(585),
    [sym_if_statement] = STATE(585),
    [sym_case_statement] = STATE(585),
    [sym_function_definition] = STATE(585),
    [sym_subshell] = STATE(585),
    [sym_pipeline] = STATE(585),
    [sym_list] = STATE(585),
    [sym_negated_command] = STATE(585),
    [sym_test_command] = STATE(585),
    [sym_declaration_command] = STATE(585),
    [sym_unset_command] = STATE(585),
    [sym_command] = STATE(585),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(586),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [222] = {
    [sym_concatenation] = STATE(595),
    [sym_string] = STATE(590),
    [sym_simple_expansion] = STATE(590),
    [sym_string_expansion] = STATE(590),
    [sym_expansion] = STATE(590),
    [sym_command_substitution] = STATE(590),
    [sym_process_substitution] = STATE(590),
    [aux_sym_for_statement_repeat1] = STATE(595),
    [sym__special_characters] = ACTIONS(1155),
    [anon_sym_DQUOTE] = ACTIONS(1157),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(1161),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1163),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1165),
    [anon_sym_BQUOTE] = ACTIONS(1167),
    [anon_sym_LT_LPAREN] = ACTIONS(1169),
    [anon_sym_GT_LPAREN] = ACTIONS(1169),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1161),
  },
  [223] = {
    [sym_do_group] = STATE(597),
    [anon_sym_do] = ACTIONS(1171),
    [sym_comment] = ACTIONS(53),
  },
  [224] = {
    [sym__terminated_statement] = STATE(601),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_case_statement] = STATE(599),
    [sym_function_definition] = STATE(599),
    [sym_subshell] = STATE(599),
    [sym_pipeline] = STATE(599),
    [sym_list] = STATE(599),
    [sym_negated_command] = STATE(599),
    [sym_test_command] = STATE(599),
    [sym_declaration_command] = STATE(599),
    [sym_unset_command] = STATE(599),
    [sym_command] = STATE(599),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(600),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(601),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_done] = ACTIONS(1173),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [225] = {
    [sym_file_redirect] = STATE(603),
    [sym_heredoc_redirect] = STATE(603),
    [sym_heredoc_body] = STATE(602),
    [sym_herestring_redirect] = STATE(603),
    [aux_sym_while_statement_repeat1] = STATE(603),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(1175),
    [anon_sym_SEMI_SEMI] = ACTIONS(1175),
    [anon_sym_PIPE_AMP] = ACTIONS(1175),
    [anon_sym_AMP_AMP] = ACTIONS(1175),
    [anon_sym_PIPE_PIPE] = ACTIONS(1175),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1175),
    [anon_sym_LF] = ACTIONS(1177),
    [anon_sym_AMP] = ACTIONS(1175),
  },
  [226] = {
    [anon_sym_do] = ACTIONS(951),
    [anon_sym_then] = ACTIONS(951),
    [sym_comment] = ACTIONS(53),
  },
  [227] = {
    [sym__terminated_statement] = STATE(611),
    [sym_for_statement] = STATE(607),
    [sym_while_statement] = STATE(607),
    [sym_if_statement] = STATE(607),
    [sym_elif_clause] = STATE(608),
    [sym_else_clause] = STATE(609),
    [sym_case_statement] = STATE(607),
    [sym_function_definition] = STATE(607),
    [sym_subshell] = STATE(607),
    [sym_pipeline] = STATE(607),
    [sym_list] = STATE(607),
    [sym_negated_command] = STATE(607),
    [sym_test_command] = STATE(607),
    [sym_declaration_command] = STATE(607),
    [sym_unset_command] = STATE(607),
    [sym_command] = STATE(607),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(610),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(611),
    [aux_sym_if_statement_repeat1] = STATE(612),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_fi] = ACTIONS(1179),
    [anon_sym_elif] = ACTIONS(1181),
    [anon_sym_else] = ACTIONS(1183),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [228] = {
    [sym_string] = STATE(613),
    [sym_simple_expansion] = STATE(613),
    [sym_string_expansion] = STATE(613),
    [sym_expansion] = STATE(613),
    [sym_command_substitution] = STATE(613),
    [sym_process_substitution] = STATE(613),
    [sym__special_characters] = ACTIONS(1185),
    [anon_sym_DQUOTE] = ACTIONS(69),
    [anon_sym_DOLLAR] = ACTIONS(71),
    [sym_raw_string] = ACTIONS(1185),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(75),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(77),
    [anon_sym_BQUOTE] = ACTIONS(79),
    [anon_sym_LT_LPAREN] = ACTIONS(81),
    [anon_sym_GT_LPAREN] = ACTIONS(81),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1185),
  },
  [229] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(1187),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1187),
    [anon_sym_LF] = ACTIONS(1189),
    [anon_sym_AMP] = ACTIONS(1187),
  },
  [230] = {
    [anon_sym_in] = ACTIONS(1191),
    [sym_comment] = ACTIONS(53),
  },
  [231] = {
    [aux_sym_concatenation_repeat1] = STATE(616),
    [sym__concat] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [232] = {
    [sym__concat] = ACTIONS(697),
    [anon_sym_in] = ACTIONS(699),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_LF] = ACTIONS(697),
    [anon_sym_AMP] = ACTIONS(699),
  },
  [233] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1193),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [234] = {
    [sym__concat] = ACTIONS(727),
    [anon_sym_in] = ACTIONS(729),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(729),
    [anon_sym_LF] = ACTIONS(727),
    [anon_sym_AMP] = ACTIONS(729),
  },
  [235] = {
    [sym__concat] = ACTIONS(731),
    [anon_sym_in] = ACTIONS(733),
    [anon_sym_SEMI_SEMI] = ACTIONS(733),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(733),
    [anon_sym_LF] = ACTIONS(731),
    [anon_sym_AMP] = ACTIONS(733),
  },
  [236] = {
    [sym__concat] = ACTIONS(735),
    [anon_sym_in] = ACTIONS(737),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(737),
    [anon_sym_LF] = ACTIONS(735),
    [anon_sym_AMP] = ACTIONS(737),
  },
  [237] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(1195),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1195),
    [anon_sym_LF] = ACTIONS(1197),
    [anon_sym_AMP] = ACTIONS(1195),
  },
  [238] = {
    [anon_sym_in] = ACTIONS(1199),
    [sym_comment] = ACTIONS(53),
  },
  [239] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1201),
    [sym_comment] = ACTIONS(53),
  },
  [240] = {
    [sym_concatenation] = STATE(623),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(623),
    [anon_sym_RBRACE] = ACTIONS(1203),
    [anon_sym_EQ] = ACTIONS(1205),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1207),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1209),
    [anon_sym_COLON] = ACTIONS(1205),
    [anon_sym_COLON_QMARK] = ACTIONS(1205),
    [anon_sym_COLON_DASH] = ACTIONS(1205),
    [anon_sym_PERCENT] = ACTIONS(1205),
    [anon_sym_DASH] = ACTIONS(1205),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [241] = {
    [sym_subscript] = STATE(627),
    [sym_variable_name] = ACTIONS(1211),
    [anon_sym_DOLLAR] = ACTIONS(1213),
    [anon_sym_DASH] = ACTIONS(1213),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1215),
    [anon_sym_STAR] = ACTIONS(1213),
    [anon_sym_AT] = ACTIONS(1213),
    [anon_sym_QMARK] = ACTIONS(1213),
    [anon_sym_0] = ACTIONS(1217),
    [anon_sym__] = ACTIONS(1217),
  },
  [242] = {
    [sym_concatenation] = STATE(630),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(630),
    [anon_sym_RBRACE] = ACTIONS(1219),
    [anon_sym_EQ] = ACTIONS(1221),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1223),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1225),
    [anon_sym_COLON] = ACTIONS(1221),
    [anon_sym_COLON_QMARK] = ACTIONS(1221),
    [anon_sym_COLON_DASH] = ACTIONS(1221),
    [anon_sym_PERCENT] = ACTIONS(1221),
    [anon_sym_DASH] = ACTIONS(1221),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [243] = {
    [sym_concatenation] = STATE(633),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(633),
    [anon_sym_RBRACE] = ACTIONS(1227),
    [anon_sym_EQ] = ACTIONS(1229),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1233),
    [anon_sym_COLON] = ACTIONS(1229),
    [anon_sym_COLON_QMARK] = ACTIONS(1229),
    [anon_sym_COLON_DASH] = ACTIONS(1229),
    [anon_sym_PERCENT] = ACTIONS(1229),
    [anon_sym_DASH] = ACTIONS(1229),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [244] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1235),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [245] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1235),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [246] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1235),
    [sym_comment] = ACTIONS(53),
  },
  [247] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1235),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [248] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1237),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [249] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1237),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [250] = {
    [anon_sym_RPAREN] = ACTIONS(1239),
    [sym_comment] = ACTIONS(53),
  },
  [251] = {
    [sym__terminated_statement] = STATE(640),
    [sym_for_statement] = STATE(638),
    [sym_while_statement] = STATE(638),
    [sym_if_statement] = STATE(638),
    [sym_case_statement] = STATE(638),
    [sym_function_definition] = STATE(638),
    [sym_subshell] = STATE(638),
    [sym_pipeline] = STATE(638),
    [sym_list] = STATE(638),
    [sym_negated_command] = STATE(638),
    [sym_test_command] = STATE(638),
    [sym_declaration_command] = STATE(638),
    [sym_unset_command] = STATE(638),
    [sym_command] = STATE(638),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(639),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(640),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(1241),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [252] = {
    [sym_file_redirect] = STATE(643),
    [sym_file_descriptor] = ACTIONS(1243),
    [anon_sym_PIPE] = ACTIONS(1245),
    [anon_sym_SEMI_SEMI] = ACTIONS(1245),
    [anon_sym_PIPE_AMP] = ACTIONS(1245),
    [anon_sym_AMP_AMP] = ACTIONS(1245),
    [anon_sym_PIPE_PIPE] = ACTIONS(1245),
    [anon_sym_LT] = ACTIONS(1247),
    [anon_sym_GT] = ACTIONS(1247),
    [anon_sym_GT_GT] = ACTIONS(1247),
    [anon_sym_AMP_GT] = ACTIONS(1247),
    [anon_sym_AMP_GT_GT] = ACTIONS(1247),
    [anon_sym_LT_AMP] = ACTIONS(1247),
    [anon_sym_GT_AMP] = ACTIONS(1247),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1245),
    [anon_sym_LF] = ACTIONS(1249),
    [anon_sym_AMP] = ACTIONS(1245),
  },
  [253] = {
    [sym_concatenation] = STATE(212),
    [sym_string] = STATE(645),
    [sym_array] = STATE(212),
    [sym_simple_expansion] = STATE(645),
    [sym_string_expansion] = STATE(645),
    [sym_expansion] = STATE(645),
    [sym_command_substitution] = STATE(645),
    [sym_process_substitution] = STATE(645),
    [sym__empty_value] = ACTIONS(385),
    [anon_sym_LPAREN] = ACTIONS(387),
    [sym__special_characters] = ACTIONS(1251),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(1253),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1253),
  },
  [254] = {
    [sym_do_group] = STATE(646),
    [anon_sym_do] = ACTIONS(411),
    [sym_comment] = ACTIONS(53),
  },
  [255] = {
    [sym_compound_statement] = STATE(648),
    [anon_sym_LPAREN] = ACTIONS(1255),
    [anon_sym_LBRACE] = ACTIONS(455),
    [sym_comment] = ACTIONS(53),
  },
  [256] = {
    [anon_sym_AMP_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(543),
    [anon_sym_RBRACK] = ACTIONS(1257),
    [anon_sym_EQ_TILDE] = ACTIONS(547),
    [anon_sym_EQ_EQ] = ACTIONS(547),
    [anon_sym_EQ] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(543),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(543),
  },
  [257] = {
    [anon_sym_AMP_AMP] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1257),
    [anon_sym_EQ_TILDE] = ACTIONS(575),
    [anon_sym_EQ_EQ] = ACTIONS(575),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(573),
    [anon_sym_GT] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(573),
  },
  [258] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(1259),
    [anon_sym_PLUS_EQ] = ACTIONS(1259),
    [sym_comment] = ACTIONS(53),
  },
  [259] = {
    [aux_sym_concatenation_repeat1] = STATE(651),
    [sym__concat] = ACTIONS(581),
    [sym_variable_name] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(585),
    [anon_sym_RPAREN] = ACTIONS(585),
    [anon_sym_SEMI_SEMI] = ACTIONS(585),
    [anon_sym_PIPE_AMP] = ACTIONS(585),
    [anon_sym_AMP_AMP] = ACTIONS(585),
    [anon_sym_PIPE_PIPE] = ACTIONS(585),
    [sym__special_characters] = ACTIONS(585),
    [anon_sym_DQUOTE] = ACTIONS(585),
    [anon_sym_DOLLAR] = ACTIONS(585),
    [sym_raw_string] = ACTIONS(585),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(585),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(585),
    [anon_sym_BQUOTE] = ACTIONS(585),
    [anon_sym_LT_LPAREN] = ACTIONS(585),
    [anon_sym_GT_LPAREN] = ACTIONS(585),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(585),
    [sym_word] = ACTIONS(585),
    [anon_sym_SEMI] = ACTIONS(585),
    [anon_sym_LF] = ACTIONS(583),
    [anon_sym_AMP] = ACTIONS(585),
  },
  [260] = {
    [aux_sym_concatenation_repeat1] = STATE(651),
    [sym__concat] = ACTIONS(581),
    [sym_variable_name] = ACTIONS(599),
    [anon_sym_PIPE] = ACTIONS(601),
    [anon_sym_RPAREN] = ACTIONS(601),
    [anon_sym_SEMI_SEMI] = ACTIONS(601),
    [anon_sym_PIPE_AMP] = ACTIONS(601),
    [anon_sym_AMP_AMP] = ACTIONS(601),
    [anon_sym_PIPE_PIPE] = ACTIONS(601),
    [sym__special_characters] = ACTIONS(601),
    [anon_sym_DQUOTE] = ACTIONS(601),
    [anon_sym_DOLLAR] = ACTIONS(601),
    [sym_raw_string] = ACTIONS(601),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(601),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(601),
    [anon_sym_BQUOTE] = ACTIONS(601),
    [anon_sym_LT_LPAREN] = ACTIONS(601),
    [anon_sym_GT_LPAREN] = ACTIONS(601),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(601),
    [sym_word] = ACTIONS(601),
    [anon_sym_SEMI] = ACTIONS(601),
    [anon_sym_LF] = ACTIONS(599),
    [anon_sym_AMP] = ACTIONS(601),
  },
  [261] = {
    [anon_sym_EQ] = ACTIONS(1259),
    [anon_sym_PLUS_EQ] = ACTIONS(1259),
    [sym_comment] = ACTIONS(53),
  },
  [262] = {
    [sym_variable_assignment] = STATE(652),
    [sym_subscript] = STATE(261),
    [sym_concatenation] = STATE(652),
    [sym_string] = STATE(260),
    [sym_simple_expansion] = STATE(260),
    [sym_string_expansion] = STATE(260),
    [sym_expansion] = STATE(260),
    [sym_command_substitution] = STATE(260),
    [sym_process_substitution] = STATE(260),
    [aux_sym_declaration_command_repeat1] = STATE(652),
    [sym_variable_name] = ACTIONS(461),
    [anon_sym_PIPE] = ACTIONS(617),
    [anon_sym_RPAREN] = ACTIONS(617),
    [anon_sym_SEMI_SEMI] = ACTIONS(617),
    [anon_sym_PIPE_AMP] = ACTIONS(617),
    [anon_sym_AMP_AMP] = ACTIONS(617),
    [anon_sym_PIPE_PIPE] = ACTIONS(617),
    [sym__special_characters] = ACTIONS(463),
    [anon_sym_DQUOTE] = ACTIONS(163),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(465),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(169),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(171),
    [anon_sym_BQUOTE] = ACTIONS(173),
    [anon_sym_LT_LPAREN] = ACTIONS(175),
    [anon_sym_GT_LPAREN] = ACTIONS(175),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(179),
    [sym_word] = ACTIONS(465),
    [anon_sym_SEMI] = ACTIONS(617),
    [anon_sym_LF] = ACTIONS(619),
    [anon_sym_AMP] = ACTIONS(617),
  },
  [263] = {
    [aux_sym_concatenation_repeat1] = STATE(653),
    [sym__concat] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(623),
    [anon_sym_SEMI_SEMI] = ACTIONS(623),
    [anon_sym_PIPE_AMP] = ACTIONS(623),
    [anon_sym_AMP_AMP] = ACTIONS(623),
    [anon_sym_PIPE_PIPE] = ACTIONS(623),
    [sym__special_characters] = ACTIONS(623),
    [anon_sym_DQUOTE] = ACTIONS(623),
    [anon_sym_DOLLAR] = ACTIONS(623),
    [sym_raw_string] = ACTIONS(623),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(623),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(623),
    [anon_sym_BQUOTE] = ACTIONS(623),
    [anon_sym_LT_LPAREN] = ACTIONS(623),
    [anon_sym_GT_LPAREN] = ACTIONS(623),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(623),
    [sym_word] = ACTIONS(623),
    [anon_sym_SEMI] = ACTIONS(623),
    [anon_sym_LF] = ACTIONS(625),
    [anon_sym_AMP] = ACTIONS(623),
  },
  [264] = {
    [aux_sym_concatenation_repeat1] = STATE(653),
    [sym__concat] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(639),
    [anon_sym_RPAREN] = ACTIONS(639),
    [anon_sym_SEMI_SEMI] = ACTIONS(639),
    [anon_sym_PIPE_AMP] = ACTIONS(639),
    [anon_sym_AMP_AMP] = ACTIONS(639),
    [anon_sym_PIPE_PIPE] = ACTIONS(639),
    [sym__special_characters] = ACTIONS(639),
    [anon_sym_DQUOTE] = ACTIONS(639),
    [anon_sym_DOLLAR] = ACTIONS(639),
    [sym_raw_string] = ACTIONS(639),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(639),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(639),
    [anon_sym_BQUOTE] = ACTIONS(639),
    [anon_sym_LT_LPAREN] = ACTIONS(639),
    [anon_sym_GT_LPAREN] = ACTIONS(639),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(639),
    [sym_word] = ACTIONS(639),
    [anon_sym_SEMI] = ACTIONS(639),
    [anon_sym_LF] = ACTIONS(641),
    [anon_sym_AMP] = ACTIONS(639),
  },
  [265] = {
    [sym_concatenation] = STATE(654),
    [sym_string] = STATE(264),
    [sym_simple_expansion] = STATE(264),
    [sym_string_expansion] = STATE(264),
    [sym_expansion] = STATE(264),
    [sym_command_substitution] = STATE(264),
    [sym_process_substitution] = STATE(264),
    [aux_sym_unset_command_repeat1] = STATE(654),
    [anon_sym_PIPE] = ACTIONS(657),
    [anon_sym_RPAREN] = ACTIONS(657),
    [anon_sym_SEMI_SEMI] = ACTIONS(657),
    [anon_sym_PIPE_AMP] = ACTIONS(657),
    [anon_sym_AMP_AMP] = ACTIONS(657),
    [anon_sym_PIPE_PIPE] = ACTIONS(657),
    [sym__special_characters] = ACTIONS(467),
    [anon_sym_DQUOTE] = ACTIONS(187),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(469),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(193),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(195),
    [anon_sym_BQUOTE] = ACTIONS(197),
    [anon_sym_LT_LPAREN] = ACTIONS(199),
    [anon_sym_GT_LPAREN] = ACTIONS(199),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(201),
    [sym_word] = ACTIONS(469),
    [anon_sym_SEMI] = ACTIONS(657),
    [anon_sym_LF] = ACTIONS(659),
    [anon_sym_AMP] = ACTIONS(657),
  },
  [266] = {
    [aux_sym_concatenation_repeat1] = STATE(655),
    [sym__simple_heredoc_body] = ACTIONS(693),
    [sym__heredoc_body_beginning] = ACTIONS(693),
    [sym_file_descriptor] = ACTIONS(693),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_RPAREN] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(695),
    [anon_sym_EQ_TILDE] = ACTIONS(695),
    [anon_sym_EQ_EQ] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(695),
    [anon_sym_GT] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(695),
    [anon_sym_AMP_GT] = ACTIONS(695),
    [anon_sym_AMP_GT_GT] = ACTIONS(695),
    [anon_sym_LT_AMP] = ACTIONS(695),
    [anon_sym_GT_AMP] = ACTIONS(695),
    [anon_sym_LT_LT] = ACTIONS(695),
    [anon_sym_LT_LT_DASH] = ACTIONS(695),
    [anon_sym_LT_LT_LT] = ACTIONS(695),
    [sym__special_characters] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(695),
    [anon_sym_BQUOTE] = ACTIONS(695),
    [anon_sym_LT_LPAREN] = ACTIONS(695),
    [anon_sym_GT_LPAREN] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [267] = {
    [anon_sym_RPAREN] = ACTIONS(1261),
    [sym_comment] = ACTIONS(53),
  },
  [268] = {
    [sym_for_statement] = STATE(529),
    [sym_while_statement] = STATE(529),
    [sym_if_statement] = STATE(529),
    [sym_case_statement] = STATE(529),
    [sym_function_definition] = STATE(529),
    [sym_subshell] = STATE(529),
    [sym_pipeline] = STATE(529),
    [sym_list] = STATE(529),
    [sym_negated_command] = STATE(529),
    [sym_test_command] = STATE(529),
    [sym_declaration_command] = STATE(529),
    [sym_unset_command] = STATE(529),
    [sym_command] = STATE(529),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(530),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_command_repeat1] = STATE(68),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_typeset] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_readonly] = ACTIONS(97),
    [anon_sym_local] = ACTIONS(97),
    [anon_sym_unset] = ACTIONS(99),
    [anon_sym_unsetenv] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(105),
  },
  [269] = {
    [anon_sym_esac] = ACTIONS(1263),
    [anon_sym_PIPE] = ACTIONS(1263),
    [anon_sym_RPAREN] = ACTIONS(1263),
    [anon_sym_SEMI_SEMI] = ACTIONS(1263),
    [anon_sym_PIPE_AMP] = ACTIONS(1263),
    [anon_sym_AMP_AMP] = ACTIONS(1263),
    [anon_sym_PIPE_PIPE] = ACTIONS(1263),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1263),
    [anon_sym_LF] = ACTIONS(1265),
    [anon_sym_AMP] = ACTIONS(1263),
  },
  [270] = {
    [sym_file_descriptor] = ACTIONS(951),
    [sym_variable_name] = ACTIONS(951),
    [anon_sym_for] = ACTIONS(953),
    [anon_sym_while] = ACTIONS(953),
    [anon_sym_if] = ACTIONS(953),
    [anon_sym_case] = ACTIONS(953),
    [anon_sym_RPAREN] = ACTIONS(1267),
    [anon_sym_function] = ACTIONS(953),
    [anon_sym_LPAREN] = ACTIONS(951),
    [anon_sym_BANG] = ACTIONS(953),
    [anon_sym_LBRACK] = ACTIONS(953),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(951),
    [anon_sym_declare] = ACTIONS(953),
    [anon_sym_typeset] = ACTIONS(953),
    [anon_sym_export] = ACTIONS(953),
    [anon_sym_readonly] = ACTIONS(953),
    [anon_sym_local] = ACTIONS(953),
    [anon_sym_unset] = ACTIONS(953),
    [anon_sym_unsetenv] = ACTIONS(953),
    [anon_sym_LT] = ACTIONS(953),
    [anon_sym_GT] = ACTIONS(953),
    [anon_sym_GT_GT] = ACTIONS(951),
    [anon_sym_AMP_GT] = ACTIONS(953),
    [anon_sym_AMP_GT_GT] = ACTIONS(951),
    [anon_sym_LT_AMP] = ACTIONS(951),
    [anon_sym_GT_AMP] = ACTIONS(951),
    [sym__special_characters] = ACTIONS(953),
    [anon_sym_DQUOTE] = ACTIONS(951),
    [anon_sym_DOLLAR] = ACTIONS(953),
    [sym_raw_string] = ACTIONS(951),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(951),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(951),
    [anon_sym_BQUOTE] = ACTIONS(951),
    [anon_sym_LT_LPAREN] = ACTIONS(951),
    [anon_sym_GT_LPAREN] = ACTIONS(951),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(953),
  },
  [271] = {
    [sym_for_statement] = STATE(658),
    [sym_while_statement] = STATE(658),
    [sym_if_statement] = STATE(658),
    [sym_case_statement] = STATE(658),
    [sym_function_definition] = STATE(658),
    [sym_subshell] = STATE(658),
    [sym_pipeline] = STATE(658),
    [sym_list] = STATE(658),
    [sym_negated_command] = STATE(658),
    [sym_test_command] = STATE(658),
    [sym_declaration_command] = STATE(658),
    [sym_unset_command] = STATE(658),
    [sym_command] = STATE(658),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(659),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_command_repeat1] = STATE(68),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_typeset] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_readonly] = ACTIONS(97),
    [anon_sym_local] = ACTIONS(97),
    [anon_sym_unset] = ACTIONS(99),
    [anon_sym_unsetenv] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(105),
  },
  [272] = {
    [anon_sym_LT] = ACTIONS(1269),
    [anon_sym_GT] = ACTIONS(1269),
    [anon_sym_GT_GT] = ACTIONS(1271),
    [anon_sym_AMP_GT] = ACTIONS(1269),
    [anon_sym_AMP_GT_GT] = ACTIONS(1271),
    [anon_sym_LT_AMP] = ACTIONS(1271),
    [anon_sym_GT_AMP] = ACTIONS(1271),
    [sym_comment] = ACTIONS(53),
  },
  [273] = {
    [sym_concatenation] = STATE(540),
    [sym_string] = STATE(662),
    [sym_simple_expansion] = STATE(662),
    [sym_string_expansion] = STATE(662),
    [sym_expansion] = STATE(662),
    [sym_command_substitution] = STATE(662),
    [sym_process_substitution] = STATE(662),
    [sym__special_characters] = ACTIONS(1273),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1275),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1275),
    [sym_regex] = ACTIONS(975),
  },
  [274] = {
    [sym_concatenation] = STATE(543),
    [sym_string] = STATE(664),
    [sym_simple_expansion] = STATE(664),
    [sym_string_expansion] = STATE(664),
    [sym_expansion] = STATE(664),
    [sym_command_substitution] = STATE(664),
    [sym_process_substitution] = STATE(664),
    [sym__special_characters] = ACTIONS(1277),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1279),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1279),
  },
  [275] = {
    [sym_concatenation] = STATE(547),
    [sym_string] = STATE(666),
    [sym_simple_expansion] = STATE(666),
    [sym_string_expansion] = STATE(666),
    [sym_expansion] = STATE(666),
    [sym_command_substitution] = STATE(666),
    [sym_process_substitution] = STATE(666),
    [sym__special_characters] = ACTIONS(1281),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(1283),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1283),
  },
  [276] = {
    [aux_sym_concatenation_repeat1] = STATE(266),
    [sym__simple_heredoc_body] = ACTIONS(987),
    [sym__heredoc_body_beginning] = ACTIONS(987),
    [sym_file_descriptor] = ACTIONS(987),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(989),
    [anon_sym_RPAREN] = ACTIONS(989),
    [anon_sym_SEMI_SEMI] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(989),
    [anon_sym_AMP_AMP] = ACTIONS(989),
    [anon_sym_PIPE_PIPE] = ACTIONS(989),
    [anon_sym_EQ_TILDE] = ACTIONS(989),
    [anon_sym_EQ_EQ] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(989),
    [anon_sym_GT] = ACTIONS(989),
    [anon_sym_GT_GT] = ACTIONS(989),
    [anon_sym_AMP_GT] = ACTIONS(989),
    [anon_sym_AMP_GT_GT] = ACTIONS(989),
    [anon_sym_LT_AMP] = ACTIONS(989),
    [anon_sym_GT_AMP] = ACTIONS(989),
    [anon_sym_LT_LT] = ACTIONS(989),
    [anon_sym_LT_LT_DASH] = ACTIONS(989),
    [anon_sym_LT_LT_LT] = ACTIONS(989),
    [sym__special_characters] = ACTIONS(989),
    [anon_sym_DQUOTE] = ACTIONS(989),
    [anon_sym_DOLLAR] = ACTIONS(989),
    [sym_raw_string] = ACTIONS(989),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(989),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(989),
    [anon_sym_BQUOTE] = ACTIONS(989),
    [anon_sym_LT_LPAREN] = ACTIONS(989),
    [anon_sym_GT_LPAREN] = ACTIONS(989),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(989),
    [anon_sym_SEMI] = ACTIONS(989),
    [anon_sym_LF] = ACTIONS(987),
    [anon_sym_AMP] = ACTIONS(989),
  },
  [277] = {
    [aux_sym_concatenation_repeat1] = STATE(266),
    [sym__simple_heredoc_body] = ACTIONS(991),
    [sym__heredoc_body_beginning] = ACTIONS(991),
    [sym_file_descriptor] = ACTIONS(991),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(993),
    [anon_sym_RPAREN] = ACTIONS(993),
    [anon_sym_SEMI_SEMI] = ACTIONS(993),
    [anon_sym_PIPE_AMP] = ACTIONS(993),
    [anon_sym_AMP_AMP] = ACTIONS(993),
    [anon_sym_PIPE_PIPE] = ACTIONS(993),
    [anon_sym_EQ_TILDE] = ACTIONS(993),
    [anon_sym_EQ_EQ] = ACTIONS(993),
    [anon_sym_LT] = ACTIONS(993),
    [anon_sym_GT] = ACTIONS(993),
    [anon_sym_GT_GT] = ACTIONS(993),
    [anon_sym_AMP_GT] = ACTIONS(993),
    [anon_sym_AMP_GT_GT] = ACTIONS(993),
    [anon_sym_LT_AMP] = ACTIONS(993),
    [anon_sym_GT_AMP] = ACTIONS(993),
    [anon_sym_LT_LT] = ACTIONS(993),
    [anon_sym_LT_LT_DASH] = ACTIONS(993),
    [anon_sym_LT_LT_LT] = ACTIONS(993),
    [sym__special_characters] = ACTIONS(993),
    [anon_sym_DQUOTE] = ACTIONS(993),
    [anon_sym_DOLLAR] = ACTIONS(993),
    [sym_raw_string] = ACTIONS(993),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(993),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(993),
    [anon_sym_BQUOTE] = ACTIONS(993),
    [anon_sym_LT_LPAREN] = ACTIONS(993),
    [anon_sym_GT_LPAREN] = ACTIONS(993),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(993),
    [anon_sym_SEMI] = ACTIONS(993),
    [anon_sym_LF] = ACTIONS(991),
    [anon_sym_AMP] = ACTIONS(993),
  },
  [278] = {
    [sym_file_redirect] = STATE(667),
    [sym_heredoc_redirect] = STATE(667),
    [sym_heredoc_body] = STATE(548),
    [sym_herestring_redirect] = STATE(667),
    [aux_sym_while_statement_repeat1] = STATE(667),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(995),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(995),
    [anon_sym_AMP_AMP] = ACTIONS(995),
    [anon_sym_PIPE_PIPE] = ACTIONS(995),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(487),
    [anon_sym_AMP_GT] = ACTIONS(487),
    [anon_sym_AMP_GT_GT] = ACTIONS(487),
    [anon_sym_LT_AMP] = ACTIONS(487),
    [anon_sym_GT_AMP] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(995),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(995),
  },
  [279] = {
    [sym_file_redirect] = STATE(668),
    [sym_heredoc_redirect] = STATE(668),
    [sym_heredoc_body] = STATE(548),
    [sym_herestring_redirect] = STATE(668),
    [sym_concatenation] = STATE(669),
    [sym_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_string_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym_while_statement_repeat1] = STATE(668),
    [aux_sym_command_repeat2] = STATE(669),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(995),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(995),
    [anon_sym_AMP_AMP] = ACTIONS(995),
    [anon_sym_PIPE_PIPE] = ACTIONS(995),
    [anon_sym_EQ_TILDE] = ACTIONS(485),
    [anon_sym_EQ_EQ] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(487),
    [anon_sym_AMP_GT] = ACTIONS(487),
    [anon_sym_AMP_GT_GT] = ACTIONS(487),
    [anon_sym_LT_AMP] = ACTIONS(487),
    [anon_sym_GT_AMP] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [sym__special_characters] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(493),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(493),
    [anon_sym_SEMI] = ACTIONS(995),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(995),
  },
  [280] = {
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(1285),
    [anon_sym_SEMI_SEMI] = ACTIONS(1287),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1287),
    [anon_sym_LF] = ACTIONS(1289),
    [anon_sym_AMP] = ACTIONS(1287),
  },
  [281] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(1285),
    [anon_sym_SEMI_SEMI] = ACTIONS(1287),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(1287),
    [anon_sym_LF] = ACTIONS(1289),
    [anon_sym_AMP] = ACTIONS(1287),
  },
  [282] = {
    [sym__terminated_statement] = STATE(282),
    [sym_for_statement] = STATE(26),
    [sym_while_statement] = STATE(26),
    [sym_if_statement] = STATE(26),
    [sym_case_statement] = STATE(26),
    [sym_function_definition] = STATE(26),
    [sym_subshell] = STATE(26),
    [sym_pipeline] = STATE(26),
    [sym_list] = STATE(26),
    [sym_negated_command] = STATE(26),
    [sym_test_command] = STATE(26),
    [sym_declaration_command] = STATE(26),
    [sym_unset_command] = STATE(26),
    [sym_command] = STATE(26),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(28),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(282),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(999),
    [sym_variable_name] = ACTIONS(1002),
    [anon_sym_for] = ACTIONS(1007),
    [anon_sym_while] = ACTIONS(1010),
    [anon_sym_if] = ACTIONS(1013),
    [anon_sym_case] = ACTIONS(1016),
    [anon_sym_function] = ACTIONS(1019),
    [anon_sym_LPAREN] = ACTIONS(1022),
    [anon_sym_BANG] = ACTIONS(1025),
    [anon_sym_LBRACK] = ACTIONS(1028),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(1031),
    [anon_sym_declare] = ACTIONS(1034),
    [anon_sym_typeset] = ACTIONS(1034),
    [anon_sym_export] = ACTIONS(1034),
    [anon_sym_readonly] = ACTIONS(1034),
    [anon_sym_local] = ACTIONS(1034),
    [anon_sym_unset] = ACTIONS(1037),
    [anon_sym_unsetenv] = ACTIONS(1037),
    [anon_sym_LT] = ACTIONS(1040),
    [anon_sym_GT] = ACTIONS(1040),
    [anon_sym_GT_GT] = ACTIONS(1043),
    [anon_sym_AMP_GT] = ACTIONS(1040),
    [anon_sym_AMP_GT_GT] = ACTIONS(1043),
    [anon_sym_LT_AMP] = ACTIONS(1043),
    [anon_sym_GT_AMP] = ACTIONS(1043),
    [sym__special_characters] = ACTIONS(1046),
    [anon_sym_DQUOTE] = ACTIONS(1049),
    [anon_sym_DOLLAR] = ACTIONS(1052),
    [sym_raw_string] = ACTIONS(1055),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1058),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1061),
    [anon_sym_BQUOTE] = ACTIONS(1064),
    [anon_sym_LT_LPAREN] = ACTIONS(1067),
    [anon_sym_GT_LPAREN] = ACTIONS(1067),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1070),
  },
  [283] = {
    [sym_file_redirect] = STATE(668),
    [sym_heredoc_redirect] = STATE(668),
    [sym_heredoc_body] = STATE(548),
    [sym_herestring_redirect] = STATE(668),
    [sym_concatenation] = STATE(671),
    [sym_string] = STATE(277),
    [sym_simple_expansion] = STATE(277),
    [sym_string_expansion] = STATE(277),
    [sym_expansion] = STATE(277),
    [sym_command_substitution] = STATE(277),
    [sym_process_substitution] = STATE(277),
    [aux_sym_while_statement_repeat1] = STATE(668),
    [aux_sym_command_repeat2] = STATE(671),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(995),
    [anon_sym_SEMI_SEMI] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(995),
    [anon_sym_AMP_AMP] = ACTIONS(995),
    [anon_sym_PIPE_PIPE] = ACTIONS(995),
    [anon_sym_EQ_TILDE] = ACTIONS(485),
    [anon_sym_EQ_EQ] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(487),
    [anon_sym_AMP_GT] = ACTIONS(487),
    [anon_sym_AMP_GT_GT] = ACTIONS(487),
    [anon_sym_LT_AMP] = ACTIONS(487),
    [anon_sym_GT_AMP] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [sym__special_characters] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(493),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(493),
    [anon_sym_SEMI] = ACTIONS(995),
    [anon_sym_LF] = ACTIONS(997),
    [anon_sym_AMP] = ACTIONS(995),
  },
  [284] = {
    [sym_concatenation] = STATE(672),
    [sym_string] = STATE(675),
    [sym_array] = STATE(672),
    [sym_simple_expansion] = STATE(675),
    [sym_string_expansion] = STATE(675),
    [sym_expansion] = STATE(675),
    [sym_command_substitution] = STATE(675),
    [sym_process_substitution] = STATE(675),
    [sym__empty_value] = ACTIONS(1291),
    [anon_sym_LPAREN] = ACTIONS(1293),
    [sym__special_characters] = ACTIONS(1295),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(1297),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1297),
  },
  [285] = {
    [sym__expression] = STATE(676),
    [sym_binary_expression] = STATE(676),
    [sym_unary_expression] = STATE(676),
    [sym_parenthesized_expression] = STATE(676),
    [sym_concatenation] = STATE(676),
    [sym_string] = STATE(287),
    [sym_simple_expansion] = STATE(287),
    [sym_string_expansion] = STATE(287),
    [sym_expansion] = STATE(287),
    [sym_command_substitution] = STATE(287),
    [sym_process_substitution] = STATE(287),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(503),
    [sym__special_characters] = ACTIONS(505),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(507),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(509),
    [sym_test_operator] = ACTIONS(511),
  },
  [286] = {
    [aux_sym_concatenation_repeat1] = STATE(677),
    [sym__concat] = ACTIONS(551),
    [anon_sym_RPAREN] = ACTIONS(515),
    [anon_sym_AMP_AMP] = ACTIONS(515),
    [anon_sym_PIPE_PIPE] = ACTIONS(515),
    [anon_sym_EQ_TILDE] = ACTIONS(515),
    [anon_sym_EQ_EQ] = ACTIONS(515),
    [anon_sym_EQ] = ACTIONS(517),
    [anon_sym_LT] = ACTIONS(515),
    [anon_sym_GT] = ACTIONS(515),
    [anon_sym_BANG_EQ] = ACTIONS(515),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(515),
  },
  [287] = {
    [aux_sym_concatenation_repeat1] = STATE(677),
    [sym__concat] = ACTIONS(551),
    [anon_sym_RPAREN] = ACTIONS(529),
    [anon_sym_AMP_AMP] = ACTIONS(529),
    [anon_sym_PIPE_PIPE] = ACTIONS(529),
    [anon_sym_EQ_TILDE] = ACTIONS(529),
    [anon_sym_EQ_EQ] = ACTIONS(529),
    [anon_sym_EQ] = ACTIONS(531),
    [anon_sym_LT] = ACTIONS(529),
    [anon_sym_GT] = ACTIONS(529),
    [anon_sym_BANG_EQ] = ACTIONS(529),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(529),
  },
  [288] = {
    [anon_sym_RPAREN] = ACTIONS(1299),
    [anon_sym_AMP_AMP] = ACTIONS(1301),
    [anon_sym_PIPE_PIPE] = ACTIONS(1301),
    [anon_sym_EQ_TILDE] = ACTIONS(1303),
    [anon_sym_EQ_EQ] = ACTIONS(1303),
    [anon_sym_EQ] = ACTIONS(1305),
    [anon_sym_LT] = ACTIONS(1301),
    [anon_sym_GT] = ACTIONS(1301),
    [anon_sym_BANG_EQ] = ACTIONS(1301),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1301),
  },
  [289] = {
    [anon_sym_AMP_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(543),
    [anon_sym_RBRACK] = ACTIONS(1307),
    [anon_sym_EQ_TILDE] = ACTIONS(547),
    [anon_sym_EQ_EQ] = ACTIONS(547),
    [anon_sym_EQ] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(543),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(543),
  },
  [290] = {
    [sym_string] = STATE(681),
    [sym_simple_expansion] = STATE(681),
    [sym_string_expansion] = STATE(681),
    [sym_expansion] = STATE(681),
    [sym_command_substitution] = STATE(681),
    [sym_process_substitution] = STATE(681),
    [sym__special_characters] = ACTIONS(1309),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(1309),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1309),
  },
  [291] = {
    [aux_sym_concatenation_repeat1] = STATE(682),
    [sym__concat] = ACTIONS(513),
    [anon_sym_AMP_AMP] = ACTIONS(693),
    [anon_sym_PIPE_PIPE] = ACTIONS(693),
    [anon_sym_RBRACK] = ACTIONS(693),
    [anon_sym_EQ_TILDE] = ACTIONS(693),
    [anon_sym_EQ_EQ] = ACTIONS(693),
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(693),
    [anon_sym_BANG_EQ] = ACTIONS(693),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(693),
  },
  [292] = {
    [sym__concat] = ACTIONS(697),
    [anon_sym_AMP_AMP] = ACTIONS(697),
    [anon_sym_PIPE_PIPE] = ACTIONS(697),
    [anon_sym_RBRACK] = ACTIONS(697),
    [anon_sym_EQ_TILDE] = ACTIONS(697),
    [anon_sym_EQ_EQ] = ACTIONS(697),
    [anon_sym_EQ] = ACTIONS(699),
    [anon_sym_LT] = ACTIONS(697),
    [anon_sym_GT] = ACTIONS(697),
    [anon_sym_BANG_EQ] = ACTIONS(697),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(697),
  },
  [293] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1311),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [294] = {
    [sym__concat] = ACTIONS(727),
    [anon_sym_AMP_AMP] = ACTIONS(727),
    [anon_sym_PIPE_PIPE] = ACTIONS(727),
    [anon_sym_RBRACK] = ACTIONS(727),
    [anon_sym_EQ_TILDE] = ACTIONS(727),
    [anon_sym_EQ_EQ] = ACTIONS(727),
    [anon_sym_EQ] = ACTIONS(729),
    [anon_sym_LT] = ACTIONS(727),
    [anon_sym_GT] = ACTIONS(727),
    [anon_sym_BANG_EQ] = ACTIONS(727),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(727),
  },
  [295] = {
    [sym__concat] = ACTIONS(731),
    [anon_sym_AMP_AMP] = ACTIONS(731),
    [anon_sym_PIPE_PIPE] = ACTIONS(731),
    [anon_sym_RBRACK] = ACTIONS(731),
    [anon_sym_EQ_TILDE] = ACTIONS(731),
    [anon_sym_EQ_EQ] = ACTIONS(731),
    [anon_sym_EQ] = ACTIONS(733),
    [anon_sym_LT] = ACTIONS(731),
    [anon_sym_GT] = ACTIONS(731),
    [anon_sym_BANG_EQ] = ACTIONS(731),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(731),
  },
  [296] = {
    [sym__concat] = ACTIONS(735),
    [anon_sym_AMP_AMP] = ACTIONS(735),
    [anon_sym_PIPE_PIPE] = ACTIONS(735),
    [anon_sym_RBRACK] = ACTIONS(735),
    [anon_sym_EQ_TILDE] = ACTIONS(735),
    [anon_sym_EQ_EQ] = ACTIONS(735),
    [anon_sym_EQ] = ACTIONS(737),
    [anon_sym_LT] = ACTIONS(735),
    [anon_sym_GT] = ACTIONS(735),
    [anon_sym_BANG_EQ] = ACTIONS(735),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(735),
  },
  [297] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1313),
    [sym_comment] = ACTIONS(53),
  },
  [298] = {
    [sym_concatenation] = STATE(687),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(687),
    [anon_sym_RBRACE] = ACTIONS(1315),
    [anon_sym_EQ] = ACTIONS(1317),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1319),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1321),
    [anon_sym_COLON] = ACTIONS(1317),
    [anon_sym_COLON_QMARK] = ACTIONS(1317),
    [anon_sym_COLON_DASH] = ACTIONS(1317),
    [anon_sym_PERCENT] = ACTIONS(1317),
    [anon_sym_DASH] = ACTIONS(1317),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [299] = {
    [sym_subscript] = STATE(691),
    [sym_variable_name] = ACTIONS(1323),
    [anon_sym_DOLLAR] = ACTIONS(1325),
    [anon_sym_DASH] = ACTIONS(1325),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1327),
    [anon_sym_STAR] = ACTIONS(1325),
    [anon_sym_AT] = ACTIONS(1325),
    [anon_sym_QMARK] = ACTIONS(1325),
    [anon_sym_0] = ACTIONS(1329),
    [anon_sym__] = ACTIONS(1329),
  },
  [300] = {
    [sym_concatenation] = STATE(694),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(694),
    [anon_sym_RBRACE] = ACTIONS(1331),
    [anon_sym_EQ] = ACTIONS(1333),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1335),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1337),
    [anon_sym_COLON] = ACTIONS(1333),
    [anon_sym_COLON_QMARK] = ACTIONS(1333),
    [anon_sym_COLON_DASH] = ACTIONS(1333),
    [anon_sym_PERCENT] = ACTIONS(1333),
    [anon_sym_DASH] = ACTIONS(1333),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [301] = {
    [sym_concatenation] = STATE(697),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(697),
    [anon_sym_RBRACE] = ACTIONS(1339),
    [anon_sym_EQ] = ACTIONS(1341),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1343),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1345),
    [anon_sym_COLON] = ACTIONS(1341),
    [anon_sym_COLON_QMARK] = ACTIONS(1341),
    [anon_sym_COLON_DASH] = ACTIONS(1341),
    [anon_sym_PERCENT] = ACTIONS(1341),
    [anon_sym_DASH] = ACTIONS(1341),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [302] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1347),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [303] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1347),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [304] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1347),
    [sym_comment] = ACTIONS(53),
  },
  [305] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1347),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [306] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1349),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [307] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1349),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [308] = {
    [sym__expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_unary_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(700),
    [sym_concatenation] = STATE(700),
    [sym_string] = STATE(77),
    [sym_simple_expansion] = STATE(77),
    [sym_string_expansion] = STATE(77),
    [sym_expansion] = STATE(77),
    [sym_command_substitution] = STATE(77),
    [sym_process_substitution] = STATE(77),
    [anon_sym_LPAREN] = ACTIONS(109),
    [anon_sym_BANG] = ACTIONS(111),
    [sym__special_characters] = ACTIONS(113),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(129),
    [sym_test_operator] = ACTIONS(131),
  },
  [309] = {
    [sym_file_redirect] = STATE(705),
    [sym_heredoc_redirect] = STATE(705),
    [sym_herestring_redirect] = STATE(705),
    [aux_sym_while_statement_repeat1] = STATE(705),
    [sym_file_descriptor] = ACTIONS(1351),
    [anon_sym_PIPE] = ACTIONS(1353),
    [anon_sym_SEMI_SEMI] = ACTIONS(1353),
    [anon_sym_PIPE_AMP] = ACTIONS(1353),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(1355),
    [anon_sym_GT] = ACTIONS(1355),
    [anon_sym_GT_GT] = ACTIONS(1355),
    [anon_sym_AMP_GT] = ACTIONS(1355),
    [anon_sym_AMP_GT_GT] = ACTIONS(1355),
    [anon_sym_LT_AMP] = ACTIONS(1355),
    [anon_sym_GT_AMP] = ACTIONS(1355),
    [anon_sym_LT_LT] = ACTIONS(1357),
    [anon_sym_LT_LT_DASH] = ACTIONS(1357),
    [anon_sym_LT_LT_LT] = ACTIONS(1359),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_LF] = ACTIONS(1361),
    [anon_sym_AMP] = ACTIONS(1353),
  },
  [310] = {
    [sym__expression] = STATE(700),
    [sym_binary_expression] = STATE(700),
    [sym_unary_expression] = STATE(700),
    [sym_parenthesized_expression] = STATE(700),
    [sym_concatenation] = STATE(700),
    [sym_string] = STATE(77),
    [sym_simple_expansion] = STATE(77),
    [sym_string_expansion] = STATE(77),
    [sym_expansion] = STATE(77),
    [sym_command_substitution] = STATE(77),
    [sym_process_substitution] = STATE(77),
    [anon_sym_LPAREN] = ACTIONS(1363),
    [anon_sym_BANG] = ACTIONS(111),
    [sym__special_characters] = ACTIONS(1365),
    [anon_sym_DQUOTE] = ACTIONS(1367),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(129),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1371),
    [anon_sym_BQUOTE] = ACTIONS(1373),
    [anon_sym_LT_LPAREN] = ACTIONS(1375),
    [anon_sym_GT_LPAREN] = ACTIONS(1375),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(129),
    [sym_test_operator] = ACTIONS(111),
    [sym_regex] = ACTIONS(1377),
  },
  [311] = {
    [anon_sym_RPAREN] = ACTIONS(1379),
    [anon_sym_AMP_AMP] = ACTIONS(1301),
    [anon_sym_PIPE_PIPE] = ACTIONS(1301),
    [anon_sym_EQ_TILDE] = ACTIONS(1303),
    [anon_sym_EQ_EQ] = ACTIONS(1303),
    [anon_sym_EQ] = ACTIONS(1305),
    [anon_sym_LT] = ACTIONS(1301),
    [anon_sym_GT] = ACTIONS(1301),
    [anon_sym_BANG_EQ] = ACTIONS(1301),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(1301),
  },
  [312] = {
    [anon_sym_AMP_AMP] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1307),
    [anon_sym_EQ_TILDE] = ACTIONS(575),
    [anon_sym_EQ_EQ] = ACTIONS(575),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(573),
    [anon_sym_GT] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(573),
  },
  [313] = {
    [sym_string] = STATE(708),
    [sym_simple_expansion] = STATE(708),
    [sym_string_expansion] = STATE(708),
    [sym_expansion] = STATE(708),
    [sym_command_substitution] = STATE(708),
    [sym_process_substitution] = STATE(708),
    [sym__special_characters] = ACTIONS(1381),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(1381),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1381),
  },
  [314] = {
    [aux_sym_concatenation_repeat1] = STATE(709),
    [sym__concat] = ACTIONS(551),
    [anon_sym_AMP_AMP] = ACTIONS(693),
    [anon_sym_PIPE_PIPE] = ACTIONS(693),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(693),
    [anon_sym_EQ_TILDE] = ACTIONS(693),
    [anon_sym_EQ_EQ] = ACTIONS(693),
    [anon_sym_EQ] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(693),
    [anon_sym_GT] = ACTIONS(693),
    [anon_sym_BANG_EQ] = ACTIONS(693),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(693),
  },
  [315] = {
    [sym__concat] = ACTIONS(697),
    [anon_sym_PIPE] = ACTIONS(699),
    [anon_sym_RPAREN] = ACTIONS(697),
    [anon_sym_AMP_AMP] = ACTIONS(697),
    [anon_sym_PIPE_PIPE] = ACTIONS(697),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(697),
    [anon_sym_EQ_TILDE] = ACTIONS(697),
    [anon_sym_EQ_EQ] = ACTIONS(697),
    [anon_sym_EQ] = ACTIONS(699),
    [anon_sym_LT] = ACTIONS(697),
    [anon_sym_GT] = ACTIONS(697),
    [anon_sym_BANG_EQ] = ACTIONS(697),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(697),
  },
  [316] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1383),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [317] = {
    [sym__concat] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_RPAREN] = ACTIONS(727),
    [anon_sym_AMP_AMP] = ACTIONS(727),
    [anon_sym_PIPE_PIPE] = ACTIONS(727),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(727),
    [anon_sym_EQ_TILDE] = ACTIONS(727),
    [anon_sym_EQ_EQ] = ACTIONS(727),
    [anon_sym_EQ] = ACTIONS(729),
    [anon_sym_LT] = ACTIONS(727),
    [anon_sym_GT] = ACTIONS(727),
    [anon_sym_BANG_EQ] = ACTIONS(727),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(727),
  },
  [318] = {
    [sym__concat] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(731),
    [anon_sym_AMP_AMP] = ACTIONS(731),
    [anon_sym_PIPE_PIPE] = ACTIONS(731),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(731),
    [anon_sym_EQ_TILDE] = ACTIONS(731),
    [anon_sym_EQ_EQ] = ACTIONS(731),
    [anon_sym_EQ] = ACTIONS(733),
    [anon_sym_LT] = ACTIONS(731),
    [anon_sym_GT] = ACTIONS(731),
    [anon_sym_BANG_EQ] = ACTIONS(731),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(731),
  },
  [319] = {
    [sym__concat] = ACTIONS(735),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_RPAREN] = ACTIONS(735),
    [anon_sym_AMP_AMP] = ACTIONS(735),
    [anon_sym_PIPE_PIPE] = ACTIONS(735),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(735),
    [anon_sym_EQ_TILDE] = ACTIONS(735),
    [anon_sym_EQ_EQ] = ACTIONS(735),
    [anon_sym_EQ] = ACTIONS(737),
    [anon_sym_LT] = ACTIONS(735),
    [anon_sym_GT] = ACTIONS(735),
    [anon_sym_BANG_EQ] = ACTIONS(735),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(735),
  },
  [320] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1385),
    [sym_comment] = ACTIONS(53),
  },
  [321] = {
    [sym_concatenation] = STATE(714),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(714),
    [anon_sym_RBRACE] = ACTIONS(1387),
    [anon_sym_EQ] = ACTIONS(1389),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1391),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1393),
    [anon_sym_COLON] = ACTIONS(1389),
    [anon_sym_COLON_QMARK] = ACTIONS(1389),
    [anon_sym_COLON_DASH] = ACTIONS(1389),
    [anon_sym_PERCENT] = ACTIONS(1389),
    [anon_sym_DASH] = ACTIONS(1389),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [322] = {
    [sym_subscript] = STATE(718),
    [sym_variable_name] = ACTIONS(1395),
    [anon_sym_DOLLAR] = ACTIONS(1397),
    [anon_sym_DASH] = ACTIONS(1397),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1399),
    [anon_sym_STAR] = ACTIONS(1397),
    [anon_sym_AT] = ACTIONS(1397),
    [anon_sym_QMARK] = ACTIONS(1397),
    [anon_sym_0] = ACTIONS(1401),
    [anon_sym__] = ACTIONS(1401),
  },
  [323] = {
    [sym_concatenation] = STATE(721),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(721),
    [anon_sym_RBRACE] = ACTIONS(1403),
    [anon_sym_EQ] = ACTIONS(1405),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1407),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1409),
    [anon_sym_COLON] = ACTIONS(1405),
    [anon_sym_COLON_QMARK] = ACTIONS(1405),
    [anon_sym_COLON_DASH] = ACTIONS(1405),
    [anon_sym_PERCENT] = ACTIONS(1405),
    [anon_sym_DASH] = ACTIONS(1405),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [324] = {
    [sym_concatenation] = STATE(724),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(724),
    [anon_sym_RBRACE] = ACTIONS(1411),
    [anon_sym_EQ] = ACTIONS(1413),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1415),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1417),
    [anon_sym_COLON] = ACTIONS(1413),
    [anon_sym_COLON_QMARK] = ACTIONS(1413),
    [anon_sym_COLON_DASH] = ACTIONS(1413),
    [anon_sym_PERCENT] = ACTIONS(1413),
    [anon_sym_DASH] = ACTIONS(1413),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [325] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1419),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [326] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1419),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [327] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1419),
    [sym_comment] = ACTIONS(53),
  },
  [328] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1419),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [329] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [330] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1421),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [331] = {
    [sym__expression] = STATE(727),
    [sym_binary_expression] = STATE(727),
    [sym_unary_expression] = STATE(727),
    [sym_parenthesized_expression] = STATE(727),
    [sym_concatenation] = STATE(727),
    [sym_string] = STATE(88),
    [sym_simple_expansion] = STATE(88),
    [sym_string_expansion] = STATE(88),
    [sym_expansion] = STATE(88),
    [sym_command_substitution] = STATE(88),
    [sym_process_substitution] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(137),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(143),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(155),
  },
  [332] = {
    [sym__expression] = STATE(727),
    [sym_binary_expression] = STATE(727),
    [sym_unary_expression] = STATE(727),
    [sym_parenthesized_expression] = STATE(727),
    [sym_concatenation] = STATE(727),
    [sym_string] = STATE(88),
    [sym_simple_expansion] = STATE(88),
    [sym_string_expansion] = STATE(88),
    [sym_expansion] = STATE(88),
    [sym_command_substitution] = STATE(88),
    [sym_process_substitution] = STATE(88),
    [anon_sym_LPAREN] = ACTIONS(1423),
    [anon_sym_BANG] = ACTIONS(135),
    [sym__special_characters] = ACTIONS(1425),
    [anon_sym_DQUOTE] = ACTIONS(1427),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(153),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1429),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1431),
    [anon_sym_BQUOTE] = ACTIONS(1433),
    [anon_sym_LT_LPAREN] = ACTIONS(1435),
    [anon_sym_GT_LPAREN] = ACTIONS(1435),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(153),
    [sym_test_operator] = ACTIONS(135),
    [sym_regex] = ACTIONS(1437),
  },
  [333] = {
    [sym_concatenation] = STATE(729),
    [sym_string] = STATE(732),
    [sym_array] = STATE(729),
    [sym_simple_expansion] = STATE(732),
    [sym_string_expansion] = STATE(732),
    [sym_expansion] = STATE(732),
    [sym_command_substitution] = STATE(732),
    [sym_process_substitution] = STATE(732),
    [sym__empty_value] = ACTIONS(1439),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [sym__special_characters] = ACTIONS(1443),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(1445),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1449),
    [anon_sym_BQUOTE] = ACTIONS(1451),
    [anon_sym_LT_LPAREN] = ACTIONS(1453),
    [anon_sym_GT_LPAREN] = ACTIONS(1453),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1445),
  },
  [334] = {
    [sym_string] = STATE(733),
    [sym_simple_expansion] = STATE(733),
    [sym_string_expansion] = STATE(733),
    [sym_expansion] = STATE(733),
    [sym_command_substitution] = STATE(733),
    [sym_process_substitution] = STATE(733),
    [sym__special_characters] = ACTIONS(1455),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(1455),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1449),
    [anon_sym_BQUOTE] = ACTIONS(1451),
    [anon_sym_LT_LPAREN] = ACTIONS(1453),
    [anon_sym_GT_LPAREN] = ACTIONS(1453),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1455),
  },
  [335] = {
    [aux_sym_concatenation_repeat1] = STATE(734),
    [sym__concat] = ACTIONS(581),
    [sym_variable_name] = ACTIONS(693),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(695),
    [sym__special_characters] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(695),
    [anon_sym_BQUOTE] = ACTIONS(695),
    [anon_sym_LT_LPAREN] = ACTIONS(695),
    [anon_sym_GT_LPAREN] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(695),
    [sym_word] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [336] = {
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(697),
    [anon_sym_PIPE] = ACTIONS(699),
    [anon_sym_RPAREN] = ACTIONS(699),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [anon_sym_PIPE_AMP] = ACTIONS(699),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [sym__special_characters] = ACTIONS(699),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_DOLLAR] = ACTIONS(699),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(699),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(699),
    [anon_sym_BQUOTE] = ACTIONS(699),
    [anon_sym_LT_LPAREN] = ACTIONS(699),
    [anon_sym_GT_LPAREN] = ACTIONS(699),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(699),
    [sym_word] = ACTIONS(699),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_LF] = ACTIONS(697),
    [anon_sym_AMP] = ACTIONS(699),
  },
  [337] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1457),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [338] = {
    [sym__concat] = ACTIONS(727),
    [sym_variable_name] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_RPAREN] = ACTIONS(729),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(729),
    [anon_sym_DQUOTE] = ACTIONS(729),
    [anon_sym_DOLLAR] = ACTIONS(729),
    [sym_raw_string] = ACTIONS(729),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(729),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(729),
    [anon_sym_BQUOTE] = ACTIONS(729),
    [anon_sym_LT_LPAREN] = ACTIONS(729),
    [anon_sym_GT_LPAREN] = ACTIONS(729),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(729),
    [sym_word] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(729),
    [anon_sym_LF] = ACTIONS(727),
    [anon_sym_AMP] = ACTIONS(729),
  },
  [339] = {
    [sym__concat] = ACTIONS(731),
    [sym_variable_name] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(733),
    [anon_sym_SEMI_SEMI] = ACTIONS(733),
    [anon_sym_PIPE_AMP] = ACTIONS(733),
    [anon_sym_AMP_AMP] = ACTIONS(733),
    [anon_sym_PIPE_PIPE] = ACTIONS(733),
    [sym__special_characters] = ACTIONS(733),
    [anon_sym_DQUOTE] = ACTIONS(733),
    [anon_sym_DOLLAR] = ACTIONS(733),
    [sym_raw_string] = ACTIONS(733),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(733),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(733),
    [anon_sym_BQUOTE] = ACTIONS(733),
    [anon_sym_LT_LPAREN] = ACTIONS(733),
    [anon_sym_GT_LPAREN] = ACTIONS(733),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(733),
    [sym_word] = ACTIONS(733),
    [anon_sym_SEMI] = ACTIONS(733),
    [anon_sym_LF] = ACTIONS(731),
    [anon_sym_AMP] = ACTIONS(733),
  },
  [340] = {
    [sym__concat] = ACTIONS(735),
    [sym_variable_name] = ACTIONS(735),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_RPAREN] = ACTIONS(737),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [anon_sym_PIPE_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(737),
    [sym__special_characters] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym_raw_string] = ACTIONS(737),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [anon_sym_LT_LPAREN] = ACTIONS(737),
    [anon_sym_GT_LPAREN] = ACTIONS(737),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(737),
    [sym_word] = ACTIONS(737),
    [anon_sym_SEMI] = ACTIONS(737),
    [anon_sym_LF] = ACTIONS(735),
    [anon_sym_AMP] = ACTIONS(737),
  },
  [341] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1459),
    [sym_comment] = ACTIONS(53),
  },
  [342] = {
    [sym_concatenation] = STATE(739),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(739),
    [anon_sym_RBRACE] = ACTIONS(1461),
    [anon_sym_EQ] = ACTIONS(1463),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1465),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1467),
    [anon_sym_COLON] = ACTIONS(1463),
    [anon_sym_COLON_QMARK] = ACTIONS(1463),
    [anon_sym_COLON_DASH] = ACTIONS(1463),
    [anon_sym_PERCENT] = ACTIONS(1463),
    [anon_sym_DASH] = ACTIONS(1463),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [343] = {
    [sym_subscript] = STATE(743),
    [sym_variable_name] = ACTIONS(1469),
    [anon_sym_DOLLAR] = ACTIONS(1471),
    [anon_sym_DASH] = ACTIONS(1471),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1473),
    [anon_sym_STAR] = ACTIONS(1471),
    [anon_sym_AT] = ACTIONS(1471),
    [anon_sym_QMARK] = ACTIONS(1471),
    [anon_sym_0] = ACTIONS(1475),
    [anon_sym__] = ACTIONS(1475),
  },
  [344] = {
    [sym_concatenation] = STATE(746),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(746),
    [anon_sym_RBRACE] = ACTIONS(1477),
    [anon_sym_EQ] = ACTIONS(1479),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1481),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1483),
    [anon_sym_COLON] = ACTIONS(1479),
    [anon_sym_COLON_QMARK] = ACTIONS(1479),
    [anon_sym_COLON_DASH] = ACTIONS(1479),
    [anon_sym_PERCENT] = ACTIONS(1479),
    [anon_sym_DASH] = ACTIONS(1479),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [345] = {
    [sym_concatenation] = STATE(749),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(749),
    [anon_sym_RBRACE] = ACTIONS(1485),
    [anon_sym_EQ] = ACTIONS(1487),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1489),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1491),
    [anon_sym_COLON] = ACTIONS(1487),
    [anon_sym_COLON_QMARK] = ACTIONS(1487),
    [anon_sym_COLON_DASH] = ACTIONS(1487),
    [anon_sym_PERCENT] = ACTIONS(1487),
    [anon_sym_DASH] = ACTIONS(1487),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [346] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1493),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [347] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1493),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [348] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1493),
    [sym_comment] = ACTIONS(53),
  },
  [349] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1493),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [350] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1495),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [351] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1495),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [352] = {
    [sym_variable_assignment] = STATE(352),
    [sym_subscript] = STATE(104),
    [sym_concatenation] = STATE(352),
    [sym_string] = STATE(98),
    [sym_simple_expansion] = STATE(98),
    [sym_string_expansion] = STATE(98),
    [sym_expansion] = STATE(98),
    [sym_command_substitution] = STATE(98),
    [sym_process_substitution] = STATE(98),
    [aux_sym_declaration_command_repeat1] = STATE(352),
    [sym_variable_name] = ACTIONS(1497),
    [anon_sym_PIPE] = ACTIONS(1500),
    [anon_sym_SEMI_SEMI] = ACTIONS(1500),
    [anon_sym_PIPE_AMP] = ACTIONS(1500),
    [anon_sym_AMP_AMP] = ACTIONS(1500),
    [anon_sym_PIPE_PIPE] = ACTIONS(1500),
    [sym__special_characters] = ACTIONS(1502),
    [anon_sym_DQUOTE] = ACTIONS(1505),
    [anon_sym_DOLLAR] = ACTIONS(1508),
    [sym_raw_string] = ACTIONS(1511),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1514),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1517),
    [anon_sym_BQUOTE] = ACTIONS(1520),
    [anon_sym_LT_LPAREN] = ACTIONS(1523),
    [anon_sym_GT_LPAREN] = ACTIONS(1523),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1526),
    [sym_word] = ACTIONS(1511),
    [anon_sym_SEMI] = ACTIONS(1500),
    [anon_sym_LF] = ACTIONS(1529),
    [anon_sym_AMP] = ACTIONS(1500),
  },
  [353] = {
    [sym_string] = STATE(752),
    [sym_simple_expansion] = STATE(752),
    [sym_string_expansion] = STATE(752),
    [sym_expansion] = STATE(752),
    [sym_command_substitution] = STATE(752),
    [sym_process_substitution] = STATE(752),
    [sym__special_characters] = ACTIONS(1531),
    [anon_sym_DQUOTE] = ACTIONS(629),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(1531),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1533),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1535),
    [anon_sym_BQUOTE] = ACTIONS(1537),
    [anon_sym_LT_LPAREN] = ACTIONS(1539),
    [anon_sym_GT_LPAREN] = ACTIONS(1539),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1531),
  },
  [354] = {
    [aux_sym_concatenation_repeat1] = STATE(753),
    [sym__concat] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(695),
    [sym__special_characters] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(695),
    [anon_sym_BQUOTE] = ACTIONS(695),
    [anon_sym_LT_LPAREN] = ACTIONS(695),
    [anon_sym_GT_LPAREN] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(695),
    [sym_word] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [355] = {
    [sym__concat] = ACTIONS(697),
    [anon_sym_PIPE] = ACTIONS(699),
    [anon_sym_RPAREN] = ACTIONS(699),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [anon_sym_PIPE_AMP] = ACTIONS(699),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [sym__special_characters] = ACTIONS(699),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_DOLLAR] = ACTIONS(699),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(699),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(699),
    [anon_sym_BQUOTE] = ACTIONS(699),
    [anon_sym_LT_LPAREN] = ACTIONS(699),
    [anon_sym_GT_LPAREN] = ACTIONS(699),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(699),
    [sym_word] = ACTIONS(699),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_LF] = ACTIONS(697),
    [anon_sym_AMP] = ACTIONS(699),
  },
  [356] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1541),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [357] = {
    [sym__concat] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_RPAREN] = ACTIONS(729),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(729),
    [anon_sym_DQUOTE] = ACTIONS(729),
    [anon_sym_DOLLAR] = ACTIONS(729),
    [sym_raw_string] = ACTIONS(729),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(729),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(729),
    [anon_sym_BQUOTE] = ACTIONS(729),
    [anon_sym_LT_LPAREN] = ACTIONS(729),
    [anon_sym_GT_LPAREN] = ACTIONS(729),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(729),
    [sym_word] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(729),
    [anon_sym_LF] = ACTIONS(727),
    [anon_sym_AMP] = ACTIONS(729),
  },
  [358] = {
    [sym__concat] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(733),
    [anon_sym_SEMI_SEMI] = ACTIONS(733),
    [anon_sym_PIPE_AMP] = ACTIONS(733),
    [anon_sym_AMP_AMP] = ACTIONS(733),
    [anon_sym_PIPE_PIPE] = ACTIONS(733),
    [sym__special_characters] = ACTIONS(733),
    [anon_sym_DQUOTE] = ACTIONS(733),
    [anon_sym_DOLLAR] = ACTIONS(733),
    [sym_raw_string] = ACTIONS(733),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(733),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(733),
    [anon_sym_BQUOTE] = ACTIONS(733),
    [anon_sym_LT_LPAREN] = ACTIONS(733),
    [anon_sym_GT_LPAREN] = ACTIONS(733),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(733),
    [sym_word] = ACTIONS(733),
    [anon_sym_SEMI] = ACTIONS(733),
    [anon_sym_LF] = ACTIONS(731),
    [anon_sym_AMP] = ACTIONS(733),
  },
  [359] = {
    [sym__concat] = ACTIONS(735),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_RPAREN] = ACTIONS(737),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [anon_sym_PIPE_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(737),
    [sym__special_characters] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym_raw_string] = ACTIONS(737),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [anon_sym_LT_LPAREN] = ACTIONS(737),
    [anon_sym_GT_LPAREN] = ACTIONS(737),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(737),
    [sym_word] = ACTIONS(737),
    [anon_sym_SEMI] = ACTIONS(737),
    [anon_sym_LF] = ACTIONS(735),
    [anon_sym_AMP] = ACTIONS(737),
  },
  [360] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1543),
    [sym_comment] = ACTIONS(53),
  },
  [361] = {
    [sym_concatenation] = STATE(758),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(758),
    [anon_sym_RBRACE] = ACTIONS(1545),
    [anon_sym_EQ] = ACTIONS(1547),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1549),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1551),
    [anon_sym_COLON] = ACTIONS(1547),
    [anon_sym_COLON_QMARK] = ACTIONS(1547),
    [anon_sym_COLON_DASH] = ACTIONS(1547),
    [anon_sym_PERCENT] = ACTIONS(1547),
    [anon_sym_DASH] = ACTIONS(1547),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [362] = {
    [sym_subscript] = STATE(762),
    [sym_variable_name] = ACTIONS(1553),
    [anon_sym_DOLLAR] = ACTIONS(1555),
    [anon_sym_DASH] = ACTIONS(1555),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1557),
    [anon_sym_STAR] = ACTIONS(1555),
    [anon_sym_AT] = ACTIONS(1555),
    [anon_sym_QMARK] = ACTIONS(1555),
    [anon_sym_0] = ACTIONS(1559),
    [anon_sym__] = ACTIONS(1559),
  },
  [363] = {
    [sym_concatenation] = STATE(765),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(765),
    [anon_sym_RBRACE] = ACTIONS(1561),
    [anon_sym_EQ] = ACTIONS(1563),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1565),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1567),
    [anon_sym_COLON] = ACTIONS(1563),
    [anon_sym_COLON_QMARK] = ACTIONS(1563),
    [anon_sym_COLON_DASH] = ACTIONS(1563),
    [anon_sym_PERCENT] = ACTIONS(1563),
    [anon_sym_DASH] = ACTIONS(1563),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [364] = {
    [sym_concatenation] = STATE(768),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(768),
    [anon_sym_RBRACE] = ACTIONS(1569),
    [anon_sym_EQ] = ACTIONS(1571),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1573),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1575),
    [anon_sym_COLON] = ACTIONS(1571),
    [anon_sym_COLON_QMARK] = ACTIONS(1571),
    [anon_sym_COLON_DASH] = ACTIONS(1571),
    [anon_sym_PERCENT] = ACTIONS(1571),
    [anon_sym_DASH] = ACTIONS(1571),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [365] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1577),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [366] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1577),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [367] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1577),
    [sym_comment] = ACTIONS(53),
  },
  [368] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1577),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [369] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1579),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [370] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1579),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [371] = {
    [sym_concatenation] = STATE(371),
    [sym_string] = STATE(109),
    [sym_simple_expansion] = STATE(109),
    [sym_string_expansion] = STATE(109),
    [sym_expansion] = STATE(109),
    [sym_command_substitution] = STATE(109),
    [sym_process_substitution] = STATE(109),
    [aux_sym_unset_command_repeat1] = STATE(371),
    [anon_sym_PIPE] = ACTIONS(1581),
    [anon_sym_SEMI_SEMI] = ACTIONS(1581),
    [anon_sym_PIPE_AMP] = ACTIONS(1581),
    [anon_sym_AMP_AMP] = ACTIONS(1581),
    [anon_sym_PIPE_PIPE] = ACTIONS(1581),
    [sym__special_characters] = ACTIONS(1583),
    [anon_sym_DQUOTE] = ACTIONS(1586),
    [anon_sym_DOLLAR] = ACTIONS(1589),
    [sym_raw_string] = ACTIONS(1592),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1595),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1598),
    [anon_sym_BQUOTE] = ACTIONS(1601),
    [anon_sym_LT_LPAREN] = ACTIONS(1604),
    [anon_sym_GT_LPAREN] = ACTIONS(1604),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1607),
    [sym_word] = ACTIONS(1592),
    [anon_sym_SEMI] = ACTIONS(1581),
    [anon_sym_LF] = ACTIONS(1610),
    [anon_sym_AMP] = ACTIONS(1581),
  },
  [372] = {
    [sym_string] = STATE(771),
    [sym_simple_expansion] = STATE(771),
    [sym_string_expansion] = STATE(771),
    [sym_expansion] = STATE(771),
    [sym_command_substitution] = STATE(771),
    [sym_process_substitution] = STATE(771),
    [sym__special_characters] = ACTIONS(1612),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(1612),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1612),
  },
  [373] = {
    [aux_sym_concatenation_repeat1] = STATE(772),
    [sym_file_descriptor] = ACTIONS(693),
    [sym__concat] = ACTIONS(663),
    [sym_variable_name] = ACTIONS(693),
    [anon_sym_LT] = ACTIONS(695),
    [anon_sym_GT] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(693),
    [anon_sym_AMP_GT] = ACTIONS(695),
    [anon_sym_AMP_GT_GT] = ACTIONS(693),
    [anon_sym_LT_AMP] = ACTIONS(693),
    [anon_sym_GT_AMP] = ACTIONS(693),
    [sym__special_characters] = ACTIONS(693),
    [anon_sym_DQUOTE] = ACTIONS(693),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(693),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(693),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(693),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [anon_sym_LT_LPAREN] = ACTIONS(693),
    [anon_sym_GT_LPAREN] = ACTIONS(693),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(693),
  },
  [374] = {
    [sym_file_descriptor] = ACTIONS(697),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(697),
    [anon_sym_PIPE] = ACTIONS(699),
    [anon_sym_RPAREN] = ACTIONS(697),
    [anon_sym_PIPE_AMP] = ACTIONS(697),
    [anon_sym_AMP_AMP] = ACTIONS(697),
    [anon_sym_PIPE_PIPE] = ACTIONS(697),
    [anon_sym_LT] = ACTIONS(699),
    [anon_sym_GT] = ACTIONS(699),
    [anon_sym_GT_GT] = ACTIONS(697),
    [anon_sym_AMP_GT] = ACTIONS(699),
    [anon_sym_AMP_GT_GT] = ACTIONS(697),
    [anon_sym_LT_AMP] = ACTIONS(697),
    [anon_sym_GT_AMP] = ACTIONS(697),
    [sym__special_characters] = ACTIONS(697),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_DOLLAR] = ACTIONS(699),
    [sym_raw_string] = ACTIONS(697),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(697),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(697),
    [anon_sym_BQUOTE] = ACTIONS(697),
    [anon_sym_LT_LPAREN] = ACTIONS(697),
    [anon_sym_GT_LPAREN] = ACTIONS(697),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(697),
  },
  [375] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1614),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [376] = {
    [sym_file_descriptor] = ACTIONS(727),
    [sym__concat] = ACTIONS(727),
    [sym_variable_name] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_RPAREN] = ACTIONS(727),
    [anon_sym_PIPE_AMP] = ACTIONS(727),
    [anon_sym_AMP_AMP] = ACTIONS(727),
    [anon_sym_PIPE_PIPE] = ACTIONS(727),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(727),
    [anon_sym_AMP_GT] = ACTIONS(729),
    [anon_sym_AMP_GT_GT] = ACTIONS(727),
    [anon_sym_LT_AMP] = ACTIONS(727),
    [anon_sym_GT_AMP] = ACTIONS(727),
    [sym__special_characters] = ACTIONS(727),
    [anon_sym_DQUOTE] = ACTIONS(727),
    [anon_sym_DOLLAR] = ACTIONS(729),
    [sym_raw_string] = ACTIONS(727),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(727),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(727),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [anon_sym_LT_LPAREN] = ACTIONS(727),
    [anon_sym_GT_LPAREN] = ACTIONS(727),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(727),
  },
  [377] = {
    [sym_file_descriptor] = ACTIONS(731),
    [sym__concat] = ACTIONS(731),
    [sym_variable_name] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(731),
    [anon_sym_PIPE_AMP] = ACTIONS(731),
    [anon_sym_AMP_AMP] = ACTIONS(731),
    [anon_sym_PIPE_PIPE] = ACTIONS(731),
    [anon_sym_LT] = ACTIONS(733),
    [anon_sym_GT] = ACTIONS(733),
    [anon_sym_GT_GT] = ACTIONS(731),
    [anon_sym_AMP_GT] = ACTIONS(733),
    [anon_sym_AMP_GT_GT] = ACTIONS(731),
    [anon_sym_LT_AMP] = ACTIONS(731),
    [anon_sym_GT_AMP] = ACTIONS(731),
    [sym__special_characters] = ACTIONS(731),
    [anon_sym_DQUOTE] = ACTIONS(731),
    [anon_sym_DOLLAR] = ACTIONS(733),
    [sym_raw_string] = ACTIONS(731),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(731),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(731),
    [anon_sym_BQUOTE] = ACTIONS(731),
    [anon_sym_LT_LPAREN] = ACTIONS(731),
    [anon_sym_GT_LPAREN] = ACTIONS(731),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(731),
  },
  [378] = {
    [sym_file_descriptor] = ACTIONS(735),
    [sym__concat] = ACTIONS(735),
    [sym_variable_name] = ACTIONS(735),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_RPAREN] = ACTIONS(735),
    [anon_sym_PIPE_AMP] = ACTIONS(735),
    [anon_sym_AMP_AMP] = ACTIONS(735),
    [anon_sym_PIPE_PIPE] = ACTIONS(735),
    [anon_sym_LT] = ACTIONS(737),
    [anon_sym_GT] = ACTIONS(737),
    [anon_sym_GT_GT] = ACTIONS(735),
    [anon_sym_AMP_GT] = ACTIONS(737),
    [anon_sym_AMP_GT_GT] = ACTIONS(735),
    [anon_sym_LT_AMP] = ACTIONS(735),
    [anon_sym_GT_AMP] = ACTIONS(735),
    [sym__special_characters] = ACTIONS(735),
    [anon_sym_DQUOTE] = ACTIONS(735),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym_raw_string] = ACTIONS(735),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(735),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(735),
    [anon_sym_BQUOTE] = ACTIONS(735),
    [anon_sym_LT_LPAREN] = ACTIONS(735),
    [anon_sym_GT_LPAREN] = ACTIONS(735),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(735),
  },
  [379] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1616),
    [sym_comment] = ACTIONS(53),
  },
  [380] = {
    [sym_concatenation] = STATE(777),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(777),
    [anon_sym_RBRACE] = ACTIONS(1618),
    [anon_sym_EQ] = ACTIONS(1620),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1622),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1624),
    [anon_sym_COLON] = ACTIONS(1620),
    [anon_sym_COLON_QMARK] = ACTIONS(1620),
    [anon_sym_COLON_DASH] = ACTIONS(1620),
    [anon_sym_PERCENT] = ACTIONS(1620),
    [anon_sym_DASH] = ACTIONS(1620),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [381] = {
    [sym_subscript] = STATE(781),
    [sym_variable_name] = ACTIONS(1626),
    [anon_sym_DOLLAR] = ACTIONS(1628),
    [anon_sym_DASH] = ACTIONS(1628),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1630),
    [anon_sym_STAR] = ACTIONS(1628),
    [anon_sym_AT] = ACTIONS(1628),
    [anon_sym_QMARK] = ACTIONS(1628),
    [anon_sym_0] = ACTIONS(1632),
    [anon_sym__] = ACTIONS(1632),
  },
  [382] = {
    [sym_concatenation] = STATE(784),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(784),
    [anon_sym_RBRACE] = ACTIONS(1634),
    [anon_sym_EQ] = ACTIONS(1636),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1638),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1640),
    [anon_sym_COLON] = ACTIONS(1636),
    [anon_sym_COLON_QMARK] = ACTIONS(1636),
    [anon_sym_COLON_DASH] = ACTIONS(1636),
    [anon_sym_PERCENT] = ACTIONS(1636),
    [anon_sym_DASH] = ACTIONS(1636),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [383] = {
    [sym_concatenation] = STATE(787),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(787),
    [anon_sym_RBRACE] = ACTIONS(1642),
    [anon_sym_EQ] = ACTIONS(1644),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1646),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1648),
    [anon_sym_COLON] = ACTIONS(1644),
    [anon_sym_COLON_QMARK] = ACTIONS(1644),
    [anon_sym_COLON_DASH] = ACTIONS(1644),
    [anon_sym_PERCENT] = ACTIONS(1644),
    [anon_sym_DASH] = ACTIONS(1644),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [384] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1650),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [385] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1650),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [386] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1650),
    [sym_comment] = ACTIONS(53),
  },
  [387] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1650),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [388] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1652),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [389] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1652),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [390] = {
    [sym__simple_heredoc_body] = ACTIONS(1654),
    [sym__heredoc_body_beginning] = ACTIONS(1654),
    [sym_file_descriptor] = ACTIONS(1654),
    [sym__concat] = ACTIONS(1654),
    [anon_sym_PIPE] = ACTIONS(1656),
    [anon_sym_RPAREN] = ACTIONS(1656),
    [anon_sym_SEMI_SEMI] = ACTIONS(1656),
    [anon_sym_PIPE_AMP] = ACTIONS(1656),
    [anon_sym_AMP_AMP] = ACTIONS(1656),
    [anon_sym_PIPE_PIPE] = ACTIONS(1656),
    [anon_sym_EQ_TILDE] = ACTIONS(1656),
    [anon_sym_EQ_EQ] = ACTIONS(1656),
    [anon_sym_LT] = ACTIONS(1656),
    [anon_sym_GT] = ACTIONS(1656),
    [anon_sym_GT_GT] = ACTIONS(1656),
    [anon_sym_AMP_GT] = ACTIONS(1656),
    [anon_sym_AMP_GT_GT] = ACTIONS(1656),
    [anon_sym_LT_AMP] = ACTIONS(1656),
    [anon_sym_GT_AMP] = ACTIONS(1656),
    [anon_sym_LT_LT] = ACTIONS(1656),
    [anon_sym_LT_LT_DASH] = ACTIONS(1656),
    [anon_sym_LT_LT_LT] = ACTIONS(1656),
    [sym__special_characters] = ACTIONS(1656),
    [anon_sym_DQUOTE] = ACTIONS(1656),
    [anon_sym_DOLLAR] = ACTIONS(1656),
    [sym_raw_string] = ACTIONS(1656),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1656),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1656),
    [anon_sym_BQUOTE] = ACTIONS(1656),
    [anon_sym_LT_LPAREN] = ACTIONS(1656),
    [anon_sym_GT_LPAREN] = ACTIONS(1656),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1656),
    [anon_sym_SEMI] = ACTIONS(1656),
    [anon_sym_LF] = ACTIONS(1654),
    [anon_sym_AMP] = ACTIONS(1656),
  },
  [391] = {
    [aux_sym_concatenation_repeat1] = STATE(391),
    [sym__simple_heredoc_body] = ACTIONS(1654),
    [sym__heredoc_body_beginning] = ACTIONS(1654),
    [sym_file_descriptor] = ACTIONS(1654),
    [sym__concat] = ACTIONS(1658),
    [anon_sym_PIPE] = ACTIONS(1656),
    [anon_sym_SEMI_SEMI] = ACTIONS(1656),
    [anon_sym_PIPE_AMP] = ACTIONS(1656),
    [anon_sym_AMP_AMP] = ACTIONS(1656),
    [anon_sym_PIPE_PIPE] = ACTIONS(1656),
    [anon_sym_EQ_TILDE] = ACTIONS(1656),
    [anon_sym_EQ_EQ] = ACTIONS(1656),
    [anon_sym_LT] = ACTIONS(1656),
    [anon_sym_GT] = ACTIONS(1656),
    [anon_sym_GT_GT] = ACTIONS(1656),
    [anon_sym_AMP_GT] = ACTIONS(1656),
    [anon_sym_AMP_GT_GT] = ACTIONS(1656),
    [anon_sym_LT_AMP] = ACTIONS(1656),
    [anon_sym_GT_AMP] = ACTIONS(1656),
    [anon_sym_LT_LT] = ACTIONS(1656),
    [anon_sym_LT_LT_DASH] = ACTIONS(1656),
    [anon_sym_LT_LT_LT] = ACTIONS(1656),
    [sym__special_characters] = ACTIONS(1656),
    [anon_sym_DQUOTE] = ACTIONS(1656),
    [anon_sym_DOLLAR] = ACTIONS(1656),
    [sym_raw_string] = ACTIONS(1656),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1656),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1656),
    [anon_sym_BQUOTE] = ACTIONS(1656),
    [anon_sym_LT_LPAREN] = ACTIONS(1656),
    [anon_sym_GT_LPAREN] = ACTIONS(1656),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1656),
    [anon_sym_SEMI] = ACTIONS(1656),
    [anon_sym_LF] = ACTIONS(1654),
    [anon_sym_AMP] = ACTIONS(1656),
  },
  [392] = {
    [sym__concat] = ACTIONS(727),
    [anon_sym_DQUOTE] = ACTIONS(729),
    [anon_sym_DOLLAR] = ACTIONS(729),
    [sym__string_content] = ACTIONS(727),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(729),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(729),
    [anon_sym_BQUOTE] = ACTIONS(729),
    [sym_comment] = ACTIONS(177),
  },
  [393] = {
    [sym__concat] = ACTIONS(1661),
    [anon_sym_DQUOTE] = ACTIONS(1663),
    [anon_sym_DOLLAR] = ACTIONS(1663),
    [sym__string_content] = ACTIONS(1665),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1663),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1663),
    [anon_sym_BQUOTE] = ACTIONS(1663),
    [sym_comment] = ACTIONS(177),
  },
  [394] = {
    [sym__concat] = ACTIONS(735),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym__string_content] = ACTIONS(735),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [sym_comment] = ACTIONS(177),
  },
  [395] = {
    [anon_sym_DQUOTE] = ACTIONS(1663),
    [anon_sym_DOLLAR] = ACTIONS(1663),
    [sym__string_content] = ACTIONS(1665),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1663),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1663),
    [anon_sym_BQUOTE] = ACTIONS(1663),
    [sym_comment] = ACTIONS(177),
  },
  [396] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1667),
    [sym_comment] = ACTIONS(53),
  },
  [397] = {
    [sym_concatenation] = STATE(794),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(794),
    [anon_sym_RBRACE] = ACTIONS(1669),
    [anon_sym_EQ] = ACTIONS(1671),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1673),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1675),
    [anon_sym_COLON] = ACTIONS(1671),
    [anon_sym_COLON_QMARK] = ACTIONS(1671),
    [anon_sym_COLON_DASH] = ACTIONS(1671),
    [anon_sym_PERCENT] = ACTIONS(1671),
    [anon_sym_DASH] = ACTIONS(1671),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [398] = {
    [sym_subscript] = STATE(798),
    [sym_variable_name] = ACTIONS(1677),
    [anon_sym_DOLLAR] = ACTIONS(1679),
    [anon_sym_DASH] = ACTIONS(1679),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1681),
    [anon_sym_STAR] = ACTIONS(1679),
    [anon_sym_AT] = ACTIONS(1679),
    [anon_sym_QMARK] = ACTIONS(1679),
    [anon_sym_0] = ACTIONS(1683),
    [anon_sym__] = ACTIONS(1683),
  },
  [399] = {
    [sym_concatenation] = STATE(801),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(801),
    [anon_sym_RBRACE] = ACTIONS(1685),
    [anon_sym_EQ] = ACTIONS(1687),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1689),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1691),
    [anon_sym_COLON] = ACTIONS(1687),
    [anon_sym_COLON_QMARK] = ACTIONS(1687),
    [anon_sym_COLON_DASH] = ACTIONS(1687),
    [anon_sym_PERCENT] = ACTIONS(1687),
    [anon_sym_DASH] = ACTIONS(1687),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [400] = {
    [sym_concatenation] = STATE(804),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(804),
    [anon_sym_RBRACE] = ACTIONS(1693),
    [anon_sym_EQ] = ACTIONS(1695),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1697),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1699),
    [anon_sym_COLON] = ACTIONS(1695),
    [anon_sym_COLON_QMARK] = ACTIONS(1695),
    [anon_sym_COLON_DASH] = ACTIONS(1695),
    [anon_sym_PERCENT] = ACTIONS(1695),
    [anon_sym_DASH] = ACTIONS(1695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [401] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1701),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [402] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1701),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [403] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1701),
    [sym_comment] = ACTIONS(53),
  },
  [404] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1701),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [405] = {
    [sym__simple_heredoc_body] = ACTIONS(1703),
    [sym__heredoc_body_beginning] = ACTIONS(1703),
    [sym_file_descriptor] = ACTIONS(1703),
    [sym__concat] = ACTIONS(1703),
    [anon_sym_PIPE] = ACTIONS(1705),
    [anon_sym_RPAREN] = ACTIONS(1705),
    [anon_sym_SEMI_SEMI] = ACTIONS(1705),
    [anon_sym_PIPE_AMP] = ACTIONS(1705),
    [anon_sym_AMP_AMP] = ACTIONS(1705),
    [anon_sym_PIPE_PIPE] = ACTIONS(1705),
    [anon_sym_EQ_TILDE] = ACTIONS(1705),
    [anon_sym_EQ_EQ] = ACTIONS(1705),
    [anon_sym_LT] = ACTIONS(1705),
    [anon_sym_GT] = ACTIONS(1705),
    [anon_sym_GT_GT] = ACTIONS(1705),
    [anon_sym_AMP_GT] = ACTIONS(1705),
    [anon_sym_AMP_GT_GT] = ACTIONS(1705),
    [anon_sym_LT_AMP] = ACTIONS(1705),
    [anon_sym_GT_AMP] = ACTIONS(1705),
    [anon_sym_LT_LT] = ACTIONS(1705),
    [anon_sym_LT_LT_DASH] = ACTIONS(1705),
    [anon_sym_LT_LT_LT] = ACTIONS(1705),
    [sym__special_characters] = ACTIONS(1705),
    [anon_sym_DQUOTE] = ACTIONS(1705),
    [anon_sym_DOLLAR] = ACTIONS(1705),
    [sym_raw_string] = ACTIONS(1705),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1705),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1705),
    [anon_sym_BQUOTE] = ACTIONS(1705),
    [anon_sym_LT_LPAREN] = ACTIONS(1705),
    [anon_sym_GT_LPAREN] = ACTIONS(1705),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1705),
    [anon_sym_SEMI] = ACTIONS(1705),
    [anon_sym_LF] = ACTIONS(1703),
    [anon_sym_AMP] = ACTIONS(1705),
  },
  [406] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1663),
    [anon_sym_DOLLAR] = ACTIONS(1707),
    [sym__string_content] = ACTIONS(1710),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1713),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1716),
    [anon_sym_BQUOTE] = ACTIONS(1719),
    [sym_comment] = ACTIONS(177),
  },
  [407] = {
    [sym_concatenation] = STATE(808),
    [sym_string] = STATE(807),
    [sym_simple_expansion] = STATE(807),
    [sym_string_expansion] = STATE(807),
    [sym_expansion] = STATE(807),
    [sym_command_substitution] = STATE(807),
    [sym_process_substitution] = STATE(807),
    [sym__special_characters] = ACTIONS(1722),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(1724),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1724),
  },
  [408] = {
    [sym_concatenation] = STATE(818),
    [sym_string] = STATE(813),
    [sym_simple_expansion] = STATE(813),
    [sym_string_expansion] = STATE(813),
    [sym_expansion] = STATE(813),
    [sym_command_substitution] = STATE(813),
    [sym_process_substitution] = STATE(813),
    [anon_sym_RBRACE] = ACTIONS(1726),
    [sym__special_characters] = ACTIONS(1728),
    [anon_sym_DQUOTE] = ACTIONS(1730),
    [anon_sym_DOLLAR] = ACTIONS(1732),
    [sym_raw_string] = ACTIONS(1734),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1736),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1738),
    [anon_sym_BQUOTE] = ACTIONS(1740),
    [anon_sym_LT_LPAREN] = ACTIONS(1742),
    [anon_sym_GT_LPAREN] = ACTIONS(1742),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1734),
  },
  [409] = {
    [sym__simple_heredoc_body] = ACTIONS(1744),
    [sym__heredoc_body_beginning] = ACTIONS(1744),
    [sym_file_descriptor] = ACTIONS(1744),
    [sym__concat] = ACTIONS(1744),
    [anon_sym_PIPE] = ACTIONS(1746),
    [anon_sym_RPAREN] = ACTIONS(1746),
    [anon_sym_SEMI_SEMI] = ACTIONS(1746),
    [anon_sym_PIPE_AMP] = ACTIONS(1746),
    [anon_sym_AMP_AMP] = ACTIONS(1746),
    [anon_sym_PIPE_PIPE] = ACTIONS(1746),
    [anon_sym_EQ_TILDE] = ACTIONS(1746),
    [anon_sym_EQ_EQ] = ACTIONS(1746),
    [anon_sym_LT] = ACTIONS(1746),
    [anon_sym_GT] = ACTIONS(1746),
    [anon_sym_GT_GT] = ACTIONS(1746),
    [anon_sym_AMP_GT] = ACTIONS(1746),
    [anon_sym_AMP_GT_GT] = ACTIONS(1746),
    [anon_sym_LT_AMP] = ACTIONS(1746),
    [anon_sym_GT_AMP] = ACTIONS(1746),
    [anon_sym_LT_LT] = ACTIONS(1746),
    [anon_sym_LT_LT_DASH] = ACTIONS(1746),
    [anon_sym_LT_LT_LT] = ACTIONS(1746),
    [sym__special_characters] = ACTIONS(1746),
    [anon_sym_DQUOTE] = ACTIONS(1746),
    [anon_sym_DOLLAR] = ACTIONS(1746),
    [sym_raw_string] = ACTIONS(1746),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1746),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1746),
    [anon_sym_BQUOTE] = ACTIONS(1746),
    [anon_sym_LT_LPAREN] = ACTIONS(1746),
    [anon_sym_GT_LPAREN] = ACTIONS(1746),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1746),
    [anon_sym_SEMI] = ACTIONS(1746),
    [anon_sym_LF] = ACTIONS(1744),
    [anon_sym_AMP] = ACTIONS(1746),
  },
  [410] = {
    [aux_sym_concatenation_repeat1] = STATE(820),
    [sym__concat] = ACTIONS(1748),
    [anon_sym_RBRACE] = ACTIONS(1750),
    [anon_sym_EQ] = ACTIONS(1752),
    [sym__special_characters] = ACTIONS(1752),
    [anon_sym_DQUOTE] = ACTIONS(1750),
    [anon_sym_DOLLAR] = ACTIONS(1752),
    [sym_raw_string] = ACTIONS(1750),
    [anon_sym_POUND] = ACTIONS(1750),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1750),
    [anon_sym_COLON] = ACTIONS(1752),
    [anon_sym_COLON_QMARK] = ACTIONS(1752),
    [anon_sym_COLON_DASH] = ACTIONS(1752),
    [anon_sym_PERCENT] = ACTIONS(1752),
    [anon_sym_DASH] = ACTIONS(1752),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1750),
    [anon_sym_BQUOTE] = ACTIONS(1750),
    [anon_sym_LT_LPAREN] = ACTIONS(1750),
    [anon_sym_GT_LPAREN] = ACTIONS(1750),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1752),
  },
  [411] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(822),
    [anon_sym_DQUOTE] = ACTIONS(1754),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [412] = {
    [sym_string] = STATE(824),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(1756),
    [sym_raw_string] = ACTIONS(1758),
    [anon_sym_POUND] = ACTIONS(1756),
    [anon_sym_DASH] = ACTIONS(1756),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1760),
    [anon_sym_STAR] = ACTIONS(1756),
    [anon_sym_AT] = ACTIONS(1756),
    [anon_sym_QMARK] = ACTIONS(1756),
    [anon_sym_0] = ACTIONS(1762),
    [anon_sym__] = ACTIONS(1762),
  },
  [413] = {
    [aux_sym_concatenation_repeat1] = STATE(820),
    [sym__concat] = ACTIONS(1748),
    [anon_sym_RBRACE] = ACTIONS(1764),
    [anon_sym_EQ] = ACTIONS(1766),
    [sym__special_characters] = ACTIONS(1766),
    [anon_sym_DQUOTE] = ACTIONS(1764),
    [anon_sym_DOLLAR] = ACTIONS(1766),
    [sym_raw_string] = ACTIONS(1764),
    [anon_sym_POUND] = ACTIONS(1764),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1764),
    [anon_sym_COLON] = ACTIONS(1766),
    [anon_sym_COLON_QMARK] = ACTIONS(1766),
    [anon_sym_COLON_DASH] = ACTIONS(1766),
    [anon_sym_PERCENT] = ACTIONS(1766),
    [anon_sym_DASH] = ACTIONS(1766),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1764),
    [anon_sym_BQUOTE] = ACTIONS(1764),
    [anon_sym_LT_LPAREN] = ACTIONS(1764),
    [anon_sym_GT_LPAREN] = ACTIONS(1764),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1766),
  },
  [414] = {
    [sym_subscript] = STATE(830),
    [sym_variable_name] = ACTIONS(1768),
    [anon_sym_DOLLAR] = ACTIONS(1770),
    [anon_sym_POUND] = ACTIONS(1772),
    [anon_sym_DASH] = ACTIONS(1770),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1774),
    [anon_sym_STAR] = ACTIONS(1770),
    [anon_sym_AT] = ACTIONS(1770),
    [anon_sym_QMARK] = ACTIONS(1770),
    [anon_sym_0] = ACTIONS(1776),
    [anon_sym__] = ACTIONS(1776),
  },
  [415] = {
    [sym_comment] = ACTIONS(177),
    [sym_regex_without_right_brace] = ACTIONS(1778),
  },
  [416] = {
    [sym_for_statement] = STATE(832),
    [sym_while_statement] = STATE(832),
    [sym_if_statement] = STATE(832),
    [sym_case_statement] = STATE(832),
    [sym_function_definition] = STATE(832),
    [sym_subshell] = STATE(832),
    [sym_pipeline] = STATE(832),
    [sym_list] = STATE(832),
    [sym_negated_command] = STATE(832),
    [sym_test_command] = STATE(832),
    [sym_declaration_command] = STATE(832),
    [sym_unset_command] = STATE(832),
    [sym_command] = STATE(832),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(833),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [417] = {
    [sym_for_statement] = STATE(834),
    [sym_while_statement] = STATE(834),
    [sym_if_statement] = STATE(834),
    [sym_case_statement] = STATE(834),
    [sym_function_definition] = STATE(834),
    [sym_subshell] = STATE(834),
    [sym_pipeline] = STATE(834),
    [sym_list] = STATE(834),
    [sym_negated_command] = STATE(834),
    [sym_test_command] = STATE(834),
    [sym_declaration_command] = STATE(834),
    [sym_unset_command] = STATE(834),
    [sym_command] = STATE(834),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(835),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [418] = {
    [sym_for_statement] = STATE(836),
    [sym_while_statement] = STATE(836),
    [sym_if_statement] = STATE(836),
    [sym_case_statement] = STATE(836),
    [sym_function_definition] = STATE(836),
    [sym_subshell] = STATE(836),
    [sym_pipeline] = STATE(836),
    [sym_list] = STATE(836),
    [sym_negated_command] = STATE(836),
    [sym_test_command] = STATE(836),
    [sym_declaration_command] = STATE(836),
    [sym_unset_command] = STATE(836),
    [sym_command] = STATE(836),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(837),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [419] = {
    [sym_concatenation] = STATE(839),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(839),
    [anon_sym_RBRACE] = ACTIONS(1780),
    [anon_sym_EQ] = ACTIONS(1782),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(1782),
    [anon_sym_COLON_QMARK] = ACTIONS(1782),
    [anon_sym_COLON_DASH] = ACTIONS(1782),
    [anon_sym_PERCENT] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(1782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [420] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1786),
    [sym_comment] = ACTIONS(53),
  },
  [421] = {
    [sym_concatenation] = STATE(843),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(843),
    [anon_sym_RBRACE] = ACTIONS(1788),
    [anon_sym_EQ] = ACTIONS(1790),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1792),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1794),
    [anon_sym_COLON] = ACTIONS(1790),
    [anon_sym_COLON_QMARK] = ACTIONS(1790),
    [anon_sym_COLON_DASH] = ACTIONS(1790),
    [anon_sym_PERCENT] = ACTIONS(1790),
    [anon_sym_DASH] = ACTIONS(1790),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [422] = {
    [sym_concatenation] = STATE(846),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(846),
    [anon_sym_RBRACE] = ACTIONS(1796),
    [anon_sym_EQ] = ACTIONS(1798),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1800),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1802),
    [anon_sym_COLON] = ACTIONS(1798),
    [anon_sym_COLON_QMARK] = ACTIONS(1798),
    [anon_sym_COLON_DASH] = ACTIONS(1798),
    [anon_sym_PERCENT] = ACTIONS(1798),
    [anon_sym_DASH] = ACTIONS(1798),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [423] = {
    [sym_concatenation] = STATE(848),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(848),
    [anon_sym_RBRACE] = ACTIONS(1726),
    [anon_sym_EQ] = ACTIONS(1804),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1806),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1808),
    [anon_sym_COLON] = ACTIONS(1804),
    [anon_sym_COLON_QMARK] = ACTIONS(1804),
    [anon_sym_COLON_DASH] = ACTIONS(1804),
    [anon_sym_PERCENT] = ACTIONS(1804),
    [anon_sym_DASH] = ACTIONS(1804),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [424] = {
    [sym__simple_heredoc_body] = ACTIONS(1810),
    [sym__heredoc_body_beginning] = ACTIONS(1810),
    [sym_file_descriptor] = ACTIONS(1810),
    [sym__concat] = ACTIONS(1810),
    [anon_sym_PIPE] = ACTIONS(1812),
    [anon_sym_RPAREN] = ACTIONS(1812),
    [anon_sym_SEMI_SEMI] = ACTIONS(1812),
    [anon_sym_PIPE_AMP] = ACTIONS(1812),
    [anon_sym_AMP_AMP] = ACTIONS(1812),
    [anon_sym_PIPE_PIPE] = ACTIONS(1812),
    [anon_sym_EQ_TILDE] = ACTIONS(1812),
    [anon_sym_EQ_EQ] = ACTIONS(1812),
    [anon_sym_LT] = ACTIONS(1812),
    [anon_sym_GT] = ACTIONS(1812),
    [anon_sym_GT_GT] = ACTIONS(1812),
    [anon_sym_AMP_GT] = ACTIONS(1812),
    [anon_sym_AMP_GT_GT] = ACTIONS(1812),
    [anon_sym_LT_AMP] = ACTIONS(1812),
    [anon_sym_GT_AMP] = ACTIONS(1812),
    [anon_sym_LT_LT] = ACTIONS(1812),
    [anon_sym_LT_LT_DASH] = ACTIONS(1812),
    [anon_sym_LT_LT_LT] = ACTIONS(1812),
    [sym__special_characters] = ACTIONS(1812),
    [anon_sym_DQUOTE] = ACTIONS(1812),
    [anon_sym_DOLLAR] = ACTIONS(1812),
    [sym_raw_string] = ACTIONS(1812),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1812),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1812),
    [anon_sym_BQUOTE] = ACTIONS(1812),
    [anon_sym_LT_LPAREN] = ACTIONS(1812),
    [anon_sym_GT_LPAREN] = ACTIONS(1812),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1812),
    [anon_sym_SEMI] = ACTIONS(1812),
    [anon_sym_LF] = ACTIONS(1810),
    [anon_sym_AMP] = ACTIONS(1812),
  },
  [425] = {
    [sym_comment] = ACTIONS(177),
    [sym_regex_without_right_brace] = ACTIONS(1814),
  },
  [426] = {
    [sym_concatenation] = STATE(839),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(839),
    [anon_sym_RBRACE] = ACTIONS(1816),
    [anon_sym_EQ] = ACTIONS(1782),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(1782),
    [anon_sym_COLON_QMARK] = ACTIONS(1782),
    [anon_sym_COLON_DASH] = ACTIONS(1782),
    [anon_sym_PERCENT] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(1782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [427] = {
    [sym__simple_heredoc_body] = ACTIONS(1818),
    [sym__heredoc_body_beginning] = ACTIONS(1818),
    [sym_file_descriptor] = ACTIONS(1818),
    [sym__concat] = ACTIONS(1818),
    [anon_sym_PIPE] = ACTIONS(1820),
    [anon_sym_RPAREN] = ACTIONS(1820),
    [anon_sym_SEMI_SEMI] = ACTIONS(1820),
    [anon_sym_PIPE_AMP] = ACTIONS(1820),
    [anon_sym_AMP_AMP] = ACTIONS(1820),
    [anon_sym_PIPE_PIPE] = ACTIONS(1820),
    [anon_sym_EQ_TILDE] = ACTIONS(1820),
    [anon_sym_EQ_EQ] = ACTIONS(1820),
    [anon_sym_LT] = ACTIONS(1820),
    [anon_sym_GT] = ACTIONS(1820),
    [anon_sym_GT_GT] = ACTIONS(1820),
    [anon_sym_AMP_GT] = ACTIONS(1820),
    [anon_sym_AMP_GT_GT] = ACTIONS(1820),
    [anon_sym_LT_AMP] = ACTIONS(1820),
    [anon_sym_GT_AMP] = ACTIONS(1820),
    [anon_sym_LT_LT] = ACTIONS(1820),
    [anon_sym_LT_LT_DASH] = ACTIONS(1820),
    [anon_sym_LT_LT_LT] = ACTIONS(1820),
    [sym__special_characters] = ACTIONS(1820),
    [anon_sym_DQUOTE] = ACTIONS(1820),
    [anon_sym_DOLLAR] = ACTIONS(1820),
    [sym_raw_string] = ACTIONS(1820),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1820),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1820),
    [anon_sym_BQUOTE] = ACTIONS(1820),
    [anon_sym_LT_LPAREN] = ACTIONS(1820),
    [anon_sym_GT_LPAREN] = ACTIONS(1820),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1820),
    [anon_sym_SEMI] = ACTIONS(1820),
    [anon_sym_LF] = ACTIONS(1818),
    [anon_sym_AMP] = ACTIONS(1820),
  },
  [428] = {
    [sym_comment] = ACTIONS(177),
    [sym_regex_without_right_brace] = ACTIONS(1822),
  },
  [429] = {
    [sym_concatenation] = STATE(839),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(839),
    [anon_sym_RBRACE] = ACTIONS(1726),
    [anon_sym_EQ] = ACTIONS(1782),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(1782),
    [anon_sym_COLON_QMARK] = ACTIONS(1782),
    [anon_sym_COLON_DASH] = ACTIONS(1782),
    [anon_sym_PERCENT] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(1782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [430] = {
    [sym_concatenation] = STATE(672),
    [sym_string] = STATE(853),
    [sym_array] = STATE(672),
    [sym_simple_expansion] = STATE(853),
    [sym_string_expansion] = STATE(853),
    [sym_expansion] = STATE(853),
    [sym_command_substitution] = STATE(853),
    [sym_process_substitution] = STATE(853),
    [sym__empty_value] = ACTIONS(1291),
    [anon_sym_LPAREN] = ACTIONS(1293),
    [sym__special_characters] = ACTIONS(1824),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(1826),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1826),
  },
  [431] = {
    [anon_sym_in] = ACTIONS(1828),
    [anon_sym_SEMI_SEMI] = ACTIONS(1830),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1830),
    [anon_sym_LF] = ACTIONS(1832),
    [anon_sym_AMP] = ACTIONS(1830),
  },
  [432] = {
    [sym_do_group] = STATE(857),
    [anon_sym_do] = ACTIONS(1834),
    [sym_comment] = ACTIONS(53),
  },
  [433] = {
    [anon_sym_then] = ACTIONS(1836),
    [sym_comment] = ACTIONS(53),
  },
  [434] = {
    [aux_sym_concatenation_repeat1] = STATE(231),
    [sym__concat] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(1838),
    [anon_sym_SEMI_SEMI] = ACTIONS(1840),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1840),
    [anon_sym_LF] = ACTIONS(1842),
    [anon_sym_AMP] = ACTIONS(1840),
  },
  [435] = {
    [aux_sym_concatenation_repeat1] = STATE(231),
    [sym__concat] = ACTIONS(419),
    [anon_sym_in] = ACTIONS(1844),
    [anon_sym_SEMI_SEMI] = ACTIONS(1846),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1846),
    [anon_sym_LF] = ACTIONS(1848),
    [anon_sym_AMP] = ACTIONS(1846),
  },
  [436] = {
    [anon_sym_in] = ACTIONS(1844),
    [anon_sym_SEMI_SEMI] = ACTIONS(1846),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1846),
    [anon_sym_LF] = ACTIONS(1848),
    [anon_sym_AMP] = ACTIONS(1846),
  },
  [437] = {
    [sym_compound_statement] = STATE(865),
    [anon_sym_LPAREN] = ACTIONS(1850),
    [anon_sym_LBRACE] = ACTIONS(1852),
    [sym_comment] = ACTIONS(53),
  },
  [438] = {
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(1854),
    [anon_sym_SEMI_SEMI] = ACTIONS(1856),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1856),
    [anon_sym_LF] = ACTIONS(1858),
    [anon_sym_AMP] = ACTIONS(1856),
  },
  [439] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(1854),
    [anon_sym_SEMI_SEMI] = ACTIONS(1856),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(479),
    [anon_sym_PIPE_PIPE] = ACTIONS(479),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(1856),
    [anon_sym_LF] = ACTIONS(1858),
    [anon_sym_AMP] = ACTIONS(1856),
  },
  [440] = {
    [sym__terminated_statement] = STATE(282),
    [sym_for_statement] = STATE(868),
    [sym_while_statement] = STATE(868),
    [sym_if_statement] = STATE(868),
    [sym_case_statement] = STATE(868),
    [sym_function_definition] = STATE(868),
    [sym_subshell] = STATE(868),
    [sym_pipeline] = STATE(868),
    [sym_list] = STATE(868),
    [sym_negated_command] = STATE(868),
    [sym_test_command] = STATE(868),
    [sym_declaration_command] = STATE(868),
    [sym_unset_command] = STATE(868),
    [sym_command] = STATE(868),
    [sym_command_name] = STATE(64),
    [sym_variable_assignment] = STATE(869),
    [sym_subscript] = STATE(66),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(61),
    [sym_simple_expansion] = STATE(61),
    [sym_string_expansion] = STATE(61),
    [sym_expansion] = STATE(61),
    [sym_command_substitution] = STATE(61),
    [sym_process_substitution] = STATE(61),
    [aux_sym_program_repeat1] = STATE(282),
    [aux_sym_command_repeat1] = STATE(68),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(85),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(87),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(89),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(91),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(95),
    [anon_sym_declare] = ACTIONS(97),
    [anon_sym_typeset] = ACTIONS(97),
    [anon_sym_export] = ACTIONS(97),
    [anon_sym_readonly] = ACTIONS(97),
    [anon_sym_local] = ACTIONS(97),
    [anon_sym_unset] = ACTIONS(99),
    [anon_sym_unsetenv] = ACTIONS(99),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(101),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(103),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(105),
  },
  [441] = {
    [anon_sym_PIPE] = ACTIONS(499),
    [anon_sym_RPAREN] = ACTIONS(501),
    [anon_sym_PIPE_AMP] = ACTIONS(501),
    [anon_sym_AMP_AMP] = ACTIONS(501),
    [anon_sym_PIPE_PIPE] = ACTIONS(501),
    [anon_sym_BQUOTE] = ACTIONS(501),
    [sym_comment] = ACTIONS(53),
  },
  [442] = {
    [anon_sym_AMP_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(543),
    [anon_sym_RBRACK] = ACTIONS(1860),
    [anon_sym_EQ_TILDE] = ACTIONS(547),
    [anon_sym_EQ_EQ] = ACTIONS(547),
    [anon_sym_EQ] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(543),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(543),
  },
  [443] = {
    [anon_sym_AMP_AMP] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1860),
    [anon_sym_EQ_TILDE] = ACTIONS(575),
    [anon_sym_EQ_EQ] = ACTIONS(575),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(573),
    [anon_sym_GT] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(573),
  },
  [444] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(1862),
    [anon_sym_PLUS_EQ] = ACTIONS(1862),
    [sym_comment] = ACTIONS(53),
  },
  [445] = {
    [aux_sym_concatenation_repeat1] = STATE(873),
    [sym__concat] = ACTIONS(1864),
    [sym_variable_name] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(585),
    [anon_sym_RPAREN] = ACTIONS(583),
    [anon_sym_PIPE_AMP] = ACTIONS(583),
    [anon_sym_AMP_AMP] = ACTIONS(583),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [sym__special_characters] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_DOLLAR] = ACTIONS(585),
    [sym_raw_string] = ACTIONS(583),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(583),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(583),
    [anon_sym_BQUOTE] = ACTIONS(583),
    [anon_sym_LT_LPAREN] = ACTIONS(583),
    [anon_sym_GT_LPAREN] = ACTIONS(583),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(585),
    [sym_word] = ACTIONS(585),
  },
  [446] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(875),
    [anon_sym_DQUOTE] = ACTIONS(1866),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [447] = {
    [sym_string] = STATE(877),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(1868),
    [sym_raw_string] = ACTIONS(1870),
    [anon_sym_POUND] = ACTIONS(1868),
    [anon_sym_DASH] = ACTIONS(1868),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1872),
    [anon_sym_STAR] = ACTIONS(1868),
    [anon_sym_AT] = ACTIONS(1868),
    [anon_sym_QMARK] = ACTIONS(1868),
    [anon_sym_0] = ACTIONS(1874),
    [anon_sym__] = ACTIONS(1874),
  },
  [448] = {
    [aux_sym_concatenation_repeat1] = STATE(873),
    [sym__concat] = ACTIONS(1864),
    [sym_variable_name] = ACTIONS(599),
    [anon_sym_PIPE] = ACTIONS(601),
    [anon_sym_RPAREN] = ACTIONS(599),
    [anon_sym_PIPE_AMP] = ACTIONS(599),
    [anon_sym_AMP_AMP] = ACTIONS(599),
    [anon_sym_PIPE_PIPE] = ACTIONS(599),
    [sym__special_characters] = ACTIONS(599),
    [anon_sym_DQUOTE] = ACTIONS(599),
    [anon_sym_DOLLAR] = ACTIONS(601),
    [sym_raw_string] = ACTIONS(599),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(599),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(599),
    [anon_sym_BQUOTE] = ACTIONS(599),
    [anon_sym_LT_LPAREN] = ACTIONS(599),
    [anon_sym_GT_LPAREN] = ACTIONS(599),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(601),
    [sym_word] = ACTIONS(601),
  },
  [449] = {
    [sym_subscript] = STATE(883),
    [sym_variable_name] = ACTIONS(1876),
    [anon_sym_DOLLAR] = ACTIONS(1878),
    [anon_sym_POUND] = ACTIONS(1880),
    [anon_sym_DASH] = ACTIONS(1878),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1882),
    [anon_sym_STAR] = ACTIONS(1878),
    [anon_sym_AT] = ACTIONS(1878),
    [anon_sym_QMARK] = ACTIONS(1878),
    [anon_sym_0] = ACTIONS(1884),
    [anon_sym__] = ACTIONS(1884),
  },
  [450] = {
    [sym_for_statement] = STATE(884),
    [sym_while_statement] = STATE(884),
    [sym_if_statement] = STATE(884),
    [sym_case_statement] = STATE(884),
    [sym_function_definition] = STATE(884),
    [sym_subshell] = STATE(884),
    [sym_pipeline] = STATE(884),
    [sym_list] = STATE(884),
    [sym_negated_command] = STATE(884),
    [sym_test_command] = STATE(884),
    [sym_declaration_command] = STATE(884),
    [sym_unset_command] = STATE(884),
    [sym_command] = STATE(884),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(885),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [451] = {
    [sym_for_statement] = STATE(886),
    [sym_while_statement] = STATE(886),
    [sym_if_statement] = STATE(886),
    [sym_case_statement] = STATE(886),
    [sym_function_definition] = STATE(886),
    [sym_subshell] = STATE(886),
    [sym_pipeline] = STATE(886),
    [sym_list] = STATE(886),
    [sym_negated_command] = STATE(886),
    [sym_test_command] = STATE(886),
    [sym_declaration_command] = STATE(886),
    [sym_unset_command] = STATE(886),
    [sym_command] = STATE(886),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(887),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [452] = {
    [sym_for_statement] = STATE(888),
    [sym_while_statement] = STATE(888),
    [sym_if_statement] = STATE(888),
    [sym_case_statement] = STATE(888),
    [sym_function_definition] = STATE(888),
    [sym_subshell] = STATE(888),
    [sym_pipeline] = STATE(888),
    [sym_list] = STATE(888),
    [sym_negated_command] = STATE(888),
    [sym_test_command] = STATE(888),
    [sym_declaration_command] = STATE(888),
    [sym_unset_command] = STATE(888),
    [sym_command] = STATE(888),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(889),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [453] = {
    [sym_variable_name] = ACTIONS(613),
    [anon_sym_PIPE] = ACTIONS(615),
    [anon_sym_RPAREN] = ACTIONS(613),
    [anon_sym_PIPE_AMP] = ACTIONS(613),
    [anon_sym_AMP_AMP] = ACTIONS(613),
    [anon_sym_PIPE_PIPE] = ACTIONS(613),
    [sym__special_characters] = ACTIONS(613),
    [anon_sym_DQUOTE] = ACTIONS(613),
    [anon_sym_DOLLAR] = ACTIONS(615),
    [sym_raw_string] = ACTIONS(613),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(613),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(613),
    [anon_sym_BQUOTE] = ACTIONS(613),
    [anon_sym_LT_LPAREN] = ACTIONS(613),
    [anon_sym_GT_LPAREN] = ACTIONS(613),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(615),
    [sym_word] = ACTIONS(615),
  },
  [454] = {
    [anon_sym_EQ] = ACTIONS(1862),
    [anon_sym_PLUS_EQ] = ACTIONS(1862),
    [sym_comment] = ACTIONS(53),
  },
  [455] = {
    [sym_variable_assignment] = STATE(890),
    [sym_subscript] = STATE(454),
    [sym_concatenation] = STATE(890),
    [sym_string] = STATE(448),
    [sym_simple_expansion] = STATE(448),
    [sym_string_expansion] = STATE(448),
    [sym_expansion] = STATE(448),
    [sym_command_substitution] = STATE(448),
    [sym_process_substitution] = STATE(448),
    [aux_sym_declaration_command_repeat1] = STATE(890),
    [sym_variable_name] = ACTIONS(803),
    [anon_sym_PIPE] = ACTIONS(617),
    [anon_sym_RPAREN] = ACTIONS(619),
    [anon_sym_PIPE_AMP] = ACTIONS(619),
    [anon_sym_AMP_AMP] = ACTIONS(619),
    [anon_sym_PIPE_PIPE] = ACTIONS(619),
    [sym__special_characters] = ACTIONS(805),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(811),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(813),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(815),
    [anon_sym_BQUOTE] = ACTIONS(817),
    [anon_sym_LT_LPAREN] = ACTIONS(819),
    [anon_sym_GT_LPAREN] = ACTIONS(819),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(821),
    [sym_word] = ACTIONS(823),
  },
  [456] = {
    [aux_sym_concatenation_repeat1] = STATE(892),
    [sym__concat] = ACTIONS(1886),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_RPAREN] = ACTIONS(625),
    [anon_sym_PIPE_AMP] = ACTIONS(625),
    [anon_sym_AMP_AMP] = ACTIONS(625),
    [anon_sym_PIPE_PIPE] = ACTIONS(625),
    [sym__special_characters] = ACTIONS(625),
    [anon_sym_DQUOTE] = ACTIONS(625),
    [anon_sym_DOLLAR] = ACTIONS(623),
    [sym_raw_string] = ACTIONS(625),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(625),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(625),
    [anon_sym_BQUOTE] = ACTIONS(625),
    [anon_sym_LT_LPAREN] = ACTIONS(625),
    [anon_sym_GT_LPAREN] = ACTIONS(625),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(623),
    [sym_word] = ACTIONS(623),
  },
  [457] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(894),
    [anon_sym_DQUOTE] = ACTIONS(1888),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [458] = {
    [sym_string] = STATE(896),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(1890),
    [sym_raw_string] = ACTIONS(1892),
    [anon_sym_POUND] = ACTIONS(1890),
    [anon_sym_DASH] = ACTIONS(1890),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1894),
    [anon_sym_STAR] = ACTIONS(1890),
    [anon_sym_AT] = ACTIONS(1890),
    [anon_sym_QMARK] = ACTIONS(1890),
    [anon_sym_0] = ACTIONS(1896),
    [anon_sym__] = ACTIONS(1896),
  },
  [459] = {
    [aux_sym_concatenation_repeat1] = STATE(892),
    [sym__concat] = ACTIONS(1886),
    [anon_sym_PIPE] = ACTIONS(639),
    [anon_sym_RPAREN] = ACTIONS(641),
    [anon_sym_PIPE_AMP] = ACTIONS(641),
    [anon_sym_AMP_AMP] = ACTIONS(641),
    [anon_sym_PIPE_PIPE] = ACTIONS(641),
    [sym__special_characters] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(641),
    [anon_sym_DOLLAR] = ACTIONS(639),
    [sym_raw_string] = ACTIONS(641),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(641),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(641),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [anon_sym_LT_LPAREN] = ACTIONS(641),
    [anon_sym_GT_LPAREN] = ACTIONS(641),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(639),
    [sym_word] = ACTIONS(639),
  },
  [460] = {
    [sym_subscript] = STATE(902),
    [sym_variable_name] = ACTIONS(1898),
    [anon_sym_DOLLAR] = ACTIONS(1900),
    [anon_sym_POUND] = ACTIONS(1902),
    [anon_sym_DASH] = ACTIONS(1900),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1904),
    [anon_sym_STAR] = ACTIONS(1900),
    [anon_sym_AT] = ACTIONS(1900),
    [anon_sym_QMARK] = ACTIONS(1900),
    [anon_sym_0] = ACTIONS(1906),
    [anon_sym__] = ACTIONS(1906),
  },
  [461] = {
    [sym_for_statement] = STATE(903),
    [sym_while_statement] = STATE(903),
    [sym_if_statement] = STATE(903),
    [sym_case_statement] = STATE(903),
    [sym_function_definition] = STATE(903),
    [sym_subshell] = STATE(903),
    [sym_pipeline] = STATE(903),
    [sym_list] = STATE(903),
    [sym_negated_command] = STATE(903),
    [sym_test_command] = STATE(903),
    [sym_declaration_command] = STATE(903),
    [sym_unset_command] = STATE(903),
    [sym_command] = STATE(903),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(904),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [462] = {
    [sym_for_statement] = STATE(905),
    [sym_while_statement] = STATE(905),
    [sym_if_statement] = STATE(905),
    [sym_case_statement] = STATE(905),
    [sym_function_definition] = STATE(905),
    [sym_subshell] = STATE(905),
    [sym_pipeline] = STATE(905),
    [sym_list] = STATE(905),
    [sym_negated_command] = STATE(905),
    [sym_test_command] = STATE(905),
    [sym_declaration_command] = STATE(905),
    [sym_unset_command] = STATE(905),
    [sym_command] = STATE(905),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(906),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [463] = {
    [sym_for_statement] = STATE(907),
    [sym_while_statement] = STATE(907),
    [sym_if_statement] = STATE(907),
    [sym_case_statement] = STATE(907),
    [sym_function_definition] = STATE(907),
    [sym_subshell] = STATE(907),
    [sym_pipeline] = STATE(907),
    [sym_list] = STATE(907),
    [sym_negated_command] = STATE(907),
    [sym_test_command] = STATE(907),
    [sym_declaration_command] = STATE(907),
    [sym_unset_command] = STATE(907),
    [sym_command] = STATE(907),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(908),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [464] = {
    [anon_sym_PIPE] = ACTIONS(653),
    [anon_sym_RPAREN] = ACTIONS(655),
    [anon_sym_PIPE_AMP] = ACTIONS(655),
    [anon_sym_AMP_AMP] = ACTIONS(655),
    [anon_sym_PIPE_PIPE] = ACTIONS(655),
    [sym__special_characters] = ACTIONS(655),
    [anon_sym_DQUOTE] = ACTIONS(655),
    [anon_sym_DOLLAR] = ACTIONS(653),
    [sym_raw_string] = ACTIONS(655),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(655),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(655),
    [anon_sym_BQUOTE] = ACTIONS(655),
    [anon_sym_LT_LPAREN] = ACTIONS(655),
    [anon_sym_GT_LPAREN] = ACTIONS(655),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(653),
    [sym_word] = ACTIONS(653),
  },
  [465] = {
    [sym_concatenation] = STATE(909),
    [sym_string] = STATE(459),
    [sym_simple_expansion] = STATE(459),
    [sym_string_expansion] = STATE(459),
    [sym_expansion] = STATE(459),
    [sym_command_substitution] = STATE(459),
    [sym_process_substitution] = STATE(459),
    [aux_sym_unset_command_repeat1] = STATE(909),
    [anon_sym_PIPE] = ACTIONS(657),
    [anon_sym_RPAREN] = ACTIONS(659),
    [anon_sym_PIPE_AMP] = ACTIONS(659),
    [anon_sym_AMP_AMP] = ACTIONS(659),
    [anon_sym_PIPE_PIPE] = ACTIONS(659),
    [sym__special_characters] = ACTIONS(825),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(831),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(833),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(835),
    [anon_sym_BQUOTE] = ACTIONS(837),
    [anon_sym_LT_LPAREN] = ACTIONS(839),
    [anon_sym_GT_LPAREN] = ACTIONS(839),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(841),
    [sym_word] = ACTIONS(843),
  },
  [466] = {
    [sym_string] = STATE(910),
    [sym_simple_expansion] = STATE(910),
    [sym_string_expansion] = STATE(910),
    [sym_expansion] = STATE(910),
    [sym_command_substitution] = STATE(910),
    [sym_process_substitution] = STATE(910),
    [sym__special_characters] = ACTIONS(1908),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(1908),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1908),
  },
  [467] = {
    [aux_sym_concatenation_repeat1] = STATE(911),
    [sym__simple_heredoc_body] = ACTIONS(693),
    [sym__heredoc_body_beginning] = ACTIONS(693),
    [sym_file_descriptor] = ACTIONS(693),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_RPAREN] = ACTIONS(693),
    [anon_sym_PIPE_AMP] = ACTIONS(693),
    [anon_sym_AMP_AMP] = ACTIONS(693),
    [anon_sym_PIPE_PIPE] = ACTIONS(693),
    [anon_sym_EQ_TILDE] = ACTIONS(695),
    [anon_sym_EQ_EQ] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(695),
    [anon_sym_GT] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(693),
    [anon_sym_AMP_GT] = ACTIONS(695),
    [anon_sym_AMP_GT_GT] = ACTIONS(693),
    [anon_sym_LT_AMP] = ACTIONS(693),
    [anon_sym_GT_AMP] = ACTIONS(693),
    [anon_sym_LT_LT] = ACTIONS(695),
    [anon_sym_LT_LT_DASH] = ACTIONS(693),
    [anon_sym_LT_LT_LT] = ACTIONS(693),
    [sym__special_characters] = ACTIONS(693),
    [anon_sym_DQUOTE] = ACTIONS(693),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(693),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(693),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(693),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [anon_sym_LT_LPAREN] = ACTIONS(693),
    [anon_sym_GT_LPAREN] = ACTIONS(693),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(695),
  },
  [468] = {
    [sym__simple_heredoc_body] = ACTIONS(697),
    [sym__heredoc_body_beginning] = ACTIONS(697),
    [sym_file_descriptor] = ACTIONS(697),
    [sym__concat] = ACTIONS(697),
    [anon_sym_PIPE] = ACTIONS(699),
    [anon_sym_RPAREN] = ACTIONS(697),
    [anon_sym_PIPE_AMP] = ACTIONS(697),
    [anon_sym_AMP_AMP] = ACTIONS(697),
    [anon_sym_PIPE_PIPE] = ACTIONS(697),
    [anon_sym_EQ_TILDE] = ACTIONS(699),
    [anon_sym_EQ_EQ] = ACTIONS(699),
    [anon_sym_LT] = ACTIONS(699),
    [anon_sym_GT] = ACTIONS(699),
    [anon_sym_GT_GT] = ACTIONS(697),
    [anon_sym_AMP_GT] = ACTIONS(699),
    [anon_sym_AMP_GT_GT] = ACTIONS(697),
    [anon_sym_LT_AMP] = ACTIONS(697),
    [anon_sym_GT_AMP] = ACTIONS(697),
    [anon_sym_LT_LT] = ACTIONS(699),
    [anon_sym_LT_LT_DASH] = ACTIONS(697),
    [anon_sym_LT_LT_LT] = ACTIONS(697),
    [sym__special_characters] = ACTIONS(697),
    [anon_sym_DQUOTE] = ACTIONS(697),
    [anon_sym_DOLLAR] = ACTIONS(699),
    [sym_raw_string] = ACTIONS(697),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(697),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(697),
    [anon_sym_BQUOTE] = ACTIONS(697),
    [anon_sym_LT_LPAREN] = ACTIONS(697),
    [anon_sym_GT_LPAREN] = ACTIONS(697),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(699),
  },
  [469] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(1910),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [470] = {
    [sym__simple_heredoc_body] = ACTIONS(727),
    [sym__heredoc_body_beginning] = ACTIONS(727),
    [sym_file_descriptor] = ACTIONS(727),
    [sym__concat] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_RPAREN] = ACTIONS(727),
    [anon_sym_PIPE_AMP] = ACTIONS(727),
    [anon_sym_AMP_AMP] = ACTIONS(727),
    [anon_sym_PIPE_PIPE] = ACTIONS(727),
    [anon_sym_EQ_TILDE] = ACTIONS(729),
    [anon_sym_EQ_EQ] = ACTIONS(729),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(727),
    [anon_sym_AMP_GT] = ACTIONS(729),
    [anon_sym_AMP_GT_GT] = ACTIONS(727),
    [anon_sym_LT_AMP] = ACTIONS(727),
    [anon_sym_GT_AMP] = ACTIONS(727),
    [anon_sym_LT_LT] = ACTIONS(729),
    [anon_sym_LT_LT_DASH] = ACTIONS(727),
    [anon_sym_LT_LT_LT] = ACTIONS(727),
    [sym__special_characters] = ACTIONS(727),
    [anon_sym_DQUOTE] = ACTIONS(727),
    [anon_sym_DOLLAR] = ACTIONS(729),
    [sym_raw_string] = ACTIONS(727),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(727),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(727),
    [anon_sym_BQUOTE] = ACTIONS(727),
    [anon_sym_LT_LPAREN] = ACTIONS(727),
    [anon_sym_GT_LPAREN] = ACTIONS(727),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(729),
  },
  [471] = {
    [sym__simple_heredoc_body] = ACTIONS(731),
    [sym__heredoc_body_beginning] = ACTIONS(731),
    [sym_file_descriptor] = ACTIONS(731),
    [sym__concat] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(731),
    [anon_sym_PIPE_AMP] = ACTIONS(731),
    [anon_sym_AMP_AMP] = ACTIONS(731),
    [anon_sym_PIPE_PIPE] = ACTIONS(731),
    [anon_sym_EQ_TILDE] = ACTIONS(733),
    [anon_sym_EQ_EQ] = ACTIONS(733),
    [anon_sym_LT] = ACTIONS(733),
    [anon_sym_GT] = ACTIONS(733),
    [anon_sym_GT_GT] = ACTIONS(731),
    [anon_sym_AMP_GT] = ACTIONS(733),
    [anon_sym_AMP_GT_GT] = ACTIONS(731),
    [anon_sym_LT_AMP] = ACTIONS(731),
    [anon_sym_GT_AMP] = ACTIONS(731),
    [anon_sym_LT_LT] = ACTIONS(733),
    [anon_sym_LT_LT_DASH] = ACTIONS(731),
    [anon_sym_LT_LT_LT] = ACTIONS(731),
    [sym__special_characters] = ACTIONS(731),
    [anon_sym_DQUOTE] = ACTIONS(731),
    [anon_sym_DOLLAR] = ACTIONS(733),
    [sym_raw_string] = ACTIONS(731),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(731),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(731),
    [anon_sym_BQUOTE] = ACTIONS(731),
    [anon_sym_LT_LPAREN] = ACTIONS(731),
    [anon_sym_GT_LPAREN] = ACTIONS(731),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(733),
  },
  [472] = {
    [sym__simple_heredoc_body] = ACTIONS(735),
    [sym__heredoc_body_beginning] = ACTIONS(735),
    [sym_file_descriptor] = ACTIONS(735),
    [sym__concat] = ACTIONS(735),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_RPAREN] = ACTIONS(735),
    [anon_sym_PIPE_AMP] = ACTIONS(735),
    [anon_sym_AMP_AMP] = ACTIONS(735),
    [anon_sym_PIPE_PIPE] = ACTIONS(735),
    [anon_sym_EQ_TILDE] = ACTIONS(737),
    [anon_sym_EQ_EQ] = ACTIONS(737),
    [anon_sym_LT] = ACTIONS(737),
    [anon_sym_GT] = ACTIONS(737),
    [anon_sym_GT_GT] = ACTIONS(735),
    [anon_sym_AMP_GT] = ACTIONS(737),
    [anon_sym_AMP_GT_GT] = ACTIONS(735),
    [anon_sym_LT_AMP] = ACTIONS(735),
    [anon_sym_GT_AMP] = ACTIONS(735),
    [anon_sym_LT_LT] = ACTIONS(737),
    [anon_sym_LT_LT_DASH] = ACTIONS(735),
    [anon_sym_LT_LT_LT] = ACTIONS(735),
    [sym__special_characters] = ACTIONS(735),
    [anon_sym_DQUOTE] = ACTIONS(735),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym_raw_string] = ACTIONS(735),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(735),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(735),
    [anon_sym_BQUOTE] = ACTIONS(735),
    [anon_sym_LT_LPAREN] = ACTIONS(735),
    [anon_sym_GT_LPAREN] = ACTIONS(735),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(737),
  },
  [473] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(1912),
    [sym_comment] = ACTIONS(53),
  },
  [474] = {
    [sym_concatenation] = STATE(916),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(916),
    [anon_sym_RBRACE] = ACTIONS(1914),
    [anon_sym_EQ] = ACTIONS(1916),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1918),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1920),
    [anon_sym_COLON] = ACTIONS(1916),
    [anon_sym_COLON_QMARK] = ACTIONS(1916),
    [anon_sym_COLON_DASH] = ACTIONS(1916),
    [anon_sym_PERCENT] = ACTIONS(1916),
    [anon_sym_DASH] = ACTIONS(1916),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [475] = {
    [sym_subscript] = STATE(920),
    [sym_variable_name] = ACTIONS(1922),
    [anon_sym_DOLLAR] = ACTIONS(1924),
    [anon_sym_DASH] = ACTIONS(1924),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1926),
    [anon_sym_STAR] = ACTIONS(1924),
    [anon_sym_AT] = ACTIONS(1924),
    [anon_sym_QMARK] = ACTIONS(1924),
    [anon_sym_0] = ACTIONS(1928),
    [anon_sym__] = ACTIONS(1928),
  },
  [476] = {
    [sym_concatenation] = STATE(923),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(923),
    [anon_sym_RBRACE] = ACTIONS(1930),
    [anon_sym_EQ] = ACTIONS(1932),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1934),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1936),
    [anon_sym_COLON] = ACTIONS(1932),
    [anon_sym_COLON_QMARK] = ACTIONS(1932),
    [anon_sym_COLON_DASH] = ACTIONS(1932),
    [anon_sym_PERCENT] = ACTIONS(1932),
    [anon_sym_DASH] = ACTIONS(1932),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [477] = {
    [sym_concatenation] = STATE(926),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(926),
    [anon_sym_RBRACE] = ACTIONS(1938),
    [anon_sym_EQ] = ACTIONS(1940),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1942),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(1944),
    [anon_sym_COLON] = ACTIONS(1940),
    [anon_sym_COLON_QMARK] = ACTIONS(1940),
    [anon_sym_COLON_DASH] = ACTIONS(1940),
    [anon_sym_PERCENT] = ACTIONS(1940),
    [anon_sym_DASH] = ACTIONS(1940),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [478] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1946),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [479] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1946),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [480] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(1946),
    [sym_comment] = ACTIONS(53),
  },
  [481] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(1946),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [482] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [483] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(1948),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [484] = {
    [anon_sym_RPAREN] = ACTIONS(1950),
    [sym_comment] = ACTIONS(53),
  },
  [485] = {
    [sym_for_statement] = STATE(930),
    [sym_while_statement] = STATE(930),
    [sym_if_statement] = STATE(930),
    [sym_case_statement] = STATE(930),
    [sym_function_definition] = STATE(930),
    [sym_subshell] = STATE(930),
    [sym_pipeline] = STATE(930),
    [sym_list] = STATE(930),
    [sym_negated_command] = STATE(930),
    [sym_test_command] = STATE(930),
    [sym_declaration_command] = STATE(930),
    [sym_unset_command] = STATE(930),
    [sym_command] = STATE(930),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(931),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [486] = {
    [sym__simple_heredoc_body] = ACTIONS(1952),
    [sym__heredoc_body_beginning] = ACTIONS(1952),
    [sym_file_descriptor] = ACTIONS(1952),
    [sym__concat] = ACTIONS(1952),
    [anon_sym_PIPE] = ACTIONS(1954),
    [anon_sym_RPAREN] = ACTIONS(1954),
    [anon_sym_SEMI_SEMI] = ACTIONS(1954),
    [anon_sym_PIPE_AMP] = ACTIONS(1954),
    [anon_sym_AMP_AMP] = ACTIONS(1954),
    [anon_sym_PIPE_PIPE] = ACTIONS(1954),
    [anon_sym_EQ_TILDE] = ACTIONS(1954),
    [anon_sym_EQ_EQ] = ACTIONS(1954),
    [anon_sym_LT] = ACTIONS(1954),
    [anon_sym_GT] = ACTIONS(1954),
    [anon_sym_GT_GT] = ACTIONS(1954),
    [anon_sym_AMP_GT] = ACTIONS(1954),
    [anon_sym_AMP_GT_GT] = ACTIONS(1954),
    [anon_sym_LT_AMP] = ACTIONS(1954),
    [anon_sym_GT_AMP] = ACTIONS(1954),
    [anon_sym_LT_LT] = ACTIONS(1954),
    [anon_sym_LT_LT_DASH] = ACTIONS(1954),
    [anon_sym_LT_LT_LT] = ACTIONS(1954),
    [sym__special_characters] = ACTIONS(1954),
    [anon_sym_DQUOTE] = ACTIONS(1954),
    [anon_sym_DOLLAR] = ACTIONS(1954),
    [sym_raw_string] = ACTIONS(1954),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1954),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1954),
    [anon_sym_BQUOTE] = ACTIONS(1954),
    [anon_sym_LT_LPAREN] = ACTIONS(1954),
    [anon_sym_GT_LPAREN] = ACTIONS(1954),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1954),
    [anon_sym_SEMI] = ACTIONS(1954),
    [anon_sym_LF] = ACTIONS(1952),
    [anon_sym_AMP] = ACTIONS(1954),
  },
  [487] = {
    [sym_for_statement] = STATE(932),
    [sym_while_statement] = STATE(932),
    [sym_if_statement] = STATE(932),
    [sym_case_statement] = STATE(932),
    [sym_function_definition] = STATE(932),
    [sym_subshell] = STATE(932),
    [sym_pipeline] = STATE(932),
    [sym_list] = STATE(932),
    [sym_negated_command] = STATE(932),
    [sym_test_command] = STATE(932),
    [sym_declaration_command] = STATE(932),
    [sym_unset_command] = STATE(932),
    [sym_command] = STATE(932),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(933),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [488] = {
    [anon_sym_PIPE] = ACTIONS(955),
    [anon_sym_RPAREN] = ACTIONS(957),
    [anon_sym_PIPE_AMP] = ACTIONS(957),
    [anon_sym_AMP_AMP] = ACTIONS(957),
    [anon_sym_PIPE_PIPE] = ACTIONS(957),
    [anon_sym_BQUOTE] = ACTIONS(957),
    [sym_comment] = ACTIONS(53),
  },
  [489] = {
    [sym_simple_expansion] = STATE(935),
    [sym_expansion] = STATE(935),
    [aux_sym_heredoc_body_repeat1] = STATE(935),
    [sym__heredoc_body_middle] = ACTIONS(1956),
    [sym__heredoc_body_end] = ACTIONS(1958),
    [anon_sym_DOLLAR] = ACTIONS(963),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(965),
    [sym_comment] = ACTIONS(53),
  },
  [490] = {
    [anon_sym_LT] = ACTIONS(1960),
    [anon_sym_GT] = ACTIONS(1960),
    [anon_sym_GT_GT] = ACTIONS(1962),
    [anon_sym_AMP_GT] = ACTIONS(1960),
    [anon_sym_AMP_GT_GT] = ACTIONS(1962),
    [anon_sym_LT_AMP] = ACTIONS(1962),
    [anon_sym_GT_AMP] = ACTIONS(1962),
    [sym_comment] = ACTIONS(53),
  },
  [491] = {
    [sym_concatenation] = STATE(939),
    [sym_string] = STATE(938),
    [sym_simple_expansion] = STATE(938),
    [sym_string_expansion] = STATE(938),
    [sym_expansion] = STATE(938),
    [sym_command_substitution] = STATE(938),
    [sym_process_substitution] = STATE(938),
    [sym__special_characters] = ACTIONS(1964),
    [anon_sym_DQUOTE] = ACTIONS(1966),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(1968),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1970),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1972),
    [anon_sym_BQUOTE] = ACTIONS(1974),
    [anon_sym_LT_LPAREN] = ACTIONS(1976),
    [anon_sym_GT_LPAREN] = ACTIONS(1976),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1968),
    [sym_regex] = ACTIONS(1978),
  },
  [492] = {
    [sym_concatenation] = STATE(942),
    [sym_string] = STATE(941),
    [sym_simple_expansion] = STATE(941),
    [sym_string_expansion] = STATE(941),
    [sym_expansion] = STATE(941),
    [sym_command_substitution] = STATE(941),
    [sym_process_substitution] = STATE(941),
    [sym__special_characters] = ACTIONS(1980),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(1982),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1982),
  },
  [493] = {
    [sym_heredoc_start] = ACTIONS(1984),
    [sym_comment] = ACTIONS(53),
  },
  [494] = {
    [sym_concatenation] = STATE(946),
    [sym_string] = STATE(945),
    [sym_simple_expansion] = STATE(945),
    [sym_string_expansion] = STATE(945),
    [sym_expansion] = STATE(945),
    [sym_command_substitution] = STATE(945),
    [sym_process_substitution] = STATE(945),
    [sym__special_characters] = ACTIONS(1986),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(1988),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1988),
  },
  [495] = {
    [aux_sym_concatenation_repeat1] = STATE(467),
    [sym__simple_heredoc_body] = ACTIONS(987),
    [sym__heredoc_body_beginning] = ACTIONS(987),
    [sym_file_descriptor] = ACTIONS(987),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(989),
    [anon_sym_RPAREN] = ACTIONS(987),
    [anon_sym_PIPE_AMP] = ACTIONS(987),
    [anon_sym_AMP_AMP] = ACTIONS(987),
    [anon_sym_PIPE_PIPE] = ACTIONS(987),
    [anon_sym_EQ_TILDE] = ACTIONS(989),
    [anon_sym_EQ_EQ] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(989),
    [anon_sym_GT] = ACTIONS(989),
    [anon_sym_GT_GT] = ACTIONS(987),
    [anon_sym_AMP_GT] = ACTIONS(989),
    [anon_sym_AMP_GT_GT] = ACTIONS(987),
    [anon_sym_LT_AMP] = ACTIONS(987),
    [anon_sym_GT_AMP] = ACTIONS(987),
    [anon_sym_LT_LT] = ACTIONS(989),
    [anon_sym_LT_LT_DASH] = ACTIONS(987),
    [anon_sym_LT_LT_LT] = ACTIONS(987),
    [sym__special_characters] = ACTIONS(987),
    [anon_sym_DQUOTE] = ACTIONS(987),
    [anon_sym_DOLLAR] = ACTIONS(989),
    [sym_raw_string] = ACTIONS(987),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(987),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(987),
    [anon_sym_BQUOTE] = ACTIONS(987),
    [anon_sym_LT_LPAREN] = ACTIONS(987),
    [anon_sym_GT_LPAREN] = ACTIONS(987),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(989),
  },
  [496] = {
    [aux_sym_concatenation_repeat1] = STATE(467),
    [sym__simple_heredoc_body] = ACTIONS(991),
    [sym__heredoc_body_beginning] = ACTIONS(991),
    [sym_file_descriptor] = ACTIONS(991),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(993),
    [anon_sym_RPAREN] = ACTIONS(991),
    [anon_sym_PIPE_AMP] = ACTIONS(991),
    [anon_sym_AMP_AMP] = ACTIONS(991),
    [anon_sym_PIPE_PIPE] = ACTIONS(991),
    [anon_sym_EQ_TILDE] = ACTIONS(993),
    [anon_sym_EQ_EQ] = ACTIONS(993),
    [anon_sym_LT] = ACTIONS(993),
    [anon_sym_GT] = ACTIONS(993),
    [anon_sym_GT_GT] = ACTIONS(991),
    [anon_sym_AMP_GT] = ACTIONS(993),
    [anon_sym_AMP_GT_GT] = ACTIONS(991),
    [anon_sym_LT_AMP] = ACTIONS(991),
    [anon_sym_GT_AMP] = ACTIONS(991),
    [anon_sym_LT_LT] = ACTIONS(993),
    [anon_sym_LT_LT_DASH] = ACTIONS(991),
    [anon_sym_LT_LT_LT] = ACTIONS(991),
    [sym__special_characters] = ACTIONS(991),
    [anon_sym_DQUOTE] = ACTIONS(991),
    [anon_sym_DOLLAR] = ACTIONS(993),
    [sym_raw_string] = ACTIONS(991),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(991),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(991),
    [anon_sym_BQUOTE] = ACTIONS(991),
    [anon_sym_LT_LPAREN] = ACTIONS(991),
    [anon_sym_GT_LPAREN] = ACTIONS(991),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(993),
  },
  [497] = {
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(997),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_BQUOTE] = ACTIONS(997),
    [sym_comment] = ACTIONS(53),
  },
  [498] = {
    [sym_file_redirect] = STATE(948),
    [sym_heredoc_redirect] = STATE(948),
    [sym_heredoc_body] = STATE(947),
    [sym_herestring_redirect] = STATE(948),
    [aux_sym_while_statement_repeat1] = STATE(948),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(881),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(997),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(893),
    [sym_comment] = ACTIONS(53),
  },
  [499] = {
    [sym_file_redirect] = STATE(949),
    [sym_heredoc_redirect] = STATE(949),
    [sym_heredoc_body] = STATE(947),
    [sym_herestring_redirect] = STATE(949),
    [sym_concatenation] = STATE(950),
    [sym_string] = STATE(496),
    [sym_simple_expansion] = STATE(496),
    [sym_string_expansion] = STATE(496),
    [sym_expansion] = STATE(496),
    [sym_command_substitution] = STATE(496),
    [sym_process_substitution] = STATE(496),
    [aux_sym_while_statement_repeat1] = STATE(949),
    [aux_sym_command_repeat2] = STATE(950),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(881),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(997),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_EQ_TILDE] = ACTIONS(883),
    [anon_sym_EQ_EQ] = ACTIONS(883),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(893),
    [sym__special_characters] = ACTIONS(895),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(897),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(899),
  },
  [500] = {
    [sym_file_redirect] = STATE(949),
    [sym_heredoc_redirect] = STATE(949),
    [sym_heredoc_body] = STATE(947),
    [sym_herestring_redirect] = STATE(949),
    [sym_concatenation] = STATE(951),
    [sym_string] = STATE(496),
    [sym_simple_expansion] = STATE(496),
    [sym_string_expansion] = STATE(496),
    [sym_expansion] = STATE(496),
    [sym_command_substitution] = STATE(496),
    [sym_process_substitution] = STATE(496),
    [aux_sym_while_statement_repeat1] = STATE(949),
    [aux_sym_command_repeat2] = STATE(951),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(881),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_RPAREN] = ACTIONS(997),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_EQ_TILDE] = ACTIONS(883),
    [anon_sym_EQ_EQ] = ACTIONS(883),
    [anon_sym_LT] = ACTIONS(885),
    [anon_sym_GT] = ACTIONS(885),
    [anon_sym_GT_GT] = ACTIONS(887),
    [anon_sym_AMP_GT] = ACTIONS(885),
    [anon_sym_AMP_GT_GT] = ACTIONS(887),
    [anon_sym_LT_AMP] = ACTIONS(887),
    [anon_sym_GT_AMP] = ACTIONS(887),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(893),
    [sym__special_characters] = ACTIONS(895),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(897),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(899),
  },
  [501] = {
    [sym_concatenation] = STATE(672),
    [sym_string] = STATE(953),
    [sym_array] = STATE(672),
    [sym_simple_expansion] = STATE(953),
    [sym_string_expansion] = STATE(953),
    [sym_expansion] = STATE(953),
    [sym_command_substitution] = STATE(953),
    [sym_process_substitution] = STATE(953),
    [sym__empty_value] = ACTIONS(1291),
    [anon_sym_LPAREN] = ACTIONS(1293),
    [sym__special_characters] = ACTIONS(1990),
    [anon_sym_DQUOTE] = ACTIONS(207),
    [anon_sym_DOLLAR] = ACTIONS(209),
    [sym_raw_string] = ACTIONS(1992),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(213),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(215),
    [anon_sym_BQUOTE] = ACTIONS(217),
    [anon_sym_LT_LPAREN] = ACTIONS(219),
    [anon_sym_GT_LPAREN] = ACTIONS(219),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1992),
  },
  [502] = {
    [sym_do_group] = STATE(954),
    [anon_sym_do] = ACTIONS(1834),
    [sym_comment] = ACTIONS(53),
  },
  [503] = {
    [sym_compound_statement] = STATE(956),
    [anon_sym_LPAREN] = ACTIONS(1994),
    [anon_sym_LBRACE] = ACTIONS(1852),
    [sym_comment] = ACTIONS(53),
  },
  [504] = {
    [anon_sym_AMP_AMP] = ACTIONS(543),
    [anon_sym_PIPE_PIPE] = ACTIONS(543),
    [anon_sym_RBRACK] = ACTIONS(1996),
    [anon_sym_EQ_TILDE] = ACTIONS(547),
    [anon_sym_EQ_EQ] = ACTIONS(547),
    [anon_sym_EQ] = ACTIONS(549),
    [anon_sym_LT] = ACTIONS(543),
    [anon_sym_GT] = ACTIONS(543),
    [anon_sym_BANG_EQ] = ACTIONS(543),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(543),
  },
  [505] = {
    [anon_sym_AMP_AMP] = ACTIONS(573),
    [anon_sym_PIPE_PIPE] = ACTIONS(573),
    [anon_sym_RBRACK_RBRACK] = ACTIONS(1996),
    [anon_sym_EQ_TILDE] = ACTIONS(575),
    [anon_sym_EQ_EQ] = ACTIONS(575),
    [anon_sym_EQ] = ACTIONS(577),
    [anon_sym_LT] = ACTIONS(573),
    [anon_sym_GT] = ACTIONS(573),
    [anon_sym_BANG_EQ] = ACTIONS(573),
    [sym_comment] = ACTIONS(53),
    [sym_test_operator] = ACTIONS(573),
  },
  [506] = {
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_EQ] = ACTIONS(1998),
    [anon_sym_PLUS_EQ] = ACTIONS(1998),
    [sym_comment] = ACTIONS(53),
  },
  [507] = {
    [aux_sym_concatenation_repeat1] = STATE(959),
    [sym__concat] = ACTIONS(1864),
    [sym_variable_name] = ACTIONS(583),
    [anon_sym_PIPE] = ACTIONS(585),
    [anon_sym_PIPE_AMP] = ACTIONS(583),
    [anon_sym_AMP_AMP] = ACTIONS(583),
    [anon_sym_PIPE_PIPE] = ACTIONS(583),
    [sym__special_characters] = ACTIONS(583),
    [anon_sym_DQUOTE] = ACTIONS(583),
    [anon_sym_DOLLAR] = ACTIONS(585),
    [sym_raw_string] = ACTIONS(583),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(583),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(583),
    [anon_sym_BQUOTE] = ACTIONS(583),
    [anon_sym_LT_LPAREN] = ACTIONS(583),
    [anon_sym_GT_LPAREN] = ACTIONS(583),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(585),
    [sym_word] = ACTIONS(585),
  },
  [508] = {
    [aux_sym_concatenation_repeat1] = STATE(959),
    [sym__concat] = ACTIONS(1864),
    [sym_variable_name] = ACTIONS(599),
    [anon_sym_PIPE] = ACTIONS(601),
    [anon_sym_PIPE_AMP] = ACTIONS(599),
    [anon_sym_AMP_AMP] = ACTIONS(599),
    [anon_sym_PIPE_PIPE] = ACTIONS(599),
    [sym__special_characters] = ACTIONS(599),
    [anon_sym_DQUOTE] = ACTIONS(599),
    [anon_sym_DOLLAR] = ACTIONS(601),
    [sym_raw_string] = ACTIONS(599),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(599),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(599),
    [anon_sym_BQUOTE] = ACTIONS(599),
    [anon_sym_LT_LPAREN] = ACTIONS(599),
    [anon_sym_GT_LPAREN] = ACTIONS(599),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(601),
    [sym_word] = ACTIONS(601),
  },
  [509] = {
    [anon_sym_EQ] = ACTIONS(1998),
    [anon_sym_PLUS_EQ] = ACTIONS(1998),
    [sym_comment] = ACTIONS(53),
  },
  [510] = {
    [sym_variable_assignment] = STATE(960),
    [sym_subscript] = STATE(509),
    [sym_concatenation] = STATE(960),
    [sym_string] = STATE(508),
    [sym_simple_expansion] = STATE(508),
    [sym_string_expansion] = STATE(508),
    [sym_expansion] = STATE(508),
    [sym_command_substitution] = STATE(508),
    [sym_process_substitution] = STATE(508),
    [aux_sym_declaration_command_repeat1] = STATE(960),
    [sym_variable_name] = ACTIONS(907),
    [anon_sym_PIPE] = ACTIONS(617),
    [anon_sym_PIPE_AMP] = ACTIONS(619),
    [anon_sym_AMP_AMP] = ACTIONS(619),
    [anon_sym_PIPE_PIPE] = ACTIONS(619),
    [sym__special_characters] = ACTIONS(909),
    [anon_sym_DQUOTE] = ACTIONS(807),
    [anon_sym_DOLLAR] = ACTIONS(809),
    [sym_raw_string] = ACTIONS(911),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(813),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(815),
    [anon_sym_BQUOTE] = ACTIONS(619),
    [anon_sym_LT_LPAREN] = ACTIONS(819),
    [anon_sym_GT_LPAREN] = ACTIONS(819),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(821),
    [sym_word] = ACTIONS(913),
  },
  [511] = {
    [aux_sym_concatenation_repeat1] = STATE(961),
    [sym__concat] = ACTIONS(1886),
    [anon_sym_PIPE] = ACTIONS(623),
    [anon_sym_PIPE_AMP] = ACTIONS(625),
    [anon_sym_AMP_AMP] = ACTIONS(625),
    [anon_sym_PIPE_PIPE] = ACTIONS(625),
    [sym__special_characters] = ACTIONS(625),
    [anon_sym_DQUOTE] = ACTIONS(625),
    [anon_sym_DOLLAR] = ACTIONS(623),
    [sym_raw_string] = ACTIONS(625),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(625),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(625),
    [anon_sym_BQUOTE] = ACTIONS(625),
    [anon_sym_LT_LPAREN] = ACTIONS(625),
    [anon_sym_GT_LPAREN] = ACTIONS(625),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(623),
    [sym_word] = ACTIONS(623),
  },
  [512] = {
    [aux_sym_concatenation_repeat1] = STATE(961),
    [sym__concat] = ACTIONS(1886),
    [anon_sym_PIPE] = ACTIONS(639),
    [anon_sym_PIPE_AMP] = ACTIONS(641),
    [anon_sym_AMP_AMP] = ACTIONS(641),
    [anon_sym_PIPE_PIPE] = ACTIONS(641),
    [sym__special_characters] = ACTIONS(641),
    [anon_sym_DQUOTE] = ACTIONS(641),
    [anon_sym_DOLLAR] = ACTIONS(639),
    [sym_raw_string] = ACTIONS(641),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(641),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(641),
    [anon_sym_BQUOTE] = ACTIONS(641),
    [anon_sym_LT_LPAREN] = ACTIONS(641),
    [anon_sym_GT_LPAREN] = ACTIONS(641),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(639),
    [sym_word] = ACTIONS(639),
  },
  [513] = {
    [sym_concatenation] = STATE(962),
    [sym_string] = STATE(512),
    [sym_simple_expansion] = STATE(512),
    [sym_string_expansion] = STATE(512),
    [sym_expansion] = STATE(512),
    [sym_command_substitution] = STATE(512),
    [sym_process_substitution] = STATE(512),
    [aux_sym_unset_command_repeat1] = STATE(962),
    [anon_sym_PIPE] = ACTIONS(657),
    [anon_sym_PIPE_AMP] = ACTIONS(659),
    [anon_sym_AMP_AMP] = ACTIONS(659),
    [anon_sym_PIPE_PIPE] = ACTIONS(659),
    [sym__special_characters] = ACTIONS(915),
    [anon_sym_DQUOTE] = ACTIONS(827),
    [anon_sym_DOLLAR] = ACTIONS(829),
    [sym_raw_string] = ACTIONS(917),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(833),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(835),
    [anon_sym_BQUOTE] = ACTIONS(659),
    [anon_sym_LT_LPAREN] = ACTIONS(839),
    [anon_sym_GT_LPAREN] = ACTIONS(839),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(841),
    [sym_word] = ACTIONS(919),
  },
  [514] = {
    [aux_sym_concatenation_repeat1] = STATE(963),
    [sym__simple_heredoc_body] = ACTIONS(693),
    [sym__heredoc_body_beginning] = ACTIONS(693),
    [sym_file_descriptor] = ACTIONS(693),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(693),
    [anon_sym_AMP_AMP] = ACTIONS(693),
    [anon_sym_PIPE_PIPE] = ACTIONS(693),
    [anon_sym_EQ_TILDE] = ACTIONS(695),
    [anon_sym_EQ_EQ] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(695),
    [anon_sym_GT] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(693),
    [anon_sym_AMP_GT] = ACTIONS(695),
    [anon_sym_AMP_GT_GT] = ACTIONS(693),
    [anon_sym_LT_AMP] = ACTIONS(693),
    [anon_sym_GT_AMP] = ACTIONS(693),
    [anon_sym_LT_LT] = ACTIONS(695),
    [anon_sym_LT_LT_DASH] = ACTIONS(693),
    [anon_sym_LT_LT_LT] = ACTIONS(693),
    [sym__special_characters] = ACTIONS(693),
    [anon_sym_DQUOTE] = ACTIONS(693),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(693),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(693),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(693),
    [anon_sym_BQUOTE] = ACTIONS(693),
    [anon_sym_LT_LPAREN] = ACTIONS(693),
    [anon_sym_GT_LPAREN] = ACTIONS(693),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(695),
  },
  [515] = {
    [anon_sym_RPAREN] = ACTIONS(2000),
    [sym_comment] = ACTIONS(53),
  },
  [516] = {
    [sym_for_statement] = STATE(930),
    [sym_while_statement] = STATE(930),
    [sym_if_statement] = STATE(930),
    [sym_case_statement] = STATE(930),
    [sym_function_definition] = STATE(930),
    [sym_subshell] = STATE(930),
    [sym_pipeline] = STATE(930),
    [sym_list] = STATE(930),
    [sym_negated_command] = STATE(930),
    [sym_test_command] = STATE(930),
    [sym_declaration_command] = STATE(930),
    [sym_unset_command] = STATE(930),
    [sym_command] = STATE(930),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(965),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [517] = {
    [sym_for_statement] = STATE(966),
    [sym_while_statement] = STATE(966),
    [sym_if_statement] = STATE(966),
    [sym_case_statement] = STATE(966),
    [sym_function_definition] = STATE(966),
    [sym_subshell] = STATE(966),
    [sym_pipeline] = STATE(966),
    [sym_list] = STATE(966),
    [sym_negated_command] = STATE(966),
    [sym_test_command] = STATE(966),
    [sym_declaration_command] = STATE(966),
    [sym_unset_command] = STATE(966),
    [sym_command] = STATE(966),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(967),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [518] = {
    [anon_sym_LT] = ACTIONS(2002),
    [anon_sym_GT] = ACTIONS(2002),
    [anon_sym_GT_GT] = ACTIONS(2004),
    [anon_sym_AMP_GT] = ACTIONS(2002),
    [anon_sym_AMP_GT_GT] = ACTIONS(2004),
    [anon_sym_LT_AMP] = ACTIONS(2004),
    [anon_sym_GT_AMP] = ACTIONS(2004),
    [sym_comment] = ACTIONS(53),
  },
  [519] = {
    [sym_concatenation] = STATE(939),
    [sym_string] = STATE(970),
    [sym_simple_expansion] = STATE(970),
    [sym_string_expansion] = STATE(970),
    [sym_expansion] = STATE(970),
    [sym_command_substitution] = STATE(970),
    [sym_process_substitution] = STATE(970),
    [sym__special_characters] = ACTIONS(2006),
    [anon_sym_DQUOTE] = ACTIONS(1966),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(2008),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1970),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1972),
    [anon_sym_BQUOTE] = ACTIONS(1974),
    [anon_sym_LT_LPAREN] = ACTIONS(1976),
    [anon_sym_GT_LPAREN] = ACTIONS(1976),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2008),
    [sym_regex] = ACTIONS(1978),
  },
  [520] = {
    [sym_concatenation] = STATE(942),
    [sym_string] = STATE(972),
    [sym_simple_expansion] = STATE(972),
    [sym_string_expansion] = STATE(972),
    [sym_expansion] = STATE(972),
    [sym_command_substitution] = STATE(972),
    [sym_process_substitution] = STATE(972),
    [sym__special_characters] = ACTIONS(2010),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(2012),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2012),
  },
  [521] = {
    [sym_concatenation] = STATE(946),
    [sym_string] = STATE(974),
    [sym_simple_expansion] = STATE(974),
    [sym_string_expansion] = STATE(974),
    [sym_expansion] = STATE(974),
    [sym_command_substitution] = STATE(974),
    [sym_process_substitution] = STATE(974),
    [sym__special_characters] = ACTIONS(2014),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(2016),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2016),
  },
  [522] = {
    [aux_sym_concatenation_repeat1] = STATE(514),
    [sym__simple_heredoc_body] = ACTIONS(987),
    [sym__heredoc_body_beginning] = ACTIONS(987),
    [sym_file_descriptor] = ACTIONS(987),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(989),
    [anon_sym_PIPE_AMP] = ACTIONS(987),
    [anon_sym_AMP_AMP] = ACTIONS(987),
    [anon_sym_PIPE_PIPE] = ACTIONS(987),
    [anon_sym_EQ_TILDE] = ACTIONS(989),
    [anon_sym_EQ_EQ] = ACTIONS(989),
    [anon_sym_LT] = ACTIONS(989),
    [anon_sym_GT] = ACTIONS(989),
    [anon_sym_GT_GT] = ACTIONS(987),
    [anon_sym_AMP_GT] = ACTIONS(989),
    [anon_sym_AMP_GT_GT] = ACTIONS(987),
    [anon_sym_LT_AMP] = ACTIONS(987),
    [anon_sym_GT_AMP] = ACTIONS(987),
    [anon_sym_LT_LT] = ACTIONS(989),
    [anon_sym_LT_LT_DASH] = ACTIONS(987),
    [anon_sym_LT_LT_LT] = ACTIONS(987),
    [sym__special_characters] = ACTIONS(987),
    [anon_sym_DQUOTE] = ACTIONS(987),
    [anon_sym_DOLLAR] = ACTIONS(989),
    [sym_raw_string] = ACTIONS(987),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(987),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(987),
    [anon_sym_BQUOTE] = ACTIONS(987),
    [anon_sym_LT_LPAREN] = ACTIONS(987),
    [anon_sym_GT_LPAREN] = ACTIONS(987),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(989),
  },
  [523] = {
    [aux_sym_concatenation_repeat1] = STATE(514),
    [sym__simple_heredoc_body] = ACTIONS(991),
    [sym__heredoc_body_beginning] = ACTIONS(991),
    [sym_file_descriptor] = ACTIONS(991),
    [sym__concat] = ACTIONS(845),
    [anon_sym_PIPE] = ACTIONS(993),
    [anon_sym_PIPE_AMP] = ACTIONS(991),
    [anon_sym_AMP_AMP] = ACTIONS(991),
    [anon_sym_PIPE_PIPE] = ACTIONS(991),
    [anon_sym_EQ_TILDE] = ACTIONS(993),
    [anon_sym_EQ_EQ] = ACTIONS(993),
    [anon_sym_LT] = ACTIONS(993),
    [anon_sym_GT] = ACTIONS(993),
    [anon_sym_GT_GT] = ACTIONS(991),
    [anon_sym_AMP_GT] = ACTIONS(993),
    [anon_sym_AMP_GT_GT] = ACTIONS(991),
    [anon_sym_LT_AMP] = ACTIONS(991),
    [anon_sym_GT_AMP] = ACTIONS(991),
    [anon_sym_LT_LT] = ACTIONS(993),
    [anon_sym_LT_LT_DASH] = ACTIONS(991),
    [anon_sym_LT_LT_LT] = ACTIONS(991),
    [sym__special_characters] = ACTIONS(991),
    [anon_sym_DQUOTE] = ACTIONS(991),
    [anon_sym_DOLLAR] = ACTIONS(993),
    [sym_raw_string] = ACTIONS(991),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(991),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(991),
    [anon_sym_BQUOTE] = ACTIONS(991),
    [anon_sym_LT_LPAREN] = ACTIONS(991),
    [anon_sym_GT_LPAREN] = ACTIONS(991),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(993),
  },
  [524] = {
    [sym_file_redirect] = STATE(975),
    [sym_heredoc_redirect] = STATE(975),
    [sym_heredoc_body] = STATE(947),
    [sym_herestring_redirect] = STATE(975),
    [aux_sym_while_statement_repeat1] = STATE(975),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(929),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_LT] = ACTIONS(933),
    [anon_sym_GT] = ACTIONS(933),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_AMP_GT] = ACTIONS(933),
    [anon_sym_AMP_GT_GT] = ACTIONS(935),
    [anon_sym_LT_AMP] = ACTIONS(935),
    [anon_sym_GT_AMP] = ACTIONS(935),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(937),
    [anon_sym_BQUOTE] = ACTIONS(997),
    [sym_comment] = ACTIONS(53),
  },
  [525] = {
    [sym_file_redirect] = STATE(976),
    [sym_heredoc_redirect] = STATE(976),
    [sym_heredoc_body] = STATE(947),
    [sym_herestring_redirect] = STATE(976),
    [sym_concatenation] = STATE(977),
    [sym_string] = STATE(523),
    [sym_simple_expansion] = STATE(523),
    [sym_string_expansion] = STATE(523),
    [sym_expansion] = STATE(523),
    [sym_command_substitution] = STATE(523),
    [sym_process_substitution] = STATE(523),
    [aux_sym_while_statement_repeat1] = STATE(976),
    [aux_sym_command_repeat2] = STATE(977),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(929),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_EQ_TILDE] = ACTIONS(931),
    [anon_sym_EQ_EQ] = ACTIONS(931),
    [anon_sym_LT] = ACTIONS(933),
    [anon_sym_GT] = ACTIONS(933),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_AMP_GT] = ACTIONS(933),
    [anon_sym_AMP_GT_GT] = ACTIONS(935),
    [anon_sym_LT_AMP] = ACTIONS(935),
    [anon_sym_GT_AMP] = ACTIONS(935),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(937),
    [sym__special_characters] = ACTIONS(939),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(941),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(997),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(943),
  },
  [526] = {
    [sym_file_redirect] = STATE(976),
    [sym_heredoc_redirect] = STATE(976),
    [sym_heredoc_body] = STATE(947),
    [sym_herestring_redirect] = STATE(976),
    [sym_concatenation] = STATE(978),
    [sym_string] = STATE(523),
    [sym_simple_expansion] = STATE(523),
    [sym_string_expansion] = STATE(523),
    [sym_expansion] = STATE(523),
    [sym_command_substitution] = STATE(523),
    [sym_process_substitution] = STATE(523),
    [aux_sym_while_statement_repeat1] = STATE(976),
    [aux_sym_command_repeat2] = STATE(978),
    [sym__simple_heredoc_body] = ACTIONS(877),
    [sym__heredoc_body_beginning] = ACTIONS(879),
    [sym_file_descriptor] = ACTIONS(929),
    [anon_sym_PIPE] = ACTIONS(995),
    [anon_sym_PIPE_AMP] = ACTIONS(997),
    [anon_sym_AMP_AMP] = ACTIONS(997),
    [anon_sym_PIPE_PIPE] = ACTIONS(997),
    [anon_sym_EQ_TILDE] = ACTIONS(931),
    [anon_sym_EQ_EQ] = ACTIONS(931),
    [anon_sym_LT] = ACTIONS(933),
    [anon_sym_GT] = ACTIONS(933),
    [anon_sym_GT_GT] = ACTIONS(935),
    [anon_sym_AMP_GT] = ACTIONS(933),
    [anon_sym_AMP_GT_GT] = ACTIONS(935),
    [anon_sym_LT_AMP] = ACTIONS(935),
    [anon_sym_GT_AMP] = ACTIONS(935),
    [anon_sym_LT_LT] = ACTIONS(889),
    [anon_sym_LT_LT_DASH] = ACTIONS(891),
    [anon_sym_LT_LT_LT] = ACTIONS(937),
    [sym__special_characters] = ACTIONS(939),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(941),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(997),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(943),
  },
  [527] = {
    [sym__simple_heredoc_body] = ACTIONS(2018),
    [sym__heredoc_body_beginning] = ACTIONS(2018),
    [sym_file_descriptor] = ACTIONS(2018),
    [sym__concat] = ACTIONS(2018),
    [anon_sym_PIPE] = ACTIONS(2020),
    [anon_sym_RPAREN] = ACTIONS(2020),
    [anon_sym_SEMI_SEMI] = ACTIONS(2020),
    [anon_sym_PIPE_AMP] = ACTIONS(2020),
    [anon_sym_AMP_AMP] = ACTIONS(2020),
    [anon_sym_PIPE_PIPE] = ACTIONS(2020),
    [anon_sym_EQ_TILDE] = ACTIONS(2020),
    [anon_sym_EQ_EQ] = ACTIONS(2020),
    [anon_sym_LT] = ACTIONS(2020),
    [anon_sym_GT] = ACTIONS(2020),
    [anon_sym_GT_GT] = ACTIONS(2020),
    [anon_sym_AMP_GT] = ACTIONS(2020),
    [anon_sym_AMP_GT_GT] = ACTIONS(2020),
    [anon_sym_LT_AMP] = ACTIONS(2020),
    [anon_sym_GT_AMP] = ACTIONS(2020),
    [anon_sym_LT_LT] = ACTIONS(2020),
    [anon_sym_LT_LT_DASH] = ACTIONS(2020),
    [anon_sym_LT_LT_LT] = ACTIONS(2020),
    [sym__special_characters] = ACTIONS(2020),
    [anon_sym_DQUOTE] = ACTIONS(2020),
    [anon_sym_DOLLAR] = ACTIONS(2020),
    [sym_raw_string] = ACTIONS(2020),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2020),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2020),
    [anon_sym_BQUOTE] = ACTIONS(2020),
    [anon_sym_LT_LPAREN] = ACTIONS(2020),
    [anon_sym_GT_LPAREN] = ACTIONS(2020),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2020),
    [anon_sym_SEMI] = ACTIONS(2020),
    [anon_sym_LF] = ACTIONS(2018),
    [anon_sym_AMP] = ACTIONS(2020),
  },
  [528] = {
    [sym_compound_statement] = STATE(979),
    [anon_sym_LBRACE] = ACTIONS(455),
    [sym_comment] = ACTIONS(53),
  },
  [529] = {
    [anon_sym_esac] = ACTIONS(2022),
    [anon_sym_PIPE] = ACTIONS(2022),
    [anon_sym_RPAREN] = ACTIONS(2022),
    [anon_sym_SEMI_SEMI] = ACTIONS(2022),
    [anon_sym_PIPE_AMP] = ACTIONS(2022),
    [anon_sym_AMP_AMP] = ACTIONS(2022),
    [anon_sym_PIPE_PIPE] = ACTIONS(2022),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2022),
    [anon_sym_LF] = ACTIONS(2024),
    [anon_sym_AMP] = ACTIONS(2022),
  },
  [530] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(2022),
    [anon_sym_RPAREN] = ACTIONS(2022),
    [anon_sym_SEMI_SEMI] = ACTIONS(2022),
    [anon_sym_PIPE_AMP] = ACTIONS(2022),
    [anon_sym_AMP_AMP] = ACTIONS(2022),
    [anon_sym_PIPE_PIPE] = ACTIONS(2022),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(2022),
    [anon_sym_LF] = ACTIONS(2024),
    [anon_sym_AMP] = ACTIONS(2022),
  },
  [531] = {
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2026),
    [anon_sym_LF] = ACTIONS(2028),
    [anon_sym_AMP] = ACTIONS(2026),
  },
  [532] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(2026),
    [anon_sym_LF] = ACTIONS(2028),
    [anon_sym_AMP] = ACTIONS(2026),
  },
  [533] = {
    [anon_sym_esac] = ACTIONS(2030),
    [anon_sym_PIPE] = ACTIONS(2030),
    [anon_sym_RPAREN] = ACTIONS(2030),
    [anon_sym_SEMI_SEMI] = ACTIONS(2030),
    [anon_sym_PIPE_AMP] = ACTIONS(2030),
    [anon_sym_AMP_AMP] = ACTIONS(2030),
    [anon_sym_PIPE_PIPE] = ACTIONS(2030),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2030),
    [anon_sym_LF] = ACTIONS(2032),
    [anon_sym_AMP] = ACTIONS(2030),
  },
  [534] = {
    [anon_sym_DOLLAR] = ACTIONS(2034),
    [anon_sym_POUND] = ACTIONS(2034),
    [anon_sym_DASH] = ACTIONS(2034),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2036),
    [anon_sym_STAR] = ACTIONS(2034),
    [anon_sym_AT] = ACTIONS(2034),
    [anon_sym_QMARK] = ACTIONS(2034),
    [anon_sym_0] = ACTIONS(2038),
    [anon_sym__] = ACTIONS(2038),
  },
  [535] = {
    [sym_subscript] = STATE(986),
    [sym_variable_name] = ACTIONS(2040),
    [anon_sym_DOLLAR] = ACTIONS(2042),
    [anon_sym_POUND] = ACTIONS(2044),
    [anon_sym_DASH] = ACTIONS(2042),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2046),
    [anon_sym_STAR] = ACTIONS(2042),
    [anon_sym_AT] = ACTIONS(2042),
    [anon_sym_QMARK] = ACTIONS(2042),
    [anon_sym_0] = ACTIONS(2048),
    [anon_sym__] = ACTIONS(2048),
  },
  [536] = {
    [sym_simple_expansion] = STATE(988),
    [sym_expansion] = STATE(988),
    [aux_sym_heredoc_body_repeat1] = STATE(988),
    [sym__heredoc_body_middle] = ACTIONS(2050),
    [sym__heredoc_body_end] = ACTIONS(2052),
    [anon_sym_DOLLAR] = ACTIONS(963),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(965),
    [sym_comment] = ACTIONS(53),
  },
  [537] = {
    [sym_concatenation] = STATE(991),
    [sym_string] = STATE(990),
    [sym_simple_expansion] = STATE(990),
    [sym_string_expansion] = STATE(990),
    [sym_expansion] = STATE(990),
    [sym_command_substitution] = STATE(990),
    [sym_process_substitution] = STATE(990),
    [sym__special_characters] = ACTIONS(2054),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(2056),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2056),
  },
  [538] = {
    [aux_sym_concatenation_repeat1] = STATE(126),
    [sym__simple_heredoc_body] = ACTIONS(2058),
    [sym__heredoc_body_beginning] = ACTIONS(2058),
    [sym_file_descriptor] = ACTIONS(2058),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(2060),
    [anon_sym_SEMI_SEMI] = ACTIONS(2060),
    [anon_sym_PIPE_AMP] = ACTIONS(2060),
    [anon_sym_AMP_AMP] = ACTIONS(2060),
    [anon_sym_PIPE_PIPE] = ACTIONS(2060),
    [anon_sym_EQ_TILDE] = ACTIONS(2060),
    [anon_sym_EQ_EQ] = ACTIONS(2060),
    [anon_sym_LT] = ACTIONS(2060),
    [anon_sym_GT] = ACTIONS(2060),
    [anon_sym_GT_GT] = ACTIONS(2060),
    [anon_sym_AMP_GT] = ACTIONS(2060),
    [anon_sym_AMP_GT_GT] = ACTIONS(2060),
    [anon_sym_LT_AMP] = ACTIONS(2060),
    [anon_sym_GT_AMP] = ACTIONS(2060),
    [anon_sym_LT_LT] = ACTIONS(2060),
    [anon_sym_LT_LT_DASH] = ACTIONS(2060),
    [anon_sym_LT_LT_LT] = ACTIONS(2060),
    [sym__special_characters] = ACTIONS(2060),
    [anon_sym_DQUOTE] = ACTIONS(2060),
    [anon_sym_DOLLAR] = ACTIONS(2060),
    [sym_raw_string] = ACTIONS(2060),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2060),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2060),
    [anon_sym_BQUOTE] = ACTIONS(2060),
    [anon_sym_LT_LPAREN] = ACTIONS(2060),
    [anon_sym_GT_LPAREN] = ACTIONS(2060),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2060),
    [anon_sym_SEMI] = ACTIONS(2060),
    [anon_sym_LF] = ACTIONS(2058),
    [anon_sym_AMP] = ACTIONS(2060),
  },
  [539] = {
    [aux_sym_concatenation_repeat1] = STATE(126),
    [sym__simple_heredoc_body] = ACTIONS(2062),
    [sym__heredoc_body_beginning] = ACTIONS(2062),
    [sym_file_descriptor] = ACTIONS(2062),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(2064),
    [anon_sym_SEMI_SEMI] = ACTIONS(2064),
    [anon_sym_PIPE_AMP] = ACTIONS(2064),
    [anon_sym_AMP_AMP] = ACTIONS(2064),
    [anon_sym_PIPE_PIPE] = ACTIONS(2064),
    [anon_sym_EQ_TILDE] = ACTIONS(2064),
    [anon_sym_EQ_EQ] = ACTIONS(2064),
    [anon_sym_LT] = ACTIONS(2064),
    [anon_sym_GT] = ACTIONS(2064),
    [anon_sym_GT_GT] = ACTIONS(2064),
    [anon_sym_AMP_GT] = ACTIONS(2064),
    [anon_sym_AMP_GT_GT] = ACTIONS(2064),
    [anon_sym_LT_AMP] = ACTIONS(2064),
    [anon_sym_GT_AMP] = ACTIONS(2064),
    [anon_sym_LT_LT] = ACTIONS(2064),
    [anon_sym_LT_LT_DASH] = ACTIONS(2064),
    [anon_sym_LT_LT_LT] = ACTIONS(2064),
    [sym__special_characters] = ACTIONS(2064),
    [anon_sym_DQUOTE] = ACTIONS(2064),
    [anon_sym_DOLLAR] = ACTIONS(2064),
    [sym_raw_string] = ACTIONS(2064),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2064),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2064),
    [anon_sym_BQUOTE] = ACTIONS(2064),
    [anon_sym_LT_LPAREN] = ACTIONS(2064),
    [anon_sym_GT_LPAREN] = ACTIONS(2064),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2064),
    [anon_sym_SEMI] = ACTIONS(2064),
    [anon_sym_LF] = ACTIONS(2062),
    [anon_sym_AMP] = ACTIONS(2064),
  },
  [540] = {
    [sym__simple_heredoc_body] = ACTIONS(2062),
    [sym__heredoc_body_beginning] = ACTIONS(2062),
    [sym_file_descriptor] = ACTIONS(2062),
    [anon_sym_PIPE] = ACTIONS(2064),
    [anon_sym_RPAREN] = ACTIONS(2064),
    [anon_sym_SEMI_SEMI] = ACTIONS(2064),
    [anon_sym_PIPE_AMP] = ACTIONS(2064),
    [anon_sym_AMP_AMP] = ACTIONS(2064),
    [anon_sym_PIPE_PIPE] = ACTIONS(2064),
    [anon_sym_EQ_TILDE] = ACTIONS(2064),
    [anon_sym_EQ_EQ] = ACTIONS(2064),
    [anon_sym_LT] = ACTIONS(2064),
    [anon_sym_GT] = ACTIONS(2064),
    [anon_sym_GT_GT] = ACTIONS(2064),
    [anon_sym_AMP_GT] = ACTIONS(2064),
    [anon_sym_AMP_GT_GT] = ACTIONS(2064),
    [anon_sym_LT_AMP] = ACTIONS(2064),
    [anon_sym_GT_AMP] = ACTIONS(2064),
    [anon_sym_LT_LT] = ACTIONS(2064),
    [anon_sym_LT_LT_DASH] = ACTIONS(2064),
    [anon_sym_LT_LT_LT] = ACTIONS(2064),
    [sym__special_characters] = ACTIONS(2064),
    [anon_sym_DQUOTE] = ACTIONS(2064),
    [anon_sym_DOLLAR] = ACTIONS(2064),
    [sym_raw_string] = ACTIONS(2064),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2064),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2064),
    [anon_sym_BQUOTE] = ACTIONS(2064),
    [anon_sym_LT_LPAREN] = ACTIONS(2064),
    [anon_sym_GT_LPAREN] = ACTIONS(2064),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2064),
    [anon_sym_SEMI] = ACTIONS(2064),
    [anon_sym_LF] = ACTIONS(2062),
    [anon_sym_AMP] = ACTIONS(2064),
  },
  [541] = {
    [aux_sym_concatenation_repeat1] = STATE(992),
    [sym__simple_heredoc_body] = ACTIONS(661),
    [sym__heredoc_body_beginning] = ACTIONS(661),
    [sym_file_descriptor] = ACTIONS(661),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(665),
    [anon_sym_SEMI_SEMI] = ACTIONS(665),
    [anon_sym_PIPE_AMP] = ACTIONS(665),
    [anon_sym_AMP_AMP] = ACTIONS(665),
    [anon_sym_PIPE_PIPE] = ACTIONS(665),
    [anon_sym_LT] = ACTIONS(665),
    [anon_sym_GT] = ACTIONS(665),
    [anon_sym_GT_GT] = ACTIONS(665),
    [anon_sym_AMP_GT] = ACTIONS(665),
    [anon_sym_AMP_GT_GT] = ACTIONS(665),
    [anon_sym_LT_AMP] = ACTIONS(665),
    [anon_sym_GT_AMP] = ACTIONS(665),
    [anon_sym_LT_LT] = ACTIONS(665),
    [anon_sym_LT_LT_DASH] = ACTIONS(665),
    [anon_sym_LT_LT_LT] = ACTIONS(665),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(665),
    [anon_sym_LF] = ACTIONS(661),
    [anon_sym_AMP] = ACTIONS(665),
  },
  [542] = {
    [aux_sym_concatenation_repeat1] = STATE(992),
    [sym__simple_heredoc_body] = ACTIONS(677),
    [sym__heredoc_body_beginning] = ACTIONS(677),
    [sym_file_descriptor] = ACTIONS(677),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(679),
    [anon_sym_SEMI_SEMI] = ACTIONS(679),
    [anon_sym_PIPE_AMP] = ACTIONS(679),
    [anon_sym_AMP_AMP] = ACTIONS(679),
    [anon_sym_PIPE_PIPE] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(679),
    [anon_sym_GT] = ACTIONS(679),
    [anon_sym_GT_GT] = ACTIONS(679),
    [anon_sym_AMP_GT] = ACTIONS(679),
    [anon_sym_AMP_GT_GT] = ACTIONS(679),
    [anon_sym_LT_AMP] = ACTIONS(679),
    [anon_sym_GT_AMP] = ACTIONS(679),
    [anon_sym_LT_LT] = ACTIONS(679),
    [anon_sym_LT_LT_DASH] = ACTIONS(679),
    [anon_sym_LT_LT_LT] = ACTIONS(679),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(679),
    [anon_sym_LF] = ACTIONS(677),
    [anon_sym_AMP] = ACTIONS(679),
  },
  [543] = {
    [sym__simple_heredoc_body] = ACTIONS(677),
    [sym__heredoc_body_beginning] = ACTIONS(677),
    [sym_file_descriptor] = ACTIONS(677),
    [anon_sym_esac] = ACTIONS(679),
    [anon_sym_PIPE] = ACTIONS(679),
    [anon_sym_RPAREN] = ACTIONS(679),
    [anon_sym_SEMI_SEMI] = ACTIONS(679),
    [anon_sym_PIPE_AMP] = ACTIONS(679),
    [anon_sym_AMP_AMP] = ACTIONS(679),
    [anon_sym_PIPE_PIPE] = ACTIONS(679),
    [anon_sym_LT] = ACTIONS(679),
    [anon_sym_GT] = ACTIONS(679),
    [anon_sym_GT_GT] = ACTIONS(679),
    [anon_sym_AMP_GT] = ACTIONS(679),
    [anon_sym_AMP_GT_GT] = ACTIONS(679),
    [anon_sym_LT_AMP] = ACTIONS(679),
    [anon_sym_GT_AMP] = ACTIONS(679),
    [anon_sym_LT_LT] = ACTIONS(679),
    [anon_sym_LT_LT_DASH] = ACTIONS(679),
    [anon_sym_LT_LT_LT] = ACTIONS(679),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(679),
    [anon_sym_LF] = ACTIONS(677),
    [anon_sym_AMP] = ACTIONS(679),
  },
  [544] = {
    [sym__simple_heredoc_body] = ACTIONS(2066),
    [sym__heredoc_body_beginning] = ACTIONS(2066),
    [sym_file_descriptor] = ACTIONS(2066),
    [anon_sym_esac] = ACTIONS(2068),
    [anon_sym_PIPE] = ACTIONS(2068),
    [anon_sym_RPAREN] = ACTIONS(2068),
    [anon_sym_SEMI_SEMI] = ACTIONS(2068),
    [anon_sym_PIPE_AMP] = ACTIONS(2068),
    [anon_sym_AMP_AMP] = ACTIONS(2068),
    [anon_sym_PIPE_PIPE] = ACTIONS(2068),
    [anon_sym_LT] = ACTIONS(2068),
    [anon_sym_GT] = ACTIONS(2068),
    [anon_sym_GT_GT] = ACTIONS(2068),
    [anon_sym_AMP_GT] = ACTIONS(2068),
    [anon_sym_AMP_GT_GT] = ACTIONS(2068),
    [anon_sym_LT_AMP] = ACTIONS(2068),
    [anon_sym_GT_AMP] = ACTIONS(2068),
    [anon_sym_LT_LT] = ACTIONS(2068),
    [anon_sym_LT_LT_DASH] = ACTIONS(2068),
    [anon_sym_LT_LT_LT] = ACTIONS(2068),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2068),
    [anon_sym_LF] = ACTIONS(2066),
    [anon_sym_AMP] = ACTIONS(2068),
  },
  [545] = {
    [aux_sym_concatenation_repeat1] = STATE(992),
    [sym__simple_heredoc_body] = ACTIONS(2070),
    [sym__heredoc_body_beginning] = ACTIONS(2070),
    [sym_file_descriptor] = ACTIONS(2070),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(2072),
    [anon_sym_SEMI_SEMI] = ACTIONS(2072),
    [anon_sym_PIPE_AMP] = ACTIONS(2072),
    [anon_sym_AMP_AMP] = ACTIONS(2072),
    [anon_sym_PIPE_PIPE] = ACTIONS(2072),
    [anon_sym_LT] = ACTIONS(2072),
    [anon_sym_GT] = ACTIONS(2072),
    [anon_sym_GT_GT] = ACTIONS(2072),
    [anon_sym_AMP_GT] = ACTIONS(2072),
    [anon_sym_AMP_GT_GT] = ACTIONS(2072),
    [anon_sym_LT_AMP] = ACTIONS(2072),
    [anon_sym_GT_AMP] = ACTIONS(2072),
    [anon_sym_LT_LT] = ACTIONS(2072),
    [anon_sym_LT_LT_DASH] = ACTIONS(2072),
    [anon_sym_LT_LT_LT] = ACTIONS(2072),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2072),
    [anon_sym_LF] = ACTIONS(2070),
    [anon_sym_AMP] = ACTIONS(2072),
  },
  [546] = {
    [aux_sym_concatenation_repeat1] = STATE(992),
    [sym__simple_heredoc_body] = ACTIONS(2074),
    [sym__heredoc_body_beginning] = ACTIONS(2074),
    [sym_file_descriptor] = ACTIONS(2074),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(2076),
    [anon_sym_SEMI_SEMI] = ACTIONS(2076),
    [anon_sym_PIPE_AMP] = ACTIONS(2076),
    [anon_sym_AMP_AMP] = ACTIONS(2076),
    [anon_sym_PIPE_PIPE] = ACTIONS(2076),
    [anon_sym_LT] = ACTIONS(2076),
    [anon_sym_GT] = ACTIONS(2076),
    [anon_sym_GT_GT] = ACTIONS(2076),
    [anon_sym_AMP_GT] = ACTIONS(2076),
    [anon_sym_AMP_GT_GT] = ACTIONS(2076),
    [anon_sym_LT_AMP] = ACTIONS(2076),
    [anon_sym_GT_AMP] = ACTIONS(2076),
    [anon_sym_LT_LT] = ACTIONS(2076),
    [anon_sym_LT_LT_DASH] = ACTIONS(2076),
    [anon_sym_LT_LT_LT] = ACTIONS(2076),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2076),
    [anon_sym_LF] = ACTIONS(2074),
    [anon_sym_AMP] = ACTIONS(2076),
  },
  [547] = {
    [sym__simple_heredoc_body] = ACTIONS(2074),
    [sym__heredoc_body_beginning] = ACTIONS(2074),
    [sym_file_descriptor] = ACTIONS(2074),
    [anon_sym_esac] = ACTIONS(2076),
    [anon_sym_PIPE] = ACTIONS(2076),
    [anon_sym_RPAREN] = ACTIONS(2076),
    [anon_sym_SEMI_SEMI] = ACTIONS(2076),
    [anon_sym_PIPE_AMP] = ACTIONS(2076),
    [anon_sym_AMP_AMP] = ACTIONS(2076),
    [anon_sym_PIPE_PIPE] = ACTIONS(2076),
    [anon_sym_LT] = ACTIONS(2076),
    [anon_sym_GT] = ACTIONS(2076),
    [anon_sym_GT_GT] = ACTIONS(2076),
    [anon_sym_AMP_GT] = ACTIONS(2076),
    [anon_sym_AMP_GT_GT] = ACTIONS(2076),
    [anon_sym_LT_AMP] = ACTIONS(2076),
    [anon_sym_GT_AMP] = ACTIONS(2076),
    [anon_sym_LT_LT] = ACTIONS(2076),
    [anon_sym_LT_LT_DASH] = ACTIONS(2076),
    [anon_sym_LT_LT_LT] = ACTIONS(2076),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2076),
    [anon_sym_LF] = ACTIONS(2074),
    [anon_sym_AMP] = ACTIONS(2076),
  },
  [548] = {
    [anon_sym_esac] = ACTIONS(2078),
    [anon_sym_PIPE] = ACTIONS(2078),
    [anon_sym_RPAREN] = ACTIONS(2078),
    [anon_sym_SEMI_SEMI] = ACTIONS(2078),
    [anon_sym_PIPE_AMP] = ACTIONS(2078),
    [anon_sym_AMP_AMP] = ACTIONS(2078),
    [anon_sym_PIPE_PIPE] = ACTIONS(2078),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2078),
    [anon_sym_LF] = ACTIONS(2080),
    [anon_sym_AMP] = ACTIONS(2078),
  },
  [549] = {
    [sym_file_redirect] = STATE(549),
    [sym_heredoc_redirect] = STATE(549),
    [sym_herestring_redirect] = STATE(549),
    [aux_sym_while_statement_repeat1] = STATE(549),
    [sym__simple_heredoc_body] = ACTIONS(2082),
    [sym__heredoc_body_beginning] = ACTIONS(2082),
    [sym_file_descriptor] = ACTIONS(2084),
    [anon_sym_PIPE] = ACTIONS(2087),
    [anon_sym_SEMI_SEMI] = ACTIONS(2087),
    [anon_sym_PIPE_AMP] = ACTIONS(2087),
    [anon_sym_AMP_AMP] = ACTIONS(2087),
    [anon_sym_PIPE_PIPE] = ACTIONS(2087),
    [anon_sym_LT] = ACTIONS(2089),
    [anon_sym_GT] = ACTIONS(2089),
    [anon_sym_GT_GT] = ACTIONS(2089),
    [anon_sym_AMP_GT] = ACTIONS(2089),
    [anon_sym_AMP_GT_GT] = ACTIONS(2089),
    [anon_sym_LT_AMP] = ACTIONS(2089),
    [anon_sym_GT_AMP] = ACTIONS(2089),
    [anon_sym_LT_LT] = ACTIONS(2092),
    [anon_sym_LT_LT_DASH] = ACTIONS(2092),
    [anon_sym_LT_LT_LT] = ACTIONS(2095),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2087),
    [anon_sym_LF] = ACTIONS(2082),
    [anon_sym_AMP] = ACTIONS(2087),
  },
  [550] = {
    [sym_file_redirect] = STATE(549),
    [sym_heredoc_redirect] = STATE(549),
    [sym_heredoc_body] = STATE(993),
    [sym_herestring_redirect] = STATE(549),
    [aux_sym_while_statement_repeat1] = STATE(549),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(2078),
    [anon_sym_SEMI_SEMI] = ACTIONS(2078),
    [anon_sym_PIPE_AMP] = ACTIONS(2078),
    [anon_sym_AMP_AMP] = ACTIONS(2078),
    [anon_sym_PIPE_PIPE] = ACTIONS(2078),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2078),
    [anon_sym_LF] = ACTIONS(2080),
    [anon_sym_AMP] = ACTIONS(2078),
  },
  [551] = {
    [sym_concatenation] = STATE(551),
    [sym_string] = STATE(199),
    [sym_simple_expansion] = STATE(199),
    [sym_string_expansion] = STATE(199),
    [sym_expansion] = STATE(199),
    [sym_command_substitution] = STATE(199),
    [sym_process_substitution] = STATE(199),
    [aux_sym_command_repeat2] = STATE(551),
    [sym__simple_heredoc_body] = ACTIONS(2062),
    [sym__heredoc_body_beginning] = ACTIONS(2062),
    [sym_file_descriptor] = ACTIONS(2062),
    [anon_sym_PIPE] = ACTIONS(2064),
    [anon_sym_SEMI_SEMI] = ACTIONS(2064),
    [anon_sym_PIPE_AMP] = ACTIONS(2064),
    [anon_sym_AMP_AMP] = ACTIONS(2064),
    [anon_sym_PIPE_PIPE] = ACTIONS(2064),
    [anon_sym_EQ_TILDE] = ACTIONS(2098),
    [anon_sym_EQ_EQ] = ACTIONS(2098),
    [anon_sym_LT] = ACTIONS(2064),
    [anon_sym_GT] = ACTIONS(2064),
    [anon_sym_GT_GT] = ACTIONS(2064),
    [anon_sym_AMP_GT] = ACTIONS(2064),
    [anon_sym_AMP_GT_GT] = ACTIONS(2064),
    [anon_sym_LT_AMP] = ACTIONS(2064),
    [anon_sym_GT_AMP] = ACTIONS(2064),
    [anon_sym_LT_LT] = ACTIONS(2064),
    [anon_sym_LT_LT_DASH] = ACTIONS(2064),
    [anon_sym_LT_LT_LT] = ACTIONS(2064),
    [sym__special_characters] = ACTIONS(2101),
    [anon_sym_DQUOTE] = ACTIONS(2104),
    [anon_sym_DOLLAR] = ACTIONS(2107),
    [sym_raw_string] = ACTIONS(2110),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2113),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2116),
    [anon_sym_BQUOTE] = ACTIONS(2119),
    [anon_sym_LT_LPAREN] = ACTIONS(2122),
    [anon_sym_GT_LPAREN] = ACTIONS(2122),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2110),
    [anon_sym_SEMI] = ACTIONS(2064),
    [anon_sym_LF] = ACTIONS(2062),
    [anon_sym_AMP] = ACTIONS(2064),
  },
  [552] = {
    [sym_file_redirect] = STATE(994),
    [sym_heredoc_redirect] = STATE(994),
    [sym_heredoc_body] = STATE(993),
    [sym_herestring_redirect] = STATE(994),
    [sym_concatenation] = STATE(551),
    [sym_string] = STATE(199),
    [sym_simple_expansion] = STATE(199),
    [sym_string_expansion] = STATE(199),
    [sym_expansion] = STATE(199),
    [sym_command_substitution] = STATE(199),
    [sym_process_substitution] = STATE(199),
    [aux_sym_while_statement_repeat1] = STATE(994),
    [aux_sym_command_repeat2] = STATE(551),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(2078),
    [anon_sym_SEMI_SEMI] = ACTIONS(2078),
    [anon_sym_PIPE_AMP] = ACTIONS(2078),
    [anon_sym_AMP_AMP] = ACTIONS(2078),
    [anon_sym_PIPE_PIPE] = ACTIONS(2078),
    [anon_sym_EQ_TILDE] = ACTIONS(345),
    [anon_sym_EQ_EQ] = ACTIONS(345),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym__special_characters] = ACTIONS(353),
    [anon_sym_DQUOTE] = ACTIONS(355),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(357),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(359),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(361),
    [anon_sym_BQUOTE] = ACTIONS(363),
    [anon_sym_LT_LPAREN] = ACTIONS(365),
    [anon_sym_GT_LPAREN] = ACTIONS(365),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(357),
    [anon_sym_SEMI] = ACTIONS(2078),
    [anon_sym_LF] = ACTIONS(2080),
    [anon_sym_AMP] = ACTIONS(2078),
  },
  [553] = {
    [sym_string] = STATE(681),
    [sym_simple_expansion] = STATE(681),
    [sym_string_expansion] = STATE(681),
    [sym_expansion] = STATE(681),
    [sym_command_substitution] = STATE(681),
    [sym_process_substitution] = STATE(681),
    [anon_sym_RBRACK] = ACTIONS(2125),
    [sym__special_characters] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(1309),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1309),
  },
  [554] = {
    [sym__concat] = ACTIONS(2129),
    [anon_sym_EQ] = ACTIONS(2131),
    [anon_sym_PLUS_EQ] = ACTIONS(2131),
    [sym_comment] = ACTIONS(53),
  },
  [555] = {
    [aux_sym_concatenation_repeat1] = STATE(997),
    [sym__concat] = ACTIONS(513),
    [anon_sym_RBRACK] = ACTIONS(693),
    [sym_comment] = ACTIONS(53),
  },
  [556] = {
    [sym_string] = STATE(681),
    [sym_simple_expansion] = STATE(681),
    [sym_string_expansion] = STATE(681),
    [sym_expansion] = STATE(681),
    [sym_command_substitution] = STATE(681),
    [sym_process_substitution] = STATE(681),
    [anon_sym_RBRACK] = ACTIONS(2133),
    [sym__special_characters] = ACTIONS(2127),
    [anon_sym_DQUOTE] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [sym_raw_string] = ACTIONS(1309),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(123),
    [anon_sym_BQUOTE] = ACTIONS(125),
    [anon_sym_LT_LPAREN] = ACTIONS(127),
    [anon_sym_GT_LPAREN] = ACTIONS(127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1309),
  },
  [557] = {
    [sym__concat] = ACTIONS(2135),
    [anon_sym_EQ] = ACTIONS(2137),
    [anon_sym_PLUS_EQ] = ACTIONS(2137),
    [sym_comment] = ACTIONS(53),
  },
  [558] = {
    [anon_sym_RBRACK] = ACTIONS(2133),
    [sym_comment] = ACTIONS(53),
  },
  [559] = {
    [sym_file_descriptor] = ACTIONS(2139),
    [sym_variable_name] = ACTIONS(2139),
    [anon_sym_PIPE] = ACTIONS(2141),
    [anon_sym_RPAREN] = ACTIONS(2141),
    [anon_sym_SEMI_SEMI] = ACTIONS(2141),
    [anon_sym_PIPE_AMP] = ACTIONS(2141),
    [anon_sym_AMP_AMP] = ACTIONS(2141),
    [anon_sym_PIPE_PIPE] = ACTIONS(2141),
    [anon_sym_LT] = ACTIONS(2141),
    [anon_sym_GT] = ACTIONS(2141),
    [anon_sym_GT_GT] = ACTIONS(2141),
    [anon_sym_AMP_GT] = ACTIONS(2141),
    [anon_sym_AMP_GT_GT] = ACTIONS(2141),
    [anon_sym_LT_AMP] = ACTIONS(2141),
    [anon_sym_GT_AMP] = ACTIONS(2141),
    [sym__special_characters] = ACTIONS(2141),
    [anon_sym_DQUOTE] = ACTIONS(2141),
    [anon_sym_DOLLAR] = ACTIONS(2141),
    [sym_raw_string] = ACTIONS(2141),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2141),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2141),
    [anon_sym_BQUOTE] = ACTIONS(2141),
    [anon_sym_LT_LPAREN] = ACTIONS(2141),
    [anon_sym_GT_LPAREN] = ACTIONS(2141),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2141),
    [anon_sym_SEMI] = ACTIONS(2141),
    [anon_sym_LF] = ACTIONS(2139),
    [anon_sym_AMP] = ACTIONS(2141),
  },
  [560] = {
    [aux_sym_concatenation_repeat1] = STATE(1001),
    [sym__concat] = ACTIONS(2143),
    [anon_sym_RPAREN] = ACTIONS(2145),
    [sym__special_characters] = ACTIONS(2145),
    [anon_sym_DQUOTE] = ACTIONS(2145),
    [anon_sym_DOLLAR] = ACTIONS(2147),
    [sym_raw_string] = ACTIONS(2145),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2145),
    [anon_sym_BQUOTE] = ACTIONS(2145),
    [anon_sym_LT_LPAREN] = ACTIONS(2145),
    [anon_sym_GT_LPAREN] = ACTIONS(2145),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2145),
  },
  [561] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(1003),
    [anon_sym_DQUOTE] = ACTIONS(2149),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [562] = {
    [sym_string] = STATE(1005),
    [anon_sym_DQUOTE] = ACTIONS(1115),
    [anon_sym_DOLLAR] = ACTIONS(2151),
    [sym_raw_string] = ACTIONS(2153),
    [anon_sym_POUND] = ACTIONS(2151),
    [anon_sym_DASH] = ACTIONS(2151),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2155),
    [anon_sym_STAR] = ACTIONS(2151),
    [anon_sym_AT] = ACTIONS(2151),
    [anon_sym_QMARK] = ACTIONS(2151),
    [anon_sym_0] = ACTIONS(2157),
    [anon_sym__] = ACTIONS(2157),
  },
  [563] = {
    [aux_sym_concatenation_repeat1] = STATE(1001),
    [sym__concat] = ACTIONS(2143),
    [anon_sym_RPAREN] = ACTIONS(2159),
    [sym__special_characters] = ACTIONS(2159),
    [anon_sym_DQUOTE] = ACTIONS(2159),
    [anon_sym_DOLLAR] = ACTIONS(2161),
    [sym_raw_string] = ACTIONS(2159),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2159),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2159),
    [anon_sym_BQUOTE] = ACTIONS(2159),
    [anon_sym_LT_LPAREN] = ACTIONS(2159),
    [anon_sym_GT_LPAREN] = ACTIONS(2159),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2159),
  },
  [564] = {
    [sym_subscript] = STATE(1011),
    [sym_variable_name] = ACTIONS(2163),
    [anon_sym_DOLLAR] = ACTIONS(2165),
    [anon_sym_POUND] = ACTIONS(2167),
    [anon_sym_DASH] = ACTIONS(2165),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2169),
    [anon_sym_STAR] = ACTIONS(2165),
    [anon_sym_AT] = ACTIONS(2165),
    [anon_sym_QMARK] = ACTIONS(2165),
    [anon_sym_0] = ACTIONS(2171),
    [anon_sym__] = ACTIONS(2171),
  },
  [565] = {
    [sym_for_statement] = STATE(1012),
    [sym_while_statement] = STATE(1012),
    [sym_if_statement] = STATE(1012),
    [sym_case_statement] = STATE(1012),
    [sym_function_definition] = STATE(1012),
    [sym_subshell] = STATE(1012),
    [sym_pipeline] = STATE(1012),
    [sym_list] = STATE(1012),
    [sym_negated_command] = STATE(1012),
    [sym_test_command] = STATE(1012),
    [sym_declaration_command] = STATE(1012),
    [sym_unset_command] = STATE(1012),
    [sym_command] = STATE(1012),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(1013),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [566] = {
    [sym_for_statement] = STATE(1014),
    [sym_while_statement] = STATE(1014),
    [sym_if_statement] = STATE(1014),
    [sym_case_statement] = STATE(1014),
    [sym_function_definition] = STATE(1014),
    [sym_subshell] = STATE(1014),
    [sym_pipeline] = STATE(1014),
    [sym_list] = STATE(1014),
    [sym_negated_command] = STATE(1014),
    [sym_test_command] = STATE(1014),
    [sym_declaration_command] = STATE(1014),
    [sym_unset_command] = STATE(1014),
    [sym_command] = STATE(1014),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(1015),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [567] = {
    [sym_for_statement] = STATE(1016),
    [sym_while_statement] = STATE(1016),
    [sym_if_statement] = STATE(1016),
    [sym_case_statement] = STATE(1016),
    [sym_function_definition] = STATE(1016),
    [sym_subshell] = STATE(1016),
    [sym_pipeline] = STATE(1016),
    [sym_list] = STATE(1016),
    [sym_negated_command] = STATE(1016),
    [sym_test_command] = STATE(1016),
    [sym_declaration_command] = STATE(1016),
    [sym_unset_command] = STATE(1016),
    [sym_command] = STATE(1016),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(1017),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [568] = {
    [sym_concatenation] = STATE(1019),
    [sym_string] = STATE(563),
    [sym_simple_expansion] = STATE(563),
    [sym_string_expansion] = STATE(563),
    [sym_expansion] = STATE(563),
    [sym_command_substitution] = STATE(563),
    [sym_process_substitution] = STATE(563),
    [aux_sym_for_statement_repeat1] = STATE(1019),
    [anon_sym_RPAREN] = ACTIONS(2173),
    [sym__special_characters] = ACTIONS(1113),
    [anon_sym_DQUOTE] = ACTIONS(1115),
    [anon_sym_DOLLAR] = ACTIONS(1117),
    [sym_raw_string] = ACTIONS(1119),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1121),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1123),
    [anon_sym_BQUOTE] = ACTIONS(1125),
    [anon_sym_LT_LPAREN] = ACTIONS(1127),
    [anon_sym_GT_LPAREN] = ACTIONS(1127),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(1119),
  },
  [569] = {
    [sym_string] = STATE(1020),
    [sym_simple_expansion] = STATE(1020),
    [sym_string_expansion] = STATE(1020),
    [sym_expansion] = STATE(1020),
    [sym_command_substitution] = STATE(1020),
    [sym_process_substitution] = STATE(1020),
    [sym__special_characters] = ACTIONS(2175),
    [anon_sym_DQUOTE] = ACTIONS(391),
    [anon_sym_DOLLAR] = ACTIONS(393),
    [sym_raw_string] = ACTIONS(2175),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(397),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(399),
    [anon_sym_BQUOTE] = ACTIONS(401),
    [anon_sym_LT_LPAREN] = ACTIONS(403),
    [anon_sym_GT_LPAREN] = ACTIONS(403),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2175),
  },
  [570] = {
    [aux_sym_concatenation_repeat1] = STATE(1021),
    [sym_file_descriptor] = ACTIONS(693),
    [sym__concat] = ACTIONS(1131),
    [sym_variable_name] = ACTIONS(693),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(695),
    [anon_sym_LT] = ACTIONS(695),
    [anon_sym_GT] = ACTIONS(695),
    [anon_sym_GT_GT] = ACTIONS(695),
    [anon_sym_AMP_GT] = ACTIONS(695),
    [anon_sym_AMP_GT_GT] = ACTIONS(695),
    [anon_sym_LT_AMP] = ACTIONS(695),
    [anon_sym_GT_AMP] = ACTIONS(695),
    [sym__special_characters] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(695),
    [anon_sym_BQUOTE] = ACTIONS(695),
    [anon_sym_LT_LPAREN] = ACTIONS(695),
    [anon_sym_GT_LPAREN] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [571] = {
    [sym_file_descriptor] = ACTIONS(697),
    [sym__concat] = ACTIONS(697),
    [sym_variable_name] = ACTIONS(697),
    [anon_sym_PIPE] = ACTIONS(699),
    [anon_sym_RPAREN] = ACTIONS(699),
    [anon_sym_SEMI_SEMI] = ACTIONS(699),
    [anon_sym_PIPE_AMP] = ACTIONS(699),
    [anon_sym_AMP_AMP] = ACTIONS(699),
    [anon_sym_PIPE_PIPE] = ACTIONS(699),
    [anon_sym_LT] = ACTIONS(699),
    [anon_sym_GT] = ACTIONS(699),
    [anon_sym_GT_GT] = ACTIONS(699),
    [anon_sym_AMP_GT] = ACTIONS(699),
    [anon_sym_AMP_GT_GT] = ACTIONS(699),
    [anon_sym_LT_AMP] = ACTIONS(699),
    [anon_sym_GT_AMP] = ACTIONS(699),
    [sym__special_characters] = ACTIONS(699),
    [anon_sym_DQUOTE] = ACTIONS(699),
    [anon_sym_DOLLAR] = ACTIONS(699),
    [sym_raw_string] = ACTIONS(699),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(699),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(699),
    [anon_sym_BQUOTE] = ACTIONS(699),
    [anon_sym_LT_LPAREN] = ACTIONS(699),
    [anon_sym_GT_LPAREN] = ACTIONS(699),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(699),
    [anon_sym_SEMI] = ACTIONS(699),
    [anon_sym_LF] = ACTIONS(697),
    [anon_sym_AMP] = ACTIONS(699),
  },
  [572] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(406),
    [anon_sym_DQUOTE] = ACTIONS(2177),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [573] = {
    [sym_file_descriptor] = ACTIONS(727),
    [sym__concat] = ACTIONS(727),
    [sym_variable_name] = ACTIONS(727),
    [anon_sym_PIPE] = ACTIONS(729),
    [anon_sym_RPAREN] = ACTIONS(729),
    [anon_sym_SEMI_SEMI] = ACTIONS(729),
    [anon_sym_PIPE_AMP] = ACTIONS(729),
    [anon_sym_AMP_AMP] = ACTIONS(729),
    [anon_sym_PIPE_PIPE] = ACTIONS(729),
    [anon_sym_LT] = ACTIONS(729),
    [anon_sym_GT] = ACTIONS(729),
    [anon_sym_GT_GT] = ACTIONS(729),
    [anon_sym_AMP_GT] = ACTIONS(729),
    [anon_sym_AMP_GT_GT] = ACTIONS(729),
    [anon_sym_LT_AMP] = ACTIONS(729),
    [anon_sym_GT_AMP] = ACTIONS(729),
    [sym__special_characters] = ACTIONS(729),
    [anon_sym_DQUOTE] = ACTIONS(729),
    [anon_sym_DOLLAR] = ACTIONS(729),
    [sym_raw_string] = ACTIONS(729),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(729),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(729),
    [anon_sym_BQUOTE] = ACTIONS(729),
    [anon_sym_LT_LPAREN] = ACTIONS(729),
    [anon_sym_GT_LPAREN] = ACTIONS(729),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(729),
    [anon_sym_SEMI] = ACTIONS(729),
    [anon_sym_LF] = ACTIONS(727),
    [anon_sym_AMP] = ACTIONS(729),
  },
  [574] = {
    [sym_file_descriptor] = ACTIONS(731),
    [sym__concat] = ACTIONS(731),
    [sym_variable_name] = ACTIONS(731),
    [anon_sym_PIPE] = ACTIONS(733),
    [anon_sym_RPAREN] = ACTIONS(733),
    [anon_sym_SEMI_SEMI] = ACTIONS(733),
    [anon_sym_PIPE_AMP] = ACTIONS(733),
    [anon_sym_AMP_AMP] = ACTIONS(733),
    [anon_sym_PIPE_PIPE] = ACTIONS(733),
    [anon_sym_LT] = ACTIONS(733),
    [anon_sym_GT] = ACTIONS(733),
    [anon_sym_GT_GT] = ACTIONS(733),
    [anon_sym_AMP_GT] = ACTIONS(733),
    [anon_sym_AMP_GT_GT] = ACTIONS(733),
    [anon_sym_LT_AMP] = ACTIONS(733),
    [anon_sym_GT_AMP] = ACTIONS(733),
    [sym__special_characters] = ACTIONS(733),
    [anon_sym_DQUOTE] = ACTIONS(733),
    [anon_sym_DOLLAR] = ACTIONS(733),
    [sym_raw_string] = ACTIONS(733),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(733),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(733),
    [anon_sym_BQUOTE] = ACTIONS(733),
    [anon_sym_LT_LPAREN] = ACTIONS(733),
    [anon_sym_GT_LPAREN] = ACTIONS(733),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(733),
    [anon_sym_SEMI] = ACTIONS(733),
    [anon_sym_LF] = ACTIONS(731),
    [anon_sym_AMP] = ACTIONS(733),
  },
  [575] = {
    [sym_file_descriptor] = ACTIONS(735),
    [sym__concat] = ACTIONS(735),
    [sym_variable_name] = ACTIONS(735),
    [anon_sym_PIPE] = ACTIONS(737),
    [anon_sym_RPAREN] = ACTIONS(737),
    [anon_sym_SEMI_SEMI] = ACTIONS(737),
    [anon_sym_PIPE_AMP] = ACTIONS(737),
    [anon_sym_AMP_AMP] = ACTIONS(737),
    [anon_sym_PIPE_PIPE] = ACTIONS(737),
    [anon_sym_LT] = ACTIONS(737),
    [anon_sym_GT] = ACTIONS(737),
    [anon_sym_GT_GT] = ACTIONS(737),
    [anon_sym_AMP_GT] = ACTIONS(737),
    [anon_sym_AMP_GT_GT] = ACTIONS(737),
    [anon_sym_LT_AMP] = ACTIONS(737),
    [anon_sym_GT_AMP] = ACTIONS(737),
    [sym__special_characters] = ACTIONS(737),
    [anon_sym_DQUOTE] = ACTIONS(737),
    [anon_sym_DOLLAR] = ACTIONS(737),
    [sym_raw_string] = ACTIONS(737),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(737),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(737),
    [anon_sym_BQUOTE] = ACTIONS(737),
    [anon_sym_LT_LPAREN] = ACTIONS(737),
    [anon_sym_GT_LPAREN] = ACTIONS(737),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(737),
    [anon_sym_SEMI] = ACTIONS(737),
    [anon_sym_LF] = ACTIONS(735),
    [anon_sym_AMP] = ACTIONS(737),
  },
  [576] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(2179),
    [sym_comment] = ACTIONS(53),
  },
  [577] = {
    [sym_concatenation] = STATE(1026),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(1026),
    [anon_sym_RBRACE] = ACTIONS(2181),
    [anon_sym_EQ] = ACTIONS(2183),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(2185),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(2187),
    [anon_sym_COLON] = ACTIONS(2183),
    [anon_sym_COLON_QMARK] = ACTIONS(2183),
    [anon_sym_COLON_DASH] = ACTIONS(2183),
    [anon_sym_PERCENT] = ACTIONS(2183),
    [anon_sym_DASH] = ACTIONS(2183),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [578] = {
    [sym_subscript] = STATE(1030),
    [sym_variable_name] = ACTIONS(2189),
    [anon_sym_DOLLAR] = ACTIONS(2191),
    [anon_sym_DASH] = ACTIONS(2191),
    [sym_comment] = ACTIONS(53),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2193),
    [anon_sym_STAR] = ACTIONS(2191),
    [anon_sym_AT] = ACTIONS(2191),
    [anon_sym_QMARK] = ACTIONS(2191),
    [anon_sym_0] = ACTIONS(2195),
    [anon_sym__] = ACTIONS(2195),
  },
  [579] = {
    [sym_concatenation] = STATE(1033),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(1033),
    [anon_sym_RBRACE] = ACTIONS(2197),
    [anon_sym_EQ] = ACTIONS(2199),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(2201),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(2203),
    [anon_sym_COLON] = ACTIONS(2199),
    [anon_sym_COLON_QMARK] = ACTIONS(2199),
    [anon_sym_COLON_DASH] = ACTIONS(2199),
    [anon_sym_PERCENT] = ACTIONS(2199),
    [anon_sym_DASH] = ACTIONS(2199),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [580] = {
    [sym_concatenation] = STATE(1036),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(1036),
    [anon_sym_RBRACE] = ACTIONS(2205),
    [anon_sym_EQ] = ACTIONS(2207),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(2209),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(2211),
    [anon_sym_COLON] = ACTIONS(2207),
    [anon_sym_COLON_QMARK] = ACTIONS(2207),
    [anon_sym_COLON_DASH] = ACTIONS(2207),
    [anon_sym_PERCENT] = ACTIONS(2207),
    [anon_sym_DASH] = ACTIONS(2207),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [581] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(2213),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [582] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(2213),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [583] = {
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_BQUOTE] = ACTIONS(2213),
    [sym_comment] = ACTIONS(53),
  },
  [584] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(923),
    [anon_sym_PIPE_AMP] = ACTIONS(925),
    [anon_sym_AMP_AMP] = ACTIONS(927),
    [anon_sym_PIPE_PIPE] = ACTIONS(927),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(2213),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [585] = {
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(2215),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [sym_comment] = ACTIONS(53),
  },
  [586] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(869),
    [anon_sym_RPAREN] = ACTIONS(2215),
    [anon_sym_PIPE_AMP] = ACTIONS(873),
    [anon_sym_AMP_AMP] = ACTIONS(875),
    [anon_sym_PIPE_PIPE] = ACTIONS(875),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(369),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(369),
    [anon_sym_LT_AMP] = ACTIONS(369),
    [anon_sym_GT_AMP] = ACTIONS(369),
    [sym__special_characters] = ACTIONS(369),
    [anon_sym_DQUOTE] = ACTIONS(369),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(369),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(369),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(369),
    [anon_sym_BQUOTE] = ACTIONS(369),
    [anon_sym_LT_LPAREN] = ACTIONS(369),
    [anon_sym_GT_LPAREN] = ACTIONS(369),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(369),
  },
  [587] = {
    [aux_sym_concatenation_repeat1] = STATE(1040),
    [sym__concat] = ACTIONS(2217),
    [anon_sym_SEMI_SEMI] = ACTIONS(2147),
    [sym__special_characters] = ACTIONS(2147),
    [anon_sym_DQUOTE] = ACTIONS(2147),
    [anon_sym_DOLLAR] = ACTIONS(2147),
    [sym_raw_string] = ACTIONS(2147),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2147),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2147),
    [anon_sym_BQUOTE] = ACTIONS(2147),
    [anon_sym_LT_LPAREN] = ACTIONS(2147),
    [anon_sym_GT_LPAREN] = ACTIONS(2147),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2147),
    [anon_sym_SEMI] = ACTIONS(2147),
    [anon_sym_LF] = ACTIONS(2145),
    [anon_sym_AMP] = ACTIONS(2147),
  },
  [588] = {
    [sym_simple_expansion] = STATE(129),
    [sym_expansion] = STATE(129),
    [sym_command_substitution] = STATE(129),
    [aux_sym_string_repeat1] = STATE(1042),
    [anon_sym_DQUOTE] = ACTIONS(2219),
    [anon_sym_DOLLAR] = ACTIONS(229),
    [sym__string_content] = ACTIONS(231),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(233),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(235),
    [anon_sym_BQUOTE] = ACTIONS(237),
    [sym_comment] = ACTIONS(177),
  },
  [589] = {
    [sym_string] = STATE(1044),
    [anon_sym_DQUOTE] = ACTIONS(1157),
    [anon_sym_DOLLAR] = ACTIONS(2221),
    [sym_raw_string] = ACTIONS(2223),
    [anon_sym_POUND] = ACTIONS(2221),
    [anon_sym_DASH] = ACTIONS(2221),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2225),
    [anon_sym_STAR] = ACTIONS(2221),
    [anon_sym_AT] = ACTIONS(2221),
    [anon_sym_QMARK] = ACTIONS(2221),
    [anon_sym_0] = ACTIONS(2227),
    [anon_sym__] = ACTIONS(2227),
  },
  [590] = {
    [aux_sym_concatenation_repeat1] = STATE(1040),
    [sym__concat] = ACTIONS(2217),
    [anon_sym_SEMI_SEMI] = ACTIONS(2161),
    [sym__special_characters] = ACTIONS(2161),
    [anon_sym_DQUOTE] = ACTIONS(2161),
    [anon_sym_DOLLAR] = ACTIONS(2161),
    [sym_raw_string] = ACTIONS(2161),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2161),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2161),
    [anon_sym_BQUOTE] = ACTIONS(2161),
    [anon_sym_LT_LPAREN] = ACTIONS(2161),
    [anon_sym_GT_LPAREN] = ACTIONS(2161),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2161),
    [anon_sym_SEMI] = ACTIONS(2161),
    [anon_sym_LF] = ACTIONS(2159),
    [anon_sym_AMP] = ACTIONS(2161),
  },
  [591] = {
    [sym_subscript] = STATE(1050),
    [sym_variable_name] = ACTIONS(2229),
    [anon_sym_DOLLAR] = ACTIONS(2231),
    [anon_sym_POUND] = ACTIONS(2233),
    [anon_sym_DASH] = ACTIONS(2231),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(2235),
    [anon_sym_STAR] = ACTIONS(2231),
    [anon_sym_AT] = ACTIONS(2231),
    [anon_sym_QMARK] = ACTIONS(2231),
    [anon_sym_0] = ACTIONS(2237),
    [anon_sym__] = ACTIONS(2237),
  },
  [592] = {
    [sym_for_statement] = STATE(1051),
    [sym_while_statement] = STATE(1051),
    [sym_if_statement] = STATE(1051),
    [sym_case_statement] = STATE(1051),
    [sym_function_definition] = STATE(1051),
    [sym_subshell] = STATE(1051),
    [sym_pipeline] = STATE(1051),
    [sym_list] = STATE(1051),
    [sym_negated_command] = STATE(1051),
    [sym_test_command] = STATE(1051),
    [sym_declaration_command] = STATE(1051),
    [sym_unset_command] = STATE(1051),
    [sym_command] = STATE(1051),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(1052),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [593] = {
    [sym_for_statement] = STATE(1053),
    [sym_while_statement] = STATE(1053),
    [sym_if_statement] = STATE(1053),
    [sym_case_statement] = STATE(1053),
    [sym_function_definition] = STATE(1053),
    [sym_subshell] = STATE(1053),
    [sym_pipeline] = STATE(1053),
    [sym_list] = STATE(1053),
    [sym_negated_command] = STATE(1053),
    [sym_test_command] = STATE(1053),
    [sym_declaration_command] = STATE(1053),
    [sym_unset_command] = STATE(1053),
    [sym_command] = STATE(1053),
    [sym_command_name] = STATE(181),
    [sym_variable_assignment] = STATE(1054),
    [sym_subscript] = STATE(183),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(178),
    [sym_simple_expansion] = STATE(178),
    [sym_string_expansion] = STATE(178),
    [sym_expansion] = STATE(178),
    [sym_command_substitution] = STATE(178),
    [sym_process_substitution] = STATE(178),
    [aux_sym_command_repeat1] = STATE(184),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(303),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(305),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(307),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(313),
    [anon_sym_declare] = ACTIONS(315),
    [anon_sym_typeset] = ACTIONS(315),
    [anon_sym_export] = ACTIONS(315),
    [anon_sym_readonly] = ACTIONS(315),
    [anon_sym_local] = ACTIONS(315),
    [anon_sym_unset] = ACTIONS(317),
    [anon_sym_unsetenv] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(319),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(321),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(323),
  },
  [594] = {
    [sym_for_statement] = STATE(1055),
    [sym_while_statement] = STATE(1055),
    [sym_if_statement] = STATE(1055),
    [sym_case_statement] = STATE(1055),
    [sym_function_definition] = STATE(1055),
    [sym_subshell] = STATE(1055),
    [sym_pipeline] = STATE(1055),
    [sym_list] = STATE(1055),
    [sym_negated_command] = STATE(1055),
    [sym_test_command] = STATE(1055),
    [sym_declaration_command] = STATE(1055),
    [sym_unset_command] = STATE(1055),
    [sym_command] = STATE(1055),
    [sym_command_name] = STATE(164),
    [sym_variable_assignment] = STATE(1056),
    [sym_subscript] = STATE(166),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(167),
    [sym_string] = STATE(157),
    [sym_simple_expansion] = STATE(157),
    [sym_string_expansion] = STATE(157),
    [sym_expansion] = STATE(157),
    [sym_command_substitution] = STATE(157),
    [sym_process_substitution] = STATE(157),
    [aux_sym_command_repeat1] = STATE(168),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(261),
    [anon_sym_for] = ACTIONS(263),
    [anon_sym_while] = ACTIONS(265),
    [anon_sym_if] = ACTIONS(267),
    [anon_sym_case] = ACTIONS(269),
    [anon_sym_function] = ACTIONS(271),
    [anon_sym_LPAREN] = ACTIONS(273),
    [anon_sym_BANG] = ACTIONS(275),
    [anon_sym_LBRACK] = ACTIONS(277),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(279),
    [anon_sym_declare] = ACTIONS(281),
    [anon_sym_typeset] = ACTIONS(281),
    [anon_sym_export] = ACTIONS(281),
    [anon_sym_readonly] = ACTIONS(281),
    [anon_sym_local] = ACTIONS(281),
    [anon_sym_unset] = ACTIONS(283),
    [anon_sym_unsetenv] = ACTIONS(283),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(285),
    [anon_sym_DQUOTE] = ACTIONS(287),
    [anon_sym_DOLLAR] = ACTIONS(289),
    [sym_raw_string] = ACTIONS(291),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(293),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(295),
    [anon_sym_BQUOTE] = ACTIONS(297),
    [anon_sym_LT_LPAREN] = ACTIONS(299),
    [anon_sym_GT_LPAREN] = ACTIONS(299),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(301),
  },
  [595] = {
    [sym_concatenation] = STATE(1058),
    [sym_string] = STATE(590),
    [sym_simple_expansion] = STATE(590),
    [sym_string_expansion] = STATE(590),
    [sym_expansion] = STATE(590),
    [sym_command_substitution] = STATE(590),
    [sym_process_substitution] = STATE(590),
    [aux_sym_for_statement_repeat1] = STATE(1058),
    [anon_sym_SEMI_SEMI] = ACTIONS(2239),
    [sym__special_characters] = ACTIONS(2241),
    [anon_sym_DQUOTE] = ACTIONS(2243),
    [anon_sym_DOLLAR] = ACTIONS(1159),
    [sym_raw_string] = ACTIONS(2245),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(2247),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(2249),
    [anon_sym_BQUOTE] = ACTIONS(2251),
    [anon_sym_LT_LPAREN] = ACTIONS(2253),
    [anon_sym_GT_LPAREN] = ACTIONS(2253),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(2245),
    [anon_sym_SEMI] = ACTIONS(2239),
    [anon_sym_LF] = ACTIONS(2255),
    [anon_sym_AMP] = ACTIONS(2239),
  },
  [596] = {
    [sym__terminated_statement] = STATE(1060),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_case_statement] = STATE(599),
    [sym_function_definition] = STATE(599),
    [sym_subshell] = STATE(599),
    [sym_pipeline] = STATE(599),
    [sym_list] = STATE(599),
    [sym_negated_command] = STATE(599),
    [sym_test_command] = STATE(599),
    [sym_declaration_command] = STATE(599),
    [sym_unset_command] = STATE(599),
    [sym_command] = STATE(599),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(600),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(1060),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_done] = ACTIONS(2257),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [597] = {
    [anon_sym_esac] = ACTIONS(2259),
    [anon_sym_PIPE] = ACTIONS(2259),
    [anon_sym_RPAREN] = ACTIONS(2259),
    [anon_sym_SEMI_SEMI] = ACTIONS(2259),
    [anon_sym_PIPE_AMP] = ACTIONS(2259),
    [anon_sym_AMP_AMP] = ACTIONS(2259),
    [anon_sym_PIPE_PIPE] = ACTIONS(2259),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2259),
    [anon_sym_LF] = ACTIONS(2261),
    [anon_sym_AMP] = ACTIONS(2259),
  },
  [598] = {
    [sym__simple_heredoc_body] = ACTIONS(2263),
    [sym__heredoc_body_beginning] = ACTIONS(2263),
    [sym_file_descriptor] = ACTIONS(2263),
    [anon_sym_esac] = ACTIONS(2265),
    [anon_sym_PIPE] = ACTIONS(2265),
    [anon_sym_RPAREN] = ACTIONS(2265),
    [anon_sym_SEMI_SEMI] = ACTIONS(2265),
    [anon_sym_PIPE_AMP] = ACTIONS(2265),
    [anon_sym_AMP_AMP] = ACTIONS(2265),
    [anon_sym_PIPE_PIPE] = ACTIONS(2265),
    [anon_sym_LT] = ACTIONS(2265),
    [anon_sym_GT] = ACTIONS(2265),
    [anon_sym_GT_GT] = ACTIONS(2265),
    [anon_sym_AMP_GT] = ACTIONS(2265),
    [anon_sym_AMP_GT_GT] = ACTIONS(2265),
    [anon_sym_LT_AMP] = ACTIONS(2265),
    [anon_sym_GT_AMP] = ACTIONS(2265),
    [anon_sym_LT_LT] = ACTIONS(2265),
    [anon_sym_LT_LT_DASH] = ACTIONS(2265),
    [anon_sym_LT_LT_LT] = ACTIONS(2265),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2265),
    [anon_sym_LF] = ACTIONS(2263),
    [anon_sym_AMP] = ACTIONS(2265),
  },
  [599] = {
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2267),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2267),
    [anon_sym_LF] = ACTIONS(2269),
    [anon_sym_AMP] = ACTIONS(2267),
  },
  [600] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2267),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(2267),
    [anon_sym_LF] = ACTIONS(2269),
    [anon_sym_AMP] = ACTIONS(2267),
  },
  [601] = {
    [sym__terminated_statement] = STATE(1063),
    [sym_for_statement] = STATE(599),
    [sym_while_statement] = STATE(599),
    [sym_if_statement] = STATE(599),
    [sym_case_statement] = STATE(599),
    [sym_function_definition] = STATE(599),
    [sym_subshell] = STATE(599),
    [sym_pipeline] = STATE(599),
    [sym_list] = STATE(599),
    [sym_negated_command] = STATE(599),
    [sym_test_command] = STATE(599),
    [sym_declaration_command] = STATE(599),
    [sym_unset_command] = STATE(599),
    [sym_command] = STATE(599),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(600),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(1063),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_done] = ACTIONS(2271),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [602] = {
    [anon_sym_esac] = ACTIONS(2273),
    [anon_sym_PIPE] = ACTIONS(2273),
    [anon_sym_RPAREN] = ACTIONS(2273),
    [anon_sym_SEMI_SEMI] = ACTIONS(2273),
    [anon_sym_PIPE_AMP] = ACTIONS(2273),
    [anon_sym_AMP_AMP] = ACTIONS(2273),
    [anon_sym_PIPE_PIPE] = ACTIONS(2273),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2273),
    [anon_sym_LF] = ACTIONS(2275),
    [anon_sym_AMP] = ACTIONS(2273),
  },
  [603] = {
    [sym_file_redirect] = STATE(549),
    [sym_heredoc_redirect] = STATE(549),
    [sym_heredoc_body] = STATE(1064),
    [sym_herestring_redirect] = STATE(549),
    [aux_sym_while_statement_repeat1] = STATE(549),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(341),
    [anon_sym_PIPE] = ACTIONS(2273),
    [anon_sym_SEMI_SEMI] = ACTIONS(2273),
    [anon_sym_PIPE_AMP] = ACTIONS(2273),
    [anon_sym_AMP_AMP] = ACTIONS(2273),
    [anon_sym_PIPE_PIPE] = ACTIONS(2273),
    [anon_sym_LT] = ACTIONS(347),
    [anon_sym_GT] = ACTIONS(347),
    [anon_sym_GT_GT] = ACTIONS(347),
    [anon_sym_AMP_GT] = ACTIONS(347),
    [anon_sym_AMP_GT_GT] = ACTIONS(347),
    [anon_sym_LT_AMP] = ACTIONS(347),
    [anon_sym_GT_AMP] = ACTIONS(347),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(351),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2273),
    [anon_sym_LF] = ACTIONS(2275),
    [anon_sym_AMP] = ACTIONS(2273),
  },
  [604] = {
    [anon_sym_esac] = ACTIONS(2277),
    [anon_sym_PIPE] = ACTIONS(2277),
    [anon_sym_RPAREN] = ACTIONS(2277),
    [anon_sym_SEMI_SEMI] = ACTIONS(2277),
    [anon_sym_PIPE_AMP] = ACTIONS(2277),
    [anon_sym_AMP_AMP] = ACTIONS(2277),
    [anon_sym_PIPE_PIPE] = ACTIONS(2277),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2277),
    [anon_sym_LF] = ACTIONS(2279),
    [anon_sym_AMP] = ACTIONS(2277),
  },
  [605] = {
    [sym__terminated_statement] = STATE(1065),
    [sym_for_statement] = STATE(39),
    [sym_while_statement] = STATE(39),
    [sym_if_statement] = STATE(39),
    [sym_case_statement] = STATE(39),
    [sym_function_definition] = STATE(39),
    [sym_subshell] = STATE(39),
    [sym_pipeline] = STATE(39),
    [sym_list] = STATE(39),
    [sym_negated_command] = STATE(39),
    [sym_test_command] = STATE(39),
    [sym_declaration_command] = STATE(39),
    [sym_unset_command] = STATE(39),
    [sym_command] = STATE(39),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(40),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [606] = {
    [sym__terminated_statement] = STATE(1068),
    [sym_for_statement] = STATE(1066),
    [sym_while_statement] = STATE(1066),
    [sym_if_statement] = STATE(1066),
    [sym_case_statement] = STATE(1066),
    [sym_function_definition] = STATE(1066),
    [sym_subshell] = STATE(1066),
    [sym_pipeline] = STATE(1066),
    [sym_list] = STATE(1066),
    [sym_negated_command] = STATE(1066),
    [sym_test_command] = STATE(1066),
    [sym_declaration_command] = STATE(1066),
    [sym_unset_command] = STATE(1066),
    [sym_command] = STATE(1066),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(1067),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(1068),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_fi] = ACTIONS(2281),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [607] = {
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2283),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2283),
    [anon_sym_LF] = ACTIONS(2285),
    [anon_sym_AMP] = ACTIONS(2283),
  },
  [608] = {
    [anon_sym_fi] = ACTIONS(2287),
    [anon_sym_elif] = ACTIONS(2287),
    [anon_sym_else] = ACTIONS(2287),
    [sym_comment] = ACTIONS(53),
  },
  [609] = {
    [anon_sym_fi] = ACTIONS(2289),
    [sym_comment] = ACTIONS(53),
  },
  [610] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2283),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(2283),
    [anon_sym_LF] = ACTIONS(2285),
    [anon_sym_AMP] = ACTIONS(2283),
  },
  [611] = {
    [sym__terminated_statement] = STATE(1072),
    [sym_for_statement] = STATE(607),
    [sym_while_statement] = STATE(607),
    [sym_if_statement] = STATE(607),
    [sym_elif_clause] = STATE(608),
    [sym_else_clause] = STATE(1071),
    [sym_case_statement] = STATE(607),
    [sym_function_definition] = STATE(607),
    [sym_subshell] = STATE(607),
    [sym_pipeline] = STATE(607),
    [sym_list] = STATE(607),
    [sym_negated_command] = STATE(607),
    [sym_test_command] = STATE(607),
    [sym_declaration_command] = STATE(607),
    [sym_unset_command] = STATE(607),
    [sym_command] = STATE(607),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(610),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(1072),
    [aux_sym_if_statement_repeat1] = STATE(1073),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_fi] = ACTIONS(2291),
    [anon_sym_elif] = ACTIONS(1181),
    [anon_sym_else] = ACTIONS(1183),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [612] = {
    [sym_elif_clause] = STATE(608),
    [sym_else_clause] = STATE(1071),
    [aux_sym_if_statement_repeat1] = STATE(1074),
    [anon_sym_fi] = ACTIONS(2289),
    [anon_sym_elif] = ACTIONS(2293),
    [anon_sym_else] = ACTIONS(2295),
    [sym_comment] = ACTIONS(53),
  },
  [613] = {
    [sym__concat] = ACTIONS(1654),
    [anon_sym_in] = ACTIONS(1656),
    [anon_sym_SEMI_SEMI] = ACTIONS(1656),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1656),
    [anon_sym_LF] = ACTIONS(1654),
    [anon_sym_AMP] = ACTIONS(1656),
  },
  [614] = {
    [sym_case_item] = STATE(1080),
    [sym_last_case_item] = STATE(1078),
    [sym_concatenation] = STATE(1079),
    [sym_string] = STATE(1077),
    [sym_simple_expansion] = STATE(1077),
    [sym_string_expansion] = STATE(1077),
    [sym_expansion] = STATE(1077),
    [sym_command_substitution] = STATE(1077),
    [sym_process_substitution] = STATE(1077),
    [aux_sym_case_statement_repeat1] = STATE(1080),
    [anon_sym_esac] = ACTIONS(2297),
    [sym__special_characters] = ACTIONS(2299),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(2301),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2303),
  },
  [615] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(2305),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2305),
    [anon_sym_LF] = ACTIONS(2307),
    [anon_sym_AMP] = ACTIONS(2305),
  },
  [616] = {
    [aux_sym_concatenation_repeat1] = STATE(616),
    [sym__concat] = ACTIONS(2309),
    [anon_sym_in] = ACTIONS(1656),
    [anon_sym_SEMI_SEMI] = ACTIONS(1656),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1656),
    [anon_sym_LF] = ACTIONS(1654),
    [anon_sym_AMP] = ACTIONS(1656),
  },
  [617] = {
    [sym__concat] = ACTIONS(1703),
    [anon_sym_in] = ACTIONS(1705),
    [anon_sym_SEMI_SEMI] = ACTIONS(1705),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1705),
    [anon_sym_LF] = ACTIONS(1703),
    [anon_sym_AMP] = ACTIONS(1705),
  },
  [618] = {
    [sym_case_item] = STATE(1084),
    [sym_last_case_item] = STATE(1083),
    [sym_concatenation] = STATE(1079),
    [sym_string] = STATE(1077),
    [sym_simple_expansion] = STATE(1077),
    [sym_string_expansion] = STATE(1077),
    [sym_expansion] = STATE(1077),
    [sym_command_substitution] = STATE(1077),
    [sym_process_substitution] = STATE(1077),
    [aux_sym_case_statement_repeat1] = STATE(1084),
    [anon_sym_esac] = ACTIONS(2312),
    [sym__special_characters] = ACTIONS(2299),
    [anon_sym_DQUOTE] = ACTIONS(139),
    [anon_sym_DOLLAR] = ACTIONS(141),
    [sym_raw_string] = ACTIONS(2301),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(145),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(147),
    [anon_sym_BQUOTE] = ACTIONS(149),
    [anon_sym_LT_LPAREN] = ACTIONS(151),
    [anon_sym_GT_LPAREN] = ACTIONS(151),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2303),
  },
  [619] = {
    [anon_sym_SEMI_SEMI] = ACTIONS(2314),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2314),
    [anon_sym_LF] = ACTIONS(2316),
    [anon_sym_AMP] = ACTIONS(2314),
  },
  [620] = {
    [sym_concatenation] = STATE(1089),
    [sym_string] = STATE(1088),
    [sym_simple_expansion] = STATE(1088),
    [sym_string_expansion] = STATE(1088),
    [sym_expansion] = STATE(1088),
    [sym_command_substitution] = STATE(1088),
    [sym_process_substitution] = STATE(1088),
    [anon_sym_RBRACE] = ACTIONS(2318),
    [sym__special_characters] = ACTIONS(2320),
    [anon_sym_DQUOTE] = ACTIONS(1730),
    [anon_sym_DOLLAR] = ACTIONS(1732),
    [sym_raw_string] = ACTIONS(2322),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1736),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1738),
    [anon_sym_BQUOTE] = ACTIONS(1740),
    [anon_sym_LT_LPAREN] = ACTIONS(1742),
    [anon_sym_GT_LPAREN] = ACTIONS(1742),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2322),
  },
  [621] = {
    [sym__concat] = ACTIONS(1744),
    [anon_sym_in] = ACTIONS(1746),
    [anon_sym_SEMI_SEMI] = ACTIONS(1746),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1746),
    [anon_sym_LF] = ACTIONS(1744),
    [anon_sym_AMP] = ACTIONS(1746),
  },
  [622] = {
    [sym_comment] = ACTIONS(177),
    [sym_regex_without_right_brace] = ACTIONS(2324),
  },
  [623] = {
    [sym_concatenation] = STATE(839),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(839),
    [anon_sym_RBRACE] = ACTIONS(2326),
    [anon_sym_EQ] = ACTIONS(1782),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(1782),
    [anon_sym_COLON_QMARK] = ACTIONS(1782),
    [anon_sym_COLON_DASH] = ACTIONS(1782),
    [anon_sym_PERCENT] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(1782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [624] = {
    [anon_sym_LBRACK] = ACTIONS(739),
    [anon_sym_EQ] = ACTIONS(2328),
    [sym_comment] = ACTIONS(53),
  },
  [625] = {
    [sym_concatenation] = STATE(1095),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(1095),
    [anon_sym_RBRACE] = ACTIONS(2330),
    [anon_sym_EQ] = ACTIONS(2332),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(2334),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(2336),
    [anon_sym_COLON] = ACTIONS(2332),
    [anon_sym_COLON_QMARK] = ACTIONS(2332),
    [anon_sym_COLON_DASH] = ACTIONS(2332),
    [anon_sym_PERCENT] = ACTIONS(2332),
    [anon_sym_DASH] = ACTIONS(2332),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [626] = {
    [sym_concatenation] = STATE(1098),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(1098),
    [anon_sym_RBRACE] = ACTIONS(2338),
    [anon_sym_EQ] = ACTIONS(2340),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(2342),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(2344),
    [anon_sym_COLON] = ACTIONS(2340),
    [anon_sym_COLON_QMARK] = ACTIONS(2340),
    [anon_sym_COLON_DASH] = ACTIONS(2340),
    [anon_sym_PERCENT] = ACTIONS(2340),
    [anon_sym_DASH] = ACTIONS(2340),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [627] = {
    [sym_concatenation] = STATE(1100),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(1100),
    [anon_sym_RBRACE] = ACTIONS(2318),
    [anon_sym_EQ] = ACTIONS(2346),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(2348),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [aux_sym_SLASH] = ACTIONS(2350),
    [anon_sym_COLON] = ACTIONS(2346),
    [anon_sym_COLON_QMARK] = ACTIONS(2346),
    [anon_sym_COLON_DASH] = ACTIONS(2346),
    [anon_sym_PERCENT] = ACTIONS(2346),
    [anon_sym_DASH] = ACTIONS(2346),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [628] = {
    [sym__concat] = ACTIONS(1810),
    [anon_sym_in] = ACTIONS(1812),
    [anon_sym_SEMI_SEMI] = ACTIONS(1812),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1812),
    [anon_sym_LF] = ACTIONS(1810),
    [anon_sym_AMP] = ACTIONS(1812),
  },
  [629] = {
    [sym_comment] = ACTIONS(177),
    [sym_regex_without_right_brace] = ACTIONS(2352),
  },
  [630] = {
    [sym_concatenation] = STATE(839),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(839),
    [anon_sym_RBRACE] = ACTIONS(2354),
    [anon_sym_EQ] = ACTIONS(1782),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(1782),
    [anon_sym_COLON_QMARK] = ACTIONS(1782),
    [anon_sym_COLON_DASH] = ACTIONS(1782),
    [anon_sym_PERCENT] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(1782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [631] = {
    [sym__concat] = ACTIONS(1818),
    [anon_sym_in] = ACTIONS(1820),
    [anon_sym_SEMI_SEMI] = ACTIONS(1820),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1820),
    [anon_sym_LF] = ACTIONS(1818),
    [anon_sym_AMP] = ACTIONS(1820),
  },
  [632] = {
    [sym_comment] = ACTIONS(177),
    [sym_regex_without_right_brace] = ACTIONS(2356),
  },
  [633] = {
    [sym_concatenation] = STATE(839),
    [sym_string] = STATE(413),
    [sym_simple_expansion] = STATE(413),
    [sym_string_expansion] = STATE(413),
    [sym_expansion] = STATE(413),
    [sym_command_substitution] = STATE(413),
    [sym_process_substitution] = STATE(413),
    [aux_sym_expansion_repeat1] = STATE(839),
    [anon_sym_RBRACE] = ACTIONS(2318),
    [anon_sym_EQ] = ACTIONS(1782),
    [sym__special_characters] = ACTIONS(747),
    [anon_sym_DQUOTE] = ACTIONS(749),
    [anon_sym_DOLLAR] = ACTIONS(751),
    [sym_raw_string] = ACTIONS(753),
    [anon_sym_POUND] = ACTIONS(1784),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(757),
    [anon_sym_COLON] = ACTIONS(1782),
    [anon_sym_COLON_QMARK] = ACTIONS(1782),
    [anon_sym_COLON_DASH] = ACTIONS(1782),
    [anon_sym_PERCENT] = ACTIONS(1782),
    [anon_sym_DASH] = ACTIONS(1782),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(761),
    [anon_sym_BQUOTE] = ACTIONS(763),
    [anon_sym_LT_LPAREN] = ACTIONS(765),
    [anon_sym_GT_LPAREN] = ACTIONS(765),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(767),
  },
  [634] = {
    [sym__concat] = ACTIONS(1952),
    [anon_sym_in] = ACTIONS(1954),
    [anon_sym_SEMI_SEMI] = ACTIONS(1954),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1954),
    [anon_sym_LF] = ACTIONS(1952),
    [anon_sym_AMP] = ACTIONS(1954),
  },
  [635] = {
    [sym__concat] = ACTIONS(2018),
    [anon_sym_in] = ACTIONS(2020),
    [anon_sym_SEMI_SEMI] = ACTIONS(2020),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2020),
    [anon_sym_LF] = ACTIONS(2018),
    [anon_sym_AMP] = ACTIONS(2020),
  },
  [636] = {
    [sym_compound_statement] = STATE(1104),
    [anon_sym_LBRACE] = ACTIONS(455),
    [sym_comment] = ACTIONS(53),
  },
  [637] = {
    [sym_file_descriptor] = ACTIONS(2358),
    [anon_sym_esac] = ACTIONS(2360),
    [anon_sym_PIPE] = ACTIONS(2360),
    [anon_sym_RPAREN] = ACTIONS(2360),
    [anon_sym_SEMI_SEMI] = ACTIONS(2360),
    [anon_sym_PIPE_AMP] = ACTIONS(2360),
    [anon_sym_AMP_AMP] = ACTIONS(2360),
    [anon_sym_PIPE_PIPE] = ACTIONS(2360),
    [anon_sym_LT] = ACTIONS(2360),
    [anon_sym_GT] = ACTIONS(2360),
    [anon_sym_GT_GT] = ACTIONS(2360),
    [anon_sym_AMP_GT] = ACTIONS(2360),
    [anon_sym_AMP_GT_GT] = ACTIONS(2360),
    [anon_sym_LT_AMP] = ACTIONS(2360),
    [anon_sym_GT_AMP] = ACTIONS(2360),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2360),
    [anon_sym_LF] = ACTIONS(2358),
    [anon_sym_AMP] = ACTIONS(2360),
  },
  [638] = {
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2362),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2362),
    [anon_sym_LF] = ACTIONS(2364),
    [anon_sym_AMP] = ACTIONS(2362),
  },
  [639] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(329),
    [anon_sym_SEMI_SEMI] = ACTIONS(2362),
    [anon_sym_PIPE_AMP] = ACTIONS(329),
    [anon_sym_AMP_AMP] = ACTIONS(333),
    [anon_sym_PIPE_PIPE] = ACTIONS(333),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(2362),
    [anon_sym_LF] = ACTIONS(2364),
    [anon_sym_AMP] = ACTIONS(2362),
  },
  [640] = {
    [sym__terminated_statement] = STATE(1107),
    [sym_for_statement] = STATE(638),
    [sym_while_statement] = STATE(638),
    [sym_if_statement] = STATE(638),
    [sym_case_statement] = STATE(638),
    [sym_function_definition] = STATE(638),
    [sym_subshell] = STATE(638),
    [sym_pipeline] = STATE(638),
    [sym_list] = STATE(638),
    [sym_negated_command] = STATE(638),
    [sym_test_command] = STATE(638),
    [sym_declaration_command] = STATE(638),
    [sym_unset_command] = STATE(638),
    [sym_command] = STATE(638),
    [sym_command_name] = STATE(27),
    [sym_variable_assignment] = STATE(639),
    [sym_subscript] = STATE(29),
    [sym_file_redirect] = STATE(30),
    [sym_concatenation] = STATE(31),
    [sym_string] = STATE(19),
    [sym_simple_expansion] = STATE(19),
    [sym_string_expansion] = STATE(19),
    [sym_expansion] = STATE(19),
    [sym_command_substitution] = STATE(19),
    [sym_process_substitution] = STATE(19),
    [aux_sym_program_repeat1] = STATE(1107),
    [aux_sym_command_repeat1] = STATE(33),
    [sym_file_descriptor] = ACTIONS(5),
    [sym_variable_name] = ACTIONS(7),
    [anon_sym_for] = ACTIONS(11),
    [anon_sym_while] = ACTIONS(13),
    [anon_sym_if] = ACTIONS(15),
    [anon_sym_case] = ACTIONS(17),
    [anon_sym_function] = ACTIONS(19),
    [anon_sym_LPAREN] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(2366),
    [anon_sym_BANG] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_LBRACK_LBRACK] = ACTIONS(27),
    [anon_sym_declare] = ACTIONS(29),
    [anon_sym_typeset] = ACTIONS(29),
    [anon_sym_export] = ACTIONS(29),
    [anon_sym_readonly] = ACTIONS(29),
    [anon_sym_local] = ACTIONS(29),
    [anon_sym_unset] = ACTIONS(31),
    [anon_sym_unsetenv] = ACTIONS(31),
    [anon_sym_LT] = ACTIONS(33),
    [anon_sym_GT] = ACTIONS(33),
    [anon_sym_GT_GT] = ACTIONS(35),
    [anon_sym_AMP_GT] = ACTIONS(33),
    [anon_sym_AMP_GT_GT] = ACTIONS(35),
    [anon_sym_LT_AMP] = ACTIONS(35),
    [anon_sym_GT_AMP] = ACTIONS(35),
    [sym__special_characters] = ACTIONS(37),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(43),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(55),
  },
  [641] = {
    [anon_sym_LT] = ACTIONS(2368),
    [anon_sym_GT] = ACTIONS(2368),
    [anon_sym_GT_GT] = ACTIONS(2370),
    [anon_sym_AMP_GT] = ACTIONS(2368),
    [anon_sym_AMP_GT_GT] = ACTIONS(2370),
    [anon_sym_LT_AMP] = ACTIONS(2370),
    [anon_sym_GT_AMP] = ACTIONS(2370),
    [sym_comment] = ACTIONS(53),
  },
  [642] = {
    [sym_concatenation] = STATE(1111),
    [sym_string] = STATE(1110),
    [sym_simple_expansion] = STATE(1110),
    [sym_string_expansion] = STATE(1110),
    [sym_expansion] = STATE(1110),
    [sym_command_substitution] = STATE(1110),
    [sym_process_substitution] = STATE(1110),
    [sym__special_characters] = ACTIONS(2372),
    [anon_sym_DQUOTE] = ACTIONS(629),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [sym_raw_string] = ACTIONS(2374),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1533),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1535),
    [anon_sym_BQUOTE] = ACTIONS(1537),
    [anon_sym_LT_LPAREN] = ACTIONS(1539),
    [anon_sym_GT_LPAREN] = ACTIONS(1539),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2374),
  },
  [643] = {
    [anon_sym_esac] = ACTIONS(2376),
    [anon_sym_PIPE] = ACTIONS(2376),
    [anon_sym_RPAREN] = ACTIONS(2376),
    [anon_sym_SEMI_SEMI] = ACTIONS(2376),
    [anon_sym_PIPE_AMP] = ACTIONS(2376),
    [anon_sym_AMP_AMP] = ACTIONS(2376),
    [anon_sym_PIPE_PIPE] = ACTIONS(2376),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2376),
    [anon_sym_LF] = ACTIONS(2378),
    [anon_sym_AMP] = ACTIONS(2376),
  },
  [644] = {
    [aux_sym_concatenation_repeat1] = STATE(1112),
    [sym_file_descriptor] = ACTIONS(1129),
    [sym__concat] = ACTIONS(1131),
    [sym_variable_name] = ACTIONS(1129),
    [anon_sym_PIPE] = ACTIONS(1133),
    [anon_sym_RPAREN] = ACTIONS(1133),
    [anon_sym_SEMI_SEMI] = ACTIONS(1133),
    [anon_sym_PIPE_AMP] = ACTIONS(1133),
    [anon_sym_AMP_AMP] = ACTIONS(1133),
    [anon_sym_PIPE_PIPE] = ACTIONS(1133),
    [anon_sym_LT] = ACTIONS(1133),
    [anon_sym_GT] = ACTIONS(1133),
    [anon_sym_GT_GT] = ACTIONS(1133),
    [anon_sym_AMP_GT] = ACTIONS(1133),
    [anon_sym_AMP_GT_GT] = ACTIONS(1133),
    [anon_sym_LT_AMP] = ACTIONS(1133),
    [anon_sym_GT_AMP] = ACTIONS(1133),
    [sym__special_characters] = ACTIONS(1133),
    [anon_sym_DQUOTE] = ACTIONS(1133),
    [anon_sym_DOLLAR] = ACTIONS(1133),
    [sym_raw_string] = ACTIONS(1133),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1133),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1133),
    [anon_sym_BQUOTE] = ACTIONS(1133),
    [anon_sym_LT_LPAREN] = ACTIONS(1133),
    [anon_sym_GT_LPAREN] = ACTIONS(1133),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1133),
    [anon_sym_SEMI] = ACTIONS(1133),
    [anon_sym_LF] = ACTIONS(1129),
    [anon_sym_AMP] = ACTIONS(1133),
  },
  [645] = {
    [aux_sym_concatenation_repeat1] = STATE(1112),
    [sym_file_descriptor] = ACTIONS(1107),
    [sym__concat] = ACTIONS(1131),
    [sym_variable_name] = ACTIONS(1107),
    [anon_sym_PIPE] = ACTIONS(1109),
    [anon_sym_RPAREN] = ACTIONS(1109),
    [anon_sym_SEMI_SEMI] = ACTIONS(1109),
    [anon_sym_PIPE_AMP] = ACTIONS(1109),
    [anon_sym_AMP_AMP] = ACTIONS(1109),
    [anon_sym_PIPE_PIPE] = ACTIONS(1109),
    [anon_sym_LT] = ACTIONS(1109),
    [anon_sym_GT] = ACTIONS(1109),
    [anon_sym_GT_GT] = ACTIONS(1109),
    [anon_sym_AMP_GT] = ACTIONS(1109),
    [anon_sym_AMP_GT_GT] = ACTIONS(1109),
    [anon_sym_LT_AMP] = ACTIONS(1109),
    [anon_sym_GT_AMP] = ACTIONS(1109),
    [sym__special_characters] = ACTIONS(1109),
    [anon_sym_DQUOTE] = ACTIONS(1109),
    [anon_sym_DOLLAR] = ACTIONS(1109),
    [sym_raw_string] = ACTIONS(1109),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1109),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1109),
    [anon_sym_BQUOTE] = ACTIONS(1109),
    [anon_sym_LT_LPAREN] = ACTIONS(1109),
    [anon_sym_GT_LPAREN] = ACTIONS(1109),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1109),
    [anon_sym_SEMI] = ACTIONS(1109),
    [anon_sym_LF] = ACTIONS(1107),
    [anon_sym_AMP] = ACTIONS(1109),
  },
  [646] = {
    [sym_file_redirect] = STATE(1113),
    [sym_heredoc_redirect] = STATE(1113),
    [sym_heredoc_body] = STATE(602),
    [sym_herestring_redirect] = STATE(1113),
    [aux_sym_while_statement_repeat1] = STATE(1113),
    [sym__simple_heredoc_body] = ACTIONS(337),
    [sym__heredoc_body_beginning] = ACTIONS(339),
    [sym_file_descriptor] = ACTIONS(483),
    [anon_sym_PIPE] = ACTIONS(1175),
    [anon_sym_RPAREN] = ACTIONS(1175),
    [anon_sym_SEMI_SEMI] = ACTIONS(1175),
    [anon_sym_PIPE_AMP] = ACTIONS(1175),
    [anon_sym_AMP_AMP] = ACTIONS(1175),
    [anon_sym_PIPE_PIPE] = ACTIONS(1175),
    [anon_sym_LT] = ACTIONS(487),
    [anon_sym_GT] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(487),
    [anon_sym_AMP_GT] = ACTIONS(487),
    [anon_sym_AMP_GT_GT] = ACTIONS(487),
    [anon_sym_LT_AMP] = ACTIONS(487),
    [anon_sym_GT_AMP] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(349),
    [anon_sym_LT_LT_DASH] = ACTIONS(349),
    [anon_sym_LT_LT_LT] = ACTIONS(489),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1175),
    [anon_sym_LF] = ACTIONS(1177),
    [anon_sym_AMP] = ACTIONS(1175),
  },
  [647] = {
    [anon_sym_RPAREN] = ACTIONS(2380),
    [sym_comment] = ACTIONS(53),
  },
  [648] = {
    [sym_file_redirect] = STATE(643),
    [sym_file_descriptor] = ACTIONS(2382),
    [anon_sym_PIPE] = ACTIONS(1245),
    [anon_sym_RPAREN] = ACTIONS(1245),
    [anon_sym_SEMI_SEMI] = ACTIONS(1245),
    [anon_sym_PIPE_AMP] = ACTIONS(1245),
    [anon_sym_AMP_AMP] = ACTIONS(1245),
    [anon_sym_PIPE_PIPE] = ACTIONS(1245),
    [anon_sym_LT] = ACTIONS(2384),
    [anon_sym_GT] = ACTIONS(2384),
    [anon_sym_GT_GT] = ACTIONS(2384),
    [anon_sym_AMP_GT] = ACTIONS(2384),
    [anon_sym_AMP_GT_GT] = ACTIONS(2384),
    [anon_sym_LT_AMP] = ACTIONS(2384),
    [anon_sym_GT_AMP] = ACTIONS(2384),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1245),
    [anon_sym_LF] = ACTIONS(1249),
    [anon_sym_AMP] = ACTIONS(1245),
  },
  [649] = {
    [sym_file_redirect] = STATE(1120),
    [sym_heredoc_redirect] = STATE(1120),
    [sym_herestring_redirect] = STATE(1120),
    [aux_sym_while_statement_repeat1] = STATE(1120),
    [sym_file_descriptor] = ACTIONS(2386),
    [anon_sym_PIPE] = ACTIONS(1353),
    [anon_sym_RPAREN] = ACTIONS(1353),
    [anon_sym_SEMI_SEMI] = ACTIONS(1353),
    [anon_sym_PIPE_AMP] = ACTIONS(1353),
    [anon_sym_AMP_AMP] = ACTIONS(1353),
    [anon_sym_PIPE_PIPE] = ACTIONS(1353),
    [anon_sym_LT] = ACTIONS(2388),
    [anon_sym_GT] = ACTIONS(2388),
    [anon_sym_GT_GT] = ACTIONS(2388),
    [anon_sym_AMP_GT] = ACTIONS(2388),
    [anon_sym_AMP_GT_GT] = ACTIONS(2388),
    [anon_sym_LT_AMP] = ACTIONS(2388),
    [anon_sym_GT_AMP] = ACTIONS(2388),
    [anon_sym_LT_LT] = ACTIONS(1357),
    [anon_sym_LT_LT_DASH] = ACTIONS(1357),
    [anon_sym_LT_LT_LT] = ACTIONS(2390),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(1353),
    [anon_sym_LF] = ACTIONS(1361),
    [anon_sym_AMP] = ACTIONS(1353),
  },
  [650] = {
    [sym_concatenation] = STATE(729),
    [sym_string] = STATE(1122),
    [sym_array] = STATE(729),
    [sym_simple_expansion] = STATE(1122),
    [sym_string_expansion] = STATE(1122),
    [sym_expansion] = STATE(1122),
    [sym_command_substitution] = STATE(1122),
    [sym_process_substitution] = STATE(1122),
    [sym__empty_value] = ACTIONS(1439),
    [anon_sym_LPAREN] = ACTIONS(1441),
    [sym__special_characters] = ACTIONS(2392),
    [anon_sym_DQUOTE] = ACTIONS(589),
    [anon_sym_DOLLAR] = ACTIONS(165),
    [sym_raw_string] = ACTIONS(2394),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1447),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1449),
    [anon_sym_BQUOTE] = ACTIONS(1451),
    [anon_sym_LT_LPAREN] = ACTIONS(1453),
    [anon_sym_GT_LPAREN] = ACTIONS(1453),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2394),
  },
  [651] = {
    [aux_sym_concatenation_repeat1] = STATE(1123),
    [sym__concat] = ACTIONS(581),
    [sym_variable_name] = ACTIONS(693),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_RPAREN] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(695),
    [sym__special_characters] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(695),
    [anon_sym_BQUOTE] = ACTIONS(695),
    [anon_sym_LT_LPAREN] = ACTIONS(695),
    [anon_sym_GT_LPAREN] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(695),
    [sym_word] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [652] = {
    [sym_variable_assignment] = STATE(652),
    [sym_subscript] = STATE(261),
    [sym_concatenation] = STATE(652),
    [sym_string] = STATE(260),
    [sym_simple_expansion] = STATE(260),
    [sym_string_expansion] = STATE(260),
    [sym_expansion] = STATE(260),
    [sym_command_substitution] = STATE(260),
    [sym_process_substitution] = STATE(260),
    [aux_sym_declaration_command_repeat1] = STATE(652),
    [sym_variable_name] = ACTIONS(2396),
    [anon_sym_PIPE] = ACTIONS(1500),
    [anon_sym_RPAREN] = ACTIONS(1500),
    [anon_sym_SEMI_SEMI] = ACTIONS(1500),
    [anon_sym_PIPE_AMP] = ACTIONS(1500),
    [anon_sym_AMP_AMP] = ACTIONS(1500),
    [anon_sym_PIPE_PIPE] = ACTIONS(1500),
    [sym__special_characters] = ACTIONS(2399),
    [anon_sym_DQUOTE] = ACTIONS(1505),
    [anon_sym_DOLLAR] = ACTIONS(1508),
    [sym_raw_string] = ACTIONS(2402),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1514),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1517),
    [anon_sym_BQUOTE] = ACTIONS(1520),
    [anon_sym_LT_LPAREN] = ACTIONS(1523),
    [anon_sym_GT_LPAREN] = ACTIONS(1523),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1526),
    [sym_word] = ACTIONS(2402),
    [anon_sym_SEMI] = ACTIONS(1500),
    [anon_sym_LF] = ACTIONS(1529),
    [anon_sym_AMP] = ACTIONS(1500),
  },
  [653] = {
    [aux_sym_concatenation_repeat1] = STATE(1124),
    [sym__concat] = ACTIONS(621),
    [anon_sym_PIPE] = ACTIONS(695),
    [anon_sym_RPAREN] = ACTIONS(695),
    [anon_sym_SEMI_SEMI] = ACTIONS(695),
    [anon_sym_PIPE_AMP] = ACTIONS(695),
    [anon_sym_AMP_AMP] = ACTIONS(695),
    [anon_sym_PIPE_PIPE] = ACTIONS(695),
    [sym__special_characters] = ACTIONS(695),
    [anon_sym_DQUOTE] = ACTIONS(695),
    [anon_sym_DOLLAR] = ACTIONS(695),
    [sym_raw_string] = ACTIONS(695),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(695),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(695),
    [anon_sym_BQUOTE] = ACTIONS(695),
    [anon_sym_LT_LPAREN] = ACTIONS(695),
    [anon_sym_GT_LPAREN] = ACTIONS(695),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(695),
    [sym_word] = ACTIONS(695),
    [anon_sym_SEMI] = ACTIONS(695),
    [anon_sym_LF] = ACTIONS(693),
    [anon_sym_AMP] = ACTIONS(695),
  },
  [654] = {
    [sym_concatenation] = STATE(654),
    [sym_string] = STATE(264),
    [sym_simple_expansion] = STATE(264),
    [sym_string_expansion] = STATE(264),
    [sym_expansion] = STATE(264),
    [sym_command_substitution] = STATE(264),
    [sym_process_substitution] = STATE(264),
    [aux_sym_unset_command_repeat1] = STATE(654),
    [anon_sym_PIPE] = ACTIONS(1581),
    [anon_sym_RPAREN] = ACTIONS(1581),
    [anon_sym_SEMI_SEMI] = ACTIONS(1581),
    [anon_sym_PIPE_AMP] = ACTIONS(1581),
    [anon_sym_AMP_AMP] = ACTIONS(1581),
    [anon_sym_PIPE_PIPE] = ACTIONS(1581),
    [sym__special_characters] = ACTIONS(2405),
    [anon_sym_DQUOTE] = ACTIONS(1586),
    [anon_sym_DOLLAR] = ACTIONS(1589),
    [sym_raw_string] = ACTIONS(2408),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1595),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1598),
    [anon_sym_BQUOTE] = ACTIONS(1601),
    [anon_sym_LT_LPAREN] = ACTIONS(1604),
    [anon_sym_GT_LPAREN] = ACTIONS(1604),
    [sym_comment] = ACTIONS(177),
    [aux_sym_SLASH_BSLASHw_PLUS_SLASH] = ACTIONS(1607),
    [sym_word] = ACTIONS(2408),
    [anon_sym_SEMI] = ACTIONS(1581),
    [anon_sym_LF] = ACTIONS(1610),
    [anon_sym_AMP] = ACTIONS(1581),
  },
  [655] = {
    [aux_sym_concatenation_repeat1] = STATE(655),
    [sym__simple_heredoc_body] = ACTIONS(1654),
    [sym__heredoc_body_beginning] = ACTIONS(1654),
    [sym_file_descriptor] = ACTIONS(1654),
    [sym__concat] = ACTIONS(1658),
    [anon_sym_PIPE] = ACTIONS(1656),
    [anon_sym_RPAREN] = ACTIONS(1656),
    [anon_sym_SEMI_SEMI] = ACTIONS(1656),
    [anon_sym_PIPE_AMP] = ACTIONS(1656),
    [anon_sym_AMP_AMP] = ACTIONS(1656),
    [anon_sym_PIPE_PIPE] = ACTIONS(1656),
    [anon_sym_EQ_TILDE] = ACTIONS(1656),
    [anon_sym_EQ_EQ] = ACTIONS(1656),
    [anon_sym_LT] = ACTIONS(1656),
    [anon_sym_GT] = ACTIONS(1656),
    [anon_sym_GT_GT] = ACTIONS(1656),
    [anon_sym_AMP_GT] = ACTIONS(1656),
    [anon_sym_AMP_GT_GT] = ACTIONS(1656),
    [anon_sym_LT_AMP] = ACTIONS(1656),
    [anon_sym_GT_AMP] = ACTIONS(1656),
    [anon_sym_LT_LT] = ACTIONS(1656),
    [anon_sym_LT_LT_DASH] = ACTIONS(1656),
    [anon_sym_LT_LT_LT] = ACTIONS(1656),
    [sym__special_characters] = ACTIONS(1656),
    [anon_sym_DQUOTE] = ACTIONS(1656),
    [anon_sym_DOLLAR] = ACTIONS(1656),
    [sym_raw_string] = ACTIONS(1656),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1656),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(1656),
    [anon_sym_BQUOTE] = ACTIONS(1656),
    [anon_sym_LT_LPAREN] = ACTIONS(1656),
    [anon_sym_GT_LPAREN] = ACTIONS(1656),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(1656),
    [anon_sym_SEMI] = ACTIONS(1656),
    [anon_sym_LF] = ACTIONS(1654),
    [anon_sym_AMP] = ACTIONS(1656),
  },
  [656] = {
    [sym_compound_statement] = STATE(1125),
    [anon_sym_LBRACE] = ACTIONS(455),
    [sym_comment] = ACTIONS(53),
  },
  [657] = {
    [anon_sym_esac] = ACTIONS(2411),
    [anon_sym_PIPE] = ACTIONS(2411),
    [anon_sym_RPAREN] = ACTIONS(2411),
    [anon_sym_SEMI_SEMI] = ACTIONS(2411),
    [anon_sym_PIPE_AMP] = ACTIONS(2411),
    [anon_sym_AMP_AMP] = ACTIONS(2411),
    [anon_sym_PIPE_PIPE] = ACTIONS(2411),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2411),
    [anon_sym_LF] = ACTIONS(2413),
    [anon_sym_AMP] = ACTIONS(2411),
  },
  [658] = {
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(2026),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [sym_comment] = ACTIONS(177),
    [anon_sym_SEMI] = ACTIONS(2026),
    [anon_sym_LF] = ACTIONS(2028),
    [anon_sym_AMP] = ACTIONS(2026),
  },
  [659] = {
    [sym_file_descriptor] = ACTIONS(369),
    [sym_variable_name] = ACTIONS(369),
    [anon_sym_PIPE] = ACTIONS(473),
    [anon_sym_RPAREN] = ACTIONS(2026),
    [anon_sym_SEMI_SEMI] = ACTIONS(2026),
    [anon_sym_PIPE_AMP] = ACTIONS(473),
    [anon_sym_AMP_AMP] = ACTIONS(2026),
    [anon_sym_PIPE_PIPE] = ACTIONS(2026),
    [anon_sym_LT] = ACTIONS(371),
    [anon_sym_GT] = ACTIONS(371),
    [anon_sym_GT_GT] = ACTIONS(371),
    [anon_sym_AMP_GT] = ACTIONS(371),
    [anon_sym_AMP_GT_GT] = ACTIONS(371),
    [anon_sym_LT_AMP] = ACTIONS(371),
    [anon_sym_GT_AMP] = ACTIONS(371),
    [sym__special_characters] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(371),
    [anon_sym_DOLLAR] = ACTIONS(371),
    [sym_raw_string] = ACTIONS(371),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(371),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(371),
    [anon_sym_BQUOTE] = ACTIONS(371),
    [anon_sym_LT_LPAREN] = ACTIONS(371),
    [anon_sym_GT_LPAREN] = ACTIONS(371),
    [sym_comment] = ACTIONS(177),
    [sym_word] = ACTIONS(371),
    [anon_sym_SEMI] = ACTIONS(2026),
    [anon_sym_LF] = ACTIONS(2028),
    [anon_sym_AMP] = ACTIONS(2026),
  },
  [660] = {
    [sym_concatenation] = STATE(991),
    [sym_string] = STATE(1127),
    [sym_simple_expansion] = STATE(1127),
    [sym_string_expansion] = STATE(1127),
    [sym_expansion] = STATE(1127),
    [sym_command_substitution] = STATE(1127),
    [sym_process_substitution] = STATE(1127),
    [sym__special_characters] = ACTIONS(2415),
    [anon_sym_DQUOTE] = ACTIONS(39),
    [anon_sym_DOLLAR] = ACTIONS(41),
    [sym_raw_string] = ACTIONS(2417),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(45),
    [anon_sym_DOLLAR_LPAREN] = ACTIONS(47),
    [anon_sym_BQUOTE] = ACTIONS(49),
    [anon_sym_LT_LPAREN] = ACTIONS(51),
    [anon_sym_GT_LPAREN] = ACTIONS(51),
    [sym_comment] = ACTIONS(53),
    [sym_word] = ACTIONS(2417),
  },
  [661] = {
    [aux_sym_concatenation_repeat1] = STATE(266),
    [sym__simple_heredoc_body] = ACTIONS(2058),
    [sym__heredoc_body_beginning] = ACTIONS(2058),
    [sym_file_descriptor] = ACTIONS(2058),
    [sym__concat] = ACTIONS(223),
    [anon_sym_PIPE] = ACTIONS(2060),
    [anon_sym_RPAREN] = ACTIONS(2060),
    [anon_sym_SEMI_S