/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.common;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.JSeparator;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class CommandButtonLayoutManagerTile
implements CommandButtonLayoutManager {
    @Override
    public int getPreferredIconSize() {
        return 32;
    }

    @Override
    public Dimension getPreferredSize(AbstractCommandButton commandButton) {
        Insets borderInsets = commandButton.getInsets();
        int by = borderInsets.top + borderInsets.bottom;
        FontMetrics fm = commandButton.getFontMetrics(commandButton.getFont());
        String buttonText = commandButton.getText();
        int titleWidth = buttonText == null ? 0 : fm.stringWidth(commandButton.getText());
        String extraText = commandButton.getExtraText();
        int extraWidth = extraText == null ? 0 : fm.stringWidth(extraText);
        double textWidth = Math.max(titleWidth, extraWidth);
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        boolean hasIcon = commandButton.getIcon() != null;
        boolean hasText = textWidth > 0.0;
        boolean hasPopupIcon = FlamingoUtilities.hasPopupAction(commandButton);
        int prefIconSize = hasIcon ? this.getPreferredIconSize() : 0;
        int width = borderInsets.left;
        if (hasIcon) {
            width += layoutHGap;
            width += prefIconSize;
            width += layoutHGap;
        }
        if (hasText) {
            width += layoutHGap;
            width = (int)((double)width + textWidth);
            width += layoutHGap;
        }
        if (hasPopupIcon) {
            width += 2 * layoutHGap;
            width += 1 + fm.getHeight() / 2;
            width += 2 * layoutHGap;
        }
        if (commandButton instanceof JCommandButton) {
            JCommandButton jcb = (JCommandButton)commandButton;
            JCommandButton.CommandButtonKind buttonKind = jcb.getCommandButtonKind();
            boolean hasSeparator = false;
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION && (hasIcon || hasText)) {
                hasSeparator = true;
            }
            if (buttonKind == JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP && hasIcon) {
                hasSeparator = true;
            }
            if (hasSeparator) {
                width += new JSeparator((int)1).getPreferredSize().width;
            }
        }
        width += borderInsets.right;
        return new Dimension(width -= 2 * layoutHGap, by + Math.max(prefIconSize, 2 * (fm.getAscent() + fm.getDescent())));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    @Override
    public Point getKeyTipAnchorCenterPoint(AbstractCommandButton commandButton) {
        Insets ins = commandButton.getInsets();
        int height = commandButton.getHeight();
        ResizableIcon buttonIcon = commandButton.getIcon();
        if (buttonIcon != null) {
            return new Point(ins.left + buttonIcon.getIconWidth(), (height + buttonIcon.getIconHeight()) / 2);
        }
        return new Point(ins.left, 3 * height / 4);
    }

    @Override
    public CommandButtonLayoutManager.CommandButtonLayoutInfo getLayoutInfo(AbstractCommandButton commandButton, Graphics g) {
        CommandButtonLayoutManager.CommandButtonLayoutInfo result = new CommandButtonLayoutManager.CommandButtonLayoutInfo();
        result.actionClickArea = new Rectangle(0, 0, 0, 0);
        result.popupClickArea = new Rectangle(0, 0, 0, 0);
        Insets ins = commandButton.getInsets();
        result.iconRect = new Rectangle();
        result.popupActionRect = new Rectangle();
        int width = commandButton.getWidth();
        int height = commandButton.getHeight();
        int prefWidth = this.getPreferredSize((AbstractCommandButton)commandButton).width;
        int shiftX = 0;
        if (commandButton.getHorizontalAlignment() == 0 && width > prefWidth) {
            shiftX = (width - prefWidth) / 2;
        }
        ResizableIcon buttonIcon = commandButton.getIcon();
        String buttonText = commandButton.getText();
        String buttonExtraText = commandButton.getExtraText();
        boolean hasIcon = buttonIcon != null;
        boolean hasText = buttonText != null || buttonExtraText != null;
        boolean hasPopupIcon = FlamingoUtilities.hasPopupAction(commandButton);
        boolean ltr = commandButton.getComponentOrientation().isLeftToRight();
        FontMetrics fm = g.getFontMetrics();
        int labelHeight = fm.getAscent() + fm.getDescent();
        JCommandButton.CommandButtonKind buttonKind = commandButton instanceof JCommandButton ? ((JCommandButton)commandButton).getCommandButtonKind() : JCommandButton.CommandButtonKind.ACTION_ONLY;
        int layoutHGap = FlamingoUtilities.getHLayoutGap(commandButton);
        if (ltr) {
            int x = ins.left + shiftX - layoutHGap;
            if (hasIcon) {
                int iconHeight = buttonIcon.getIconHeight();
                int iconWidth = buttonIcon.getIconWidth();
                result.iconRect.x = x += layoutHGap;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x += iconWidth + layoutHGap;
            }
            if (hasText) {
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                lineLayoutInfo.text = commandButton.getText();
                lineLayoutInfo.textRect = new Rectangle();
                lineLayoutInfo.textRect.x = x += layoutHGap;
                lineLayoutInfo.textRect.y = (height - 2 * labelHeight) / 2;
                lineLayoutInfo.textRect.width = buttonText == null ? 0 : (int)fm.getStringBounds(buttonText, g).getWidth();
                lineLayoutInfo.textRect.height = labelHeight;
                result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.textLayoutInfoList.add(lineLayoutInfo);
                String extraText = commandButton.getExtraText();
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo.text = extraText;
                extraLineLayoutInfo.textRect = new Rectangle();
                extraLineLayoutInfo.textRect.x = x;
                extraLineLayoutInfo.textRect.y = lineLayoutInfo.textRect.y + labelHeight;
                extraLineLayoutInfo.textRect.width = extraText == null ? 0 : (int)fm.getStringBounds(extraText, g).getWidth();
                extraLineLayoutInfo.textRect.height = labelHeight;
                result.extraTextLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo);
                x += Math.max(lineLayoutInfo.textRect.width, extraLineLayoutInfo.textRect.width);
                x += layoutHGap;
            }
            if (hasPopupIcon) {
                result.popupActionRect.x = x += 2 * layoutHGap;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.height = labelHeight + 2;
                x += result.popupActionRect.width;
                x += 2 * layoutHGap;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: {
                    if (hasText || hasIcon) {
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.popupActionRect.x - 2 * layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        if (result.textLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : result.textLayoutInfoList) {
                                textLayoutInfo.textRect.x += verticalSeparatorWidth;
                            }
                        }
                        if (result.extraTextLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : result.extraTextLayoutInfoList) {
                                extraTextLayoutInfo.textRect.x += verticalSeparatorWidth;
                            }
                        }
                        result.popupActionRect.x += verticalSeparatorWidth;
                        xBorderBetweenActionAndPopup = result.iconRect.x + result.iconRect.width + layoutHGap;
                        result.actionClickArea.x = 0;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = xBorderBetweenActionAndPopup;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        } else {
            int x = width - ins.right - shiftX + layoutHGap;
            if (hasIcon) {
                int iconHeight = buttonIcon.getIconHeight();
                int iconWidth = buttonIcon.getIconWidth();
                result.iconRect.x = (x -= layoutHGap) - iconWidth;
                result.iconRect.y = (height - iconHeight) / 2;
                result.iconRect.width = iconWidth;
                result.iconRect.height = iconHeight;
                x -= iconWidth + layoutHGap;
            }
            if (hasText) {
                CommandButtonLayoutManager.TextLayoutInfo lineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                lineLayoutInfo.text = commandButton.getText();
                (lineLayoutInfo.textRect = new Rectangle()).width = buttonText == null ? 0 : (int)fm.getStringBounds(buttonText, g).getWidth();
                lineLayoutInfo.textRect.x = (x -= layoutHGap) - lineLayoutInfo.textRect.width;
                lineLayoutInfo.textRect.y = (height - 2 * labelHeight) / 2;
                lineLayoutInfo.textRect.height = labelHeight;
                result.textLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.textLayoutInfoList.add(lineLayoutInfo);
                String extraText = commandButton.getExtraText();
                CommandButtonLayoutManager.TextLayoutInfo extraLineLayoutInfo = new CommandButtonLayoutManager.TextLayoutInfo();
                extraLineLayoutInfo.text = extraText;
                (extraLineLayoutInfo.textRect = new Rectangle()).width = extraText == null ? 0 : (int)fm.getStringBounds(extraText, g).getWidth();
                extraLineLayoutInfo.textRect.x = x - extraLineLayoutInfo.textRect.width;
                extraLineLayoutInfo.textRect.y = lineLayoutInfo.textRect.y + labelHeight;
                extraLineLayoutInfo.textRect.height = labelHeight;
                result.extraTextLayoutInfoList = new ArrayList<CommandButtonLayoutManager.TextLayoutInfo>();
                result.extraTextLayoutInfoList.add(extraLineLayoutInfo);
                x -= Math.max(lineLayoutInfo.textRect.width, extraLineLayoutInfo.textRect.width);
                x -= layoutHGap;
            }
            if (hasPopupIcon) {
                result.popupActionRect.width = 1 + labelHeight / 2;
                result.popupActionRect.x = (x -= 2 * layoutHGap) - result.popupActionRect.width;
                result.popupActionRect.y = (height - labelHeight) / 2 - 1;
                result.popupActionRect.height = labelHeight + 2;
                x -= result.popupActionRect.width;
                x -= 2 * layoutHGap;
            }
            int xBorderBetweenActionAndPopup = 0;
            int verticalSeparatorWidth = new JSeparator((int)1).getPreferredSize().width;
            switch (buttonKind) {
                case ACTION_ONLY: {
                    result.actionClickArea.x = 0;
                    result.actionClickArea.y = 0;
                    result.actionClickArea.width = width;
                    result.actionClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case POPUP_ONLY: {
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = false;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_ACTION: {
                    if (hasText || hasIcon) {
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.popupActionRect.x + result.popupActionRect.width + 2 * layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                    break;
                }
                case ACTION_AND_POPUP_MAIN_POPUP: {
                    if (hasIcon) {
                        if (result.textLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo textLayoutInfo : result.textLayoutInfoList) {
                                textLayoutInfo.textRect.x -= verticalSeparatorWidth;
                            }
                        }
                        if (result.extraTextLayoutInfoList != null) {
                            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : result.extraTextLayoutInfoList) {
                                extraTextLayoutInfo.textRect.x -= verticalSeparatorWidth;
                            }
                        }
                        result.popupActionRect.x -= verticalSeparatorWidth;
                        result.actionClickArea.x = xBorderBetweenActionAndPopup = result.iconRect.x - layoutHGap;
                        result.actionClickArea.y = 0;
                        result.actionClickArea.width = width - xBorderBetweenActionAndPopup;
                        result.actionClickArea.height = height;
                        result.popupClickArea.x = 0;
                        result.popupClickArea.y = 0;
                        result.popupClickArea.width = xBorderBetweenActionAndPopup;
                        result.popupClickArea.height = height;
                        result.separatorOrientation = CommandButtonLayoutManager.CommandButtonSeparatorOrientation.VERTICAL;
                        result.separatorArea = new Rectangle();
                        result.separatorArea.x = xBorderBetweenActionAndPopup;
                        result.separatorArea.y = 0;
                        result.separatorArea.width = verticalSeparatorWidth;
                        result.separatorArea.height = height;
                        result.isTextInActionArea = true;
                        break;
                    }
                    result.popupClickArea.x = 0;
                    result.popupClickArea.y = 0;
                    result.popupClickArea.width = width;
                    result.popupClickArea.height = height;
                    result.isTextInActionArea = true;
                }
            }
        }
        return result;
    }
}

