/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.Behavior;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.Bounds;
import javax.media.j3d.DistanceLOD;
import javax.media.j3d.IllegalSceneGraphException;
import javax.media.j3d.IllegalSharingException;
import javax.media.j3d.IndexedUnorderSet;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroupRetained;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupCondition;

class BehaviorRetained
extends LeafRetained {
    static final int WAKEUP_ACTIVATE_INDEX = 0;
    static final int WAKEUP_DEACTIVATE_INDEX = 1;
    static final int WAKEUP_VP_ENTRY_INDEX = 2;
    static final int WAKEUP_VP_EXIT_INDEX = 3;
    static final int WAKEUP_TIME_INDEX = 4;
    static final int NUM_WAKEUPS = 5;
    static final int WAKEUP_ACTIVATE = 1;
    static final int WAKEUP_DEACTIVATE = 2;
    static final int WAKEUP_VP_ENTRY = 4;
    static final int WAKEUP_VP_EXIT = 8;
    static final int WAKEUP_TIME = 16;
    static final int NUM_SCHEDULING_INTERVALS = 10;
    static final int BEHAIVORS_IN_BS_LIST = 0;
    static final int SCHEDULE_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    Bounds schedulingRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    WakeupCondition wakeupCondition = null;
    WakeupCondition newWakeupCondition = null;
    ViewPlatformRetained vp = null;
    boolean active = false;
    boolean enable = true;
    int schedulingInterval = 5;
    boolean conditionSet = false;
    boolean inCallback = false;
    boolean inInitCallback = false;
    Bounds transformedRegion = null;
    int isDirty = 65535;
    int wakeupMask = 0;
    int[] wakeupArray = new int[5];
    Object[] targets = new Object[1];

    BehaviorRetained() {
        this.nodeType = 17;
        this.localBounds = new BoundingBox((Bounds)null);
        this.targets[0] = this;
        IndexedUnorderSet.init(this, 2);
    }

    Bounds getSchedulingBounds() {
        Bounds bounds = null;
        if (this.schedulingRegion != null) {
            bounds = (Bounds)this.schedulingRegion.clone();
            if (this.staticTransform != null) {
                Transform3D transform3D = this.staticTransform.getInvTransform();
                bounds.transform(transform3D);
            }
        }
        return bounds;
    }

    synchronized void setSchedulingBounds(Bounds bounds) {
        if (bounds != null) {
            this.schedulingRegion = (Bounds)bounds.clone();
            if (this.staticTransform != null) {
                this.schedulingRegion.transform(this.staticTransform.transform);
            }
        } else {
            this.schedulingRegion = null;
        }
        if (this.source != null && this.source.isLive()) {
            this.sendMessage(35);
        }
    }

    synchronized void setSchedulingBoundingLeaf(BoundingLeaf boundingLeaf) {
        if (this.source != null && this.source.isLive() && this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
        this.boundingLeaf = boundingLeaf != null ? (BoundingLeafRetained)boundingLeaf.retained : null;
        if (this.source != null && this.source.isLive()) {
            if (this.boundingLeaf != null) {
                this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
            }
            this.sendMessage(35);
        }
    }

    void setEnable(boolean bl) {
        if (this.enable != bl) {
            this.enable = bl;
            if (this.source != null && this.source.isLive()) {
                this.sendMessage(bl ? 29 : 30);
            }
        }
    }

    boolean getEnable() {
        return this.enable;
    }

    void setSchedulingInterval(int n) {
        if (this.source != null && this.source.isLive() && !this.inCallback) {
            this.sendMessage(55, new Integer(n));
        } else {
            this.schedulingInterval = n;
        }
    }

    int getSchedulingInterval() {
        return this.schedulingInterval;
    }

    BoundingLeaf getSchedulingBoundingLeaf() {
        return this.boundingLeaf != null ? (BoundingLeaf)this.boundingLeaf.source : null;
    }

    synchronized void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("BehaviorRetained0"));
        }
        if (this.inSharedGroup) {
            throw new IllegalSharingException(J3dI18N.getString("BehaviorRetained1"));
        }
        setLiveState.nodeList.add(this);
        setLiveState.behaviorNodes.add(this);
        setLiveState.notifyThreads |= 0x100;
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 2);
        }
        this.switchState = setLiveState.switchStates.get(0);
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.addUser(this);
        }
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 2);
            setLiveState.notifyThreads |= 0x2000;
        }
        super.markAsLive();
    }

    synchronized void clearLive(SetLiveState setLiveState) {
        super.clearLive(setLiveState);
        setLiveState.nodeList.add(this);
        if (setLiveState.transformTargets != null && setLiveState.transformTargets[0] != null) {
            setLiveState.transformTargets[0].addNode(this, 2);
            setLiveState.notifyThreads |= 0x2000;
        }
        setLiveState.notifyThreads |= 0x100;
        if (setLiveState.switchTargets != null && setLiveState.switchTargets[0] != null) {
            setLiveState.switchTargets[0].addNode(this, 2);
        }
        if (this.boundingLeaf != null) {
            this.boundingLeaf.mirrorBoundingLeaf.removeUser(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeInitialize() {
        BehaviorRetained behaviorRetained = this;
        synchronized (behaviorRetained) {
            boolean bl = this.inCallback;
            boolean bl2 = this.inInitCallback;
            this.inCallback = true;
            this.inInitCallback = true;
            try {
                ((Behavior)this.source).initialize();
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Exception occurred during Behavior initialization:");
                runtimeException.printStackTrace();
            }
            catch (Error error) {
                System.err.println("Error occurred during Behavior initialization:");
                error.printStackTrace();
            }
            this.inCallback = bl;
            this.inInitCallback = bl2;
        }
    }

    void wakeupOn(WakeupCondition wakeupCondition) {
        if (wakeupCondition == null) {
            throw new NullPointerException(J3dI18N.getString("BehaviorRetained2"));
        }
        if (!this.inInitCallback) {
            this.conditionSet = true;
            this.wakeupCondition = wakeupCondition;
        } else {
            this.newWakeupCondition = wakeupCondition;
        }
    }

    void handleLastWakeupOn(WakeupCondition wakeupCondition, BehaviorStructure behaviorStructure) {
        if (behaviorStructure == this.universe.behaviorStructure) {
            if (this.wakeupCondition == wakeupCondition) {
                this.wakeupCondition.resetTree();
            } else {
                if (wakeupCondition != null) {
                    wakeupCondition.cleanTree(behaviorStructure);
                }
                this.wakeupCondition.buildTree(null, 0, this);
            }
        }
    }

    WakeupCondition getWakeupCondition() {
        return this.wakeupCondition;
    }

    void postId(int n) {
        if (this.source != null && this.source.isLive()) {
            this.universe.behaviorStructure.handleBehaviorPost((Behavior)this.source, n);
        }
    }

    protected View getView() {
        return this.universe != null ? this.universe.getCurrentView() : null;
    }

    synchronized void updateTransformRegion(Bounds bounds) {
        if (this.boundingLeaf == null) {
            this.updateTransformRegion();
        } else if (bounds == null) {
            this.transformedRegion = null;
        } else {
            this.transformedRegion = (Bounds)bounds.clone();
            this.transformedRegion.transform(this.boundingLeaf.mirrorBoundingLeaf.getCurrentLocalToVworld());
        }
    }

    synchronized void updateTransformRegion() {
        if (this.boundingLeaf == null || !this.boundingLeaf.mirrorBoundingLeaf.switchState.currentSwitchOn) {
            if (this.schedulingRegion == null) {
                this.transformedRegion = null;
            } else {
                if (this.transformedRegion != null) {
                    this.transformedRegion.set(this.schedulingRegion);
                } else {
                    this.transformedRegion = (Bounds)this.schedulingRegion.clone();
                }
                this.transformedRegion.transform(this.getCurrentLocalToVworld());
            }
        } else {
            this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
        }
    }

    void updateBoundingLeaf(long l) {
        this.transformedRegion = this.boundingLeaf.mirrorBoundingLeaf.transformedRegion;
    }

    void addWakeupCondition() {
    }

    final void sendMessage(int n, Object object) {
        J3dMessage j3dMessage = new J3dMessage();
        j3dMessage.threads = 256;
        j3dMessage.type = n;
        j3dMessage.universe = this.universe;
        j3dMessage.args[0] = this.targets;
        j3dMessage.args[1] = this;
        j3dMessage.args[2] = object;
        VirtualUniverse.mc.processMessage(j3dMessage);
    }

    final void sendMessage(int n) {
        this.sendMessage(n, null);
    }

    void mergeTransform(TransformGroupRetained transformGroupRetained) {
        super.mergeTransform(transformGroupRetained);
        if (this.schedulingRegion != null) {
            this.schedulingRegion.transform(transformGroupRetained.transform);
        }
        if (this.source instanceof DistanceLOD) {
            ((DistanceLOD)this.source).mergeTransform(transformGroupRetained);
        }
    }
}

