/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.settings.IvyPattern;
import org.apache.ivy.plugins.matcher.Matcher;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Message;

public abstract class AbstractPatternsBasedResolver
extends BasicResolver {
    private List ivyPatterns = new ArrayList();
    private List artifactPatterns = new ArrayList();
    private boolean m2compatible = false;

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        if (this.isM2compatible()) {
            moduleRevisionId = this.convertM2IdForResourceSearch(moduleRevisionId);
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.ivyPatterns, DefaultArtifact.newIvyArtifact(moduleRevisionId, resolveData.getDate()), this.getRMDParser(dependencyDescriptor, resolveData), resolveData.getDate());
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        ModuleRevisionId moduleRevisionId = artifact.getModuleRevisionId();
        if (this.isM2compatible()) {
            moduleRevisionId = this.convertM2IdForResourceSearch(moduleRevisionId);
        }
        return this.findResourceUsingPatterns(moduleRevisionId, this.artifactPatterns, artifact, this.getDefaultRMDParser(artifact.getModuleRevisionId().getModuleId()), date);
    }

    @Override
    public ResolvedResource findResource(ResolvedResource[] resolvedResourceArray, ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, Date date) {
        if (this.isM2compatible()) {
            moduleRevisionId = this.convertM2ResourceSearchIdToNormal(moduleRevisionId);
        }
        return super.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
    }

    protected ResolvedResource findResourceUsingPatterns(ModuleRevisionId moduleRevisionId, List list, Artifact artifact, ResourceMDParser resourceMDParser, Date date) {
        ArrayList<ResolvedResource> arrayList = new ArrayList<ResolvedResource>();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = this.getSettings().getVersionMatcher().isDynamic(moduleRevisionId);
        boolean bl2 = false;
        ResolvedResource[] resolvedResourceArray = list.iterator();
        while (resolvedResourceArray.hasNext() && !bl2) {
            String string = (String)resolvedResourceArray.next();
            ResolvedResource resolvedResource = this.findResourceUsingPattern(moduleRevisionId, string, artifact, resourceMDParser, date);
            if (resolvedResource == null || hashSet.contains(resolvedResource.getRevision())) continue;
            hashSet.add(resolvedResource.getRevision());
            arrayList.add(resolvedResource);
            bl2 = !bl;
        }
        if (arrayList.size() > 1) {
            resolvedResourceArray = arrayList.toArray(new ResolvedResource[arrayList.size()]);
            return this.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
        }
        if (arrayList.size() == 1) {
            return (ResolvedResource)arrayList.get(0);
        }
        return null;
    }

    protected abstract ResolvedResource findResourceUsingPattern(ModuleRevisionId var1, String var2, Artifact var3, ResourceMDParser var4, Date var5);

    @Override
    protected Collection findNames(Map map, String string) {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.findIvyNames(map, string));
        if (this.isAllownomd()) {
            hashSet.addAll(this.findArtifactNames(map, string));
        }
        return hashSet;
    }

    protected Collection findIvyNames(Map hashMap, String string) {
        HashSet hashSet = new HashSet();
        hashMap = new HashMap<String, String>(hashMap);
        hashMap.put("artifact", "ivy");
        hashMap.put("type", "ivy");
        hashMap.put("ext", "xml");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(hashMap);
        }
        this.findTokenValues(hashSet, this.getIvyPatterns(), hashMap, string);
        this.filterNames(hashSet);
        return hashSet;
    }

    protected Collection findArtifactNames(Map hashMap, String string) {
        HashSet hashSet = new HashSet();
        hashMap = new HashMap(hashMap);
        hashMap.put("artifact", hashMap.get("module"));
        hashMap.put("type", "jar");
        hashMap.put("ext", "jar");
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(hashMap);
        }
        this.findTokenValues(hashSet, this.getArtifactPatterns(), hashMap, string);
        this.filterNames(hashSet);
        return hashSet;
    }

    @Override
    public Map[] listTokenValues(String[] stringArray, Map map) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        List list = this.getIvyPatterns();
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put("type", "ivy");
        hashMap.put("ext", this.getModuleDescriptorExtension());
        if (this.isM2compatible()) {
            this.convertM2TokenValuesForResourceSearch(hashMap);
        }
        for (Object object : list) {
            linkedHashSet.addAll(this.resolveTokenValues(stringArray, (String)object, hashMap, false));
        }
        if (this.isAllownomd()) {
            Object object;
            List list2 = this.getArtifactPatterns();
            hashMap = new HashMap(map);
            hashMap.put("type", "jar");
            hashMap.put("ext", "jar");
            if (this.isM2compatible()) {
                this.convertM2TokenValuesForResourceSearch(hashMap);
            }
            object = list2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                linkedHashSet.addAll(this.resolveTokenValues(stringArray, string, hashMap, true));
            }
        }
        return linkedHashSet.toArray(new Map[linkedHashSet.size()]);
    }

    protected String getModuleDescriptorExtension() {
        return "xml";
    }

    private Set resolveTokenValues(String[] stringArray, String string, Map map, boolean bl) {
        String[] stringArray2;
        Object v;
        Object object;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        HashMap hashMap = new HashMap();
        for (Map.Entry object22 : map.entrySet()) {
            object = object22.getKey();
            v = object22.getValue();
            if (!(v instanceof String)) continue;
            hashMap.put(object, v);
        }
        if (hashSet.isEmpty()) {
            linkedHashSet.add(hashMap);
            return linkedHashSet;
        }
        String string2 = IvyPatternHelper.substituteTokens(string, hashMap);
        String string3 = IvyPatternHelper.getFirstToken(string2);
        if (string3 == null && this.exist(string2)) {
            linkedHashSet.add(hashMap);
            return linkedHashSet;
        }
        hashSet.remove(string3);
        object = null;
        v = map.get(string3);
        if (v instanceof Matcher) {
            object = (Matcher)v;
        }
        if ((stringArray2 = this.listTokenValues(string2, string3)) == null) {
            return linkedHashSet;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray2));
        this.filterNames(arrayList);
        for (String string4 : arrayList) {
            if (object != null && !object.matches(string4)) continue;
            hashMap.put(string3, string4);
            String string5 = IvyPatternHelper.substituteTokens(string2, hashMap);
            HashMap<String, String> hashMap2 = new HashMap<String, String>(map);
            hashMap2.put(string3, string4);
            if (bl && "artifact".equals(string3)) {
                hashMap2.put("module", string4);
            } else if (bl && "module".equals(string3)) {
                hashMap2.put("artifact", string4);
            }
            linkedHashSet.addAll(this.resolveTokenValues(hashSet.toArray(new String[hashSet.size()]), string5, hashMap2, bl));
        }
        return linkedHashSet;
    }

    protected abstract String[] listTokenValues(String var1, String var2);

    protected abstract boolean exist(String var1);

    protected void findTokenValues(Collection collection, List list, Map map, String string) {
    }

    public void addIvyPattern(String string) {
        this.ivyPatterns.add(string);
    }

    public void addArtifactPattern(String string) {
        this.artifactPatterns.add(string);
    }

    public List getIvyPatterns() {
        return Collections.unmodifiableList(this.ivyPatterns);
    }

    public List getArtifactPatterns() {
        return Collections.unmodifiableList(this.artifactPatterns);
    }

    protected void setIvyPatterns(List list) {
        this.ivyPatterns = list;
    }

    protected void setArtifactPatterns(List list) {
        this.artifactPatterns = list;
    }

    public void addConfiguredIvy(IvyPattern ivyPattern) {
        this.ivyPatterns.add(ivyPattern.getPattern());
    }

    public void addConfiguredArtifact(IvyPattern ivyPattern) {
        this.artifactPatterns.add(ivyPattern.getPattern());
    }

    @Override
    public void dumpSettings() {
        String string;
        super.dumpSettings();
        Message.debug("\t\tm2compatible: " + this.isM2compatible());
        Message.debug("\t\tivy patterns:");
        ListIterator listIterator = this.getIvyPatterns().listIterator();
        while (listIterator.hasNext()) {
            string = (String)listIterator.next();
            Message.debug("\t\t\t" + string);
        }
        Message.debug("\t\tartifact patterns:");
        listIterator = this.getArtifactPatterns().listIterator();
        while (listIterator.hasNext()) {
            string = (String)listIterator.next();
            Message.debug("\t\t\t" + string);
        }
    }

    public boolean isM2compatible() {
        return this.m2compatible;
    }

    public void setM2compatible(boolean bl) {
        this.m2compatible = bl;
    }

    protected ModuleRevisionId convertM2ResourceSearchIdToNormal(ModuleRevisionId moduleRevisionId) {
        if (moduleRevisionId.getOrganisation() == null || moduleRevisionId.getOrganisation().indexOf(47) == -1) {
            return moduleRevisionId;
        }
        return ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation().replace('/', '.'), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), moduleRevisionId.getQualifiedExtraAttributes());
    }

    protected ModuleRevisionId convertM2IdForResourceSearch(ModuleRevisionId moduleRevisionId) {
        if (moduleRevisionId.getOrganisation() == null || moduleRevisionId.getOrganisation().indexOf(46) == -1) {
            return moduleRevisionId;
        }
        return ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation().replace('.', '/'), moduleRevisionId.getName(), moduleRevisionId.getBranch(), moduleRevisionId.getRevision(), moduleRevisionId.getQualifiedExtraAttributes());
    }

    protected String convertM2OrganizationForResourceSearch(String string) {
        return string.replace('.', '/');
    }

    protected void convertM2TokenValuesForResourceSearch(Map map) {
        if (map.get("organisation") instanceof String) {
            map.put("organisation", this.convertM2OrganizationForResourceSearch((String)map.get("organisation")));
        }
    }
}

