/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithSharedLibrary;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultCppSharedLibrary
extends DefaultCppBinary
implements CppSharedLibrary,
ConfigurableComponentWithSharedLibrary,
ConfigurableComponentWithLinkUsage,
ConfigurableComponentWithRuntimeUsage,
SoftwareComponentInternal {
    private final RegularFileProperty linkFile;
    private final RegularFileProperty runtimeFile;
    private final Property<LinkSharedLibrary> linkTaskProperty;
    private final Property<Configuration> linkElements;
    private final Property<Configuration> runtimeElements;
    private final ConfigurableFileCollection outputs;

    @Inject
    public DefaultCppSharedLibrary(String name, ProjectLayout projectLayout, ObjectFactory objectFactory, FileOperations fileOperations, Provider<String> baseName, FileCollection sourceFiles, FileCollection componentHeaderDirs, ConfigurationContainer configurations, Configuration implementation, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider, NativeVariantIdentity identity) {
        super(name, projectLayout, objectFactory, baseName, sourceFiles, componentHeaderDirs, configurations, implementation, targetPlatform, toolChain, platformToolProvider, identity);
        this.linkFile = projectLayout.fileProperty();
        this.runtimeFile = projectLayout.fileProperty();
        this.linkTaskProperty = objectFactory.property(LinkSharedLibrary.class);
        this.linkElements = objectFactory.property(Configuration.class);
        this.runtimeElements = objectFactory.property(Configuration.class);
        this.outputs = fileOperations.files(new Object[0]);
    }

    @Override
    public ConfigurableFileCollection getOutputs() {
        return this.outputs;
    }

    public RegularFileProperty getLinkFile() {
        return this.linkFile;
    }

    public RegularFileProperty getRuntimeFile() {
        return this.runtimeFile;
    }

    @Override
    public Property<LinkSharedLibrary> getLinkTask() {
        return this.linkTaskProperty;
    }

    @Override
    public Property<Configuration> getLinkElements() {
        return this.linkElements;
    }

    @Override
    public Property<Configuration> getRuntimeElements() {
        return this.runtimeElements;
    }

    @Override
    @Nullable
    public Linkage getLinkage() {
        return Linkage.SHARED;
    }

    @Override
    public boolean hasRuntimeFile() {
        return true;
    }

    public Set<? extends UsageContext> getUsages() {
        Configuration linkElements = (Configuration)this.getLinkElements().get();
        Configuration runtimeElements = (Configuration)this.getRuntimeElements().get();
        return Sets.newHashSet((Object[])new DefaultUsageContext[]{new DefaultUsageContext(this.getIdentity().getLinkUsageContext(), (Set<? extends PublishArtifact>)linkElements.getAllArtifacts(), linkElements), new DefaultUsageContext(this.getIdentity().getRuntimeUsageContext(), (Set<? extends PublishArtifact>)runtimeElements.getAllArtifacts(), runtimeElements)});
    }

    @Override
    public AttributeContainer getLinkAttributes() {
        return this.getIdentity().getLinkUsageContext().getAttributes();
    }

    @Override
    public AttributeContainer getRuntimeAttributes() {
        return this.getIdentity().getRuntimeUsageContext().getAttributes();
    }

    public ModuleVersionIdentifier getCoordinates() {
        return this.getIdentity().getCoordinates();
    }
}

