/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.BuildIdentifierSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

public class ComponentSelectorSerializer
extends AbstractSerializer<ComponentSelector> {
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final BuildIdentifierSerializer buildIdentifierSerializer;

    public ComponentSelectorSerializer(AttributeContainerSerializer attributeContainerSerializer) {
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.buildIdentifierSerializer = new BuildIdentifierSerializer();
    }

    public ComponentSelector read(Decoder decoder) throws IOException {
        byte id = decoder.readByte();
        if (Implementation.ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            String projectName = decoder.readString();
            return new DefaultProjectComponentSelector(buildIdentifier, Path.ROOT, Path.ROOT, projectName, this.readAttributes(decoder));
        }
        if (Implementation.ROOT_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path projectPath = Path.path((String)decoder.readString());
            return new DefaultProjectComponentSelector(buildIdentifier, projectPath, projectPath, projectPath.getName(), this.readAttributes(decoder));
        }
        if (Implementation.OTHER_BUILD_ROOT_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path((String)decoder.readString());
            return new DefaultProjectComponentSelector(buildIdentifier, identityPath, Path.ROOT, identityPath.getName(), this.readAttributes(decoder));
        }
        if (Implementation.OTHER_BUILD_PROJECT.getId() == id) {
            BuildIdentifier buildIdentifier = this.buildIdentifierSerializer.read(decoder);
            Path identityPath = Path.path((String)decoder.readString());
            Path projectPath = Path.path((String)decoder.readString());
            return new DefaultProjectComponentSelector(buildIdentifier, identityPath, projectPath, projectPath.getName(), this.readAttributes(decoder));
        }
        if (Implementation.MODULE.getId() == id) {
            return DefaultModuleComponentSelector.newSelector(DefaultModuleIdentifier.newId(decoder.readString(), decoder.readString()), this.readVersionConstraint(decoder), (AttributeContainer)this.readAttributes(decoder));
        }
        if (Implementation.LIBRARY.getId() == id) {
            return new DefaultLibraryComponentSelector(decoder.readString(), decoder.readNullableString(), decoder.readNullableString());
        }
        throw new IllegalArgumentException("Unable to find component selector with id: " + id);
    }

    private ImmutableAttributes readAttributes(Decoder decoder) throws IOException {
        return this.attributeContainerSerializer.read(decoder);
    }

    ImmutableVersionConstraint readVersionConstraint(Decoder decoder) throws IOException {
        String prefers = decoder.readString();
        int rejectCount = decoder.readSmallInt();
        ArrayList rejects = Lists.newArrayListWithCapacity((int)rejectCount);
        for (int i = 0; i < rejectCount; ++i) {
            rejects.add(decoder.readString());
        }
        return new DefaultImmutableVersionConstraint(prefers, rejects);
    }

    public void write(Encoder encoder, ComponentSelector value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Provided component selector may not be null");
        }
        Implementation implementation = this.resolveImplementation(value);
        encoder.writeByte(implementation.getId());
        if (implementation == Implementation.MODULE) {
            ModuleComponentSelector moduleComponentSelector = (ModuleComponentSelector)value;
            encoder.writeString((CharSequence)moduleComponentSelector.getGroup());
            encoder.writeString((CharSequence)moduleComponentSelector.getModule());
            VersionConstraint versionConstraint = moduleComponentSelector.getVersionConstraint();
            this.writeVersionConstraint(encoder, versionConstraint);
            this.writeAttributes(encoder, moduleComponentSelector.getAttributes());
        } else if (implementation == Implementation.ROOT_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectName());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
        } else if (implementation == Implementation.ROOT_BUILD_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectPath());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
        } else if (implementation == Implementation.OTHER_BUILD_ROOT_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getIdentityPath().getPath());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
        } else if (implementation == Implementation.OTHER_BUILD_PROJECT) {
            DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
            this.buildIdentifierSerializer.write(encoder, projectComponentSelector.getBuildIdentifier());
            encoder.writeString((CharSequence)projectComponentSelector.getIdentityPath().getPath());
            encoder.writeString((CharSequence)projectComponentSelector.getProjectPath());
            this.writeAttributes(encoder, projectComponentSelector.getAttributes());
        } else if (implementation == Implementation.LIBRARY) {
            LibraryComponentSelector libraryComponentSelector = (LibraryComponentSelector)value;
            encoder.writeString((CharSequence)libraryComponentSelector.getProjectPath());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getLibraryName());
            encoder.writeNullableString((CharSequence)libraryComponentSelector.getVariant());
        } else {
            throw new IllegalStateException("Unsupported implementation type: " + (Object)((Object)implementation));
        }
    }

    private void writeAttributes(Encoder encoder, AttributeContainer attributes) throws IOException {
        this.attributeContainerSerializer.write(encoder, attributes);
    }

    private void writeVersionConstraint(Encoder encoder, VersionConstraint versionConstraint) throws IOException {
        encoder.writeString((CharSequence)versionConstraint.getPreferredVersion());
        List rejectedVersions = versionConstraint.getRejectedVersions();
        encoder.writeSmallInt(rejectedVersions.size());
        for (String rejectedVersion : rejectedVersions) {
            encoder.writeString((CharSequence)rejectedVersion);
        }
    }

    private Implementation resolveImplementation(ComponentSelector value) {
        Implementation implementation;
        if (value instanceof DefaultModuleComponentSelector) {
            implementation = Implementation.MODULE;
        } else {
            if (value instanceof DefaultProjectComponentSelector) {
                DefaultProjectComponentSelector projectComponentSelector = (DefaultProjectComponentSelector)value;
                boolean isARootProject = projectComponentSelector.projectPath().equals((Object)Path.ROOT);
                if (projectComponentSelector.getIdentityPath().equals((Object)Path.ROOT) && isARootProject) {
                    return Implementation.ROOT_PROJECT;
                }
                if (projectComponentSelector.getIdentityPath().equals((Object)projectComponentSelector.projectPath()) && projectComponentSelector.projectPath().getName().equals(projectComponentSelector.getProjectName())) {
                    return Implementation.ROOT_BUILD_PROJECT;
                }
                if (isARootProject && projectComponentSelector.getProjectName().equals(projectComponentSelector.getIdentityPath().getName())) {
                    return Implementation.OTHER_BUILD_ROOT_PROJECT;
                }
                return Implementation.OTHER_BUILD_PROJECT;
            }
            if (value instanceof DefaultLibraryComponentSelector) {
                implementation = Implementation.LIBRARY;
            } else {
                throw new IllegalArgumentException("Unsupported component selector class: " + value.getClass());
            }
        }
        return implementation;
    }

    private static enum Implementation {
        MODULE(1),
        ROOT_PROJECT(2),
        ROOT_BUILD_PROJECT(3),
        OTHER_BUILD_ROOT_PROJECT(4),
        OTHER_BUILD_PROJECT(5),
        LIBRARY(6),
        SNAPSHOT(7);

        private final byte id;

        private Implementation(int id) {
            this.id = (byte)id;
        }

        byte getId() {
            return this.id;
        }
    }
}

