/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.ScriptSession;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.io.JavascriptObject;

public class DefaultJavascriptObject
implements JavascriptObject,
InvocationHandler {
    private ScriptSession session;
    private String id;

    public DefaultJavascriptObject(ScriptSession session, String id) {
        this.session = session;
        this.id = id;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals") && args.length == 1) {
            return this.equals(args[0]);
        }
        if (method.getName().equals("hashCode") && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if (method.getName().equals("toString") && (args == null || args.length == 0)) {
            return this.toString();
        }
        ScriptBuffer script = EnginePrivate.getRemoteExecuteObjectScript(this.id, method.getName(), args);
        this.session.addScript(script);
        return null;
    }

    @Override
    public void execute(String methodName, Object ... params) {
        ScriptBuffer script = EnginePrivate.getRemoteExecuteObjectScript(this.id, methodName, params);
        this.session.addScript(script);
    }

    @Override
    public void set(String propertyName, Object data) {
        ScriptBuffer script = EnginePrivate.getRemoteSetObjectScript(this.id, propertyName, data);
        this.session.addScript(script);
    }

    @Override
    public void close() {
        ScriptBuffer script = EnginePrivate.getRemoteCloseFunctionScript(this.id);
        this.session.addScript(script);
    }

    public String toString() {
        return "browser[" + this.session.getId() + "].object[" + this.id + "](...)";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultJavascriptObject that = (DefaultJavascriptObject)obj;
        if (!this.session.equals(that.session)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int hash = 345;
        hash += this.id == null ? 768 : this.id.hashCode();
        return hash += this.session == null ? 546 : this.session.hashCode();
    }
}

