/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.List;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.Operation;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.lookup.PainlessCast;
import org.elasticsearch.painless.lookup.def;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public final class MethodWriter
extends GeneratorAdapter {
    private final BitSet statements;
    private final CompilerSettings settings;
    private final Deque<List<Type>> stringConcatArgs = WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE == null ? null : new ArrayDeque();

    public MethodWriter(int access, Method method, ClassVisitor cw, BitSet statements, CompilerSettings settings) {
        super(327680, cw.visitMethod(access, method.getName(), method.getDescriptor(), null, null), access, method.getName(), method.getDescriptor());
        this.statements = statements;
        this.settings = settings;
    }

    public void writeStatementOffset(Location location) {
        int offset = location.getOffset();
        assert (!this.statements.get(offset));
        this.statements.set(offset);
    }

    public void writeDebugInfo(Location location) {
        Label label = new Label();
        this.visitLabel(label);
        this.visitLineNumber(location.getOffset() + 1, label);
    }

    public void writeLoopCounter(int slot, int count, Location location) {
        assert (slot != -1);
        this.writeDebugInfo(location);
        Label end = new Label();
        this.iinc(slot, -count);
        this.visitVarInsn(21, slot);
        this.push(0);
        this.ifICmp(157, end);
        this.throwException(WriterConstants.PAINLESS_ERROR_TYPE, "The maximum number of statements that can be executed in a loop has been reached.");
        this.mark(end);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCast(PainlessCast cast) {
        if (cast == null) return;
        if (cast.from == Character.TYPE && cast.to == String.class) {
            this.invokeStatic(WriterConstants.UTILITY_TYPE, WriterConstants.CHAR_TO_STRING);
            return;
        } else if (cast.from == String.class && cast.to == Character.TYPE) {
            this.invokeStatic(WriterConstants.UTILITY_TYPE, WriterConstants.STRING_TO_CHAR);
            return;
        } else if (cast.unboxFrom != null) {
            this.unbox(MethodWriter.getType(cast.unboxFrom));
            this.writeCast(cast.from, cast.to);
            return;
        } else if (cast.unboxTo != null) {
            if (cast.from == def.class) {
                if (cast.explicit) {
                    if (cast.to == Boolean.class) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BOOLEAN);
                        return;
                    } else if (cast.to == Byte.class) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BYTE_EXPLICIT);
                        return;
                    } else if (cast.to == Short.class) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_SHORT_EXPLICIT);
                        return;
                    } else if (cast.to == Character.class) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_CHAR_EXPLICIT);
                        return;
                    } else if (cast.to == Integer.class) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_INT_EXPLICIT);
                        return;
                    } else if (cast.to == Long.class) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_LONG_EXPLICIT);
                        return;
                    } else if (cast.to == Float.class) {
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_FLOAT_EXPLICIT);
                        return;
                    } else {
                        if (cast.to != Double.class) throw new IllegalStateException("Illegal tree structure.");
                        this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_DOUBLE_EXPLICIT);
                    }
                    return;
                } else if (cast.to == Boolean.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BOOLEAN);
                    return;
                } else if (cast.to == Byte.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_BYTE_IMPLICIT);
                    return;
                } else if (cast.to == Short.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_SHORT_IMPLICIT);
                    return;
                } else if (cast.to == Character.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_CHAR_IMPLICIT);
                    return;
                } else if (cast.to == Integer.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_INT_IMPLICIT);
                    return;
                } else if (cast.to == Long.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_LONG_IMPLICIT);
                    return;
                } else if (cast.to == Float.class) {
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_FLOAT_IMPLICIT);
                    return;
                } else {
                    if (cast.to != Double.class) throw new IllegalStateException("Illegal tree structure.");
                    this.invokeStatic(WriterConstants.DEF_UTIL_TYPE, WriterConstants.DEF_TO_DOUBLE_IMPLICIT);
                }
                return;
            } else {
                this.writeCast(cast.from, cast.to);
                this.unbox(MethodWriter.getType(cast.unboxTo));
            }
            return;
        } else if (cast.boxFrom != null) {
            this.box(MethodWriter.getType(cast.boxFrom));
            this.writeCast(cast.from, cast.to);
            return;
        } else if (cast.boxTo != null) {
            this.writeCast(cast.from, cast.to);
            this.box(MethodWriter.getType(cast.boxTo));
            return;
        } else {
            this.writeCast(cast.from, cast.to);
        }
    }

    private void writeCast(Class<?> from, Class<?> to) {
        if (from.equals(to)) {
            return;
        }
        if (from != Boolean.TYPE && from.isPrimitive() && to != Boolean.TYPE && to.isPrimitive()) {
            this.cast(MethodWriter.getType(from), MethodWriter.getType(to));
        } else if (!to.isAssignableFrom(from)) {
            this.checkCast(MethodWriter.getType(to));
        }
    }

    public void box(Type type) {
        this.valueOf(type);
    }

    public static Type getType(Class<?> clazz) {
        if (clazz.isArray()) {
            Class<?> component = clazz.getComponentType();
            int dimensions = 1;
            while (component.isArray()) {
                component = component.getComponentType();
                ++dimensions;
            }
            if (component == def.class) {
                char[] braces = new char[dimensions];
                Arrays.fill(braces, '[');
                return Type.getType((String)(new String(braces) + Type.getType(Object.class).getDescriptor()));
            }
        } else if (clazz == def.class) {
            return Type.getType(Object.class);
        }
        return Type.getType(clazz);
    }

    public int writeNewStrings() {
        if (WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE != null) {
            this.stringConcatArgs.push(new ArrayList());
            return 0;
        }
        this.newInstance(WriterConstants.STRINGBUILDER_TYPE);
        this.dup();
        this.invokeConstructor(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_CONSTRUCTOR);
        return 1;
    }

    public void writeAppendStrings(Class<?> clazz) {
        if (WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE != null) {
            this.stringConcatArgs.peek().add(MethodWriter.getType(clazz));
            if (this.stringConcatArgs.peek().size() >= 200) {
                this.writeToStrings();
                this.writeNewStrings();
                this.stringConcatArgs.peek().add(WriterConstants.STRING_TYPE);
            }
        } else if (clazz == Boolean.TYPE) {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_BOOLEAN);
        } else if (clazz == Character.TYPE) {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_CHAR);
        } else if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE) {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_INT);
        } else if (clazz == Long.TYPE) {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_LONG);
        } else if (clazz == Float.TYPE) {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_FLOAT);
        } else if (clazz == Double.TYPE) {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_DOUBLE);
        } else if (clazz == String.class) {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_STRING);
        } else {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_APPEND_OBJECT);
        }
    }

    public void writeToStrings() {
        if (WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE != null) {
            String desc = Type.getMethodDescriptor((Type)WriterConstants.STRING_TYPE, (Type[])((Type[])this.stringConcatArgs.pop().stream().toArray(Type[]::new)));
            this.invokeDynamic("concat", desc, WriterConstants.INDY_STRING_CONCAT_BOOTSTRAP_HANDLE, new Object[0]);
        } else {
            this.invokeVirtual(WriterConstants.STRINGBUILDER_TYPE, WriterConstants.STRINGBUILDER_TOSTRING);
        }
    }

    public void writeDynamicBinaryInstruction(Location location, Class<?> returnType, Class<?> lhs, Class<?> rhs, Operation operation, int flags) {
        Type methodType = Type.getMethodType((Type)MethodWriter.getType(returnType), (Type[])new Type[]{MethodWriter.getType(lhs), MethodWriter.getType(rhs)});
        switch (operation) {
            case MUL: {
                this.invokeDefCall("mul", methodType, 8, flags);
                break;
            }
            case DIV: {
                this.invokeDefCall("div", methodType, 8, flags);
                break;
            }
            case REM: {
                this.invokeDefCall("rem", methodType, 8, flags);
                break;
            }
            case ADD: {
                boolean hasPrimitiveArg;
                boolean bl = hasPrimitiveArg = lhs.isPrimitive() || rhs.isPrimitive();
                if (!hasPrimitiveArg) {
                    flags |= 1;
                }
                this.invokeDefCall("add", methodType, 8, flags);
                break;
            }
            case SUB: {
                this.invokeDefCall("sub", methodType, 8, flags);
                break;
            }
            case LSH: {
                this.invokeDefCall("lsh", methodType, 9, flags);
                break;
            }
            case USH: {
                this.invokeDefCall("ush", methodType, 9, flags);
                break;
            }
            case RSH: {
                this.invokeDefCall("rsh", methodType, 9, flags);
                break;
            }
            case BWAND: {
                this.invokeDefCall("and", methodType, 8, flags);
                break;
            }
            case XOR: {
                this.invokeDefCall("xor", methodType, 8, flags);
                break;
            }
            case BWOR: {
                this.invokeDefCall("or", methodType, 8, flags);
                break;
            }
            default: {
                throw location.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    public void writeBinaryInstruction(Location location, Class<?> clazz, Operation operation) {
        if (!(clazz != Float.TYPE && clazz != Double.TYPE || operation != Operation.LSH && operation != Operation.USH && operation != Operation.RSH && operation != Operation.BWAND && operation != Operation.XOR && operation != Operation.BWOR)) {
            throw location.createError(new IllegalStateException("Illegal tree structure."));
        }
        switch (operation) {
            case MUL: {
                this.math(104, MethodWriter.getType(clazz));
                break;
            }
            case DIV: {
                this.math(108, MethodWriter.getType(clazz));
                break;
            }
            case REM: {
                this.math(112, MethodWriter.getType(clazz));
                break;
            }
            case ADD: {
                this.math(96, MethodWriter.getType(clazz));
                break;
            }
            case SUB: {
                this.math(100, MethodWriter.getType(clazz));
                break;
            }
            case LSH: {
                this.math(120, MethodWriter.getType(clazz));
                break;
            }
            case USH: {
                this.math(124, MethodWriter.getType(clazz));
                break;
            }
            case RSH: {
                this.math(122, MethodWriter.getType(clazz));
                break;
            }
            case BWAND: {
                this.math(126, MethodWriter.getType(clazz));
                break;
            }
            case XOR: {
                this.math(130, MethodWriter.getType(clazz));
                break;
            }
            case BWOR: {
                this.math(128, MethodWriter.getType(clazz));
                break;
            }
            default: {
                throw location.createError(new IllegalStateException("Illegal tree structure."));
            }
        }
    }

    public void writeDup(int size, int xsize) {
        if (size == 1) {
            if (xsize == 2) {
                this.dupX2();
            } else if (xsize == 1) {
                this.dupX1();
            } else {
                this.dup();
            }
        } else if (size == 2) {
            if (xsize == 2) {
                this.dup2X2();
            } else if (xsize == 1) {
                this.dup2X1();
            } else {
                this.dup2();
            }
        }
    }

    public void writePop(int size) {
        if (size == 1) {
            this.pop();
        } else if (size == 2) {
            this.pop2();
        }
    }

    public void endMethod() {
        if (this.stringConcatArgs != null && !this.stringConcatArgs.isEmpty()) {
            throw new IllegalStateException("String concat bytecode not completed.");
        }
        super.endMethod();
    }

    public void visitEnd() {
        throw new AssertionError((Object)"Should never call this method on MethodWriter, use endMethod() instead");
    }

    public void invokeDefCall(String name, Type methodType, int flavor, Object ... params) {
        Object[] args = new Object[params.length + 2];
        args[0] = this.settings.getInitialCallSiteDepth();
        args[1] = flavor;
        System.arraycopy(params, 0, args, 2, params.length);
        this.invokeDynamic(name, methodType.getDescriptor(), WriterConstants.DEF_BOOTSTRAP_HANDLE, args);
    }
}

