/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class ScriptedMetricAggContexts {

    public static abstract class ReduceScript {
        private final Map<String, Object> params;
        private final List<Object> states;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_reduce", Factory.class);

        public ReduceScript(Map<String, Object> params, List<Object> states) {
            this.params = params;
            this.states = states;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public List<Object> getStates() {
            return this.states;
        }

        public abstract Object execute();

        public static interface Factory {
            public ReduceScript newInstance(Map<String, Object> var1, List<Object> var2);
        }
    }

    public static abstract class CombineScript
    extends ParamsAndStateBase {
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_combine", Factory.class);

        public CombineScript(Map<String, Object> params, Object state) {
            super(params, state);
        }

        public abstract Object execute();

        public static interface Factory {
            public CombineScript newInstance(Map<String, Object> var1, Object var2);
        }
    }

    public static abstract class MapScript
    extends ParamsAndStateBase {
        private final LeafSearchLookup leafLookup;
        private Scorer scorer;
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_map", Factory.class);

        public MapScript(Map<String, Object> params, Object state, SearchLookup lookup, LeafReaderContext leafContext) {
            super(params, state);
            this.leafLookup = leafContext == null ? null : lookup.getLeafSearchLookup(leafContext);
        }

        public Map<String, ScriptDocValues<?>> getDoc() {
            return this.leafLookup == null ? null : this.leafLookup.doc();
        }

        public void setDocument(int docId) {
            if (this.leafLookup != null) {
                this.leafLookup.setDocument(docId);
            }
        }

        public void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        public double get_score() {
            if (this.scorer == null) {
                return 0.0;
            }
            try {
                return this.scorer.score();
            }
            catch (IOException e) {
                throw new ElasticsearchException("Couldn't look up score", (Throwable)e, new Object[0]);
            }
        }

        public abstract void execute();

        public static interface Factory {
            public LeafFactory newFactory(Map<String, Object> var1, Object var2, SearchLookup var3);
        }

        public static interface LeafFactory {
            public MapScript newInstance(LeafReaderContext var1);
        }
    }

    public static abstract class InitScript
    extends ParamsAndStateBase {
        public static String[] PARAMETERS = new String[0];
        public static ScriptContext<Factory> CONTEXT = new ScriptContext<Factory>("aggs_init", Factory.class);

        public InitScript(Map<String, Object> params, Object state) {
            super(params, state);
        }

        public abstract void execute();

        public static interface Factory {
            public InitScript newInstance(Map<String, Object> var1, Object var2);
        }
    }

    private static abstract class ParamsAndStateBase {
        private final Map<String, Object> params;
        private final Object state;

        ParamsAndStateBase(Map<String, Object> params, Object state) {
            this.params = params;
            this.state = state;
        }

        public Map<String, Object> getParams() {
            return this.params;
        }

        public Object getState() {
            return this.state;
        }
    }
}

