// Generated by gmmproc 2.51.6 -- DO NOT MODIFY!
#ifndef _PANGOMM_LANGUAGE_H
#define _PANGOMM_LANGUAGE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/value.h>
#include <glibmm/arrayhandle.h>
#include <pango/pango-attributes.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _PangoLanguage PangoLanguage; }
#endif

namespace Pango
{

/** @addtogroup pangommEnums pangomm Enums and Flags */

/** 
 *  @var Script SCRIPT_INVALID_CODE
 * A value never returned from pango_script_for_unichar().
 * 
 *  @var Script SCRIPT_COMMON
 * A character used by multiple different scripts.
 * 
 *  @var Script SCRIPT_INHERITED
 * A mark glyph that takes its script from the
 * base glyph to which it is attached.
 * 
 *  @var Script SCRIPT_ARABIC
 * Arabic.
 * 
 *  @var Script SCRIPT_ARMENIAN
 * Armenian.
 * 
 *  @var Script SCRIPT_BENGALI
 * Bengali.
 * 
 *  @var Script SCRIPT_BOPOMOFO
 * Bopomofo.
 * 
 *  @var Script SCRIPT_CHEROKEE
 * Cherokee.
 * 
 *  @var Script SCRIPT_COPTIC
 * Coptic.
 * 
 *  @var Script SCRIPT_CYRILLIC
 * Cyrillic.
 * 
 *  @var Script SCRIPT_DESERET
 * Deseret.
 * 
 *  @var Script SCRIPT_DEVANAGARI
 * Devanagari.
 * 
 *  @var Script SCRIPT_ETHIOPIC
 * Ethiopic.
 * 
 *  @var Script SCRIPT_GEORGIAN
 * Georgian.
 * 
 *  @var Script SCRIPT_GOTHIC
 * Gothic.
 * 
 *  @var Script SCRIPT_GREEK
 * Greek.
 * 
 *  @var Script SCRIPT_GUJARATI
 * Gujarati.
 * 
 *  @var Script SCRIPT_GURMUKHI
 * Gurmukhi.
 * 
 *  @var Script SCRIPT_HAN
 * Han.
 * 
 *  @var Script SCRIPT_HANGUL
 * Hangul.
 * 
 *  @var Script SCRIPT_HEBREW
 * Hebrew.
 * 
 *  @var Script SCRIPT_HIRAGANA
 * Hiragana.
 * 
 *  @var Script SCRIPT_KANNADA
 * Kannada.
 * 
 *  @var Script SCRIPT_KATAKANA
 * Katakana.
 * 
 *  @var Script SCRIPT_KHMER
 * Khmer.
 * 
 *  @var Script SCRIPT_LAO
 * Lao.
 * 
 *  @var Script SCRIPT_LATIN
 * Latin.
 * 
 *  @var Script SCRIPT_MALAYALAM
 * Malayalam.
 * 
 *  @var Script SCRIPT_MONGOLIAN
 * Mongolian.
 * 
 *  @var Script SCRIPT_MYANMAR
 * Myanmar.
 * 
 *  @var Script SCRIPT_OGHAM
 * Ogham.
 * 
 *  @var Script SCRIPT_OLD_ITALIC
 * Old Italic.
 * 
 *  @var Script SCRIPT_ORIYA
 * Oriya.
 * 
 *  @var Script SCRIPT_RUNIC
 * Runic.
 * 
 *  @var Script SCRIPT_SINHALA
 * Sinhala.
 * 
 *  @var Script SCRIPT_SYRIAC
 * Syriac.
 * 
 *  @var Script SCRIPT_TAMIL
 * Tamil.
 * 
 *  @var Script SCRIPT_TELUGU
 * Telugu.
 * 
 *  @var Script SCRIPT_THAANA
 * Thaana.
 * 
 *  @var Script SCRIPT_THAI
 * Thai.
 * 
 *  @var Script SCRIPT_TIBETAN
 * Tibetan.
 * 
 *  @var Script SCRIPT_CANADIAN_ABORIGINAL
 * Canadian Aboriginal.
 * 
 *  @var Script SCRIPT_YI
 * Yi.
 * 
 *  @var Script SCRIPT_TAGALOG
 * Tagalog.
 * 
 *  @var Script SCRIPT_HANUNOO
 * Hanunoo.
 * 
 *  @var Script SCRIPT_BUHID
 * Buhid.
 * 
 *  @var Script SCRIPT_TAGBANWA
 * Tagbanwa.
 * 
 *  @var Script SCRIPT_BRAILLE
 * Braille.
 * 
 *  @var Script SCRIPT_CYPRIOT
 * Cypriot.
 * 
 *  @var Script SCRIPT_LIMBU
 * Limbu.
 * 
 *  @var Script SCRIPT_OSMANYA
 * Osmanya.
 * 
 *  @var Script SCRIPT_SHAVIAN
 * Shavian.
 * 
 *  @var Script SCRIPT_LINEAR_B
 * Linear B.
 * 
 *  @var Script SCRIPT_TAI_LE
 * Tai Le.
 * 
 *  @var Script SCRIPT_UGARITIC
 * Ugaritic.
 * 
 *  @var Script SCRIPT_NEW_TAI_LUE
 * New Tai Lue. @newin{1,10}
 * 
 *  @var Script SCRIPT_BUGINESE
 * Buginese. @newin{1,10}
 * 
 *  @var Script SCRIPT_GLAGOLITIC
 * Glagolitic. @newin{1,10}
 * 
 *  @var Script SCRIPT_TIFINAGH
 * Tifinagh. @newin{1,10}
 * 
 *  @var Script SCRIPT_SYLOTI_NAGRI
 * Syloti Nagri. @newin{1,10}
 * 
 *  @var Script SCRIPT_OLD_PERSIAN
 * Old Persian. @newin{1,10}
 * 
 *  @var Script SCRIPT_KHAROSHTHI
 * Kharoshthi. @newin{1,10}
 * 
 *  @var Script SCRIPT_UNKNOWN
 * An unassigned code point. @newin{1,14}
 * 
 *  @var Script SCRIPT_BALINESE
 * Balinese. @newin{1,14}
 * 
 *  @var Script SCRIPT_CUNEIFORM
 * Cuneiform. @newin{1,14}
 * 
 *  @var Script SCRIPT_PHOENICIAN
 * Phoenician. @newin{1,14}
 * 
 *  @var Script SCRIPT_PHAGS_PA
 * Phags-pa. @newin{1,14}
 * 
 *  @var Script SCRIPT_NKO
 * N'Ko. @newin{1,14}
 * 
 *  @var Script SCRIPT_KAYAH_LI
 * Kayah Li. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_LEPCHA
 * Lepcha. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_REJANG
 * Rejang. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_SUNDANESE
 * Sundanese. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_SAURASHTRA
 * Saurashtra. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_CHAM
 * Cham. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_OL_CHIKI
 * Ol Chiki. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_VAI
 * Vai. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_CARIAN
 * Carian. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_LYCIAN
 * Lycian. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_LYDIAN
 * Lydian. @newin{1,20,1}
 * 
 *  @var Script SCRIPT_BATAK
 * Batak. @newin{1,32}
 * 
 *  @var Script SCRIPT_BRAHMI
 * Brahmi. @newin{1,32}
 * 
 *  @var Script SCRIPT_MANDAIC
 * Mandaic. @newin{1,32}
 * 
 *  @var Script SCRIPT_CHAKMA
 * Chakma. @newin{1,32}
 * 
 *  @var Script SCRIPT_MEROITIC_CURSIVE
 * Meroitic Cursive. @newin{1,32}
 * 
 *  @var Script SCRIPT_MEROITIC_HIEROGLYPHS
 * Meroitic Hieroglyphs. @newin{1,32}
 * 
 *  @var Script SCRIPT_MIAO
 * Miao. @newin{1,32}
 * 
 *  @var Script SCRIPT_SHARADA
 * Sharada. @newin{1,32}
 * 
 *  @var Script SCRIPT_SORA_SOMPENG
 * Sora Sompeng. @newin{1,32}
 * 
 *  @var Script SCRIPT_TAKRI
 * Takri. @newin{1,32}
 * 
 *  @var Script SCRIPT_BASSA_VAH
 * Bassa. @newin{1,40}
 * 
 *  @var Script SCRIPT_CAUCASIAN_ALBANIAN
 * Caucasian Albanian. @newin{1,40}
 * 
 *  @var Script SCRIPT_DUPLOYAN
 * Duployan. @newin{1,40}
 * 
 *  @var Script SCRIPT_ELBASAN
 * Elbasan. @newin{1,40}
 * 
 *  @var Script SCRIPT_GRANTHA
 * Grantha. @newin{1,40}
 * 
 *  @var Script SCRIPT_KHOJKI
 * Kjohki. @newin{1,40}
 * 
 *  @var Script SCRIPT_KHUDAWADI
 * Khudawadi, Sindhi. @newin{1,40}
 * 
 *  @var Script SCRIPT_LINEAR_A
 * Linear A. @newin{1,40}
 * 
 *  @var Script SCRIPT_MAHAJANI
 * Mahajani. @newin{1,40}
 * 
 *  @var Script SCRIPT_MANICHAEAN
 * Manichaean. @newin{1,40}
 * 
 *  @var Script SCRIPT_MENDE_KIKAKUI
 * Mende Kikakui. @newin{1,40}
 * 
 *  @var Script SCRIPT_MODI
 * Modi. @newin{1,40}
 * 
 *  @var Script SCRIPT_MRO
 * Mro. @newin{1,40}
 * 
 *  @var Script SCRIPT_NABATAEAN
 * Nabataean. @newin{1,40}
 * 
 *  @var Script SCRIPT_OLD_NORTH_ARABIAN
 * Old North Arabian. @newin{1,40}
 * 
 *  @var Script SCRIPT_OLD_PERMIC
 * Old Permic. @newin{1,40}
 * 
 *  @var Script SCRIPT_PAHAWH_HMONG
 * Pahawh Hmong. @newin{1,40}
 * 
 *  @var Script SCRIPT_PALMYRENE
 * Palmyrene. @newin{1,40}
 * 
 *  @var Script SCRIPT_PAU_CIN_HAU
 * Pau Cin Hau. @newin{1,40}
 * 
 *  @var Script SCRIPT_PSALTER_PAHLAVI
 * Psalter Pahlavi. @newin{1,40}
 * 
 *  @var Script SCRIPT_SIDDHAM
 * Siddham. @newin{1,40}
 * 
 *  @var Script SCRIPT_TIRHUTA
 * Tirhuta. @newin{1,40}
 * 
 *  @var Script SCRIPT_WARANG_CITI
 * Warang Citi. @newin{1,40}
 * 
 *  @var Script SCRIPT_AHOM
 * Ahom. @newin{1,40}
 * 
 *  @var Script SCRIPT_ANATOLIAN_HIEROGLYPHS
 * Anatolian Hieroglyphs. @newin{1,40}
 * 
 *  @var Script SCRIPT_HATRAN
 * Hatran. @newin{1,40}
 * 
 *  @var Script SCRIPT_MULTANI
 * Multani. @newin{1,40}
 * 
 *  @var Script SCRIPT_OLD_HUNGARIAN
 * Old Hungarian. @newin{1,40}
 * 
 *  @var Script SCRIPT_SIGNWRITING
 * Signwriting. @newin{1,40}
 * 
 *  @enum Script
 * 
 * The Pango::Script enumeration identifies different writing
 * systems. The values correspond to the names as defined in the
 * Unicode standard.
 * Note that new types may be added in the future. Applications should be ready
 * to handle unknown values.  This enumeration is interchangeable with
 * UnicodeScript.  See Unicode Standard Annex
 * #24: Script names.
 *
 * @ingroup pangommEnums
 */
enum Script
{
  SCRIPT_INVALID_CODE = -1,
  SCRIPT_COMMON,
  SCRIPT_INHERITED,
  SCRIPT_ARABIC,
  SCRIPT_ARMENIAN,
  SCRIPT_BENGALI,
  SCRIPT_BOPOMOFO,
  SCRIPT_CHEROKEE,
  SCRIPT_COPTIC,
  SCRIPT_CYRILLIC,
  SCRIPT_DESERET,
  SCRIPT_DEVANAGARI,
  SCRIPT_ETHIOPIC,
  SCRIPT_GEORGIAN,
  SCRIPT_GOTHIC,
  SCRIPT_GREEK,
  SCRIPT_GUJARATI,
  SCRIPT_GURMUKHI,
  SCRIPT_HAN,
  SCRIPT_HANGUL,
  SCRIPT_HEBREW,
  SCRIPT_HIRAGANA,
  SCRIPT_KANNADA,
  SCRIPT_KATAKANA,
  SCRIPT_KHMER,
  SCRIPT_LAO,
  SCRIPT_LATIN,
  SCRIPT_MALAYALAM,
  SCRIPT_MONGOLIAN,
  SCRIPT_MYANMAR,
  SCRIPT_OGHAM,
  SCRIPT_OLD_ITALIC,
  SCRIPT_ORIYA,
  SCRIPT_RUNIC,
  SCRIPT_SINHALA,
  SCRIPT_SYRIAC,
  SCRIPT_TAMIL,
  SCRIPT_TELUGU,
  SCRIPT_THAANA,
  SCRIPT_THAI,
  SCRIPT_TIBETAN,
  SCRIPT_CANADIAN_ABORIGINAL,
  SCRIPT_YI,
  SCRIPT_TAGALOG,
  SCRIPT_HANUNOO,
  SCRIPT_BUHID,
  SCRIPT_TAGBANWA,
  SCRIPT_BRAILLE,
  SCRIPT_CYPRIOT,
  SCRIPT_LIMBU,
  SCRIPT_OSMANYA,
  SCRIPT_SHAVIAN,
  SCRIPT_LINEAR_B,
  SCRIPT_TAI_LE,
  SCRIPT_UGARITIC,
  SCRIPT_NEW_TAI_LUE,
  SCRIPT_BUGINESE,
  SCRIPT_GLAGOLITIC,
  SCRIPT_TIFINAGH,
  SCRIPT_SYLOTI_NAGRI,
  SCRIPT_OLD_PERSIAN,
  SCRIPT_KHAROSHTHI,
  SCRIPT_UNKNOWN,
  SCRIPT_BALINESE,
  SCRIPT_CUNEIFORM,
  SCRIPT_PHOENICIAN,
  SCRIPT_PHAGS_PA,
  SCRIPT_NKO,
  SCRIPT_KAYAH_LI,
  SCRIPT_LEPCHA,
  SCRIPT_REJANG,
  SCRIPT_SUNDANESE,
  SCRIPT_SAURASHTRA,
  SCRIPT_CHAM,
  SCRIPT_OL_CHIKI,
  SCRIPT_VAI,
  SCRIPT_CARIAN,
  SCRIPT_LYCIAN,
  SCRIPT_LYDIAN,
  SCRIPT_BATAK,
  SCRIPT_BRAHMI,
  SCRIPT_MANDAIC,
  SCRIPT_CHAKMA,
  SCRIPT_MEROITIC_CURSIVE,
  SCRIPT_MEROITIC_HIEROGLYPHS,
  SCRIPT_MIAO,
  SCRIPT_SHARADA,
  SCRIPT_SORA_SOMPENG,
  SCRIPT_TAKRI,
  SCRIPT_BASSA_VAH,
  SCRIPT_CAUCASIAN_ALBANIAN,
  SCRIPT_DUPLOYAN,
  SCRIPT_ELBASAN,
  SCRIPT_GRANTHA,
  SCRIPT_KHOJKI,
  SCRIPT_KHUDAWADI,
  SCRIPT_LINEAR_A,
  SCRIPT_MAHAJANI,
  SCRIPT_MANICHAEAN,
  SCRIPT_MENDE_KIKAKUI,
  SCRIPT_MODI,
  SCRIPT_MRO,
  SCRIPT_NABATAEAN,
  SCRIPT_OLD_NORTH_ARABIAN,
  SCRIPT_OLD_PERMIC,
  SCRIPT_PAHAWH_HMONG,
  SCRIPT_PALMYRENE,
  SCRIPT_PAU_CIN_HAU,
  SCRIPT_PSALTER_PAHLAVI,
  SCRIPT_SIDDHAM,
  SCRIPT_TIRHUTA,
  SCRIPT_WARANG_CITI,
  SCRIPT_AHOM,
  SCRIPT_ANATOLIAN_HIEROGLYPHS,
  SCRIPT_HATRAN,
  SCRIPT_MULTANI,
  SCRIPT_OLD_HUNGARIAN,
  SCRIPT_SIGNWRITING
};

} // namespace Pango

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Pango::Script> : public Glib::Value_Enum<Pango::Script>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Pango
{


/** A Pango::Language is used to represent a language.
 */
class Language
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Language;
  using BaseObjectType = PangoLanguage;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type() G_GNUC_CONST;


  explicit Language(PangoLanguage* gobject, bool make_a_copy = true);

  Language(const Language& other);
  Language& operator=(const Language& other);

  Language(Language&& other) noexcept;
  Language& operator=(Language&& other) noexcept;

  ~Language() noexcept;

  void swap(Language& other) noexcept;

  ///Provides access to the underlying C instance.
  PangoLanguage*       gobj()       { return gobject_; }

  ///Provides access to the underlying C instance.
  const PangoLanguage* gobj() const { return gobject_; }

  ///Provides access to the underlying C instance. The caller is responsible for freeing it. Use when directly setting fields in structs.
  PangoLanguage* gobj_copy() const;

protected:
  PangoLanguage* gobject_;

private:

   //This function is a bad hack for internal use by renderers and Pango (from pango/pango-utils.c)
   //This is defined as a macro
  

public:
  /** Constructs an empty language tag.
   */
  Language();

  /** Constructs a Pango::Language object from a RFC-3066 format language tag.
   * This function first canonicalizes the string by converting it to lowercase,
   * mapping '_' to '-', and stripping all characters other than letters and '-'.
   */
  Language(const Glib::ustring& language);

  /** Gets a RFC-3066 format string representing the given language tag.
   * @return A string representing the language tag. An empty string is returned if the language tag is empty.
   */
  Glib::ustring get_string() const;

  
  /** Checks if a language tag matches one of the elements in a list of
   * language ranges. A language tag is considered to match a range
   * in the list if the range is '*', the range is exactly the tag,
   * or the range is a prefix of the tag, and the character after it
   * in the tag is '-'.
   * 
   * @param range_list A list of language ranges, separated by ';', ':',
   * ',', or space characters.
   * Each element must either be '*', or a RFC 3066 language range
   * canonicalized as by from_string().
   * @return <tt>true</tt> if a match was found.
   */
  bool matches(const Glib::ustring & range_list) const;
  
  /** Determines if @a script is one of the scripts used to
   * write @a language. The returned value is conservative;
   * if nothing is known about the language tag @a language,
   * <tt>true</tt> will be returned, since, as far as Pango knows,
   *  @a script might be used to write @a language.
   * 
   * This routine is used in Pango's itemization process when
   * determining if a supplied language tag is relevant to
   * a particular section of text. It probably is not useful for
   * applications in most circumstances.
   * 
   * This function uses get_scripts() internally.
   * 
   * @newin{1,4}
   * 
   * @param script A Pango::Script.
   * @return <tt>true</tt> if @a script is one of the scripts used
   * to write @a language or if nothing is known about @a language
   * (including the case that @a language is <tt>nullptr</tt>),
   * <tt>false</tt> otherwise.
   */
  bool includes_script(Script script) const;


 /** Determines the scripts used to to write this language.
   * If nothing is known about the language tag then an empty container is returned.
   * The list of scripts returned starts with the script that the
   * language uses most and continues to the one it uses least.
   *
   * Most languages use only one script for writing, but there are
   * some that use two (Latin and Cyrillic for example), and a few
   * use three (Japanese for example).  Applications should not make
   * any assumptions on the maximum number of scripts returned
   * though, except that it is a small number.
   *
   * @result A container of Script values.
   *
   * @newin{2,14}
   */
  Glib::ArrayHandle<Script> get_scripts() const;
  

};

} /* namespace Pango */


namespace Pango
{

/** @relates Pango::Language
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 */
inline void swap(Language& lhs, Language& rhs) noexcept
  { lhs.swap(rhs); }

} // namespace Pango

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Pango::Language
 */
Pango::Language wrap(PangoLanguage* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Pango::Language> : public Glib::Value_Boxed<Pango::Language>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _PANGOMM_LANGUAGE_H */

