/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.PendingSource;
import org.gradle.api.internal.provider.ProviderInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPendingSource<T>
implements PendingSource<T> {
    private final List<ProviderInternal<? extends T>> pending = Lists.newArrayList();
    private Action<ProviderInternal<? extends T>> flushAction;

    @Override
    public void realizePending() {
        if (!this.pending.isEmpty()) {
            ArrayList copied = Lists.newArrayList(this.pending);
            this.realize(copied);
        }
    }

    @Override
    public void realizePending(Class<?> type) {
        if (!this.pending.isEmpty()) {
            ArrayList copied = Lists.newArrayList();
            for (ProviderInternal<T> provider : this.pending) {
                if (provider.getType() != null && !type.isAssignableFrom(provider.getType())) continue;
                copied.add(provider);
            }
            this.realize(copied);
        }
    }

    private void realize(Iterable<ProviderInternal<? extends T>> elements) {
        for (ProviderInternal<T> providerInternal : elements) {
            if (this.flushAction != null) {
                this.pending.remove(providerInternal);
                this.flushAction.execute(providerInternal);
                continue;
            }
            throw new IllegalStateException("Cannot realize pending elements when realize action is not set");
        }
    }

    @Override
    public void addPending(ProviderInternal<? extends T> provider) {
        this.pending.add(provider);
    }

    @Override
    public void removePending(ProviderInternal<? extends T> provider) {
        this.pending.remove(provider);
    }

    @Override
    public void onRealize(Action<ProviderInternal<? extends T>> action) {
        this.flushAction = action;
    }

    @Override
    public boolean isEmpty() {
        return this.pending.isEmpty();
    }

    @Override
    public int size() {
        return this.pending.size();
    }

    @Override
    public void clear() {
        this.pending.clear();
    }
}

