/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.util.Arrays;
import org.gradle.api.Transformer;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.ResultHandler;
import org.gradle.tooling.internal.consumer.AbstractLongRunningOperation;
import org.gradle.tooling.internal.consumer.BlockingResultHandler;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.ExceptionTransformer;
import org.gradle.tooling.internal.consumer.PhasedBuildAction;
import org.gradle.tooling.internal.consumer.ResultHandlerAdapter;
import org.gradle.tooling.internal.consumer.async.AsyncConsumerActionExecutor;
import org.gradle.tooling.internal.consumer.connection.ConsumerAction;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPhasedBuildActionExecuter
extends AbstractLongRunningOperation<DefaultPhasedBuildActionExecuter>
implements BuildActionExecuter<Void> {
    private final PhasedBuildAction phasedBuildAction;
    private final AsyncConsumerActionExecutor connection;

    DefaultPhasedBuildActionExecuter(PhasedBuildAction phasedBuildAction, AsyncConsumerActionExecutor connection, ConnectionParameters parameters) {
        super(parameters);
        this.operationParamsBuilder.setEntryPoint("PhasedBuildActionExecuter API");
        this.phasedBuildAction = phasedBuildAction;
        this.connection = connection;
    }

    @Override
    protected DefaultPhasedBuildActionExecuter getThis() {
        return this;
    }

    @Override
    public BuildActionExecuter<Void> forTasks(String ... tasks) {
        this.operationParamsBuilder.setTasks(tasks != null ? Arrays.asList(tasks) : null);
        return this.getThis();
    }

    @Override
    public BuildActionExecuter<Void> forTasks(Iterable<String> tasks) {
        this.operationParamsBuilder.setTasks(tasks != null ? CollectionUtils.toList(tasks) : null);
        return this.getThis();
    }

    @Override
    public Void run() throws GradleConnectionException, IllegalStateException {
        BlockingResultHandler<Void> handler = new BlockingResultHandler<Void>(Void.class);
        this.run((ResultHandler<? super Void>)handler);
        handler.getResult();
        return null;
    }

    @Override
    public void run(ResultHandler<? super Void> handler) throws IllegalStateException {
        final ConsumerOperationParameters operationParameters = this.getConsumerOperationParameters();
        this.connection.run(new ConsumerAction<Void>(){

            @Override
            public ConsumerOperationParameters getParameters() {
                return operationParameters;
            }

            @Override
            public Void run(ConsumerConnection connection) {
                connection.run(DefaultPhasedBuildActionExecuter.this.phasedBuildAction, operationParameters);
                return null;
            }
        }, new ResultHandlerAdapter<Void>(handler, new ExceptionTransformer(new Transformer<String, Throwable>(){

            public String transform(Throwable throwable) {
                return String.format("Could not run phased build action using %s.", DefaultPhasedBuildActionExecuter.this.connection.getDisplayName());
            }
        })));
    }
}

