/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.serialization.KInput;
import kotlinx.serialization.KOutput;
import kotlinx.serialization.KSerialClassDesc;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationKt;
import kotlinx.serialization.internal.EnumDesc;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\r\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/internal/EnumSerializer;", "T", "", "Lkotlinx/serialization/KSerializer;", "serializableClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "serialClassDesc", "Lkotlinx/serialization/KSerialClassDesc;", "getSerialClassDesc", "()Lkotlinx/serialization/KSerialClassDesc;", "getSerializableClass", "()Lkotlin/reflect/KClass;", "load", "input", "Lkotlinx/serialization/KInput;", "(Lkotlinx/serialization/KInput;)Ljava/lang/Enum;", "save", "", "output", "Lkotlinx/serialization/KOutput;", "obj", "(Lkotlinx/serialization/KOutput;Ljava/lang/Enum;)V", "kotlinx-serialization-runtime"})
public final class EnumSerializer<T extends Enum<T>>
implements KSerializer<T> {
    @NotNull
    private final KSerialClassDesc serialClassDesc;
    @NotNull
    private final KClass<T> serializableClass;

    @Override
    @NotNull
    public KSerialClassDesc getSerialClassDesc() {
        return this.serialClassDesc;
    }

    @Override
    public void save(@NotNull KOutput output, @NotNull T obj) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        output.writeEnumValue(this.serializableClass, obj);
    }

    @Override
    @NotNull
    public T load(@NotNull KInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return input.readEnumValue(this.serializableClass);
    }

    @NotNull
    public final KClass<T> getSerializableClass() {
        return this.serializableClass;
    }

    public EnumSerializer(@NotNull KClass<T> serializableClass) {
        Intrinsics.checkParameterIsNotNull(serializableClass, (String)"serializableClass");
        this.serializableClass = serializableClass;
        this.serialClassDesc = new EnumDesc(SerializationKt.enumClassName(this.serializableClass));
    }

    @Override
    @NotNull
    public T update(@NotNull KInput input, @NotNull T old) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull(old, (String)"old");
        return (T)((Enum)KSerializer.DefaultImpls.update(this, input, old));
    }
}

