/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.NameTransformer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/JvmClassNameTransformer;", "Lorg/jetbrains/kotlin/incremental/storage/NameTransformer;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "()V", "asFqName", "Lorg/jetbrains/kotlin/name/FqName;", "string", "", "asName", "asString", "name", "kotlin-build-common"})
public final class JvmClassNameTransformer
implements NameTransformer<JvmClassName> {
    public static final JvmClassNameTransformer INSTANCE;

    @Override
    @NotNull
    public String asString(@NotNull JvmClassName name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        String string = name.getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "name.internalName");
        return string;
    }

    @Override
    @NotNull
    public JvmClassName asName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        JvmClassName jvmClassName = JvmClassName.byInternalName(string);
        Intrinsics.checkExpressionValueIsNotNull(jvmClassName, "JvmClassName.byInternalName(string)");
        return jvmClassName;
    }

    @Override
    @NotNull
    public FqName asFqName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        FqName fqName2 = this.asName(string).getFqNameForClassNameWithoutDollars();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "asName(string).fqNameForClassNameWithoutDollars");
        return fqName2;
    }

    private JvmClassNameTransformer() {
    }

    static {
        JvmClassNameTransformer jvmClassNameTransformer;
        INSTANCE = jvmClassNameTransformer = new JvmClassNameTransformer();
    }
}

