/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor.ontology;

import com.google.common.base.Optional;
import org.protege.editor.core.Disposable;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.CustomOWLEntityFactory;
import org.protege.editor.owl.model.entity.OWLEntityCreationException;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class OWLEntityIRIRegenerator
implements Disposable {
    private OWLEntityFactory fac;

    public OWLEntityIRIRegenerator(OWLModelManager mngr) {
        this.fac = new CustomOWLEntityFactory(mngr){

            @Override
            protected boolean isFragmentAutoGenerated() {
                return true;
            }
        };
    }

    public IRI generateNewIRI(OWLEntity entity) {
        if (entity.isBuiltIn()) {
            return entity.getIRI();
        }
        IRI base = this.getBaseIRI(entity);
        String id = "";
        OWLEntity newEntity = this.getEntity(entity, id, base);
        return newEntity.getIRI();
    }

    private OWLEntity getEntity(OWLEntity entity, String id, IRI base) {
        try {
            return this.fac.createOWLEntity(entity.getClass(), id, base).getOWLEntity();
        }
        catch (OWLEntityCreationException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    private IRI getBaseIRI(OWLEntity entity) {
        IRI iri;
        int remainderIndex;
        Optional remainder = entity.getIRI().getRemainder();
        if (remainder.isPresent() && (remainderIndex = (iri = entity.getIRI()).toString().lastIndexOf((String)remainder.get())) != -1) {
            return IRI.create((String)iri.toString().substring(0, remainderIndex));
        }
        return entity.getIRI();
    }

    public void dispose() throws Exception {
    }
}

