/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.util.ReferenceFinder;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLEntityDeleter {
    private static Logger logger = LoggerFactory.getLogger(OWLEntityDeleter.class);

    public static void deleteEntities(Collection<? extends OWLEntity> entities, OWLModelManager modelManager) {
        logger.info(LogBanner.start((String)"Deleting entities"));
        logger.info("Generating changes to remove {} entities", (Object)entities.size());
        Stopwatch stopwatch = Stopwatch.createStarted();
        List<OWLOntologyChange> allChanges = OWLEntityDeleter.getChangesToDeleteEntities(entities, modelManager);
        logger.info("Generated {} changes to remove {} entities in {} ms", new Object[]{allChanges.size(), entities.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        modelManager.applyChanges(allChanges);
        logger.info("Applied {} changes in {}", (Object)allChanges.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        logger.info(LogBanner.end());
    }

    private static List<OWLOntologyChange> getChangesToDeleteEntities(Collection<? extends OWLEntity> entities, OWLModelManager modelManager) {
        ArrayList<OWLOntologyChange> allChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntology ontology : modelManager.getOntologies()) {
            List<OWLOntologyChange> changeList = OWLEntityDeleter.getChangesForOntology(entities, ontology);
            allChanges.addAll(changeList);
        }
        return allChanges;
    }

    private static List<OWLOntologyChange> getChangesForOntology(Collection<? extends OWLEntity> entities, OWLOntology ontology) {
        ReferenceFinder referenceFinder = new ReferenceFinder();
        ReferenceFinder.ReferenceSet referenceSet = referenceFinder.getReferenceSet(entities, ontology);
        ArrayList<OWLOntologyChange> changeList = new ArrayList<OWLOntologyChange>(referenceSet.getReferencingAxioms().size() + referenceSet.getReferencingOntologyAnnotations().size());
        for (OWLAxiom ax : referenceSet.getReferencingAxioms()) {
            changeList.add((OWLOntologyChange)new RemoveAxiom(referenceSet.getOntology(), ax));
        }
        for (OWLAnnotation annotation : referenceSet.getReferencingOntologyAnnotations()) {
            changeList.add((OWLOntologyChange)new RemoveOntologyAnnotation(referenceSet.getOntology(), annotation));
        }
        return changeList;
    }
}

