/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadIntoCurrentModelAction
extends ProtegeOWLAction {
    private Logger logger = LoggerFactory.getLogger(LoadIntoCurrentModelAction.class);

    public void actionPerformed(ActionEvent e) {
        UIHelper helper = new UIHelper(this.getOWLEditorKit());
        if (helper.showOptionPane("Load ontology?", "This will open an ontology into the current set of ontologies.\nDo you want to continue?", 0, 2) == 0) {
            this.loadOntology();
        }
    }

    private void loadOntology() {
        UIHelper helper = new UIHelper(this.getOWLEditorKit());
        File file = helper.chooseOWLFile("Select an OWL ontology file");
        if (file == null) {
            return;
        }
        try {
            this.getOWLEditorKit().handleLoadFrom(file.toURI());
        }
        catch (Exception e) {
            this.logger.error("An error occurred when loading an ontology from {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    public void dispose() {
    }

    public void initialise() throws Exception {
    }
}

