/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.clsdescriptioneditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.classexpression.OWLExpressionParserException;
import org.protege.editor.owl.ui.clsdescriptioneditor.AutoCompleterMatcher;
import org.protege.editor.owl.ui.clsdescriptioneditor.AutoCompleterMatcherImpl;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAutoCompleter {
    private final Logger logger = LoggerFactory.getLogger(OWLAutoCompleter.class);
    public static final int DEFAULT_MAX_ENTRIES = 100;
    private OWLEditorKit owlEditorKit;
    private JTextComponent textComponent;
    private Set<String> wordDelimeters;
    private AutoCompleterMatcher matcher;
    private JList popupList;
    private JWindow popupWindow;
    public static final int POPUP_WIDTH = 350;
    public static final int POPUP_HEIGHT = 300;
    private OWLExpressionChecker checker;
    private String lastTextUpdate = "*";
    private int maxEntries = 100;
    private KeyListener keyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            OWLAutoCompleter.this.processKeyPressed(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && OWLAutoCompleter.this.popupWindow.isVisible() && !OWLAutoCompleter.this.lastTextUpdate.equals(OWLAutoCompleter.this.textComponent.getText())) {
                OWLAutoCompleter.this.lastTextUpdate = OWLAutoCompleter.this.textComponent.getText();
                OWLAutoCompleter.this.updatePopup(OWLAutoCompleter.this.getMatches());
            }
        }
    };
    private ComponentAdapter componentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent event) {
            OWLAutoCompleter.this.hidePopup();
        }

        @Override
        public void componentResized(ComponentEvent event) {
            OWLAutoCompleter.this.hidePopup();
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            OWLAutoCompleter.this.hidePopup();
        }
    };
    private HierarchyListener hierarchyListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if ((e.getChangeFlags() & 1L) != 0L) {
                OWLAutoCompleter.this.createPopupWindow();
                Container frame = OWLAutoCompleter.this.textComponent.getTopLevelAncestor();
                if (frame != null) {
                    frame.addComponentListener(OWLAutoCompleter.this.componentListener);
                }
            }
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                OWLAutoCompleter.this.completeWithPopupSelection();
            }
        }
    };
    private FocusListener focusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent event) {
            OWLAutoCompleter.this.hidePopup();
        }
    };

    public OWLAutoCompleter(OWLEditorKit owlEditorKit, JTextComponent tc, OWLExpressionChecker checker) {
        this.owlEditorKit = owlEditorKit;
        this.checker = checker;
        this.textComponent = tc;
        this.wordDelimeters = new HashSet<String>();
        this.wordDelimeters.add(" ");
        this.wordDelimeters.add("\n");
        this.wordDelimeters.add("[");
        this.wordDelimeters.add("]");
        this.wordDelimeters.add("{");
        this.wordDelimeters.add("}");
        this.wordDelimeters.add("(");
        this.wordDelimeters.add(")");
        this.wordDelimeters.add(",");
        this.wordDelimeters.add("^");
        this.matcher = new AutoCompleterMatcherImpl(owlEditorKit.getModelManager());
        this.popupList = new JList();
        this.popupList.setAutoscrolls(true);
        this.popupList.setCellRenderer(owlEditorKit.getWorkspace().createOWLCellRenderer());
        this.popupList.addMouseListener(this.mouseListener);
        this.popupList.setRequestFocusEnabled(false);
        this.textComponent.addKeyListener(this.keyListener);
        this.textComponent.addHierarchyListener(this.hierarchyListener);
        this.textComponent.addComponentListener(this.componentListener);
        this.textComponent.addFocusListener(this.focusListener);
        this.createPopupWindow();
    }

    public void cancel() {
        this.hidePopup();
    }

    private void processKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && e.isControlDown()) {
            this.performAutoCompletion();
        } else if (e.getKeyCode() == 9) {
            e.consume();
            this.performAutoCompletion();
        } else if (e.getKeyCode() == 27) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.hidePopup();
            }
        } else if (e.getKeyCode() == 10) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.completeWithPopupSelection();
            }
        } else if (e.getKeyCode() == 40) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.incrementSelection();
            }
        } else if (e.getKeyCode() == 38) {
            if (this.popupWindow.isVisible()) {
                e.consume();
                this.decrementSelection();
            }
        } else if (e.getKeyCode() == 37) {
            this.hidePopup();
        } else if (e.getKeyCode() == 39) {
            this.hidePopup();
        }
    }

    private void completeWithPopupSelection() {
        Object selObject;
        if (this.popupWindow.isVisible() && (selObject = this.popupList.getSelectedValue()) != null) {
            if (selObject instanceof OWLEntity) {
                this.insertWord(this.getInsertText(selObject));
            } else {
                this.insertWord(this.getInsertText(selObject));
            }
            this.hidePopup();
        }
    }

    private List getMatches() {
        int wordIndex = this.getWordIndex();
        try {
            String expression = this.textComponent.getDocument().getText(0, wordIndex);
            expression = expression + "+**";
            try {
                this.checker.check(expression);
            }
            catch (OWLExpressionParserException e) {
                String word = this.getWordToComplete();
                Set<OWLObject> matches = this.matcher.getMatches(word, e.isOWLClassExpected(), e.isOWLObjectPropertyExpected(), e.isOWLDataPropertyExpected(), e.isOWLIndividualExpected(), e.isDatatypeExpected(), e.isAnnotationPropertyExpected());
                ArrayList<String> kwMatches = new ArrayList<String>(matches.size() + 10);
                for (String s : e.getExpectedKeyWords()) {
                    if (!s.toLowerCase().startsWith(word.toLowerCase())) continue;
                    kwMatches.add(s);
                }
                kwMatches.addAll(matches);
                return kwMatches;
            }
        }
        catch (BadLocationException e) {
            this.logger.error("A BadLocationException was thrown whilst retrieving matches for the auto-completer.\nWord index: {}\nCurrent text: {}\n", new Object[]{wordIndex, this.textComponent.getText(), e});
        }
        return Collections.emptyList();
    }

    private void createPopupWindow() {
        JScrollPane sp = ComponentFactory.createScrollPane((JComponent)this.popupList);
        this.popupWindow = new JWindow((Window)SwingUtilities.getAncestorOfClass(Window.class, this.textComponent));
        this.popupWindow.getContentPane().setLayout(new BorderLayout());
        this.popupWindow.getContentPane().add((Component)sp, "Center");
        this.popupWindow.setFocusableWindowState(false);
    }

    private void performAutoCompletion() {
        List matches = this.getMatches();
        if (matches.size() == 1) {
            this.insertWord(this.getInsertText(matches.iterator().next()));
        } else if (matches.size() > 1) {
            this.lastTextUpdate = this.textComponent.getText();
            this.displayAndUpdatePopup(matches);
        }
    }

    private void displayAndUpdatePopup(List matches) {
        this.showPopup();
        this.updatePopup(matches);
    }

    private void insertWord(String word) {
        try {
            int selStart = this.textComponent.getSelectionStart();
            int selEnd = this.textComponent.getSelectionEnd();
            int selLen = selEnd - selStart;
            if (selLen > 0) {
                this.textComponent.getDocument().remove(selStart, selLen);
            }
            int index = this.getWordIndex();
            int caretIndex = this.textComponent.getCaretPosition();
            if (caretIndex > 0 && caretIndex > index) {
                this.textComponent.getDocument().remove(index, caretIndex - index);
            }
            this.textComponent.getDocument().insertString(index, word, null);
        }
        catch (BadLocationException e) {
            this.logger.error("A BadLocationException was thrown when the auto-completer was attempting to insert a word.\n", (Throwable)e);
        }
    }

    private void showPopup() {
        if (this.popupWindow == null) {
            this.createPopupWindow();
        }
        if (!this.popupWindow.isVisible()) {
            this.popupWindow.setSize(350, 300);
            try {
                int wordIndex = this.getWordIndex();
                Point p = new Point(0, 0);
                if (wordIndex > 0) {
                    p = this.textComponent.modelToView(wordIndex).getLocation();
                }
                SwingUtilities.convertPointToScreen(p, this.textComponent);
                p.y += this.textComponent.getFontMetrics(this.textComponent.getFont()).getHeight();
                this.popupWindow.setLocation(p);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.popupWindow.setVisible(true);
        }
    }

    private void hidePopup() {
        this.popupWindow.setVisible(false);
        this.popupList.setListData(new Object[0]);
    }

    private void updatePopup(List matches) {
        int count = matches.size();
        if (count > this.maxEntries) {
            count = this.maxEntries;
        }
        if (!matches.isEmpty()) {
            this.popupList.setListData(matches.subList(0, count).toArray());
        } else {
            this.popupList.setListData(matches.toArray());
        }
        this.popupList.setSelectedIndex(0);
        this.popupWindow.setSize(350, 300);
    }

    private void incrementSelection() {
        if (this.popupList.getModel().getSize() > 0) {
            int selIndex = this.popupList.getSelectedIndex();
            if (++selIndex > this.popupList.getModel().getSize() - 1) {
                selIndex = 0;
            }
            this.popupList.setSelectedIndex(selIndex);
            this.popupList.scrollRectToVisible(this.popupList.getCellBounds(selIndex, selIndex));
        }
    }

    private void decrementSelection() {
        if (this.popupList.getModel().getSize() > 0) {
            int selIndex = this.popupList.getSelectedIndex();
            if (--selIndex < 0) {
                selIndex = this.popupList.getModel().getSize() - 1;
            }
            this.popupList.setSelectedIndex(selIndex);
            this.popupList.scrollRectToVisible(this.popupList.getCellBounds(selIndex, selIndex));
        }
    }

    private int getWordIndex() {
        int index = this.getEscapedWordIndex();
        if (index == -1) {
            index = this.getUnbrokenWordIndex();
        }
        return Math.max(0, index);
    }

    private int getEscapedWordIndex() {
        try {
            int escapeStart;
            int caretPos = Math.max(0, this.getEffectiveCaretPosition() - 1);
            String expression = this.textComponent.getDocument().getText(0, caretPos);
            int escapeEnd = -1;
            while ((escapeStart = expression.indexOf("'", escapeEnd + 1)) != -1) {
                escapeEnd = expression.indexOf("'", escapeStart + 1);
                if (escapeEnd != -1) continue;
                return escapeStart;
            }
            return -1;
        }
        catch (BadLocationException e) {
            this.logger.error("A BadLocationException was thrown when the auto-completer was determining whether or not the caret is in an escaped name", (Throwable)e);
            return -1;
        }
    }

    private int getUnbrokenWordIndex() {
        try {
            int caretPos = Math.max(0, this.getEffectiveCaretPosition() - 1);
            if (caretPos > 0) {
                for (int index = caretPos; index > -1; --index) {
                    if (this.wordDelimeters.contains(this.textComponent.getDocument().getText(index, 1))) {
                        return index + 1;
                    }
                    if (index != 0) continue;
                    return 0;
                }
            }
        }
        catch (BadLocationException e) {
            this.logger.error("A BadLocationException exception was thrown when the auto-complete was retrieving an unbroken word index.", (Throwable)e);
        }
        return -1;
    }

    private String getInsertText(Object o) {
        if (o instanceof OWLObject) {
            OWLModelManager mngr = this.owlEditorKit.getModelManager();
            return mngr.getRendering((OWLObject)o);
        }
        return o.toString();
    }

    private String getWordToComplete() {
        try {
            int index = this.getWordIndex();
            int caretIndex = this.getEffectiveCaretPosition();
            return this.textComponent.getDocument().getText(index, caretIndex - index);
        }
        catch (BadLocationException e) {
            this.logger.error("A BadLocationException was thrown when the auto-completer was retrieving the word to complete.", (Throwable)e);
            return "";
        }
    }

    private int getEffectiveCaretPosition() {
        int startSel = this.textComponent.getSelectionStart();
        if (startSel >= 0) {
            return startSel;
        }
        return this.textComponent.getCaretPosition();
    }

    public void uninstall() {
        this.hidePopup();
        this.textComponent.removeKeyListener(this.keyListener);
        this.textComponent.removeComponentListener(this.componentListener);
        this.textComponent.removeFocusListener(this.focusListener);
        this.textComponent.removeHierarchyListener(this.hierarchyListener);
    }
}

