/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLIndividualSelectorPanel;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

public class OWLIndividualSetEditor
extends AbstractOWLObjectEditor<Set<OWLNamedIndividual>>
implements VerifiedInputEditor {
    private OWLIndividualSelectorPanel panel;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private InputVerificationStatusChangedListener inputListener = newState -> this.handleVerifyEditorContents();

    public OWLIndividualSetEditor(OWLEditorKit owlEditorKit) {
        this.panel = new OWLIndividualSelectorPanel(owlEditorKit, 2);
        this.panel.addStatusChangedListener(this.inputListener);
    }

    @Override
    @Nullable
    public Set<OWLNamedIndividual> getEditedObject() {
        return this.panel.getSelectedObjects();
    }

    @Override
    public boolean setEditedObject(Set<OWLNamedIndividual> individuals) {
        this.panel.setSelection((Set<OWLNamedIndividual>)(individuals != null ? individuals : Collections.emptySet()));
        return true;
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Set of named Individuals";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkSet(object, OWLNamedIndividual.class);
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.panel;
    }

    private void handleVerifyEditorContents() {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(true);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        l.verifiedStatusChanged(true);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void dispose() {
        this.panel.dispose();
    }
}

