/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.Dimension;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionChecker;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class OWLPropertySetEditor
extends AbstractOWLObjectEditor<Set<OWLPropertyExpression>>
implements VerifiedInputEditor {
    private ExpressionEditor<Set<OWLPropertyExpression>> editor;

    public OWLPropertySetEditor(OWLEditorKit eKit) {
        OWLExpressionChecker<Set<OWLPropertyExpression>> checker = eKit.getModelManager().getOWLExpressionCheckerFactory().getPropertySetChecker();
        this.editor = new ExpressionEditor<Set<OWLPropertyExpression>>(eKit, checker);
        this.editor.setPreferredSize(new Dimension(300, 200));
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Set of properties";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkSet(object, OWLPropertyExpression.class);
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.editor;
    }

    @Override
    @Nullable
    public Set<OWLPropertyExpression> getEditedObject() {
        try {
            return this.editor.createObject();
        }
        catch (OWLException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean setEditedObject(Set<OWLPropertyExpression> editedObject) {
        this.editor.setExpressionObject(editedObject);
        return true;
    }

    @Override
    public void dispose() {
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.addStatusChangedListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.removeStatusChangedListener(listener);
    }
}

